/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.log.Log;
import io.questdb.mp.WorkerPool;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.std.str.Path;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public interface WorkerPoolAwareConfiguration
extends WorkerPoolConfiguration {
    public static final WorkerPoolAwareConfiguration USE_SHARED_CONFIGURATION;

    public static WorkerPool configureWorkerPool(WorkerPoolAwareConfiguration configuration, WorkerPool sharedPool, Metrics metrics) {
        return configuration.getWorkerCount() > 0 ? new WorkerPool(configuration, metrics) : sharedPool;
    }

    @Nullable
    public static <T extends Closeable, C extends WorkerPoolAwareConfiguration> T create(C configuration, WorkerPool sharedWorkerPool, Log log, CairoEngine cairoEngine, ServerFactory<T, C> factory, FunctionFactoryCache functionFactoryCache, DatabaseSnapshotAgent snapshotAgent, Metrics metrics) {
        if (configuration.isEnabled()) {
            WorkerPool localPool = WorkerPoolAwareConfiguration.configureWorkerPool(configuration, sharedWorkerPool, metrics);
            if (!2.$assertionsDisabled && localPool == null) {
                throw new AssertionError();
            }
            boolean local = localPool != sharedWorkerPool;
            int sharedWorkerCount = sharedWorkerPool == null ? localPool.getWorkerCount() : sharedWorkerPool.getWorkerCount();
            T server = factory.create(configuration, cairoEngine, localPool, local, sharedWorkerCount, functionFactoryCache, snapshotAgent, metrics);
            if (local) {
                localPool.assignCleaner(Path.CLEANER);
                localPool.start(log);
            }
            return server;
        }
        return null;
    }

    default public boolean isEnabled() {
        return true;
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        USE_SHARED_CONFIGURATION = new WorkerPoolAwareConfiguration(){

            @Override
            public int[] getWorkerAffinity() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getWorkerCount() {
                return 0;
            }

            @Override
            public boolean haltOnError() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @FunctionalInterface
    public static interface ServerFactory<T extends Closeable, C> {
        public T create(C var1, CairoEngine var2, WorkerPool var3, boolean var4, int var5, @Nullable FunctionFactoryCache var6, @Nullable DatabaseSnapshotAgent var7, Metrics var8);
    }
}

