/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BuildInformation;
import io.questdb.PropertyKey;
import io.questdb.ServerConfiguration;
import io.questdb.ServerConfigurationException;
import io.questdb.TelemetryConfiguration;
import io.questdb.WorkerPoolAwareConfiguration;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpMinServerConfiguration;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.WaitProcessorConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.line.LineProtoHourTimestampAdapter;
import io.questdb.cutlass.line.LineProtoMicroTimestampAdapter;
import io.questdb.cutlass.line.LineProtoMilliTimestampAdapter;
import io.questdb.cutlass.line.LineProtoMinuteTimestampAdapter;
import io.questdb.cutlass.line.LineProtoNanoTimestampAdapter;
import io.questdb.cutlass.line.LineProtoSecondTimestampAdapter;
import io.questdb.cutlass.line.LineProtoTimestampAdapter;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.types.InputFormatConfiguration;
import io.questdb.log.Log;
import io.questdb.metrics.MetricsConfiguration;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.network.EpollFacade;
import io.questdb.network.EpollFacadeImpl;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.Net;
import io.questdb.network.NetworkError;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.network.SelectFacade;
import io.questdb.network.SelectFacadeImpl;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import io.questdb.std.StationaryMillisClock;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.DateLocaleFactory;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.microtime.TimestampFormatCompiler;
import io.questdb.std.datetime.microtime.TimestampFormatFactory;
import io.questdb.std.datetime.millitime.DateFormatFactory;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.datetime.millitime.MillisecondClockImpl;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class PropServerConfiguration
implements ServerConfiguration {
    public static final String CONFIG_DIRECTORY = "conf";
    public static final String DB_DIRECTORY = "db";
    public static final String SNAPSHOT_DIRECTORY = "snapshot";
    public static final long COMMIT_INTERVAL_DEFAULT = 2000L;
    private static final LowerCaseCharSequenceIntHashMap WRITE_FO_OPTS = new LowerCaseCharSequenceIntHashMap();
    private static final Map<String, String> OBSOLETE_SETTINGS = new HashMap<String, String>();
    private static final Map<PropertyKey, String> DEPRECATED_SETTINGS = new HashMap<PropertyKey, String>();
    private final IODispatcherConfiguration httpIODispatcherConfiguration = new PropHttpIODispatcherConfiguration();
    private final WaitProcessorConfiguration httpWaitProcessorConfiguration = new PropWaitProcessorConfiguration();
    private final StaticContentProcessorConfiguration staticContentProcessorConfiguration = new PropStaticContentProcessorConfiguration();
    private final HttpServerConfiguration httpServerConfiguration = new PropHttpServerConfiguration();
    private final TextConfiguration textConfiguration = new PropTextConfiguration();
    private final CairoConfiguration cairoConfiguration = new PropCairoConfiguration();
    private final LineUdpReceiverConfiguration lineUdpReceiverConfiguration = new PropLineUdpReceiverConfiguration();
    private final JsonQueryProcessorConfiguration jsonQueryProcessorConfiguration = new PropJsonQueryProcessorConfiguration();
    private final TelemetryConfiguration telemetryConfiguration = new PropTelemetryConfiguration();
    private final int commitMode;
    private final boolean httpServerEnabled;
    private final int createAsSelectRetryCount;
    private final CharSequence defaultMapType;
    private final boolean defaultSymbolCacheFlag;
    private final int defaultSymbolCapacity;
    private final int fileOperationRetryCount;
    private final long idleCheckInterval;
    private final long inactiveReaderTTL;
    private final long inactiveWriterTTL;
    private final int indexValueBlockSize;
    private final int maxSwapFileCount;
    private final int mkdirMode;
    private final int parallelIndexThreshold;
    private final int readerPoolMaxSegments;
    private final long spinLockTimeout;
    private final boolean httpSqlCacheEnabled;
    private final int httpSqlCacheBlockCount;
    private final int httpSqlCacheRowCount;
    private final int rndFunctionMemoryPageSize;
    private final int rndFunctionMemoryMaxPages;
    private final int sqlCharacterStoreCapacity;
    private final int sqlCharacterStoreSequencePoolCapacity;
    private final int sqlColumnPoolCapacity;
    private final int sqlCopyModelPoolCapacity;
    private final double sqlCompactMapLoadFactor;
    private final int sqlExpressionPoolCapacity;
    private final double sqlFastMapLoadFactor;
    private final int sqlJoinContextPoolCapacity;
    private final int sqlLexerPoolCapacity;
    private final int sqlMapKeyCapacity;
    private final int sqlSmallMapKeyCapacity;
    private final int sqlMapPageSize;
    private final int sqlMapMaxPages;
    private final int sqlMapMaxResizes;
    private final int sqlModelPoolCapacity;
    private final int sqlMaxNegativeLimit;
    private final long sqlSortKeyPageSize;
    private final int sqlSortKeyMaxPages;
    private final long sqlSortLightValuePageSize;
    private final int sqlSortLightValueMaxPages;
    private final int sqlHashJoinValuePageSize;
    private final int sqlHashJoinValueMaxPages;
    private final long sqlLatestByRowCount;
    private final int sqlHashJoinLightValuePageSize;
    private final int sqlHashJoinLightValueMaxPages;
    private final int sqlSortValuePageSize;
    private final int sqlSortValueMaxPages;
    private final long workStealTimeoutNanos;
    private final boolean parallelIndexingEnabled;
    private final int sqlJoinMetadataPageSize;
    private final int sqlJoinMetadataMaxResizes;
    private final int lineUdpCommitRate;
    private final int lineUdpGroupIPv4Address;
    private final int lineUdpMsgBufferSize;
    private final int lineUdpMsgCount;
    private final int lineUdpReceiveBufferSize;
    private final int lineUdpCommitMode;
    private final int[] sharedWorkerAffinity;
    private final int sharedWorkerCount;
    private final boolean sharedWorkerHaltOnError;
    private final long sharedWorkerYieldThreshold;
    private final long sharedWorkerSleepThreshold;
    private final long sharedWorkerSleepTimeout;
    private final WorkerPoolConfiguration workerPoolConfiguration = new PropWorkerPoolConfiguration();
    private final PGWireConfiguration pgWireConfiguration = new PropPGWireConfiguration();
    private final InputFormatConfiguration inputFormatConfiguration;
    private final LineProtoTimestampAdapter lineUdpTimestampAdapter;
    private final String cairoSqlCopyRoot;
    private final String cairoSqlCopyWorkRoot;
    private final boolean lineUdpEnabled;
    private final int lineUdpOwnThreadAffinity;
    private final boolean lineUdpUnicast;
    private final boolean lineUdpOwnThread;
    private final int sqlCopyBufferSize;
    private final long writerDataAppendPageSize;
    private final long writerMiscAppendPageSize;
    private final int sqlAnalyticColumnPoolCapacity;
    private final int sqlCreateTableModelPoolCapacity;
    private final int sqlColumnCastModelPoolCapacity;
    private final int sqlRenameTableModelPoolCapacity;
    private final int sqlWithClauseModelPoolCapacity;
    private final int sqlInsertModelPoolCapacity;
    private final int sqlGroupByPoolCapacity;
    private final int sqlGroupByMapCapacity;
    private final int sqlMaxSymbolNotEqualsCount;
    private final int sqlBindVariablePoolSize;
    private final int sqlPageFrameMinRows;
    private final int sqlPageFrameMaxRows;
    private final int sqlJitMode;
    private final int sqlJitIRMemoryPageSize;
    private final int sqlJitIRMemoryMaxPages;
    private final int sqlJitBindVarsMemoryPageSize;
    private final int sqlJitBindVarsMemoryMaxPages;
    private final int sqlJitRowsThreshold;
    private final int sqlJitPageAddressCacheThreshold;
    private final boolean sqlJitDebugEnabled;
    private final DateLocale locale;
    private final String backupRoot;
    private final DateFormat backupDirTimestampFormat;
    private final CharSequence backupTempDirName;
    private final int backupMkdirMode;
    private final int sqlFloatToStrCastScale;
    private final int sqlDoubleToStrCastScale;
    private final PropPGWireDispatcherConfiguration propPGWireDispatcherConfiguration = new PropPGWireDispatcherConfiguration();
    private final boolean pgEnabled;
    private final boolean telemetryEnabled;
    private final boolean telemetryDisableCompletely;
    private final int telemetryQueueCapacity;
    private final boolean telemetryHideTables;
    private final LineTcpReceiverConfiguration lineTcpReceiverConfiguration = new PropLineTcpReceiverConfiguration();
    private final IODispatcherConfiguration lineTcpReceiverDispatcherConfiguration = new PropLineTcpReceiverIODispatcherConfiguration();
    private final boolean lineTcpEnabled;
    private final WorkerPoolAwareConfiguration lineTcpWriterWorkerPoolConfiguration = new PropLineTcpWriterWorkerPoolConfiguration();
    private final WorkerPoolAwareConfiguration lineTcpIOWorkerPoolConfiguration = new PropLineTcpIOWorkerPoolConfiguration();
    private final Log log;
    private final PropHttpMinServerConfiguration httpMinServerConfiguration = new PropHttpMinServerConfiguration();
    private final PropHttpContextConfiguration httpContextConfiguration = new PropHttpContextConfiguration();
    private final boolean httpMinServerEnabled;
    private final PropHttpMinIODispatcherConfiguration httpMinIODispatcherConfiguration = new PropHttpMinIODispatcherConfiguration();
    private final PropSqlExecutionCircuitBreakerConfiguration circuitBreakerConfiguration = new PropSqlExecutionCircuitBreakerConfiguration();
    private final int sqlAnalyticStorePageSize;
    private final int sqlAnalyticStoreMaxPages;
    private final int sqlAnalyticRowIdPageSize;
    private final int sqlAnalyticRowIdMaxPages;
    private final int sqlAnalyticTreeKeyPageSize;
    private final int sqlAnalyticTreeKeyMaxPages;
    private final String root;
    private final String dbDirectory;
    private final String confRoot;
    private final String snapshotRoot;
    private final String snapshotInstanceId;
    private final boolean snapshotRecoveryEnabled;
    private final long maxRerunWaitCapMs;
    private final double rerunExponentialWaitMultiplier;
    private final int rerunInitialWaitQueueSize;
    private final int rerunMaxProcessingQueueSize;
    private final BuildInformation buildInformation;
    private final int columnIndexerQueueCapacity;
    private final int vectorAggregateQueueCapacity;
    private final int o3CallbackQueueCapacity;
    private final int o3PartitionQueueCapacity;
    private final int o3OpenColumnQueueCapacity;
    private final int o3CopyQueueCapacity;
    private final int o3UpdPartitionSizeQueueCapacity;
    private final int o3PurgeDiscoveryQueueCapacity;
    private final int o3ColumnMemorySize;
    private final int maxUncommittedRows;
    private final long commitLag;
    private final long instanceHashLo;
    private final long instanceHashHi;
    private final int sqlTxnScoreboardEntryCount;
    private final boolean o3QuickSortEnabled;
    private final MetricsConfiguration metricsConfiguration = new PropMetricsConfiguration();
    private final boolean metricsEnabled;
    private final int sqlDistinctTimestampKeyCapacity;
    private final double sqlDistinctTimestampLoadFactor;
    private final int circuitBreakerThrottle;
    private final int circuitBreakerBufferSize;
    private final long circuitBreakerTimeout;
    private final int latestByQueueCapacity;
    private final int sampleByIndexSearchPageSize;
    private final int binaryEncodingMaxLength;
    private final long writerDataIndexKeyAppendPageSize;
    private final long writerDataIndexValueAppendPageSize;
    private final long writerAsyncCommandBusyWaitTimeout;
    private final int writerAsyncCommandQueueCapacity;
    private final long writerAsyncCommandQueueSlotSize;
    private final int writerTickRowsCountMod;
    private final long writerAsyncCommandMaxWaitTimeout;
    private final int o3PartitionPurgeListCapacity;
    private final int cairoPageFrameReduceQueueCapacity;
    private final int cairoPageFrameReduceRowIdListCapacity;
    private final int cairoPageFrameReduceColumnListCapacity;
    private final int cairoPageFrameReduceTaskPoolCapacity;
    private final long writerFileOpenOpts;
    private final int queryCacheEventQueueCapacity;
    private final int columnPurgeQueueCapacity;
    private final long columnPurgeRetryDelayLimit;
    private final double columnPurgeRetryDelayMultiplier;
    private final String systemTableNamePrefix;
    private final long columnPurgeRetryDelay;
    private final boolean sqlParallelFilterEnabled;
    private final boolean sqlParallelFilterPreTouchEnabled;
    private final int cairoPageFrameReduceShardCount;
    private final int replaceFunctionBufferMaxSize;
    private final int cairoSqlCopyQueueCapacity;
    private final int columnPurgeTaskPoolCapacity;
    private final int maxFileNameLength;
    private final boolean ilpAutoCreateNewColumns;
    private final boolean ilpAutoCreateNewTables;
    private final boolean simulateCrashEnabled;
    private final int cairoSqlCopyLogRetentionDays;
    private final boolean ioURingEnabled;
    private final int cairoMaxCrashFiles;
    private final boolean walEnabledDefault;
    private final String cairoAttachPartitionSuffix;
    private final boolean cairoAttachPartitionCopy;
    private int lineUdpDefaultPartitionBy;
    private int httpMinNetConnectionLimit;
    private boolean httpMinNetConnectionHint;
    private boolean httpAllowDeflateBeforeSend;
    private int[] httpWorkerAffinity;
    private int[] httpMinWorkerAffinity;
    private int connectionPoolInitialCapacity;
    private int connectionStringPoolCapacity;
    private int multipartHeaderBufferSize;
    private long multipartIdleSpinCount;
    private int recvBufferSize;
    private int requestHeaderBufferSize;
    private int httpWorkerCount;
    private boolean httpWorkerHaltOnError;
    private long httpWorkerYieldThreshold;
    private long httpWorkerSleepThreshold;
    private long httpWorkerSleepTimeout;
    private boolean httpServerKeepAlive;
    private int sendBufferSize;
    private CharSequence indexFileName;
    private String publicDirectory;
    private int httpNetConnectionLimit;
    private boolean httpNetConnectionHint;
    private long httpNetConnectionTimeout;
    private long httpNetConnectionQueueTimeout;
    private int httpNetConnectionSndBuf;
    private int httpNetConnectionRcvBuf;
    private int dateAdapterPoolCapacity;
    private int jsonCacheLimit;
    private int jsonCacheSize;
    private double maxRequiredDelimiterStdDev;
    private double maxRequiredLineLengthStdDev;
    private int metadataStringPoolCapacity;
    private int rollBufferLimit;
    private int rollBufferSize;
    private int textAnalysisMaxLines;
    private int textLexerStringPoolCapacity;
    private int timestampAdapterPoolCapacity;
    private int utf8SinkSize;
    private MimeTypesCache mimeTypesCache;
    private String keepAliveHeader;
    private int httpNetBindIPv4Address;
    private int httpNetBindPort;
    private int lineUdpBindIPV4Address;
    private int lineUdpPort;
    private int jsonQueryFloatScale;
    private int jsonQueryDoubleScale;
    private int jsonQueryConnectionCheckFrequency;
    private boolean httpFrozenClock;
    private boolean httpReadOnlySecurityContext;
    private long maxHttpQueryResponseRowLimit;
    private boolean interruptOnClosedConnection;
    private long cairoSqlCopyMaxIndexChunkSize;
    private int pgNetConnectionLimit;
    private boolean pgNetConnectionHint;
    private int pgNetBindIPv4Address;
    private int pgNetBindPort;
    private long pgNetIdleConnectionTimeout;
    private long pgNetConnectionQueueTimeout;
    private int pgNetConnectionRcvBuf;
    private int pgNetConnectionSndBuf;
    private int pgCharacterStoreCapacity;
    private int pgBinaryParamsCapacity;
    private int pgCharacterStorePoolCapacity;
    private int pgConnectionPoolInitialCapacity;
    private String pgPassword;
    private String pgUsername;
    private boolean pgReadOnlySecurityContext;
    private int pgMaxBlobSizeOnQuery;
    private int pgRecvBufferSize;
    private int pgSendBufferSize;
    private DateLocale pgDefaultLocale;
    private int[] pgWorkerAffinity;
    private int pgWorkerCount;
    private boolean pgHaltOnError;
    private long pgWorkerYieldThreshold;
    private long pgWorkerSleepThreshold;
    private boolean pgDaemonPool;
    private boolean pgSelectCacheEnabled;
    private int pgSelectCacheBlockCount;
    private int pgSelectCacheRowCount;
    private boolean pgInsertCacheEnabled;
    private int pgInsertCacheBlockCount;
    private int pgInsertCacheRowCount;
    private int pgInsertPoolCapacity;
    private boolean pgUpdateCacheEnabled;
    private int pgUpdateCacheBlockCount;
    private int pgUpdateCacheRowCount;
    private int pgNamedStatementCacheCapacity;
    private int pgNamesStatementPoolCapacity;
    private int pgPendingWritersCacheCapacity;
    private int lineTcpNetConnectionLimit;
    private boolean lineTcpNetConnectionHint;
    private int lineTcpNetBindIPv4Address;
    private int lineTcpNetBindPort;
    private long lineTcpNetConnectionTimeout;
    private long lineTcpNetConnectionQueueTimeout;
    private int lineTcpNetConnectionRcvBuf;
    private int lineTcpConnectionPoolInitialCapacity;
    private LineProtoTimestampAdapter lineTcpTimestampAdapter;
    private int lineTcpMsgBufferSize;
    private int lineTcpMaxMeasurementSize;
    private int lineTcpWriterQueueCapacity;
    private int lineTcpWriterWorkerCount;
    private int[] lineTcpWriterWorkerAffinity;
    private boolean lineTcpWriterWorkerPoolHaltOnError;
    private long lineTcpWriterWorkerYieldThreshold;
    private long lineTcpWriterWorkerSleepThreshold;
    private int lineTcpIOWorkerCount;
    private int[] lineTcpIOWorkerAffinity;
    private boolean lineTcpIOWorkerPoolHaltOnError;
    private long lineTcpIOWorkerYieldThreshold;
    private long lineTcpIOWorkerSleepThreshold;
    private long lineTcpMaintenanceInterval;
    private double lineTcpCommitIntervalFraction;
    private long lineTcpCommitIntervalDefault;
    private String lineTcpAuthDbPath;
    private int lineTcpDefaultPartitionBy;
    private long minIdleMsBeforeWriterRelease;
    private boolean lineTcpDisconnectOnError;
    private String httpVersion;
    private int httpMinWorkerCount;
    private boolean httpMinWorkerHaltOnError;
    private long httpMinWorkerYieldThreshold;
    private long httpMinWorkerSleepThreshold;
    private int httpMinBindIPv4Address;
    private int httpMinBindPort;
    private long httpMinNetConnectionTimeout;
    private long httpMinNetConnectionQueueTimeout;
    private int httpMinNetConnectionRcvBuf;
    private int httpMinNetConnectionSndBuf;
    private long symbolCacheWaitUsBeforeReload;
    private boolean stringToCharCastAllowed;
    private boolean symbolAsFieldSupported;
    private boolean isStringAsTagSupported;
    private short floatDefaultColumnType;
    private short integerDefaultColumnType;

    public PropServerConfiguration(String root, Properties properties, @Nullable Map<String, String> env, Log log, BuildInformation buildInformation) throws ServerConfigurationException, JsonException {
        this.log = log;
        boolean configValidationStrict = this.getBoolean(properties, env, PropertyKey.CONFIG_VALIDATION_STRICT, false);
        this.validateProperties(properties, configValidationStrict);
        this.mkdirMode = this.getInt(properties, env, PropertyKey.CAIRO_MKDIR_MODE, 509);
        this.maxFileNameLength = this.getInt(properties, env, PropertyKey.CAIRO_MAX_FILE_NAME_LENGTH, 127);
        this.walEnabledDefault = this.getBoolean(properties, env, PropertyKey.CAIRO_WAL_ENABLED_DEFAULT, false);
        this.dbDirectory = this.getString(properties, env, PropertyKey.CAIRO_ROOT, DB_DIRECTORY);
        if (new File(this.dbDirectory).isAbsolute()) {
            this.root = this.dbDirectory;
            this.confRoot = PropServerConfiguration.rootSubdir(this.root, CONFIG_DIRECTORY);
            this.snapshotRoot = PropServerConfiguration.rootSubdir(this.root, SNAPSHOT_DIRECTORY);
        } else {
            this.root = new File(root, this.dbDirectory).getAbsolutePath();
            this.confRoot = new File(root, CONFIG_DIRECTORY).getAbsolutePath();
            this.snapshotRoot = new File(root, SNAPSHOT_DIRECTORY).getAbsolutePath();
        }
        this.cairoAttachPartitionSuffix = this.getString(properties, env, PropertyKey.CAIRO_ATTACH_PARTITION_SUFFIX, ".attachable");
        this.cairoAttachPartitionCopy = this.getBoolean(properties, env, PropertyKey.CAIRO_ATTACH_PARTITION_COPY, false);
        this.snapshotInstanceId = this.getString(properties, env, PropertyKey.CAIRO_SNAPSHOT_INSTANCE_ID, "");
        this.snapshotRecoveryEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SNAPSHOT_RECOVERY_ENABLED, true);
        this.simulateCrashEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SIMULATE_CRASH_ENABLED, false);
        int cpuAvailable = Runtime.getRuntime().availableProcessors();
        int cpuUsed = 0;
        int cpuSpare = 0;
        if (cpuAvailable > 16) {
            cpuSpare = 2;
        } else if (cpuAvailable > 8) {
            cpuSpare = 1;
        }
        FilesFacade ff = this.cairoConfiguration.getFilesFacade();
        try (Path path = new Path();){
            String[] opts;
            Rnd rnd;
            ff.mkdirs(path.of(this.root).slash$(), this.mkdirMode);
            path.of(this.root).concat("_tab_index.d").$();
            long tableIndexFd = TableUtils.openFileRWOrFail(ff, path, 0L);
            long fileSize = ff.length(tableIndexFd);
            if (fileSize < 8L && !ff.allocate(tableIndexFd, Files.PAGE_SIZE)) {
                ff.close(tableIndexFd);
                throw CairoException.critical(ff.errno()).put("Could not allocate [file=").put(path).put(", actual=").put(fileSize).put(", desired=").put(Files.PAGE_SIZE).put(']');
            }
            long tableIndexMem = TableUtils.mapRWOrClose(ff, tableIndexFd, Files.PAGE_SIZE, 0);
            if (Os.compareAndSwap(tableIndexMem + 8L, 0L, (rnd = new Rnd(this.getCairoConfiguration().getMicrosecondClock().getTicks(), this.getCairoConfiguration().getMillisecondClock().getTicks())).nextLong()) == 0L) {
                Unsafe.getUnsafe().putLong(tableIndexMem + 16L, rnd.nextLong());
            }
            this.instanceHashLo = Unsafe.getUnsafe().getLong(tableIndexMem + 8L);
            this.instanceHashHi = Unsafe.getUnsafe().getLong(tableIndexMem + 16L);
            ff.munmap(tableIndexMem, Files.PAGE_SIZE, 0);
            ff.close(tableIndexFd);
            this.httpMinServerEnabled = this.getBoolean(properties, env, PropertyKey.HTTP_MIN_ENABLED, true);
            if (this.httpMinServerEnabled) {
                this.httpMinWorkerHaltOnError = this.getBoolean(properties, env, PropertyKey.HTTP_MIN_WORKER_HALT_ON_ERROR, false);
                this.httpMinWorkerCount = this.getInt(properties, env, PropertyKey.HTTP_MIN_WORKER_COUNT, cpuAvailable > 16 ? 1 : 0);
                cpuUsed += this.httpMinWorkerCount;
                this.httpMinWorkerAffinity = this.getAffinity(properties, env, PropertyKey.HTTP_MIN_WORKER_AFFINITY, this.httpMinWorkerCount);
                this.httpMinWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.HTTP_MIN_WORKER_YIELD_THRESHOLD, 10L);
                this.httpMinWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.HTTP_MIN_WORKER_SLEEP_THRESHOLD, 10000L);
                String httpMinBindTo = this.getString(properties, env, PropertyKey.HTTP_MIN_BIND_TO, "0.0.0.0:9003");
                this.parseBindTo(properties, env, PropertyKey.HTTP_MIN_NET_BIND_TO, httpMinBindTo, (a, p) -> {
                    this.httpMinBindIPv4Address = a;
                    this.httpMinBindPort = p;
                });
                this.httpMinNetConnectionLimit = this.getInt(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_LIMIT, 4);
                this.httpMinNetConnectionTimeout = this.getLong(properties, env, PropertyKey.HTTP_MIN_NET_IDLE_CONNECTION_TIMEOUT, 300000L);
                this.httpMinNetConnectionTimeout = this.getLong(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_TIMEOUT, this.httpMinNetConnectionTimeout);
                this.httpMinNetConnectionQueueTimeout = this.getLong(properties, env, PropertyKey.HTTP_MIN_NET_QUEUED_CONNECTION_TIMEOUT, 5000L);
                this.httpMinNetConnectionQueueTimeout = this.getLong(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_QUEUE_TIMEOUT, this.httpMinNetConnectionQueueTimeout);
                this.httpMinNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_NET_SND_BUF_SIZE, 1024);
                this.httpMinNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_SNDBUF, this.httpMinNetConnectionSndBuf);
                this.httpMinNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_RCV_BUF_SIZE, 1024);
                this.httpMinNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_RCVBUF, this.httpMinNetConnectionRcvBuf);
                this.httpMinNetConnectionHint = this.getBoolean(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_HINT, false);
            }
            this.httpServerEnabled = this.getBoolean(properties, env, PropertyKey.HTTP_ENABLED, true);
            if (this.httpServerEnabled) {
                this.connectionPoolInitialCapacity = this.getInt(properties, env, PropertyKey.HTTP_CONNECTION_POOL_INITIAL_CAPACITY, 4);
                this.connectionStringPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_CONNECTION_STRING_POOL_CAPACITY, 128);
                this.multipartHeaderBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_MULTIPART_HEADER_BUFFER_SIZE, 512);
                this.multipartIdleSpinCount = this.getLong(properties, env, PropertyKey.HTTP_MULTIPART_IDLE_SPIN_COUNT, 10000L);
                this.recvBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_RECEIVE_BUFFER_SIZE, 0x100000);
                this.requestHeaderBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_REQUEST_HEADER_BUFFER_SIZE, 64448);
                this.httpWorkerCount = this.getInt(properties, env, PropertyKey.HTTP_WORKER_COUNT, 0);
                cpuUsed += this.httpWorkerCount;
                this.httpWorkerAffinity = this.getAffinity(properties, env, PropertyKey.HTTP_WORKER_AFFINITY, this.httpWorkerCount);
                this.httpWorkerHaltOnError = this.getBoolean(properties, env, PropertyKey.HTTP_WORKER_HALT_ON_ERROR, false);
                this.httpWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.HTTP_WORKER_YIELD_THRESHOLD, 10L);
                this.httpWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.HTTP_WORKER_SLEEP_THRESHOLD, 10000L);
                this.httpWorkerSleepTimeout = this.getLong(properties, env, PropertyKey.HTTP_WORKER_SLEEP_TIMEOUT, 100L);
                this.sendBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_SEND_BUFFER_SIZE, 0x200000);
                this.indexFileName = this.getString(properties, env, PropertyKey.HTTP_STATIC_INDEX_FILE_NAME, "index.html");
                this.httpFrozenClock = this.getBoolean(properties, env, PropertyKey.HTTP_FROZEN_CLOCK, false);
                this.httpAllowDeflateBeforeSend = this.getBoolean(properties, env, PropertyKey.HTTP_ALLOW_DEFLATE_BEFORE_SEND, false);
                this.httpServerKeepAlive = this.getBoolean(properties, env, PropertyKey.HTTP_SERVER_KEEP_ALIVE, true);
                this.httpVersion = this.getString(properties, env, PropertyKey.HTTP_VERSION, "HTTP/1.1");
                if (!this.httpVersion.endsWith(" ")) {
                    this.httpVersion = this.httpVersion + ' ';
                }
                int keepAliveTimeout = this.getInt(properties, env, PropertyKey.HTTP_KEEP_ALIVE_TIMEOUT, 5);
                int keepAliveMax = this.getInt(properties, env, PropertyKey.HTTP_KEEP_ALIVE_MAX, 10000);
                this.keepAliveHeader = keepAliveTimeout > 0 && keepAliveMax > 0 ? "Keep-Alive: timeout=" + keepAliveTimeout + ", max=" + keepAliveMax + "\r\n" : null;
                String publicDirectory = this.getString(properties, env, PropertyKey.HTTP_STATIC_PUBLIC_DIRECTORY, "public");
                this.publicDirectory = new File(publicDirectory).isAbsolute() ? publicDirectory : new File(root, publicDirectory).getAbsolutePath();
                this.httpNetConnectionLimit = this.getInt(properties, env, PropertyKey.HTTP_NET_ACTIVE_CONNECTION_LIMIT, 64);
                this.httpNetConnectionLimit = this.getInt(properties, env, PropertyKey.HTTP_NET_CONNECTION_LIMIT, this.httpNetConnectionLimit);
                this.httpNetConnectionHint = this.getBoolean(properties, env, PropertyKey.HTTP_NET_CONNECTION_HINT, false);
                this.httpNetConnectionTimeout = this.getLong(properties, env, PropertyKey.HTTP_NET_IDLE_CONNECTION_TIMEOUT, 300000L);
                this.httpNetConnectionTimeout = this.getLong(properties, env, PropertyKey.HTTP_NET_CONNECTION_TIMEOUT, this.httpNetConnectionTimeout);
                this.httpNetConnectionQueueTimeout = this.getLong(properties, env, PropertyKey.HTTP_NET_QUEUED_CONNECTION_TIMEOUT, 5000L);
                this.httpNetConnectionQueueTimeout = this.getLong(properties, env, PropertyKey.HTTP_NET_CONNECTION_QUEUE_TIMEOUT, this.httpNetConnectionQueueTimeout);
                this.httpNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_SND_BUF_SIZE, 0x200000);
                this.httpNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_CONNECTION_SNDBUF, this.httpNetConnectionSndBuf);
                this.httpNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_RCV_BUF_SIZE, 0x200000);
                this.httpNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_CONNECTION_RCVBUF, this.httpNetConnectionRcvBuf);
                this.dateAdapterPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_TEXT_DATE_ADAPTER_POOL_CAPACITY, 16);
                this.jsonCacheLimit = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_JSON_CACHE_LIMIT, 16384);
                this.jsonCacheSize = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_JSON_CACHE_SIZE, 8192);
                this.maxRequiredDelimiterStdDev = this.getDouble(properties, env, PropertyKey.HTTP_TEXT_MAX_REQUIRED_DELIMITER_STDDEV, 0.1222);
                this.maxRequiredLineLengthStdDev = this.getDouble(properties, env, PropertyKey.HTTP_TEXT_MAX_REQUIRED_LINE_LENGTH_STDDEV, 0.8);
                this.metadataStringPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_TEXT_METADATA_STRING_POOL_CAPACITY, 128);
                this.rollBufferLimit = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_ROLL_BUFFER_LIMIT, 0x400000);
                this.rollBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_ROLL_BUFFER_SIZE, 1024);
                this.textAnalysisMaxLines = this.getInt(properties, env, PropertyKey.HTTP_TEXT_ANALYSIS_MAX_LINES, 1000);
                this.textLexerStringPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_TEXT_LEXER_STRING_POOL_CAPACITY, 64);
                this.timestampAdapterPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_TEXT_TIMESTAMP_ADAPTER_POOL_CAPACITY, 64);
                this.utf8SinkSize = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_UTF8_SINK_SIZE, 4096);
                this.jsonQueryConnectionCheckFrequency = this.getInt(properties, env, PropertyKey.HTTP_JSON_QUERY_CONNECTION_CHECK_FREQUENCY, 1000000);
                this.jsonQueryFloatScale = this.getInt(properties, env, PropertyKey.HTTP_JSON_QUERY_FLOAT_SCALE, 4);
                this.jsonQueryDoubleScale = this.getInt(properties, env, PropertyKey.HTTP_JSON_QUERY_DOUBLE_SCALE, 12);
                this.httpReadOnlySecurityContext = this.getBoolean(properties, env, PropertyKey.HTTP_SECURITY_READONLY, false);
                this.maxHttpQueryResponseRowLimit = this.getLong(properties, env, PropertyKey.HTTP_SECURITY_MAX_RESPONSE_ROWS, Long.MAX_VALUE);
                this.interruptOnClosedConnection = this.getBoolean(properties, env, PropertyKey.HTTP_SECURITY_INTERRUPT_ON_CLOSED_CONNECTION, true);
                String httpBindTo = this.getString(properties, env, PropertyKey.HTTP_BIND_TO, "0.0.0.0:9000");
                this.parseBindTo(properties, env, PropertyKey.HTTP_NET_BIND_TO, httpBindTo, (a, p) -> {
                    this.httpNetBindIPv4Address = a;
                    this.httpNetBindPort = p;
                });
                path.of(new File(new File(root, CONFIG_DIRECTORY), "mime.types").getAbsolutePath()).$();
                this.mimeTypesCache = new MimeTypesCache(FilesFacadeImpl.INSTANCE, path);
            }
            this.maxRerunWaitCapMs = this.getLong(properties, env, PropertyKey.HTTP_BUSY_RETRY_MAXIMUM_WAIT_BEFORE_RETRY, 1000L);
            this.rerunExponentialWaitMultiplier = this.getDouble(properties, env, PropertyKey.HTTP_BUSY_RETRY_EXPONENTIAL_WAIT_MULTIPLIER, 2.0);
            this.rerunInitialWaitQueueSize = this.getIntSize(properties, env, PropertyKey.HTTP_BUSY_RETRY_INITIAL_WAIT_QUEUE_SIZE, 64);
            this.rerunMaxProcessingQueueSize = this.getIntSize(properties, env, PropertyKey.HTTP_BUSY_RETRY_MAX_PROCESSING_QUEUE_SIZE, 4096);
            this.circuitBreakerThrottle = this.getInt(properties, env, PropertyKey.CIRCUIT_BREAKER_THROTTLE, 2000000);
            this.circuitBreakerBufferSize = this.getInt(properties, env, PropertyKey.CIRCUIT_BREAKER_BUFFER_SIZE, 64);
            this.circuitBreakerTimeout = (long)(this.getDouble(properties, env, PropertyKey.QUERY_TIMEOUT_SEC, 60.0) * 1000.0);
            this.pgEnabled = this.getBoolean(properties, env, PropertyKey.PG_ENABLED, true);
            if (this.pgEnabled) {
                this.pgNetConnectionLimit = this.getInt(properties, env, PropertyKey.PG_NET_ACTIVE_CONNECTION_LIMIT, 64);
                this.pgNetConnectionLimit = this.getInt(properties, env, PropertyKey.PG_NET_CONNECTION_LIMIT, this.pgNetConnectionLimit);
                this.pgNetConnectionHint = this.getBoolean(properties, env, PropertyKey.PG_NET_CONNECTION_HINT, false);
                this.parseBindTo(properties, env, PropertyKey.PG_NET_BIND_TO, "0.0.0.0:8812", (a, p) -> {
                    this.pgNetBindIPv4Address = a;
                    this.pgNetBindPort = p;
                });
                this.pgNetIdleConnectionTimeout = this.getLong(properties, env, PropertyKey.PG_NET_IDLE_TIMEOUT, 300000L);
                this.pgNetIdleConnectionTimeout = this.getLong(properties, env, PropertyKey.PG_NET_CONNECTION_TIMEOUT, this.pgNetIdleConnectionTimeout);
                this.pgNetConnectionQueueTimeout = this.getLong(properties, env, PropertyKey.PG_NET_CONNECTION_QUEUE_TIMEOUT, 300000L);
                this.pgNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.PG_NET_RECV_BUF_SIZE, -1);
                this.pgNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.PG_NET_CONNECTION_RCVBUF, this.pgNetConnectionRcvBuf);
                this.pgNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.PG_NET_SEND_BUF_SIZE, -1);
                this.pgNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.PG_NET_CONNECTION_SNDBUF, this.pgNetConnectionSndBuf);
                this.pgCharacterStoreCapacity = this.getInt(properties, env, PropertyKey.PG_CHARACTER_STORE_CAPACITY, 4096);
                this.pgBinaryParamsCapacity = this.getInt(properties, env, PropertyKey.PG_BINARY_PARAM_COUNT_CAPACITY, 2);
                this.pgCharacterStorePoolCapacity = this.getInt(properties, env, PropertyKey.PG_CHARACTER_STORE_POOL_CAPACITY, 64);
                this.pgConnectionPoolInitialCapacity = this.getInt(properties, env, PropertyKey.PG_CONNECTION_POOL_CAPACITY, 4);
                this.pgPassword = this.getString(properties, env, PropertyKey.PG_PASSWORD, "quest");
                this.pgUsername = this.getString(properties, env, PropertyKey.PG_USER, "admin");
                this.pgReadOnlySecurityContext = this.getBoolean(properties, env, PropertyKey.PG_SECURITY_READONLY, false);
                this.pgMaxBlobSizeOnQuery = this.getIntSize(properties, env, PropertyKey.PG_MAX_BLOB_SIZE_ON_QUERY, 524288);
                this.pgRecvBufferSize = this.getIntSize(properties, env, PropertyKey.PG_RECV_BUFFER_SIZE, 0x100000);
                this.pgSendBufferSize = this.getIntSize(properties, env, PropertyKey.PG_SEND_BUFFER_SIZE, 0x100000);
                String dateLocale = this.getString(properties, env, PropertyKey.PG_DATE_LOCALE, "en");
                this.pgDefaultLocale = DateLocaleFactory.INSTANCE.getLocale(dateLocale);
                if (this.pgDefaultLocale == null) {
                    throw ServerConfigurationException.forInvalidKey(PropertyKey.PG_DATE_LOCALE.getPropertyPath(), dateLocale);
                }
                this.pgWorkerCount = this.getInt(properties, env, PropertyKey.PG_WORKER_COUNT, 0);
                cpuUsed += this.pgWorkerCount;
                this.pgWorkerAffinity = this.getAffinity(properties, env, PropertyKey.PG_WORKER_AFFINITY, this.pgWorkerCount);
                this.pgHaltOnError = this.getBoolean(properties, env, PropertyKey.PG_HALT_ON_ERROR, false);
                this.pgWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.PG_WORKER_YIELD_THRESHOLD, 10L);
                this.pgWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.PG_WORKER_SLEEP_THRESHOLD, 10000L);
                this.pgDaemonPool = this.getBoolean(properties, env, PropertyKey.PG_DAEMON_POOL, true);
                this.pgSelectCacheEnabled = this.getBoolean(properties, env, PropertyKey.PG_SELECT_CACHE_ENABLED, true);
                this.pgSelectCacheBlockCount = this.getInt(properties, env, PropertyKey.PG_SELECT_CACHE_BLOCK_COUNT, 8);
                this.pgSelectCacheRowCount = this.getInt(properties, env, PropertyKey.PG_SELECT_CACHE_ROW_COUNT, 8);
                this.pgInsertCacheEnabled = this.getBoolean(properties, env, PropertyKey.PG_INSERT_CACHE_ENABLED, true);
                this.pgInsertCacheBlockCount = this.getInt(properties, env, PropertyKey.PG_INSERT_CACHE_BLOCK_COUNT, 4);
                this.pgInsertCacheRowCount = this.getInt(properties, env, PropertyKey.PG_INSERT_CACHE_ROW_COUNT, 4);
                this.pgInsertPoolCapacity = this.getInt(properties, env, PropertyKey.PG_INSERT_POOL_CAPACITY, 16);
                this.pgUpdateCacheEnabled = this.getBoolean(properties, env, PropertyKey.PG_UPDATE_CACHE_ENABLED, true);
                this.pgUpdateCacheBlockCount = this.getInt(properties, env, PropertyKey.PG_UPDATE_CACHE_BLOCK_COUNT, 4);
                this.pgUpdateCacheRowCount = this.getInt(properties, env, PropertyKey.PG_UPDATE_CACHE_ROW_COUNT, 4);
                this.pgNamedStatementCacheCapacity = this.getInt(properties, env, PropertyKey.PG_NAMED_STATEMENT_CACHE_CAPACITY, 32);
                this.pgNamesStatementPoolCapacity = this.getInt(properties, env, PropertyKey.PG_NAMED_STATEMENT_POOL_CAPACITY, 32);
                this.pgPendingWritersCacheCapacity = this.getInt(properties, env, PropertyKey.PG_PENDING_WRITERS_CACHE_CAPACITY, 16);
            }
            this.commitMode = this.getCommitMode(properties, env, PropertyKey.CAIRO_COMMIT_MODE);
            this.createAsSelectRetryCount = this.getInt(properties, env, PropertyKey.CAIRO_CREAT_AS_SELECT_RETRY_COUNT, 5);
            this.defaultMapType = this.getString(properties, env, PropertyKey.CAIRO_DEFAULT_MAP_TYPE, "fast");
            this.defaultSymbolCacheFlag = this.getBoolean(properties, env, PropertyKey.CAIRO_DEFAULT_SYMBOL_CACHE_FLAG, true);
            this.defaultSymbolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_DEFAULT_SYMBOL_CAPACITY, 256);
            this.fileOperationRetryCount = this.getInt(properties, env, PropertyKey.CAIRO_FILE_OPERATION_RETRY_COUNT, 30);
            this.idleCheckInterval = this.getLong(properties, env, PropertyKey.CAIRO_IDLE_CHECK_INTERVAL, 300000L);
            this.inactiveReaderTTL = this.getLong(properties, env, PropertyKey.CAIRO_INACTIVE_READER_TTL, 120000L);
            this.inactiveWriterTTL = this.getLong(properties, env, PropertyKey.CAIRO_INACTIVE_WRITER_TTL, 600000L);
            this.indexValueBlockSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_INDEX_VALUE_BLOCK_SIZE, 256));
            this.maxSwapFileCount = this.getInt(properties, env, PropertyKey.CAIRO_MAX_SWAP_FILE_COUNT, 30);
            this.parallelIndexThreshold = this.getInt(properties, env, PropertyKey.CAIRO_PARALLEL_INDEX_THRESHOLD, 100000);
            this.readerPoolMaxSegments = this.getInt(properties, env, PropertyKey.CAIRO_READER_POOL_MAX_SEGMENTS, 5);
            this.spinLockTimeout = this.getLong(properties, env, PropertyKey.CAIRO_SPIN_LOCK_TIMEOUT, 1000L);
            this.httpSqlCacheEnabled = this.getBoolean(properties, env, PropertyKey.HTTP_QUERY_CACHE_ENABLED, true);
            this.httpSqlCacheBlockCount = this.getInt(properties, env, PropertyKey.HTTP_QUERY_CACHE_BLOCK_COUNT, 4);
            this.httpSqlCacheRowCount = this.getInt(properties, env, PropertyKey.HTTP_QUERY_CACHE_ROW_COUNT, 4);
            this.sqlCharacterStoreCapacity = this.getInt(properties, env, PropertyKey.CAIRO_CHARACTER_STORE_CAPACITY, 1024);
            this.sqlCharacterStoreSequencePoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_CHARACTER_STORE_SEQUENCE_POOL_CAPACITY, 64);
            this.sqlColumnPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_COLUMN_POOL_CAPACITY, 4096);
            this.sqlCompactMapLoadFactor = this.getDouble(properties, env, PropertyKey.CAIRO_COMPACT_MAP_LOAD_FACTOR, 0.7);
            this.sqlExpressionPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_EXPRESSION_POOL_CAPACITY, 8192);
            this.sqlFastMapLoadFactor = this.getDouble(properties, env, PropertyKey.CAIRO_FAST_MAP_LOAD_FACTOR, 0.5);
            this.sqlJoinContextPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_JOIN_CONTEXT_POOL_CAPACITY, 64);
            this.sqlLexerPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_LEXER_POOL_CAPACITY, 2048);
            this.sqlMapKeyCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_MAP_KEY_CAPACITY, 0x200000);
            this.sqlSmallMapKeyCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_SMALL_MAP_KEY_CAPACITY, 1024);
            this.sqlMapPageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_MAP_PAGE_SIZE, 0x400000);
            this.sqlMapMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_MAP_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlMapMaxResizes = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_MAP_MAX_RESIZES, Integer.MAX_VALUE);
            this.sqlModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_MODEL_POOL_CAPACITY, 1024);
            this.sqlMaxNegativeLimit = this.getInt(properties, env, PropertyKey.CAIRO_SQL_MAX_NEGATIVE_LIMIT, 10000);
            this.sqlSortKeyPageSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_SORT_KEY_PAGE_SIZE, 0x400000L);
            this.sqlSortKeyMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SORT_KEY_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlSortLightValuePageSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_SORT_LIGHT_VALUE_PAGE_SIZE, 0x800000L);
            this.sqlSortLightValueMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SORT_LIGHT_VALUE_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlHashJoinValuePageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_HASH_JOIN_VALUE_PAGE_SIZE, 0x1000000);
            this.sqlHashJoinValueMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_HASH_JOIN_VALUE_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlLatestByRowCount = this.getInt(properties, env, PropertyKey.CAIRO_SQL_LATEST_BY_ROW_COUNT, 1000);
            this.sqlHashJoinLightValuePageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_HASH_JOIN_LIGHT_VALUE_PAGE_SIZE, 0x100000);
            this.sqlHashJoinLightValueMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_HASH_JOIN_LIGHT_VALUE_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlSortValuePageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SORT_VALUE_PAGE_SIZE, 0x1000000);
            this.sqlSortValueMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SORT_VALUE_MAX_PAGES, Integer.MAX_VALUE);
            this.workStealTimeoutNanos = this.getLong(properties, env, PropertyKey.CAIRO_WORK_STEAL_TIMEOUT_NANOS, 10000L);
            this.parallelIndexingEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_PARALLEL_INDEXING_ENABLED, true);
            this.sqlJoinMetadataPageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JOIN_METADATA_PAGE_SIZE, 16384);
            this.sqlJoinMetadataMaxResizes = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JOIN_METADATA_MAX_RESIZES, Integer.MAX_VALUE);
            this.sqlAnalyticColumnPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_COLUMN_POOL_CAPACITY, 64);
            this.sqlCreateTableModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_CREATE_TABEL_MODEL_POOL_CAPACITY, 16);
            this.sqlColumnCastModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_COLUMN_CAST_MODEL_POOL_CAPACITY, 16);
            this.sqlRenameTableModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_RENAME_TABLE_MODEL_POOL_CAPACITY, 16);
            this.sqlWithClauseModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_WITH_CLAUSE_MODEL_POOL_CAPACITY, 128);
            this.sqlInsertModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_INSERT_MODEL_POOL_CAPACITY, 64);
            this.sqlCopyModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_COPY_MODEL_POOL_CAPACITY, 32);
            this.sqlCopyBufferSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_COPY_BUFFER_SIZE, 0x200000);
            this.columnPurgeQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_QUEUE_CAPACITY, 128);
            this.columnPurgeTaskPoolCapacity = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_TASK_POOL_CAPACITY, 256);
            this.columnPurgeRetryDelayLimit = this.getLong(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_RETRY_DELAY_LIMIT, 60000000L);
            this.columnPurgeRetryDelay = this.getLong(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_RETRY_DELAY, 10000L);
            this.columnPurgeRetryDelayMultiplier = this.getDouble(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_RETRY_DELAY_MULTIPLIER, 10.0);
            this.systemTableNamePrefix = this.getString(properties, env, PropertyKey.CAIRO_SQL_SYSTEM_TABLE_PREFIX, "sys.");
            this.cairoPageFrameReduceQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_PAGE_FRAME_REDUCE_QUEUE_CAPACITY, 64));
            this.cairoPageFrameReduceRowIdListCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_PAGE_FRAME_ROWID_LIST_CAPACITY, 256));
            this.cairoPageFrameReduceColumnListCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_PAGE_FRAME_COLUMN_LIST_CAPACITY, 16));
            this.sqlParallelFilterEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_FILTER_ENABLED, true);
            this.sqlParallelFilterPreTouchEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_FILTER_PRETOUCH_ENABLED, true);
            this.cairoPageFrameReduceShardCount = this.getInt(properties, env, PropertyKey.CAIRO_PAGE_FRAME_SHARD_COUNT, 4);
            this.cairoPageFrameReduceTaskPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_PAGE_FRAME_TASK_POOL_CAPACITY, 4);
            this.writerDataIndexKeyAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_DATA_INDEX_KEY_APPEND_PAGE_SIZE, 524288L));
            this.writerDataIndexValueAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_DATA_INDEX_VALUE_APPEND_PAGE_SIZE, 0x1000000L));
            this.writerDataAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_DATA_APPEND_PAGE_SIZE, 0x1000000L));
            this.writerMiscAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_MISC_APPEND_PAGE_SIZE, Files.PAGE_SIZE));
            this.sampleByIndexSearchPageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SAMPLEBY_PAGE_SIZE, 0);
            this.sqlDoubleToStrCastScale = this.getInt(properties, env, PropertyKey.CAIRO_SQL_DOUBLE_CAST_SCALE, 12);
            this.sqlFloatToStrCastScale = this.getInt(properties, env, PropertyKey.CAIRO_SQL_FLOAT_CAST_SCALE, 4);
            this.sqlGroupByMapCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_GROUPBY_MAP_CAPACITY, 1024);
            this.sqlGroupByPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_GROUPBY_POOL_CAPACITY, 1024);
            this.sqlMaxSymbolNotEqualsCount = this.getInt(properties, env, PropertyKey.CAIRO_SQL_MAX_SYMBOL_NOT_EQUALS_COUNT, 100);
            this.sqlBindVariablePoolSize = this.getInt(properties, env, PropertyKey.CAIRO_SQL_BIND_VARIABLE_POOL_SIZE, 8);
            String sqlCopyFormatsFile = this.getString(properties, env, PropertyKey.CAIRO_SQL_COPY_FORMATS_FILE, "/text_loader.json");
            String dateLocale = this.getString(properties, env, PropertyKey.CAIRO_DATE_LOCALE, "en");
            this.locale = DateLocaleFactory.INSTANCE.getLocale(dateLocale);
            if (this.locale == null) {
                throw ServerConfigurationException.forInvalidKey(PropertyKey.CAIRO_DATE_LOCALE.getPropertyPath(), dateLocale);
            }
            this.sqlDistinctTimestampKeyCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_DISTINCT_TIMESTAMP_KEY_CAPACITY, 512);
            this.sqlDistinctTimestampLoadFactor = this.getDouble(properties, env, PropertyKey.CAIRO_SQL_DISTINCT_TIMESTAMP_LOAD_FACTOR, 0.5);
            this.sqlPageFrameMinRows = this.getInt(properties, env, PropertyKey.CAIRO_SQL_PAGE_FRAME_MIN_ROWS, 1000);
            this.sqlPageFrameMaxRows = this.getInt(properties, env, PropertyKey.CAIRO_SQL_PAGE_FRAME_MAX_ROWS, 1000000);
            this.sqlJitMode = this.getSqlJitMode(properties, env);
            this.sqlJitIRMemoryPageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JIT_IR_MEMORY_PAGE_SIZE, 8192);
            this.sqlJitIRMemoryMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_JIT_IR_MEMORY_MAX_PAGES, 8);
            this.sqlJitBindVarsMemoryPageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JIT_BIND_VARS_MEMORY_PAGE_SIZE, 4096);
            this.sqlJitBindVarsMemoryMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_JIT_BIND_VARS_MEMORY_MAX_PAGES, 8);
            this.sqlJitRowsThreshold = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JIT_ROWS_THRESHOLD, 0x100000);
            this.sqlJitPageAddressCacheThreshold = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JIT_PAGE_ADDRESS_CACHE_THRESHOLD, 0x100000);
            this.sqlJitDebugEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_JIT_DEBUG_ENABLED, false);
            String value = this.getString(properties, env, PropertyKey.CAIRO_WRITER_FO_OPTS, "o_none");
            long lopts = 0L;
            for (String opt : opts = value.split("\\|")) {
                int index = WRITE_FO_OPTS.keyIndex(opt.trim());
                if (index >= 0) continue;
                lopts |= (long)WRITE_FO_OPTS.valueAt(index);
            }
            this.writerFileOpenOpts = lopts;
            this.inputFormatConfiguration = new InputFormatConfiguration(new DateFormatFactory(), DateLocaleFactory.INSTANCE, new TimestampFormatFactory(), this.locale);
            try (JsonLexer lexer = new JsonLexer(1024, 1024);){
                this.inputFormatConfiguration.parseConfiguration(lexer, this.confRoot, sqlCopyFormatsFile);
            }
            this.cairoSqlCopyRoot = this.getString(properties, env, PropertyKey.CAIRO_SQL_COPY_ROOT, null);
            String cairoSqlCopyWorkRoot = this.getString(properties, env, PropertyKey.CAIRO_SQL_COPY_WORK_ROOT, this.cairoSqlCopyRoot);
            this.cairoSqlCopyWorkRoot = cairoSqlCopyWorkRoot != null ? this.getCanonicalPath(cairoSqlCopyWorkRoot) : null;
            if (this.pathEquals(root, this.cairoSqlCopyWorkRoot) || this.pathEquals(this.root, this.cairoSqlCopyWorkRoot) || this.pathEquals(this.confRoot, this.cairoSqlCopyWorkRoot) || this.pathEquals(this.snapshotRoot, this.cairoSqlCopyWorkRoot)) {
                throw new ServerConfigurationException("Configuration value for " + PropertyKey.CAIRO_SQL_COPY_WORK_ROOT.getPropertyPath() + " can't point to root, data, conf or snapshot dirs. ");
            }
            this.cairoSqlCopyMaxIndexChunkSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_COPY_MAX_INDEX_CHUNK_SIZE, 0x6400000L);
            this.cairoSqlCopyMaxIndexChunkSize -= this.cairoSqlCopyMaxIndexChunkSize % 16L;
            if (this.cairoSqlCopyMaxIndexChunkSize < 16L) {
                throw new ServerConfigurationException("invalid configuration value [key=" + PropertyKey.CAIRO_SQL_COPY_MAX_INDEX_CHUNK_SIZE.getPropertyPath() + ", description=max import chunk size can't be smaller than 16]");
            }
            this.cairoSqlCopyQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_SQL_COPY_QUEUE_CAPACITY, 32));
            this.cairoSqlCopyLogRetentionDays = this.getInt(properties, env, PropertyKey.CAIRO_SQL_COPY_LOG_RETENTION_DAYS, 3);
            this.backupRoot = this.getString(properties, env, PropertyKey.CAIRO_SQL_BACKUP_ROOT, null);
            this.backupDirTimestampFormat = this.getTimestampFormat(properties, env);
            this.backupTempDirName = this.getString(properties, env, PropertyKey.CAIRO_SQL_BACKUP_DIR_TMP_NAME, "tmp");
            this.backupMkdirMode = this.getInt(properties, env, PropertyKey.CAIRO_SQL_BACKUP_MKDIR_MODE, 509);
            this.columnIndexerQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_COLUMN_INDEXER_QUEUE_CAPACITY, 64);
            this.vectorAggregateQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_VECTOR_AGGREGATE_QUEUE_CAPACITY, 128);
            this.o3CallbackQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_O3_CALLBACK_QUEUE_CAPACITY, 128);
            this.o3PartitionQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_O3_PARTITION_QUEUE_CAPACITY, 128);
            this.o3OpenColumnQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_O3_OPEN_COLUMN_QUEUE_CAPACITY, 128);
            this.o3CopyQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_O3_COPY_QUEUE_CAPACITY, 128);
            this.o3UpdPartitionSizeQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_O3_UPD_PARTITION_SIZE_QUEUE_CAPACITY, 128));
            this.o3PurgeDiscoveryQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_O3_PURGE_DISCOVERY_QUEUE_CAPACITY, 128));
            this.o3ColumnMemorySize = (int)Files.ceilPageSize(this.getIntSize(properties, env, PropertyKey.CAIRO_O3_COLUMN_MEMORY_SIZE, 0x800000));
            this.maxUncommittedRows = this.getInt(properties, env, PropertyKey.CAIRO_MAX_UNCOMMITTED_ROWS, 500000);
            this.commitLag = this.getLong(properties, env, PropertyKey.CAIRO_COMMIT_LAG, 300000L) * 1000L;
            this.o3QuickSortEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_O3_QUICKSORT_ENABLED, false);
            this.rndFunctionMemoryPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_RND_MEMORY_PAGE_SIZE, 8192));
            this.rndFunctionMemoryMaxPages = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_RND_MEMORY_MAX_PAGES, 128));
            this.replaceFunctionBufferMaxSize = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_REPLACE_BUFFER_MAX_SIZE, 0x100000));
            this.sqlAnalyticStorePageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_STORE_PAGE_SIZE, 0x100000));
            this.sqlAnalyticStoreMaxPages = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_STORE_MAX_PAGES, Integer.MAX_VALUE));
            this.sqlAnalyticRowIdPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_ROWID_PAGE_SIZE, 524288));
            this.sqlAnalyticRowIdMaxPages = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_ROWID_MAX_PAGES, Integer.MAX_VALUE));
            this.sqlAnalyticTreeKeyPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_TREE_PAGE_SIZE, 524288));
            this.sqlAnalyticTreeKeyMaxPages = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_TREE_MAX_PAGES, Integer.MAX_VALUE));
            this.sqlTxnScoreboardEntryCount = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_O3_TXN_SCOREBOARD_ENTRY_COUNT, 16384));
            this.latestByQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_LATESTBY_QUEUE_CAPACITY, 32));
            this.telemetryEnabled = this.getBoolean(properties, env, PropertyKey.TELEMETRY_ENABLED, true);
            this.telemetryDisableCompletely = this.getBoolean(properties, env, PropertyKey.TELEMETRY_DISABLE_COMPLETELY, false);
            this.telemetryQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.TELEMETRY_QUEUE_CAPACITY, 512));
            this.telemetryHideTables = this.getBoolean(properties, env, PropertyKey.TELEMETRY_HIDE_TABLES, true);
            this.o3PartitionPurgeListCapacity = this.getInt(properties, env, PropertyKey.CAIRO_O3_PARTITION_PURGE_LIST_INITIAL_CAPACITY, 1);
            this.ioURingEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_IO_URING_ENABLED, true);
            this.cairoMaxCrashFiles = this.getInt(properties, env, PropertyKey.CAIRO_MAX_CRASH_FILES, 100);
            this.parseBindTo(properties, env, PropertyKey.LINE_UDP_BIND_TO, "0.0.0.0:9009", (a, p) -> {
                this.lineUdpBindIPV4Address = a;
                this.lineUdpPort = p;
            });
            this.lineUdpGroupIPv4Address = this.getIPv4Address(properties, env, PropertyKey.LINE_UDP_JOIN, "232.1.2.3");
            this.lineUdpCommitRate = this.getInt(properties, env, PropertyKey.LINE_UDP_COMMIT_RATE, 1000000);
            this.lineUdpMsgBufferSize = this.getIntSize(properties, env, PropertyKey.LINE_UDP_MSG_BUFFER_SIZE, 2048);
            this.lineUdpMsgCount = this.getInt(properties, env, PropertyKey.LINE_UDP_MSG_COUNT, 10000);
            this.lineUdpReceiveBufferSize = this.getIntSize(properties, env, PropertyKey.LINE_UDP_RECEIVE_BUFFER_SIZE, 0x800000);
            this.lineUdpEnabled = this.getBoolean(properties, env, PropertyKey.LINE_UDP_ENABLED, true);
            this.lineUdpOwnThreadAffinity = this.getInt(properties, env, PropertyKey.LINE_UDP_OWN_THREAD_AFFINITY, -1);
            this.lineUdpOwnThread = this.getBoolean(properties, env, PropertyKey.LINE_UDP_OWN_THREAD, false);
            this.lineUdpUnicast = this.getBoolean(properties, env, PropertyKey.LINE_UDP_UNICAST, false);
            this.lineUdpCommitMode = this.getCommitMode(properties, env, PropertyKey.LINE_UDP_COMMIT_MODE);
            this.lineUdpTimestampAdapter = this.getLineTimestampAdaptor(properties, env, PropertyKey.LINE_UDP_TIMESTAMP);
            String defaultUdpPartitionByProperty = this.getString(properties, env, PropertyKey.LINE_DEFAULT_PARTITION_BY, "DAY");
            this.lineUdpDefaultPartitionBy = PartitionBy.fromString(defaultUdpPartitionByProperty);
            if (this.lineUdpDefaultPartitionBy == -1) {
                log.info().$("invalid partition by ").$(this.lineUdpDefaultPartitionBy).$("), will use DAY for UDP").$();
                this.lineUdpDefaultPartitionBy = 0;
            }
            this.lineTcpEnabled = this.getBoolean(properties, env, PropertyKey.LINE_TCP_ENABLED, true);
            if (this.lineTcpEnabled) {
                this.lineTcpNetConnectionLimit = this.getInt(properties, env, PropertyKey.LINE_TCP_NET_ACTIVE_CONNECTION_LIMIT, 256);
                this.lineTcpNetConnectionLimit = this.getInt(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_LIMIT, this.lineTcpNetConnectionLimit);
                this.lineTcpNetConnectionHint = this.getBoolean(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_HINT, false);
                this.parseBindTo(properties, env, PropertyKey.LINE_TCP_NET_BIND_TO, "0.0.0.0:9009", (a, p) -> {
                    this.lineTcpNetBindIPv4Address = a;
                    this.lineTcpNetBindPort = p;
                });
                this.lineTcpNetConnectionTimeout = this.getLong(properties, env, PropertyKey.LINE_TCP_NET_IDLE_TIMEOUT, 0L);
                this.lineTcpNetConnectionTimeout = this.getLong(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_TIMEOUT, this.lineTcpNetConnectionTimeout);
                this.lineTcpNetConnectionQueueTimeout = this.getLong(properties, env, PropertyKey.LINE_TCP_NET_QUEUED_TIMEOUT, 5000L);
                this.lineTcpNetConnectionQueueTimeout = this.getLong(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_QUEUE_TIMEOUT, this.lineTcpNetConnectionQueueTimeout);
                this.lineTcpNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.LINE_TCP_NET_RECV_BUF_SIZE, -1);
                this.lineTcpNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_RCVBUF, this.lineTcpNetConnectionRcvBuf);
                this.lineTcpConnectionPoolInitialCapacity = this.getInt(properties, env, PropertyKey.LINE_TCP_CONNECTION_POOL_CAPACITY, 8);
                this.lineTcpTimestampAdapter = this.getLineTimestampAdaptor(properties, env, PropertyKey.LINE_TCP_TIMESTAMP);
                this.lineTcpMsgBufferSize = this.getIntSize(properties, env, PropertyKey.LINE_TCP_MSG_BUFFER_SIZE, 32768);
                this.lineTcpMaxMeasurementSize = this.getIntSize(properties, env, PropertyKey.LINE_TCP_MAX_MEASUREMENT_SIZE, 32768);
                if (this.lineTcpMaxMeasurementSize > this.lineTcpMsgBufferSize) {
                    throw new IllegalArgumentException(PropertyKey.LINE_TCP_MAX_MEASUREMENT_SIZE.getPropertyPath() + " (" + this.lineTcpMaxMeasurementSize + ") cannot be more than line.tcp.msg.buffer.size (" + this.lineTcpMsgBufferSize + ")");
                }
                this.lineTcpWriterQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.LINE_TCP_WRITER_QUEUE_CAPACITY, 128);
                this.lineTcpWriterWorkerCount = this.getInt(properties, env, PropertyKey.LINE_TCP_WRITER_WORKER_COUNT, 1);
                cpuUsed += this.lineTcpWriterWorkerCount;
                this.lineTcpWriterWorkerAffinity = this.getAffinity(properties, env, PropertyKey.LINE_TCP_WRITER_WORKER_AFFINITY, this.lineTcpWriterWorkerCount);
                this.lineTcpWriterWorkerPoolHaltOnError = this.getBoolean(properties, env, PropertyKey.LINE_TCP_WRITER_HALT_ON_ERROR, false);
                this.lineTcpWriterWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_WRITER_WORKER_YIELD_THRESHOLD, 10L);
                this.lineTcpWriterWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_WRITER_WORKER_SLEEP_THRESHOLD, 10000L);
                this.symbolCacheWaitUsBeforeReload = this.getLong(properties, env, PropertyKey.LINE_TCP_SYMBOL_CACHE_WAIT_US_BEFORE_RELOAD, 500000L);
                int ilpTcpWorkerCount = cpuAvailable < 9 ? 0 : (cpuAvailable < 17 ? 2 : 6);
                this.lineTcpIOWorkerCount = this.getInt(properties, env, PropertyKey.LINE_TCP_IO_WORKER_COUNT, ilpTcpWorkerCount);
                cpuUsed += this.lineTcpIOWorkerCount;
                this.lineTcpIOWorkerAffinity = this.getAffinity(properties, env, PropertyKey.LINE_TCP_IO_WORKER_AFFINITY, this.lineTcpIOWorkerCount);
                this.lineTcpIOWorkerPoolHaltOnError = this.getBoolean(properties, env, PropertyKey.LINE_TCP_IO_HALT_ON_ERROR, false);
                this.lineTcpIOWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_IO_WORKER_YIELD_THRESHOLD, 10L);
                this.lineTcpIOWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_IO_WORKER_SLEEP_THRESHOLD, 10000L);
                this.lineTcpMaintenanceInterval = this.getLong(properties, env, PropertyKey.LINE_TCP_MAINTENANCE_JOB_INTERVAL, 1000L);
                this.lineTcpCommitIntervalFraction = this.getDouble(properties, env, PropertyKey.LINE_TCP_COMMIT_INTERVAL_FRACTION, 0.5);
                this.lineTcpCommitIntervalDefault = this.getLong(properties, env, PropertyKey.LINE_TCP_COMMIT_INTERVAL_DEFAULT, 2000L);
                if (this.lineTcpCommitIntervalDefault < 1L) {
                    log.info().$("invalid default commit interval ").$(this.lineTcpCommitIntervalDefault).$("), will use ").$(2000L).$();
                    this.lineTcpCommitIntervalDefault = 2000L;
                }
                this.lineTcpAuthDbPath = this.getString(properties, env, PropertyKey.LINE_TCP_AUTH_DB_PATH, null);
                String defaultTcpPartitionByProperty = this.getString(properties, env, PropertyKey.LINE_TCP_DEFAULT_PARTITION_BY, "DAY");
                defaultTcpPartitionByProperty = this.getString(properties, env, PropertyKey.LINE_DEFAULT_PARTITION_BY, defaultTcpPartitionByProperty);
                this.lineTcpDefaultPartitionBy = PartitionBy.fromString(defaultTcpPartitionByProperty);
                if (this.lineTcpDefaultPartitionBy == -1) {
                    log.info().$("invalid partition by ").$(defaultTcpPartitionByProperty).$("), will use DAY for TCP").$();
                    this.lineTcpDefaultPartitionBy = 0;
                }
                if (null != this.lineTcpAuthDbPath) {
                    this.lineTcpAuthDbPath = new File(root, this.lineTcpAuthDbPath).getAbsolutePath();
                }
                this.minIdleMsBeforeWriterRelease = this.getLong(properties, env, PropertyKey.LINE_TCP_MIN_IDLE_MS_BEFORE_WRITER_RELEASE, 500L);
                this.lineTcpDisconnectOnError = this.getBoolean(properties, env, PropertyKey.LINE_TCP_DISCONNECT_ON_ERROR, true);
                this.stringToCharCastAllowed = this.getBoolean(properties, env, PropertyKey.LINE_TCP_UNDOCUMENTED_STRING_TO_CHAR_CAST_ALLOWED, false);
                this.symbolAsFieldSupported = this.getBoolean(properties, env, PropertyKey.LINE_TCP_UNDOCUMENTED_SYMBOL_AS_FIELD_SUPPORTED, false);
                this.isStringAsTagSupported = this.getBoolean(properties, env, PropertyKey.LINE_TCP_UNDOCUMENTED_STRING_AS_TAG_SUPPORTED, false);
                String floatDefaultColumnTypeName = this.getString(properties, env, PropertyKey.LINE_FLOAT_DEFAULT_COLUMN_TYPE, ColumnType.nameOf(10));
                this.floatDefaultColumnType = ColumnType.tagOf(floatDefaultColumnTypeName);
                if (this.floatDefaultColumnType != 10 && this.floatDefaultColumnType != 9) {
                    log.info().$("invalid default column type for float ").$(floatDefaultColumnTypeName).$("), will use DOUBLE").$();
                    this.floatDefaultColumnType = (short)10;
                }
                String integerDefaultColumnTypeName = this.getString(properties, env, PropertyKey.LINE_INTEGER_DEFAULT_COLUMN_TYPE, ColumnType.nameOf(6));
                this.integerDefaultColumnType = ColumnType.tagOf(integerDefaultColumnTypeName);
                if (this.integerDefaultColumnType != 6 && this.integerDefaultColumnType != 5 && this.integerDefaultColumnType != 3 && this.integerDefaultColumnType != 2) {
                    log.info().$("invalid default column type for integer ").$(integerDefaultColumnTypeName).$("), will use LONG").$();
                    this.integerDefaultColumnType = (short)6;
                }
            }
            this.ilpAutoCreateNewColumns = this.getBoolean(properties, env, PropertyKey.LINE_AUTO_CREATE_NEW_COLUMNS, true);
            this.ilpAutoCreateNewTables = this.getBoolean(properties, env, PropertyKey.LINE_AUTO_CREATE_NEW_TABLES, true);
            this.sharedWorkerCount = this.getInt(properties, env, PropertyKey.SHARED_WORKER_COUNT, Math.max(2, cpuAvailable - cpuSpare - cpuUsed));
            this.sharedWorkerAffinity = this.getAffinity(properties, env, PropertyKey.SHARED_WORKER_AFFINITY, this.sharedWorkerCount);
            this.sharedWorkerHaltOnError = this.getBoolean(properties, env, PropertyKey.SHARED_WORKER_HALT_ON_ERROR, false);
            this.sharedWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.SHARED_WORKER_YIELD_THRESHOLD, 100L);
            this.sharedWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.SHARED_WORKER_SLEEP_THRESHOLD, 10000L);
            this.sharedWorkerSleepTimeout = this.getLong(properties, env, PropertyKey.SHARED_WORKER_SLEEP_TIMEOUT, 100L);
            this.metricsEnabled = this.getBoolean(properties, env, PropertyKey.METRICS_ENABLED, false);
            this.writerAsyncCommandBusyWaitTimeout = this.getLong(properties, env, PropertyKey.CAIRO_WRITER_ALTER_BUSY_WAIT_TIMEOUT, 500L);
            this.writerAsyncCommandMaxWaitTimeout = this.getLong(properties, env, PropertyKey.CAIRO_WRITER_ALTER_MAX_WAIT_TIMEOUT, 30000L);
            this.writerTickRowsCountMod = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_WRITER_TICK_ROWS_COUNT, 1024)) - 1;
            this.writerAsyncCommandQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_WRITER_COMMAND_QUEUE_CAPACITY, 32));
            this.writerAsyncCommandQueueSlotSize = Numbers.ceilPow2(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_COMMAND_QUEUE_SLOT_SIZE, 2048L));
            this.queryCacheEventQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_QUERY_CACHE_EVENT_QUEUE_CAPACITY, 4));
            this.buildInformation = buildInformation;
            this.binaryEncodingMaxLength = this.getInt(properties, env, PropertyKey.BINARYDATA_ENCODING_MAXLENGTH, 32768);
        }
    }

    public static String rootSubdir(CharSequence dbRoot, CharSequence subdir) {
        if (dbRoot != null) {
            int len;
            int end = len = dbRoot.length();
            boolean needsSlash = true;
            for (int i = len - 1; i > -1; --i) {
                if (dbRoot.charAt(i) != Files.SEPARATOR || i == len - 1) continue;
                end = i + 1;
                needsSlash = false;
                break;
            }
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(dbRoot, 0, end);
            if (needsSlash) {
                sink.put(Files.SEPARATOR);
            }
            return sink.put(subdir).toString();
        }
        return null;
    }

    @Override
    public CairoConfiguration getCairoConfiguration() {
        return this.cairoConfiguration;
    }

    @Override
    public HttpServerConfiguration getHttpServerConfiguration() {
        return this.httpServerConfiguration;
    }

    @Override
    public HttpMinServerConfiguration getHttpMinServerConfiguration() {
        return this.httpMinServerConfiguration;
    }

    @Override
    public LineUdpReceiverConfiguration getLineUdpReceiverConfiguration() {
        return this.lineUdpReceiverConfiguration;
    }

    @Override
    public LineTcpReceiverConfiguration getLineTcpReceiverConfiguration() {
        return this.lineTcpReceiverConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getWorkerPoolConfiguration() {
        return this.workerPoolConfiguration;
    }

    @Override
    public PGWireConfiguration getPGWireConfiguration() {
        return this.pgWireConfiguration;
    }

    @Override
    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    static ValidationResult validate(Properties properties) {
        HashMap<String, String> obsolete = new HashMap<String, String>();
        HashMap<String, String> deprecated = new HashMap<String, String>();
        HashSet<String> incorrect = new HashSet<String>();
        for (String propName : properties.stringPropertyNames()) {
            Optional<PropertyKey> prop = PropertyKey.getByString(propName);
            if (prop.isPresent()) {
                String string = DEPRECATED_SETTINGS.get((Object)prop.get());
                if (string == null) continue;
                deprecated.put(propName, string);
                continue;
            }
            String string = OBSOLETE_SETTINGS.get(propName);
            if (string != null) {
                obsolete.put(propName, string);
                continue;
            }
            incorrect.add(propName);
        }
        if (obsolete.isEmpty() && deprecated.isEmpty() && incorrect.isEmpty()) {
            return null;
        }
        boolean isError = false;
        StringBuilder sb = new StringBuilder("Configuration issues:\n");
        if (!incorrect.isEmpty()) {
            isError = true;
            sb.append("    Invalid settings (not recognized, probable typos):\n");
            for (String string : incorrect) {
                sb.append("        * ");
                sb.append(string);
                sb.append('\n');
            }
        }
        if (!obsolete.isEmpty()) {
            isError = true;
            sb.append("    Obsolete settings (no longer recognized):\n");
            for (Map.Entry entry : obsolete.entrySet()) {
                sb.append("        * ");
                sb.append((String)entry.getKey());
                sb.append(": ");
                sb.append((String)entry.getValue());
                sb.append('\n');
            }
        }
        if (!deprecated.isEmpty()) {
            sb.append("    Deprecated settings (recognized but superseded by newer settings):\n");
            for (Map.Entry entry : deprecated.entrySet()) {
                sb.append("        * ");
                sb.append((String)entry.getKey());
                sb.append(": ");
                sb.append((String)entry.getValue());
                sb.append('\n');
            }
        }
        return new ValidationResult(isError, sb.toString());
    }

    private static <KeyT> void registerReplacements(Map<KeyT, String> map, KeyT old, PropertyKey ... replacements) {
        StringBuilder sb = new StringBuilder("Replaced by ");
        for (int index = 0; index < replacements.length; ++index) {
            if (index > 0) {
                sb.append(index < replacements.length - 1 ? ", " : " and ");
            }
            String replacement = replacements[index].getPropertyPath();
            sb.append('`');
            sb.append(replacement);
            sb.append('`');
        }
        map.put(old, sb.toString());
    }

    private static void registerObsolete(String old, PropertyKey ... replacements) {
        PropServerConfiguration.registerReplacements(OBSOLETE_SETTINGS, old, replacements);
    }

    private static void registerDeprecated(PropertyKey old, PropertyKey ... replacements) {
        PropServerConfiguration.registerReplacements(DEPRECATED_SETTINGS, old, replacements);
    }

    private int[] getAffinity(Properties properties, @Nullable Map<String, String> env, PropertyKey key, int httpWorkerCount) throws ServerConfigurationException {
        int[] result = new int[httpWorkerCount];
        String value = this.overrideWithEnv(properties, env, key);
        if (value == null) {
            Arrays.fill(result, -1);
        } else {
            String[] affinity = value.split(",");
            if (affinity.length != httpWorkerCount) {
                throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), "wrong number of affinity values");
            }
            for (int i = 0; i < httpWorkerCount; ++i) {
                try {
                    result[i] = Numbers.parseInt(affinity[i]);
                    continue;
                }
                catch (NumericException e) {
                    throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), "Invalid affinity value: " + affinity[i]);
                }
            }
        }
        return result;
    }

    protected boolean getBoolean(Properties properties, @Nullable Map<String, String> env, PropertyKey key, boolean defaultValue) {
        String value = this.overrideWithEnv(properties, env, key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    String getCanonicalPath(String path) throws ServerConfigurationException {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new ServerConfigurationException("Cannot calculate canonical path for configuration property [key=" + PropertyKey.CAIRO_SQL_COPY_WORK_ROOT.getPropertyPath() + ",value=" + path + "]");
        }
    }

    private int getCommitMode(Properties properties, @Nullable Map<String, String> env, PropertyKey key) {
        String commitMode = this.overrideWithEnv(properties, env, key);
        if (commitMode == null) {
            return 2;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "nosync")) {
            return 2;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "async")) {
            return 0;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "sync")) {
            return 1;
        }
        return 2;
    }

    private double getDouble(Properties properties, @Nullable Map<String, String> env, PropertyKey key, double defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseDouble(value) : defaultValue;
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected int getIPv4Address(Properties properties, Map<String, String> env, PropertyKey key, String defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, defaultValue);
        try {
            return Net.parseIPv4(value);
        }
        catch (NetworkError e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    private int getInt(Properties properties, @Nullable Map<String, String> env, PropertyKey key, int defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseInt(value) : defaultValue;
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected int getIntSize(Properties properties, @Nullable Map<String, String> env, PropertyKey key, int defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseIntSize(value) : defaultValue;
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    private LineProtoTimestampAdapter getLineTimestampAdaptor(Properties properties, Map<String, String> env, PropertyKey propNm) {
        String lineUdpTimestampSwitch;
        switch (lineUdpTimestampSwitch = this.getString(properties, env, propNm, "n")) {
            case "u": {
                return LineProtoMicroTimestampAdapter.INSTANCE;
            }
            case "ms": {
                return LineProtoMilliTimestampAdapter.INSTANCE;
            }
            case "s": {
                return LineProtoSecondTimestampAdapter.INSTANCE;
            }
            case "m": {
                return LineProtoMinuteTimestampAdapter.INSTANCE;
            }
            case "h": {
                return LineProtoHourTimestampAdapter.INSTANCE;
            }
        }
        return LineProtoNanoTimestampAdapter.INSTANCE;
    }

    private long getLong(Properties properties, @Nullable Map<String, String> env, PropertyKey key, long defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseLong(value) : defaultValue;
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    private long getLongSize(Properties properties, @Nullable Map<String, String> env, PropertyKey key, long defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseLongSize(value) : defaultValue;
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    private int getQueueCapacity(Properties properties, @Nullable Map<String, String> env, PropertyKey key, int defaultValue) throws ServerConfigurationException {
        int value = this.getInt(properties, env, key, defaultValue);
        if (!Numbers.isPow2(value)) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), "Value must be power of 2, e.g. 1,2,4,8,16,32,64...");
        }
        return value;
    }

    private int getSqlJitMode(Properties properties, @Nullable Map<String, String> env) {
        String jitMode = this.overrideWithEnv(properties, env, PropertyKey.CAIRO_SQL_JIT_MODE);
        if (jitMode == null) {
            return 0;
        }
        if (Chars.equalsLowerCaseAscii(jitMode, "on")) {
            return 0;
        }
        if (Chars.equalsLowerCaseAscii(jitMode, "off")) {
            return 2;
        }
        if (Chars.equalsLowerCaseAscii(jitMode, "scalar")) {
            return 1;
        }
        return 0;
    }

    private String getString(Properties properties, @Nullable Map<String, String> env, PropertyKey key, String defaultValue) {
        String value = this.overrideWithEnv(properties, env, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private DateFormat getTimestampFormat(Properties properties, @Nullable Map<String, String> env) {
        String pattern = this.overrideWithEnv(properties, env, PropertyKey.CAIRO_SQL_BACKUP_DIR_DATETIME_FORMAT);
        TimestampFormatCompiler compiler = new TimestampFormatCompiler();
        if (null != pattern) {
            return compiler.compile(pattern);
        }
        return compiler.compile("yyyy-MM-dd");
    }

    private String overrideWithEnv(Properties properties, @Nullable Map<String, String> env, PropertyKey key) {
        String envValue;
        String envCandidate = "QDB_" + key.getPropertyPath().replace('.', '_').toUpperCase();
        String string = envValue = env != null ? env.get(envCandidate) : null;
        if (envValue != null) {
            this.log.info().$("env config [key=").$(envCandidate).$(']').$();
            return envValue;
        }
        return properties.getProperty(key.getPropertyPath());
    }

    protected void parseBindTo(Properties properties, Map<String, String> env, PropertyKey key, String defaultValue, BindToParser parser) throws ServerConfigurationException {
        int port;
        int ipv4;
        String bindTo = this.getString(properties, env, key, defaultValue);
        int colonIndex = bindTo.indexOf(58);
        if (colonIndex == -1) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), bindTo);
        }
        String ipv4Str = bindTo.substring(0, colonIndex);
        try {
            ipv4 = Net.parseIPv4(ipv4Str);
        }
        catch (NetworkError e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), ipv4Str);
        }
        String portStr = bindTo.substring(colonIndex + 1);
        try {
            port = Numbers.parseInt(portStr);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), portStr);
        }
        parser.onReady(ipv4, port);
    }

    private boolean pathEquals(String p1, String p2) {
        try {
            if (p1 == null || p2 == null) {
                return false;
            }
            return new File(p1).getCanonicalPath().replace(File.separatorChar, '/').equals(new File(p2).getCanonicalPath().replace(File.separatorChar, '/'));
        }
        catch (IOException e) {
            this.log.info().$("Can't validate configuration property [key=").$(PropertyKey.CAIRO_SQL_COPY_WORK_ROOT.getPropertyPath()).$(", value=").$(p2).$("]");
            return false;
        }
    }

    private void validateProperties(Properties properties, boolean configValidationStrict) throws ServerConfigurationException {
        ValidationResult validation = PropServerConfiguration.validate(properties);
        if (validation != null) {
            if (validation.isError && configValidationStrict) {
                throw new ServerConfigurationException(validation.message);
            }
            this.log.advisory().$(validation.message).$();
        }
    }

    static {
        WRITE_FO_OPTS.put("o_direct", 16384);
        WRITE_FO_OPTS.put("o_sync", 128);
        WRITE_FO_OPTS.put("o_async", 64);
        WRITE_FO_OPTS.put("o_none", 0);
        PropServerConfiguration.registerObsolete("line.tcp.commit.timeout", PropertyKey.LINE_TCP_COMMIT_INTERVAL_DEFAULT, PropertyKey.LINE_TCP_COMMIT_INTERVAL_FRACTION);
        PropServerConfiguration.registerObsolete("cairo.timestamp.locale", PropertyKey.CAIRO_DATE_LOCALE);
        PropServerConfiguration.registerObsolete("pg.timestamp.locale", PropertyKey.PG_DATE_LOCALE);
        PropServerConfiguration.registerDeprecated(PropertyKey.HTTP_MIN_BIND_TO, PropertyKey.HTTP_MIN_NET_BIND_TO);
        PropServerConfiguration.registerDeprecated(PropertyKey.HTTP_MIN_NET_IDLE_CONNECTION_TIMEOUT, PropertyKey.HTTP_MIN_NET_CONNECTION_TIMEOUT);
        PropServerConfiguration.registerDeprecated(PropertyKey.HTTP_MIN_NET_QUEUED_CONNECTION_TIMEOUT, PropertyKey.HTTP_MIN_NET_CONNECTION_QUEUE_TIMEOUT);
        PropServerConfiguration.registerDeprecated(PropertyKey.HTTP_MIN_NET_SND_BUF_SIZE, PropertyKey.HTTP_MIN_NET_CONNECTION_SNDBUF);
        PropServerConfiguration.registerDeprecated(PropertyKey.HTTP_NET_RCV_BUF_SIZE, PropertyKey.HTTP_MIN_NET_CONNECTION_RCVBUF, PropertyKey.HTTP_NET_CONNECTION_RCVBUF);
        PropServerConfiguration.registerDeprecated(PropertyKey.HTTP_NET_ACTIVE_CONNECTION_LIMIT, PropertyKey.HTTP_NET_CONNECTION_LIMIT);
        PropServerConfiguration.registerDeprecated(PropertyKey.HTTP_NET_IDLE_CONNECTION_TIMEOUT, PropertyKey.HTTP_NET_CONNECTION_TIMEOUT);
        PropServerConfiguration.registerDeprecated(PropertyKey.HTTP_NET_QUEUED_CONNECTION_TIMEOUT, PropertyKey.HTTP_NET_CONNECTION_QUEUE_TIMEOUT);
        PropServerConfiguration.registerDeprecated(PropertyKey.HTTP_NET_SND_BUF_SIZE, PropertyKey.HTTP_NET_CONNECTION_SNDBUF);
        PropServerConfiguration.registerDeprecated(PropertyKey.PG_NET_ACTIVE_CONNECTION_LIMIT, PropertyKey.PG_NET_CONNECTION_LIMIT);
        PropServerConfiguration.registerDeprecated(PropertyKey.PG_NET_IDLE_TIMEOUT, PropertyKey.PG_NET_CONNECTION_TIMEOUT);
        PropServerConfiguration.registerDeprecated(PropertyKey.PG_NET_RECV_BUF_SIZE, PropertyKey.PG_NET_CONNECTION_RCVBUF);
        PropServerConfiguration.registerDeprecated(PropertyKey.LINE_TCP_NET_ACTIVE_CONNECTION_LIMIT, PropertyKey.LINE_TCP_NET_CONNECTION_LIMIT);
        PropServerConfiguration.registerDeprecated(PropertyKey.LINE_TCP_NET_IDLE_TIMEOUT, PropertyKey.LINE_TCP_NET_CONNECTION_TIMEOUT);
        PropServerConfiguration.registerDeprecated(PropertyKey.LINE_TCP_NET_QUEUED_TIMEOUT, PropertyKey.LINE_TCP_NET_CONNECTION_QUEUE_TIMEOUT);
        PropServerConfiguration.registerDeprecated(PropertyKey.LINE_TCP_NET_RECV_BUF_SIZE, PropertyKey.LINE_TCP_NET_CONNECTION_RCVBUF);
        PropServerConfiguration.registerDeprecated(PropertyKey.LINE_TCP_DEFAULT_PARTITION_BY, PropertyKey.LINE_DEFAULT_PARTITION_BY);
    }

    private class PropMetricsConfiguration
    implements MetricsConfiguration {
        private PropMetricsConfiguration() {
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.metricsEnabled;
        }
    }

    private class PropHttpMinServerConfiguration
    implements HttpMinServerConfiguration {
        private PropHttpMinServerConfiguration() {
        }

        @Override
        public IODispatcherConfiguration getDispatcherConfiguration() {
            return PropServerConfiguration.this.httpMinIODispatcherConfiguration;
        }

        @Override
        public HttpContextConfiguration getHttpContextConfiguration() {
            return PropServerConfiguration.this.httpContextConfiguration;
        }

        @Override
        public WaitProcessorConfiguration getWaitProcessorConfiguration() {
            return PropServerConfiguration.this.httpWaitProcessorConfiguration;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.httpMinWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.httpMinWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.httpMinWorkerHaltOnError;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.httpMinWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.httpMinWorkerSleepThreshold;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.httpMinServerEnabled;
        }
    }

    private class PropTelemetryConfiguration
    implements TelemetryConfiguration {
        private PropTelemetryConfiguration() {
        }

        @Override
        public boolean getDisableCompletely() {
            return PropServerConfiguration.this.telemetryDisableCompletely;
        }

        @Override
        public boolean getEnabled() {
            return PropServerConfiguration.this.telemetryEnabled;
        }

        @Override
        public int getQueueCapacity() {
            return PropServerConfiguration.this.telemetryQueueCapacity;
        }

        @Override
        public boolean hideTables() {
            return PropServerConfiguration.this.telemetryHideTables;
        }
    }

    private class PropPGWireConfiguration
    implements PGWireConfiguration {
        private PropPGWireConfiguration() {
        }

        @Override
        public int getBinParamCountCapacity() {
            return PropServerConfiguration.this.pgBinaryParamsCapacity;
        }

        @Override
        public int getCharacterStoreCapacity() {
            return PropServerConfiguration.this.pgCharacterStoreCapacity;
        }

        @Override
        public int getCharacterStorePoolCapacity() {
            return PropServerConfiguration.this.pgCharacterStorePoolCapacity;
        }

        @Override
        public int getConnectionPoolInitialCapacity() {
            return PropServerConfiguration.this.pgConnectionPoolInitialCapacity;
        }

        @Override
        public String getDefaultPassword() {
            return PropServerConfiguration.this.pgPassword;
        }

        @Override
        public String getDefaultUsername() {
            return PropServerConfiguration.this.pgUsername;
        }

        @Override
        public boolean readOnlySecurityContext() {
            return PropServerConfiguration.this.pgReadOnlySecurityContext;
        }

        @Override
        public IODispatcherConfiguration getDispatcherConfiguration() {
            return PropServerConfiguration.this.propPGWireDispatcherConfiguration;
        }

        @Override
        public boolean isSelectCacheEnabled() {
            return PropServerConfiguration.this.pgSelectCacheEnabled;
        }

        @Override
        public int getSelectCacheBlockCount() {
            return PropServerConfiguration.this.pgSelectCacheBlockCount;
        }

        @Override
        public int getSelectCacheRowCount() {
            return PropServerConfiguration.this.pgSelectCacheRowCount;
        }

        @Override
        public boolean isInsertCacheEnabled() {
            return PropServerConfiguration.this.pgInsertCacheEnabled;
        }

        @Override
        public int getInsertCacheBlockCount() {
            return PropServerConfiguration.this.pgInsertCacheBlockCount;
        }

        @Override
        public int getInsertCacheRowCount() {
            return PropServerConfiguration.this.pgInsertCacheRowCount;
        }

        @Override
        public int getInsertPoolCapacity() {
            return PropServerConfiguration.this.pgInsertPoolCapacity;
        }

        @Override
        public boolean isUpdateCacheEnabled() {
            return PropServerConfiguration.this.pgUpdateCacheEnabled;
        }

        @Override
        public int getUpdateCacheBlockCount() {
            return PropServerConfiguration.this.pgUpdateCacheBlockCount;
        }

        @Override
        public int getUpdateCacheRowCount() {
            return PropServerConfiguration.this.pgUpdateCacheRowCount;
        }

        @Override
        public int getMaxBlobSizeOnQuery() {
            return PropServerConfiguration.this.pgMaxBlobSizeOnQuery;
        }

        @Override
        public int getNamedStatementCacheCapacity() {
            return PropServerConfiguration.this.pgNamedStatementCacheCapacity;
        }

        @Override
        public int getNamesStatementPoolCapacity() {
            return PropServerConfiguration.this.pgNamesStatementPoolCapacity;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getPendingWritersCacheSize() {
            return PropServerConfiguration.this.pgPendingWritersCacheCapacity;
        }

        @Override
        public int getRecvBufferSize() {
            return PropServerConfiguration.this.pgRecvBufferSize;
        }

        @Override
        public int getSendBufferSize() {
            return PropServerConfiguration.this.pgSendBufferSize;
        }

        @Override
        public String getServerVersion() {
            return "11.3";
        }

        @Override
        public DateLocale getDefaultDateLocale() {
            return PropServerConfiguration.this.pgDefaultLocale;
        }

        @Override
        public SqlExecutionCircuitBreakerConfiguration getCircuitBreakerConfiguration() {
            return PropServerConfiguration.this.circuitBreakerConfiguration;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.pgWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.pgWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.pgHaltOnError;
        }

        @Override
        public boolean isDaemonPool() {
            return PropServerConfiguration.this.pgDaemonPool;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.pgWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.pgWorkerSleepThreshold;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.pgEnabled;
        }
    }

    private class PropPGWireDispatcherConfiguration
    implements IODispatcherConfiguration {
        private PropPGWireDispatcherConfiguration() {
        }

        @Override
        public int getLimit() {
            return PropServerConfiguration.this.pgNetConnectionLimit;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.pgNetBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.pgNetBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public String getDispatcherLogName() {
            return "pg-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public long getTimeout() {
            return PropServerConfiguration.this.pgNetIdleConnectionTimeout;
        }

        @Override
        public int getInitialBias() {
            return 1;
        }

        @Override
        public boolean getHint() {
            return PropServerConfiguration.this.pgNetConnectionHint;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRcvBufSize() {
            return PropServerConfiguration.this.pgNetConnectionRcvBuf;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSndBufSize() {
            return PropServerConfiguration.this.pgNetConnectionSndBuf;
        }

        @Override
        public long getQueueTimeout() {
            return PropServerConfiguration.this.pgNetConnectionQueueTimeout;
        }
    }

    private class PropWaitProcessorConfiguration
    implements WaitProcessorConfiguration {
        private PropWaitProcessorConfiguration() {
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public long getMaxWaitCapMs() {
            return PropServerConfiguration.this.maxRerunWaitCapMs;
        }

        @Override
        public double getExponentialWaitMultiplier() {
            return PropServerConfiguration.this.rerunExponentialWaitMultiplier;
        }

        @Override
        public int getInitialWaitQueueSize() {
            return PropServerConfiguration.this.rerunInitialWaitQueueSize;
        }

        @Override
        public int getMaxProcessingQueueSize() {
            return PropServerConfiguration.this.rerunMaxProcessingQueueSize;
        }
    }

    private class PropWorkerPoolConfiguration
    implements WorkerPoolConfiguration {
        private PropWorkerPoolConfiguration() {
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.sharedWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.sharedWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.sharedWorkerHaltOnError;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.sharedWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.sharedWorkerSleepThreshold;
        }

        @Override
        public long getSleepTimeout() {
            return PropServerConfiguration.this.sharedWorkerSleepTimeout;
        }
    }

    private class PropJsonQueryProcessorConfiguration
    implements JsonQueryProcessorConfiguration {
        private PropJsonQueryProcessorConfiguration() {
        }

        @Override
        public MillisecondClock getClock() {
            return PropServerConfiguration.this.httpFrozenClock ? StationaryMillisClock.INSTANCE : MillisecondClockImpl.INSTANCE;
        }

        @Override
        public int getConnectionCheckFrequency() {
            return PropServerConfiguration.this.jsonQueryConnectionCheckFrequency;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public int getFloatScale() {
            return PropServerConfiguration.this.jsonQueryFloatScale;
        }

        @Override
        public int getDoubleScale() {
            return PropServerConfiguration.this.jsonQueryDoubleScale;
        }

        @Override
        public CharSequence getKeepAliveHeader() {
            return PropServerConfiguration.this.keepAliveHeader;
        }

        @Override
        public long getMaxQueryResponseRowLimit() {
            return PropServerConfiguration.this.maxHttpQueryResponseRowLimit;
        }
    }

    private class PropLineTcpReceiverConfiguration
    implements LineTcpReceiverConfiguration {
        private PropLineTcpReceiverConfiguration() {
        }

        @Override
        public String getAuthDbPath() {
            return PropServerConfiguration.this.lineTcpAuthDbPath;
        }

        @Override
        public boolean getAutoCreateNewColumns() {
            return PropServerConfiguration.this.ilpAutoCreateNewColumns;
        }

        @Override
        public boolean getAutoCreateNewTables() {
            return PropServerConfiguration.this.ilpAutoCreateNewTables;
        }

        @Override
        public CairoSecurityContext getCairoSecurityContext() {
            return AllowAllCairoSecurityContext.INSTANCE;
        }

        @Override
        public int getConnectionPoolInitialCapacity() {
            return PropServerConfiguration.this.lineTcpConnectionPoolInitialCapacity;
        }

        @Override
        public int getDefaultPartitionBy() {
            return PropServerConfiguration.this.lineTcpDefaultPartitionBy;
        }

        @Override
        public WorkerPoolAwareConfiguration getIOWorkerPoolConfiguration() {
            return PropServerConfiguration.this.lineTcpIOWorkerPoolConfiguration;
        }

        @Override
        public long getMaintenanceInterval() {
            return PropServerConfiguration.this.lineTcpMaintenanceInterval;
        }

        @Override
        public double getCommitIntervalFraction() {
            return PropServerConfiguration.this.lineTcpCommitIntervalFraction;
        }

        @Override
        public long getCommitIntervalDefault() {
            return PropServerConfiguration.this.lineTcpCommitIntervalDefault;
        }

        @Override
        public int getMaxFileNameLength() {
            return PropServerConfiguration.this.maxFileNameLength;
        }

        @Override
        public int getMaxMeasurementSize() {
            return PropServerConfiguration.this.lineTcpMaxMeasurementSize;
        }

        @Override
        public MicrosecondClock getMicrosecondClock() {
            return MicrosecondClockImpl.INSTANCE;
        }

        @Override
        public MillisecondClock getMillisecondClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public long getWriterIdleTimeout() {
            return PropServerConfiguration.this.minIdleMsBeforeWriterRelease;
        }

        @Override
        public IODispatcherConfiguration getDispatcherConfiguration() {
            return PropServerConfiguration.this.lineTcpReceiverDispatcherConfiguration;
        }

        @Override
        public int getNetMsgBufferSize() {
            return PropServerConfiguration.this.lineTcpMsgBufferSize;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public LineProtoTimestampAdapter getTimestampAdapter() {
            return PropServerConfiguration.this.lineTcpTimestampAdapter;
        }

        @Override
        public int getWriterQueueCapacity() {
            return PropServerConfiguration.this.lineTcpWriterQueueCapacity;
        }

        @Override
        public WorkerPoolAwareConfiguration getWriterWorkerPoolConfiguration() {
            return PropServerConfiguration.this.lineTcpWriterWorkerPoolConfiguration;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.lineTcpEnabled;
        }

        @Override
        public boolean getDisconnectOnError() {
            return PropServerConfiguration.this.lineTcpDisconnectOnError;
        }

        @Override
        public long getSymbolCacheWaitUsBeforeReload() {
            return PropServerConfiguration.this.symbolCacheWaitUsBeforeReload;
        }

        @Override
        public boolean isStringToCharCastAllowed() {
            return PropServerConfiguration.this.stringToCharCastAllowed;
        }

        @Override
        public boolean isSymbolAsFieldSupported() {
            return PropServerConfiguration.this.symbolAsFieldSupported;
        }

        @Override
        public boolean isStringAsTagSupported() {
            return PropServerConfiguration.this.isStringAsTagSupported;
        }

        @Override
        public short getDefaultColumnTypeForFloat() {
            return PropServerConfiguration.this.floatDefaultColumnType;
        }

        @Override
        public short getDefaultColumnTypeForInteger() {
            return PropServerConfiguration.this.integerDefaultColumnType;
        }
    }

    private class PropLineTcpIOWorkerPoolConfiguration
    implements WorkerPoolAwareConfiguration {
        private PropLineTcpIOWorkerPoolConfiguration() {
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.lineTcpIOWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.lineTcpIOWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.lineTcpIOWorkerPoolHaltOnError;
        }

        @Override
        public String getPoolName() {
            return "ilpio";
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.lineTcpIOWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.lineTcpIOWorkerSleepThreshold;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private class PropLineTcpWriterWorkerPoolConfiguration
    implements WorkerPoolAwareConfiguration {
        private PropLineTcpWriterWorkerPoolConfiguration() {
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.lineTcpWriterWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.lineTcpWriterWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.lineTcpWriterWorkerPoolHaltOnError;
        }

        @Override
        public String getPoolName() {
            return "ilpwriter";
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.lineTcpWriterWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.lineTcpWriterWorkerSleepThreshold;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private class PropLineTcpReceiverIODispatcherConfiguration
    implements IODispatcherConfiguration {
        private PropLineTcpReceiverIODispatcherConfiguration() {
        }

        @Override
        public int getLimit() {
            return PropServerConfiguration.this.lineTcpNetConnectionLimit;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.lineTcpNetBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.lineTcpNetBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public String getDispatcherLogName() {
            return "tcp-line-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public long getTimeout() {
            return PropServerConfiguration.this.lineTcpNetConnectionTimeout;
        }

        @Override
        public int getInitialBias() {
            return 1;
        }

        @Override
        public boolean getHint() {
            return PropServerConfiguration.this.lineTcpNetConnectionHint;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRcvBufSize() {
            return PropServerConfiguration.this.lineTcpNetConnectionRcvBuf;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSndBufSize() {
            return -1;
        }

        @Override
        public long getQueueTimeout() {
            return PropServerConfiguration.this.lineTcpNetConnectionQueueTimeout;
        }
    }

    private class PropLineUdpReceiverConfiguration
    implements LineUdpReceiverConfiguration {
        private PropLineUdpReceiverConfiguration() {
        }

        @Override
        public boolean getAutoCreateNewColumns() {
            return PropServerConfiguration.this.ilpAutoCreateNewColumns;
        }

        @Override
        public boolean getAutoCreateNewTables() {
            return PropServerConfiguration.this.ilpAutoCreateNewTables;
        }

        @Override
        public int getCommitMode() {
            return PropServerConfiguration.this.lineUdpCommitMode;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.lineUdpBindIPV4Address;
        }

        @Override
        public int getCommitRate() {
            return PropServerConfiguration.this.lineUdpCommitRate;
        }

        @Override
        public int getGroupIPv4Address() {
            return PropServerConfiguration.this.lineUdpGroupIPv4Address;
        }

        @Override
        public int getMaxFileNameLength() {
            return PropServerConfiguration.this.maxFileNameLength;
        }

        @Override
        public int getMsgBufferSize() {
            return PropServerConfiguration.this.lineUdpMsgBufferSize;
        }

        @Override
        public int getMsgCount() {
            return PropServerConfiguration.this.lineUdpMsgCount;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getPort() {
            return PropServerConfiguration.this.lineUdpPort;
        }

        @Override
        public int getReceiveBufferSize() {
            return PropServerConfiguration.this.lineUdpReceiveBufferSize;
        }

        @Override
        public CairoSecurityContext getCairoSecurityContext() {
            return AllowAllCairoSecurityContext.INSTANCE;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.lineUdpEnabled;
        }

        @Override
        public boolean isUnicast() {
            return PropServerConfiguration.this.lineUdpUnicast;
        }

        @Override
        public boolean ownThread() {
            return PropServerConfiguration.this.lineUdpOwnThread;
        }

        @Override
        public int ownThreadAffinity() {
            return PropServerConfiguration.this.lineUdpOwnThreadAffinity;
        }

        @Override
        public LineProtoTimestampAdapter getTimestampAdapter() {
            return PropServerConfiguration.this.lineUdpTimestampAdapter;
        }

        @Override
        public int getDefaultPartitionBy() {
            return PropServerConfiguration.this.lineUdpDefaultPartitionBy;
        }

        @Override
        public short getDefaultColumnTypeForFloat() {
            return PropServerConfiguration.this.floatDefaultColumnType;
        }

        @Override
        public short getDefaultColumnTypeForInteger() {
            return PropServerConfiguration.this.integerDefaultColumnType;
        }
    }

    private class PropCairoConfiguration
    implements CairoConfiguration {
        private PropCairoConfiguration() {
        }

        @Override
        public boolean attachPartitionCopy() {
            return PropServerConfiguration.this.cairoAttachPartitionCopy;
        }

        @Override
        public boolean enableTestFactories() {
            return false;
        }

        @Override
        public int getAnalyticColumnPoolCapacity() {
            return PropServerConfiguration.this.sqlAnalyticColumnPoolCapacity;
        }

        @Override
        public String getAttachPartitionSuffix() {
            return PropServerConfiguration.this.cairoAttachPartitionSuffix;
        }

        @Override
        public DateFormat getBackupDirTimestampFormat() {
            return PropServerConfiguration.this.backupDirTimestampFormat;
        }

        @Override
        public int getBackupMkDirMode() {
            return PropServerConfiguration.this.backupMkdirMode;
        }

        @Override
        public CharSequence getBackupRoot() {
            return PropServerConfiguration.this.backupRoot;
        }

        @Override
        public CharSequence getBackupTempDirName() {
            return PropServerConfiguration.this.backupTempDirName;
        }

        @Override
        public int getBinaryEncodingMaxLength() {
            return PropServerConfiguration.this.binaryEncodingMaxLength;
        }

        @Override
        public int getBindVariablePoolSize() {
            return PropServerConfiguration.this.sqlBindVariablePoolSize;
        }

        @Override
        public BuildInformation getBuildInformation() {
            return PropServerConfiguration.this.buildInformation;
        }

        @Override
        public SqlExecutionCircuitBreakerConfiguration getCircuitBreakerConfiguration() {
            return PropServerConfiguration.this.circuitBreakerConfiguration;
        }

        @Override
        public int getColumnCastModelPoolCapacity() {
            return PropServerConfiguration.this.sqlColumnCastModelPoolCapacity;
        }

        @Override
        public int getColumnIndexerQueueCapacity() {
            return PropServerConfiguration.this.columnIndexerQueueCapacity;
        }

        @Override
        public int getColumnPurgeQueueCapacity() {
            return PropServerConfiguration.this.columnPurgeQueueCapacity;
        }

        @Override
        public long getColumnPurgeRetryDelay() {
            return PropServerConfiguration.this.columnPurgeRetryDelay;
        }

        @Override
        public long getColumnPurgeRetryDelayLimit() {
            return PropServerConfiguration.this.columnPurgeRetryDelayLimit;
        }

        @Override
        public double getColumnPurgeRetryDelayMultiplier() {
            return PropServerConfiguration.this.columnPurgeRetryDelayMultiplier;
        }

        @Override
        public int getColumnPurgeTaskPoolCapacity() {
            return PropServerConfiguration.this.columnPurgeTaskPoolCapacity;
        }

        @Override
        public long getCommitLag() {
            return PropServerConfiguration.this.commitLag;
        }

        @Override
        public int getCommitMode() {
            return PropServerConfiguration.this.commitMode;
        }

        @Override
        public CharSequence getConfRoot() {
            return PropServerConfiguration.this.confRoot;
        }

        @Override
        public int getCopyPoolCapacity() {
            return PropServerConfiguration.this.sqlCopyModelPoolCapacity;
        }

        @Override
        public int getCreateAsSelectRetryCount() {
            return PropServerConfiguration.this.createAsSelectRetryCount;
        }

        @Override
        public int getCreateTableModelPoolCapacity() {
            return PropServerConfiguration.this.sqlCreateTableModelPoolCapacity;
        }

        @Override
        public long getDataAppendPageSize() {
            return PropServerConfiguration.this.writerDataAppendPageSize;
        }

        @Override
        public long getDataIndexKeyAppendPageSize() {
            return PropServerConfiguration.this.writerDataIndexKeyAppendPageSize;
        }

        @Override
        public long getDataIndexValueAppendPageSize() {
            return PropServerConfiguration.this.writerDataIndexValueAppendPageSize;
        }

        @Override
        public long getDatabaseIdHi() {
            return PropServerConfiguration.this.instanceHashHi;
        }

        @Override
        public long getDatabaseIdLo() {
            return PropServerConfiguration.this.instanceHashLo;
        }

        @Override
        public CharSequence getDbDirectory() {
            return PropServerConfiguration.this.dbDirectory;
        }

        @Override
        public DateLocale getDefaultDateLocale() {
            return PropServerConfiguration.this.locale;
        }

        @Override
        public CharSequence getDefaultMapType() {
            return PropServerConfiguration.this.defaultMapType;
        }

        @Override
        public boolean getDefaultSymbolCacheFlag() {
            return PropServerConfiguration.this.defaultSymbolCacheFlag;
        }

        @Override
        public int getDefaultSymbolCapacity() {
            return PropServerConfiguration.this.defaultSymbolCapacity;
        }

        @Override
        public int getDoubleToStrCastScale() {
            return PropServerConfiguration.this.sqlDoubleToStrCastScale;
        }

        @Override
        public int getFileOperationRetryCount() {
            return PropServerConfiguration.this.fileOperationRetryCount;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public int getFloatToStrCastScale() {
            return PropServerConfiguration.this.sqlFloatToStrCastScale;
        }

        @Override
        public int getGroupByMapCapacity() {
            return PropServerConfiguration.this.sqlGroupByMapCapacity;
        }

        @Override
        public int getGroupByPoolCapacity() {
            return PropServerConfiguration.this.sqlGroupByPoolCapacity;
        }

        @Override
        public long getIdleCheckInterval() {
            return PropServerConfiguration.this.idleCheckInterval;
        }

        @Override
        public long getInactiveReaderTTL() {
            return PropServerConfiguration.this.inactiveReaderTTL;
        }

        @Override
        public long getInactiveWriterTTL() {
            return PropServerConfiguration.this.inactiveWriterTTL;
        }

        @Override
        public int getIndexValueBlockSize() {
            return PropServerConfiguration.this.indexValueBlockSize;
        }

        @Override
        public int getInsertPoolCapacity() {
            return PropServerConfiguration.this.sqlInsertModelPoolCapacity;
        }

        @Override
        public int getLatestByQueueCapacity() {
            return PropServerConfiguration.this.latestByQueueCapacity;
        }

        @Override
        public int getMaxCrashFiles() {
            return PropServerConfiguration.this.cairoMaxCrashFiles;
        }

        @Override
        public int getMaxFileNameLength() {
            return PropServerConfiguration.this.maxFileNameLength;
        }

        @Override
        public int getMaxSwapFileCount() {
            return PropServerConfiguration.this.maxSwapFileCount;
        }

        @Override
        public int getMaxSymbolNotEqualsCount() {
            return PropServerConfiguration.this.sqlMaxSymbolNotEqualsCount;
        }

        @Override
        public int getMaxUncommittedRows() {
            return PropServerConfiguration.this.maxUncommittedRows;
        }

        @Override
        public MicrosecondClock getMicrosecondClock() {
            return MicrosecondClockImpl.INSTANCE;
        }

        @Override
        public MillisecondClock getMillisecondClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public long getMiscAppendPageSize() {
            return PropServerConfiguration.this.writerMiscAppendPageSize;
        }

        @Override
        public int getMkDirMode() {
            return PropServerConfiguration.this.mkdirMode;
        }

        @Override
        public int getO3CallbackQueueCapacity() {
            return PropServerConfiguration.this.o3CallbackQueueCapacity;
        }

        @Override
        public int getO3ColumnMemorySize() {
            return PropServerConfiguration.this.o3ColumnMemorySize;
        }

        @Override
        public int getO3CopyQueueCapacity() {
            return PropServerConfiguration.this.o3CopyQueueCapacity;
        }

        @Override
        public int getO3OpenColumnQueueCapacity() {
            return PropServerConfiguration.this.o3OpenColumnQueueCapacity;
        }

        @Override
        public int getO3PartitionQueueCapacity() {
            return PropServerConfiguration.this.o3PartitionQueueCapacity;
        }

        @Override
        public int getO3PartitionUpdateQueueCapacity() {
            return PropServerConfiguration.this.o3UpdPartitionSizeQueueCapacity;
        }

        @Override
        public int getO3PurgeDiscoveryQueueCapacity() {
            return PropServerConfiguration.this.o3PurgeDiscoveryQueueCapacity;
        }

        @Override
        public int getPageFrameReduceColumnListCapacity() {
            return PropServerConfiguration.this.cairoPageFrameReduceColumnListCapacity;
        }

        @Override
        public int getPageFrameReduceQueueCapacity() {
            return PropServerConfiguration.this.cairoPageFrameReduceQueueCapacity;
        }

        @Override
        public int getPageFrameReduceRowIdListCapacity() {
            return PropServerConfiguration.this.cairoPageFrameReduceRowIdListCapacity;
        }

        @Override
        public int getPageFrameReduceShardCount() {
            return PropServerConfiguration.this.cairoPageFrameReduceShardCount;
        }

        @Override
        public int getPageFrameReduceTaskPoolCapacity() {
            return PropServerConfiguration.this.cairoPageFrameReduceTaskPoolCapacity;
        }

        @Override
        public int getParallelIndexThreshold() {
            return PropServerConfiguration.this.parallelIndexThreshold;
        }

        @Override
        public int getPartitionPurgeListCapacity() {
            return PropServerConfiguration.this.o3PartitionPurgeListCapacity;
        }

        @Override
        public int getQueryCacheEventQueueCapacity() {
            return PropServerConfiguration.this.queryCacheEventQueueCapacity;
        }

        @Override
        public int getReaderPoolMaxSegments() {
            return PropServerConfiguration.this.readerPoolMaxSegments;
        }

        @Override
        public int getRenameTableModelPoolCapacity() {
            return PropServerConfiguration.this.sqlRenameTableModelPoolCapacity;
        }

        @Override
        public int getReplaceFunctionMaxBufferLength() {
            return PropServerConfiguration.this.replaceFunctionBufferMaxSize;
        }

        @Override
        public int getRndFunctionMemoryMaxPages() {
            return PropServerConfiguration.this.rndFunctionMemoryMaxPages;
        }

        @Override
        public int getRndFunctionMemoryPageSize() {
            return PropServerConfiguration.this.rndFunctionMemoryPageSize;
        }

        @Override
        public CharSequence getRoot() {
            return PropServerConfiguration.this.root;
        }

        @Override
        public int getSampleByIndexSearchPageSize() {
            return PropServerConfiguration.this.sampleByIndexSearchPageSize;
        }

        @Override
        public boolean getSimulateCrashEnabled() {
            return PropServerConfiguration.this.simulateCrashEnabled;
        }

        @Override
        public CharSequence getSnapshotInstanceId() {
            return PropServerConfiguration.this.snapshotInstanceId;
        }

        @Override
        public CharSequence getSnapshotRoot() {
            return PropServerConfiguration.this.snapshotRoot;
        }

        @Override
        public long getSpinLockTimeout() {
            return PropServerConfiguration.this.spinLockTimeout;
        }

        @Override
        public int getSqlAnalyticRowIdMaxPages() {
            return PropServerConfiguration.this.sqlAnalyticRowIdMaxPages;
        }

        @Override
        public int getSqlAnalyticRowIdPageSize() {
            return PropServerConfiguration.this.sqlAnalyticRowIdPageSize;
        }

        @Override
        public int getSqlAnalyticStoreMaxPages() {
            return PropServerConfiguration.this.sqlAnalyticStoreMaxPages;
        }

        @Override
        public int getSqlAnalyticStorePageSize() {
            return PropServerConfiguration.this.sqlAnalyticStorePageSize;
        }

        @Override
        public int getSqlAnalyticTreeKeyMaxPages() {
            return PropServerConfiguration.this.sqlAnalyticTreeKeyMaxPages;
        }

        @Override
        public int getSqlAnalyticTreeKeyPageSize() {
            return PropServerConfiguration.this.sqlAnalyticTreeKeyPageSize;
        }

        @Override
        public int getSqlCharacterStoreCapacity() {
            return PropServerConfiguration.this.sqlCharacterStoreCapacity;
        }

        @Override
        public int getSqlCharacterStoreSequencePoolCapacity() {
            return PropServerConfiguration.this.sqlCharacterStoreSequencePoolCapacity;
        }

        @Override
        public int getSqlColumnPoolCapacity() {
            return PropServerConfiguration.this.sqlColumnPoolCapacity;
        }

        @Override
        public double getSqlCompactMapLoadFactor() {
            return PropServerConfiguration.this.sqlCompactMapLoadFactor;
        }

        @Override
        public int getSqlCopyBufferSize() {
            return PropServerConfiguration.this.sqlCopyBufferSize;
        }

        @Override
        public CharSequence getSqlCopyInputRoot() {
            return PropServerConfiguration.this.cairoSqlCopyRoot;
        }

        @Override
        public CharSequence getSqlCopyInputWorkRoot() {
            return PropServerConfiguration.this.cairoSqlCopyWorkRoot;
        }

        @Override
        public int getSqlCopyLogRetentionDays() {
            return PropServerConfiguration.this.cairoSqlCopyLogRetentionDays;
        }

        @Override
        public long getSqlCopyMaxIndexChunkSize() {
            return PropServerConfiguration.this.cairoSqlCopyMaxIndexChunkSize;
        }

        @Override
        public int getSqlCopyQueueCapacity() {
            return PropServerConfiguration.this.cairoSqlCopyQueueCapacity;
        }

        @Override
        public int getSqlDistinctTimestampKeyCapacity() {
            return PropServerConfiguration.this.sqlDistinctTimestampKeyCapacity;
        }

        @Override
        public double getSqlDistinctTimestampLoadFactor() {
            return PropServerConfiguration.this.sqlDistinctTimestampLoadFactor;
        }

        @Override
        public int getSqlExpressionPoolCapacity() {
            return PropServerConfiguration.this.sqlExpressionPoolCapacity;
        }

        @Override
        public double getSqlFastMapLoadFactor() {
            return PropServerConfiguration.this.sqlFastMapLoadFactor;
        }

        @Override
        public int getSqlHashJoinLightValueMaxPages() {
            return PropServerConfiguration.this.sqlHashJoinLightValueMaxPages;
        }

        @Override
        public int getSqlHashJoinLightValuePageSize() {
            return PropServerConfiguration.this.sqlHashJoinLightValuePageSize;
        }

        @Override
        public int getSqlHashJoinValueMaxPages() {
            return PropServerConfiguration.this.sqlHashJoinValueMaxPages;
        }

        @Override
        public int getSqlHashJoinValuePageSize() {
            return PropServerConfiguration.this.sqlHashJoinValuePageSize;
        }

        @Override
        public int getSqlJitBindVarsMemoryMaxPages() {
            return PropServerConfiguration.this.sqlJitBindVarsMemoryMaxPages;
        }

        @Override
        public int getSqlJitBindVarsMemoryPageSize() {
            return PropServerConfiguration.this.sqlJitBindVarsMemoryPageSize;
        }

        @Override
        public int getSqlJitIRMemoryMaxPages() {
            return PropServerConfiguration.this.sqlJitIRMemoryMaxPages;
        }

        @Override
        public int getSqlJitIRMemoryPageSize() {
            return PropServerConfiguration.this.sqlJitIRMemoryPageSize;
        }

        @Override
        public int getSqlJitMode() {
            return PropServerConfiguration.this.sqlJitMode;
        }

        @Override
        public int getSqlJitPageAddressCacheThreshold() {
            return PropServerConfiguration.this.sqlJitPageAddressCacheThreshold;
        }

        @Override
        public int getSqlJitRowsThreshold() {
            return PropServerConfiguration.this.sqlJitRowsThreshold;
        }

        @Override
        public int getSqlJoinContextPoolCapacity() {
            return PropServerConfiguration.this.sqlJoinContextPoolCapacity;
        }

        @Override
        public int getSqlJoinMetadataMaxResizes() {
            return PropServerConfiguration.this.sqlJoinMetadataMaxResizes;
        }

        @Override
        public int getSqlJoinMetadataPageSize() {
            return PropServerConfiguration.this.sqlJoinMetadataPageSize;
        }

        @Override
        public long getSqlLatestByRowCount() {
            return PropServerConfiguration.this.sqlLatestByRowCount;
        }

        @Override
        public int getSqlLexerPoolCapacity() {
            return PropServerConfiguration.this.sqlLexerPoolCapacity;
        }

        @Override
        public int getSqlMapKeyCapacity() {
            return PropServerConfiguration.this.sqlMapKeyCapacity;
        }

        @Override
        public int getSqlMapMaxPages() {
            return PropServerConfiguration.this.sqlMapMaxPages;
        }

        @Override
        public int getSqlMapMaxResizes() {
            return PropServerConfiguration.this.sqlMapMaxResizes;
        }

        @Override
        public int getSqlMapPageSize() {
            return PropServerConfiguration.this.sqlMapPageSize;
        }

        @Override
        public int getSqlMaxNegativeLimit() {
            return PropServerConfiguration.this.sqlMaxNegativeLimit;
        }

        @Override
        public int getSqlModelPoolCapacity() {
            return PropServerConfiguration.this.sqlModelPoolCapacity;
        }

        @Override
        public int getSqlPageFrameMaxRows() {
            return PropServerConfiguration.this.sqlPageFrameMaxRows;
        }

        @Override
        public int getSqlPageFrameMinRows() {
            return PropServerConfiguration.this.sqlPageFrameMinRows;
        }

        @Override
        public int getSqlSmallMapKeyCapacity() {
            return PropServerConfiguration.this.sqlSmallMapKeyCapacity;
        }

        @Override
        public int getSqlSortKeyMaxPages() {
            return PropServerConfiguration.this.sqlSortKeyMaxPages;
        }

        @Override
        public long getSqlSortKeyPageSize() {
            return PropServerConfiguration.this.sqlSortKeyPageSize;
        }

        @Override
        public int getSqlSortLightValueMaxPages() {
            return PropServerConfiguration.this.sqlSortLightValueMaxPages;
        }

        @Override
        public long getSqlSortLightValuePageSize() {
            return PropServerConfiguration.this.sqlSortLightValuePageSize;
        }

        @Override
        public int getSqlSortValueMaxPages() {
            return PropServerConfiguration.this.sqlSortValueMaxPages;
        }

        @Override
        public int getSqlSortValuePageSize() {
            return PropServerConfiguration.this.sqlSortValuePageSize;
        }

        @Override
        public CharSequence getSystemTableNamePrefix() {
            return PropServerConfiguration.this.systemTableNamePrefix;
        }

        @Override
        public TelemetryConfiguration getTelemetryConfiguration() {
            return PropServerConfiguration.this.telemetryConfiguration;
        }

        @Override
        public TextConfiguration getTextConfiguration() {
            return PropServerConfiguration.this.textConfiguration;
        }

        @Override
        public int getTxnScoreboardEntryCount() {
            return PropServerConfiguration.this.sqlTxnScoreboardEntryCount;
        }

        @Override
        public int getVectorAggregateQueueCapacity() {
            return PropServerConfiguration.this.vectorAggregateQueueCapacity;
        }

        @Override
        public boolean getWallEnabledDefault() {
            return PropServerConfiguration.this.walEnabledDefault;
        }

        @Override
        public int getWithClauseModelPoolCapacity() {
            return PropServerConfiguration.this.sqlWithClauseModelPoolCapacity;
        }

        @Override
        public long getWorkStealTimeoutNanos() {
            return PropServerConfiguration.this.workStealTimeoutNanos;
        }

        @Override
        public long getWriterAsyncCommandBusyWaitTimeout() {
            return PropServerConfiguration.this.writerAsyncCommandBusyWaitTimeout;
        }

        @Override
        public long getWriterAsyncCommandMaxTimeout() {
            return PropServerConfiguration.this.writerAsyncCommandMaxWaitTimeout;
        }

        @Override
        public int getWriterCommandQueueCapacity() {
            return PropServerConfiguration.this.writerAsyncCommandQueueCapacity;
        }

        @Override
        public long getWriterCommandQueueSlotSize() {
            return PropServerConfiguration.this.writerAsyncCommandQueueSlotSize;
        }

        @Override
        public long getWriterFileOpenOpts() {
            return PropServerConfiguration.this.writerFileOpenOpts;
        }

        @Override
        public int getWriterTickRowsCountMod() {
            return PropServerConfiguration.this.writerTickRowsCountMod;
        }

        @Override
        public boolean isIOURingEnabled() {
            return PropServerConfiguration.this.ioURingEnabled;
        }

        @Override
        public boolean isO3QuickSortEnabled() {
            return PropServerConfiguration.this.o3QuickSortEnabled;
        }

        @Override
        public boolean isParallelIndexingEnabled() {
            return PropServerConfiguration.this.parallelIndexingEnabled;
        }

        @Override
        public boolean isSnapshotRecoveryEnabled() {
            return PropServerConfiguration.this.snapshotRecoveryEnabled;
        }

        @Override
        public boolean isSqlJitDebugEnabled() {
            return PropServerConfiguration.this.sqlJitDebugEnabled;
        }

        @Override
        public boolean isSqlParallelFilterEnabled() {
            return PropServerConfiguration.this.sqlParallelFilterEnabled;
        }

        @Override
        public boolean isSqlParallelFilterPreTouchEnabled() {
            return PropServerConfiguration.this.sqlParallelFilterPreTouchEnabled;
        }
    }

    private class PropHttpServerConfiguration
    implements HttpServerConfiguration {
        private PropHttpServerConfiguration() {
        }

        @Override
        public IODispatcherConfiguration getDispatcherConfiguration() {
            return PropServerConfiguration.this.httpIODispatcherConfiguration;
        }

        @Override
        public HttpContextConfiguration getHttpContextConfiguration() {
            return PropServerConfiguration.this.httpContextConfiguration;
        }

        @Override
        public JsonQueryProcessorConfiguration getJsonQueryProcessorConfiguration() {
            return PropServerConfiguration.this.jsonQueryProcessorConfiguration;
        }

        @Override
        public boolean isQueryCacheEnabled() {
            return PropServerConfiguration.this.httpSqlCacheEnabled;
        }

        @Override
        public int getQueryCacheBlockCount() {
            return PropServerConfiguration.this.httpSqlCacheBlockCount;
        }

        @Override
        public int getQueryCacheRowCount() {
            return PropServerConfiguration.this.httpSqlCacheRowCount;
        }

        @Override
        public WaitProcessorConfiguration getWaitProcessorConfiguration() {
            return PropServerConfiguration.this.httpWaitProcessorConfiguration;
        }

        @Override
        public StaticContentProcessorConfiguration getStaticContentProcessorConfiguration() {
            return PropServerConfiguration.this.staticContentProcessorConfiguration;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.httpServerEnabled;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.httpWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.httpWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.httpWorkerHaltOnError;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.httpWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.httpWorkerSleepThreshold;
        }

        @Override
        public long getSleepTimeout() {
            return PropServerConfiguration.this.httpWorkerSleepTimeout;
        }
    }

    private class PropHttpContextConfiguration
    implements HttpContextConfiguration {
        private PropHttpContextConfiguration() {
        }

        @Override
        public boolean allowDeflateBeforeSend() {
            return PropServerConfiguration.this.httpAllowDeflateBeforeSend;
        }

        @Override
        public MillisecondClock getClock() {
            return PropServerConfiguration.this.httpFrozenClock ? StationaryMillisClock.INSTANCE : MillisecondClockImpl.INSTANCE;
        }

        @Override
        public int getConnectionPoolInitialCapacity() {
            return PropServerConfiguration.this.connectionPoolInitialCapacity;
        }

        @Override
        public int getConnectionStringPoolCapacity() {
            return PropServerConfiguration.this.connectionStringPoolCapacity;
        }

        @Override
        public boolean getDumpNetworkTraffic() {
            return false;
        }

        @Override
        public String getHttpVersion() {
            return PropServerConfiguration.this.httpVersion;
        }

        @Override
        public int getMultipartHeaderBufferSize() {
            return PropServerConfiguration.this.multipartHeaderBufferSize;
        }

        @Override
        public long getMultipartIdleSpinCount() {
            return PropServerConfiguration.this.multipartIdleSpinCount;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRecvBufferSize() {
            return PropServerConfiguration.this.recvBufferSize;
        }

        @Override
        public int getRequestHeaderBufferSize() {
            return PropServerConfiguration.this.requestHeaderBufferSize;
        }

        @Override
        public int getSendBufferSize() {
            return PropServerConfiguration.this.sendBufferSize;
        }

        @Override
        public boolean getServerKeepAlive() {
            return PropServerConfiguration.this.httpServerKeepAlive;
        }

        @Override
        public boolean readOnlySecurityContext() {
            return PropServerConfiguration.this.httpReadOnlySecurityContext;
        }
    }

    private class PropSqlExecutionCircuitBreakerConfiguration
    implements SqlExecutionCircuitBreakerConfiguration {
        private PropSqlExecutionCircuitBreakerConfiguration() {
        }

        @Override
        public int getBufferSize() {
            return PropServerConfiguration.this.circuitBreakerBufferSize;
        }

        @Override
        public int getCircuitBreakerThrottle() {
            return PropServerConfiguration.this.circuitBreakerThrottle;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.interruptOnClosedConnection;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public long getTimeout() {
            return PropServerConfiguration.this.circuitBreakerTimeout;
        }
    }

    private class PropTextConfiguration
    implements TextConfiguration {
        private PropTextConfiguration() {
        }

        @Override
        public int getDateAdapterPoolCapacity() {
            return PropServerConfiguration.this.dateAdapterPoolCapacity;
        }

        @Override
        public int getJsonCacheLimit() {
            return PropServerConfiguration.this.jsonCacheLimit;
        }

        @Override
        public int getJsonCacheSize() {
            return PropServerConfiguration.this.jsonCacheSize;
        }

        @Override
        public double getMaxRequiredDelimiterStdDev() {
            return PropServerConfiguration.this.maxRequiredDelimiterStdDev;
        }

        @Override
        public double getMaxRequiredLineLengthStdDev() {
            return PropServerConfiguration.this.maxRequiredLineLengthStdDev;
        }

        @Override
        public int getMetadataStringPoolCapacity() {
            return PropServerConfiguration.this.metadataStringPoolCapacity;
        }

        @Override
        public int getRollBufferLimit() {
            return PropServerConfiguration.this.rollBufferLimit;
        }

        @Override
        public int getRollBufferSize() {
            return PropServerConfiguration.this.rollBufferSize;
        }

        @Override
        public int getTextAnalysisMaxLines() {
            return PropServerConfiguration.this.textAnalysisMaxLines;
        }

        @Override
        public int getTextLexerStringPoolCapacity() {
            return PropServerConfiguration.this.textLexerStringPoolCapacity;
        }

        @Override
        public int getTimestampAdapterPoolCapacity() {
            return PropServerConfiguration.this.timestampAdapterPoolCapacity;
        }

        @Override
        public int getUtf8SinkSize() {
            return PropServerConfiguration.this.utf8SinkSize;
        }

        @Override
        public InputFormatConfiguration getInputFormatConfiguration() {
            return PropServerConfiguration.this.inputFormatConfiguration;
        }

        @Override
        public DateLocale getDefaultDateLocale() {
            return PropServerConfiguration.this.locale;
        }
    }

    private class PropHttpMinIODispatcherConfiguration
    implements IODispatcherConfiguration {
        private PropHttpMinIODispatcherConfiguration() {
        }

        @Override
        public int getLimit() {
            return PropServerConfiguration.this.httpMinNetConnectionLimit;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.httpMinBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.httpMinBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public String getDispatcherLogName() {
            return "http-min-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public long getTimeout() {
            return PropServerConfiguration.this.httpMinNetConnectionTimeout;
        }

        @Override
        public int getInitialBias() {
            return 1;
        }

        @Override
        public boolean getHint() {
            return PropServerConfiguration.this.httpMinNetConnectionHint;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRcvBufSize() {
            return PropServerConfiguration.this.httpMinNetConnectionRcvBuf;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSndBufSize() {
            return PropServerConfiguration.this.httpMinNetConnectionSndBuf;
        }

        @Override
        public long getQueueTimeout() {
            return PropServerConfiguration.this.httpMinNetConnectionQueueTimeout;
        }
    }

    private class PropHttpIODispatcherConfiguration
    implements IODispatcherConfiguration {
        private PropHttpIODispatcherConfiguration() {
        }

        @Override
        public int getLimit() {
            return PropServerConfiguration.this.httpNetConnectionLimit;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.httpNetBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.httpNetBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public String getDispatcherLogName() {
            return "http-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public long getTimeout() {
            return PropServerConfiguration.this.httpNetConnectionTimeout;
        }

        @Override
        public int getInitialBias() {
            return 1;
        }

        @Override
        public boolean getHint() {
            return PropServerConfiguration.this.httpNetConnectionHint;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRcvBufSize() {
            return PropServerConfiguration.this.httpNetConnectionRcvBuf;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSndBufSize() {
            return PropServerConfiguration.this.httpNetConnectionSndBuf;
        }

        @Override
        public long getQueueTimeout() {
            return PropServerConfiguration.this.httpNetConnectionQueueTimeout;
        }
    }

    private class PropStaticContentProcessorConfiguration
    implements StaticContentProcessorConfiguration {
        private PropStaticContentProcessorConfiguration() {
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public CharSequence getIndexFileName() {
            return PropServerConfiguration.this.indexFileName;
        }

        @Override
        public MimeTypesCache getMimeTypesCache() {
            return PropServerConfiguration.this.mimeTypesCache;
        }

        @Override
        public CharSequence getPublicDirectory() {
            return PropServerConfiguration.this.publicDirectory;
        }

        @Override
        public String getKeepAliveHeader() {
            return PropServerConfiguration.this.keepAliveHeader;
        }
    }

    static class ValidationResult {
        final boolean isError;
        final String message;

        private ValidationResult(boolean isError, String message) {
            this.isError = isError;
            this.message = message;
        }
    }

    @FunctionalInterface
    protected static interface BindToParser {
        public void onReady(int var1, int var2);
    }
}

