/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cutlass.text.TextImportRequestTask;
import io.questdb.cutlass.text.TextImportTask;
import io.questdb.mp.Barrier;
import io.questdb.mp.FanOut;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SPSequence;
import io.questdb.mp.Sequence;
import io.questdb.std.Misc;
import io.questdb.tasks.ColumnIndexerTask;
import io.questdb.tasks.ColumnPurgeTask;
import io.questdb.tasks.LatestByTask;
import io.questdb.tasks.O3CallbackTask;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionPurgeTask;
import io.questdb.tasks.O3PartitionTask;
import io.questdb.tasks.TableWriterTask;
import io.questdb.tasks.VectorAggregateTask;
import org.jetbrains.annotations.NotNull;

public class MessageBusImpl
implements MessageBus {
    private final CairoConfiguration configuration;
    private final RingQueue<ColumnIndexerTask> indexerQueue;
    private final MPSequence indexerPubSeq;
    private final MCSequence indexerSubSeq;
    private final RingQueue<VectorAggregateTask> vectorAggregateQueue;
    private final MPSequence vectorAggregatePubSeq;
    private final MCSequence vectorAggregateSubSeq;
    private final RingQueue<O3CallbackTask> o3CallbackQueue;
    private final MPSequence o3CallbackPubSeq;
    private final MCSequence o3CallbackSubSeq;
    private final RingQueue<O3PartitionPurgeTask> o3PurgeDiscoveryQueue;
    private final MPSequence o3PurgeDiscoveryPubSeq;
    private final MCSequence o3PurgeDiscoverySubSeq;
    private final RingQueue<O3PartitionTask> o3PartitionQueue;
    private final MPSequence o3PartitionPubSeq;
    private final MCSequence o3PartitionSubSeq;
    private final RingQueue<O3OpenColumnTask> o3OpenColumnQueue;
    private final MPSequence o3OpenColumnPubSeq;
    private final MCSequence o3OpenColumnSubSeq;
    private final RingQueue<O3CopyTask> o3CopyQueue;
    private final MPSequence o3CopyPubSeq;
    private final MCSequence o3CopySubSeq;
    private final RingQueue<LatestByTask> latestByQueue;
    private final MPSequence latestByPubSeq;
    private final MCSequence latestBySubSeq;
    private final RingQueue<TableWriterTask> tableWriterEventQueue;
    private final MPSequence tableWriterEventPubSeq;
    private final FanOut tableWriterEventSubSeq;
    private final MPSequence queryCacheEventPubSeq;
    private final FanOut queryCacheEventSubSeq;
    private final int pageFrameReduceShardCount;
    private final MPSequence[] pageFrameReducePubSeq;
    private final MCSequence[] pageFrameReduceSubSeq;
    private final RingQueue<PageFrameReduceTask>[] pageFrameReduceQueue;
    private final FanOut[] pageFrameCollectFanOut;
    private final RingQueue<ColumnPurgeTask> columnPurgeQueue;
    private final SCSequence columnPurgeSubSeq;
    private final MPSequence columnPurgePubSeq;
    private final RingQueue<TextImportTask> textImportQueue;
    private final SPSequence textImportPubSeq;
    private final MCSequence textImportSubSeq;
    private final SCSequence textImportColSeq;
    private final RingQueue<TextImportRequestTask> textImportRequestQueue;
    private final MPSequence textImportRequestPubSeq;
    private final SCSequence textImportRequestSubSeq;

    public MessageBusImpl(@NotNull CairoConfiguration configuration) {
        this.configuration = configuration;
        this.indexerQueue = new RingQueue<ColumnIndexerTask>(ColumnIndexerTask::new, configuration.getColumnIndexerQueueCapacity());
        this.indexerPubSeq = new MPSequence(this.indexerQueue.getCycle());
        this.indexerSubSeq = new MCSequence(this.indexerQueue.getCycle());
        this.indexerPubSeq.then(this.indexerSubSeq).then(this.indexerPubSeq);
        this.vectorAggregateQueue = new RingQueue<VectorAggregateTask>(VectorAggregateTask::new, configuration.getVectorAggregateQueueCapacity());
        this.vectorAggregatePubSeq = new MPSequence(this.vectorAggregateQueue.getCycle());
        this.vectorAggregateSubSeq = new MCSequence(this.vectorAggregateQueue.getCycle());
        this.vectorAggregatePubSeq.then(this.vectorAggregateSubSeq).then(this.vectorAggregatePubSeq);
        this.o3CallbackQueue = new RingQueue<O3CallbackTask>(O3CallbackTask::new, configuration.getO3CallbackQueueCapacity());
        this.o3CallbackPubSeq = new MPSequence(this.o3CallbackQueue.getCycle());
        this.o3CallbackSubSeq = new MCSequence(this.o3CallbackQueue.getCycle());
        this.o3CallbackPubSeq.then(this.o3CallbackSubSeq).then(this.o3CallbackPubSeq);
        this.o3PartitionQueue = new RingQueue<O3PartitionTask>(O3PartitionTask::new, configuration.getO3PartitionQueueCapacity());
        this.o3PartitionPubSeq = new MPSequence(this.o3PartitionQueue.getCycle());
        this.o3PartitionSubSeq = new MCSequence(this.o3PartitionQueue.getCycle());
        this.o3PartitionPubSeq.then(this.o3PartitionSubSeq).then(this.o3PartitionPubSeq);
        this.o3OpenColumnQueue = new RingQueue<O3OpenColumnTask>(O3OpenColumnTask::new, configuration.getO3OpenColumnQueueCapacity());
        this.o3OpenColumnPubSeq = new MPSequence(this.o3OpenColumnQueue.getCycle());
        this.o3OpenColumnSubSeq = new MCSequence(this.o3OpenColumnQueue.getCycle());
        this.o3OpenColumnPubSeq.then(this.o3OpenColumnSubSeq).then(this.o3OpenColumnPubSeq);
        this.o3CopyQueue = new RingQueue<O3CopyTask>(O3CopyTask::new, configuration.getO3CopyQueueCapacity());
        this.o3CopyPubSeq = new MPSequence(this.o3CopyQueue.getCycle());
        this.o3CopySubSeq = new MCSequence(this.o3CopyQueue.getCycle());
        this.o3CopyPubSeq.then(this.o3CopySubSeq).then(this.o3CopyPubSeq);
        this.o3PurgeDiscoveryQueue = new RingQueue<O3PartitionPurgeTask>(O3PartitionPurgeTask::new, configuration.getO3PurgeDiscoveryQueueCapacity());
        this.o3PurgeDiscoveryPubSeq = new MPSequence(this.o3PurgeDiscoveryQueue.getCycle());
        this.o3PurgeDiscoverySubSeq = new MCSequence(this.o3PurgeDiscoveryQueue.getCycle());
        this.o3PurgeDiscoveryPubSeq.then(this.o3PurgeDiscoverySubSeq).then(this.o3PurgeDiscoveryPubSeq);
        this.latestByQueue = new RingQueue<LatestByTask>(LatestByTask::new, configuration.getLatestByQueueCapacity());
        this.latestByPubSeq = new MPSequence(this.latestByQueue.getCycle());
        this.latestBySubSeq = new MCSequence(this.latestByQueue.getCycle());
        this.latestByPubSeq.then(this.latestBySubSeq).then(this.latestByPubSeq);
        this.tableWriterEventQueue = new RingQueue<TableWriterTask>(TableWriterTask::new, configuration.getWriterCommandQueueSlotSize(), configuration.getWriterCommandQueueCapacity(), 17);
        this.tableWriterEventPubSeq = new MPSequence(this.tableWriterEventQueue.getCycle());
        this.tableWriterEventSubSeq = new FanOut(new Barrier[0]);
        this.tableWriterEventPubSeq.then(this.tableWriterEventSubSeq).then(this.tableWriterEventPubSeq);
        this.queryCacheEventPubSeq = new MPSequence(configuration.getQueryCacheEventQueueCapacity());
        this.queryCacheEventSubSeq = new FanOut(new Barrier[0]);
        this.queryCacheEventPubSeq.then(this.queryCacheEventSubSeq).then(this.queryCacheEventPubSeq);
        this.columnPurgeQueue = new RingQueue<ColumnPurgeTask>(ColumnPurgeTask::new, configuration.getColumnPurgeQueueCapacity());
        this.columnPurgeSubSeq = new SCSequence();
        this.columnPurgePubSeq = new MPSequence(this.columnPurgeQueue.getCycle());
        this.columnPurgePubSeq.then(this.columnPurgeSubSeq).then(this.columnPurgePubSeq);
        this.pageFrameReduceShardCount = configuration.getPageFrameReduceShardCount();
        this.pageFrameReduceQueue = new RingQueue[this.pageFrameReduceShardCount];
        this.pageFrameReducePubSeq = new MPSequence[this.pageFrameReduceShardCount];
        this.pageFrameReduceSubSeq = new MCSequence[this.pageFrameReduceShardCount];
        this.pageFrameCollectFanOut = new FanOut[this.pageFrameReduceShardCount];
        int reduceQueueCapacity = configuration.getPageFrameReduceQueueCapacity();
        for (int i = 0; i < this.pageFrameReduceShardCount; ++i) {
            RingQueue<PageFrameReduceTask> queue = new RingQueue<PageFrameReduceTask>(() -> new PageFrameReduceTask(configuration), reduceQueueCapacity);
            MPSequence reducePubSeq = new MPSequence(reduceQueueCapacity);
            MCSequence reduceSubSeq = new MCSequence(reduceQueueCapacity);
            FanOut collectFanOut = new FanOut(new Barrier[0]);
            reducePubSeq.then(reduceSubSeq).then(collectFanOut).then(reducePubSeq);
            this.pageFrameReduceQueue[i] = queue;
            this.pageFrameReducePubSeq[i] = reducePubSeq;
            this.pageFrameReduceSubSeq[i] = reduceSubSeq;
            this.pageFrameCollectFanOut[i] = collectFanOut;
        }
        this.textImportQueue = new RingQueue<TextImportTask>(TextImportTask::new, configuration.getSqlCopyQueueCapacity());
        this.textImportPubSeq = new SPSequence(this.textImportQueue.getCycle());
        this.textImportSubSeq = new MCSequence(this.textImportQueue.getCycle());
        this.textImportColSeq = new SCSequence();
        this.textImportPubSeq.then(this.textImportSubSeq).then(this.textImportColSeq).then(this.textImportPubSeq);
        this.textImportRequestQueue = new RingQueue<TextImportRequestTask>(TextImportRequestTask::new, 1);
        this.textImportRequestPubSeq = new MPSequence(this.textImportRequestQueue.getCycle());
        this.textImportRequestSubSeq = new SCSequence();
        this.textImportRequestPubSeq.then(this.textImportRequestSubSeq).then(this.textImportRequestPubSeq);
    }

    @Override
    public void close() {
        Misc.free(this.getTableWriterEventQueue());
        Misc.free(this.pageFrameReduceQueue);
    }

    @Override
    public Sequence getColumnPurgePubSeq() {
        return this.columnPurgePubSeq;
    }

    @Override
    public RingQueue<ColumnPurgeTask> getColumnPurgeQueue() {
        return this.columnPurgeQueue;
    }

    @Override
    public SCSequence getColumnPurgeSubSeq() {
        return this.columnPurgeSubSeq;
    }

    @Override
    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Sequence getIndexerPubSequence() {
        return this.indexerPubSeq;
    }

    @Override
    public RingQueue<ColumnIndexerTask> getIndexerQueue() {
        return this.indexerQueue;
    }

    @Override
    public Sequence getIndexerSubSequence() {
        return this.indexerSubSeq;
    }

    @Override
    public Sequence getLatestByPubSeq() {
        return this.latestByPubSeq;
    }

    @Override
    public RingQueue<LatestByTask> getLatestByQueue() {
        return this.latestByQueue;
    }

    @Override
    public Sequence getLatestBySubSeq() {
        return this.latestBySubSeq;
    }

    @Override
    public MPSequence getO3CallbackPubSeq() {
        return this.o3CallbackPubSeq;
    }

    @Override
    public RingQueue<O3CallbackTask> getO3CallbackQueue() {
        return this.o3CallbackQueue;
    }

    @Override
    public MCSequence getO3CallbackSubSeq() {
        return this.o3CallbackSubSeq;
    }

    @Override
    public MPSequence getO3CopyPubSeq() {
        return this.o3CopyPubSeq;
    }

    @Override
    public RingQueue<O3CopyTask> getO3CopyQueue() {
        return this.o3CopyQueue;
    }

    @Override
    public MCSequence getO3CopySubSeq() {
        return this.o3CopySubSeq;
    }

    @Override
    public MPSequence getO3OpenColumnPubSeq() {
        return this.o3OpenColumnPubSeq;
    }

    @Override
    public RingQueue<O3OpenColumnTask> getO3OpenColumnQueue() {
        return this.o3OpenColumnQueue;
    }

    @Override
    public MCSequence getO3OpenColumnSubSeq() {
        return this.o3OpenColumnSubSeq;
    }

    @Override
    public MPSequence getO3PartitionPubSeq() {
        return this.o3PartitionPubSeq;
    }

    @Override
    public RingQueue<O3PartitionTask> getO3PartitionQueue() {
        return this.o3PartitionQueue;
    }

    @Override
    public MCSequence getO3PartitionSubSeq() {
        return this.o3PartitionSubSeq;
    }

    @Override
    public MPSequence getO3PurgeDiscoveryPubSeq() {
        return this.o3PurgeDiscoveryPubSeq;
    }

    @Override
    public RingQueue<O3PartitionPurgeTask> getO3PurgeDiscoveryQueue() {
        return this.o3PurgeDiscoveryQueue;
    }

    @Override
    public MCSequence getO3PurgeDiscoverySubSeq() {
        return this.o3PurgeDiscoverySubSeq;
    }

    @Override
    public FanOut getPageFrameCollectFanOut(int shard) {
        return this.pageFrameCollectFanOut[shard];
    }

    @Override
    public MPSequence getPageFrameReducePubSeq(int shard) {
        return this.pageFrameReducePubSeq[shard];
    }

    @Override
    public RingQueue<PageFrameReduceTask> getPageFrameReduceQueue(int shard) {
        return this.pageFrameReduceQueue[shard];
    }

    @Override
    public int getPageFrameReduceShardCount() {
        return this.pageFrameReduceShardCount;
    }

    @Override
    public MCSequence getPageFrameReduceSubSeq(int shard) {
        return this.pageFrameReduceSubSeq[shard];
    }

    @Override
    public FanOut getTableWriterEventFanOut() {
        return this.tableWriterEventSubSeq;
    }

    @Override
    public MPSequence getTableWriterEventPubSeq() {
        return this.tableWriterEventPubSeq;
    }

    @Override
    public RingQueue<TableWriterTask> getTableWriterEventQueue() {
        return this.tableWriterEventQueue;
    }

    @Override
    public Sequence getVectorAggregatePubSeq() {
        return this.vectorAggregatePubSeq;
    }

    @Override
    public RingQueue<VectorAggregateTask> getVectorAggregateQueue() {
        return this.vectorAggregateQueue;
    }

    @Override
    public Sequence getVectorAggregateSubSeq() {
        return this.vectorAggregateSubSeq;
    }

    @Override
    public MPSequence getQueryCacheEventPubSeq() {
        return this.queryCacheEventPubSeq;
    }

    @Override
    public FanOut getQueryCacheEventFanOut() {
        return this.queryCacheEventSubSeq;
    }

    @Override
    public RingQueue<TextImportTask> getTextImportQueue() {
        return this.textImportQueue;
    }

    @Override
    public Sequence getTextImportPubSeq() {
        return this.textImportPubSeq;
    }

    @Override
    public Sequence getTextImportSubSeq() {
        return this.textImportSubSeq;
    }

    @Override
    public SCSequence getTextImportColSeq() {
        return this.textImportColSeq;
    }

    @Override
    public RingQueue<TextImportRequestTask> getTextImportRequestQueue() {
        return this.textImportRequestQueue;
    }

    @Override
    public MPSequence getTextImportRequestPubSeq() {
        return this.textImportRequestPubSeq;
    }

    @Override
    public Sequence getTextImportRequestSubSeq() {
        return this.textImportRequestSubSeq;
    }
}

