/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.serialization.FlowEncodingVersion;
import org.apache.nifi.controller.serialization.FlowFromDOMFactory;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ControllerServiceLoader {
    private static final Logger logger = LoggerFactory.getLogger(ControllerServiceLoader.class);

    public static Map<ControllerServiceNode, Element> loadControllerServices(List<Element> serviceElements, FlowController controller, ProcessGroup parentGroup, PropertyEncryptor encryptor, FlowEncodingVersion encodingVersion) {
        HashMap<ControllerServiceNode, Element> nodeMap = new HashMap<ControllerServiceNode, Element>();
        for (Element element : serviceElements) {
            ControllerServiceNode serviceNode = ControllerServiceLoader.createControllerService(controller, element, encryptor, encodingVersion);
            if (parentGroup == null) {
                controller.getFlowManager().addRootControllerService(serviceNode);
            } else {
                parentGroup.addControllerService(serviceNode);
            }
            nodeMap.put(serviceNode, (Element)element.cloneNode(true));
        }
        for (Map.Entry entry : nodeMap.entrySet()) {
            ControllerServiceLoader.configureControllerService((ControllerServiceNode)entry.getKey(), (Element)entry.getValue(), encryptor, encodingVersion);
        }
        return nodeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableControllerServices(Map<ControllerServiceNode, Element> nodeMap, FlowController controller, PropertyEncryptor encryptor, boolean autoResumeState, FlowEncodingVersion encodingVersion) {
        if (autoResumeState) {
            HashSet<ControllerServiceNode> nodesToEnable = new HashSet<ControllerServiceNode>();
            for (ControllerServiceNode node : nodeMap.keySet()) {
                ControllerServiceDTO dto;
                Element controllerServiceElement = nodeMap.get(node);
                Document document = controllerServiceElement.getOwnerDocument();
                synchronized (document) {
                    dto = FlowFromDOMFactory.getControllerService(controllerServiceElement, encryptor, encodingVersion);
                }
                ControllerServiceState state = ControllerServiceState.valueOf((String)dto.getState());
                if (state == ControllerServiceState.ENABLED) {
                    nodesToEnable.add(node);
                    logger.debug("Will enable Controller Service {}", (Object)node);
                    continue;
                }
                logger.debug("Will not enable Controller Service {} because its state is set to {}", (Object)node, (Object)state);
            }
            ControllerServiceLoader.enableControllerServices(nodesToEnable, controller, autoResumeState);
        } else {
            logger.debug("Will not enable the following Controller Services because 'auto-resume state' flag is false: {}", nodeMap.keySet());
        }
    }

    public static void enableControllerServices(Collection<ControllerServiceNode> nodesToEnable, FlowController controller, boolean autoResumeState) {
        if (autoResumeState) {
            logger.debug("Enabling Controller Services {}", nodesToEnable);
            nodesToEnable.forEach(ComponentNode::performValidation);
            controller.getControllerServiceProvider().enableControllerServices(nodesToEnable);
        } else {
            logger.debug("Will not enable the following Controller Services because 'auto-resume state' flag is false: {}", nodesToEnable);
        }
    }

    public static ControllerServiceNode cloneControllerService(FlowController flowController, ControllerServiceNode controllerService) {
        UUID id = UUID.nameUUIDFromBytes(controllerService.getIdentifier().getBytes(StandardCharsets.UTF_8));
        ControllerServiceNode clone = flowController.getFlowManager().createControllerService(controllerService.getCanonicalClassName(), id.toString(), controllerService.getBundleCoordinate(), Collections.emptySet(), false, true, null);
        clone.setName(controllerService.getName());
        clone.setComments(controllerService.getComments());
        clone.setBulletinLevel(controllerService.getBulletinLevel());
        if (controllerService.getProperties() != null) {
            HashMap properties = new HashMap();
            for (Map.Entry propEntry : controllerService.getRawPropertyValues().entrySet()) {
                properties.put(((PropertyDescriptor)propEntry.getKey()).getName(), propEntry.getValue());
            }
            clone.setProperties(properties);
        }
        return clone;
    }

    private static ControllerServiceNode createControllerService(FlowController flowController, Element controllerServiceElement, PropertyEncryptor encryptor, FlowEncodingVersion encodingVersion) {
        BundleCoordinate coordinate;
        ControllerServiceDTO dto = FlowFromDOMFactory.getControllerService(controllerServiceElement, encryptor, encodingVersion);
        try {
            coordinate = BundleUtils.getCompatibleBundle(flowController.getExtensionManager(), dto.getType(), dto.getBundle());
        }
        catch (IllegalStateException e) {
            BundleDTO bundleDTO = dto.getBundle();
            coordinate = bundleDTO == null ? BundleCoordinate.UNKNOWN_COORDINATE : new BundleCoordinate(bundleDTO.getGroup(), bundleDTO.getArtifact(), bundleDTO.getVersion());
        }
        ControllerServiceNode node = flowController.getFlowManager().createControllerService(dto.getType(), dto.getId(), coordinate, Collections.emptySet(), false, true, null);
        node.setName(dto.getName());
        node.setComments(dto.getComments());
        if (dto.getBulletinLevel() != null) {
            node.setBulletinLevel(LogLevel.valueOf((String)dto.getBulletinLevel()));
        } else {
            node.setBulletinLevel(LogLevel.WARN);
        }
        node.setVersionedComponentId(dto.getVersionedComponentId());
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureControllerService(ControllerServiceNode node, Element controllerServiceElement, PropertyEncryptor encryptor, FlowEncodingVersion encodingVersion) {
        ControllerServiceDTO dto = FlowFromDOMFactory.getControllerService(controllerServiceElement, encryptor, encodingVersion);
        node.pauseValidationTrigger();
        try {
            node.setAnnotationData(dto.getAnnotationData());
            Set<String> sensitiveDynamicPropertyNames = ControllerServiceLoader.getSensitiveDynamicPropertyNames(dto.getSensitiveDynamicPropertyNames(), node);
            node.setProperties(dto.getProperties(), false, sensitiveDynamicPropertyNames);
        }
        finally {
            node.resumeValidationTrigger();
        }
    }

    private static Set<String> getSensitiveDynamicPropertyNames(Set<String> parsedSensitivePropertyNames, ControllerServiceNode controllerServiceNode) {
        Set<Object> sensitivePropertyNames = parsedSensitivePropertyNames == null ? Collections.emptySet() : parsedSensitivePropertyNames;
        return sensitivePropertyNames.stream().filter(propertyName -> {
            PropertyDescriptor propertyDescriptor = controllerServiceNode.getPropertyDescriptor(propertyName);
            return propertyDescriptor.isDynamic();
        }).collect(Collectors.toSet());
    }
}

