/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.parameter.ParameterSensitivity;
import org.apache.nifi.web.api.entity.Entity;

@XmlType(name="parameterGroupConfiguration")
public class ParameterGroupConfigurationEntity
extends Entity
implements Comparable<ParameterGroupConfigurationEntity> {
    private String groupName;
    private String parameterContextName;
    private Boolean isSynchronized;
    private Map<String, ParameterSensitivity> parameterSensitivities;

    @ApiModelProperty(value="The name of the external parameter group to which the provided parameter names apply.")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @ApiModelProperty(value="The name of the ParameterContext that receives the parameters in this group")
    public String getParameterContextName() {
        return this.parameterContextName;
    }

    public void setParameterContextName(String parameterContextName) {
        this.parameterContextName = parameterContextName;
    }

    @ApiModelProperty(value="All fetched parameter names that should be applied.")
    public Map<String, ParameterSensitivity> getParameterSensitivities() {
        return this.parameterSensitivities;
    }

    public void setParameterSensitivities(Map<String, ParameterSensitivity> parameterSensitivities) {
        this.parameterSensitivities = parameterSensitivities;
    }

    @ApiModelProperty(value="True if this group should be synchronized to a ParameterContext, including creating one if it does not exist.")
    public Boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(Boolean aSynchronized) {
        this.isSynchronized = aSynchronized;
    }

    @Override
    public int compareTo(ParameterGroupConfigurationEntity other) {
        if (other == null) {
            return -1;
        }
        String groupName = this.getGroupName();
        String otherGroupName = other.getGroupName();
        if (groupName == null) {
            return otherGroupName == null ? 0 : -1;
        }
        if (otherGroupName == null) {
            return 1;
        }
        return groupName.compareTo(otherGroupName);
    }
}

