/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime.manifest.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.c2.protocol.component.api.BuildInfo;
import org.apache.nifi.c2.protocol.component.api.Bundle;
import org.apache.nifi.c2.protocol.component.api.ConfigurableComponentDefinition;
import org.apache.nifi.c2.protocol.component.api.ControllerServiceDefinition;
import org.apache.nifi.c2.protocol.component.api.DefinedType;
import org.apache.nifi.c2.protocol.component.api.DynamicRelationship;
import org.apache.nifi.c2.protocol.component.api.ExtensionComponent;
import org.apache.nifi.c2.protocol.component.api.ProcessorDefinition;
import org.apache.nifi.c2.protocol.component.api.PropertyAllowableValue;
import org.apache.nifi.c2.protocol.component.api.PropertyDependency;
import org.apache.nifi.c2.protocol.component.api.PropertyDescriptor;
import org.apache.nifi.c2.protocol.component.api.PropertyResourceDefinition;
import org.apache.nifi.c2.protocol.component.api.Relationship;
import org.apache.nifi.c2.protocol.component.api.ReportingTaskDefinition;
import org.apache.nifi.c2.protocol.component.api.Restriction;
import org.apache.nifi.c2.protocol.component.api.RuntimeManifest;
import org.apache.nifi.c2.protocol.component.api.SchedulingDefaults;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.extension.manifest.AllowableValue;
import org.apache.nifi.extension.manifest.Attribute;
import org.apache.nifi.extension.manifest.DefaultSchedule;
import org.apache.nifi.extension.manifest.DefaultSettings;
import org.apache.nifi.extension.manifest.Dependency;
import org.apache.nifi.extension.manifest.DependentValues;
import org.apache.nifi.extension.manifest.DeprecationNotice;
import org.apache.nifi.extension.manifest.DynamicProperty;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.extension.manifest.ExtensionManifest;
import org.apache.nifi.extension.manifest.InputRequirement;
import org.apache.nifi.extension.manifest.Property;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.extension.manifest.ResourceDefinition;
import org.apache.nifi.extension.manifest.ResourceType;
import org.apache.nifi.extension.manifest.Restricted;
import org.apache.nifi.extension.manifest.Stateful;
import org.apache.nifi.extension.manifest.SystemResourceConsideration;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.runtime.manifest.ComponentManifestBuilder;
import org.apache.nifi.runtime.manifest.ExtensionManifestContainer;
import org.apache.nifi.runtime.manifest.RuntimeManifestBuilder;
import org.apache.nifi.runtime.manifest.impl.StandardComponentManifestBuilder;
import org.apache.nifi.scheduling.SchedulingStrategy;

public class StandardRuntimeManifestBuilder
implements RuntimeManifestBuilder {
    private static final String DEFAULT_YIELD_PERIOD = "1 sec";
    private static final String DEFAULT_PENALIZATION_PERIOD = "30 sec";
    private static final String DEFAULT_BULLETIN_LEVEL = LogLevel.WARN.name();
    private String identifier;
    private String version;
    private String runtimeType;
    private BuildInfo buildInfo;
    private List<Bundle> bundles = new ArrayList<Bundle>();
    private SchedulingDefaults schedulingDefaults;

    @Override
    public RuntimeManifestBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public RuntimeManifestBuilder version(String version) {
        this.version = version;
        return this;
    }

    @Override
    public RuntimeManifestBuilder runtimeType(String runtimeType) {
        this.runtimeType = runtimeType;
        return this;
    }

    @Override
    public RuntimeManifestBuilder buildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
        return this;
    }

    @Override
    public RuntimeManifestBuilder addBundle(ExtensionManifestContainer extensionManifestContainer) {
        if (extensionManifestContainer == null) {
            throw new IllegalArgumentException("Extension manifest container is required");
        }
        ExtensionManifest extensionManifest = extensionManifestContainer.getManifest();
        if (extensionManifest == null) {
            throw new IllegalArgumentException("Extension manifest is required");
        }
        if (extensionManifest.getGroupId() == null || extensionManifest.getGroupId().trim().isEmpty()) {
            throw new IllegalArgumentException("Extension manifest groupId is required");
        }
        if (extensionManifest.getArtifactId() == null || extensionManifest.getArtifactId().trim().isEmpty()) {
            throw new IllegalArgumentException("Extension manifest artifactId is required");
        }
        if (extensionManifest.getVersion() == null || extensionManifest.getVersion().trim().isEmpty()) {
            throw new IllegalArgumentException("Extension manifest version is required");
        }
        Bundle bundle = new Bundle();
        bundle.setGroup(extensionManifest.getGroupId());
        bundle.setArtifact(extensionManifest.getArtifactId());
        bundle.setVersion(extensionManifest.getVersion());
        if (extensionManifest.getExtensions() != null) {
            Map<String, String> additionalDetailsMap = extensionManifestContainer.getAdditionalDetails();
            StandardComponentManifestBuilder componentManifestBuilder = new StandardComponentManifestBuilder();
            extensionManifest.getExtensions().forEach(extension -> {
                String additionalDetails = (String)additionalDetailsMap.get(extension.getName());
                this.addExtension(extensionManifest, (Extension)extension, additionalDetails, componentManifestBuilder);
            });
            bundle.setComponentManifest(componentManifestBuilder.build());
        }
        this.bundles.add(bundle);
        return this;
    }

    @Override
    public RuntimeManifestBuilder addBundles(Iterable<ExtensionManifestContainer> extensionManifests) {
        extensionManifests.forEach(em -> this.addBundle((ExtensionManifestContainer)em));
        return this;
    }

    @Override
    public RuntimeManifestBuilder addBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle is required");
        }
        this.bundles.add(bundle);
        return this;
    }

    @Override
    public RuntimeManifestBuilder schedulingDefaults(SchedulingDefaults schedulingDefaults) {
        this.schedulingDefaults = schedulingDefaults;
        return this;
    }

    @Override
    public RuntimeManifest build() {
        RuntimeManifest runtimeManifest = new RuntimeManifest();
        runtimeManifest.setIdentifier(this.identifier);
        runtimeManifest.setVersion(this.version);
        runtimeManifest.setAgentType(this.runtimeType);
        runtimeManifest.setBuildInfo(this.buildInfo);
        runtimeManifest.setBundles(new ArrayList<Bundle>(this.bundles));
        runtimeManifest.setSchedulingDefaults(this.schedulingDefaults);
        return runtimeManifest;
    }

    private void addExtension(ExtensionManifest extensionManifest, Extension extension, String additionalDetails, ComponentManifestBuilder componentManifestBuilder) {
        if (extension == null) {
            throw new IllegalArgumentException("Extension cannot be null");
        }
        switch (extension.getType()) {
            case PROCESSOR: {
                this.addProcessorDefinition(extensionManifest, extension, additionalDetails, componentManifestBuilder);
                break;
            }
            case CONTROLLER_SERVICE: {
                this.addControllerServiceDefinition(extensionManifest, extension, additionalDetails, componentManifestBuilder);
                break;
            }
            case REPORTING_TASK: {
                this.addReportingTaskDefinition(extensionManifest, extension, additionalDetails, componentManifestBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown extension type: " + extension.getType());
            }
        }
    }

    private void addProcessorDefinition(ExtensionManifest extensionManifest, Extension extension, String additionalDetails, ComponentManifestBuilder componentManifestBuilder) {
        List writesAttributes;
        DefaultSchedule defaultSchedule;
        DefaultSettings defaultSettings;
        ProcessorDefinition processorDefinition = new ProcessorDefinition();
        this.populateDefinedType(extensionManifest, extension, (DefinedType)processorDefinition);
        this.populateExtensionComponent(extensionManifest, extension, additionalDetails, (ExtensionComponent)processorDefinition);
        this.populateConfigurableComponent(extension, (ConfigurableComponentDefinition)processorDefinition);
        processorDefinition.setInputRequirement(this.getInputRequirement(extension.getInputRequirement()));
        processorDefinition.setSupportedRelationships(this.getSupportedRelationships(extension.getRelationships()));
        processorDefinition.setTriggerWhenEmpty(extension.getTriggerWhenEmpty());
        processorDefinition.setTriggerSerially(extension.getTriggerSerially());
        processorDefinition.setTriggerWhenAnyDestinationAvailable(extension.getTriggerWhenAnyDestinationAvailable());
        processorDefinition.setSupportsBatching(extension.getSupportsBatching());
        processorDefinition.setSupportsEventDriven(extension.getEventDriven());
        processorDefinition.setPrimaryNodeOnly(extension.getPrimaryNodeOnly());
        processorDefinition.setSideEffectFree(extension.getSideEffectFree());
        org.apache.nifi.extension.manifest.DynamicRelationship dynamicRelationship = extension.getDynamicRelationship();
        if (dynamicRelationship != null) {
            processorDefinition.setSupportsDynamicRelationships(true);
            processorDefinition.setDynamicRelationship(this.getDynamicRelationship(dynamicRelationship));
        }
        processorDefinition.setDefaultPenaltyDuration((defaultSettings = extension.getDefaultSettings()) == null ? DEFAULT_PENALIZATION_PERIOD : defaultSettings.getPenaltyDuration());
        processorDefinition.setDefaultYieldDuration(defaultSettings == null ? DEFAULT_YIELD_PERIOD : defaultSettings.getYieldDuration());
        processorDefinition.setDefaultBulletinLevel(defaultSettings == null ? DEFAULT_BULLETIN_LEVEL : defaultSettings.getBulletinLevel());
        ArrayList<String> schedulingStrategies = new ArrayList<String>();
        schedulingStrategies.add(SchedulingStrategy.TIMER_DRIVEN.name());
        schedulingStrategies.add(SchedulingStrategy.CRON_DRIVEN.name());
        if (extension.getEventDriven()) {
            schedulingStrategies.add(SchedulingStrategy.EVENT_DRIVEN.name());
        }
        String defaultSchedulingStrategy = (defaultSchedule = extension.getDefaultSchedule()) == null ? SchedulingStrategy.TIMER_DRIVEN.name() : extension.getDefaultSchedule().getStrategy();
        LinkedHashMap<String, Integer> defaultConcurrentTasks = new LinkedHashMap<String, Integer>(3);
        defaultConcurrentTasks.put(SchedulingStrategy.TIMER_DRIVEN.name(), SchedulingStrategy.TIMER_DRIVEN.getDefaultConcurrentTasks());
        defaultConcurrentTasks.put(SchedulingStrategy.CRON_DRIVEN.name(), SchedulingStrategy.CRON_DRIVEN.getDefaultConcurrentTasks());
        if (extension.getEventDriven()) {
            defaultConcurrentTasks.put(SchedulingStrategy.EVENT_DRIVEN.name(), SchedulingStrategy.EVENT_DRIVEN.getDefaultConcurrentTasks());
        }
        LinkedHashMap<String, String> defaultSchedulingPeriods = new LinkedHashMap<String, String>(2);
        defaultSchedulingPeriods.put(SchedulingStrategy.TIMER_DRIVEN.name(), SchedulingStrategy.TIMER_DRIVEN.getDefaultSchedulingPeriod());
        defaultSchedulingPeriods.put(SchedulingStrategy.CRON_DRIVEN.name(), SchedulingStrategy.CRON_DRIVEN.getDefaultSchedulingPeriod());
        if (defaultSchedule != null) {
            defaultSchedulingPeriods.put(defaultSchedule.getStrategy(), defaultSchedule.getPeriod());
            defaultConcurrentTasks.put(defaultSchedule.getStrategy(), Integer.valueOf(defaultSchedule.getConcurrentTasks()));
        }
        processorDefinition.setSupportedSchedulingStrategies(schedulingStrategies);
        processorDefinition.setDefaultSchedulingStrategy(defaultSchedulingStrategy);
        processorDefinition.setDefaultConcurrentTasksBySchedulingStrategy(defaultConcurrentTasks);
        processorDefinition.setDefaultSchedulingPeriodBySchedulingStrategy(defaultSchedulingPeriods);
        List readsAttributes = extension.getReadsAttributes();
        if (this.isNotEmpty(readsAttributes)) {
            processorDefinition.setReadsAttributes(readsAttributes.stream().map(this::getAttribute).collect(Collectors.toList()));
        }
        if (this.isNotEmpty(writesAttributes = extension.getWritesAttributes())) {
            processorDefinition.setWritesAttributes(writesAttributes.stream().map(this::getAttribute).collect(Collectors.toList()));
        }
        componentManifestBuilder.addProcessor(processorDefinition);
    }

    private org.apache.nifi.c2.protocol.component.api.Attribute getAttribute(Attribute attribute) {
        org.apache.nifi.c2.protocol.component.api.Attribute c2Attribute = new org.apache.nifi.c2.protocol.component.api.Attribute();
        c2Attribute.setName(attribute.getName());
        c2Attribute.setDescription(attribute.getDescription());
        return c2Attribute;
    }

    private DynamicRelationship getDynamicRelationship(org.apache.nifi.extension.manifest.DynamicRelationship dynamicRelationship) {
        DynamicRelationship c2DynamicRelationship = new DynamicRelationship();
        c2DynamicRelationship.setName(dynamicRelationship.getName());
        c2DynamicRelationship.setDescription(dynamicRelationship.getDescription());
        return c2DynamicRelationship;
    }

    private InputRequirement.Requirement getInputRequirement(InputRequirement inputRequirement) {
        if (inputRequirement == null) {
            return null;
        }
        switch (inputRequirement) {
            case INPUT_ALLOWED: {
                return InputRequirement.Requirement.INPUT_ALLOWED;
            }
            case INPUT_REQUIRED: {
                return InputRequirement.Requirement.INPUT_REQUIRED;
            }
            case INPUT_FORBIDDEN: {
                return InputRequirement.Requirement.INPUT_FORBIDDEN;
            }
        }
        throw new IllegalArgumentException("Unknown input requirement: " + inputRequirement.name());
    }

    private List<Relationship> getSupportedRelationships(List<org.apache.nifi.extension.manifest.Relationship> relationships) {
        if (relationships == null || relationships.isEmpty()) {
            return null;
        }
        ArrayList<Relationship> componentRelationships = new ArrayList<Relationship>();
        for (org.apache.nifi.extension.manifest.Relationship relationship : relationships) {
            Relationship componentRelationship = new Relationship();
            componentRelationship.setName(relationship.getName());
            componentRelationship.setDescription(relationship.getDescription());
            componentRelationships.add(componentRelationship);
        }
        return componentRelationships;
    }

    private void addControllerServiceDefinition(ExtensionManifest extensionManifest, Extension extension, String additionalDetails, ComponentManifestBuilder componentManifestBuilder) {
        ControllerServiceDefinition controllerServiceDefinition = new ControllerServiceDefinition();
        this.populateDefinedType(extensionManifest, extension, (DefinedType)controllerServiceDefinition);
        this.populateExtensionComponent(extensionManifest, extension, additionalDetails, (ExtensionComponent)controllerServiceDefinition);
        this.populateConfigurableComponent(extension, (ConfigurableComponentDefinition)controllerServiceDefinition);
        componentManifestBuilder.addControllerService(controllerServiceDefinition);
    }

    private void addReportingTaskDefinition(ExtensionManifest extensionManifest, Extension extension, String additionalDetails, ComponentManifestBuilder componentManifestBuilder) {
        ReportingTaskDefinition reportingTaskDefinition = new ReportingTaskDefinition();
        this.populateDefinedType(extensionManifest, extension, (DefinedType)reportingTaskDefinition);
        this.populateExtensionComponent(extensionManifest, extension, additionalDetails, (ExtensionComponent)reportingTaskDefinition);
        this.populateConfigurableComponent(extension, (ConfigurableComponentDefinition)reportingTaskDefinition);
        ArrayList<String> schedulingStrategies = new ArrayList<String>();
        schedulingStrategies.add(SchedulingStrategy.TIMER_DRIVEN.name());
        schedulingStrategies.add(SchedulingStrategy.CRON_DRIVEN.name());
        DefaultSchedule defaultSchedule = extension.getDefaultSchedule();
        String defaultSchedulingStrategy = defaultSchedule == null ? SchedulingStrategy.TIMER_DRIVEN.name() : extension.getDefaultSchedule().getStrategy();
        LinkedHashMap<String, String> defaultSchedulingPeriods = new LinkedHashMap<String, String>(2);
        defaultSchedulingPeriods.put(SchedulingStrategy.TIMER_DRIVEN.name(), SchedulingStrategy.TIMER_DRIVEN.getDefaultSchedulingPeriod());
        defaultSchedulingPeriods.put(SchedulingStrategy.CRON_DRIVEN.name(), SchedulingStrategy.CRON_DRIVEN.getDefaultSchedulingPeriod());
        if (defaultSchedule != null) {
            defaultSchedulingPeriods.put(defaultSchedule.getStrategy(), defaultSchedule.getPeriod());
        }
        reportingTaskDefinition.setSupportedSchedulingStrategies(schedulingStrategies);
        reportingTaskDefinition.setDefaultSchedulingStrategy(defaultSchedulingStrategy);
        reportingTaskDefinition.setDefaultSchedulingPeriodBySchedulingStrategy(defaultSchedulingPeriods);
        componentManifestBuilder.addReportingTask(reportingTaskDefinition);
    }

    private void populateDefinedType(ExtensionManifest extensionManifest, Extension extension, DefinedType definedType) {
        definedType.setType(extension.getName());
        definedType.setTypeDescription(extension.getDescription());
        definedType.setGroup(extensionManifest.getGroupId());
        definedType.setArtifact(extensionManifest.getArtifactId());
        definedType.setVersion(extensionManifest.getVersion());
    }

    private void populateExtensionComponent(ExtensionManifest extensionManifest, Extension extension, String additionalDetails, ExtensionComponent extensionComponent) {
        List systemResourceConsiderations;
        Stateful stateful;
        Restricted restricted;
        List providedServiceApis;
        DeprecationNotice deprecationNotice;
        List seeAlso;
        List tags;
        org.apache.nifi.extension.manifest.BuildInfo buildInfo = extensionManifest.getBuildInfo();
        if (buildInfo != null) {
            BuildInfo componentBuildInfo = new BuildInfo();
            componentBuildInfo.setRevision(buildInfo.getRevision());
            extensionComponent.setBuildInfo(componentBuildInfo);
        }
        if (this.isNotEmpty(tags = extension.getTags())) {
            extensionComponent.setTags(new TreeSet(tags));
        }
        if (this.isNotEmpty(seeAlso = extension.getSeeAlso())) {
            extensionComponent.setSeeAlso(new TreeSet(seeAlso));
        }
        if ((deprecationNotice = extension.getDeprecationNotice()) != null && deprecationNotice.getReason() != null) {
            extensionComponent.setDeprecated(Boolean.valueOf(true));
            extensionComponent.setDeprecationReason(deprecationNotice.getReason());
            List alternatives = deprecationNotice.getAlternatives();
            if (this.isNotEmpty(alternatives)) {
                extensionComponent.setDeprecationAlternatives(new TreeSet(alternatives));
            }
        }
        if (this.isNotEmpty(providedServiceApis = extension.getProvidedServiceAPIs())) {
            ArrayList providedApiTypes = new ArrayList();
            providedServiceApis.forEach(providedServiceApi -> providedApiTypes.add(this.createProvidedApiType((ProvidedServiceAPI)providedServiceApi)));
            extensionComponent.setProvidedApiImplementations(providedApiTypes);
        }
        if ((restricted = extension.getRestricted()) != null) {
            extensionComponent.setRestricted(Boolean.valueOf(true));
            extensionComponent.setRestrictedExplanation(restricted.getGeneralRestrictionExplanation());
            if (restricted.getRestrictions() != null) {
                HashSet explicitRestrictions = new HashSet();
                restricted.getRestrictions().forEach(r -> explicitRestrictions.add(this.createRestriction((org.apache.nifi.extension.manifest.Restriction)r)));
                extensionComponent.setExplicitRestrictions(explicitRestrictions);
            }
        }
        if ((stateful = extension.getStateful()) != null) {
            org.apache.nifi.c2.protocol.component.api.Stateful componentStateful = new org.apache.nifi.c2.protocol.component.api.Stateful();
            componentStateful.setDescription(stateful.getDescription());
            if (stateful.getScopes() != null) {
                componentStateful.setScopes(stateful.getScopes().stream().map(this::getScope).collect(Collectors.toSet()));
                extensionComponent.setStateful(componentStateful);
            }
        }
        if (this.isNotEmpty(systemResourceConsiderations = extension.getSystemResourceConsiderations())) {
            extensionComponent.setSystemResourceConsiderations(systemResourceConsiderations.stream().map(this::getSystemResourceConsideration).collect(Collectors.toList()));
        }
        if (additionalDetails != null) {
            extensionComponent.setAdditionalDetails(true);
        }
    }

    private org.apache.nifi.c2.protocol.component.api.SystemResourceConsideration getSystemResourceConsideration(SystemResourceConsideration systemResourceConsideration) {
        org.apache.nifi.c2.protocol.component.api.SystemResourceConsideration c2consideration = new org.apache.nifi.c2.protocol.component.api.SystemResourceConsideration();
        c2consideration.setResource(systemResourceConsideration.getResource());
        c2consideration.setDescription(systemResourceConsideration.getDescription());
        return c2consideration;
    }

    private Scope getScope(org.apache.nifi.extension.manifest.Scope sourceScope) {
        switch (sourceScope) {
            case LOCAL: {
                return Scope.LOCAL;
            }
            case CLUSTER: {
                return Scope.CLUSTER;
            }
        }
        throw new IllegalArgumentException("Unknown scope: " + sourceScope);
    }

    private Restriction createRestriction(org.apache.nifi.extension.manifest.Restriction extensionRestriction) {
        Restriction restriction = new Restriction();
        restriction.setExplanation(extensionRestriction.getExplanation());
        restriction.setRequiredPermission(extensionRestriction.getRequiredPermission());
        return restriction;
    }

    private DefinedType createProvidedApiType(ProvidedServiceAPI providedServiceApi) {
        DefinedType providedApiType = new DefinedType();
        providedApiType.setType(providedServiceApi.getClassName());
        providedApiType.setGroup(providedServiceApi.getGroupId());
        providedApiType.setArtifact(providedServiceApi.getArtifactId());
        providedApiType.setVersion(providedServiceApi.getVersion());
        return providedApiType;
    }

    private void populateConfigurableComponent(Extension extension, ConfigurableComponentDefinition configurableComponentDefinition) {
        List dynamicProperties;
        List properties = extension.getProperties();
        if (this.isNotEmpty(properties)) {
            LinkedHashMap propertyDescriptors = new LinkedHashMap();
            properties.forEach(property -> this.addPropertyDescriptor(propertyDescriptors, (Property)property));
            configurableComponentDefinition.setPropertyDescriptors(propertyDescriptors);
        }
        if (this.isNotEmpty(dynamicProperties = extension.getDynamicProperties())) {
            configurableComponentDefinition.setSupportsDynamicProperties(true);
            configurableComponentDefinition.setDynamicProperties(dynamicProperties.stream().map(this::getDynamicProperty).collect(Collectors.toList()));
        }
    }

    private org.apache.nifi.c2.protocol.component.api.DynamicProperty getDynamicProperty(DynamicProperty dynamicProperty) {
        org.apache.nifi.c2.protocol.component.api.DynamicProperty c2DynamicProperty = new org.apache.nifi.c2.protocol.component.api.DynamicProperty();
        c2DynamicProperty.setName(dynamicProperty.getName());
        c2DynamicProperty.setValue(dynamicProperty.getValue());
        c2DynamicProperty.setDescription(dynamicProperty.getDescription());
        c2DynamicProperty.setExpressionLanguageScope(this.getELScope(dynamicProperty.getExpressionLanguageScope()));
        return c2DynamicProperty;
    }

    private void addPropertyDescriptor(Map<String, PropertyDescriptor> propertyDescriptors, Property property) {
        PropertyDescriptor propertyDescriptor = this.createPropertyDescriptor(property);
        propertyDescriptors.put(propertyDescriptor.getName(), propertyDescriptor);
    }

    private PropertyDescriptor createPropertyDescriptor(Property property) {
        PropertyDescriptor descriptor = new PropertyDescriptor();
        descriptor.setName(property.getName());
        descriptor.setDisplayName(property.getDisplayName());
        descriptor.setDescription(property.getDescription());
        descriptor.setDefaultValue(property.getDefaultValue());
        descriptor.setRequired(property.isRequired());
        descriptor.setSensitive(property.isSensitive());
        descriptor.setExpressionLanguageScope(this.getELScope(property.getExpressionLanguageScope()));
        descriptor.setDynamic(property.isDynamic());
        descriptor.setAllowableValues(this.getPropertyAllowableValues(property.getAllowableValues()));
        descriptor.setTypeProvidedByValue(this.getControllerServiceDefinedType(property.getControllerServiceDefinition()));
        descriptor.setResourceDefinition(this.getPropertyResourceDefinition(property.getResourceDefinition()));
        descriptor.setDependencies(this.getPropertyDependencies(property.getDependencies()));
        return descriptor;
    }

    private List<PropertyDependency> getPropertyDependencies(List<Dependency> dependencies) {
        if (dependencies == null || dependencies.isEmpty()) {
            return null;
        }
        ArrayList<PropertyDependency> propertyDependencies = new ArrayList<PropertyDependency>(dependencies.size());
        for (Dependency dependency : dependencies) {
            PropertyDependency propertyDependency = new PropertyDependency();
            propertyDependency.setPropertyName(dependency.getPropertyName());
            propertyDependency.setPropertyDisplayName(dependency.getPropertyDisplayName());
            DependentValues dependentValues = dependency.getDependentValues();
            if (dependentValues != null && dependentValues.getValues() != null) {
                ArrayList values = new ArrayList();
                values.addAll(dependentValues.getValues());
                propertyDependency.setDependentValues(values);
            }
            propertyDependencies.add(propertyDependency);
        }
        return propertyDependencies;
    }

    private PropertyResourceDefinition getPropertyResourceDefinition(ResourceDefinition resourceDefinition) {
        if (resourceDefinition == null || resourceDefinition.getCardinality() == null) {
            return null;
        }
        PropertyResourceDefinition propertyResourceDefinition = new PropertyResourceDefinition();
        switch (resourceDefinition.getCardinality()) {
            case SINGLE: {
                propertyResourceDefinition.setCardinality(ResourceCardinality.SINGLE);
                break;
            }
            case MULTIPLE: {
                propertyResourceDefinition.setCardinality(ResourceCardinality.MULTIPLE);
            }
        }
        propertyResourceDefinition.setResourceTypes(resourceDefinition.getResourceTypes().stream().map(rt -> this.getResourceType((ResourceType)rt)).collect(Collectors.toSet()));
        return propertyResourceDefinition;
    }

    private org.apache.nifi.components.resource.ResourceType getResourceType(ResourceType resourceType) {
        switch (resourceType) {
            case URL: {
                return org.apache.nifi.components.resource.ResourceType.URL;
            }
            case FILE: {
                return org.apache.nifi.components.resource.ResourceType.FILE;
            }
            case TEXT: {
                return org.apache.nifi.components.resource.ResourceType.TEXT;
            }
            case DIRECTORY: {
                return org.apache.nifi.components.resource.ResourceType.DIRECTORY;
            }
        }
        throw new IllegalArgumentException("Unknown resource type: " + resourceType);
    }

    private ExpressionLanguageScope getELScope(org.apache.nifi.extension.manifest.ExpressionLanguageScope elScope) {
        if (elScope == null) {
            return null;
        }
        switch (elScope) {
            case NONE: {
                return ExpressionLanguageScope.NONE;
            }
            case FLOWFILE_ATTRIBUTES: {
                return ExpressionLanguageScope.FLOWFILE_ATTRIBUTES;
            }
            case VARIABLE_REGISTRY: {
                return ExpressionLanguageScope.VARIABLE_REGISTRY;
            }
        }
        throw new IllegalArgumentException("Unknown Expression Language Scope: " + elScope.name());
    }

    private List<PropertyAllowableValue> getPropertyAllowableValues(List<AllowableValue> allowableValues) {
        if (allowableValues == null || allowableValues.isEmpty()) {
            return null;
        }
        ArrayList<PropertyAllowableValue> propertyAllowableValues = new ArrayList<PropertyAllowableValue>();
        for (AllowableValue allowableValue : allowableValues) {
            PropertyAllowableValue propertyAllowableValue = new PropertyAllowableValue();
            propertyAllowableValue.setValue(allowableValue.getValue());
            propertyAllowableValue.setDisplayName(allowableValue.getDisplayName());
            propertyAllowableValue.setDescription(allowableValue.getDescription());
            propertyAllowableValues.add(propertyAllowableValue);
        }
        return propertyAllowableValues;
    }

    private DefinedType getControllerServiceDefinedType(org.apache.nifi.extension.manifest.ControllerServiceDefinition controllerServiceDefinition) {
        if (controllerServiceDefinition == null) {
            return null;
        }
        DefinedType serviceDefinitionType = new DefinedType();
        serviceDefinitionType.setType(controllerServiceDefinition.getClassName());
        serviceDefinitionType.setGroup(controllerServiceDefinition.getGroupId());
        serviceDefinitionType.setArtifact(controllerServiceDefinition.getArtifactId());
        serviceDefinitionType.setVersion(controllerServiceDefinition.getVersion());
        return serviceDefinitionType;
    }

    private <T> boolean isNotEmpty(Collection<T> collection) {
        return collection != null && !collection.isEmpty();
    }
}

