/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import org.apache.nifi.authorization.resource.ComponentAuthorizable;
import org.apache.nifi.components.VersionedComponent;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Positionable;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.Triggerable;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.groups.BatchCounts;
import org.apache.nifi.groups.DataValve;
import org.apache.nifi.groups.FlowFileConcurrency;
import org.apache.nifi.groups.FlowFileGate;
import org.apache.nifi.groups.FlowFileOutboundPolicy;
import org.apache.nifi.groups.FlowSynchronizationOptions;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterUpdate;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.mapping.FlowMappingOptions;
import org.apache.nifi.remote.RemoteGroupPort;

public interface ProcessGroup
extends ComponentAuthorizable,
Positionable,
VersionedComponent {
    public static final Predicate<ProcessorNode> START_PROCESSORS_FILTER = node -> !node.isRunning() && !ScheduledState.DISABLED.equals((Object)node.getScheduledState()) && node.getValidationStatus() == ValidationStatus.VALID;
    public static final Predicate<ProcessorNode> STOP_PROCESSORS_FILTER = Triggerable::isRunning;
    public static final Predicate<ProcessorNode> ENABLE_PROCESSORS_FILTER = node -> ScheduledState.DISABLED.equals((Object)node.getScheduledState());
    public static final Predicate<ProcessorNode> DISABLE_PROCESSORS_FILTER = node -> !node.isRunning() && !ScheduledState.DISABLED.equals((Object)node.getScheduledState());
    public static final Predicate<Port> START_PORTS_FILTER = port -> !port.isRunning() && !ScheduledState.DISABLED.equals((Object)port.getScheduledState()) && port.isValid();
    public static final Predicate<Port> STOP_PORTS_FILTER = port -> ScheduledState.RUNNING.equals((Object)port.getScheduledState());
    public static final Predicate<Port> ENABLE_PORTS_FILTER = port -> ScheduledState.DISABLED.equals((Object)port.getScheduledState());
    public static final Predicate<Port> DISABLE_PORTS_FILTER = port -> !port.isRunning() && !ScheduledState.DISABLED.equals((Object)port.getScheduledState());

    public ProcessGroup getParent();

    public void setParent(ProcessGroup var1);

    public String getIdentifier();

    public String getName();

    public void setName(String var1);

    public String getComments();

    public void setComments(String var1);

    public ProcessGroupCounts getCounts();

    public void startProcessing();

    public void stopProcessing();

    public void enableProcessor(ProcessorNode var1);

    public void enableInputPort(Port var1);

    public void enableOutputPort(Port var1);

    public void enableAllControllerServices();

    public Future<Void> startProcessor(ProcessorNode var1, boolean var2);

    public Future<Void> runProcessorOnce(ProcessorNode var1, Callable<Future<Void>> var2);

    public void startInputPort(Port var1);

    public void startOutputPort(Port var1);

    public void startFunnel(Funnel var1);

    public Future<Void> stopProcessor(ProcessorNode var1);

    public void terminateProcessor(ProcessorNode var1);

    public void stopInputPort(Port var1);

    public void stopOutputPort(Port var1);

    public void disableProcessor(ProcessorNode var1);

    public void disableInputPort(Port var1);

    public void disableOutputPort(Port var1);

    public void shutdown();

    public boolean isRootGroup();

    public void addInputPort(Port var1);

    public void removeInputPort(Port var1);

    public Set<Port> getInputPorts();

    public Port getInputPort(String var1);

    public void addOutputPort(Port var1);

    public void removeOutputPort(Port var1);

    public Port getOutputPort(String var1);

    public Set<Port> getOutputPorts();

    public void addProcessGroup(ProcessGroup var1);

    public ProcessGroup getProcessGroup(String var1);

    public Set<ProcessGroup> getProcessGroups();

    public void removeProcessGroup(ProcessGroup var1);

    public void addProcessor(ProcessorNode var1);

    public void removeProcessor(ProcessorNode var1);

    public Collection<ProcessorNode> getProcessors();

    public ProcessorNode getProcessor(String var1);

    public Connectable getConnectable(String var1);

    public void addConnection(Connection var1);

    public void removeConnection(Connection var1);

    public void inheritConnection(Connection var1);

    public Connection getConnection(String var1);

    public Set<Connection> getConnections();

    public Connection findConnection(String var1);

    public List<Connection> findAllConnections();

    public DropFlowFileStatus dropAllFlowFiles(String var1, String var2);

    public DropFlowFileStatus getDropAllFlowFilesStatus(String var1);

    public DropFlowFileStatus cancelDropAllFlowFiles(String var1);

    public Funnel findFunnel(String var1);

    public Set<String> getAncestorServiceIds();

    public ControllerServiceNode findControllerService(String var1, boolean var2, boolean var3);

    public Set<ControllerServiceNode> findAllControllerServices();

    public void addRemoteProcessGroup(RemoteProcessGroup var1);

    public void removeRemoteProcessGroup(RemoteProcessGroup var1);

    public RemoteProcessGroup getRemoteProcessGroup(String var1);

    public Set<RemoteProcessGroup> getRemoteProcessGroups();

    public void addLabel(Label var1);

    public void removeLabel(Label var1);

    public Set<Label> getLabels();

    public Label getLabel(String var1);

    public ProcessGroup findProcessGroup(String var1);

    public List<ProcessGroup> findAllProcessGroups();

    public List<ProcessGroup> findAllProcessGroups(Predicate<ProcessGroup> var1);

    public RemoteProcessGroup findRemoteProcessGroup(String var1);

    public List<RemoteProcessGroup> findAllRemoteProcessGroups();

    public ProcessorNode findProcessor(String var1);

    public List<ProcessorNode> findAllProcessors();

    public Label findLabel(String var1);

    public List<Label> findAllLabels();

    public Port findInputPort(String var1);

    public List<Port> findAllInputPorts();

    public Port getInputPortByName(String var1);

    public Port findOutputPort(String var1);

    public List<Port> findAllOutputPorts();

    public Port getOutputPortByName(String var1);

    public void addFunnel(Funnel var1);

    public void addFunnel(Funnel var1, boolean var2);

    public Set<Funnel> getFunnels();

    public Funnel getFunnel(String var1);

    public void removeFunnel(Funnel var1);

    public List<Funnel> findAllFunnels();

    public void addControllerService(ControllerServiceNode var1);

    public ControllerServiceNode getControllerService(String var1);

    public Set<ControllerServiceNode> getControllerServices(boolean var1);

    public void removeControllerService(ControllerServiceNode var1);

    public boolean isEmpty();

    public void remove(Snippet var1);

    public RemoteGroupPort findRemoteGroupPort(String var1);

    public Set<Positionable> findAllPositionables();

    public void move(Snippet var1, ProcessGroup var2);

    public void updateFlow(VersionedExternalFlow var1, String var2, boolean var3, boolean var4, boolean var5);

    public void synchronizeFlow(VersionedExternalFlow var1, FlowSynchronizationOptions var2, FlowMappingOptions var3);

    public void verifyCanAddTemplate(String var1);

    public void verifyCanDelete();

    public void verifyCanDelete(boolean var1);

    public void verifyCanDelete(boolean var1, boolean var2);

    public void verifyCanStart(Connectable var1);

    public void verifyCanStart();

    public void verifyCanStop(Connectable var1);

    public void verifyCanStop();

    public void verifyCanDelete(Snippet var1);

    public void verifyCanMove(Snippet var1, ProcessGroup var2);

    public void verifyCanUpdateVariables(Map<String, String> var1);

    public void verifyCanUpdate(VersionedExternalFlow var1, boolean var2, boolean var3);

    public void verifyCanRevertLocalModifications();

    public void verifyCanShowLocalModifications();

    public void verifyCanSaveToFlowRegistry(String var1, String var2, String var3, String var4);

    public void addTemplate(Template var1);

    public void removeTemplate(Template var1);

    public Template getTemplate(String var1);

    public Template findTemplate(String var1);

    public Set<Template> getTemplates();

    public Set<Template> findAllTemplates();

    public void setVariables(Map<String, String> var1);

    public ComponentVariableRegistry getVariableRegistry();

    public Set<ComponentNode> getComponentsAffectedByVariable(String var1);

    public VersionControlInformation getVersionControlInformation();

    public void setVersionControlInformation(VersionControlInformation var1, Map<String, String> var2);

    public void disconnectVersionControl(boolean var1);

    public void synchronizeWithFlowRegistry(FlowManager var1);

    public void onComponentModified();

    public void setParameterContext(ParameterContext var1);

    public ParameterContext getParameterContext();

    public void verifyCanSetParameterContext(ParameterContext var1);

    public void onParameterContextUpdated(Map<String, ParameterUpdate> var1);

    public FlowFileGate getFlowFileGate();

    public FlowFileConcurrency getFlowFileConcurrency();

    public void setFlowFileConcurrency(FlowFileConcurrency var1);

    public FlowFileOutboundPolicy getFlowFileOutboundPolicy();

    public void setFlowFileOutboundPolicy(FlowFileOutboundPolicy var1);

    public boolean isDataQueued();

    public boolean isDataQueuedForProcessing();

    public BatchCounts getBatchCounts();

    public DataValve getDataValve(Port var1);

    public DataValve getDataValve();

    public boolean referencesParameterContext(ParameterContext var1);

    public String getDefaultFlowFileExpiration();

    public void setDefaultFlowFileExpiration(String var1);

    public Long getDefaultBackPressureObjectThreshold();

    public void setDefaultBackPressureObjectThreshold(Long var1);

    public String getDefaultBackPressureDataSizeThreshold();

    public void setDefaultBackPressureDataSizeThreshold(String var1);

    public QueueSize getQueueSize();
}

