/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.connectable;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.authorization.resource.ComponentAuthorizable;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.VersionedComponent;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Positionable;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.Triggerable;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.scheduling.SchedulingStrategy;

public interface Connectable
extends Triggerable,
ComponentAuthorizable,
Positionable,
VersionedComponent {
    public String getIdentifier();

    public Collection<Relationship> getRelationships();

    public Relationship getRelationship(String var1);

    public void addConnection(Connection var1) throws IllegalArgumentException;

    public boolean hasIncomingConnection();

    public void removeConnection(Connection var1) throws IllegalStateException;

    public void updateConnection(Connection var1) throws IllegalStateException;

    public List<Connection> getIncomingConnections();

    public Set<Connection> getConnections();

    public Set<Connection> getConnections(Relationship var1);

    public String getName();

    public void setName(String var1);

    public String getComments();

    public void setComments(String var1);

    public boolean isTriggerWhenEmpty();

    public ProcessGroup getProcessGroup();

    public void setProcessGroup(ProcessGroup var1);

    public boolean isAutoTerminated(Relationship var1);

    public boolean isLossTolerant();

    public void setLossTolerant(boolean var1);

    public ConnectableType getConnectableType();

    public Collection<ValidationResult> getValidationErrors();

    public long getPenalizationPeriod(TimeUnit var1);

    public String getPenalizationPeriod();

    public long getYieldPeriod(TimeUnit var1);

    public String getYieldPeriod();

    public void setYieldPeriod(String var1);

    public void setPenalizationPeriod(String var1);

    public void yield();

    public void yield(long var1, TimeUnit var3);

    public long getYieldExpiration();

    public boolean isSideEffectFree();

    default public boolean isIsolated() {
        return false;
    }

    default public boolean isTriggerWhenAnyDestinationAvailable() {
        return false;
    }

    default public long getRunDuration(TimeUnit timeUnit) {
        return 0L;
    }

    default public Object getRunnableComponent() {
        return this;
    }

    default public boolean isSessionBatchingSupported() {
        return false;
    }

    public void verifyCanDelete() throws IllegalStateException;

    public void verifyCanDelete(boolean var1) throws IllegalStateException;

    public void verifyCanStart() throws IllegalStateException;

    public void verifyCanStop() throws IllegalStateException;

    public void verifyCanUpdate() throws IllegalStateException;

    public void verifyCanEnable() throws IllegalStateException;

    public void verifyCanDisable() throws IllegalStateException;

    public void verifyCanClearState() throws IllegalStateException;

    public SchedulingStrategy getSchedulingStrategy();

    public String getComponentType();

    public int getRetryCount();

    public void setRetryCount(Integer var1);

    public Set<String> getRetriedRelationships();

    public void setRetriedRelationships(Set<String> var1);

    public boolean isRelationshipRetried(Relationship var1);

    public BackoffMechanism getBackoffMechanism();

    public void setBackoffMechanism(BackoffMechanism var1);

    public String getMaxBackoffPeriod();

    public void setMaxBackoffPeriod(String var1);

    public String evaluateParameters(String var1);
}

