/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedLabel;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedComponent;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedControllerService;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessor;

public class FlowDifferenceFilters {
    public static Predicate<FlowDifference> FILTER_PUBLIC_PORT_NAME_CHANGES = fd -> !FlowDifferenceFilters.isPublicPortNameChange(fd);
    public static Predicate<FlowDifference> FILTER_ADDED_REMOVED_REMOTE_PORTS = fd -> !FlowDifferenceFilters.isAddedOrRemovedRemotePort(fd);
    public static Predicate<FlowDifference> FILTER_IGNORABLE_VERSIONED_FLOW_COORDINATE_CHANGES = fd -> !FlowDifferenceFilters.isIgnorableVersionedFlowCoordinateChange(fd);

    public static boolean isEnvironmentalChange(FlowDifference difference, VersionedProcessGroup localGroup, FlowManager flowManager) {
        return difference.getDifferenceType() == DifferenceType.BUNDLE_CHANGED || FlowDifferenceFilters.isVariableValueChange(difference) || FlowDifferenceFilters.isAncestorVariableAdded(difference, flowManager) || FlowDifferenceFilters.isRpgUrlChange(difference) || FlowDifferenceFilters.isAddedOrRemovedRemotePort(difference) || FlowDifferenceFilters.isPublicPortNameChange(difference) || FlowDifferenceFilters.isIgnorableVersionedFlowCoordinateChange(difference) || FlowDifferenceFilters.isNewPropertyWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isNewRelationshipAutoTerminatedAndDefaulted(difference, localGroup, flowManager) || FlowDifferenceFilters.isScheduledStateNew(difference) || FlowDifferenceFilters.isLocalScheduleStateChange(difference) || FlowDifferenceFilters.isPropertyMissingFromGhostComponent(difference, flowManager) || FlowDifferenceFilters.isNewRetryConfigWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isNewZIndexLabelConfigWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isNewZIndexConnectionConfigWithDefaultValue(difference, flowManager) || FlowDifferenceFilters.isRegistryUrlChange(difference) || FlowDifferenceFilters.isParameterContextChange(difference);
    }

    private static boolean isRegistryUrlChange(FlowDifference difference) {
        if (difference.getDifferenceType() != DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED) {
            return false;
        }
        if (!(difference.getValueA() instanceof VersionedFlowCoordinates)) {
            return false;
        }
        if (!(difference.getValueB() instanceof VersionedFlowCoordinates)) {
            return false;
        }
        VersionedFlowCoordinates coordinatesA = (VersionedFlowCoordinates)difference.getValueA();
        VersionedFlowCoordinates coordinatesB = (VersionedFlowCoordinates)difference.getValueB();
        return Objects.equals(coordinatesA.getBucketId(), coordinatesB.getBucketId()) && Objects.equals(coordinatesA.getFlowId(), coordinatesB.getFlowId()) && Objects.equals(coordinatesA.getVersion(), coordinatesB.getVersion());
    }

    public static boolean isPublicPortNameChange(FlowDifference fd) {
        VersionedPort versionedPort;
        VersionedComponent versionedComponent = fd.getComponentA();
        return fd.getDifferenceType() == DifferenceType.NAME_CHANGED && versionedComponent instanceof VersionedPort && (versionedPort = (VersionedPort)versionedComponent).isAllowRemoteAccess() != false;
    }

    public static boolean isAddedOrRemovedRemotePort(FlowDifference fd) {
        if (fd.getDifferenceType() == DifferenceType.COMPONENT_ADDED || fd.getDifferenceType() == DifferenceType.COMPONENT_REMOVED) {
            VersionedComponent component = fd.getComponentA();
            if (component == null || fd.getComponentB() instanceof InstantiatedVersionedComponent) {
                component = fd.getComponentB();
            }
            if (component.getComponentType() == ComponentType.REMOTE_INPUT_PORT || component.getComponentType() == ComponentType.REMOTE_OUTPUT_PORT) {
                return true;
            }
        }
        return false;
    }

    public static boolean isIgnorableVersionedFlowCoordinateChange(FlowDifference fd) {
        if (fd.getDifferenceType() == DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED) {
            VersionedComponent componentA = fd.getComponentA();
            VersionedComponent componentB = fd.getComponentB();
            if (componentA instanceof VersionedProcessGroup && componentB instanceof VersionedProcessGroup) {
                VersionedProcessGroup versionedProcessGroupA = (VersionedProcessGroup)componentA;
                VersionedProcessGroup versionedProcessGroupB = (VersionedProcessGroup)componentB;
                VersionedFlowCoordinates coordinatesA = versionedProcessGroupA.getVersionedFlowCoordinates();
                VersionedFlowCoordinates coordinatesB = versionedProcessGroupB.getVersionedFlowCoordinates();
                if (coordinatesA != null && coordinatesB != null) {
                    String registryUrlA = coordinatesA.getRegistryUrl();
                    String registryUrlB = coordinatesB.getRegistryUrl();
                    if (registryUrlA != null && registryUrlB != null && !registryUrlA.equals(registryUrlB)) {
                        if (registryUrlA.endsWith("/")) {
                            registryUrlA = registryUrlA.substring(0, registryUrlA.length() - 1);
                        }
                        if (registryUrlB.endsWith("/")) {
                            registryUrlB = registryUrlB.substring(0, registryUrlB.length() - 1);
                        }
                        if (registryUrlA.equals(registryUrlB)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean isNewZIndexLabelConfigWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        Object valueA = fd.getValueA();
        if (valueA != null) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (!(componentB instanceof VersionedLabel)) {
            return false;
        }
        VersionedLabel versionedLabel = (VersionedLabel)componentB;
        if (fd.getDifferenceType() == DifferenceType.ZINDEX_CHANGED) {
            Long zIndex = versionedLabel.getzIndex();
            if (zIndex == null) {
                return false;
            }
            return zIndex == 0L;
        }
        return false;
    }

    private static boolean isNewZIndexConnectionConfigWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        Object valueA = fd.getValueA();
        if (valueA != null) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (!(componentB instanceof VersionedConnection)) {
            return false;
        }
        VersionedConnection versionedConnection = (VersionedConnection)componentB;
        if (fd.getDifferenceType() == DifferenceType.ZINDEX_CHANGED) {
            Long zIndex = versionedConnection.getzIndex();
            if (zIndex == null) {
                return false;
            }
            return zIndex == 0L;
        }
        return false;
    }

    private static boolean isNewRetryConfigWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        Object valueA = fd.getValueA();
        if (valueA != null) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (!(componentB instanceof InstantiatedVersionedProcessor)) {
            return false;
        }
        DifferenceType type = fd.getDifferenceType();
        InstantiatedVersionedProcessor instantiatedProcessor = (InstantiatedVersionedProcessor)componentB;
        ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedProcessor.getInstanceIdentifier());
        if (processorNode == null) {
            return false;
        }
        switch (type) {
            case RETRIED_RELATIONSHIPS_CHANGED: {
                return processorNode.getRetriedRelationships().isEmpty();
            }
            case RETRY_COUNT_CHANGED: {
                return processorNode.getRetryCount() == 10;
            }
            case MAX_BACKOFF_PERIOD_CHANGED: {
                return "10 mins".equals(processorNode.getMaxBackoffPeriod());
            }
            case BACKOFF_MECHANISM_CHANGED: {
                return ProcessorNode.DEFAULT_BACKOFF_MECHANISM == processorNode.getBackoffMechanism();
            }
        }
        return false;
    }

    public static boolean isNewPropertyWithDefaultValue(FlowDifference fd, FlowManager flowManager) {
        if (fd.getDifferenceType() != DifferenceType.PROPERTY_ADDED) {
            return false;
        }
        VersionedComponent componentB = fd.getComponentB();
        if (componentB instanceof InstantiatedVersionedProcessor) {
            InstantiatedVersionedProcessor instantiatedProcessor = (InstantiatedVersionedProcessor)componentB;
            ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedProcessor.getInstanceIdentifier());
            return FlowDifferenceFilters.isNewPropertyWithDefaultValue(fd, (ComponentNode)processorNode);
        }
        if (componentB instanceof InstantiatedVersionedControllerService) {
            InstantiatedVersionedControllerService instantiatedControllerService = (InstantiatedVersionedControllerService)componentB;
            ControllerServiceNode controllerService = flowManager.getControllerServiceNode(instantiatedControllerService.getInstanceIdentifier());
            return FlowDifferenceFilters.isNewPropertyWithDefaultValue(fd, (ComponentNode)controllerService);
        }
        return false;
    }

    private static boolean isNewPropertyWithDefaultValue(FlowDifference fd, ComponentNode componentNode) {
        if (componentNode == null) {
            return false;
        }
        Optional optionalFieldName = fd.getFieldName();
        if (!optionalFieldName.isPresent()) {
            return false;
        }
        String fieldName = (String)optionalFieldName.get();
        PropertyDescriptor propertyDescriptor = componentNode.getPropertyDescriptor(fieldName);
        if (propertyDescriptor == null) {
            return false;
        }
        return Objects.equals(fd.getValueB(), propertyDescriptor.getDefaultValue());
    }

    public static boolean isScheduledStateNew(FlowDifference fd) {
        if (fd.getDifferenceType() != DifferenceType.SCHEDULED_STATE_CHANGED) {
            return false;
        }
        if (fd.getValueA() == null && fd.getValueB() != null) {
            return true;
        }
        return fd.getValueB() == null && fd.getValueA() != null;
    }

    public static boolean isLocalScheduleStateChange(FlowDifference fd) {
        if (fd.getDifferenceType() != DifferenceType.SCHEDULED_STATE_CHANGED) {
            return false;
        }
        if (fd.getComponentA().getComponentType() == ComponentType.CONTROLLER_SERVICE) {
            return true;
        }
        String scheduledStateB = String.valueOf(fd.getValueB());
        String scheduledStateA = String.valueOf(fd.getValueA());
        if ("RUNNING".equals(scheduledStateB) && ("STOPPED".equals(scheduledStateA) || "ENABLED".equals(scheduledStateA))) {
            return true;
        }
        return "RUNNING".equals(scheduledStateA) && ("STOPPED".equals(scheduledStateB) || "ENABLED".equals(scheduledStateB));
    }

    public static boolean isVariableValueChange(FlowDifference flowDifference) {
        return flowDifference.getDifferenceType() == DifferenceType.VARIABLE_CHANGED;
    }

    public static boolean isAncestorVariableAdded(FlowDifference fd, FlowManager flowManager) {
        InstantiatedVersionedComponent componentB;
        InstantiatedVersionedComponent componentA;
        ProcessGroup processGroup;
        return fd.getDifferenceType() == DifferenceType.VARIABLE_ADDED && (fd.getComponentA() instanceof InstantiatedVersionedComponent ? (processGroup = flowManager.getGroup((componentA = (InstantiatedVersionedComponent)fd.getComponentA()).getInstanceIdentifier())).getVariableRegistry().getVariableKey((String)fd.getFieldName().get()) == null : fd.getComponentB() instanceof InstantiatedVersionedComponent && (processGroup = flowManager.getGroup((componentB = (InstantiatedVersionedComponent)fd.getComponentB()).getInstanceIdentifier())).getVariableRegistry().getVariableKey((String)fd.getFieldName().get()) == null);
    }

    public static boolean isRpgUrlChange(FlowDifference flowDifference) {
        return flowDifference.getDifferenceType() == DifferenceType.RPG_URL_CHANGED;
    }

    public static boolean isNewRelationshipAutoTerminatedAndDefaulted(FlowDifference fd, VersionedProcessGroup processGroup, FlowManager flowManager) {
        if (fd.getDifferenceType() != DifferenceType.AUTO_TERMINATED_RELATIONSHIPS_CHANGED) {
            return false;
        }
        if (!(fd.getComponentA() instanceof VersionedProcessor) || !(fd.getComponentB() instanceof InstantiatedVersionedProcessor)) {
            return false;
        }
        VersionedProcessor processorA = (VersionedProcessor)fd.getComponentA();
        VersionedProcessor processorB = (VersionedProcessor)fd.getComponentB();
        Set autoTerminatedA = FlowDifferenceFilters.replaceNull(processorA.getAutoTerminatedRelationships(), Collections.emptySet());
        Set autoTerminatedB = FlowDifferenceFilters.replaceNull(processorB.getAutoTerminatedRelationships(), Collections.emptySet());
        if (autoTerminatedB.size() < autoTerminatedA.size() || !autoTerminatedB.containsAll(autoTerminatedA)) {
            return false;
        }
        InstantiatedVersionedProcessor instantiatedVersionedProcessor = (InstantiatedVersionedProcessor)processorB;
        ProcessorNode processorNode = flowManager.getProcessorNode(instantiatedVersionedProcessor.getInstanceIdentifier());
        if (processorNode == null) {
            return false;
        }
        HashSet newlyAddedAutoTerminated = new HashSet(autoTerminatedB);
        newlyAddedAutoTerminated.removeAll(autoTerminatedA);
        for (String relationshipName : newlyAddedAutoTerminated) {
            Relationship relationship = processorNode.getRelationship(relationshipName);
            if (relationship == null) {
                return false;
            }
            boolean defaultAutoTerminated = relationship.isAutoTerminated();
            if (!defaultAutoTerminated) {
                return false;
            }
            if (!FlowDifferenceFilters.hasConnection(processGroup, processorA, relationshipName)) continue;
            return false;
        }
        return true;
    }

    private static <T> T replaceNull(T value, T replacement) {
        return value == null ? replacement : value;
    }

    public static boolean isPropertyMissingFromGhostComponent(FlowDifference difference, FlowManager flowManager) {
        if (difference.getDifferenceType() != DifferenceType.PROPERTY_REMOVED) {
            return false;
        }
        Optional fieldName = difference.getFieldName();
        if (!fieldName.isPresent()) {
            return false;
        }
        VersionedComponent componentB = difference.getComponentB();
        if (componentB instanceof InstantiatedVersionedProcessor) {
            ProcessorNode procNode = flowManager.getProcessorNode(componentB.getInstanceIdentifier());
            return procNode.isExtensionMissing() && FlowDifferenceFilters.isPropertyPresent((ComponentNode)procNode, difference);
        }
        if (componentB instanceof InstantiatedVersionedControllerService) {
            ControllerServiceNode serviceNode = flowManager.getControllerServiceNode(componentB.getInstanceIdentifier());
            return serviceNode.isExtensionMissing() && FlowDifferenceFilters.isPropertyPresent((ComponentNode)serviceNode, difference);
        }
        return false;
    }

    private static boolean isPropertyPresent(ComponentNode componentNode, FlowDifference difference) {
        if (componentNode == null) {
            return false;
        }
        Optional fieldNameOptional = difference.getFieldName();
        if (!fieldNameOptional.isPresent()) {
            return false;
        }
        PropertyDescriptor descriptor = componentNode.getPropertyDescriptor((String)fieldNameOptional.get());
        String rawPropertyValue = componentNode.getRawPropertyValue(descriptor);
        return rawPropertyValue != null;
    }

    private static boolean hasConnection(VersionedProcessGroup processGroup, VersionedProcessor processor, String relationship) {
        for (VersionedConnection connection : processGroup.getConnections()) {
            if (!connection.getSource().getId().equals(processor.getIdentifier()) || !connection.getSelectedRelationships().contains(relationship)) continue;
            return true;
        }
        return false;
    }

    private static boolean isParameterContextChange(FlowDifference flowDifference) {
        return flowDifference.getDifferenceType() == DifferenceType.PARAMETER_CONTEXT_CHANGED;
    }
}

