/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceDetails;
import org.apache.nifi.controller.service.ControllerServiceInvocationHandler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.ServiceStateTransition;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceReference;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.CharacterFilterUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.util.Tuple;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceNode
extends AbstractComponentNode
implements ControllerServiceNode {
    private static final Logger LOG = LoggerFactory.getLogger(StandardControllerServiceNode.class);
    public static final String BULLETIN_OBSERVER_ID = "bulletin-observer";
    private final AtomicReference<ControllerServiceDetails> controllerServiceHolder = new AtomicReference<Object>(null);
    private final ControllerServiceProvider serviceProvider;
    private final ServiceStateTransition stateTransition;
    private final AtomicReference<String> versionedComponentId = new AtomicReference();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Set<Tuple<ComponentNode, PropertyDescriptor>> referencingComponents = new HashSet<Tuple<ComponentNode, PropertyDescriptor>>();
    private volatile String comment;
    private volatile ProcessGroup processGroup;
    private volatile LogLevel bulletinLevel = LogLevel.WARN;
    private final AtomicBoolean active;

    public StandardControllerServiceNode(LoggableComponent<ControllerService> implementation, LoggableComponent<ControllerService> proxiedControllerService, ControllerServiceInvocationHandler invocationHandler, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger) {
        this(implementation, proxiedControllerService, invocationHandler, id, validationContextFactory, serviceProvider, ((ControllerService)implementation.getComponent()).getClass().getSimpleName(), ((ControllerService)implementation.getComponent()).getClass().getCanonicalName(), variableRegistry, reloadComponent, extensionManager, validationTrigger, false);
    }

    public StandardControllerServiceNode(LoggableComponent<ControllerService> implementation, LoggableComponent<ControllerService> proxiedControllerService, ControllerServiceInvocationHandler invocationHandler, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, String componentType, String componentCanonicalClass, ComponentVariableRegistry variableRegistry, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(id, validationContextFactory, serviceProvider, componentType, componentCanonicalClass, variableRegistry, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
        this.serviceProvider = serviceProvider;
        this.active = new AtomicBoolean();
        this.setControllerServiceAndProxy(implementation, proxiedControllerService, invocationHandler);
        this.stateTransition = new ServiceStateTransition(this);
    }

    public ConfigurableComponent getComponent() {
        return this.controllerServiceHolder.get().getImplementation();
    }

    public TerminationAwareLogger getLogger() {
        return this.controllerServiceHolder.get().getComponentLog();
    }

    public BundleCoordinate getBundleCoordinate() {
        return this.controllerServiceHolder.get().getBundleCoordinate();
    }

    public Authorizable getParentAuthorizable() {
        ProcessGroup processGroup = this.getProcessGroup();
        if (processGroup == null) {
            return new Authorizable(){

                public Authorizable getParentAuthorizable() {
                    return null;
                }

                public Resource getResource() {
                    return ResourceFactory.getControllerResource();
                }
            };
        }
        return processGroup;
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ControllerService, (String)this.getIdentifier(), (String)this.getName());
    }

    public boolean isRestricted() {
        return this.getControllerServiceImplementation().getClass().isAnnotationPresent(Restricted.class);
    }

    public Class<?> getComponentClass() {
        return this.getControllerServiceImplementation().getClass();
    }

    public boolean isDeprecated() {
        return this.getControllerServiceImplementation().getClass().isAnnotationPresent(DeprecationNotice.class);
    }

    public ControllerService getControllerServiceImplementation() {
        return this.controllerServiceHolder.get().getImplementation();
    }

    public ControllerService getProxiedControllerService() {
        return this.controllerServiceHolder.get().getProxiedControllerService();
    }

    public ControllerServiceInvocationHandler getInvocationHandler() {
        return this.controllerServiceHolder.get().getInvocationHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControllerServiceAndProxy(LoggableComponent<ControllerService> implementation, LoggableComponent<ControllerService> proxiedControllerService, ControllerServiceInvocationHandler invocationHandler) {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            if (this.isActive()) {
                throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " while service is active");
            }
            ControllerServiceDetails controllerServiceDetails = new ControllerServiceDetails(implementation, proxiedControllerService, invocationHandler);
            this.controllerServiceHolder.set(controllerServiceDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(Set<URL> additionalUrls) throws ControllerServiceInstantiationException {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            String additionalResourcesFingerprint = ClassLoaderUtils.generateAdditionalUrlsFingerprint(additionalUrls, (String)this.determineClasloaderIsolationKey());
            this.setAdditionalResourcesFingerprint(additionalResourcesFingerprint);
            this.getReloadComponent().reload((ControllerServiceNode)this, this.getCanonicalClassName(), this.getBundleCoordinate(), additionalUrls);
        }
    }

    public void setProperties(Map<String, String> properties, boolean allowRemovalOfRequiredProperties, Set<String> sensitiveDynamicPropertyNames) {
        super.setProperties(properties, allowRemovalOfRequiredProperties, sensitiveDynamicPropertyNames);
        this.getReferences().findRecursiveReferences(ComponentNode.class).forEach(ComponentNode::reloadAdditionalResourcesIfNecessary);
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup;
    }

    public void setProcessGroup(ProcessGroup group) {
        this.processGroup = group;
        LOG.debug("Resetting Validation State of {} due to setting process group", (Object)this);
        this.resetValidationState();
    }

    public ControllerServiceReference getReferences() {
        this.readLock.lock();
        try {
            StandardControllerServiceReference standardControllerServiceReference = new StandardControllerServiceReference(this, this.referencingComponents.stream().map(Tuple::getKey).collect(Collectors.toSet()));
            return standardControllerServiceReference;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addReference(ComponentNode referencingComponent, PropertyDescriptor propertyDescriptor) {
        this.writeLock.lock();
        try {
            this.referencingComponents.add((Tuple<ComponentNode, PropertyDescriptor>)new Tuple((Object)referencingComponent, (Object)propertyDescriptor));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected ParameterContext getParameterContext() {
        ProcessGroup processGroup = this.getProcessGroup();
        return processGroup == null ? null : processGroup.getParameterContext();
    }

    public List<ControllerServiceNode> getRequiredControllerServices() {
        HashSet<ControllerServiceNode> requiredServices = new HashSet<ControllerServiceNode>();
        for (Map.Entry entry : this.getEffectivePropertyValues().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || entry.getValue() == null) continue;
            String referenceId = (String)entry.getValue();
            ControllerServiceNode requiredNode = this.serviceProvider.getControllerServiceNode(referenceId);
            if (requiredNode != null) {
                requiredServices.add(requiredNode);
                continue;
            }
            LOG.warn("Unable to locate referenced controller service with id {}", (Object)referenceId);
        }
        return new ArrayList<ControllerServiceNode>(requiredServices);
    }

    public void removeReference(ComponentNode referencingComponent, PropertyDescriptor propertyDescriptor) {
        this.writeLock.lock();
        try {
            this.referencingComponents.remove(new Tuple((Object)referencingComponent, (Object)propertyDescriptor));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        ControllerServiceState state = this.getState();
        if (state == ControllerServiceState.DISABLING) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " because it is currently still disabling. Please wait for the service to fully disable before attempting to modify it.");
        }
        if (state != ControllerServiceState.DISABLED) {
            throw new IllegalStateException("Cannot modify configuration of " + (Object)((Object)this) + " because it is currently not disabled - it has a state of " + state + ". Please disable the Controller Service first.");
        }
    }

    public void verifyCanDelete() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be deleted because it is not disabled");
        }
    }

    public void verifyCanDisable() {
        this.verifyCanDisable(Collections.emptySet());
    }

    public void verifyCanDisable(Set<ControllerServiceNode> ignoreReferences) {
        if (!this.isActive()) {
            return;
        }
        ControllerServiceReference references = this.getReferences();
        HashSet<String> activeReferencesIdentifiers = new HashSet<String>();
        for (ComponentNode activeReference : references.getActiveReferences()) {
            if (ignoreReferences.contains(activeReference)) continue;
            activeReferencesIdentifiers.add(activeReference.getIdentifier());
        }
        if (!activeReferencesIdentifiers.isEmpty()) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be disabled because it is referenced by " + activeReferencesIdentifiers.size() + " components that are currently running: [" + StringUtils.join(activeReferencesIdentifiers, (String)", ") + "]");
        }
    }

    public void verifyCanEnable() {
        ControllerServiceState state = this.getState();
        switch (state) {
            case DISABLED: {
                return;
            }
            case DISABLING: {
                throw new IllegalStateException((Object)((Object)this) + " cannot be enabled because it is not disabled - it has a state of " + state);
            }
        }
        if (this.isReloadAdditionalResourcesNecessary()) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be enabled because additional resources are needed - it has a state of " + state);
        }
    }

    public void verifyCanEnable(Set<ControllerServiceNode> ignoredReferences) {
        this.verifyCanEnable();
    }

    public void verifyCanUpdate() {
        ControllerServiceState state = this.getState();
        if (state != ControllerServiceState.DISABLED) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be updated because it is not disabled - it has a state of " + state);
        }
    }

    public void verifyCanClearState() {
        this.verifyCanUpdate();
    }

    public String getComments() {
        return this.comment;
    }

    public void setComments(String comment) {
        this.comment = CharacterFilterUtils.filterInvalidXmlCharacters((String)comment);
    }

    public ControllerServiceState getState() {
        return this.stateTransition.getState();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public boolean awaitEnabled(long timePeriod, TimeUnit timeUnit) throws InterruptedException {
        LOG.debug("Waiting up to {} {} for {} to be enabled", new Object[]{timePeriod, timeUnit, this});
        boolean enabled = this.stateTransition.awaitStateOrInvalid(ControllerServiceState.ENABLED, timePeriod, timeUnit);
        if (enabled) {
            LOG.debug("{} is enabled", (Object)this);
        } else {
            LOG.debug("After {} {}, {} is NOT enabled", new Object[]{timePeriod, timeUnit, this});
        }
        return enabled;
    }

    public boolean awaitDisabled(long timePeriod, TimeUnit timeUnit) throws InterruptedException {
        LOG.debug("Waiting up to {} {} for {} to be disabled", new Object[]{timePeriod, timeUnit, this});
        boolean disabled = this.stateTransition.awaitState(ControllerServiceState.DISABLED, timePeriod, timeUnit);
        if (disabled) {
            LOG.debug("{} is now disabled", (Object)this);
        } else {
            LOG.debug("After {} {}, {} is NOT disabled", new Object[]{timePeriod, timeUnit, this});
        }
        return disabled;
    }

    public void verifyCanPerformVerification() {
        ControllerServiceState state = this.getState();
        if (state != ControllerServiceState.DISABLED) {
            throw new IllegalStateException("Cannot perform verification because the " + (Object)((Object)this) + " is not disabled - it has a state of " + state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verifyConfiguration(ConfigurationContext context, ComponentLog logger, Map<String, String> variables, ExtensionManager extensionManager) {
        ArrayList<ConfigVerificationResult> results;
        block33: {
            results = new ArrayList<ConfigVerificationResult>();
            try {
                this.verifyCanPerformVerification();
                long startNanos = System.nanoTime();
                results.addAll(super.verifyConfig(context.getProperties(), context.getAnnotationData(), this.getProcessGroup() == null ? null : this.getProcessGroup().getParameterContext()));
                long validationComplete = System.nanoTime();
                if (!results.isEmpty() && results.stream().anyMatch(result -> result.getOutcome() == ConfigVerificationResult.Outcome.FAILED)) {
                    return results;
                }
                ControllerService controllerService = this.getControllerServiceImplementation();
                if (controllerService instanceof VerifiableControllerService) {
                    block32: {
                        LOG.debug("{} is a VerifiableControllerService. Will perform full verification of configuration.", (Object)this);
                        VerifiableControllerService verifiable = (VerifiableControllerService)controllerService;
                        boolean classpathDifferent = this.isClasspathDifferent(context.getProperties());
                        if (classpathDifferent) {
                            Bundle bundle = extensionManager.getBundle(this.getBundleCoordinate());
                            Set classpathUrls = this.getAdditionalClasspathResources(context.getProperties().keySet(), descriptor -> context.getProperty(descriptor).getValue());
                            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
                            String classLoaderIsolationKey = this.getClassLoaderIsolationKey((PropertyContext)context);
                            try (InstanceClassLoader detectedClassLoader = extensionManager.createInstanceClassLoader(this.getComponentType(), this.getIdentifier(), bundle, classpathUrls, false, classLoaderIsolationKey);){
                                Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
                                results.addAll(verifiable.verify(context, logger, variables));
                                break block32;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(currentClassLoader);
                            }
                        }
                        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)extensionManager, controllerService.getClass(), (String)this.getIdentifier());){
                            results.addAll(verifiable.verify(context, logger, variables));
                        }
                    }
                    long validationNanos = validationComplete - startNanos;
                    long verificationNanos = System.nanoTime() - validationComplete;
                    LOG.debug("{} completed full configuration validation in {} plus {} for validation", new Object[]{this, FormatUtils.formatNanos((long)verificationNanos, (boolean)false), FormatUtils.formatNanos((long)validationNanos, (boolean)false)});
                    break block33;
                }
                LOG.debug("{} is not a VerifiableControllerService, so will not perform full verification of configuration. Validation took {}", (Object)this, (Object)FormatUtils.formatNanos((long)(validationComplete - startNanos), (boolean)false));
            }
            catch (Throwable t) {
                LOG.error("Failed to perform verification of Controller Service's configuration for {}", (Object)this, (Object)t);
                results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Perform Verification").explanation("Encountered unexpected failure when attempting to perform verification: " + t).build());
            }
        }
        return results;
    }

    public boolean isValidationNecessary() {
        switch (this.getState()) {
            case DISABLED: 
            case DISABLING: {
                return true;
            }
            case ENABLING: {
                return this.getValidationStatus() != ValidationStatus.VALID;
            }
        }
        return false;
    }

    public ValidationState performValidation(ValidationContext validationContext) {
        ValidationState state = super.performValidation(validationContext);
        if (state.getStatus() == ValidationStatus.INVALID) {
            this.stateTransition.signalInvalid();
        }
        return state;
    }

    protected List<ValidationResult> validateConfig() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> enable(final ScheduledExecutorService scheduler, final long administrativeYieldMillis) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.stateTransition.transitionToEnabling(ControllerServiceState.DISABLED, future)) {
            AtomicBoolean atomicBoolean = this.active;
            synchronized (atomicBoolean) {
                this.active.set(true);
            }
            final ControllerServiceProvider controllerServiceProvider = this.serviceProvider;
            final StandardControllerServiceNode service = this;
            scheduler.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StandardConfigurationContext configContext = new StandardConfigurationContext((ComponentNode)StandardControllerServiceNode.this, (ControllerServiceLookup)controllerServiceProvider, null, (VariableRegistry)StandardControllerServiceNode.this.getVariableRegistry());
                    if (!StandardControllerServiceNode.this.isActive()) {
                        LOG.warn("{} is no longer active so will no longer attempt to enable it", (Object)StandardControllerServiceNode.this);
                        StandardControllerServiceNode.this.stateTransition.disable();
                        future.complete(null);
                        return;
                    }
                    ValidationStatus validationStatus = StandardControllerServiceNode.this.getValidationStatus();
                    if (validationStatus != ValidationStatus.VALID) {
                        ValidationState validationState = StandardControllerServiceNode.this.getValidationState();
                        LOG.debug("Cannot enable {} because it is not currently valid. (Validation State is {}: {}). Will try again in 1 second", new Object[]{StandardControllerServiceNode.this, validationState, validationState.getValidationErrors()});
                        try {
                            scheduler.schedule(this, 1L, TimeUnit.SECONDS);
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                            LOG.error("Unable to enable {}.  Last known validation state was {} : {}", new Object[]{StandardControllerServiceNode.this, validationState, validationState.getValidationErrors(), rejectedExecutionException});
                        }
                        future.complete(null);
                        return;
                    }
                    try {
                        boolean shouldEnable;
                        NarCloseable nc = NarCloseable.withComponentNarLoader((ExtensionManager)StandardControllerServiceNode.this.getExtensionManager(), StandardControllerServiceNode.this.getControllerServiceImplementation().getClass(), (String)StandardControllerServiceNode.this.getIdentifier());
                        Serializable rejectedExecutionException = null;
                        try {
                            ReflectionUtils.invokeMethodsWithAnnotation(OnEnabled.class, StandardControllerServiceNode.this.getControllerServiceImplementation(), configContext);
                        }
                        catch (Throwable throwable) {
                            rejectedExecutionException = throwable;
                            throw throwable;
                        }
                        finally {
                            if (nc != null) {
                                if (rejectedExecutionException != null) {
                                    try {
                                        nc.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)rejectedExecutionException).addSuppressed(throwable);
                                    }
                                } else {
                                    nc.close();
                                }
                            }
                        }
                        rejectedExecutionException = StandardControllerServiceNode.this.active;
                        synchronized (rejectedExecutionException) {
                            shouldEnable = StandardControllerServiceNode.this.active.get() && StandardControllerServiceNode.this.stateTransition.enable(StandardControllerServiceNode.this.getReferences());
                        }
                        if (!shouldEnable) {
                            LOG.info("Disabling service {} after it has been enabled due to disable action being initiated.", (Object)service);
                            StandardControllerServiceNode.this.invokeDisable(configContext);
                            StandardControllerServiceNode.this.stateTransition.disable();
                            future.complete(null);
                        } else {
                            LOG.info("Successfully enabled {}", (Object)service);
                        }
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                        Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                        SimpleProcessLogger componentLog = new SimpleProcessLogger(StandardControllerServiceNode.this.getIdentifier(), (Object)StandardControllerServiceNode.this);
                        componentLog.error("Failed to invoke @OnEnabled method", cause);
                        StandardControllerServiceNode.this.invokeDisable(configContext);
                        if (StandardControllerServiceNode.this.isActive()) {
                            scheduler.schedule(this, administrativeYieldMillis, TimeUnit.MILLISECONDS);
                        }
                        StandardControllerServiceNode.this.stateTransition.disable();
                    }
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> disable(ScheduledExecutorService scheduler) {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            this.active.set(false);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        boolean transitioned = this.stateTransition.transitionToDisabling(ControllerServiceState.ENABLING, future);
        if (transitioned) {
            return future;
        }
        if (this.stateTransition.transitionToDisabling(ControllerServiceState.ENABLED, future)) {
            final StandardConfigurationContext configContext = new StandardConfigurationContext((ComponentNode)this, (ControllerServiceLookup)this.serviceProvider, null, (VariableRegistry)this.getVariableRegistry());
            scheduler.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        StandardControllerServiceNode.this.invokeDisable(configContext);
                    }
                    finally {
                        StandardControllerServiceNode.this.stateTransition.disable();
                        for (ComponentNode component : StandardControllerServiceNode.this.getReferences().getReferencingComponents()) {
                            component.performValidation();
                        }
                    }
                }
            });
        }
        return future;
    }

    private void invokeDisable(ConfigurationContext configContext) {
        try (NarCloseable nc = NarCloseable.withComponentNarLoader((ExtensionManager)this.getExtensionManager(), this.getControllerServiceImplementation().getClass(), (String)this.getIdentifier());){
            ReflectionUtils.invokeMethodsWithAnnotation(OnDisabled.class, this.getControllerServiceImplementation(), configContext);
            LOG.debug("Successfully disabled {}", (Object)this);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            SimpleProcessLogger componentLog = new SimpleProcessLogger(this.getIdentifier(), (Object)this);
            componentLog.error("Failed to invoke @OnDisabled method due to {}", cause);
            LOG.error("Failed to invoke @OnDisabled method of {} due to {}", (Object)this.getControllerServiceImplementation(), (Object)cause.toString());
        }
    }

    public String getProcessGroupIdentifier() {
        ProcessGroup procGroup = this.getProcessGroup();
        return procGroup == null ? null : procGroup.getIdentifier();
    }

    public Optional<String> getVersionedComponentId() {
        return Optional.ofNullable(this.versionedComponentId.get());
    }

    public void setVersionedComponentId(String versionedComponentId) {
        boolean updated = false;
        while (!updated) {
            String currentId = this.versionedComponentId.get();
            if (currentId == null) {
                updated = this.versionedComponentId.compareAndSet(null, versionedComponentId);
                continue;
            }
            if (currentId.equals(versionedComponentId)) {
                return;
            }
            if (versionedComponentId == null) {
                updated = this.versionedComponentId.compareAndSet(currentId, null);
                continue;
            }
            throw new IllegalStateException((Object)((Object)this) + " is already under version control");
        }
    }

    public String toString() {
        return "StandardControllerServiceNode[service=" + super.toString() + ", name=" + this.getName() + ", active=" + this.active + "]";
    }

    public ParameterLookup getParameterLookup() {
        return this.getParameterContext();
    }

    public LogLevel getBulletinLevel() {
        return this.bulletinLevel;
    }

    public synchronized void setBulletinLevel(LogLevel level) {
        if (level == null) {
            level = LogLevel.WARN;
        }
        LogRepositoryFactory.getRepository((String)this.getIdentifier()).setObservationLevel(BULLETIN_OBSERVER_ID, level);
        this.bulletinLevel = level;
    }
}

