/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.io.LimitedInputStream;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;
import org.apache.nifi.controller.repository.metrics.PerformanceTrackingInputStream;
import org.apache.nifi.stream.io.StreamUtils;

public class ContentClaimInputStream
extends InputStream {
    private final ContentRepository contentRepository;
    private final ContentClaim contentClaim;
    private final long claimOffset;
    private final PerformanceTracker performanceTracker;
    private InputStream delegate;
    private long bytesConsumed;
    private long currentOffset;
    private long markOffset;
    private InputStream bufferedIn;
    private int markReadLimit;

    public ContentClaimInputStream(ContentRepository contentRepository, ContentClaim contentClaim, long claimOffset, PerformanceTracker performanceTracker) {
        this(contentRepository, contentClaim, claimOffset, null, performanceTracker);
    }

    public ContentClaimInputStream(ContentRepository contentRepository, ContentClaim contentClaim, long claimOffset, InputStream initialDelegate, PerformanceTracker performanceTracker) {
        this.contentRepository = contentRepository;
        this.contentClaim = contentClaim;
        this.claimOffset = claimOffset;
        this.performanceTracker = performanceTracker;
        this.currentOffset = claimOffset;
        this.delegate = initialDelegate;
        if (this.delegate != null) {
            this.bufferedIn = new BufferedInputStream(this.delegate);
        }
    }

    private InputStream getDelegate() throws IOException {
        this.bufferedIn = null;
        if (this.delegate == null) {
            this.formDelegate();
        }
        return this.delegate;
    }

    public long getBytesConsumed() {
        return this.bytesConsumed;
    }

    public long getCurrentOffset() {
        return this.currentOffset;
    }

    @Override
    public int read() throws IOException {
        int value = -1;
        if (this.bufferedIn != null) {
            value = this.bufferedIn.read();
        }
        if (value < 0) {
            value = this.getDelegate().read();
        }
        if (value != -1) {
            ++this.bytesConsumed;
            ++this.currentOffset;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int count = -1;
        if (this.bufferedIn != null) {
            count = this.bufferedIn.read(b);
        }
        if (count < 0) {
            count = this.getDelegate().read(b);
        }
        if (count != -1) {
            this.bytesConsumed += (long)count;
            this.currentOffset += (long)count;
        }
        return count;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = -1;
        if (this.bufferedIn != null) {
            count = this.bufferedIn.read(b, off, len);
        }
        if (count < 0) {
            count = this.getDelegate().read(b, off, len);
        }
        if (count != -1) {
            this.bytesConsumed += (long)count;
            this.currentOffset += (long)count;
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        long count = this.getDelegate().skip(n);
        if (count > 0L) {
            this.bytesConsumed += count;
            this.currentOffset += count;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.available();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.markOffset = this.currentOffset;
        this.markReadLimit = readlimit;
        if (this.bufferedIn != null) {
            this.bufferedIn.mark(readlimit);
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.markOffset < 0L) {
            throw new IOException("Stream has not been marked");
        }
        if (this.bufferedIn != null && this.bytesConsumed <= (long)this.markReadLimit) {
            this.bufferedIn.reset();
            this.currentOffset = this.markOffset;
            return;
        }
        if (this.currentOffset != this.markOffset) {
            if (this.delegate != null) {
                this.delegate.close();
            }
            this.formDelegate();
            this.performanceTracker.beginContentRead();
            try {
                StreamUtils.skip((InputStream)this.delegate, (long)(this.markOffset - this.claimOffset));
            }
            finally {
                this.performanceTracker.endContentRead();
            }
            this.currentOffset = this.markOffset;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private void formDelegate() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.performanceTracker.beginContentRead();
        try {
            int limitLeft;
            this.delegate = new PerformanceTrackingInputStream(this.contentRepository.read(this.contentClaim), this.performanceTracker);
            StreamUtils.skip((InputStream)this.delegate, (long)this.claimOffset);
            this.currentOffset = this.claimOffset;
            if (this.markReadLimit > 0 && (limitLeft = (int)((long)this.markReadLimit - this.currentOffset)) > 0) {
                LimitedInputStream limitedIn = new LimitedInputStream(this.delegate, limitLeft);
                this.bufferedIn = new BufferedInputStream(limitedIn);
                this.bufferedIn.mark(limitLeft);
            }
        }
        finally {
            this.performanceTracker.endContentRead();
        }
    }
}

