/*-------------------------------------------------------------------------
 * PIC32MZ2048EFG100 processor header
 * Build date : Feb 18 2016
 *
 * Copyright (c) 2016, Microchip Technology Inc. and its subsidiaries ("Microchip")
 * All rights reserved.
 * 
 * This software is developed by Microchip Technology Inc. and its
 * subsidiaries ("Microchip").
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are 
 * met:
 * 
 * 1.      Redistributions of source code must retain the above copyright
 *         notice, this list of conditions and the following disclaimer.
 * 2.      Redistributions in binary form must reproduce the above 
 *         copyright notice, this list of conditions and the following 
 *         disclaimer in the documentation and/or other materials provided 
 *         with the distribution.
 * 3.      Microchip's name may not be used to endorse or promote products
 *         derived from this software without specific prior written 
 *         permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY MICROCHIP "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL MICROCHIP BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWSOEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

#pragma once
#ifndef __32MZ2048EFG100_H
#define __32MZ2048EFG100_H

#if defined (__LANGUAGE_C__) || defined (__LANGUAGE_C_PLUS_PLUS)

#ifdef __cplusplus
extern "C" {
#endif

#define CFGCON CFGCON
extern volatile unsigned int   CFGCON __attribute__((section("sfrs")));
typedef struct {
  unsigned TDOEN:1;
  unsigned :1;
  unsigned TROEN:1;
  unsigned JTAGEN:1;
  unsigned ECCCON:2;
  unsigned :1;
  unsigned IOANCPN:1;
  unsigned USBSSEN:1;
  unsigned :2;
  unsigned PGLOCK:1;
  unsigned PMDLOCK:1;
  unsigned IOLOCK:1;
  unsigned :2;
  unsigned OCACLK:1;
  unsigned ICACLK:1;
  unsigned :6;
  unsigned CPUPRI:1;
  unsigned DMAPRI:1;
} __CFGCONbits_t;
extern volatile __CFGCONbits_t CFGCONbits __asm__ ("CFGCON") __attribute__((section("sfrs")));
#define DEVID DEVID
extern volatile unsigned int   DEVID __attribute__((section("sfrs")));
typedef struct {
  unsigned DEVID:28;
  unsigned VER:4;
} __DEVIDbits_t;
extern volatile __DEVIDbits_t DEVIDbits __asm__ ("DEVID") __attribute__((section("sfrs")));
#define SYSKEY SYSKEY
extern volatile unsigned int   SYSKEY __attribute__((section("sfrs")));
typedef struct {
  unsigned SYSKEY:32;
} __SYSKEYbits_t;
extern volatile __SYSKEYbits_t SYSKEYbits __asm__ ("SYSKEY") __attribute__((section("sfrs")));
#define PMD1 PMD1
extern volatile unsigned int   PMD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCMD:1;
  unsigned :11;
  unsigned CVRMD:1;
} __PMD1bits_t;
extern volatile __PMD1bits_t PMD1bits __asm__ ("PMD1") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD1SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD1INV __attribute__((section("sfrs")));
#define PMD2 PMD2
extern volatile unsigned int   PMD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMP1MD:1;
  unsigned CMP2MD:1;
} __PMD2bits_t;
extern volatile __PMD2bits_t PMD2bits __asm__ ("PMD2") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD2SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD2INV __attribute__((section("sfrs")));
#define PMD3 PMD3
extern volatile unsigned int   PMD3 __attribute__((section("sfrs")));
typedef struct {
  unsigned IC1MD:1;
  unsigned IC2MD:1;
  unsigned IC3MD:1;
  unsigned IC4MD:1;
  unsigned IC5MD:1;
  unsigned IC6MD:1;
  unsigned IC7MD:1;
  unsigned IC8MD:1;
  unsigned IC9MD:1;
  unsigned :7;
  unsigned OC1MD:1;
  unsigned OC2MD:1;
  unsigned OC3MD:1;
  unsigned OC4MD:1;
  unsigned OC5MD:1;
  unsigned OC6MD:1;
  unsigned OC7MD:1;
  unsigned OC8MD:1;
  unsigned OC9MD:1;
} __PMD3bits_t;
extern volatile __PMD3bits_t PMD3bits __asm__ ("PMD3") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD3SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD3INV __attribute__((section("sfrs")));
#define PMD4 PMD4
extern volatile unsigned int   PMD4 __attribute__((section("sfrs")));
typedef struct {
  unsigned T1MD:1;
  unsigned T2MD:1;
  unsigned T3MD:1;
  unsigned T4MD:1;
  unsigned T5MD:1;
  unsigned T6MD:1;
  unsigned T7MD:1;
  unsigned T8MD:1;
  unsigned T9MD:1;
} __PMD4bits_t;
extern volatile __PMD4bits_t PMD4bits __asm__ ("PMD4") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD4SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD4INV __attribute__((section("sfrs")));
#define PMD5 PMD5
extern volatile unsigned int   PMD5 __attribute__((section("sfrs")));
typedef struct {
  unsigned U1MD:1;
  unsigned U2MD:1;
  unsigned U3MD:1;
  unsigned U4MD:1;
  unsigned U5MD:1;
  unsigned U6MD:1;
  unsigned :2;
  unsigned SPI1MD:1;
  unsigned SPI2MD:1;
  unsigned SPI3MD:1;
  unsigned SPI4MD:1;
  unsigned SPI5MD:1;
  unsigned SPI6MD:1;
  unsigned :2;
  unsigned I2C1MD:1;
  unsigned I2C2MD:1;
  unsigned I2C3MD:1;
  unsigned I2C4MD:1;
  unsigned I2C5MD:1;
  unsigned :3;
  unsigned USBMD:1;
} __PMD5bits_t;
extern volatile __PMD5bits_t PMD5bits __asm__ ("PMD5") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD5SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD5INV __attribute__((section("sfrs")));
#define PMD6 PMD6
extern volatile unsigned int   PMD6 __attribute__((section("sfrs")));
typedef struct {
  unsigned RTCCMD:1;
  unsigned :7;
  unsigned REFO1MD:1;
  unsigned REFO2MD:1;
  unsigned REFO3MD:1;
  unsigned REFO4MD:1;
  unsigned :4;
  unsigned PMPMD:1;
  unsigned EBIMD:1;
  unsigned :5;
  unsigned SQI1MD:1;
  unsigned :4;
  unsigned ETHMD:1;
} __PMD6bits_t;
extern volatile __PMD6bits_t PMD6bits __asm__ ("PMD6") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD6SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD6INV __attribute__((section("sfrs")));
#define PMD7 PMD7
extern volatile unsigned int   PMD7 __attribute__((section("sfrs")));
typedef struct {
  unsigned :4;
  unsigned DMAMD:1;
  unsigned :15;
  unsigned RNGMD:1;
} __PMD7bits_t;
extern volatile __PMD7bits_t PMD7bits __asm__ ("PMD7") __attribute__((section("sfrs")));
extern volatile unsigned int        PMD7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMD7SET __attribute__((section("sfrs")));
extern volatile unsigned int        PMD7INV __attribute__((section("sfrs")));
#define CFGEBIA CFGEBIA
extern volatile unsigned int   CFGEBIA __attribute__((section("sfrs")));
typedef struct {
  unsigned EBIA0EN:1;
  unsigned EBIA1EN:1;
  unsigned EBIA2EN:1;
  unsigned EBIA3EN:1;
  unsigned EBIA4EN:1;
  unsigned EBIA5EN:1;
  unsigned EBIA6EN:1;
  unsigned EBIA7EN:1;
  unsigned EBIA8EN:1;
  unsigned EBIA9EN:1;
  unsigned EBIA10EN:1;
  unsigned EBIA11EN:1;
  unsigned EBIA12EN:1;
  unsigned EBIA13EN:1;
  unsigned EBIA14EN:1;
  unsigned EBIA15EN:1;
  unsigned EBIA16EN:1;
  unsigned EBIA17EN:1;
  unsigned EBIA18EN:1;
  unsigned EBIA19EN:1;
  unsigned EBIA20EN:1;
  unsigned EBIA21EN:1;
  unsigned EBIA22EN:1;
  unsigned EBIA23EN:1;
  unsigned :7;
  unsigned EBIPINEN:1;
} __CFGEBIAbits_t;
extern volatile __CFGEBIAbits_t CFGEBIAbits __asm__ ("CFGEBIA") __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBIACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBIASET __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBIAINV __attribute__((section("sfrs")));
#define CFGEBIC CFGEBIC
extern volatile unsigned int   CFGEBIC __attribute__((section("sfrs")));
typedef struct {
  unsigned EBIDEN0:1;
  unsigned EBIDEN1:1;
  unsigned :2;
  unsigned EBICSEN0:1;
  unsigned EBICSEN1:1;
  unsigned EBICSEN2:1;
  unsigned EBICSEN3:1;
  unsigned EBIBSEN0:1;
  unsigned EBIBSEN1:1;
  unsigned :2;
  unsigned EBIOEEN:1;
  unsigned EBIWEEN:1;
  unsigned :2;
  unsigned EBIRPEN:1;
  unsigned EBIRDYLVL:1;
  unsigned :7;
  unsigned EBIRDYEN1:1;
  unsigned EBIRDYEN2:1;
  unsigned EBIRDYEN3:1;
  unsigned :1;
  unsigned EBIRDYINV1:1;
  unsigned EBIRDYINV2:1;
  unsigned EBIRDYINV3:1;
} __CFGEBICbits_t;
extern volatile __CFGEBICbits_t CFGEBICbits __asm__ ("CFGEBIC") __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBICCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBICSET __attribute__((section("sfrs")));
extern volatile unsigned int        CFGEBICINV __attribute__((section("sfrs")));
#define CFGPG CFGPG
extern volatile unsigned int   CFGPG __attribute__((section("sfrs")));
typedef struct {
  unsigned CPUPG:2;
  unsigned :2;
  unsigned DMAPG:2;
  unsigned :2;
  unsigned USBPG:2;
  unsigned :6;
  unsigned ETHPG:2;
  unsigned :2;
  unsigned SQI1PG:2;
  unsigned FCPG:2;
  unsigned :6;
  unsigned ICD1PG:2;
} __CFGPGbits_t;
extern volatile __CFGPGbits_t CFGPGbits __asm__ ("CFGPG") __attribute__((section("sfrs")));
extern volatile unsigned int        CFGPGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CFGPGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CFGPGINV __attribute__((section("sfrs")));
#define NVMCON NVMCON
extern volatile unsigned int   NVMCON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned NVMOP:4;
    unsigned :2;
    unsigned BFSWAP:1;
    unsigned PFSWAP:1;
    unsigned :4;
    unsigned LVDERR:1;
    unsigned WRERR:1;
    unsigned WREN:1;
    unsigned WR:1;
  };
  struct {
    unsigned NVMOP0:1;
    unsigned NVMOP1:1;
    unsigned NVMOP2:1;
    unsigned NVMOP3:1;
    unsigned :3;
    unsigned SWAP:1;
  };
  struct {
    unsigned PROGOP:4;
  };
  struct {
    unsigned PROGOP0:1;
    unsigned PROGOP1:1;
    unsigned PROGOP2:1;
    unsigned PROGOP3:1;
  };
  struct {
    unsigned w:32;
  };
} __NVMCONbits_t;
extern volatile __NVMCONbits_t NVMCONbits __asm__ ("NVMCON") __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCONINV __attribute__((section("sfrs")));
#define NVMKEY NVMKEY
extern volatile unsigned int   NVMKEY __attribute__((section("sfrs")));
#define NVMADDR NVMADDR
extern volatile unsigned int   NVMADDR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMADDRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMADDRSET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMADDRINV __attribute__((section("sfrs")));
#define NVMDATA0 NVMDATA0
extern volatile unsigned int   NVMDATA0 __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA0SET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA0INV __attribute__((section("sfrs")));
#define NVMDATA1 NVMDATA1
extern volatile unsigned int   NVMDATA1 __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA1SET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA1INV __attribute__((section("sfrs")));
#define NVMDATA2 NVMDATA2
extern volatile unsigned int   NVMDATA2 __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA2SET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA2INV __attribute__((section("sfrs")));
#define NVMDATA3 NVMDATA3
extern volatile unsigned int   NVMDATA3 __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA3SET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMDATA3INV __attribute__((section("sfrs")));
#define NVMSRCADDR NVMSRCADDR
extern volatile unsigned int   NVMSRCADDR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMSRCADDRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMSRCADDRSET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMSRCADDRINV __attribute__((section("sfrs")));
#define NVMPWP NVMPWP
extern volatile unsigned int   NVMPWP __attribute__((section("sfrs")));
typedef struct {
  unsigned PWP:24;
  unsigned :7;
  unsigned PWPULOCK:1;
} __NVMPWPbits_t;
extern volatile __NVMPWPbits_t NVMPWPbits __asm__ ("NVMPWP") __attribute__((section("sfrs")));
extern volatile unsigned int        NVMPWPCLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMPWPSET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMPWPINV __attribute__((section("sfrs")));
#define NVMBWP NVMBWP
extern volatile unsigned int   NVMBWP __attribute__((section("sfrs")));
typedef struct {
  unsigned UBWP0:1;
  unsigned UBWP1:1;
  unsigned UBWP2:1;
  unsigned UBWP3:1;
  unsigned UBWP4:1;
  unsigned :2;
  unsigned UBWPULOCK:1;
  unsigned LBWP0:1;
  unsigned LBWP1:1;
  unsigned LBWP2:1;
  unsigned LBWP3:1;
  unsigned LBWP4:1;
  unsigned :2;
  unsigned LBWPULOCK:1;
} __NVMBWPbits_t;
extern volatile __NVMBWPbits_t NVMBWPbits __asm__ ("NVMBWP") __attribute__((section("sfrs")));
extern volatile unsigned int        NVMBWPCLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMBWPSET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMBWPINV __attribute__((section("sfrs")));
#define NVMCON2 NVMCON2
extern volatile unsigned int   NVMCON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :6;
    unsigned SWAPLOCK:2;
  };
  struct {
    unsigned :8;
    unsigned ERETRY:2;
    unsigned :2;
    unsigned VREAD1:1;
    unsigned CREAD1:1;
    unsigned :1;
    unsigned LPRD:1;
    unsigned LPRDWS:5;
    unsigned :7;
    unsigned ERSCNT:4;
  };
} __NVMCON2bits_t;
extern volatile __NVMCON2bits_t NVMCON2bits __asm__ ("NVMCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        NVMCON2INV __attribute__((section("sfrs")));
#define WDTCON WDTCON
extern volatile unsigned int   WDTCON __attribute__((section("sfrs")));
typedef struct {
  unsigned WDTWINEN:1;
  unsigned :7;
  unsigned RUNDIV:5;
  unsigned :2;
  unsigned ON:1;
  unsigned WDTCLRKEY:16;
} __WDTCONbits_t;
extern volatile __WDTCONbits_t WDTCONbits __asm__ ("WDTCON") __attribute__((section("sfrs")));
extern volatile unsigned int        WDTCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        WDTCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        WDTCONINV __attribute__((section("sfrs")));
#define DMTCON DMTCON
extern volatile unsigned int   DMTCON __attribute__((section("sfrs")));
typedef struct {
  unsigned :15;
  unsigned ON:1;
} __DMTCONbits_t;
extern volatile __DMTCONbits_t DMTCONbits __asm__ ("DMTCON") __attribute__((section("sfrs")));
#define DMTPRECLR DMTPRECLR
extern volatile unsigned int   DMTPRECLR __attribute__((section("sfrs")));
typedef struct {
  unsigned :8;
  unsigned STEP1:8;
} __DMTPRECLRbits_t;
extern volatile __DMTPRECLRbits_t DMTPRECLRbits __asm__ ("DMTPRECLR") __attribute__((section("sfrs")));
#define DMTCLR DMTCLR
extern volatile unsigned int   DMTCLR __attribute__((section("sfrs")));
typedef struct {
  unsigned STEP2:8;
} __DMTCLRbits_t;
extern volatile __DMTCLRbits_t DMTCLRbits __asm__ ("DMTCLR") __attribute__((section("sfrs")));
#define DMTSTAT DMTSTAT
extern volatile unsigned int   DMTSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned WINOPN:1;
    unsigned :4;
    unsigned DMTEVENT:1;
    unsigned BAD:2;
  };
  struct {
    unsigned :6;
    unsigned BAD2:1;
    unsigned BAD1:1;
  };
  struct {
    unsigned w:32;
  };
} __DMTSTATbits_t;
extern volatile __DMTSTATbits_t DMTSTATbits __asm__ ("DMTSTAT") __attribute__((section("sfrs")));
#define DMTCNT DMTCNT
extern volatile unsigned int   DMTCNT __attribute__((section("sfrs")));
typedef struct {
  unsigned COUNTER:32;
} __DMTCNTbits_t;
extern volatile __DMTCNTbits_t DMTCNTbits __asm__ ("DMTCNT") __attribute__((section("sfrs")));
#define DMTPSCNT DMTPSCNT
extern volatile unsigned int   DMTPSCNT __attribute__((section("sfrs")));
typedef struct {
  unsigned PSCNT:32;
} __DMTPSCNTbits_t;
extern volatile __DMTPSCNTbits_t DMTPSCNTbits __asm__ ("DMTPSCNT") __attribute__((section("sfrs")));
#define DMTPSINTV DMTPSINTV
extern volatile unsigned int   DMTPSINTV __attribute__((section("sfrs")));
typedef struct {
  unsigned PSINTV:32;
} __DMTPSINTVbits_t;
extern volatile __DMTPSINTVbits_t DMTPSINTVbits __asm__ ("DMTPSINTV") __attribute__((section("sfrs")));
#define RTCCON RTCCON
extern volatile unsigned int   RTCCON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RTCOE:1;
    unsigned HALFSEC:1;
    unsigned RTCSYNC:1;
    unsigned RTCWREN:1;
    unsigned :2;
    unsigned RTCCLKON:1;
    unsigned RTCOUTSEL:2;
    unsigned RTCCLKSEL:2;
    unsigned :2;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned CAL:10;
  };
  struct {
    unsigned w:32;
  };
} __RTCCONbits_t;
extern volatile __RTCCONbits_t RTCCONbits __asm__ ("RTCCON") __attribute__((section("sfrs")));
extern volatile unsigned int        RTCCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RTCCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        RTCCONINV __attribute__((section("sfrs")));
#define RTCALRM RTCALRM
extern volatile unsigned int   RTCALRM __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ARPT:8;
    unsigned AMASK:4;
    unsigned ALRMSYNC:1;
    unsigned PIV:1;
    unsigned CHIME:1;
    unsigned ALRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __RTCALRMbits_t;
extern volatile __RTCALRMbits_t RTCALRMbits __asm__ ("RTCALRM") __attribute__((section("sfrs")));
extern volatile unsigned int        RTCALRMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RTCALRMSET __attribute__((section("sfrs")));
extern volatile unsigned int        RTCALRMINV __attribute__((section("sfrs")));
#define RTCTIME RTCTIME
extern volatile unsigned int   RTCTIME __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SEC01:4;
    unsigned SEC10:4;
    unsigned MIN01:4;
    unsigned MIN10:4;
    unsigned HR01:4;
    unsigned HR10:4;
  };
  struct {
    unsigned w:32;
  };
} __RTCTIMEbits_t;
extern volatile __RTCTIMEbits_t RTCTIMEbits __asm__ ("RTCTIME") __attribute__((section("sfrs")));
extern volatile unsigned int        RTCTIMECLR __attribute__((section("sfrs")));
extern volatile unsigned int        RTCTIMESET __attribute__((section("sfrs")));
extern volatile unsigned int        RTCTIMEINV __attribute__((section("sfrs")));
#define RTCDATE RTCDATE
extern volatile unsigned int   RTCDATE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned WDAY01:4;
    unsigned :4;
    unsigned DAY01:4;
    unsigned DAY10:4;
    unsigned MONTH01:4;
    unsigned MONTH10:4;
    unsigned YEAR01:4;
    unsigned YEAR10:4;
  };
  struct {
    unsigned w:32;
  };
} __RTCDATEbits_t;
extern volatile __RTCDATEbits_t RTCDATEbits __asm__ ("RTCDATE") __attribute__((section("sfrs")));
extern volatile unsigned int        RTCDATECLR __attribute__((section("sfrs")));
extern volatile unsigned int        RTCDATESET __attribute__((section("sfrs")));
extern volatile unsigned int        RTCDATEINV __attribute__((section("sfrs")));
#define ALRMTIME ALRMTIME
extern volatile unsigned int   ALRMTIME __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SEC01:4;
    unsigned SEC10:4;
    unsigned MIN01:4;
    unsigned MIN10:4;
    unsigned HR01:4;
    unsigned HR10:4;
  };
  struct {
    unsigned w:32;
  };
} __ALRMTIMEbits_t;
extern volatile __ALRMTIMEbits_t ALRMTIMEbits __asm__ ("ALRMTIME") __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMTIMECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMTIMESET __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMTIMEINV __attribute__((section("sfrs")));
#define ALRMDATE ALRMDATE
extern volatile unsigned int   ALRMDATE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned WDAY01:4;
    unsigned :4;
    unsigned DAY01:4;
    unsigned DAY10:4;
    unsigned MONTH01:4;
    unsigned MONTH10:4;
  };
  struct {
    unsigned w:32;
  };
} __ALRMDATEbits_t;
extern volatile __ALRMDATEbits_t ALRMDATEbits __asm__ ("ALRMDATE") __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMDATECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMDATESET __attribute__((section("sfrs")));
extern volatile unsigned int        ALRMDATEINV __attribute__((section("sfrs")));
#define CVRCON CVRCON
extern volatile unsigned int   CVRCON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CVR:4;
    unsigned CVRSS:1;
    unsigned CVRR:1;
    unsigned CVROE:1;
    unsigned :8;
    unsigned ON:1;
  };
  struct {
    unsigned CVR0:1;
    unsigned CVR1:1;
    unsigned CVR2:1;
    unsigned CVR3:1;
  };
  struct {
    unsigned w:32;
  };
} __CVRCONbits_t;
extern volatile __CVRCONbits_t CVRCONbits __asm__ ("CVRCON") __attribute__((section("sfrs")));
extern volatile unsigned int        CVRCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CVRCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        CVRCONINV __attribute__((section("sfrs")));
#define _ICDCON _ICDCON
extern volatile unsigned int   _ICDCON __attribute__((section("sfrs")));
typedef struct {
  unsigned CKSWBKEN:1;
  unsigned SLPBKEN:1;
  unsigned WDTBKEN:1;
  unsigned WDTEN:1;
  unsigned RSTBUG:1;
  unsigned DMTBKEN:1;
  unsigned DMTEN:1;
  unsigned :7;
  unsigned FRZ:1;
} ___ICDCONbits_t;
extern volatile ___ICDCONbits_t _ICDCONbits __asm__ ("_ICDCON") __attribute__((section("sfrs")));
#define _ICDSTAT _ICDSTAT
extern volatile unsigned int   _ICDSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CKSWBF:1;
  unsigned SLPBF:1;
  unsigned WDTBF:1;
  unsigned DMTBF:1;
} ___ICDSTATbits_t;
extern volatile ___ICDSTATbits_t _ICDSTATbits __asm__ ("_ICDSTAT") __attribute__((section("sfrs")));
#define OSCCON OSCCON
extern volatile unsigned int   OSCCON __attribute__((section("sfrs")));
typedef struct {
  unsigned OSWEN:1;
  unsigned SOSCEN:1;
  unsigned :1;
  unsigned CF:1;
  unsigned SLPEN:1;
  unsigned :2;
  unsigned CLKLOCK:1;
  unsigned NOSC:3;
  unsigned :1;
  unsigned COSC:3;
  unsigned :6;
  unsigned SLP2SPD:1;
  unsigned :1;
  unsigned DRMEN:1;
  unsigned FRCDIV:3;
} __OSCCONbits_t;
extern volatile __OSCCONbits_t OSCCONbits __asm__ ("OSCCON") __attribute__((section("sfrs")));
extern volatile unsigned int        OSCCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OSCCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OSCCONINV __attribute__((section("sfrs")));
#define OSCTUN OSCTUN
extern volatile unsigned int   OSCTUN __attribute__((section("sfrs")));
typedef struct {
  unsigned TUN:6;
} __OSCTUNbits_t;
extern volatile __OSCTUNbits_t OSCTUNbits __asm__ ("OSCTUN") __attribute__((section("sfrs")));
extern volatile unsigned int        OSCTUNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OSCTUNSET __attribute__((section("sfrs")));
extern volatile unsigned int        OSCTUNINV __attribute__((section("sfrs")));
#define SPLLCON SPLLCON
extern volatile unsigned int   SPLLCON __attribute__((section("sfrs")));
typedef struct {
  unsigned PLLRANGE:3;
  unsigned :4;
  unsigned PLLICLK:1;
  unsigned PLLIDIV:3;
  unsigned :5;
  unsigned PLLMULT:7;
  unsigned :1;
  unsigned PLLODIV:3;
} __SPLLCONbits_t;
extern volatile __SPLLCONbits_t SPLLCONbits __asm__ ("SPLLCON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPLLCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPLLCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPLLCONINV __attribute__((section("sfrs")));
#define RCON RCON
extern volatile unsigned int   RCON __attribute__((section("sfrs")));
typedef struct {
  unsigned POR:1;
  unsigned BOR:1;
  unsigned IDLE:1;
  unsigned SLEEP:1;
  unsigned WDTO:1;
  unsigned DMTO:1;
  unsigned SWR:1;
  unsigned EXTR:1;
  unsigned :1;
  unsigned CMR:1;
  unsigned :16;
  unsigned BCFGFAIL:1;
  unsigned BCFGERR:1;
} __RCONbits_t;
extern volatile __RCONbits_t RCONbits __asm__ ("RCON") __attribute__((section("sfrs")));
extern volatile unsigned int        RCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        RCONINV __attribute__((section("sfrs")));
#define RSWRST RSWRST
extern volatile unsigned int   RSWRST __attribute__((section("sfrs")));
typedef struct {
  unsigned SWRST:1;
} __RSWRSTbits_t;
extern volatile __RSWRSTbits_t RSWRSTbits __asm__ ("RSWRST") __attribute__((section("sfrs")));
extern volatile unsigned int        RSWRSTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RSWRSTSET __attribute__((section("sfrs")));
extern volatile unsigned int        RSWRSTINV __attribute__((section("sfrs")));
#define RNMICON RNMICON
extern volatile unsigned int   RNMICON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned NMICNT:16;
    unsigned WDTS:1;
    unsigned CF:1;
    unsigned :1;
    unsigned GNMI:1;
    unsigned :3;
    unsigned SWNMI:1;
    unsigned WDTO:1;
    unsigned DMTO:1;
  };
  struct {
    unsigned :24;
    unsigned WDTR:1;
  };
} __RNMICONbits_t;
extern volatile __RNMICONbits_t RNMICONbits __asm__ ("RNMICON") __attribute__((section("sfrs")));
extern volatile unsigned int        RNMICONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        RNMICONSET __attribute__((section("sfrs")));
extern volatile unsigned int        RNMICONINV __attribute__((section("sfrs")));
#define PWRCON PWRCON
extern volatile unsigned int   PWRCON __attribute__((section("sfrs")));
typedef struct {
  unsigned VREGS:1;
} __PWRCONbits_t;
extern volatile __PWRCONbits_t PWRCONbits __asm__ ("PWRCON") __attribute__((section("sfrs")));
extern volatile unsigned int        PWRCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PWRCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        PWRCONINV __attribute__((section("sfrs")));
#define REFO1CON REFO1CON
extern volatile unsigned int   REFO1CON __attribute__((section("sfrs")));
typedef struct {
  unsigned ROSEL:4;
  unsigned :4;
  unsigned ACTIVE:1;
  unsigned DIVSWEN:1;
  unsigned :1;
  unsigned RSLP:1;
  unsigned OE:1;
  unsigned SIDL:1;
  unsigned :1;
  unsigned ON:1;
  unsigned RODIV:15;
} __REFO1CONbits_t;
extern volatile __REFO1CONbits_t REFO1CONbits __asm__ ("REFO1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1CONINV __attribute__((section("sfrs")));
#define REFO1TRIM REFO1TRIM
extern volatile unsigned int   REFO1TRIM __attribute__((section("sfrs")));
typedef struct {
  unsigned :23;
  unsigned ROTRIM:9;
} __REFO1TRIMbits_t;
extern volatile __REFO1TRIMbits_t REFO1TRIMbits __asm__ ("REFO1TRIM") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1TRIMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1TRIMSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO1TRIMINV __attribute__((section("sfrs")));
#define REFO2CON REFO2CON
extern volatile unsigned int   REFO2CON __attribute__((section("sfrs")));
typedef struct {
  unsigned ROSEL:4;
  unsigned :4;
  unsigned ACTIVE:1;
  unsigned DIVSWEN:1;
  unsigned :1;
  unsigned RSLP:1;
  unsigned OE:1;
  unsigned SIDL:1;
  unsigned :1;
  unsigned ON:1;
  unsigned RODIV:15;
} __REFO2CONbits_t;
extern volatile __REFO2CONbits_t REFO2CONbits __asm__ ("REFO2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2CONINV __attribute__((section("sfrs")));
#define REFO2TRIM REFO2TRIM
extern volatile unsigned int   REFO2TRIM __attribute__((section("sfrs")));
typedef struct {
  unsigned :23;
  unsigned ROTRIM:9;
} __REFO2TRIMbits_t;
extern volatile __REFO2TRIMbits_t REFO2TRIMbits __asm__ ("REFO2TRIM") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2TRIMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2TRIMSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO2TRIMINV __attribute__((section("sfrs")));
#define REFO3CON REFO3CON
extern volatile unsigned int   REFO3CON __attribute__((section("sfrs")));
typedef struct {
  unsigned ROSEL:4;
  unsigned :4;
  unsigned ACTIVE:1;
  unsigned DIVSWEN:1;
  unsigned :1;
  unsigned RSLP:1;
  unsigned OE:1;
  unsigned SIDL:1;
  unsigned :1;
  unsigned ON:1;
  unsigned RODIV:15;
} __REFO3CONbits_t;
extern volatile __REFO3CONbits_t REFO3CONbits __asm__ ("REFO3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3CONINV __attribute__((section("sfrs")));
#define REFO3TRIM REFO3TRIM
extern volatile unsigned int   REFO3TRIM __attribute__((section("sfrs")));
typedef struct {
  unsigned :23;
  unsigned ROTRIM:9;
} __REFO3TRIMbits_t;
extern volatile __REFO3TRIMbits_t REFO3TRIMbits __asm__ ("REFO3TRIM") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3TRIMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3TRIMSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO3TRIMINV __attribute__((section("sfrs")));
#define REFO4CON REFO4CON
extern volatile unsigned int   REFO4CON __attribute__((section("sfrs")));
typedef struct {
  unsigned ROSEL:4;
  unsigned :4;
  unsigned ACTIVE:1;
  unsigned DIVSWEN:1;
  unsigned :1;
  unsigned RSLP:1;
  unsigned OE:1;
  unsigned SIDL:1;
  unsigned :1;
  unsigned ON:1;
  unsigned RODIV:15;
} __REFO4CONbits_t;
extern volatile __REFO4CONbits_t REFO4CONbits __asm__ ("REFO4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4CONINV __attribute__((section("sfrs")));
#define REFO4TRIM REFO4TRIM
extern volatile unsigned int   REFO4TRIM __attribute__((section("sfrs")));
typedef struct {
  unsigned :23;
  unsigned ROTRIM:9;
} __REFO4TRIMbits_t;
extern volatile __REFO4TRIMbits_t REFO4TRIMbits __asm__ ("REFO4TRIM") __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4TRIMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4TRIMSET __attribute__((section("sfrs")));
extern volatile unsigned int        REFO4TRIMINV __attribute__((section("sfrs")));
#define PB1DIV PB1DIV
extern volatile unsigned int   PB1DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
} __PB1DIVbits_t;
extern volatile __PB1DIVbits_t PB1DIVbits __asm__ ("PB1DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB1DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB1DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB1DIVINV __attribute__((section("sfrs")));
#define PB2DIV PB2DIV
extern volatile unsigned int   PB2DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB2DIVbits_t;
extern volatile __PB2DIVbits_t PB2DIVbits __asm__ ("PB2DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB2DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB2DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB2DIVINV __attribute__((section("sfrs")));
#define PB3DIV PB3DIV
extern volatile unsigned int   PB3DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB3DIVbits_t;
extern volatile __PB3DIVbits_t PB3DIVbits __asm__ ("PB3DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB3DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB3DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB3DIVINV __attribute__((section("sfrs")));
#define PB4DIV PB4DIV
extern volatile unsigned int   PB4DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB4DIVbits_t;
extern volatile __PB4DIVbits_t PB4DIVbits __asm__ ("PB4DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB4DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB4DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB4DIVINV __attribute__((section("sfrs")));
#define PB5DIV PB5DIV
extern volatile unsigned int   PB5DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB5DIVbits_t;
extern volatile __PB5DIVbits_t PB5DIVbits __asm__ ("PB5DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB5DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB5DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB5DIVINV __attribute__((section("sfrs")));
#define PB7DIV PB7DIV
extern volatile unsigned int   PB7DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB7DIVbits_t;
extern volatile __PB7DIVbits_t PB7DIVbits __asm__ ("PB7DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB7DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB7DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB7DIVINV __attribute__((section("sfrs")));
#define PB8DIV PB8DIV
extern volatile unsigned int   PB8DIV __attribute__((section("sfrs")));
typedef struct {
  unsigned PBDIV:7;
  unsigned :4;
  unsigned PBDIVRDY:1;
  unsigned :3;
  unsigned ON:1;
} __PB8DIVbits_t;
extern volatile __PB8DIVbits_t PB8DIVbits __asm__ ("PB8DIV") __attribute__((section("sfrs")));
extern volatile unsigned int        PB8DIVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PB8DIVSET __attribute__((section("sfrs")));
extern volatile unsigned int        PB8DIVINV __attribute__((section("sfrs")));
#define SLEWCON SLEWCON
extern volatile unsigned int   SLEWCON __attribute__((section("sfrs")));
typedef struct {
  unsigned BUSY:1;
  unsigned DNEN:1;
  unsigned UPEN:1;
  unsigned :5;
  unsigned SLWDIV:3;
  unsigned :5;
  unsigned SYSDIV:4;
} __SLEWCONbits_t;
extern volatile __SLEWCONbits_t SLEWCONbits __asm__ ("SLEWCON") __attribute__((section("sfrs")));
extern volatile unsigned int        SLEWCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SLEWCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SLEWCONINV __attribute__((section("sfrs")));
#define CLKSTAT CLKSTAT
extern volatile unsigned int   CLKSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FRCRDY:1;
    unsigned SPDIVRDY:1;
    unsigned POSCRDY:1;
    unsigned :1;
    unsigned SOSCRDY:1;
    unsigned LPRCRDY:1;
  };
  struct {
    unsigned :1;
    unsigned DIVSPLLRDY:1;
  };
} __CLKSTATbits_t;
extern volatile __CLKSTATbits_t CLKSTATbits __asm__ ("CLKSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        CLKSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CLKSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        CLKSTATINV __attribute__((section("sfrs")));
#define INT1R INT1R
extern volatile unsigned int   INT1R __attribute__((section("sfrs")));
typedef struct {
  unsigned INT1R:4;
} __INT1Rbits_t;
extern volatile __INT1Rbits_t INT1Rbits __asm__ ("INT1R") __attribute__((section("sfrs")));
#define INT2R INT2R
extern volatile unsigned int   INT2R __attribute__((section("sfrs")));
typedef struct {
  unsigned INT2R:4;
} __INT2Rbits_t;
extern volatile __INT2Rbits_t INT2Rbits __asm__ ("INT2R") __attribute__((section("sfrs")));
#define INT3R INT3R
extern volatile unsigned int   INT3R __attribute__((section("sfrs")));
typedef struct {
  unsigned INT3R:4;
} __INT3Rbits_t;
extern volatile __INT3Rbits_t INT3Rbits __asm__ ("INT3R") __attribute__((section("sfrs")));
#define INT4R INT4R
extern volatile unsigned int   INT4R __attribute__((section("sfrs")));
typedef struct {
  unsigned INT4R:4;
} __INT4Rbits_t;
extern volatile __INT4Rbits_t INT4Rbits __asm__ ("INT4R") __attribute__((section("sfrs")));
#define T2CKR T2CKR
extern volatile unsigned int   T2CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T2CKR:4;
} __T2CKRbits_t;
extern volatile __T2CKRbits_t T2CKRbits __asm__ ("T2CKR") __attribute__((section("sfrs")));
#define T3CKR T3CKR
extern volatile unsigned int   T3CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T3CKR:4;
} __T3CKRbits_t;
extern volatile __T3CKRbits_t T3CKRbits __asm__ ("T3CKR") __attribute__((section("sfrs")));
#define T4CKR T4CKR
extern volatile unsigned int   T4CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T4CKR:4;
} __T4CKRbits_t;
extern volatile __T4CKRbits_t T4CKRbits __asm__ ("T4CKR") __attribute__((section("sfrs")));
#define T5CKR T5CKR
extern volatile unsigned int   T5CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T5CKR:4;
} __T5CKRbits_t;
extern volatile __T5CKRbits_t T5CKRbits __asm__ ("T5CKR") __attribute__((section("sfrs")));
#define T6CKR T6CKR
extern volatile unsigned int   T6CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T6CKR:4;
} __T6CKRbits_t;
extern volatile __T6CKRbits_t T6CKRbits __asm__ ("T6CKR") __attribute__((section("sfrs")));
#define T7CKR T7CKR
extern volatile unsigned int   T7CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T7CKR:4;
} __T7CKRbits_t;
extern volatile __T7CKRbits_t T7CKRbits __asm__ ("T7CKR") __attribute__((section("sfrs")));
#define T8CKR T8CKR
extern volatile unsigned int   T8CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T8CKR:4;
} __T8CKRbits_t;
extern volatile __T8CKRbits_t T8CKRbits __asm__ ("T8CKR") __attribute__((section("sfrs")));
#define T9CKR T9CKR
extern volatile unsigned int   T9CKR __attribute__((section("sfrs")));
typedef struct {
  unsigned T9CKR:4;
} __T9CKRbits_t;
extern volatile __T9CKRbits_t T9CKRbits __asm__ ("T9CKR") __attribute__((section("sfrs")));
#define IC1R IC1R
extern volatile unsigned int   IC1R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC1R:4;
} __IC1Rbits_t;
extern volatile __IC1Rbits_t IC1Rbits __asm__ ("IC1R") __attribute__((section("sfrs")));
#define IC2R IC2R
extern volatile unsigned int   IC2R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC2R:4;
} __IC2Rbits_t;
extern volatile __IC2Rbits_t IC2Rbits __asm__ ("IC2R") __attribute__((section("sfrs")));
#define IC3R IC3R
extern volatile unsigned int   IC3R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC3R:4;
} __IC3Rbits_t;
extern volatile __IC3Rbits_t IC3Rbits __asm__ ("IC3R") __attribute__((section("sfrs")));
#define IC4R IC4R
extern volatile unsigned int   IC4R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC4R:4;
} __IC4Rbits_t;
extern volatile __IC4Rbits_t IC4Rbits __asm__ ("IC4R") __attribute__((section("sfrs")));
#define IC5R IC5R
extern volatile unsigned int   IC5R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC5R:4;
} __IC5Rbits_t;
extern volatile __IC5Rbits_t IC5Rbits __asm__ ("IC5R") __attribute__((section("sfrs")));
#define IC6R IC6R
extern volatile unsigned int   IC6R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC6R:4;
} __IC6Rbits_t;
extern volatile __IC6Rbits_t IC6Rbits __asm__ ("IC6R") __attribute__((section("sfrs")));
#define IC7R IC7R
extern volatile unsigned int   IC7R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC7R:4;
} __IC7Rbits_t;
extern volatile __IC7Rbits_t IC7Rbits __asm__ ("IC7R") __attribute__((section("sfrs")));
#define IC8R IC8R
extern volatile unsigned int   IC8R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC8R:4;
} __IC8Rbits_t;
extern volatile __IC8Rbits_t IC8Rbits __asm__ ("IC8R") __attribute__((section("sfrs")));
#define IC9R IC9R
extern volatile unsigned int   IC9R __attribute__((section("sfrs")));
typedef struct {
  unsigned IC9R:4;
} __IC9Rbits_t;
extern volatile __IC9Rbits_t IC9Rbits __asm__ ("IC9R") __attribute__((section("sfrs")));
#define OCFAR OCFAR
extern volatile unsigned int   OCFAR __attribute__((section("sfrs")));
typedef struct {
  unsigned OCFAR:4;
} __OCFARbits_t;
extern volatile __OCFARbits_t OCFARbits __asm__ ("OCFAR") __attribute__((section("sfrs")));
#define U1RXR U1RXR
extern volatile unsigned int   U1RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U1RXR:4;
} __U1RXRbits_t;
extern volatile __U1RXRbits_t U1RXRbits __asm__ ("U1RXR") __attribute__((section("sfrs")));
#define U1CTSR U1CTSR
extern volatile unsigned int   U1CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U1CTSR:4;
} __U1CTSRbits_t;
extern volatile __U1CTSRbits_t U1CTSRbits __asm__ ("U1CTSR") __attribute__((section("sfrs")));
#define U2RXR U2RXR
extern volatile unsigned int   U2RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U2RXR:4;
} __U2RXRbits_t;
extern volatile __U2RXRbits_t U2RXRbits __asm__ ("U2RXR") __attribute__((section("sfrs")));
#define U2CTSR U2CTSR
extern volatile unsigned int   U2CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U2CTSR:4;
} __U2CTSRbits_t;
extern volatile __U2CTSRbits_t U2CTSRbits __asm__ ("U2CTSR") __attribute__((section("sfrs")));
#define U3RXR U3RXR
extern volatile unsigned int   U3RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U3RXR:4;
} __U3RXRbits_t;
extern volatile __U3RXRbits_t U3RXRbits __asm__ ("U3RXR") __attribute__((section("sfrs")));
#define U3CTSR U3CTSR
extern volatile unsigned int   U3CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U3CTSR:4;
} __U3CTSRbits_t;
extern volatile __U3CTSRbits_t U3CTSRbits __asm__ ("U3CTSR") __attribute__((section("sfrs")));
#define U4RXR U4RXR
extern volatile unsigned int   U4RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U4RXR:4;
} __U4RXRbits_t;
extern volatile __U4RXRbits_t U4RXRbits __asm__ ("U4RXR") __attribute__((section("sfrs")));
#define U4CTSR U4CTSR
extern volatile unsigned int   U4CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U4CTSR:4;
} __U4CTSRbits_t;
extern volatile __U4CTSRbits_t U4CTSRbits __asm__ ("U4CTSR") __attribute__((section("sfrs")));
#define U5RXR U5RXR
extern volatile unsigned int   U5RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U5RXR:4;
} __U5RXRbits_t;
extern volatile __U5RXRbits_t U5RXRbits __asm__ ("U5RXR") __attribute__((section("sfrs")));
#define U5CTSR U5CTSR
extern volatile unsigned int   U5CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U5CTSR:4;
} __U5CTSRbits_t;
extern volatile __U5CTSRbits_t U5CTSRbits __asm__ ("U5CTSR") __attribute__((section("sfrs")));
#define U6RXR U6RXR
extern volatile unsigned int   U6RXR __attribute__((section("sfrs")));
typedef struct {
  unsigned U6RXR:4;
} __U6RXRbits_t;
extern volatile __U6RXRbits_t U6RXRbits __asm__ ("U6RXR") __attribute__((section("sfrs")));
#define U6CTSR U6CTSR
extern volatile unsigned int   U6CTSR __attribute__((section("sfrs")));
typedef struct {
  unsigned U6CTSR:4;
} __U6CTSRbits_t;
extern volatile __U6CTSRbits_t U6CTSRbits __asm__ ("U6CTSR") __attribute__((section("sfrs")));
#define SDI1R SDI1R
extern volatile unsigned int   SDI1R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI1R:4;
} __SDI1Rbits_t;
extern volatile __SDI1Rbits_t SDI1Rbits __asm__ ("SDI1R") __attribute__((section("sfrs")));
#define SS1R SS1R
extern volatile unsigned int   SS1R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS1R:4;
} __SS1Rbits_t;
extern volatile __SS1Rbits_t SS1Rbits __asm__ ("SS1R") __attribute__((section("sfrs")));
#define SDI2R SDI2R
extern volatile unsigned int   SDI2R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI2R:4;
} __SDI2Rbits_t;
extern volatile __SDI2Rbits_t SDI2Rbits __asm__ ("SDI2R") __attribute__((section("sfrs")));
#define SS2R SS2R
extern volatile unsigned int   SS2R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS2R:4;
} __SS2Rbits_t;
extern volatile __SS2Rbits_t SS2Rbits __asm__ ("SS2R") __attribute__((section("sfrs")));
#define SDI3R SDI3R
extern volatile unsigned int   SDI3R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI3R:4;
} __SDI3Rbits_t;
extern volatile __SDI3Rbits_t SDI3Rbits __asm__ ("SDI3R") __attribute__((section("sfrs")));
#define SS3R SS3R
extern volatile unsigned int   SS3R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS3R:4;
} __SS3Rbits_t;
extern volatile __SS3Rbits_t SS3Rbits __asm__ ("SS3R") __attribute__((section("sfrs")));
#define SDI4R SDI4R
extern volatile unsigned int   SDI4R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI4R:4;
} __SDI4Rbits_t;
extern volatile __SDI4Rbits_t SDI4Rbits __asm__ ("SDI4R") __attribute__((section("sfrs")));
#define SS4R SS4R
extern volatile unsigned int   SS4R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS4R:4;
} __SS4Rbits_t;
extern volatile __SS4Rbits_t SS4Rbits __asm__ ("SS4R") __attribute__((section("sfrs")));
#define SDI5R SDI5R
extern volatile unsigned int   SDI5R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI5R:4;
} __SDI5Rbits_t;
extern volatile __SDI5Rbits_t SDI5Rbits __asm__ ("SDI5R") __attribute__((section("sfrs")));
#define SS5R SS5R
extern volatile unsigned int   SS5R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS5R:4;
} __SS5Rbits_t;
extern volatile __SS5Rbits_t SS5Rbits __asm__ ("SS5R") __attribute__((section("sfrs")));
#define SDI6R SDI6R
extern volatile unsigned int   SDI6R __attribute__((section("sfrs")));
typedef struct {
  unsigned SDI6R:4;
} __SDI6Rbits_t;
extern volatile __SDI6Rbits_t SDI6Rbits __asm__ ("SDI6R") __attribute__((section("sfrs")));
#define SS6R SS6R
extern volatile unsigned int   SS6R __attribute__((section("sfrs")));
typedef struct {
  unsigned SS6R:4;
} __SS6Rbits_t;
extern volatile __SS6Rbits_t SS6Rbits __asm__ ("SS6R") __attribute__((section("sfrs")));
#define REFCLKI1R REFCLKI1R
extern volatile unsigned int   REFCLKI1R __attribute__((section("sfrs")));
typedef struct {
  unsigned REFCLKI1R:4;
} __REFCLKI1Rbits_t;
extern volatile __REFCLKI1Rbits_t REFCLKI1Rbits __asm__ ("REFCLKI1R") __attribute__((section("sfrs")));
#define REFCLKI3R REFCLKI3R
extern volatile unsigned int   REFCLKI3R __attribute__((section("sfrs")));
typedef struct {
  unsigned REFCLKI3R:4;
} __REFCLKI3Rbits_t;
extern volatile __REFCLKI3Rbits_t REFCLKI3Rbits __asm__ ("REFCLKI3R") __attribute__((section("sfrs")));
#define REFCLKI4R REFCLKI4R
extern volatile unsigned int   REFCLKI4R __attribute__((section("sfrs")));
typedef struct {
  unsigned REFCLKI4R:4;
} __REFCLKI4Rbits_t;
extern volatile __REFCLKI4Rbits_t REFCLKI4Rbits __asm__ ("REFCLKI4R") __attribute__((section("sfrs")));
#define RPA14R RPA14R
extern volatile unsigned int   RPA14R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPA14R:4;
} __RPA14Rbits_t;
extern volatile __RPA14Rbits_t RPA14Rbits __asm__ ("RPA14R") __attribute__((section("sfrs")));
#define RPA15R RPA15R
extern volatile unsigned int   RPA15R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPA15R:4;
} __RPA15Rbits_t;
extern volatile __RPA15Rbits_t RPA15Rbits __asm__ ("RPA15R") __attribute__((section("sfrs")));
#define RPB0R RPB0R
extern volatile unsigned int   RPB0R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB0R:4;
} __RPB0Rbits_t;
extern volatile __RPB0Rbits_t RPB0Rbits __asm__ ("RPB0R") __attribute__((section("sfrs")));
#define RPB1R RPB1R
extern volatile unsigned int   RPB1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB1R:4;
} __RPB1Rbits_t;
extern volatile __RPB1Rbits_t RPB1Rbits __asm__ ("RPB1R") __attribute__((section("sfrs")));
#define RPB2R RPB2R
extern volatile unsigned int   RPB2R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB2R:4;
} __RPB2Rbits_t;
extern volatile __RPB2Rbits_t RPB2Rbits __asm__ ("RPB2R") __attribute__((section("sfrs")));
#define RPB3R RPB3R
extern volatile unsigned int   RPB3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB3R:4;
} __RPB3Rbits_t;
extern volatile __RPB3Rbits_t RPB3Rbits __asm__ ("RPB3R") __attribute__((section("sfrs")));
#define RPB5R RPB5R
extern volatile unsigned int   RPB5R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB5R:4;
} __RPB5Rbits_t;
extern volatile __RPB5Rbits_t RPB5Rbits __asm__ ("RPB5R") __attribute__((section("sfrs")));
#define RPB6R RPB6R
extern volatile unsigned int   RPB6R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB6R:4;
} __RPB6Rbits_t;
extern volatile __RPB6Rbits_t RPB6Rbits __asm__ ("RPB6R") __attribute__((section("sfrs")));
#define RPB7R RPB7R
extern volatile unsigned int   RPB7R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB7R:4;
} __RPB7Rbits_t;
extern volatile __RPB7Rbits_t RPB7Rbits __asm__ ("RPB7R") __attribute__((section("sfrs")));
#define RPB8R RPB8R
extern volatile unsigned int   RPB8R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB8R:4;
} __RPB8Rbits_t;
extern volatile __RPB8Rbits_t RPB8Rbits __asm__ ("RPB8R") __attribute__((section("sfrs")));
#define RPB9R RPB9R
extern volatile unsigned int   RPB9R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB9R:4;
} __RPB9Rbits_t;
extern volatile __RPB9Rbits_t RPB9Rbits __asm__ ("RPB9R") __attribute__((section("sfrs")));
#define RPB10R RPB10R
extern volatile unsigned int   RPB10R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB10R:4;
} __RPB10Rbits_t;
extern volatile __RPB10Rbits_t RPB10Rbits __asm__ ("RPB10R") __attribute__((section("sfrs")));
#define RPB14R RPB14R
extern volatile unsigned int   RPB14R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB14R:4;
} __RPB14Rbits_t;
extern volatile __RPB14Rbits_t RPB14Rbits __asm__ ("RPB14R") __attribute__((section("sfrs")));
#define RPB15R RPB15R
extern volatile unsigned int   RPB15R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPB15R:4;
} __RPB15Rbits_t;
extern volatile __RPB15Rbits_t RPB15Rbits __asm__ ("RPB15R") __attribute__((section("sfrs")));
#define RPC1R RPC1R
extern volatile unsigned int   RPC1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC1R:4;
} __RPC1Rbits_t;
extern volatile __RPC1Rbits_t RPC1Rbits __asm__ ("RPC1R") __attribute__((section("sfrs")));
#define RPC2R RPC2R
extern volatile unsigned int   RPC2R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC2R:4;
} __RPC2Rbits_t;
extern volatile __RPC2Rbits_t RPC2Rbits __asm__ ("RPC2R") __attribute__((section("sfrs")));
#define RPC3R RPC3R
extern volatile unsigned int   RPC3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC3R:4;
} __RPC3Rbits_t;
extern volatile __RPC3Rbits_t RPC3Rbits __asm__ ("RPC3R") __attribute__((section("sfrs")));
#define RPC4R RPC4R
extern volatile unsigned int   RPC4R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC4R:4;
} __RPC4Rbits_t;
extern volatile __RPC4Rbits_t RPC4Rbits __asm__ ("RPC4R") __attribute__((section("sfrs")));
#define RPC13R RPC13R
extern volatile unsigned int   RPC13R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC13R:4;
} __RPC13Rbits_t;
extern volatile __RPC13Rbits_t RPC13Rbits __asm__ ("RPC13R") __attribute__((section("sfrs")));
#define RPC14R RPC14R
extern volatile unsigned int   RPC14R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPC14R:4;
} __RPC14Rbits_t;
extern volatile __RPC14Rbits_t RPC14Rbits __asm__ ("RPC14R") __attribute__((section("sfrs")));
#define RPD0R RPD0R
extern volatile unsigned int   RPD0R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD0R:4;
} __RPD0Rbits_t;
extern volatile __RPD0Rbits_t RPD0Rbits __asm__ ("RPD0R") __attribute__((section("sfrs")));
#define RPD1R RPD1R
extern volatile unsigned int   RPD1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD1R:4;
} __RPD1Rbits_t;
extern volatile __RPD1Rbits_t RPD1Rbits __asm__ ("RPD1R") __attribute__((section("sfrs")));
#define RPD2R RPD2R
extern volatile unsigned int   RPD2R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD2R:4;
} __RPD2Rbits_t;
extern volatile __RPD2Rbits_t RPD2Rbits __asm__ ("RPD2R") __attribute__((section("sfrs")));
#define RPD3R RPD3R
extern volatile unsigned int   RPD3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD3R:4;
} __RPD3Rbits_t;
extern volatile __RPD3Rbits_t RPD3Rbits __asm__ ("RPD3R") __attribute__((section("sfrs")));
#define RPD4R RPD4R
extern volatile unsigned int   RPD4R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD4R:4;
} __RPD4Rbits_t;
extern volatile __RPD4Rbits_t RPD4Rbits __asm__ ("RPD4R") __attribute__((section("sfrs")));
#define RPD5R RPD5R
extern volatile unsigned int   RPD5R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD5R:4;
} __RPD5Rbits_t;
extern volatile __RPD5Rbits_t RPD5Rbits __asm__ ("RPD5R") __attribute__((section("sfrs")));
#define RPD9R RPD9R
extern volatile unsigned int   RPD9R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD9R:4;
} __RPD9Rbits_t;
extern volatile __RPD9Rbits_t RPD9Rbits __asm__ ("RPD9R") __attribute__((section("sfrs")));
#define RPD10R RPD10R
extern volatile unsigned int   RPD10R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD10R:4;
} __RPD10Rbits_t;
extern volatile __RPD10Rbits_t RPD10Rbits __asm__ ("RPD10R") __attribute__((section("sfrs")));
#define RPD11R RPD11R
extern volatile unsigned int   RPD11R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD11R:4;
} __RPD11Rbits_t;
extern volatile __RPD11Rbits_t RPD11Rbits __asm__ ("RPD11R") __attribute__((section("sfrs")));
#define RPD12R RPD12R
extern volatile unsigned int   RPD12R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD12R:4;
} __RPD12Rbits_t;
extern volatile __RPD12Rbits_t RPD12Rbits __asm__ ("RPD12R") __attribute__((section("sfrs")));
#define RPD14R RPD14R
extern volatile unsigned int   RPD14R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD14R:4;
} __RPD14Rbits_t;
extern volatile __RPD14Rbits_t RPD14Rbits __asm__ ("RPD14R") __attribute__((section("sfrs")));
#define RPD15R RPD15R
extern volatile unsigned int   RPD15R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPD15R:4;
} __RPD15Rbits_t;
extern volatile __RPD15Rbits_t RPD15Rbits __asm__ ("RPD15R") __attribute__((section("sfrs")));
#define RPE3R RPE3R
extern volatile unsigned int   RPE3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPE3R:4;
} __RPE3Rbits_t;
extern volatile __RPE3Rbits_t RPE3Rbits __asm__ ("RPE3R") __attribute__((section("sfrs")));
#define RPE5R RPE5R
extern volatile unsigned int   RPE5R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPE5R:4;
} __RPE5Rbits_t;
extern volatile __RPE5Rbits_t RPE5Rbits __asm__ ("RPE5R") __attribute__((section("sfrs")));
#define RPE8R RPE8R
extern volatile unsigned int   RPE8R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPE8R:4;
} __RPE8Rbits_t;
extern volatile __RPE8Rbits_t RPE8Rbits __asm__ ("RPE8R") __attribute__((section("sfrs")));
#define RPE9R RPE9R
extern volatile unsigned int   RPE9R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPE9R:4;
} __RPE9Rbits_t;
extern volatile __RPE9Rbits_t RPE9Rbits __asm__ ("RPE9R") __attribute__((section("sfrs")));
#define RPF0R RPF0R
extern volatile unsigned int   RPF0R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF0R:4;
} __RPF0Rbits_t;
extern volatile __RPF0Rbits_t RPF0Rbits __asm__ ("RPF0R") __attribute__((section("sfrs")));
#define RPF1R RPF1R
extern volatile unsigned int   RPF1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF1R:4;
} __RPF1Rbits_t;
extern volatile __RPF1Rbits_t RPF1Rbits __asm__ ("RPF1R") __attribute__((section("sfrs")));
#define RPF2R RPF2R
extern volatile unsigned int   RPF2R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF2R:4;
} __RPF2Rbits_t;
extern volatile __RPF2Rbits_t RPF2Rbits __asm__ ("RPF2R") __attribute__((section("sfrs")));
#define RPF3R RPF3R
extern volatile unsigned int   RPF3R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF3R:4;
} __RPF3Rbits_t;
extern volatile __RPF3Rbits_t RPF3Rbits __asm__ ("RPF3R") __attribute__((section("sfrs")));
#define RPF4R RPF4R
extern volatile unsigned int   RPF4R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF4R:4;
} __RPF4Rbits_t;
extern volatile __RPF4Rbits_t RPF4Rbits __asm__ ("RPF4R") __attribute__((section("sfrs")));
#define RPF5R RPF5R
extern volatile unsigned int   RPF5R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF5R:4;
} __RPF5Rbits_t;
extern volatile __RPF5Rbits_t RPF5Rbits __asm__ ("RPF5R") __attribute__((section("sfrs")));
#define RPF8R RPF8R
extern volatile unsigned int   RPF8R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF8R:4;
} __RPF8Rbits_t;
extern volatile __RPF8Rbits_t RPF8Rbits __asm__ ("RPF8R") __attribute__((section("sfrs")));
#define RPF12R RPF12R
extern volatile unsigned int   RPF12R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF12R:4;
} __RPF12Rbits_t;
extern volatile __RPF12Rbits_t RPF12Rbits __asm__ ("RPF12R") __attribute__((section("sfrs")));
#define RPF13R RPF13R
extern volatile unsigned int   RPF13R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPF13R:4;
} __RPF13Rbits_t;
extern volatile __RPF13Rbits_t RPF13Rbits __asm__ ("RPF13R") __attribute__((section("sfrs")));
#define RPG0R RPG0R
extern volatile unsigned int   RPG0R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG0R:4;
} __RPG0Rbits_t;
extern volatile __RPG0Rbits_t RPG0Rbits __asm__ ("RPG0R") __attribute__((section("sfrs")));
#define RPG1R RPG1R
extern volatile unsigned int   RPG1R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG1R:4;
} __RPG1Rbits_t;
extern volatile __RPG1Rbits_t RPG1Rbits __asm__ ("RPG1R") __attribute__((section("sfrs")));
#define RPG6R RPG6R
extern volatile unsigned int   RPG6R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG6R:4;
} __RPG6Rbits_t;
extern volatile __RPG6Rbits_t RPG6Rbits __asm__ ("RPG6R") __attribute__((section("sfrs")));
#define RPG7R RPG7R
extern volatile unsigned int   RPG7R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG7R:4;
} __RPG7Rbits_t;
extern volatile __RPG7Rbits_t RPG7Rbits __asm__ ("RPG7R") __attribute__((section("sfrs")));
#define RPG8R RPG8R
extern volatile unsigned int   RPG8R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG8R:4;
} __RPG8Rbits_t;
extern volatile __RPG8Rbits_t RPG8Rbits __asm__ ("RPG8R") __attribute__((section("sfrs")));
#define RPG9R RPG9R
extern volatile unsigned int   RPG9R __attribute__((section("sfrs")));
typedef struct {
  unsigned RPG9R:4;
} __RPG9Rbits_t;
extern volatile __RPG9Rbits_t RPG9Rbits __asm__ ("RPG9R") __attribute__((section("sfrs")));
#define INTCON INTCON
extern volatile unsigned int   INTCON __attribute__((section("sfrs")));
typedef struct {
  unsigned INT0EP:1;
  unsigned INT1EP:1;
  unsigned INT2EP:1;
  unsigned INT3EP:1;
  unsigned INT4EP:1;
  unsigned :3;
  unsigned TPC:3;
  unsigned :1;
  unsigned MVEC:1;
  unsigned :11;
  unsigned NMIKEY:8;
} __INTCONbits_t;
extern volatile __INTCONbits_t INTCONbits __asm__ ("INTCON") __attribute__((section("sfrs")));
extern volatile unsigned int        INTCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        INTCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        INTCONINV __attribute__((section("sfrs")));
#define PRISS PRISS
extern volatile unsigned int   PRISS __attribute__((section("sfrs")));
typedef struct {
  unsigned SS0:1;
  unsigned :3;
  unsigned PRI1SS:4;
  unsigned PRI2SS:4;
  unsigned PRI3SS:4;
  unsigned PRI4SS:4;
  unsigned PRI5SS:4;
  unsigned PRI6SS:4;
  unsigned PRI7SS:4;
} __PRISSbits_t;
extern volatile __PRISSbits_t PRISSbits __asm__ ("PRISS") __attribute__((section("sfrs")));
extern volatile unsigned int        PRISSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PRISSSET __attribute__((section("sfrs")));
extern volatile unsigned int        PRISSINV __attribute__((section("sfrs")));
#define INTSTAT INTSTAT
extern volatile unsigned int   INTSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned SIRQ:8;
  unsigned SRIPL:3;
} __INTSTATbits_t;
extern volatile __INTSTATbits_t INTSTATbits __asm__ ("INTSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        INTSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        INTSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        INTSTATINV __attribute__((section("sfrs")));
#define IPTMR IPTMR
extern volatile unsigned int   IPTMR __attribute__((section("sfrs")));
typedef struct {
  unsigned IPTMR:32;
} __IPTMRbits_t;
extern volatile __IPTMRbits_t IPTMRbits __asm__ ("IPTMR") __attribute__((section("sfrs")));
extern volatile unsigned int        IPTMRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPTMRSET __attribute__((section("sfrs")));
extern volatile unsigned int        IPTMRINV __attribute__((section("sfrs")));
#define IFS0 IFS0
extern volatile unsigned int   IFS0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CTIF:1;
    unsigned CS0IF:1;
    unsigned CS1IF:1;
    unsigned INT0IF:1;
    unsigned T1IF:1;
    unsigned IC1EIF:1;
    unsigned IC1IF:1;
    unsigned OC1IF:1;
    unsigned INT1IF:1;
    unsigned T2IF:1;
    unsigned IC2EIF:1;
    unsigned IC2IF:1;
    unsigned OC2IF:1;
    unsigned INT2IF:1;
    unsigned T3IF:1;
    unsigned IC3EIF:1;
    unsigned IC3IF:1;
    unsigned OC3IF:1;
    unsigned INT3IF:1;
    unsigned T4IF:1;
    unsigned IC4EIF:1;
    unsigned IC4IF:1;
    unsigned OC4IF:1;
    unsigned INT4IF:1;
    unsigned T5IF:1;
    unsigned IC5EIF:1;
    unsigned IC5IF:1;
    unsigned OC5IF:1;
    unsigned T6IF:1;
    unsigned IC6EIF:1;
    unsigned IC6IF:1;
    unsigned OC6IF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS0bits_t;
extern volatile __IFS0bits_t IFS0bits __asm__ ("IFS0") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS0SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS0INV __attribute__((section("sfrs")));
#define IFS1 IFS1
extern volatile unsigned int   IFS1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T7IF:1;
    unsigned IC7EIF:1;
    unsigned IC7IF:1;
    unsigned OC7IF:1;
    unsigned T8IF:1;
    unsigned IC8EIF:1;
    unsigned IC8IF:1;
    unsigned OC8IF:1;
    unsigned T9IF:1;
    unsigned IC9EIF:1;
    unsigned IC9IF:1;
    unsigned OC9IF:1;
    unsigned ADCIF:1;
    unsigned ADCFIFOIF:1;
    unsigned ADCDC1IF:1;
    unsigned ADCDC2IF:1;
    unsigned ADCDC3IF:1;
    unsigned ADCDC4IF:1;
    unsigned ADCDC5IF:1;
    unsigned ADCDC6IF:1;
    unsigned ADCDF1IF:1;
    unsigned ADCDF2IF:1;
    unsigned ADCDF3IF:1;
    unsigned ADCDF4IF:1;
    unsigned ADCDF5IF:1;
    unsigned ADCDF6IF:1;
    unsigned ADCFLTIF:1;
    unsigned ADCD0IF:1;
    unsigned ADCD1IF:1;
    unsigned ADCD2IF:1;
    unsigned ADCD3IF:1;
    unsigned ADCD4IF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS1bits_t;
extern volatile __IFS1bits_t IFS1bits __asm__ ("IFS1") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS1SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS1INV __attribute__((section("sfrs")));
#define IFS2 IFS2
extern volatile unsigned int   IFS2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD5IF:1;
    unsigned ADCD6IF:1;
    unsigned ADCD7IF:1;
    unsigned ADCD8IF:1;
    unsigned ADCD9IF:1;
    unsigned ADCD10IF:1;
    unsigned ADCD11IF:1;
    unsigned ADCD12IF:1;
    unsigned ADCD13IF:1;
    unsigned ADCD14IF:1;
    unsigned ADCD15IF:1;
    unsigned ADCD16IF:1;
    unsigned ADCD17IF:1;
    unsigned ADCD18IF:1;
    unsigned ADCD19IF:1;
    unsigned ADCD20IF:1;
    unsigned ADCD21IF:1;
    unsigned ADCD22IF:1;
    unsigned ADCD23IF:1;
    unsigned ADCD24IF:1;
    unsigned ADCD25IF:1;
    unsigned ADCD26IF:1;
    unsigned ADCD27IF:1;
    unsigned ADCD28IF:1;
    unsigned ADCD29IF:1;
    unsigned ADCD30IF:1;
    unsigned ADCD31IF:1;
    unsigned ADCD32IF:1;
    unsigned ADCD33IF:1;
    unsigned ADCD34IF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS2bits_t;
extern volatile __IFS2bits_t IFS2bits __asm__ ("IFS2") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS2SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS2INV __attribute__((section("sfrs")));
#define IFS3 IFS3
extern volatile unsigned int   IFS3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :6;
    unsigned ADCD43IF:1;
    unsigned ADCD44IF:1;
    unsigned CPCIF:1;
    unsigned CFDCIF:1;
    unsigned SBIF:1;
    unsigned :2;
    unsigned SPI1EIF:1;
    unsigned SPI1RXIF:1;
    unsigned SPI1TXIF:1;
    unsigned U1EIF:1;
    unsigned U1RXIF:1;
    unsigned U1TXIF:1;
    unsigned I2C1BIF:1;
    unsigned I2C1SIF:1;
    unsigned I2C1MIF:1;
    unsigned CNAIF:1;
    unsigned CNBIF:1;
    unsigned CNCIF:1;
    unsigned CNDIF:1;
    unsigned CNEIF:1;
    unsigned CNFIF:1;
    unsigned CNGIF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS3bits_t;
extern volatile __IFS3bits_t IFS3bits __asm__ ("IFS3") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS3SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS3INV __attribute__((section("sfrs")));
#define IFS4 IFS4
extern volatile unsigned int   IFS4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMPIF:1;
    unsigned PMPEIF:1;
    unsigned CMP1IF:1;
    unsigned CMP2IF:1;
    unsigned USBIF:1;
    unsigned USBDMAIF:1;
    unsigned DMA0IF:1;
    unsigned DMA1IF:1;
    unsigned DMA2IF:1;
    unsigned DMA3IF:1;
    unsigned DMA4IF:1;
    unsigned DMA5IF:1;
    unsigned DMA6IF:1;
    unsigned DMA7IF:1;
    unsigned SPI2EIF:1;
    unsigned SPI2RXIF:1;
    unsigned SPI2TXIF:1;
    unsigned U2EIF:1;
    unsigned U2RXIF:1;
    unsigned U2TXIF:1;
    unsigned I2C2BIF:1;
    unsigned I2C2SIF:1;
    unsigned I2C2MIF:1;
    unsigned :2;
    unsigned ETHIF:1;
    unsigned SPI3EIF:1;
    unsigned SPI3RXIF:1;
    unsigned SPI3TXIF:1;
    unsigned U3EIF:1;
    unsigned U3RXIF:1;
    unsigned U3TXIF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS4bits_t;
extern volatile __IFS4bits_t IFS4bits __asm__ ("IFS4") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS4SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS4INV __attribute__((section("sfrs")));
#define IFS5 IFS5
extern volatile unsigned int   IFS5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C3BIF:1;
    unsigned I2C3SIF:1;
    unsigned I2C3MIF:1;
    unsigned SPI4EIF:1;
    unsigned SPI4RXIF:1;
    unsigned SPI4TXIF:1;
    unsigned RTCCIF:1;
    unsigned FCEIF:1;
    unsigned PREIF:1;
    unsigned SQI1IF:1;
    unsigned U4EIF:1;
    unsigned U4RXIF:1;
    unsigned U4TXIF:1;
    unsigned I2C4BIF:1;
    unsigned I2C4SIF:1;
    unsigned I2C4MIF:1;
    unsigned SPI5EIF:1;
    unsigned SPI5RXIF:1;
    unsigned SPI5TXIF:1;
    unsigned U5EIF:1;
    unsigned U5RXIF:1;
    unsigned U5TXIF:1;
    unsigned I2C5BIF:1;
    unsigned I2C5SIF:1;
    unsigned I2C5MIF:1;
    unsigned SPI6IF:1;
    unsigned SPI6RXIF:1;
    unsigned SPI6TX:1;
    unsigned U6EIF:1;
    unsigned U6RXIF:1;
    unsigned U6TXIF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS5bits_t;
extern volatile __IFS5bits_t IFS5bits __asm__ ("IFS5") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS5SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS5INV __attribute__((section("sfrs")));
#define IFS6 IFS6
extern volatile unsigned int   IFS6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCEOSIF:1;
    unsigned ADCARDYIF:1;
    unsigned ADCURDYIF:1;
    unsigned :1;
    unsigned ADCGRPIF:1;
    unsigned :1;
    unsigned ADC0EIF:1;
    unsigned ADC1EIF:1;
    unsigned ADC2EIF:1;
    unsigned ADC3EIF:1;
    unsigned ADC4EIF:1;
    unsigned :2;
    unsigned ADC7EIF:1;
    unsigned ADC0WIF:1;
    unsigned ADC1WIF:1;
    unsigned ADC2WIF:1;
    unsigned ADC3WIF:1;
    unsigned ADC4WIF:1;
    unsigned :2;
    unsigned ADC7WIF:1;
  };
  struct {
    unsigned w:32;
  };
} __IFS6bits_t;
extern volatile __IFS6bits_t IFS6bits __asm__ ("IFS6") __attribute__((section("sfrs")));
extern volatile unsigned int        IFS6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IFS6SET __attribute__((section("sfrs")));
extern volatile unsigned int        IFS6INV __attribute__((section("sfrs")));
#define IEC0 IEC0
extern volatile unsigned int   IEC0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CTIE:1;
    unsigned CS0IE:1;
    unsigned CS1IE:1;
    unsigned INT0IE:1;
    unsigned T1IE:1;
    unsigned IC1EIE:1;
    unsigned IC1IE:1;
    unsigned OC1IE:1;
    unsigned INT1IE:1;
    unsigned T2IE:1;
    unsigned IC2EIE:1;
    unsigned IC2IE:1;
    unsigned OC2IE:1;
    unsigned INT2IE:1;
    unsigned T3IE:1;
    unsigned IC3EIE:1;
    unsigned IC3IE:1;
    unsigned OC3IE:1;
    unsigned INT3IE:1;
    unsigned T4IE:1;
    unsigned IC4EIE:1;
    unsigned IC4IE:1;
    unsigned OC4IE:1;
    unsigned INT4IE:1;
    unsigned T5IE:1;
    unsigned IC5EIE:1;
    unsigned IC5IE:1;
    unsigned OC5IE:1;
    unsigned T6IE:1;
    unsigned IC6EIE:1;
    unsigned IC6IE:1;
    unsigned OC6IE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC0bits_t;
extern volatile __IEC0bits_t IEC0bits __asm__ ("IEC0") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC0SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC0INV __attribute__((section("sfrs")));
#define IEC1 IEC1
extern volatile unsigned int   IEC1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T7IE:1;
    unsigned IC7EIE:1;
    unsigned IC7IE:1;
    unsigned OC7IE:1;
    unsigned T8IE:1;
    unsigned IC8EIE:1;
    unsigned IC8IE:1;
    unsigned OC8IE:1;
    unsigned T9IE:1;
    unsigned IC9EIE:1;
    unsigned IC9IE:1;
    unsigned OC9IE:1;
    unsigned ADCIE:1;
    unsigned ADCFIFOIE:1;
    unsigned ADCDC1IE:1;
    unsigned ADCDC2IE:1;
    unsigned ADCDC3IE:1;
    unsigned ADCDC4IE:1;
    unsigned ADCDC5IE:1;
    unsigned ADCDC6IE:1;
    unsigned ADCDF1IE:1;
    unsigned ADCDF2IE:1;
    unsigned ADCDF3IE:1;
    unsigned ADCDF4IE:1;
    unsigned ADCDF5IE:1;
    unsigned ADCDF6IE:1;
    unsigned ADCFLTIE:1;
    unsigned ADCD0IE:1;
    unsigned ADCD1IE:1;
    unsigned ADCD2IE:1;
    unsigned ADCD3IE:1;
    unsigned ADCD4IE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC1bits_t;
extern volatile __IEC1bits_t IEC1bits __asm__ ("IEC1") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC1SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC1INV __attribute__((section("sfrs")));
#define IEC2 IEC2
extern volatile unsigned int   IEC2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD5IE:1;
    unsigned ADCD6IE:1;
    unsigned ADCD7IE:1;
    unsigned ADCD8IE:1;
    unsigned ADCD9IE:1;
    unsigned ADCD10IE:1;
    unsigned ADCD11IE:1;
    unsigned ADCD12IE:1;
    unsigned ADCD13IE:1;
    unsigned ADCD14IE:1;
    unsigned ADCD15IE:1;
    unsigned ADCD16IE:1;
    unsigned ADCD17IE:1;
    unsigned ADCD18IE:1;
    unsigned ADCD19IE:1;
    unsigned ADCD20IE:1;
    unsigned ADCD21IE:1;
    unsigned ADCD22IE:1;
    unsigned ADCD23IE:1;
    unsigned ADCD24IE:1;
    unsigned ADCD25IE:1;
    unsigned ADCD26IE:1;
    unsigned ADCD27IE:1;
    unsigned ADCD28IE:1;
    unsigned ADCD29IE:1;
    unsigned ADCD30IE:1;
    unsigned ADCD31IE:1;
    unsigned ADCD32IE:1;
    unsigned ADCD33IE:1;
    unsigned ADCD34IE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC2bits_t;
extern volatile __IEC2bits_t IEC2bits __asm__ ("IEC2") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC2SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC2INV __attribute__((section("sfrs")));
#define IEC3 IEC3
extern volatile unsigned int   IEC3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :6;
    unsigned ADCD43IE:1;
    unsigned ADCD44IE:1;
    unsigned CPCIE:1;
    unsigned CFDCIE:1;
    unsigned SBIE:1;
    unsigned :2;
    unsigned SPI1EIE:1;
    unsigned SPI1RXIE:1;
    unsigned SPI1TXIE:1;
    unsigned U1EIE:1;
    unsigned U1RXIE:1;
    unsigned U1TXIE:1;
    unsigned I2C1BIE:1;
    unsigned I2C1SIE:1;
    unsigned I2C1MIE:1;
    unsigned CNAIE:1;
    unsigned CNBIE:1;
    unsigned CNCIE:1;
    unsigned CNDIE:1;
    unsigned CNEIE:1;
    unsigned CNFIE:1;
    unsigned CNGIE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC3bits_t;
extern volatile __IEC3bits_t IEC3bits __asm__ ("IEC3") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC3SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC3INV __attribute__((section("sfrs")));
#define IEC4 IEC4
extern volatile unsigned int   IEC4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMPIE:1;
    unsigned PMPEIE:1;
    unsigned CMP1IE:1;
    unsigned CMP2IE:1;
    unsigned USBIE:1;
    unsigned USBDMAIE:1;
    unsigned DMA0IE:1;
    unsigned DMA1IE:1;
    unsigned DMA2IE:1;
    unsigned DMA3IE:1;
    unsigned DMA4IE:1;
    unsigned DMA5IE:1;
    unsigned DMA6IE:1;
    unsigned DMA7IE:1;
    unsigned SPI2EIE:1;
    unsigned SPI2RXIE:1;
    unsigned SPI2TXIE:1;
    unsigned U2EIE:1;
    unsigned U2RXIE:1;
    unsigned U2TXIE:1;
    unsigned I2C2BIE:1;
    unsigned I2C2SIE:1;
    unsigned I2C2MIE:1;
    unsigned :2;
    unsigned ETHIE:1;
    unsigned SPI3EIE:1;
    unsigned SPI3RXIE:1;
    unsigned SPI3TXIE:1;
    unsigned U3EIE:1;
    unsigned U3RXIE:1;
    unsigned U3TXIE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC4bits_t;
extern volatile __IEC4bits_t IEC4bits __asm__ ("IEC4") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC4SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC4INV __attribute__((section("sfrs")));
#define IEC5 IEC5
extern volatile unsigned int   IEC5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C3BIE:1;
    unsigned I2C3SIE:1;
    unsigned I2C3MIE:1;
    unsigned SPI4EIE:1;
    unsigned SPI4RXIE:1;
    unsigned SPI4TXIE:1;
    unsigned RTCCIE:1;
    unsigned FCEIE:1;
    unsigned PREIE:1;
    unsigned SQI1IE:1;
    unsigned U4EIE:1;
    unsigned U4RXIE:1;
    unsigned U4TXIE:1;
    unsigned I2C4BIE:1;
    unsigned I2C4SIE:1;
    unsigned I2C4MIE:1;
    unsigned SPI5EIE:1;
    unsigned SPI5RXIE:1;
    unsigned SPI5TXIE:1;
    unsigned U5EIE:1;
    unsigned U5RXIE:1;
    unsigned U5TXIE:1;
    unsigned I2C5BIE:1;
    unsigned I2C5SIE:1;
    unsigned I2C5MIE:1;
    unsigned SPI6IE:1;
    unsigned SPI6RXIE:1;
    unsigned SPI6TXIE:1;
    unsigned U6EIE:1;
    unsigned U6RXIE:1;
    unsigned U6TXIE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC5bits_t;
extern volatile __IEC5bits_t IEC5bits __asm__ ("IEC5") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC5SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC5INV __attribute__((section("sfrs")));
#define IEC6 IEC6
extern volatile unsigned int   IEC6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCEOSIE:1;
    unsigned ADCARDYIE:1;
    unsigned ADCURDYIE:1;
    unsigned :1;
    unsigned ADCGRPIE:1;
    unsigned :1;
    unsigned ADC0EIE:1;
    unsigned ADC1EIE:1;
    unsigned ADC2EIE:1;
    unsigned ADC3EIE:1;
    unsigned ADC4EIE:1;
    unsigned :2;
    unsigned ADC7EIE:1;
    unsigned ADC0WIE:1;
    unsigned ADC1WIE:1;
    unsigned ADC2WIE:1;
    unsigned ADC3WIE:1;
    unsigned ADC4WIE:1;
    unsigned :2;
    unsigned ADC7WIE:1;
  };
  struct {
    unsigned w:32;
  };
} __IEC6bits_t;
extern volatile __IEC6bits_t IEC6bits __asm__ ("IEC6") __attribute__((section("sfrs")));
extern volatile unsigned int        IEC6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IEC6SET __attribute__((section("sfrs")));
extern volatile unsigned int        IEC6INV __attribute__((section("sfrs")));
#define IPC0 IPC0
extern volatile unsigned int   IPC0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CTIS:2;
    unsigned CTIP:3;
    unsigned :3;
    unsigned CS0IS:2;
    unsigned CS0IP:3;
    unsigned :3;
    unsigned CS1IS:2;
    unsigned CS1IP:3;
    unsigned :3;
    unsigned INT0IS:2;
    unsigned INT0IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC0bits_t;
extern volatile __IPC0bits_t IPC0bits __asm__ ("IPC0") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC0SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC0INV __attribute__((section("sfrs")));
#define IPC1 IPC1
extern volatile unsigned int   IPC1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T1IS:2;
    unsigned T1IP:3;
    unsigned :3;
    unsigned IC1EIS:2;
    unsigned IC1EIP:3;
    unsigned :3;
    unsigned IC1IS:2;
    unsigned IC1IP:3;
    unsigned :3;
    unsigned OC1IS:2;
    unsigned OC1IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC1bits_t;
extern volatile __IPC1bits_t IPC1bits __asm__ ("IPC1") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC1SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC1INV __attribute__((section("sfrs")));
#define IPC2 IPC2
extern volatile unsigned int   IPC2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned INT1IS:2;
    unsigned INT1IP:3;
    unsigned :3;
    unsigned T2IS:2;
    unsigned T2IP:3;
    unsigned :3;
    unsigned IC2EIS:2;
    unsigned IC2EIP:3;
    unsigned :3;
    unsigned IC2IS:2;
    unsigned IC2IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC2bits_t;
extern volatile __IPC2bits_t IPC2bits __asm__ ("IPC2") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC2SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC2INV __attribute__((section("sfrs")));
#define IPC3 IPC3
extern volatile unsigned int   IPC3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OC2IS:2;
    unsigned OC2IP:3;
    unsigned :3;
    unsigned INT2IS:2;
    unsigned INT2IP:3;
    unsigned :3;
    unsigned T3IS:2;
    unsigned T3IP:3;
    unsigned :3;
    unsigned IC3EIS:2;
    unsigned IC3EIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC3bits_t;
extern volatile __IPC3bits_t IPC3bits __asm__ ("IPC3") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC3SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC3INV __attribute__((section("sfrs")));
#define IPC4 IPC4
extern volatile unsigned int   IPC4 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned IC3IS:2;
    unsigned IC3IP:3;
    unsigned :3;
    unsigned OC3IS:2;
    unsigned OC3IP:3;
    unsigned :3;
    unsigned INT3IS:2;
    unsigned INT3IP:3;
    unsigned :3;
    unsigned T4IS:2;
    unsigned T4IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC4bits_t;
extern volatile __IPC4bits_t IPC4bits __asm__ ("IPC4") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC4SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC4INV __attribute__((section("sfrs")));
#define IPC5 IPC5
extern volatile unsigned int   IPC5 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned IC4EIS:2;
    unsigned IC4EIP:3;
    unsigned :3;
    unsigned IC4IS:2;
    unsigned IC4IP:3;
    unsigned :3;
    unsigned OC4IS:2;
    unsigned OC4IP:3;
    unsigned :3;
    unsigned INT4IS:2;
    unsigned INT4IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC5bits_t;
extern volatile __IPC5bits_t IPC5bits __asm__ ("IPC5") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC5SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC5INV __attribute__((section("sfrs")));
#define IPC6 IPC6
extern volatile unsigned int   IPC6 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T5IS:2;
    unsigned T5IP:3;
    unsigned :3;
    unsigned IC5EIS:2;
    unsigned IC5EIP:3;
    unsigned :3;
    unsigned IC5IS:2;
    unsigned IC5IP:3;
    unsigned :3;
    unsigned OC5IS:2;
    unsigned OC5IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC6bits_t;
extern volatile __IPC6bits_t IPC6bits __asm__ ("IPC6") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC6SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC6INV __attribute__((section("sfrs")));
#define IPC7 IPC7
extern volatile unsigned int   IPC7 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T6IS:2;
    unsigned T6IP:3;
    unsigned :3;
    unsigned IC6EIS:2;
    unsigned IC6EIP:3;
    unsigned :3;
    unsigned IC6IS:2;
    unsigned IC6IP:3;
    unsigned :3;
    unsigned OC6IS:2;
    unsigned OC6IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC7bits_t;
extern volatile __IPC7bits_t IPC7bits __asm__ ("IPC7") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC7SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC7INV __attribute__((section("sfrs")));
#define IPC8 IPC8
extern volatile unsigned int   IPC8 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T7IS:2;
    unsigned T7IP:3;
    unsigned :3;
    unsigned IC7EIS:2;
    unsigned IC7EIP:3;
    unsigned :3;
    unsigned IC7IS:2;
    unsigned IC7IP:3;
    unsigned :3;
    unsigned OC7IS:2;
    unsigned OC7IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC8bits_t;
extern volatile __IPC8bits_t IPC8bits __asm__ ("IPC8") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC8SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC8INV __attribute__((section("sfrs")));
#define IPC9 IPC9
extern volatile unsigned int   IPC9 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T8IS:2;
    unsigned T8IP:3;
    unsigned :3;
    unsigned IC8EIS:2;
    unsigned IC8EIP:3;
    unsigned :3;
    unsigned IC8IS:2;
    unsigned IC8IP:3;
    unsigned :3;
    unsigned OC8IS:2;
    unsigned OC8IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC9bits_t;
extern volatile __IPC9bits_t IPC9bits __asm__ ("IPC9") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC9SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC9INV __attribute__((section("sfrs")));
#define IPC10 IPC10
extern volatile unsigned int   IPC10 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned T9IS:2;
    unsigned T9IP:3;
    unsigned :3;
    unsigned IC9EIS:2;
    unsigned IC9EIP:3;
    unsigned :3;
    unsigned IC9IS:2;
    unsigned IC9IP:3;
    unsigned :3;
    unsigned OC9IS:2;
    unsigned OC9IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC10bits_t;
extern volatile __IPC10bits_t IPC10bits __asm__ ("IPC10") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC10CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC10SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC10INV __attribute__((section("sfrs")));
#define IPC11 IPC11
extern volatile unsigned int   IPC11 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCIS:2;
    unsigned ADCIP:3;
    unsigned :3;
    unsigned ADCFIFOIS:2;
    unsigned ADCFIFOIP:3;
    unsigned :3;
    unsigned ADCDC1IS:2;
    unsigned ADCDC1IP:3;
    unsigned :3;
    unsigned ADCDC2IS:2;
    unsigned ADCDC2IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC11bits_t;
extern volatile __IPC11bits_t IPC11bits __asm__ ("IPC11") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC11CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC11SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC11INV __attribute__((section("sfrs")));
#define IPC12 IPC12
extern volatile unsigned int   IPC12 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCDC3IS:2;
    unsigned ADCDC3IP:3;
    unsigned :3;
    unsigned ADCDC4IS:2;
    unsigned ADCDC4IP:3;
    unsigned :3;
    unsigned ADCDC5IS:2;
    unsigned ADCDC5IP:3;
    unsigned :3;
    unsigned ADCDC6IS:2;
    unsigned ADCDC6IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC12bits_t;
extern volatile __IPC12bits_t IPC12bits __asm__ ("IPC12") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC12CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC12SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC12INV __attribute__((section("sfrs")));
#define IPC13 IPC13
extern volatile unsigned int   IPC13 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCDF1IS:2;
    unsigned ADCDF1IP:3;
    unsigned :3;
    unsigned ADCDF2IS:2;
    unsigned ADCDF2IP:3;
    unsigned :3;
    unsigned ADCDF3IS:2;
    unsigned ADCDF3IP:3;
    unsigned :3;
    unsigned ADCDF4IS:2;
    unsigned ADCDF4IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC13bits_t;
extern volatile __IPC13bits_t IPC13bits __asm__ ("IPC13") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC13CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC13SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC13INV __attribute__((section("sfrs")));
#define IPC14 IPC14
extern volatile unsigned int   IPC14 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCDF5IS:2;
    unsigned ADCDF5IP:3;
    unsigned :3;
    unsigned ADCDF6IS:2;
    unsigned ADCDF6IP:3;
    unsigned :3;
    unsigned ADCFLTIS:2;
    unsigned ADCFLTIP:3;
    unsigned :3;
    unsigned ADCD0IS:2;
    unsigned ADCD0IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC14bits_t;
extern volatile __IPC14bits_t IPC14bits __asm__ ("IPC14") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC14CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC14SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC14INV __attribute__((section("sfrs")));
#define IPC15 IPC15
extern volatile unsigned int   IPC15 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD1IS:2;
    unsigned ADCD1IP:3;
    unsigned :3;
    unsigned ADCD2IS:2;
    unsigned ADCD2IP:3;
    unsigned :3;
    unsigned ADCD3IS:2;
    unsigned ADCD3IP:3;
    unsigned :3;
    unsigned ADCD4IS:2;
    unsigned ADCD4IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC15bits_t;
extern volatile __IPC15bits_t IPC15bits __asm__ ("IPC15") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC15CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC15SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC15INV __attribute__((section("sfrs")));
#define IPC16 IPC16
extern volatile unsigned int   IPC16 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD5IS:2;
    unsigned ADCD5IP:3;
    unsigned :3;
    unsigned ADCD6IS:2;
    unsigned ADCD6IP:3;
    unsigned :3;
    unsigned ADCD7IS:2;
    unsigned ADCD7IP:3;
    unsigned :3;
    unsigned ADCD8IS:2;
    unsigned ADCD8IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC16bits_t;
extern volatile __IPC16bits_t IPC16bits __asm__ ("IPC16") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC16CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC16SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC16INV __attribute__((section("sfrs")));
#define IPC17 IPC17
extern volatile unsigned int   IPC17 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD9IS:2;
    unsigned ADCD9IP:3;
    unsigned :3;
    unsigned ADCD10IS:2;
    unsigned ADCD10IP:3;
    unsigned :3;
    unsigned ADCD11IS:2;
    unsigned ADCD11IP:3;
    unsigned :3;
    unsigned ADCD12IS:2;
    unsigned ADCD12IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC17bits_t;
extern volatile __IPC17bits_t IPC17bits __asm__ ("IPC17") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC17CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC17SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC17INV __attribute__((section("sfrs")));
#define IPC18 IPC18
extern volatile unsigned int   IPC18 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD13IS:2;
    unsigned ADCD13IP:3;
    unsigned :3;
    unsigned ADCD14IS:2;
    unsigned ADCD14IP:3;
    unsigned :3;
    unsigned ADCD15IS:2;
    unsigned ADCD15IP:3;
    unsigned :3;
    unsigned ADCD16IS:2;
    unsigned ADCD16IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC18bits_t;
extern volatile __IPC18bits_t IPC18bits __asm__ ("IPC18") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC18CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC18SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC18INV __attribute__((section("sfrs")));
#define IPC19 IPC19
extern volatile unsigned int   IPC19 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD17IS:2;
    unsigned ADCD17IP:3;
    unsigned :3;
    unsigned ADCD18IS:2;
    unsigned ADCD18IP:3;
    unsigned :3;
    unsigned ADCD19IS:2;
    unsigned ADCD19IP:3;
    unsigned :3;
    unsigned ADCD20IS:2;
    unsigned ADCD20IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC19bits_t;
extern volatile __IPC19bits_t IPC19bits __asm__ ("IPC19") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC19CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC19SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC19INV __attribute__((section("sfrs")));
#define IPC20 IPC20
extern volatile unsigned int   IPC20 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD21IS:2;
    unsigned ADCD21IP:3;
    unsigned :3;
    unsigned ADCD22IS:2;
    unsigned ADCD22IP:3;
    unsigned :3;
    unsigned ADCD23IS:2;
    unsigned ADCD23IP:3;
    unsigned :3;
    unsigned ADCD24IS:2;
    unsigned ADCD24IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC20bits_t;
extern volatile __IPC20bits_t IPC20bits __asm__ ("IPC20") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC20CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC20SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC20INV __attribute__((section("sfrs")));
#define IPC21 IPC21
extern volatile unsigned int   IPC21 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD25IS:2;
    unsigned ADCD25IP:3;
    unsigned :3;
    unsigned ADCD26IS:2;
    unsigned ADCD26IP:3;
    unsigned :3;
    unsigned ADCD27IS:2;
    unsigned ADCD27IP:3;
    unsigned :3;
    unsigned ADCD28IS:2;
    unsigned ADCD28IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC21bits_t;
extern volatile __IPC21bits_t IPC21bits __asm__ ("IPC21") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC21CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC21SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC21INV __attribute__((section("sfrs")));
#define IPC22 IPC22
extern volatile unsigned int   IPC22 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD29IS:2;
    unsigned ADCD29IP:3;
    unsigned :3;
    unsigned ADCD30IS:2;
    unsigned ADCD30IP:3;
    unsigned :3;
    unsigned ADCD31IS:2;
    unsigned ADCD31IP:3;
    unsigned :3;
    unsigned ADCD32IS:2;
    unsigned ADCD32IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC22bits_t;
extern volatile __IPC22bits_t IPC22bits __asm__ ("IPC22") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC22CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC22SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC22INV __attribute__((section("sfrs")));
#define IPC23 IPC23
extern volatile unsigned int   IPC23 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCD33IS:2;
    unsigned ADCD33IP:3;
    unsigned :3;
    unsigned ADCD34IS:2;
    unsigned ADCD34IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC23bits_t;
extern volatile __IPC23bits_t IPC23bits __asm__ ("IPC23") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC23CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC23SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC23INV __attribute__((section("sfrs")));
#define IPC25 IPC25
extern volatile unsigned int   IPC25 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :16;
    unsigned ADCD43IS:2;
    unsigned ADCD43IP:3;
    unsigned :3;
    unsigned ADCD44IS:2;
    unsigned ADCD44IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC25bits_t;
extern volatile __IPC25bits_t IPC25bits __asm__ ("IPC25") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC25CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC25SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC25INV __attribute__((section("sfrs")));
#define IPC26 IPC26
extern volatile unsigned int   IPC26 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CPCIS:2;
    unsigned CPCIP:3;
    unsigned :3;
    unsigned CFDCIS:2;
    unsigned CFDCIP:3;
    unsigned :3;
    unsigned SBIS:2;
    unsigned SBIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC26bits_t;
extern volatile __IPC26bits_t IPC26bits __asm__ ("IPC26") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC26CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC26SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC26INV __attribute__((section("sfrs")));
#define IPC27 IPC27
extern volatile unsigned int   IPC27 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SPI1EIS:2;
    unsigned SPI1EIP:3;
    unsigned :3;
    unsigned SPI1RXIS:2;
    unsigned SPI1RXIP:3;
    unsigned :3;
    unsigned SPI1TXIS:2;
    unsigned SPI1TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC27bits_t;
extern volatile __IPC27bits_t IPC27bits __asm__ ("IPC27") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC27CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC27SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC27INV __attribute__((section("sfrs")));
#define IPC28 IPC28
extern volatile unsigned int   IPC28 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned U1EIS:2;
    unsigned U1EIP:3;
    unsigned :3;
    unsigned U1RXIS:2;
    unsigned U1RXIP:3;
    unsigned :3;
    unsigned U1TXIS:2;
    unsigned U1TXIP:3;
    unsigned :3;
    unsigned I2C1BIS:2;
    unsigned I2C1BIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC28bits_t;
extern volatile __IPC28bits_t IPC28bits __asm__ ("IPC28") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC28CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC28SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC28INV __attribute__((section("sfrs")));
#define IPC29 IPC29
extern volatile unsigned int   IPC29 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C1SIS:2;
    unsigned I2C1SIP:3;
    unsigned :3;
    unsigned I2C1MIS:2;
    unsigned I2C1MIP:3;
    unsigned :3;
    unsigned CNAIS:2;
    unsigned CNAIP:3;
    unsigned :3;
    unsigned CNBIS:2;
    unsigned CNBIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC29bits_t;
extern volatile __IPC29bits_t IPC29bits __asm__ ("IPC29") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC29CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC29SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC29INV __attribute__((section("sfrs")));
#define IPC30 IPC30
extern volatile unsigned int   IPC30 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNCIS:2;
    unsigned CNCIP:3;
    unsigned :3;
    unsigned CNDIS:2;
    unsigned CNDIP:3;
    unsigned :3;
    unsigned CNEIS:2;
    unsigned CNEIP:3;
    unsigned :3;
    unsigned CNFIS:2;
    unsigned CNFIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC30bits_t;
extern volatile __IPC30bits_t IPC30bits __asm__ ("IPC30") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC30CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC30SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC30INV __attribute__((section("sfrs")));
#define IPC31 IPC31
extern volatile unsigned int   IPC31 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNGIS:2;
    unsigned CNGIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC31bits_t;
extern volatile __IPC31bits_t IPC31bits __asm__ ("IPC31") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC31CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC31SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC31INV __attribute__((section("sfrs")));
#define IPC32 IPC32
extern volatile unsigned int   IPC32 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMPIS:2;
    unsigned PMPIP:3;
    unsigned :3;
    unsigned PMPEIS:2;
    unsigned PMPEIP:3;
    unsigned :3;
    unsigned CMP1IS:2;
    unsigned CMP1IP:3;
    unsigned :3;
    unsigned CMP2IS:2;
    unsigned CMP2IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC32bits_t;
extern volatile __IPC32bits_t IPC32bits __asm__ ("IPC32") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC32CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC32SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC32INV __attribute__((section("sfrs")));
#define IPC33 IPC33
extern volatile unsigned int   IPC33 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USBIS:2;
    unsigned USBIP:3;
    unsigned :3;
    unsigned USBDMAIS:2;
    unsigned USBDMAIP:3;
    unsigned :3;
    unsigned DMA0IS:2;
    unsigned DMA0IP:3;
    unsigned :3;
    unsigned DMA1IS:2;
    unsigned DMA1IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC33bits_t;
extern volatile __IPC33bits_t IPC33bits __asm__ ("IPC33") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC33CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC33SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC33INV __attribute__((section("sfrs")));
#define IPC34 IPC34
extern volatile unsigned int   IPC34 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DMA2IS:2;
    unsigned DMA2IP:3;
    unsigned :3;
    unsigned DMA3IS:2;
    unsigned DMA3IP:3;
    unsigned :3;
    unsigned DMA4IS:2;
    unsigned DMA4IP:3;
    unsigned :3;
    unsigned DMA5IS:2;
    unsigned DMA5IP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC34bits_t;
extern volatile __IPC34bits_t IPC34bits __asm__ ("IPC34") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC34CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC34SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC34INV __attribute__((section("sfrs")));
#define IPC35 IPC35
extern volatile unsigned int   IPC35 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DMA6IS:2;
    unsigned DMA6IP:3;
    unsigned :3;
    unsigned DMA7IS:2;
    unsigned DMA7IP:3;
    unsigned :3;
    unsigned SPI2EIS:2;
    unsigned SPI2EIP:3;
    unsigned :3;
    unsigned SPI2RXIS:2;
    unsigned SPI2RXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC35bits_t;
extern volatile __IPC35bits_t IPC35bits __asm__ ("IPC35") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC35CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC35SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC35INV __attribute__((section("sfrs")));
#define IPC36 IPC36
extern volatile unsigned int   IPC36 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPI2TXIS:2;
    unsigned SPI2TXIP:3;
    unsigned :3;
    unsigned U2EIS:2;
    unsigned U2EIP:3;
    unsigned :3;
    unsigned U2RXIS:2;
    unsigned U2RXIP:3;
    unsigned :3;
    unsigned U2TXIS:2;
    unsigned U2TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC36bits_t;
extern volatile __IPC36bits_t IPC36bits __asm__ ("IPC36") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC36CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC36SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC36INV __attribute__((section("sfrs")));
#define IPC37 IPC37
extern volatile unsigned int   IPC37 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C2BIS:2;
    unsigned I2C2BIP:3;
    unsigned :3;
    unsigned I2C2SIS:2;
    unsigned I2C2SIP:3;
    unsigned :3;
    unsigned I2C2MIS:2;
    unsigned I2C2MIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC37bits_t;
extern volatile __IPC37bits_t IPC37bits __asm__ ("IPC37") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC37CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC37SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC37INV __attribute__((section("sfrs")));
#define IPC38 IPC38
extern volatile unsigned int   IPC38 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned ETHIS:2;
    unsigned ETHIP:3;
    unsigned :3;
    unsigned SPI3EIS:2;
    unsigned SPI3EIP:3;
    unsigned :3;
    unsigned SPI3RXIS:2;
    unsigned SPI3RXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC38bits_t;
extern volatile __IPC38bits_t IPC38bits __asm__ ("IPC38") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC38CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC38SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC38INV __attribute__((section("sfrs")));
#define IPC39 IPC39
extern volatile unsigned int   IPC39 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPI3TXIS:2;
    unsigned SPI3TXIP:3;
    unsigned :3;
    unsigned U3EIS:2;
    unsigned U3EIP:3;
    unsigned :3;
    unsigned U3RXIS:2;
    unsigned U3RXIP:3;
    unsigned :3;
    unsigned U3TXIS:2;
    unsigned U3TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC39bits_t;
extern volatile __IPC39bits_t IPC39bits __asm__ ("IPC39") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC39CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC39SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC39INV __attribute__((section("sfrs")));
#define IPC40 IPC40
extern volatile unsigned int   IPC40 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C3BIS:2;
    unsigned I2C3BIP:3;
    unsigned :3;
    unsigned I2C3SIS:2;
    unsigned I2C3SIP:3;
    unsigned :3;
    unsigned I2C3MIS:2;
    unsigned I2C3MIP:3;
    unsigned :3;
    unsigned SPI4EIS:2;
    unsigned SPI4EIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC40bits_t;
extern volatile __IPC40bits_t IPC40bits __asm__ ("IPC40") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC40CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC40SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC40INV __attribute__((section("sfrs")));
#define IPC41 IPC41
extern volatile unsigned int   IPC41 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPI4RXIS:2;
    unsigned SPI4RXIP:3;
    unsigned :3;
    unsigned SPI4TXIS:2;
    unsigned SPI4TXIP:3;
    unsigned :3;
    unsigned RTCCIS:2;
    unsigned RTCCIP:3;
    unsigned :3;
    unsigned FCEIS:2;
    unsigned FCEIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC41bits_t;
extern volatile __IPC41bits_t IPC41bits __asm__ ("IPC41") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC41CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC41SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC41INV __attribute__((section("sfrs")));
#define IPC42 IPC42
extern volatile unsigned int   IPC42 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PREIS:2;
    unsigned PREIP:3;
    unsigned :3;
    unsigned SQI1IS:2;
    unsigned SQI1IP:3;
    unsigned :3;
    unsigned U4EIS:2;
    unsigned U4EIP:3;
    unsigned :3;
    unsigned U4RXIS:2;
    unsigned U4RXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC42bits_t;
extern volatile __IPC42bits_t IPC42bits __asm__ ("IPC42") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC42CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC42SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC42INV __attribute__((section("sfrs")));
#define IPC43 IPC43
extern volatile unsigned int   IPC43 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned U4TXIS:2;
    unsigned U4TXIP:3;
    unsigned :3;
    unsigned I2C4BIS:2;
    unsigned I2C4BIP:3;
    unsigned :3;
    unsigned I2C4SIS:2;
    unsigned I2C4SIP:3;
    unsigned :3;
    unsigned I2C4MIS:2;
    unsigned I2C4MIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC43bits_t;
extern volatile __IPC43bits_t IPC43bits __asm__ ("IPC43") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC43CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC43SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC43INV __attribute__((section("sfrs")));
#define IPC44 IPC44
extern volatile unsigned int   IPC44 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPI5EIS:2;
    unsigned SPI5EIP:3;
    unsigned :3;
    unsigned SPI5RXIS:2;
    unsigned SPI5RXIP:3;
    unsigned :3;
    unsigned SPI5TXIS:2;
    unsigned SPI5TXIP:3;
    unsigned :3;
    unsigned U5EIS:2;
    unsigned U5EIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC44bits_t;
extern volatile __IPC44bits_t IPC44bits __asm__ ("IPC44") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC44CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC44SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC44INV __attribute__((section("sfrs")));
#define IPC45 IPC45
extern volatile unsigned int   IPC45 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned U5RXIS:2;
    unsigned U5RXIP:3;
    unsigned :3;
    unsigned U5TXIS:2;
    unsigned U5TXIP:3;
    unsigned :3;
    unsigned I2C5BIS:2;
    unsigned I2C5BIP:3;
    unsigned :3;
    unsigned I2C5SIS:2;
    unsigned I2C5SIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC45bits_t;
extern volatile __IPC45bits_t IPC45bits __asm__ ("IPC45") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC45CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC45SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC45INV __attribute__((section("sfrs")));
#define IPC46 IPC46
extern volatile unsigned int   IPC46 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2C5MIS:2;
    unsigned I2C5MIP:3;
    unsigned :3;
    unsigned SPI6EIS:2;
    unsigned SPI6EIP:3;
    unsigned :3;
    unsigned SPI6RXIS:2;
    unsigned SPI6RXIP:3;
    unsigned :3;
    unsigned SPI6TXIS:2;
    unsigned SPI6TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC46bits_t;
extern volatile __IPC46bits_t IPC46bits __asm__ ("IPC46") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC46CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC46SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC46INV __attribute__((section("sfrs")));
#define IPC47 IPC47
extern volatile unsigned int   IPC47 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned U6EIS:2;
    unsigned U6EIP:3;
    unsigned :3;
    unsigned U6RXIS:2;
    unsigned U6RXIP:3;
    unsigned :3;
    unsigned U6TXIS:2;
    unsigned U6TXIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC47bits_t;
extern volatile __IPC47bits_t IPC47bits __asm__ ("IPC47") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC47CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC47SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC47INV __attribute__((section("sfrs")));
#define IPC48 IPC48
extern volatile unsigned int   IPC48 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCEOSIS:2;
    unsigned ADCEOSIP:3;
    unsigned :3;
    unsigned ADCARDYIS:2;
    unsigned ADCARDYIP:3;
    unsigned :3;
    unsigned ADCURDYIS:2;
    unsigned ADCURDYIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC48bits_t;
extern volatile __IPC48bits_t IPC48bits __asm__ ("IPC48") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC48CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC48SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC48INV __attribute__((section("sfrs")));
#define IPC49 IPC49
extern volatile unsigned int   IPC49 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADCGRPIS:2;
    unsigned ADCGRPIP:3;
    unsigned :11;
    unsigned ADC0EIS:2;
    unsigned ADC0EIP:3;
    unsigned :3;
    unsigned ADC1EIS:2;
    unsigned ADC1EIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC49bits_t;
extern volatile __IPC49bits_t IPC49bits __asm__ ("IPC49") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC49CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC49SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC49INV __attribute__((section("sfrs")));
#define IPC50 IPC50
extern volatile unsigned int   IPC50 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADC2EIS:2;
    unsigned ADC2EIP:3;
    unsigned :3;
    unsigned ADC3EIS:2;
    unsigned ADC3EIP:3;
    unsigned :3;
    unsigned ADC4EIS:2;
    unsigned ADC4EIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC50bits_t;
extern volatile __IPC50bits_t IPC50bits __asm__ ("IPC50") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC50CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC50SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC50INV __attribute__((section("sfrs")));
#define IPC51 IPC51
extern volatile unsigned int   IPC51 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned ADC7EIS:2;
    unsigned ADC7EIP:3;
    unsigned :3;
    unsigned ADC0WIS:2;
    unsigned ADC0WIP:3;
    unsigned :3;
    unsigned ADC1WIS:2;
    unsigned ADC1WIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC51bits_t;
extern volatile __IPC51bits_t IPC51bits __asm__ ("IPC51") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC51CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC51SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC51INV __attribute__((section("sfrs")));
#define IPC52 IPC52
extern volatile unsigned int   IPC52 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADC2WIS:2;
    unsigned ADC2WIP:3;
    unsigned :3;
    unsigned ADC3WIS:2;
    unsigned ADC3WIP:3;
    unsigned :3;
    unsigned ADC4WIS:2;
    unsigned ADC4WIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC52bits_t;
extern volatile __IPC52bits_t IPC52bits __asm__ ("IPC52") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC52CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC52SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC52INV __attribute__((section("sfrs")));
#define IPC53 IPC53
extern volatile unsigned int   IPC53 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned ADC7WIS:2;
    unsigned ADC7WIP:3;
  };
  struct {
    unsigned w:32;
  };
} __IPC53bits_t;
extern volatile __IPC53bits_t IPC53bits __asm__ ("IPC53") __attribute__((section("sfrs")));
extern volatile unsigned int        IPC53CLR __attribute__((section("sfrs")));
extern volatile unsigned int        IPC53SET __attribute__((section("sfrs")));
extern volatile unsigned int        IPC53INV __attribute__((section("sfrs")));
#define OFF000 OFF000
extern volatile unsigned int   OFF000 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF000bits_t;
extern volatile __OFF000bits_t OFF000bits __asm__ ("OFF000") __attribute__((section("sfrs")));
#define OFF001 OFF001
extern volatile unsigned int   OFF001 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF001bits_t;
extern volatile __OFF001bits_t OFF001bits __asm__ ("OFF001") __attribute__((section("sfrs")));
#define OFF002 OFF002
extern volatile unsigned int   OFF002 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF002bits_t;
extern volatile __OFF002bits_t OFF002bits __asm__ ("OFF002") __attribute__((section("sfrs")));
#define OFF003 OFF003
extern volatile unsigned int   OFF003 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF003bits_t;
extern volatile __OFF003bits_t OFF003bits __asm__ ("OFF003") __attribute__((section("sfrs")));
#define OFF004 OFF004
extern volatile unsigned int   OFF004 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF004bits_t;
extern volatile __OFF004bits_t OFF004bits __asm__ ("OFF004") __attribute__((section("sfrs")));
#define OFF005 OFF005
extern volatile unsigned int   OFF005 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF005bits_t;
extern volatile __OFF005bits_t OFF005bits __asm__ ("OFF005") __attribute__((section("sfrs")));
#define OFF006 OFF006
extern volatile unsigned int   OFF006 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF006bits_t;
extern volatile __OFF006bits_t OFF006bits __asm__ ("OFF006") __attribute__((section("sfrs")));
#define OFF007 OFF007
extern volatile unsigned int   OFF007 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF007bits_t;
extern volatile __OFF007bits_t OFF007bits __asm__ ("OFF007") __attribute__((section("sfrs")));
#define OFF008 OFF008
extern volatile unsigned int   OFF008 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF008bits_t;
extern volatile __OFF008bits_t OFF008bits __asm__ ("OFF008") __attribute__((section("sfrs")));
#define OFF009 OFF009
extern volatile unsigned int   OFF009 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF009bits_t;
extern volatile __OFF009bits_t OFF009bits __asm__ ("OFF009") __attribute__((section("sfrs")));
#define OFF010 OFF010
extern volatile unsigned int   OFF010 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF010bits_t;
extern volatile __OFF010bits_t OFF010bits __asm__ ("OFF010") __attribute__((section("sfrs")));
#define OFF011 OFF011
extern volatile unsigned int   OFF011 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF011bits_t;
extern volatile __OFF011bits_t OFF011bits __asm__ ("OFF011") __attribute__((section("sfrs")));
#define OFF012 OFF012
extern volatile unsigned int   OFF012 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF012bits_t;
extern volatile __OFF012bits_t OFF012bits __asm__ ("OFF012") __attribute__((section("sfrs")));
#define OFF013 OFF013
extern volatile unsigned int   OFF013 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF013bits_t;
extern volatile __OFF013bits_t OFF013bits __asm__ ("OFF013") __attribute__((section("sfrs")));
#define OFF014 OFF014
extern volatile unsigned int   OFF014 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF014bits_t;
extern volatile __OFF014bits_t OFF014bits __asm__ ("OFF014") __attribute__((section("sfrs")));
#define OFF015 OFF015
extern volatile unsigned int   OFF015 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF015bits_t;
extern volatile __OFF015bits_t OFF015bits __asm__ ("OFF015") __attribute__((section("sfrs")));
#define OFF016 OFF016
extern volatile unsigned int   OFF016 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF016bits_t;
extern volatile __OFF016bits_t OFF016bits __asm__ ("OFF016") __attribute__((section("sfrs")));
#define OFF017 OFF017
extern volatile unsigned int   OFF017 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF017bits_t;
extern volatile __OFF017bits_t OFF017bits __asm__ ("OFF017") __attribute__((section("sfrs")));
#define OFF018 OFF018
extern volatile unsigned int   OFF018 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF018bits_t;
extern volatile __OFF018bits_t OFF018bits __asm__ ("OFF018") __attribute__((section("sfrs")));
#define OFF019 OFF019
extern volatile unsigned int   OFF019 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF019bits_t;
extern volatile __OFF019bits_t OFF019bits __asm__ ("OFF019") __attribute__((section("sfrs")));
#define OFF020 OFF020
extern volatile unsigned int   OFF020 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF020bits_t;
extern volatile __OFF020bits_t OFF020bits __asm__ ("OFF020") __attribute__((section("sfrs")));
#define OFF021 OFF021
extern volatile unsigned int   OFF021 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF021bits_t;
extern volatile __OFF021bits_t OFF021bits __asm__ ("OFF021") __attribute__((section("sfrs")));
#define OFF022 OFF022
extern volatile unsigned int   OFF022 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF022bits_t;
extern volatile __OFF022bits_t OFF022bits __asm__ ("OFF022") __attribute__((section("sfrs")));
#define OFF023 OFF023
extern volatile unsigned int   OFF023 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF023bits_t;
extern volatile __OFF023bits_t OFF023bits __asm__ ("OFF023") __attribute__((section("sfrs")));
#define OFF024 OFF024
extern volatile unsigned int   OFF024 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF024bits_t;
extern volatile __OFF024bits_t OFF024bits __asm__ ("OFF024") __attribute__((section("sfrs")));
#define OFF025 OFF025
extern volatile unsigned int   OFF025 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF025bits_t;
extern volatile __OFF025bits_t OFF025bits __asm__ ("OFF025") __attribute__((section("sfrs")));
#define OFF026 OFF026
extern volatile unsigned int   OFF026 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF026bits_t;
extern volatile __OFF026bits_t OFF026bits __asm__ ("OFF026") __attribute__((section("sfrs")));
#define OFF027 OFF027
extern volatile unsigned int   OFF027 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF027bits_t;
extern volatile __OFF027bits_t OFF027bits __asm__ ("OFF027") __attribute__((section("sfrs")));
#define OFF028 OFF028
extern volatile unsigned int   OFF028 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF028bits_t;
extern volatile __OFF028bits_t OFF028bits __asm__ ("OFF028") __attribute__((section("sfrs")));
#define OFF029 OFF029
extern volatile unsigned int   OFF029 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF029bits_t;
extern volatile __OFF029bits_t OFF029bits __asm__ ("OFF029") __attribute__((section("sfrs")));
#define OFF030 OFF030
extern volatile unsigned int   OFF030 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF030bits_t;
extern volatile __OFF030bits_t OFF030bits __asm__ ("OFF030") __attribute__((section("sfrs")));
#define OFF031 OFF031
extern volatile unsigned int   OFF031 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF031bits_t;
extern volatile __OFF031bits_t OFF031bits __asm__ ("OFF031") __attribute__((section("sfrs")));
#define OFF032 OFF032
extern volatile unsigned int   OFF032 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF032bits_t;
extern volatile __OFF032bits_t OFF032bits __asm__ ("OFF032") __attribute__((section("sfrs")));
#define OFF033 OFF033
extern volatile unsigned int   OFF033 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF033bits_t;
extern volatile __OFF033bits_t OFF033bits __asm__ ("OFF033") __attribute__((section("sfrs")));
#define OFF034 OFF034
extern volatile unsigned int   OFF034 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF034bits_t;
extern volatile __OFF034bits_t OFF034bits __asm__ ("OFF034") __attribute__((section("sfrs")));
#define OFF035 OFF035
extern volatile unsigned int   OFF035 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF035bits_t;
extern volatile __OFF035bits_t OFF035bits __asm__ ("OFF035") __attribute__((section("sfrs")));
#define OFF036 OFF036
extern volatile unsigned int   OFF036 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF036bits_t;
extern volatile __OFF036bits_t OFF036bits __asm__ ("OFF036") __attribute__((section("sfrs")));
#define OFF037 OFF037
extern volatile unsigned int   OFF037 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF037bits_t;
extern volatile __OFF037bits_t OFF037bits __asm__ ("OFF037") __attribute__((section("sfrs")));
#define OFF038 OFF038
extern volatile unsigned int   OFF038 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF038bits_t;
extern volatile __OFF038bits_t OFF038bits __asm__ ("OFF038") __attribute__((section("sfrs")));
#define OFF039 OFF039
extern volatile unsigned int   OFF039 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF039bits_t;
extern volatile __OFF039bits_t OFF039bits __asm__ ("OFF039") __attribute__((section("sfrs")));
#define OFF040 OFF040
extern volatile unsigned int   OFF040 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF040bits_t;
extern volatile __OFF040bits_t OFF040bits __asm__ ("OFF040") __attribute__((section("sfrs")));
#define OFF041 OFF041
extern volatile unsigned int   OFF041 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF041bits_t;
extern volatile __OFF041bits_t OFF041bits __asm__ ("OFF041") __attribute__((section("sfrs")));
#define OFF042 OFF042
extern volatile unsigned int   OFF042 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF042bits_t;
extern volatile __OFF042bits_t OFF042bits __asm__ ("OFF042") __attribute__((section("sfrs")));
#define OFF043 OFF043
extern volatile unsigned int   OFF043 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF043bits_t;
extern volatile __OFF043bits_t OFF043bits __asm__ ("OFF043") __attribute__((section("sfrs")));
#define OFF044 OFF044
extern volatile unsigned int   OFF044 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF044bits_t;
extern volatile __OFF044bits_t OFF044bits __asm__ ("OFF044") __attribute__((section("sfrs")));
#define OFF045 OFF045
extern volatile unsigned int   OFF045 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF045bits_t;
extern volatile __OFF045bits_t OFF045bits __asm__ ("OFF045") __attribute__((section("sfrs")));
#define OFF046 OFF046
extern volatile unsigned int   OFF046 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF046bits_t;
extern volatile __OFF046bits_t OFF046bits __asm__ ("OFF046") __attribute__((section("sfrs")));
#define OFF047 OFF047
extern volatile unsigned int   OFF047 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF047bits_t;
extern volatile __OFF047bits_t OFF047bits __asm__ ("OFF047") __attribute__((section("sfrs")));
#define OFF048 OFF048
extern volatile unsigned int   OFF048 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF048bits_t;
extern volatile __OFF048bits_t OFF048bits __asm__ ("OFF048") __attribute__((section("sfrs")));
#define OFF049 OFF049
extern volatile unsigned int   OFF049 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF049bits_t;
extern volatile __OFF049bits_t OFF049bits __asm__ ("OFF049") __attribute__((section("sfrs")));
#define OFF050 OFF050
extern volatile unsigned int   OFF050 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF050bits_t;
extern volatile __OFF050bits_t OFF050bits __asm__ ("OFF050") __attribute__((section("sfrs")));
#define OFF051 OFF051
extern volatile unsigned int   OFF051 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF051bits_t;
extern volatile __OFF051bits_t OFF051bits __asm__ ("OFF051") __attribute__((section("sfrs")));
#define OFF052 OFF052
extern volatile unsigned int   OFF052 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF052bits_t;
extern volatile __OFF052bits_t OFF052bits __asm__ ("OFF052") __attribute__((section("sfrs")));
#define OFF053 OFF053
extern volatile unsigned int   OFF053 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF053bits_t;
extern volatile __OFF053bits_t OFF053bits __asm__ ("OFF053") __attribute__((section("sfrs")));
#define OFF054 OFF054
extern volatile unsigned int   OFF054 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF054bits_t;
extern volatile __OFF054bits_t OFF054bits __asm__ ("OFF054") __attribute__((section("sfrs")));
#define OFF055 OFF055
extern volatile unsigned int   OFF055 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF055bits_t;
extern volatile __OFF055bits_t OFF055bits __asm__ ("OFF055") __attribute__((section("sfrs")));
#define OFF056 OFF056
extern volatile unsigned int   OFF056 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF056bits_t;
extern volatile __OFF056bits_t OFF056bits __asm__ ("OFF056") __attribute__((section("sfrs")));
#define OFF057 OFF057
extern volatile unsigned int   OFF057 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF057bits_t;
extern volatile __OFF057bits_t OFF057bits __asm__ ("OFF057") __attribute__((section("sfrs")));
#define OFF058 OFF058
extern volatile unsigned int   OFF058 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF058bits_t;
extern volatile __OFF058bits_t OFF058bits __asm__ ("OFF058") __attribute__((section("sfrs")));
#define OFF059 OFF059
extern volatile unsigned int   OFF059 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF059bits_t;
extern volatile __OFF059bits_t OFF059bits __asm__ ("OFF059") __attribute__((section("sfrs")));
#define OFF060 OFF060
extern volatile unsigned int   OFF060 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF060bits_t;
extern volatile __OFF060bits_t OFF060bits __asm__ ("OFF060") __attribute__((section("sfrs")));
#define OFF061 OFF061
extern volatile unsigned int   OFF061 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF061bits_t;
extern volatile __OFF061bits_t OFF061bits __asm__ ("OFF061") __attribute__((section("sfrs")));
#define OFF062 OFF062
extern volatile unsigned int   OFF062 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF062bits_t;
extern volatile __OFF062bits_t OFF062bits __asm__ ("OFF062") __attribute__((section("sfrs")));
#define OFF063 OFF063
extern volatile unsigned int   OFF063 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF063bits_t;
extern volatile __OFF063bits_t OFF063bits __asm__ ("OFF063") __attribute__((section("sfrs")));
#define OFF064 OFF064
extern volatile unsigned int   OFF064 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF064bits_t;
extern volatile __OFF064bits_t OFF064bits __asm__ ("OFF064") __attribute__((section("sfrs")));
#define OFF065 OFF065
extern volatile unsigned int   OFF065 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF065bits_t;
extern volatile __OFF065bits_t OFF065bits __asm__ ("OFF065") __attribute__((section("sfrs")));
#define OFF066 OFF066
extern volatile unsigned int   OFF066 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF066bits_t;
extern volatile __OFF066bits_t OFF066bits __asm__ ("OFF066") __attribute__((section("sfrs")));
#define OFF067 OFF067
extern volatile unsigned int   OFF067 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF067bits_t;
extern volatile __OFF067bits_t OFF067bits __asm__ ("OFF067") __attribute__((section("sfrs")));
#define OFF068 OFF068
extern volatile unsigned int   OFF068 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF068bits_t;
extern volatile __OFF068bits_t OFF068bits __asm__ ("OFF068") __attribute__((section("sfrs")));
#define OFF069 OFF069
extern volatile unsigned int   OFF069 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF069bits_t;
extern volatile __OFF069bits_t OFF069bits __asm__ ("OFF069") __attribute__((section("sfrs")));
#define OFF070 OFF070
extern volatile unsigned int   OFF070 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF070bits_t;
extern volatile __OFF070bits_t OFF070bits __asm__ ("OFF070") __attribute__((section("sfrs")));
#define OFF071 OFF071
extern volatile unsigned int   OFF071 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF071bits_t;
extern volatile __OFF071bits_t OFF071bits __asm__ ("OFF071") __attribute__((section("sfrs")));
#define OFF072 OFF072
extern volatile unsigned int   OFF072 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF072bits_t;
extern volatile __OFF072bits_t OFF072bits __asm__ ("OFF072") __attribute__((section("sfrs")));
#define OFF073 OFF073
extern volatile unsigned int   OFF073 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF073bits_t;
extern volatile __OFF073bits_t OFF073bits __asm__ ("OFF073") __attribute__((section("sfrs")));
#define OFF074 OFF074
extern volatile unsigned int   OFF074 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF074bits_t;
extern volatile __OFF074bits_t OFF074bits __asm__ ("OFF074") __attribute__((section("sfrs")));
#define OFF075 OFF075
extern volatile unsigned int   OFF075 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF075bits_t;
extern volatile __OFF075bits_t OFF075bits __asm__ ("OFF075") __attribute__((section("sfrs")));
#define OFF076 OFF076
extern volatile unsigned int   OFF076 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF076bits_t;
extern volatile __OFF076bits_t OFF076bits __asm__ ("OFF076") __attribute__((section("sfrs")));
#define OFF077 OFF077
extern volatile unsigned int   OFF077 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF077bits_t;
extern volatile __OFF077bits_t OFF077bits __asm__ ("OFF077") __attribute__((section("sfrs")));
#define OFF078 OFF078
extern volatile unsigned int   OFF078 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF078bits_t;
extern volatile __OFF078bits_t OFF078bits __asm__ ("OFF078") __attribute__((section("sfrs")));
#define OFF079 OFF079
extern volatile unsigned int   OFF079 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF079bits_t;
extern volatile __OFF079bits_t OFF079bits __asm__ ("OFF079") __attribute__((section("sfrs")));
#define OFF080 OFF080
extern volatile unsigned int   OFF080 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF080bits_t;
extern volatile __OFF080bits_t OFF080bits __asm__ ("OFF080") __attribute__((section("sfrs")));
#define OFF081 OFF081
extern volatile unsigned int   OFF081 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF081bits_t;
extern volatile __OFF081bits_t OFF081bits __asm__ ("OFF081") __attribute__((section("sfrs")));
#define OFF082 OFF082
extern volatile unsigned int   OFF082 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF082bits_t;
extern volatile __OFF082bits_t OFF082bits __asm__ ("OFF082") __attribute__((section("sfrs")));
#define OFF083 OFF083
extern volatile unsigned int   OFF083 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF083bits_t;
extern volatile __OFF083bits_t OFF083bits __asm__ ("OFF083") __attribute__((section("sfrs")));
#define OFF084 OFF084
extern volatile unsigned int   OFF084 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF084bits_t;
extern volatile __OFF084bits_t OFF084bits __asm__ ("OFF084") __attribute__((section("sfrs")));
#define OFF085 OFF085
extern volatile unsigned int   OFF085 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF085bits_t;
extern volatile __OFF085bits_t OFF085bits __asm__ ("OFF085") __attribute__((section("sfrs")));
#define OFF086 OFF086
extern volatile unsigned int   OFF086 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF086bits_t;
extern volatile __OFF086bits_t OFF086bits __asm__ ("OFF086") __attribute__((section("sfrs")));
#define OFF087 OFF087
extern volatile unsigned int   OFF087 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF087bits_t;
extern volatile __OFF087bits_t OFF087bits __asm__ ("OFF087") __attribute__((section("sfrs")));
#define OFF088 OFF088
extern volatile unsigned int   OFF088 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF088bits_t;
extern volatile __OFF088bits_t OFF088bits __asm__ ("OFF088") __attribute__((section("sfrs")));
#define OFF089 OFF089
extern volatile unsigned int   OFF089 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF089bits_t;
extern volatile __OFF089bits_t OFF089bits __asm__ ("OFF089") __attribute__((section("sfrs")));
#define OFF090 OFF090
extern volatile unsigned int   OFF090 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF090bits_t;
extern volatile __OFF090bits_t OFF090bits __asm__ ("OFF090") __attribute__((section("sfrs")));
#define OFF091 OFF091
extern volatile unsigned int   OFF091 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF091bits_t;
extern volatile __OFF091bits_t OFF091bits __asm__ ("OFF091") __attribute__((section("sfrs")));
#define OFF092 OFF092
extern volatile unsigned int   OFF092 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF092bits_t;
extern volatile __OFF092bits_t OFF092bits __asm__ ("OFF092") __attribute__((section("sfrs")));
#define OFF093 OFF093
extern volatile unsigned int   OFF093 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF093bits_t;
extern volatile __OFF093bits_t OFF093bits __asm__ ("OFF093") __attribute__((section("sfrs")));
#define OFF102 OFF102
extern volatile unsigned int   OFF102 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF102bits_t;
extern volatile __OFF102bits_t OFF102bits __asm__ ("OFF102") __attribute__((section("sfrs")));
#define OFF103 OFF103
extern volatile unsigned int   OFF103 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF103bits_t;
extern volatile __OFF103bits_t OFF103bits __asm__ ("OFF103") __attribute__((section("sfrs")));
#define OFF104 OFF104
extern volatile unsigned int   OFF104 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF104bits_t;
extern volatile __OFF104bits_t OFF104bits __asm__ ("OFF104") __attribute__((section("sfrs")));
#define OFF105 OFF105
extern volatile unsigned int   OFF105 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF105bits_t;
extern volatile __OFF105bits_t OFF105bits __asm__ ("OFF105") __attribute__((section("sfrs")));
#define OFF106 OFF106
extern volatile unsigned int   OFF106 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF106bits_t;
extern volatile __OFF106bits_t OFF106bits __asm__ ("OFF106") __attribute__((section("sfrs")));
#define OFF109 OFF109
extern volatile unsigned int   OFF109 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF109bits_t;
extern volatile __OFF109bits_t OFF109bits __asm__ ("OFF109") __attribute__((section("sfrs")));
#define OFF110 OFF110
extern volatile unsigned int   OFF110 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF110bits_t;
extern volatile __OFF110bits_t OFF110bits __asm__ ("OFF110") __attribute__((section("sfrs")));
#define OFF111 OFF111
extern volatile unsigned int   OFF111 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF111bits_t;
extern volatile __OFF111bits_t OFF111bits __asm__ ("OFF111") __attribute__((section("sfrs")));
#define OFF112 OFF112
extern volatile unsigned int   OFF112 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF112bits_t;
extern volatile __OFF112bits_t OFF112bits __asm__ ("OFF112") __attribute__((section("sfrs")));
#define OFF113 OFF113
extern volatile unsigned int   OFF113 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF113bits_t;
extern volatile __OFF113bits_t OFF113bits __asm__ ("OFF113") __attribute__((section("sfrs")));
#define OFF114 OFF114
extern volatile unsigned int   OFF114 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF114bits_t;
extern volatile __OFF114bits_t OFF114bits __asm__ ("OFF114") __attribute__((section("sfrs")));
#define OFF115 OFF115
extern volatile unsigned int   OFF115 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF115bits_t;
extern volatile __OFF115bits_t OFF115bits __asm__ ("OFF115") __attribute__((section("sfrs")));
#define OFF116 OFF116
extern volatile unsigned int   OFF116 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF116bits_t;
extern volatile __OFF116bits_t OFF116bits __asm__ ("OFF116") __attribute__((section("sfrs")));
#define OFF117 OFF117
extern volatile unsigned int   OFF117 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF117bits_t;
extern volatile __OFF117bits_t OFF117bits __asm__ ("OFF117") __attribute__((section("sfrs")));
#define OFF118 OFF118
extern volatile unsigned int   OFF118 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF118bits_t;
extern volatile __OFF118bits_t OFF118bits __asm__ ("OFF118") __attribute__((section("sfrs")));
#define OFF119 OFF119
extern volatile unsigned int   OFF119 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF119bits_t;
extern volatile __OFF119bits_t OFF119bits __asm__ ("OFF119") __attribute__((section("sfrs")));
#define OFF120 OFF120
extern volatile unsigned int   OFF120 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF120bits_t;
extern volatile __OFF120bits_t OFF120bits __asm__ ("OFF120") __attribute__((section("sfrs")));
#define OFF121 OFF121
extern volatile unsigned int   OFF121 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF121bits_t;
extern volatile __OFF121bits_t OFF121bits __asm__ ("OFF121") __attribute__((section("sfrs")));
#define OFF122 OFF122
extern volatile unsigned int   OFF122 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF122bits_t;
extern volatile __OFF122bits_t OFF122bits __asm__ ("OFF122") __attribute__((section("sfrs")));
#define OFF123 OFF123
extern volatile unsigned int   OFF123 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF123bits_t;
extern volatile __OFF123bits_t OFF123bits __asm__ ("OFF123") __attribute__((section("sfrs")));
#define OFF124 OFF124
extern volatile unsigned int   OFF124 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF124bits_t;
extern volatile __OFF124bits_t OFF124bits __asm__ ("OFF124") __attribute__((section("sfrs")));
#define OFF128 OFF128
extern volatile unsigned int   OFF128 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF128bits_t;
extern volatile __OFF128bits_t OFF128bits __asm__ ("OFF128") __attribute__((section("sfrs")));
#define OFF129 OFF129
extern volatile unsigned int   OFF129 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF129bits_t;
extern volatile __OFF129bits_t OFF129bits __asm__ ("OFF129") __attribute__((section("sfrs")));
#define OFF130 OFF130
extern volatile unsigned int   OFF130 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF130bits_t;
extern volatile __OFF130bits_t OFF130bits __asm__ ("OFF130") __attribute__((section("sfrs")));
#define OFF131 OFF131
extern volatile unsigned int   OFF131 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF131bits_t;
extern volatile __OFF131bits_t OFF131bits __asm__ ("OFF131") __attribute__((section("sfrs")));
#define OFF132 OFF132
extern volatile unsigned int   OFF132 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF132bits_t;
extern volatile __OFF132bits_t OFF132bits __asm__ ("OFF132") __attribute__((section("sfrs")));
#define OFF133 OFF133
extern volatile unsigned int   OFF133 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF133bits_t;
extern volatile __OFF133bits_t OFF133bits __asm__ ("OFF133") __attribute__((section("sfrs")));
#define OFF134 OFF134
extern volatile unsigned int   OFF134 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF134bits_t;
extern volatile __OFF134bits_t OFF134bits __asm__ ("OFF134") __attribute__((section("sfrs")));
#define OFF135 OFF135
extern volatile unsigned int   OFF135 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF135bits_t;
extern volatile __OFF135bits_t OFF135bits __asm__ ("OFF135") __attribute__((section("sfrs")));
#define OFF136 OFF136
extern volatile unsigned int   OFF136 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF136bits_t;
extern volatile __OFF136bits_t OFF136bits __asm__ ("OFF136") __attribute__((section("sfrs")));
#define OFF137 OFF137
extern volatile unsigned int   OFF137 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF137bits_t;
extern volatile __OFF137bits_t OFF137bits __asm__ ("OFF137") __attribute__((section("sfrs")));
#define OFF138 OFF138
extern volatile unsigned int   OFF138 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF138bits_t;
extern volatile __OFF138bits_t OFF138bits __asm__ ("OFF138") __attribute__((section("sfrs")));
#define OFF139 OFF139
extern volatile unsigned int   OFF139 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF139bits_t;
extern volatile __OFF139bits_t OFF139bits __asm__ ("OFF139") __attribute__((section("sfrs")));
#define OFF140 OFF140
extern volatile unsigned int   OFF140 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF140bits_t;
extern volatile __OFF140bits_t OFF140bits __asm__ ("OFF140") __attribute__((section("sfrs")));
#define OFF141 OFF141
extern volatile unsigned int   OFF141 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF141bits_t;
extern volatile __OFF141bits_t OFF141bits __asm__ ("OFF141") __attribute__((section("sfrs")));
#define OFF142 OFF142
extern volatile unsigned int   OFF142 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF142bits_t;
extern volatile __OFF142bits_t OFF142bits __asm__ ("OFF142") __attribute__((section("sfrs")));
#define OFF143 OFF143
extern volatile unsigned int   OFF143 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF143bits_t;
extern volatile __OFF143bits_t OFF143bits __asm__ ("OFF143") __attribute__((section("sfrs")));
#define OFF144 OFF144
extern volatile unsigned int   OFF144 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF144bits_t;
extern volatile __OFF144bits_t OFF144bits __asm__ ("OFF144") __attribute__((section("sfrs")));
#define OFF145 OFF145
extern volatile unsigned int   OFF145 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF145bits_t;
extern volatile __OFF145bits_t OFF145bits __asm__ ("OFF145") __attribute__((section("sfrs")));
#define OFF146 OFF146
extern volatile unsigned int   OFF146 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF146bits_t;
extern volatile __OFF146bits_t OFF146bits __asm__ ("OFF146") __attribute__((section("sfrs")));
#define OFF147 OFF147
extern volatile unsigned int   OFF147 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF147bits_t;
extern volatile __OFF147bits_t OFF147bits __asm__ ("OFF147") __attribute__((section("sfrs")));
#define OFF148 OFF148
extern volatile unsigned int   OFF148 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF148bits_t;
extern volatile __OFF148bits_t OFF148bits __asm__ ("OFF148") __attribute__((section("sfrs")));
#define OFF149 OFF149
extern volatile unsigned int   OFF149 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF149bits_t;
extern volatile __OFF149bits_t OFF149bits __asm__ ("OFF149") __attribute__((section("sfrs")));
#define OFF150 OFF150
extern volatile unsigned int   OFF150 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF150bits_t;
extern volatile __OFF150bits_t OFF150bits __asm__ ("OFF150") __attribute__((section("sfrs")));
#define OFF153 OFF153
extern volatile unsigned int   OFF153 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF153bits_t;
extern volatile __OFF153bits_t OFF153bits __asm__ ("OFF153") __attribute__((section("sfrs")));
#define OFF154 OFF154
extern volatile unsigned int   OFF154 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF154bits_t;
extern volatile __OFF154bits_t OFF154bits __asm__ ("OFF154") __attribute__((section("sfrs")));
#define OFF155 OFF155
extern volatile unsigned int   OFF155 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF155bits_t;
extern volatile __OFF155bits_t OFF155bits __asm__ ("OFF155") __attribute__((section("sfrs")));
#define OFF156 OFF156
extern volatile unsigned int   OFF156 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF156bits_t;
extern volatile __OFF156bits_t OFF156bits __asm__ ("OFF156") __attribute__((section("sfrs")));
#define OFF157 OFF157
extern volatile unsigned int   OFF157 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF157bits_t;
extern volatile __OFF157bits_t OFF157bits __asm__ ("OFF157") __attribute__((section("sfrs")));
#define OFF158 OFF158
extern volatile unsigned int   OFF158 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF158bits_t;
extern volatile __OFF158bits_t OFF158bits __asm__ ("OFF158") __attribute__((section("sfrs")));
#define OFF159 OFF159
extern volatile unsigned int   OFF159 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF159bits_t;
extern volatile __OFF159bits_t OFF159bits __asm__ ("OFF159") __attribute__((section("sfrs")));
#define OFF160 OFF160
extern volatile unsigned int   OFF160 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF160bits_t;
extern volatile __OFF160bits_t OFF160bits __asm__ ("OFF160") __attribute__((section("sfrs")));
#define OFF161 OFF161
extern volatile unsigned int   OFF161 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF161bits_t;
extern volatile __OFF161bits_t OFF161bits __asm__ ("OFF161") __attribute__((section("sfrs")));
#define OFF162 OFF162
extern volatile unsigned int   OFF162 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF162bits_t;
extern volatile __OFF162bits_t OFF162bits __asm__ ("OFF162") __attribute__((section("sfrs")));
#define OFF163 OFF163
extern volatile unsigned int   OFF163 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF163bits_t;
extern volatile __OFF163bits_t OFF163bits __asm__ ("OFF163") __attribute__((section("sfrs")));
#define OFF164 OFF164
extern volatile unsigned int   OFF164 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF164bits_t;
extern volatile __OFF164bits_t OFF164bits __asm__ ("OFF164") __attribute__((section("sfrs")));
#define OFF165 OFF165
extern volatile unsigned int   OFF165 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF165bits_t;
extern volatile __OFF165bits_t OFF165bits __asm__ ("OFF165") __attribute__((section("sfrs")));
#define OFF166 OFF166
extern volatile unsigned int   OFF166 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF166bits_t;
extern volatile __OFF166bits_t OFF166bits __asm__ ("OFF166") __attribute__((section("sfrs")));
#define OFF167 OFF167
extern volatile unsigned int   OFF167 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF167bits_t;
extern volatile __OFF167bits_t OFF167bits __asm__ ("OFF167") __attribute__((section("sfrs")));
#define OFF168 OFF168
extern volatile unsigned int   OFF168 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF168bits_t;
extern volatile __OFF168bits_t OFF168bits __asm__ ("OFF168") __attribute__((section("sfrs")));
#define OFF169 OFF169
extern volatile unsigned int   OFF169 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF169bits_t;
extern volatile __OFF169bits_t OFF169bits __asm__ ("OFF169") __attribute__((section("sfrs")));
#define OFF170 OFF170
extern volatile unsigned int   OFF170 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF170bits_t;
extern volatile __OFF170bits_t OFF170bits __asm__ ("OFF170") __attribute__((section("sfrs")));
#define OFF171 OFF171
extern volatile unsigned int   OFF171 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF171bits_t;
extern volatile __OFF171bits_t OFF171bits __asm__ ("OFF171") __attribute__((section("sfrs")));
#define OFF172 OFF172
extern volatile unsigned int   OFF172 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF172bits_t;
extern volatile __OFF172bits_t OFF172bits __asm__ ("OFF172") __attribute__((section("sfrs")));
#define OFF173 OFF173
extern volatile unsigned int   OFF173 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF173bits_t;
extern volatile __OFF173bits_t OFF173bits __asm__ ("OFF173") __attribute__((section("sfrs")));
#define OFF174 OFF174
extern volatile unsigned int   OFF174 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF174bits_t;
extern volatile __OFF174bits_t OFF174bits __asm__ ("OFF174") __attribute__((section("sfrs")));
#define OFF175 OFF175
extern volatile unsigned int   OFF175 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF175bits_t;
extern volatile __OFF175bits_t OFF175bits __asm__ ("OFF175") __attribute__((section("sfrs")));
#define OFF176 OFF176
extern volatile unsigned int   OFF176 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF176bits_t;
extern volatile __OFF176bits_t OFF176bits __asm__ ("OFF176") __attribute__((section("sfrs")));
#define OFF177 OFF177
extern volatile unsigned int   OFF177 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF177bits_t;
extern volatile __OFF177bits_t OFF177bits __asm__ ("OFF177") __attribute__((section("sfrs")));
#define OFF178 OFF178
extern volatile unsigned int   OFF178 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF178bits_t;
extern volatile __OFF178bits_t OFF178bits __asm__ ("OFF178") __attribute__((section("sfrs")));
#define OFF179 OFF179
extern volatile unsigned int   OFF179 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF179bits_t;
extern volatile __OFF179bits_t OFF179bits __asm__ ("OFF179") __attribute__((section("sfrs")));
#define OFF180 OFF180
extern volatile unsigned int   OFF180 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF180bits_t;
extern volatile __OFF180bits_t OFF180bits __asm__ ("OFF180") __attribute__((section("sfrs")));
#define OFF181 OFF181
extern volatile unsigned int   OFF181 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF181bits_t;
extern volatile __OFF181bits_t OFF181bits __asm__ ("OFF181") __attribute__((section("sfrs")));
#define OFF182 OFF182
extern volatile unsigned int   OFF182 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF182bits_t;
extern volatile __OFF182bits_t OFF182bits __asm__ ("OFF182") __attribute__((section("sfrs")));
#define OFF183 OFF183
extern volatile unsigned int   OFF183 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF183bits_t;
extern volatile __OFF183bits_t OFF183bits __asm__ ("OFF183") __attribute__((section("sfrs")));
#define OFF184 OFF184
extern volatile unsigned int   OFF184 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF184bits_t;
extern volatile __OFF184bits_t OFF184bits __asm__ ("OFF184") __attribute__((section("sfrs")));
#define OFF185 OFF185
extern volatile unsigned int   OFF185 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF185bits_t;
extern volatile __OFF185bits_t OFF185bits __asm__ ("OFF185") __attribute__((section("sfrs")));
#define OFF186 OFF186
extern volatile unsigned int   OFF186 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF186bits_t;
extern volatile __OFF186bits_t OFF186bits __asm__ ("OFF186") __attribute__((section("sfrs")));
#define OFF187 OFF187
extern volatile unsigned int   OFF187 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF187bits_t;
extern volatile __OFF187bits_t OFF187bits __asm__ ("OFF187") __attribute__((section("sfrs")));
#define OFF188 OFF188
extern volatile unsigned int   OFF188 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF188bits_t;
extern volatile __OFF188bits_t OFF188bits __asm__ ("OFF188") __attribute__((section("sfrs")));
#define OFF189 OFF189
extern volatile unsigned int   OFF189 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF189bits_t;
extern volatile __OFF189bits_t OFF189bits __asm__ ("OFF189") __attribute__((section("sfrs")));
#define OFF190 OFF190
extern volatile unsigned int   OFF190 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF190bits_t;
extern volatile __OFF190bits_t OFF190bits __asm__ ("OFF190") __attribute__((section("sfrs")));
#define OFF192 OFF192
extern volatile unsigned int   OFF192 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF192bits_t;
extern volatile __OFF192bits_t OFF192bits __asm__ ("OFF192") __attribute__((section("sfrs")));
#define OFF193 OFF193
extern volatile unsigned int   OFF193 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF193bits_t;
extern volatile __OFF193bits_t OFF193bits __asm__ ("OFF193") __attribute__((section("sfrs")));
#define OFF194 OFF194
extern volatile unsigned int   OFF194 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF194bits_t;
extern volatile __OFF194bits_t OFF194bits __asm__ ("OFF194") __attribute__((section("sfrs")));
#define OFF196 OFF196
extern volatile unsigned int   OFF196 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF196bits_t;
extern volatile __OFF196bits_t OFF196bits __asm__ ("OFF196") __attribute__((section("sfrs")));
#define OFF198 OFF198
extern volatile unsigned int   OFF198 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF198bits_t;
extern volatile __OFF198bits_t OFF198bits __asm__ ("OFF198") __attribute__((section("sfrs")));
#define OFF199 OFF199
extern volatile unsigned int   OFF199 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF199bits_t;
extern volatile __OFF199bits_t OFF199bits __asm__ ("OFF199") __attribute__((section("sfrs")));
#define OFF200 OFF200
extern volatile unsigned int   OFF200 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF200bits_t;
extern volatile __OFF200bits_t OFF200bits __asm__ ("OFF200") __attribute__((section("sfrs")));
#define OFF201 OFF201
extern volatile unsigned int   OFF201 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF201bits_t;
extern volatile __OFF201bits_t OFF201bits __asm__ ("OFF201") __attribute__((section("sfrs")));
#define OFF202 OFF202
extern volatile unsigned int   OFF202 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF202bits_t;
extern volatile __OFF202bits_t OFF202bits __asm__ ("OFF202") __attribute__((section("sfrs")));
#define OFF205 OFF205
extern volatile unsigned int   OFF205 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF205bits_t;
extern volatile __OFF205bits_t OFF205bits __asm__ ("OFF205") __attribute__((section("sfrs")));
#define OFF206 OFF206
extern volatile unsigned int   OFF206 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF206bits_t;
extern volatile __OFF206bits_t OFF206bits __asm__ ("OFF206") __attribute__((section("sfrs")));
#define OFF207 OFF207
extern volatile unsigned int   OFF207 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF207bits_t;
extern volatile __OFF207bits_t OFF207bits __asm__ ("OFF207") __attribute__((section("sfrs")));
#define OFF208 OFF208
extern volatile unsigned int   OFF208 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF208bits_t;
extern volatile __OFF208bits_t OFF208bits __asm__ ("OFF208") __attribute__((section("sfrs")));
#define OFF209 OFF209
extern volatile unsigned int   OFF209 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF209bits_t;
extern volatile __OFF209bits_t OFF209bits __asm__ ("OFF209") __attribute__((section("sfrs")));
#define OFF210 OFF210
extern volatile unsigned int   OFF210 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF210bits_t;
extern volatile __OFF210bits_t OFF210bits __asm__ ("OFF210") __attribute__((section("sfrs")));
#define OFF213 OFF213
extern volatile unsigned int   OFF213 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned VOFF:17;
} __OFF213bits_t;
extern volatile __OFF213bits_t OFF213bits __asm__ ("OFF213") __attribute__((section("sfrs")));
#define DMACON DMACON
extern volatile unsigned int   DMACON __attribute__((section("sfrs")));
typedef struct {
  unsigned :11;
  unsigned DMABUSY:1;
  unsigned SUSPEND:1;
  unsigned :2;
  unsigned ON:1;
} __DMACONbits_t;
extern volatile __DMACONbits_t DMACONbits __asm__ ("DMACON") __attribute__((section("sfrs")));
extern volatile unsigned int        DMACONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DMACONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DMACONINV __attribute__((section("sfrs")));
#define DMASTAT DMASTAT
extern volatile unsigned int   DMASTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACH:3;
  unsigned :28;
  unsigned RDWR:1;
} __DMASTATbits_t;
extern volatile __DMASTATbits_t DMASTATbits __asm__ ("DMASTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DMASTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DMASTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DMASTATINV __attribute__((section("sfrs")));
#define DMAADDR DMAADDR
extern volatile unsigned int   DMAADDR __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __DMAADDRbits_t;
extern volatile __DMAADDRbits_t DMAADDRbits __asm__ ("DMAADDR") __attribute__((section("sfrs")));
extern volatile unsigned int        DMAADDRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DMAADDRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DMAADDRINV __attribute__((section("sfrs")));
#define DCRCCON DCRCCON
extern volatile unsigned int   DCRCCON __attribute__((section("sfrs")));
typedef struct {
  unsigned CRCCH:3;
  unsigned :2;
  unsigned CRCTYP:1;
  unsigned CRCAPP:1;
  unsigned CRCEN:1;
  unsigned PLEN:5;
  unsigned :11;
  unsigned BITO:1;
  unsigned :2;
  unsigned WBO:1;
  unsigned BYTO:2;
} __DCRCCONbits_t;
extern volatile __DCRCCONbits_t DCRCCONbits __asm__ ("DCRCCON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCCONINV __attribute__((section("sfrs")));
#define DCRCDATA DCRCDATA
extern volatile unsigned int   DCRCDATA __attribute__((section("sfrs")));
typedef struct {
  unsigned DCRCDATA:32;
} __DCRCDATAbits_t;
extern volatile __DCRCDATAbits_t DCRCDATAbits __asm__ ("DCRCDATA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCDATACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCDATASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCDATAINV __attribute__((section("sfrs")));
#define DCRCXOR DCRCXOR
extern volatile unsigned int   DCRCXOR __attribute__((section("sfrs")));
typedef struct {
  unsigned DCRCXOR:32;
} __DCRCXORbits_t;
extern volatile __DCRCXORbits_t DCRCXORbits __asm__ ("DCRCXOR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCXORCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCXORSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCRCXORINV __attribute__((section("sfrs")));
#define DCH0CON DCH0CON
extern volatile unsigned int   DCH0CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH0CONbits_t;
extern volatile __DCH0CONbits_t DCH0CONbits __asm__ ("DCH0CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CONINV __attribute__((section("sfrs")));
#define DCH0ECON DCH0ECON
extern volatile unsigned int   DCH0ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH0ECONbits_t;
extern volatile __DCH0ECONbits_t DCH0ECONbits __asm__ ("DCH0ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0ECONINV __attribute__((section("sfrs")));
#define DCH0INT DCH0INT
extern volatile unsigned int   DCH0INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH0INTbits_t;
extern volatile __DCH0INTbits_t DCH0INTbits __asm__ ("DCH0INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0INTINV __attribute__((section("sfrs")));
#define DCH0SSA DCH0SSA
extern volatile unsigned int   DCH0SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH0SSAbits_t;
extern volatile __DCH0SSAbits_t DCH0SSAbits __asm__ ("DCH0SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSAINV __attribute__((section("sfrs")));
#define DCH0DSA DCH0DSA
extern volatile unsigned int   DCH0DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH0DSAbits_t;
extern volatile __DCH0DSAbits_t DCH0DSAbits __asm__ ("DCH0DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSAINV __attribute__((section("sfrs")));
#define DCH0SSIZ DCH0SSIZ
extern volatile unsigned int   DCH0SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH0SSIZbits_t;
extern volatile __DCH0SSIZbits_t DCH0SSIZbits __asm__ ("DCH0SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SSIZINV __attribute__((section("sfrs")));
#define DCH0DSIZ DCH0DSIZ
extern volatile unsigned int   DCH0DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH0DSIZbits_t;
extern volatile __DCH0DSIZbits_t DCH0DSIZbits __asm__ ("DCH0DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DSIZINV __attribute__((section("sfrs")));
#define DCH0SPTR DCH0SPTR
extern volatile unsigned int   DCH0SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH0SPTRbits_t;
extern volatile __DCH0SPTRbits_t DCH0SPTRbits __asm__ ("DCH0SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0SPTRINV __attribute__((section("sfrs")));
#define DCH0DPTR DCH0DPTR
extern volatile unsigned int   DCH0DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH0DPTRbits_t;
extern volatile __DCH0DPTRbits_t DCH0DPTRbits __asm__ ("DCH0DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DPTRINV __attribute__((section("sfrs")));
#define DCH0CSIZ DCH0CSIZ
extern volatile unsigned int   DCH0CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH0CSIZbits_t;
extern volatile __DCH0CSIZbits_t DCH0CSIZbits __asm__ ("DCH0CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CSIZINV __attribute__((section("sfrs")));
#define DCH0CPTR DCH0CPTR
extern volatile unsigned int   DCH0CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCH0CPTRbits_t;
extern volatile __DCH0CPTRbits_t DCH0CPTRbits __asm__ ("DCH0CPTR") __attribute__((section("sfrs")));
#define DCS0CPTR DCS0CPTR
extern volatile unsigned int   DCS0CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS0CPTRbits_t;
extern volatile __DCS0CPTRbits_t DCS0CPTRbits __asm__ ("DCS0CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS0CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS0CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS0CPTRINV __attribute__((section("sfrs")));
#define DCH0DAT DCH0DAT
extern volatile unsigned int   DCH0DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH0DATbits_t;
extern volatile __DCH0DATbits_t DCH0DATbits __asm__ ("DCH0DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH0DATINV __attribute__((section("sfrs")));
#define DCH1CON DCH1CON
extern volatile unsigned int   DCH1CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH1CONbits_t;
extern volatile __DCH1CONbits_t DCH1CONbits __asm__ ("DCH1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CONINV __attribute__((section("sfrs")));
#define DCH1ECON DCH1ECON
extern volatile unsigned int   DCH1ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH1ECONbits_t;
extern volatile __DCH1ECONbits_t DCH1ECONbits __asm__ ("DCH1ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1ECONINV __attribute__((section("sfrs")));
#define DCH1INT DCH1INT
extern volatile unsigned int   DCH1INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH1INTbits_t;
extern volatile __DCH1INTbits_t DCH1INTbits __asm__ ("DCH1INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1INTINV __attribute__((section("sfrs")));
#define DCH1SSA DCH1SSA
extern volatile unsigned int   DCH1SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH1SSAbits_t;
extern volatile __DCH1SSAbits_t DCH1SSAbits __asm__ ("DCH1SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSAINV __attribute__((section("sfrs")));
#define DCH1DSA DCH1DSA
extern volatile unsigned int   DCH1DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH1DSAbits_t;
extern volatile __DCH1DSAbits_t DCH1DSAbits __asm__ ("DCH1DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSAINV __attribute__((section("sfrs")));
#define DCH1SSIZ DCH1SSIZ
extern volatile unsigned int   DCH1SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH1SSIZbits_t;
extern volatile __DCH1SSIZbits_t DCH1SSIZbits __asm__ ("DCH1SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SSIZINV __attribute__((section("sfrs")));
#define DCH1DSIZ DCH1DSIZ
extern volatile unsigned int   DCH1DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH1DSIZbits_t;
extern volatile __DCH1DSIZbits_t DCH1DSIZbits __asm__ ("DCH1DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DSIZINV __attribute__((section("sfrs")));
#define DCH1SPTR DCH1SPTR
extern volatile unsigned int   DCH1SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH1SPTRbits_t;
extern volatile __DCH1SPTRbits_t DCH1SPTRbits __asm__ ("DCH1SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1SPTRINV __attribute__((section("sfrs")));
#define DCH1DPTR DCH1DPTR
extern volatile unsigned int   DCH1DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH1DPTRbits_t;
extern volatile __DCH1DPTRbits_t DCH1DPTRbits __asm__ ("DCH1DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DPTRINV __attribute__((section("sfrs")));
#define DCH1CSIZ DCH1CSIZ
extern volatile unsigned int   DCH1CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH1CSIZbits_t;
extern volatile __DCH1CSIZbits_t DCH1CSIZbits __asm__ ("DCH1CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CSIZINV __attribute__((section("sfrs")));
#define DCH1CPTR DCH1CPTR
extern volatile unsigned int   DCH1CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCH1CPTRbits_t;
extern volatile __DCH1CPTRbits_t DCH1CPTRbits __asm__ ("DCH1CPTR") __attribute__((section("sfrs")));
#define DCS1CPTR DCS1CPTR
extern volatile unsigned int   DCS1CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS1CPTRbits_t;
extern volatile __DCS1CPTRbits_t DCS1CPTRbits __asm__ ("DCS1CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS1CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS1CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS1CPTRINV __attribute__((section("sfrs")));
#define DCH1DAT DCH1DAT
extern volatile unsigned int   DCH1DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH1DATbits_t;
extern volatile __DCH1DATbits_t DCH1DATbits __asm__ ("DCH1DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH1DATINV __attribute__((section("sfrs")));
#define DCH2CON DCH2CON
extern volatile unsigned int   DCH2CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH2CONbits_t;
extern volatile __DCH2CONbits_t DCH2CONbits __asm__ ("DCH2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CONINV __attribute__((section("sfrs")));
#define DCH2ECON DCH2ECON
extern volatile unsigned int   DCH2ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH2ECONbits_t;
extern volatile __DCH2ECONbits_t DCH2ECONbits __asm__ ("DCH2ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2ECONINV __attribute__((section("sfrs")));
#define DCH2INT DCH2INT
extern volatile unsigned int   DCH2INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH2INTbits_t;
extern volatile __DCH2INTbits_t DCH2INTbits __asm__ ("DCH2INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2INTINV __attribute__((section("sfrs")));
#define DCH2SSA DCH2SSA
extern volatile unsigned int   DCH2SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH2SSAbits_t;
extern volatile __DCH2SSAbits_t DCH2SSAbits __asm__ ("DCH2SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSAINV __attribute__((section("sfrs")));
#define DCH2DSA DCH2DSA
extern volatile unsigned int   DCH2DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH2DSAbits_t;
extern volatile __DCH2DSAbits_t DCH2DSAbits __asm__ ("DCH2DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSAINV __attribute__((section("sfrs")));
#define DCH2SSIZ DCH2SSIZ
extern volatile unsigned int   DCH2SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH2SSIZbits_t;
extern volatile __DCH2SSIZbits_t DCH2SSIZbits __asm__ ("DCH2SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SSIZINV __attribute__((section("sfrs")));
#define DCH2DSIZ DCH2DSIZ
extern volatile unsigned int   DCH2DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH2DSIZbits_t;
extern volatile __DCH2DSIZbits_t DCH2DSIZbits __asm__ ("DCH2DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DSIZINV __attribute__((section("sfrs")));
#define DCH2SPTR DCH2SPTR
extern volatile unsigned int   DCH2SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH2SPTRbits_t;
extern volatile __DCH2SPTRbits_t DCH2SPTRbits __asm__ ("DCH2SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2SPTRINV __attribute__((section("sfrs")));
#define DCH2DPTR DCH2DPTR
extern volatile unsigned int   DCH2DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH2DPTRbits_t;
extern volatile __DCH2DPTRbits_t DCH2DPTRbits __asm__ ("DCH2DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DPTRINV __attribute__((section("sfrs")));
#define DCH2CSIZ DCH2CSIZ
extern volatile unsigned int   DCH2CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH2CSIZbits_t;
extern volatile __DCH2CSIZbits_t DCH2CSIZbits __asm__ ("DCH2CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CSIZINV __attribute__((section("sfrs")));
#define DCH2CPTR DCH2CPTR
extern volatile unsigned int   DCH2CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCH2CPTRbits_t;
extern volatile __DCH2CPTRbits_t DCH2CPTRbits __asm__ ("DCH2CPTR") __attribute__((section("sfrs")));
#define DCS2CPTR DCS2CPTR
extern volatile unsigned int   DCS2CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS2CPTRbits_t;
extern volatile __DCS2CPTRbits_t DCS2CPTRbits __asm__ ("DCS2CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS2CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS2CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS2CPTRINV __attribute__((section("sfrs")));
#define DCH2DAT DCH2DAT
extern volatile unsigned int   DCH2DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH2DATbits_t;
extern volatile __DCH2DATbits_t DCH2DATbits __asm__ ("DCH2DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH2DATINV __attribute__((section("sfrs")));
#define DCH3CON DCH3CON
extern volatile unsigned int   DCH3CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH3CONbits_t;
extern volatile __DCH3CONbits_t DCH3CONbits __asm__ ("DCH3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CONINV __attribute__((section("sfrs")));
#define DCH3ECON DCH3ECON
extern volatile unsigned int   DCH3ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH3ECONbits_t;
extern volatile __DCH3ECONbits_t DCH3ECONbits __asm__ ("DCH3ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3ECONINV __attribute__((section("sfrs")));
#define DCH3INT DCH3INT
extern volatile unsigned int   DCH3INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH3INTbits_t;
extern volatile __DCH3INTbits_t DCH3INTbits __asm__ ("DCH3INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3INTINV __attribute__((section("sfrs")));
#define DCH3SSA DCH3SSA
extern volatile unsigned int   DCH3SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH3SSAbits_t;
extern volatile __DCH3SSAbits_t DCH3SSAbits __asm__ ("DCH3SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSAINV __attribute__((section("sfrs")));
#define DCH3DSA DCH3DSA
extern volatile unsigned int   DCH3DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH3DSAbits_t;
extern volatile __DCH3DSAbits_t DCH3DSAbits __asm__ ("DCH3DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSAINV __attribute__((section("sfrs")));
#define DCH3SSIZ DCH3SSIZ
extern volatile unsigned int   DCH3SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH3SSIZbits_t;
extern volatile __DCH3SSIZbits_t DCH3SSIZbits __asm__ ("DCH3SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SSIZINV __attribute__((section("sfrs")));
#define DCH3DSIZ DCH3DSIZ
extern volatile unsigned int   DCH3DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH3DSIZbits_t;
extern volatile __DCH3DSIZbits_t DCH3DSIZbits __asm__ ("DCH3DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DSIZINV __attribute__((section("sfrs")));
#define DCH3SPTR DCH3SPTR
extern volatile unsigned int   DCH3SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH3SPTRbits_t;
extern volatile __DCH3SPTRbits_t DCH3SPTRbits __asm__ ("DCH3SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3SPTRINV __attribute__((section("sfrs")));
#define DCH3DPTR DCH3DPTR
extern volatile unsigned int   DCH3DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH3DPTRbits_t;
extern volatile __DCH3DPTRbits_t DCH3DPTRbits __asm__ ("DCH3DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DPTRINV __attribute__((section("sfrs")));
#define DCH3CSIZ DCH3CSIZ
extern volatile unsigned int   DCH3CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH3CSIZbits_t;
extern volatile __DCH3CSIZbits_t DCH3CSIZbits __asm__ ("DCH3CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CSIZINV __attribute__((section("sfrs")));
#define DCH3CPTR DCH3CPTR
extern volatile unsigned int   DCH3CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCH3CPTRbits_t;
extern volatile __DCH3CPTRbits_t DCH3CPTRbits __asm__ ("DCH3CPTR") __attribute__((section("sfrs")));
#define DCS3CPTR DCS3CPTR
extern volatile unsigned int   DCS3CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS3CPTRbits_t;
extern volatile __DCS3CPTRbits_t DCS3CPTRbits __asm__ ("DCS3CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS3CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS3CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS3CPTRINV __attribute__((section("sfrs")));
#define DCH3DAT DCH3DAT
extern volatile unsigned int   DCH3DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH3DATbits_t;
extern volatile __DCH3DATbits_t DCH3DATbits __asm__ ("DCH3DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH3DATINV __attribute__((section("sfrs")));
#define DCH4CON DCH4CON
extern volatile unsigned int   DCH4CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH4CONbits_t;
extern volatile __DCH4CONbits_t DCH4CONbits __asm__ ("DCH4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CONINV __attribute__((section("sfrs")));
#define DCH4ECON DCH4ECON
extern volatile unsigned int   DCH4ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH4ECONbits_t;
extern volatile __DCH4ECONbits_t DCH4ECONbits __asm__ ("DCH4ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4ECONINV __attribute__((section("sfrs")));
#define DCH4INT DCH4INT
extern volatile unsigned int   DCH4INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH4INTbits_t;
extern volatile __DCH4INTbits_t DCH4INTbits __asm__ ("DCH4INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4INTINV __attribute__((section("sfrs")));
#define DCH4SSA DCH4SSA
extern volatile unsigned int   DCH4SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH4SSAbits_t;
extern volatile __DCH4SSAbits_t DCH4SSAbits __asm__ ("DCH4SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSAINV __attribute__((section("sfrs")));
#define DCH4DSA DCH4DSA
extern volatile unsigned int   DCH4DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH4DSAbits_t;
extern volatile __DCH4DSAbits_t DCH4DSAbits __asm__ ("DCH4DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSAINV __attribute__((section("sfrs")));
#define DCH4SSIZ DCH4SSIZ
extern volatile unsigned int   DCH4SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH4SSIZbits_t;
extern volatile __DCH4SSIZbits_t DCH4SSIZbits __asm__ ("DCH4SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SSIZINV __attribute__((section("sfrs")));
#define DCH4DSIZ DCH4DSIZ
extern volatile unsigned int   DCH4DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH4DSIZbits_t;
extern volatile __DCH4DSIZbits_t DCH4DSIZbits __asm__ ("DCH4DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DSIZINV __attribute__((section("sfrs")));
#define DCH4SPTR DCH4SPTR
extern volatile unsigned int   DCH4SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH4SPTRbits_t;
extern volatile __DCH4SPTRbits_t DCH4SPTRbits __asm__ ("DCH4SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4SPTRINV __attribute__((section("sfrs")));
#define DCH4DPTR DCH4DPTR
extern volatile unsigned int   DCH4DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH4DPTRbits_t;
extern volatile __DCH4DPTRbits_t DCH4DPTRbits __asm__ ("DCH4DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DPTRINV __attribute__((section("sfrs")));
#define DCH4CSIZ DCH4CSIZ
extern volatile unsigned int   DCH4CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH4CSIZbits_t;
extern volatile __DCH4CSIZbits_t DCH4CSIZbits __asm__ ("DCH4CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CSIZINV __attribute__((section("sfrs")));
#define DCH4CPTR DCH4CPTR
extern volatile unsigned int   DCH4CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCH4CPTRbits_t;
extern volatile __DCH4CPTRbits_t DCH4CPTRbits __asm__ ("DCH4CPTR") __attribute__((section("sfrs")));
#define DCS4CPTR DCS4CPTR
extern volatile unsigned int   DCS4CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS4CPTRbits_t;
extern volatile __DCS4CPTRbits_t DCS4CPTRbits __asm__ ("DCS4CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS4CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS4CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS4CPTRINV __attribute__((section("sfrs")));
#define DCH4DAT DCH4DAT
extern volatile unsigned int   DCH4DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH4DATbits_t;
extern volatile __DCH4DATbits_t DCH4DATbits __asm__ ("DCH4DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH4DATINV __attribute__((section("sfrs")));
#define DCH5CON DCH5CON
extern volatile unsigned int   DCH5CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH5CONbits_t;
extern volatile __DCH5CONbits_t DCH5CONbits __asm__ ("DCH5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CONINV __attribute__((section("sfrs")));
#define DCH5ECON DCH5ECON
extern volatile unsigned int   DCH5ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH5ECONbits_t;
extern volatile __DCH5ECONbits_t DCH5ECONbits __asm__ ("DCH5ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5ECONINV __attribute__((section("sfrs")));
#define DCH5INT DCH5INT
extern volatile unsigned int   DCH5INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH5INTbits_t;
extern volatile __DCH5INTbits_t DCH5INTbits __asm__ ("DCH5INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5INTINV __attribute__((section("sfrs")));
#define DCH5SSA DCH5SSA
extern volatile unsigned int   DCH5SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH5SSAbits_t;
extern volatile __DCH5SSAbits_t DCH5SSAbits __asm__ ("DCH5SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSAINV __attribute__((section("sfrs")));
#define DCH5DSA DCH5DSA
extern volatile unsigned int   DCH5DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH5DSAbits_t;
extern volatile __DCH5DSAbits_t DCH5DSAbits __asm__ ("DCH5DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSAINV __attribute__((section("sfrs")));
#define DCH5SSIZ DCH5SSIZ
extern volatile unsigned int   DCH5SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH5SSIZbits_t;
extern volatile __DCH5SSIZbits_t DCH5SSIZbits __asm__ ("DCH5SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SSIZINV __attribute__((section("sfrs")));
#define DCH5DSIZ DCH5DSIZ
extern volatile unsigned int   DCH5DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH5DSIZbits_t;
extern volatile __DCH5DSIZbits_t DCH5DSIZbits __asm__ ("DCH5DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DSIZINV __attribute__((section("sfrs")));
#define DCH5SPTR DCH5SPTR
extern volatile unsigned int   DCH5SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH5SPTRbits_t;
extern volatile __DCH5SPTRbits_t DCH5SPTRbits __asm__ ("DCH5SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5SPTRINV __attribute__((section("sfrs")));
#define DCH5DPTR DCH5DPTR
extern volatile unsigned int   DCH5DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH5DPTRbits_t;
extern volatile __DCH5DPTRbits_t DCH5DPTRbits __asm__ ("DCH5DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DPTRINV __attribute__((section("sfrs")));
#define DCH5CSIZ DCH5CSIZ
extern volatile unsigned int   DCH5CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH5CSIZbits_t;
extern volatile __DCH5CSIZbits_t DCH5CSIZbits __asm__ ("DCH5CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CSIZINV __attribute__((section("sfrs")));
#define DCH5CPTR DCH5CPTR
extern volatile unsigned int   DCH5CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCH5CPTRbits_t;
extern volatile __DCH5CPTRbits_t DCH5CPTRbits __asm__ ("DCH5CPTR") __attribute__((section("sfrs")));
#define DCS5CPTR DCS5CPTR
extern volatile unsigned int   DCS5CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS5CPTRbits_t;
extern volatile __DCS5CPTRbits_t DCS5CPTRbits __asm__ ("DCS5CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS5CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS5CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS5CPTRINV __attribute__((section("sfrs")));
#define DCH5DAT DCH5DAT
extern volatile unsigned int   DCH5DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH5DATbits_t;
extern volatile __DCH5DATbits_t DCH5DATbits __asm__ ("DCH5DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH5DATINV __attribute__((section("sfrs")));
#define DCH6CON DCH6CON
extern volatile unsigned int   DCH6CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH6CONbits_t;
extern volatile __DCH6CONbits_t DCH6CONbits __asm__ ("DCH6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CONINV __attribute__((section("sfrs")));
#define DCH6ECON DCH6ECON
extern volatile unsigned int   DCH6ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH6ECONbits_t;
extern volatile __DCH6ECONbits_t DCH6ECONbits __asm__ ("DCH6ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6ECONINV __attribute__((section("sfrs")));
#define DCH6INT DCH6INT
extern volatile unsigned int   DCH6INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH6INTbits_t;
extern volatile __DCH6INTbits_t DCH6INTbits __asm__ ("DCH6INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6INTINV __attribute__((section("sfrs")));
#define DCH6SSA DCH6SSA
extern volatile unsigned int   DCH6SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH6SSAbits_t;
extern volatile __DCH6SSAbits_t DCH6SSAbits __asm__ ("DCH6SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSAINV __attribute__((section("sfrs")));
#define DCH6DSA DCH6DSA
extern volatile unsigned int   DCH6DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH6DSAbits_t;
extern volatile __DCH6DSAbits_t DCH6DSAbits __asm__ ("DCH6DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSAINV __attribute__((section("sfrs")));
#define DCH6SSIZ DCH6SSIZ
extern volatile unsigned int   DCH6SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH6SSIZbits_t;
extern volatile __DCH6SSIZbits_t DCH6SSIZbits __asm__ ("DCH6SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SSIZINV __attribute__((section("sfrs")));
#define DCH6DSIZ DCH6DSIZ
extern volatile unsigned int   DCH6DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH6DSIZbits_t;
extern volatile __DCH6DSIZbits_t DCH6DSIZbits __asm__ ("DCH6DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DSIZINV __attribute__((section("sfrs")));
#define DCH6SPTR DCH6SPTR
extern volatile unsigned int   DCH6SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH6SPTRbits_t;
extern volatile __DCH6SPTRbits_t DCH6SPTRbits __asm__ ("DCH6SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6SPTRINV __attribute__((section("sfrs")));
#define DCH6DPTR DCH6DPTR
extern volatile unsigned int   DCH6DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH6DPTRbits_t;
extern volatile __DCH6DPTRbits_t DCH6DPTRbits __asm__ ("DCH6DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DPTRINV __attribute__((section("sfrs")));
#define DCH6CSIZ DCH6CSIZ
extern volatile unsigned int   DCH6CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH6CSIZbits_t;
extern volatile __DCH6CSIZbits_t DCH6CSIZbits __asm__ ("DCH6CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CSIZINV __attribute__((section("sfrs")));
#define DCH6CPTR DCH6CPTR
extern volatile unsigned int   DCH6CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCH6CPTRbits_t;
extern volatile __DCH6CPTRbits_t DCH6CPTRbits __asm__ ("DCH6CPTR") __attribute__((section("sfrs")));
#define DCS6CPTR DCS6CPTR
extern volatile unsigned int   DCS6CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS6CPTRbits_t;
extern volatile __DCS6CPTRbits_t DCS6CPTRbits __asm__ ("DCS6CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS6CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS6CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS6CPTRINV __attribute__((section("sfrs")));
#define DCH6DAT DCH6DAT
extern volatile unsigned int   DCH6DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH6DATbits_t;
extern volatile __DCH6DATbits_t DCH6DATbits __asm__ ("DCH6DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH6DATINV __attribute__((section("sfrs")));
#define DCH7CON DCH7CON
extern volatile unsigned int   DCH7CON __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPRI:2;
  unsigned CHEDET:1;
  unsigned :1;
  unsigned CHAEN:1;
  unsigned CHCHN:1;
  unsigned CHAED:1;
  unsigned CHEN:1;
  unsigned CHCHNS:1;
  unsigned :2;
  unsigned CHPATLEN:1;
  unsigned :1;
  unsigned CHPIGNEN:1;
  unsigned :1;
  unsigned CHBUSY:1;
  unsigned :8;
  unsigned CHPIGN:8;
} __DCH7CONbits_t;
extern volatile __DCH7CONbits_t DCH7CONbits __asm__ ("DCH7CON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CONINV __attribute__((section("sfrs")));
#define DCH7ECON DCH7ECON
extern volatile unsigned int   DCH7ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned AIRQEN:1;
  unsigned SIRQEN:1;
  unsigned PATEN:1;
  unsigned CABORT:1;
  unsigned CFORCE:1;
  unsigned CHSIRQ:8;
  unsigned CHAIRQ:8;
} __DCH7ECONbits_t;
extern volatile __DCH7ECONbits_t DCH7ECONbits __asm__ ("DCH7ECON") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7ECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7ECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7ECONINV __attribute__((section("sfrs")));
#define DCH7INT DCH7INT
extern volatile unsigned int   DCH7INT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHERIF:1;
  unsigned CHTAIF:1;
  unsigned CHCCIF:1;
  unsigned CHBCIF:1;
  unsigned CHDHIF:1;
  unsigned CHDDIF:1;
  unsigned CHSHIF:1;
  unsigned CHSDIF:1;
  unsigned :8;
  unsigned CHERIE:1;
  unsigned CHTAIE:1;
  unsigned CHCCIE:1;
  unsigned CHBCIE:1;
  unsigned CHDHIE:1;
  unsigned CHDDIE:1;
  unsigned CHSHIE:1;
  unsigned CHSDIE:1;
} __DCH7INTbits_t;
extern volatile __DCH7INTbits_t DCH7INTbits __asm__ ("DCH7INT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7INTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7INTSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7INTINV __attribute__((section("sfrs")));
#define DCH7SSA DCH7SSA
extern volatile unsigned int   DCH7SSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSA:32;
} __DCH7SSAbits_t;
extern volatile __DCH7SSAbits_t DCH7SSAbits __asm__ ("DCH7SSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSAINV __attribute__((section("sfrs")));
#define DCH7DSA DCH7DSA
extern volatile unsigned int   DCH7DSA __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSA:32;
} __DCH7DSAbits_t;
extern volatile __DCH7DSAbits_t DCH7DSAbits __asm__ ("DCH7DSA") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSACLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSASET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSAINV __attribute__((section("sfrs")));
#define DCH7SSIZ DCH7SSIZ
extern volatile unsigned int   DCH7SSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSSIZ:16;
} __DCH7SSIZbits_t;
extern volatile __DCH7SSIZbits_t DCH7SSIZbits __asm__ ("DCH7SSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SSIZINV __attribute__((section("sfrs")));
#define DCH7DSIZ DCH7DSIZ
extern volatile unsigned int   DCH7DSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDSIZ:16;
} __DCH7DSIZbits_t;
extern volatile __DCH7DSIZbits_t DCH7DSIZbits __asm__ ("DCH7DSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DSIZINV __attribute__((section("sfrs")));
#define DCH7SPTR DCH7SPTR
extern volatile unsigned int   DCH7SPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHSPTR:16;
} __DCH7SPTRbits_t;
extern volatile __DCH7SPTRbits_t DCH7SPTRbits __asm__ ("DCH7SPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7SPTRINV __attribute__((section("sfrs")));
#define DCH7DPTR DCH7DPTR
extern volatile unsigned int   DCH7DPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHDPTR:16;
} __DCH7DPTRbits_t;
extern volatile __DCH7DPTRbits_t DCH7DPTRbits __asm__ ("DCH7DPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DPTRINV __attribute__((section("sfrs")));
#define DCH7CSIZ DCH7CSIZ
extern volatile unsigned int   DCH7CSIZ __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCSIZ:16;
} __DCH7CSIZbits_t;
extern volatile __DCH7CSIZbits_t DCH7CSIZbits __asm__ ("DCH7CSIZ") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CSIZCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CSIZSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CSIZINV __attribute__((section("sfrs")));
#define DCH7CPTR DCH7CPTR
extern volatile unsigned int   DCH7CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCH7CPTRbits_t;
extern volatile __DCH7CPTRbits_t DCH7CPTRbits __asm__ ("DCH7CPTR") __attribute__((section("sfrs")));
#define DCS7CPTR DCS7CPTR
extern volatile unsigned int   DCS7CPTR __attribute__((section("sfrs")));
typedef struct {
  unsigned CHCPTR:16;
} __DCS7CPTRbits_t;
extern volatile __DCS7CPTRbits_t DCS7CPTRbits __asm__ ("DCS7CPTR") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCS7CPTRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCS7CPTRSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7CPTRINV __attribute__((section("sfrs")));
extern volatile unsigned int        DCS7CPTRINV __attribute__((section("sfrs")));
#define DCH7DAT DCH7DAT
extern volatile unsigned int   DCH7DAT __attribute__((section("sfrs")));
typedef struct {
  unsigned CHPDAT:16;
} __DCH7DATbits_t;
extern volatile __DCH7DATbits_t DCH7DATbits __asm__ ("DCH7DAT") __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DATSET __attribute__((section("sfrs")));
extern volatile unsigned int        DCH7DATINV __attribute__((section("sfrs")));
#define I2C1CON I2C1CON
extern volatile unsigned int   I2C1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C1CONbits_t;
extern volatile __I2C1CONbits_t I2C1CONbits __asm__ ("I2C1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1CONINV __attribute__((section("sfrs")));
#define I2C1STAT I2C1STAT
extern volatile unsigned int   I2C1STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C1STATbits_t;
extern volatile __I2C1STATbits_t I2C1STATbits __asm__ ("I2C1STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1STATINV __attribute__((section("sfrs")));
#define I2C1ADD I2C1ADD
extern volatile unsigned int   I2C1ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C1ADDbits_t;
extern volatile __I2C1ADDbits_t I2C1ADDbits __asm__ ("I2C1ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1ADDINV __attribute__((section("sfrs")));
#define I2C1MSK I2C1MSK
extern volatile unsigned int   I2C1MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C1MSKbits_t;
extern volatile __I2C1MSKbits_t I2C1MSKbits __asm__ ("I2C1MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1MSKINV __attribute__((section("sfrs")));
#define I2C1BRG I2C1BRG
extern volatile unsigned int   I2C1BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C1BRGbits_t;
extern volatile __I2C1BRGbits_t I2C1BRGbits __asm__ ("I2C1BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1BRGINV __attribute__((section("sfrs")));
#define I2C1TRN I2C1TRN
extern volatile unsigned int   I2C1TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C1TRNbits_t;
extern volatile __I2C1TRNbits_t I2C1TRNbits __asm__ ("I2C1TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1TRNINV __attribute__((section("sfrs")));
#define I2C1RCV I2C1RCV
extern volatile unsigned int   I2C1RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C1RCVbits_t;
extern volatile __I2C1RCVbits_t I2C1RCVbits __asm__ ("I2C1RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C1RCVINV __attribute__((section("sfrs")));
#define I2C2CON I2C2CON
extern volatile unsigned int   I2C2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C2CONbits_t;
extern volatile __I2C2CONbits_t I2C2CONbits __asm__ ("I2C2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2CONINV __attribute__((section("sfrs")));
#define I2C2STAT I2C2STAT
extern volatile unsigned int   I2C2STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C2STATbits_t;
extern volatile __I2C2STATbits_t I2C2STATbits __asm__ ("I2C2STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2STATINV __attribute__((section("sfrs")));
#define I2C2ADD I2C2ADD
extern volatile unsigned int   I2C2ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C2ADDbits_t;
extern volatile __I2C2ADDbits_t I2C2ADDbits __asm__ ("I2C2ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2ADDINV __attribute__((section("sfrs")));
#define I2C2MSK I2C2MSK
extern volatile unsigned int   I2C2MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C2MSKbits_t;
extern volatile __I2C2MSKbits_t I2C2MSKbits __asm__ ("I2C2MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2MSKINV __attribute__((section("sfrs")));
#define I2C2BRG I2C2BRG
extern volatile unsigned int   I2C2BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C2BRGbits_t;
extern volatile __I2C2BRGbits_t I2C2BRGbits __asm__ ("I2C2BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2BRGINV __attribute__((section("sfrs")));
#define I2C2TRN I2C2TRN
extern volatile unsigned int   I2C2TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C2TRNbits_t;
extern volatile __I2C2TRNbits_t I2C2TRNbits __asm__ ("I2C2TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2TRNINV __attribute__((section("sfrs")));
#define I2C2RCV I2C2RCV
extern volatile unsigned int   I2C2RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C2RCVbits_t;
extern volatile __I2C2RCVbits_t I2C2RCVbits __asm__ ("I2C2RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C2RCVINV __attribute__((section("sfrs")));
#define I2C3CON I2C3CON
extern volatile unsigned int   I2C3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C3CONbits_t;
extern volatile __I2C3CONbits_t I2C3CONbits __asm__ ("I2C3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3CONINV __attribute__((section("sfrs")));
#define I2C3STAT I2C3STAT
extern volatile unsigned int   I2C3STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C3STATbits_t;
extern volatile __I2C3STATbits_t I2C3STATbits __asm__ ("I2C3STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3STATINV __attribute__((section("sfrs")));
#define I2C3ADD I2C3ADD
extern volatile unsigned int   I2C3ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C3ADDbits_t;
extern volatile __I2C3ADDbits_t I2C3ADDbits __asm__ ("I2C3ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3ADDINV __attribute__((section("sfrs")));
#define I2C3MSK I2C3MSK
extern volatile unsigned int   I2C3MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C3MSKbits_t;
extern volatile __I2C3MSKbits_t I2C3MSKbits __asm__ ("I2C3MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3MSKINV __attribute__((section("sfrs")));
#define I2C3BRG I2C3BRG
extern volatile unsigned int   I2C3BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C3BRGbits_t;
extern volatile __I2C3BRGbits_t I2C3BRGbits __asm__ ("I2C3BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3BRGINV __attribute__((section("sfrs")));
#define I2C3TRN I2C3TRN
extern volatile unsigned int   I2C3TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C3TRNbits_t;
extern volatile __I2C3TRNbits_t I2C3TRNbits __asm__ ("I2C3TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3TRNINV __attribute__((section("sfrs")));
#define I2C3RCV I2C3RCV
extern volatile unsigned int   I2C3RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C3RCVbits_t;
extern volatile __I2C3RCVbits_t I2C3RCVbits __asm__ ("I2C3RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C3RCVINV __attribute__((section("sfrs")));
#define I2C4CON I2C4CON
extern volatile unsigned int   I2C4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C4CONbits_t;
extern volatile __I2C4CONbits_t I2C4CONbits __asm__ ("I2C4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4CONINV __attribute__((section("sfrs")));
#define I2C4STAT I2C4STAT
extern volatile unsigned int   I2C4STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C4STATbits_t;
extern volatile __I2C4STATbits_t I2C4STATbits __asm__ ("I2C4STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4STATINV __attribute__((section("sfrs")));
#define I2C4ADD I2C4ADD
extern volatile unsigned int   I2C4ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C4ADDbits_t;
extern volatile __I2C4ADDbits_t I2C4ADDbits __asm__ ("I2C4ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4ADDINV __attribute__((section("sfrs")));
#define I2C4MSK I2C4MSK
extern volatile unsigned int   I2C4MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C4MSKbits_t;
extern volatile __I2C4MSKbits_t I2C4MSKbits __asm__ ("I2C4MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4MSKINV __attribute__((section("sfrs")));
#define I2C4BRG I2C4BRG
extern volatile unsigned int   I2C4BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C4BRGbits_t;
extern volatile __I2C4BRGbits_t I2C4BRGbits __asm__ ("I2C4BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4BRGINV __attribute__((section("sfrs")));
#define I2C4TRN I2C4TRN
extern volatile unsigned int   I2C4TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C4TRNbits_t;
extern volatile __I2C4TRNbits_t I2C4TRNbits __asm__ ("I2C4TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4TRNINV __attribute__((section("sfrs")));
#define I2C4RCV I2C4RCV
extern volatile unsigned int   I2C4RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C4RCVbits_t;
extern volatile __I2C4RCVbits_t I2C4RCVbits __asm__ ("I2C4RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C4RCVINV __attribute__((section("sfrs")));
#define I2C5CON I2C5CON
extern volatile unsigned int   I2C5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SEN:1;
    unsigned RSEN:1;
    unsigned PEN:1;
    unsigned RCEN:1;
    unsigned ACKEN:1;
    unsigned ACKDT:1;
    unsigned STREN:1;
    unsigned GCEN:1;
    unsigned SMEN:1;
    unsigned DISSLW:1;
    unsigned A10M:1;
    unsigned STRICT:1;
    unsigned SCLREL:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned DHEN:1;
    unsigned AHEN:1;
    unsigned SBCDE:1;
    unsigned SDAHT:1;
    unsigned BOEN:1;
    unsigned SCIE:1;
    unsigned PCIE:1;
  };
  struct {
    unsigned :11;
    unsigned IPMIEN:1;
    unsigned :1;
    unsigned I2CSIDL:1;
    unsigned :1;
    unsigned I2CEN:1;
  };
} __I2C5CONbits_t;
extern volatile __I2C5CONbits_t I2C5CONbits __asm__ ("I2C5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5CONINV __attribute__((section("sfrs")));
#define I2C5STAT I2C5STAT
extern volatile unsigned int   I2C5STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TBF:1;
    unsigned RBF:1;
    unsigned R_W:1;
    unsigned S:1;
    unsigned P:1;
    unsigned D_A:1;
    unsigned I2COV:1;
    unsigned IWCOL:1;
    unsigned ADD10:1;
    unsigned GCSTAT:1;
    unsigned BCL:1;
    unsigned :2;
    unsigned ACKTIM:1;
    unsigned TRSTAT:1;
    unsigned ACKSTAT:1;
  };
  struct {
    unsigned :6;
    unsigned I2CPOV:1;
  };
} __I2C5STATbits_t;
extern volatile __I2C5STATbits_t I2C5STATbits __asm__ ("I2C5STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5STATINV __attribute__((section("sfrs")));
#define I2C5ADD I2C5ADD
extern volatile unsigned int   I2C5ADD __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CADD:10;
} __I2C5ADDbits_t;
extern volatile __I2C5ADDbits_t I2C5ADDbits __asm__ ("I2C5ADD") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5ADDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5ADDSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5ADDINV __attribute__((section("sfrs")));
#define I2C5MSK I2C5MSK
extern volatile unsigned int   I2C5MSK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned I2CMSK:10;
  };
  struct {
    unsigned AMSK:10;
  };
} __I2C5MSKbits_t;
extern volatile __I2C5MSKbits_t I2C5MSKbits __asm__ ("I2C5MSK") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5MSKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5MSKSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5MSKINV __attribute__((section("sfrs")));
#define I2C5BRG I2C5BRG
extern volatile unsigned int   I2C5BRG __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CBRG:16;
} __I2C5BRGbits_t;
extern volatile __I2C5BRGbits_t I2C5BRGbits __asm__ ("I2C5BRG") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5BRGINV __attribute__((section("sfrs")));
#define I2C5TRN I2C5TRN
extern volatile unsigned int   I2C5TRN __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CTRN:8;
} __I2C5TRNbits_t;
extern volatile __I2C5TRNbits_t I2C5TRNbits __asm__ ("I2C5TRN") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5TRNCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5TRNSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5TRNINV __attribute__((section("sfrs")));
#define I2C5RCV I2C5RCV
extern volatile unsigned int   I2C5RCV __attribute__((section("sfrs")));
typedef struct {
  unsigned I2CRCV:8;
} __I2C5RCVbits_t;
extern volatile __I2C5RCVbits_t I2C5RCVbits __asm__ ("I2C5RCV") __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5RCVCLR __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5RCVSET __attribute__((section("sfrs")));
extern volatile unsigned int        I2C5RCVINV __attribute__((section("sfrs")));
#define SPI1CON SPI1CON
extern volatile unsigned int   SPI1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI1CONbits_t;
extern volatile __SPI1CONbits_t SPI1CONbits __asm__ ("SPI1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CONINV __attribute__((section("sfrs")));
#define SPI1STAT SPI1STAT
extern volatile unsigned int   SPI1STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI1STATbits_t;
extern volatile __SPI1STATbits_t SPI1STATbits __asm__ ("SPI1STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1STATINV __attribute__((section("sfrs")));
#define SPI1BUF SPI1BUF
extern volatile unsigned int   SPI1BUF __attribute__((section("sfrs")));
#define SPI1BRG SPI1BRG
extern volatile unsigned int   SPI1BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1BRGINV __attribute__((section("sfrs")));
#define SPI1CON2 SPI1CON2
extern volatile unsigned int   SPI1CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI1CON2bits_t;
extern volatile __SPI1CON2bits_t SPI1CON2bits __asm__ ("SPI1CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI1CON2INV __attribute__((section("sfrs")));
#define SPI2CON SPI2CON
extern volatile unsigned int   SPI2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI2CONbits_t;
extern volatile __SPI2CONbits_t SPI2CONbits __asm__ ("SPI2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CONINV __attribute__((section("sfrs")));
#define SPI2STAT SPI2STAT
extern volatile unsigned int   SPI2STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI2STATbits_t;
extern volatile __SPI2STATbits_t SPI2STATbits __asm__ ("SPI2STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2STATINV __attribute__((section("sfrs")));
#define SPI2BUF SPI2BUF
extern volatile unsigned int   SPI2BUF __attribute__((section("sfrs")));
#define SPI2BRG SPI2BRG
extern volatile unsigned int   SPI2BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2BRGINV __attribute__((section("sfrs")));
#define SPI2CON2 SPI2CON2
extern volatile unsigned int   SPI2CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI2CON2bits_t;
extern volatile __SPI2CON2bits_t SPI2CON2bits __asm__ ("SPI2CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI2CON2INV __attribute__((section("sfrs")));
#define SPI3CON SPI3CON
extern volatile unsigned int   SPI3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI3CONbits_t;
extern volatile __SPI3CONbits_t SPI3CONbits __asm__ ("SPI3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CONINV __attribute__((section("sfrs")));
#define SPI3STAT SPI3STAT
extern volatile unsigned int   SPI3STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI3STATbits_t;
extern volatile __SPI3STATbits_t SPI3STATbits __asm__ ("SPI3STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3STATINV __attribute__((section("sfrs")));
#define SPI3BUF SPI3BUF
extern volatile unsigned int   SPI3BUF __attribute__((section("sfrs")));
#define SPI3BRG SPI3BRG
extern volatile unsigned int   SPI3BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3BRGINV __attribute__((section("sfrs")));
#define SPI3CON2 SPI3CON2
extern volatile unsigned int   SPI3CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI3CON2bits_t;
extern volatile __SPI3CON2bits_t SPI3CON2bits __asm__ ("SPI3CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI3CON2INV __attribute__((section("sfrs")));
#define SPI4CON SPI4CON
extern volatile unsigned int   SPI4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI4CONbits_t;
extern volatile __SPI4CONbits_t SPI4CONbits __asm__ ("SPI4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CONINV __attribute__((section("sfrs")));
#define SPI4STAT SPI4STAT
extern volatile unsigned int   SPI4STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI4STATbits_t;
extern volatile __SPI4STATbits_t SPI4STATbits __asm__ ("SPI4STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4STATINV __attribute__((section("sfrs")));
#define SPI4BUF SPI4BUF
extern volatile unsigned int   SPI4BUF __attribute__((section("sfrs")));
#define SPI4BRG SPI4BRG
extern volatile unsigned int   SPI4BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4BRGINV __attribute__((section("sfrs")));
#define SPI4CON2 SPI4CON2
extern volatile unsigned int   SPI4CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI4CON2bits_t;
extern volatile __SPI4CON2bits_t SPI4CON2bits __asm__ ("SPI4CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI4CON2INV __attribute__((section("sfrs")));
#define SPI5CON SPI5CON
extern volatile unsigned int   SPI5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI5CONbits_t;
extern volatile __SPI5CONbits_t SPI5CONbits __asm__ ("SPI5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CONINV __attribute__((section("sfrs")));
#define SPI5STAT SPI5STAT
extern volatile unsigned int   SPI5STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI5STATbits_t;
extern volatile __SPI5STATbits_t SPI5STATbits __asm__ ("SPI5STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5STATINV __attribute__((section("sfrs")));
#define SPI5BUF SPI5BUF
extern volatile unsigned int   SPI5BUF __attribute__((section("sfrs")));
#define SPI5BRG SPI5BRG
extern volatile unsigned int   SPI5BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5BRGINV __attribute__((section("sfrs")));
#define SPI5CON2 SPI5CON2
extern volatile unsigned int   SPI5CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI5CON2bits_t;
extern volatile __SPI5CON2bits_t SPI5CON2bits __asm__ ("SPI5CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI5CON2INV __attribute__((section("sfrs")));
#define SPI6CON SPI6CON
extern volatile unsigned int   SPI6CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SRXISEL:2;
    unsigned STXISEL:2;
    unsigned DISSDI:1;
    unsigned MSTEN:1;
    unsigned CKP:1;
    unsigned SSEN:1;
    unsigned CKE:1;
    unsigned SMP:1;
    unsigned MODE16:1;
    unsigned MODE32:1;
    unsigned DISSDO:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned ENHBUF:1;
    unsigned SPIFE:1;
    unsigned :5;
    unsigned MCLKSEL:1;
    unsigned FRMCNT:3;
    unsigned FRMSYPW:1;
    unsigned MSSEN:1;
    unsigned FRMPOL:1;
    unsigned FRMSYNC:1;
    unsigned FRMEN:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI6CONbits_t;
extern volatile __SPI6CONbits_t SPI6CONbits __asm__ ("SPI6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CONINV __attribute__((section("sfrs")));
#define SPI6STAT SPI6STAT
extern volatile unsigned int   SPI6STAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SPIRBF:1;
    unsigned SPITBF:1;
    unsigned :1;
    unsigned SPITBE:1;
    unsigned :1;
    unsigned SPIRBE:1;
    unsigned SPIROV:1;
    unsigned SRMT:1;
    unsigned SPITUR:1;
    unsigned :2;
    unsigned SPIBUSY:1;
    unsigned FRMERR:1;
    unsigned :3;
    unsigned TXBUFELM:5;
    unsigned :3;
    unsigned RXBUFELM:5;
  };
  struct {
    unsigned w:32;
  };
} __SPI6STATbits_t;
extern volatile __SPI6STATbits_t SPI6STATbits __asm__ ("SPI6STAT") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6STATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6STATSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6STATINV __attribute__((section("sfrs")));
#define SPI6BUF SPI6BUF
extern volatile unsigned int   SPI6BUF __attribute__((section("sfrs")));
#define SPI6BRG SPI6BRG
extern volatile unsigned int   SPI6BRG __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6BRGINV __attribute__((section("sfrs")));
#define SPI6CON2 SPI6CON2
extern volatile unsigned int   SPI6CON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned AUDMOD:2;
    unsigned :1;
    unsigned AUDMONO:1;
    unsigned :3;
    unsigned AUDEN:1;
    unsigned IGNTUR:1;
    unsigned IGNROV:1;
    unsigned SPITUREN:1;
    unsigned SPIROVEN:1;
    unsigned FRMERREN:1;
    unsigned :2;
    unsigned SPISGNEXT:1;
  };
  struct {
    unsigned AUDMOD0:1;
    unsigned AUDMOD1:1;
  };
  struct {
    unsigned w:32;
  };
} __SPI6CON2bits_t;
extern volatile __SPI6CON2bits_t SPI6CON2bits __asm__ ("SPI6CON2") __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        SPI6CON2INV __attribute__((section("sfrs")));
#define U1MODE U1MODE
extern volatile unsigned int   U1MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U1MODEbits_t;
extern volatile __U1MODEbits_t U1MODEbits __asm__ ("U1MODE") __attribute__((section("sfrs")));
#define UABMODE UABMODE
extern volatile unsigned int   UABMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UABMODEbits_t;
extern volatile __UABMODEbits_t UABMODEbits __asm__ ("UABMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U1MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UABMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U1MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UABMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U1MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UABMODEINV __attribute__((section("sfrs")));
#define U1STA U1STA
extern volatile unsigned int   U1STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U1STAbits_t;
extern volatile __U1STAbits_t U1STAbits __asm__ ("U1STA") __attribute__((section("sfrs")));
#define UABSTA UABSTA
extern volatile unsigned int   UABSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UABSTAbits_t;
extern volatile __UABSTAbits_t UABSTAbits __asm__ ("UABSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U1STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UABSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U1STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UABSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U1STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UABSTAINV __attribute__((section("sfrs")));
#define U1TXREG U1TXREG
extern volatile unsigned int   U1TXREG __attribute__((section("sfrs")));
#define UABTXREG UABTXREG
extern volatile unsigned int   UABTXREG __attribute__((section("sfrs")));
#define U1RXREG U1RXREG
extern volatile unsigned int   U1RXREG __attribute__((section("sfrs")));
#define UABRXREG UABRXREG
extern volatile unsigned int   UABRXREG __attribute__((section("sfrs")));
#define U1BRG U1BRG
extern volatile unsigned int   U1BRG __attribute__((section("sfrs")));
#define UABBRG UABBRG
extern volatile unsigned int   UABBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U1BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UABBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U1BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UABBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U1BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UABBRGINV __attribute__((section("sfrs")));
#define U2MODE U2MODE
extern volatile unsigned int   U2MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U2MODEbits_t;
extern volatile __U2MODEbits_t U2MODEbits __asm__ ("U2MODE") __attribute__((section("sfrs")));
#define UCDMODE UCDMODE
extern volatile unsigned int   UCDMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UCDMODEbits_t;
extern volatile __UCDMODEbits_t UCDMODEbits __asm__ ("UCDMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U2MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UCDMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U2MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UCDMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U2MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UCDMODEINV __attribute__((section("sfrs")));
#define U2STA U2STA
extern volatile unsigned int   U2STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U2STAbits_t;
extern volatile __U2STAbits_t U2STAbits __asm__ ("U2STA") __attribute__((section("sfrs")));
#define UCDSTA UCDSTA
extern volatile unsigned int   UCDSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UCDSTAbits_t;
extern volatile __UCDSTAbits_t UCDSTAbits __asm__ ("UCDSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U2STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UCDSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U2STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UCDSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U2STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UCDSTAINV __attribute__((section("sfrs")));
#define U2TXREG U2TXREG
extern volatile unsigned int   U2TXREG __attribute__((section("sfrs")));
#define UCDTXREG UCDTXREG
extern volatile unsigned int   UCDTXREG __attribute__((section("sfrs")));
#define U2RXREG U2RXREG
extern volatile unsigned int   U2RXREG __attribute__((section("sfrs")));
#define UCDRXREG UCDRXREG
extern volatile unsigned int   UCDRXREG __attribute__((section("sfrs")));
#define U2BRG U2BRG
extern volatile unsigned int   U2BRG __attribute__((section("sfrs")));
#define UCDBRG UCDBRG
extern volatile unsigned int   UCDBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U2BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UCDBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U2BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UCDBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U2BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UCDBRGINV __attribute__((section("sfrs")));
#define U3MODE U3MODE
extern volatile unsigned int   U3MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U3MODEbits_t;
extern volatile __U3MODEbits_t U3MODEbits __asm__ ("U3MODE") __attribute__((section("sfrs")));
#define UEFMODE UEFMODE
extern volatile unsigned int   UEFMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UEFMODEbits_t;
extern volatile __UEFMODEbits_t UEFMODEbits __asm__ ("UEFMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U3MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UEFMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U3MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UEFMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U3MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UEFMODEINV __attribute__((section("sfrs")));
#define U3STA U3STA
extern volatile unsigned int   U3STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U3STAbits_t;
extern volatile __U3STAbits_t U3STAbits __asm__ ("U3STA") __attribute__((section("sfrs")));
#define UEFSTA UEFSTA
extern volatile unsigned int   UEFSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UEFSTAbits_t;
extern volatile __UEFSTAbits_t UEFSTAbits __asm__ ("UEFSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U3STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UEFSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U3STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UEFSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U3STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UEFSTAINV __attribute__((section("sfrs")));
#define U3TXREG U3TXREG
extern volatile unsigned int   U3TXREG __attribute__((section("sfrs")));
#define UEFTXREG UEFTXREG
extern volatile unsigned int   UEFTXREG __attribute__((section("sfrs")));
#define U3RXREG U3RXREG
extern volatile unsigned int   U3RXREG __attribute__((section("sfrs")));
#define UEFRXREG UEFRXREG
extern volatile unsigned int   UEFRXREG __attribute__((section("sfrs")));
#define U3BRG U3BRG
extern volatile unsigned int   U3BRG __attribute__((section("sfrs")));
#define UEFBRG UEFBRG
extern volatile unsigned int   UEFBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U3BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UEFBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U3BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UEFBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U3BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UEFBRGINV __attribute__((section("sfrs")));
#define U4MODE U4MODE
extern volatile unsigned int   U4MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U4MODEbits_t;
extern volatile __U4MODEbits_t U4MODEbits __asm__ ("U4MODE") __attribute__((section("sfrs")));
#define UGHMODE UGHMODE
extern volatile unsigned int   UGHMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UGHMODEbits_t;
extern volatile __UGHMODEbits_t UGHMODEbits __asm__ ("UGHMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U4MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UGHMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U4MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UGHMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U4MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UGHMODEINV __attribute__((section("sfrs")));
#define U4STA U4STA
extern volatile unsigned int   U4STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U4STAbits_t;
extern volatile __U4STAbits_t U4STAbits __asm__ ("U4STA") __attribute__((section("sfrs")));
#define UGHSTA UGHSTA
extern volatile unsigned int   UGHSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UGHSTAbits_t;
extern volatile __UGHSTAbits_t UGHSTAbits __asm__ ("UGHSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U4STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UGHSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U4STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UGHSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U4STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UGHSTAINV __attribute__((section("sfrs")));
#define U4TXREG U4TXREG
extern volatile unsigned int   U4TXREG __attribute__((section("sfrs")));
#define UGHTXREG UGHTXREG
extern volatile unsigned int   UGHTXREG __attribute__((section("sfrs")));
#define U4RXREG U4RXREG
extern volatile unsigned int   U4RXREG __attribute__((section("sfrs")));
#define UGHRXREG UGHRXREG
extern volatile unsigned int   UGHRXREG __attribute__((section("sfrs")));
#define U4BRG U4BRG
extern volatile unsigned int   U4BRG __attribute__((section("sfrs")));
#define UGHBRG UGHBRG
extern volatile unsigned int   UGHBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U4BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UGHBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U4BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UGHBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U4BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UGHBRGINV __attribute__((section("sfrs")));
#define U5MODE U5MODE
extern volatile unsigned int   U5MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U5MODEbits_t;
extern volatile __U5MODEbits_t U5MODEbits __asm__ ("U5MODE") __attribute__((section("sfrs")));
#define UJKMODE UJKMODE
extern volatile unsigned int   UJKMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UJKMODEbits_t;
extern volatile __UJKMODEbits_t UJKMODEbits __asm__ ("UJKMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U5MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        UJKMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U5MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        UJKMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U5MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        UJKMODEINV __attribute__((section("sfrs")));
#define U5STA U5STA
extern volatile unsigned int   U5STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U5STAbits_t;
extern volatile __U5STAbits_t U5STAbits __asm__ ("U5STA") __attribute__((section("sfrs")));
#define UJKSTA UJKSTA
extern volatile unsigned int   UJKSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __UJKSTAbits_t;
extern volatile __UJKSTAbits_t UJKSTAbits __asm__ ("UJKSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U5STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        UJKSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U5STASET __attribute__((section("sfrs")));
extern volatile unsigned int        UJKSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U5STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        UJKSTAINV __attribute__((section("sfrs")));
#define U5TXREG U5TXREG
extern volatile unsigned int   U5TXREG __attribute__((section("sfrs")));
#define UJKTXREG UJKTXREG
extern volatile unsigned int   UJKTXREG __attribute__((section("sfrs")));
#define U5RXREG U5RXREG
extern volatile unsigned int   U5RXREG __attribute__((section("sfrs")));
#define UJKRXREG UJKRXREG
extern volatile unsigned int   UJKRXREG __attribute__((section("sfrs")));
#define U5BRG U5BRG
extern volatile unsigned int   U5BRG __attribute__((section("sfrs")));
#define UJKBRG UJKBRG
extern volatile unsigned int   UJKBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U5BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        UJKBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U5BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        UJKBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U5BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        UJKBRGINV __attribute__((section("sfrs")));
#define U6MODE U6MODE
extern volatile unsigned int   U6MODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __U6MODEbits_t;
extern volatile __U6MODEbits_t U6MODEbits __asm__ ("U6MODE") __attribute__((section("sfrs")));
#define ULMMODE ULMMODE
extern volatile unsigned int   ULMMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STSEL:1;
    unsigned PDSEL:2;
    unsigned BRGH:1;
    unsigned RXINV:1;
    unsigned ABAUD:1;
    unsigned LPBACK:1;
    unsigned WAKE:1;
    unsigned UEN:2;
    unsigned :1;
    unsigned RTSMD:1;
    unsigned IREN:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :1;
    unsigned PDSEL0:1;
    unsigned PDSEL1:1;
    unsigned :5;
    unsigned UEN0:1;
    unsigned UEN1:1;
  };
  struct {
    unsigned :13;
    unsigned USIDL:1;
    unsigned :1;
    unsigned UARTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ULMMODEbits_t;
extern volatile __ULMMODEbits_t ULMMODEbits __asm__ ("ULMMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        U6MODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ULMMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        U6MODESET __attribute__((section("sfrs")));
extern volatile unsigned int        ULMMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        U6MODEINV __attribute__((section("sfrs")));
extern volatile unsigned int        ULMMODEINV __attribute__((section("sfrs")));
#define U6STA U6STA
extern volatile unsigned int   U6STA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __U6STAbits_t;
extern volatile __U6STAbits_t U6STAbits __asm__ ("U6STA") __attribute__((section("sfrs")));
#define ULMSTA ULMSTA
extern volatile unsigned int   ULMSTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned URXDA:1;
    unsigned OERR:1;
    unsigned FERR:1;
    unsigned PERR:1;
    unsigned RIDLE:1;
    unsigned ADDEN:1;
    unsigned URXISEL:2;
    unsigned TRMT:1;
    unsigned UTXBF:1;
    unsigned UTXEN:1;
    unsigned UTXBRK:1;
    unsigned URXEN:1;
    unsigned UTXINV:1;
    unsigned UTXISEL:2;
    unsigned ADDR:8;
    unsigned ADM_EN:1;
  };
  struct {
    unsigned :6;
    unsigned URXISEL0:1;
    unsigned URXISEL1:1;
    unsigned :6;
    unsigned UTXISEL0:1;
    unsigned UTXISEL1:1;
  };
  struct {
    unsigned :14;
    unsigned UTXSEL:2;
  };
  struct {
    unsigned w:32;
  };
} __ULMSTAbits_t;
extern volatile __ULMSTAbits_t ULMSTAbits __asm__ ("ULMSTA") __attribute__((section("sfrs")));
extern volatile unsigned int        U6STACLR __attribute__((section("sfrs")));
extern volatile unsigned int        ULMSTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        U6STASET __attribute__((section("sfrs")));
extern volatile unsigned int        ULMSTASET __attribute__((section("sfrs")));
extern volatile unsigned int        U6STAINV __attribute__((section("sfrs")));
extern volatile unsigned int        ULMSTAINV __attribute__((section("sfrs")));
#define U6TXREG U6TXREG
extern volatile unsigned int   U6TXREG __attribute__((section("sfrs")));
#define ULMTXREG ULMTXREG
extern volatile unsigned int   ULMTXREG __attribute__((section("sfrs")));
#define U6RXREG U6RXREG
extern volatile unsigned int   U6RXREG __attribute__((section("sfrs")));
#define ULMRXREG ULMRXREG
extern volatile unsigned int   ULMRXREG __attribute__((section("sfrs")));
#define U6BRG U6BRG
extern volatile unsigned int   U6BRG __attribute__((section("sfrs")));
#define ULMBRG ULMBRG
extern volatile unsigned int   ULMBRG __attribute__((section("sfrs")));
extern volatile unsigned int        U6BRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ULMBRGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        U6BRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        ULMBRGSET __attribute__((section("sfrs")));
extern volatile unsigned int        U6BRGINV __attribute__((section("sfrs")));
extern volatile unsigned int        ULMBRGINV __attribute__((section("sfrs")));
#define PMCON PMCON
extern volatile unsigned int   PMCON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RDSP:1;
    unsigned WRSP:1;
    unsigned :1;
    unsigned CS1P:1;
    unsigned CS2P:1;
    unsigned ALP:1;
    unsigned CSF:2;
    unsigned PTRDEN:1;
    unsigned PTWREN:1;
    unsigned PMPTTL:1;
    unsigned ADRMUX:2;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned :1;
    unsigned DUALBUF:1;
    unsigned :5;
    unsigned RDSTART:1;
  };
  struct {
    unsigned :6;
    unsigned CSF0:1;
    unsigned CSF1:1;
    unsigned :3;
    unsigned ADRMUX0:1;
    unsigned ADRMUX1:1;
  };
  struct {
    unsigned :13;
    unsigned PSIDL:1;
    unsigned :1;
    unsigned PMPEN:1;
  };
  struct {
    unsigned w:32;
  };
} __PMCONbits_t;
extern volatile __PMCONbits_t PMCONbits __asm__ ("PMCON") __attribute__((section("sfrs")));
extern volatile unsigned int        PMCONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMCONSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMCONINV __attribute__((section("sfrs")));
#define PMMODE PMMODE
extern volatile unsigned int   PMMODE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned WAITE:2;
    unsigned WAITM:4;
    unsigned WAITB:2;
    unsigned MODE:2;
    unsigned MODE16:1;
    unsigned INCM:2;
    unsigned IRQM:2;
    unsigned BUSY:1;
  };
  struct {
    unsigned WAITE0:1;
    unsigned WAITE1:1;
    unsigned WAITM0:1;
    unsigned WAITM1:1;
    unsigned WAITM2:1;
    unsigned WAITM3:1;
    unsigned WAITB0:1;
    unsigned WAITB1:1;
    unsigned MODE0:1;
    unsigned MODE1:1;
    unsigned :1;
    unsigned INCM0:1;
    unsigned INCM1:1;
    unsigned IRQM0:1;
    unsigned IRQM1:1;
  };
  struct {
    unsigned w:32;
  };
} __PMMODEbits_t;
extern volatile __PMMODEbits_t PMMODEbits __asm__ ("PMMODE") __attribute__((section("sfrs")));
extern volatile unsigned int        PMMODECLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMMODESET __attribute__((section("sfrs")));
extern volatile unsigned int        PMMODEINV __attribute__((section("sfrs")));
#define PMADDR PMADDR
extern volatile unsigned int   PMADDR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ADDR:14;
    unsigned ADDR14:1;
    unsigned ADDR15:1;
  };
  struct {
    unsigned :14;
    unsigned CS:2;
  };
  struct {
    unsigned :14;
    unsigned CS1:1;
    unsigned CS2:1;
  };
  struct {
    unsigned w:32;
  };
} __PMADDRbits_t;
extern volatile __PMADDRbits_t PMADDRbits __asm__ ("PMADDR") __attribute__((section("sfrs")));
extern volatile unsigned int        PMADDRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMADDRSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMADDRINV __attribute__((section("sfrs")));
#define PMDOUT PMDOUT
extern volatile unsigned int   PMDOUT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DATAOUT:32;
  };
  struct {
    unsigned w:32;
  };
} __PMDOUTbits_t;
extern volatile __PMDOUTbits_t PMDOUTbits __asm__ ("PMDOUT") __attribute__((section("sfrs")));
extern volatile unsigned int        PMDOUTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMDOUTSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMDOUTINV __attribute__((section("sfrs")));
#define PMDIN PMDIN
extern volatile unsigned int   PMDIN __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DATAIN:32;
  };
  struct {
    unsigned w:32;
  };
} __PMDINbits_t;
extern volatile __PMDINbits_t PMDINbits __asm__ ("PMDIN") __attribute__((section("sfrs")));
extern volatile unsigned int        PMDINCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMDINSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMDININV __attribute__((section("sfrs")));
#define PMAEN PMAEN
extern volatile unsigned int   PMAEN __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PTEN:24;
  };
  struct {
    unsigned w:32;
  };
} __PMAENbits_t;
extern volatile __PMAENbits_t PMAENbits __asm__ ("PMAEN") __attribute__((section("sfrs")));
extern volatile unsigned int        PMAENCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMAENSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMAENINV __attribute__((section("sfrs")));
#define PMSTAT PMSTAT
extern volatile unsigned int   PMSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OB0E:1;
    unsigned OB1E:1;
    unsigned OB2E:1;
    unsigned OB3E:1;
    unsigned :2;
    unsigned OBUF:1;
    unsigned OBE:1;
    unsigned IB0F:1;
    unsigned IB1F:1;
    unsigned IB2F:1;
    unsigned IB3F:1;
    unsigned :2;
    unsigned IBOV:1;
    unsigned IBF:1;
  };
  struct {
    unsigned w:32;
  };
} __PMSTATbits_t;
extern volatile __PMSTATbits_t PMSTATbits __asm__ ("PMSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        PMSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMSTATINV __attribute__((section("sfrs")));
#define PMWADDR PMWADDR
extern volatile unsigned int   PMWADDR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned WADDR:14;
    unsigned WADDR14:1;
    unsigned WADDR15:1;
  };
  struct {
    unsigned :14;
    unsigned WCS:2;
  };
  struct {
    unsigned :14;
    unsigned WCS1:1;
    unsigned WCS2:1;
  };
  struct {
    unsigned w:32;
  };
} __PMWADDRbits_t;
extern volatile __PMWADDRbits_t PMWADDRbits __asm__ ("PMWADDR") __attribute__((section("sfrs")));
extern volatile unsigned int        PMWADDRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMWADDRSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMWADDRINV __attribute__((section("sfrs")));
#define PMRADDR PMRADDR
extern volatile unsigned int   PMRADDR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RADDR:14;
    unsigned RADDR14:1;
    unsigned RADDR15:1;
  };
  struct {
    unsigned :14;
    unsigned RCS:2;
  };
  struct {
    unsigned :14;
    unsigned RCS1:1;
    unsigned RCS2:1;
  };
  struct {
    unsigned w:32;
  };
} __PMRADDRbits_t;
extern volatile __PMRADDRbits_t PMRADDRbits __asm__ ("PMRADDR") __attribute__((section("sfrs")));
extern volatile unsigned int        PMRADDRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMRADDRSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMRADDRINV __attribute__((section("sfrs")));
#define PMRDIN PMRDIN
extern volatile unsigned int   PMRDIN __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RDATAIN:32;
  };
  struct {
    unsigned w:32;
  };
} __PMRDINbits_t;
extern volatile __PMRDINbits_t PMRDINbits __asm__ ("PMRDIN") __attribute__((section("sfrs")));
extern volatile unsigned int        PMRDINCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PMRDINSET __attribute__((section("sfrs")));
extern volatile unsigned int        PMRDININV __attribute__((section("sfrs")));
#define T1CON T1CON
extern volatile unsigned int   T1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned TSYNC:1;
    unsigned :1;
    unsigned TCKPS:2;
    unsigned :1;
    unsigned TGATE:1;
    unsigned :3;
    unsigned TWIP:1;
    unsigned TWDIS:1;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T1CONbits_t;
extern volatile __T1CONbits_t T1CONbits __asm__ ("T1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T1CONINV __attribute__((section("sfrs")));
#define TMR1 TMR1
extern volatile unsigned int   TMR1 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR1SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR1INV __attribute__((section("sfrs")));
#define PR1 PR1
extern volatile unsigned int   PR1 __attribute__((section("sfrs")));
extern volatile unsigned int        PR1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR1SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR1INV __attribute__((section("sfrs")));
#define T2CON T2CON
extern volatile unsigned int   T2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :1;
    unsigned T32:1;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T2CONbits_t;
extern volatile __T2CONbits_t T2CONbits __asm__ ("T2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T2CONINV __attribute__((section("sfrs")));
#define TMR2 TMR2
extern volatile unsigned int   TMR2 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR2SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR2INV __attribute__((section("sfrs")));
#define PR2 PR2
extern volatile unsigned int   PR2 __attribute__((section("sfrs")));
extern volatile unsigned int        PR2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR2SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR2INV __attribute__((section("sfrs")));
#define T3CON T3CON
extern volatile unsigned int   T3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :2;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T3CONbits_t;
extern volatile __T3CONbits_t T3CONbits __asm__ ("T3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T3CONINV __attribute__((section("sfrs")));
#define TMR3 TMR3
extern volatile unsigned int   TMR3 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR3SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR3INV __attribute__((section("sfrs")));
#define PR3 PR3
extern volatile unsigned int   PR3 __attribute__((section("sfrs")));
extern volatile unsigned int        PR3CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR3SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR3INV __attribute__((section("sfrs")));
#define T4CON T4CON
extern volatile unsigned int   T4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :1;
    unsigned T32:1;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T4CONbits_t;
extern volatile __T4CONbits_t T4CONbits __asm__ ("T4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T4CONINV __attribute__((section("sfrs")));
#define TMR4 TMR4
extern volatile unsigned int   TMR4 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR4SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR4INV __attribute__((section("sfrs")));
#define PR4 PR4
extern volatile unsigned int   PR4 __attribute__((section("sfrs")));
extern volatile unsigned int        PR4CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR4SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR4INV __attribute__((section("sfrs")));
#define T5CON T5CON
extern volatile unsigned int   T5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :2;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T5CONbits_t;
extern volatile __T5CONbits_t T5CONbits __asm__ ("T5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T5CONINV __attribute__((section("sfrs")));
#define TMR5 TMR5
extern volatile unsigned int   TMR5 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR5SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR5INV __attribute__((section("sfrs")));
#define PR5 PR5
extern volatile unsigned int   PR5 __attribute__((section("sfrs")));
extern volatile unsigned int        PR5CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR5SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR5INV __attribute__((section("sfrs")));
#define T6CON T6CON
extern volatile unsigned int   T6CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :1;
    unsigned T32:1;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T6CONbits_t;
extern volatile __T6CONbits_t T6CONbits __asm__ ("T6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T6CONINV __attribute__((section("sfrs")));
#define TMR6 TMR6
extern volatile unsigned int   TMR6 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR6SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR6INV __attribute__((section("sfrs")));
#define PR6 PR6
extern volatile unsigned int   PR6 __attribute__((section("sfrs")));
extern volatile unsigned int        PR6CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR6SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR6INV __attribute__((section("sfrs")));
#define T7CON T7CON
extern volatile unsigned int   T7CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :2;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T7CONbits_t;
extern volatile __T7CONbits_t T7CONbits __asm__ ("T7CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T7CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T7CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T7CONINV __attribute__((section("sfrs")));
#define TMR7 TMR7
extern volatile unsigned int   TMR7 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR7SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR7INV __attribute__((section("sfrs")));
#define PR7 PR7
extern volatile unsigned int   PR7 __attribute__((section("sfrs")));
extern volatile unsigned int        PR7CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR7SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR7INV __attribute__((section("sfrs")));
#define T8CON T8CON
extern volatile unsigned int   T8CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :1;
    unsigned T32:1;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T8CONbits_t;
extern volatile __T8CONbits_t T8CONbits __asm__ ("T8CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T8CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T8CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T8CONINV __attribute__((section("sfrs")));
#define TMR8 TMR8
extern volatile unsigned int   TMR8 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR8SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR8INV __attribute__((section("sfrs")));
#define PR8 PR8
extern volatile unsigned int   PR8 __attribute__((section("sfrs")));
extern volatile unsigned int        PR8CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR8SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR8INV __attribute__((section("sfrs")));
#define T9CON T9CON
extern volatile unsigned int   T9CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TCS:1;
    unsigned :2;
    unsigned TCKPS:3;
    unsigned TGATE:1;
    unsigned :5;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned :4;
    unsigned TCKPS0:1;
    unsigned TCKPS1:1;
    unsigned TCKPS2:1;
  };
  struct {
    unsigned :13;
    unsigned TSIDL:1;
    unsigned :1;
    unsigned TON:1;
  };
  struct {
    unsigned w:32;
  };
} __T9CONbits_t;
extern volatile __T9CONbits_t T9CONbits __asm__ ("T9CON") __attribute__((section("sfrs")));
extern volatile unsigned int        T9CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        T9CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        T9CONINV __attribute__((section("sfrs")));
#define TMR9 TMR9
extern volatile unsigned int   TMR9 __attribute__((section("sfrs")));
extern volatile unsigned int        TMR9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        TMR9SET __attribute__((section("sfrs")));
extern volatile unsigned int        TMR9INV __attribute__((section("sfrs")));
#define PR9 PR9
extern volatile unsigned int   PR9 __attribute__((section("sfrs")));
extern volatile unsigned int        PR9CLR __attribute__((section("sfrs")));
extern volatile unsigned int        PR9SET __attribute__((section("sfrs")));
extern volatile unsigned int        PR9INV __attribute__((section("sfrs")));
#define IC1CON IC1CON
extern volatile unsigned int   IC1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC1CONbits_t;
extern volatile __IC1CONbits_t IC1CONbits __asm__ ("IC1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC1CONINV __attribute__((section("sfrs")));
#define IC1BUF IC1BUF
extern volatile unsigned int   IC1BUF __attribute__((section("sfrs")));
#define IC2CON IC2CON
extern volatile unsigned int   IC2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC2CONbits_t;
extern volatile __IC2CONbits_t IC2CONbits __asm__ ("IC2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC2CONINV __attribute__((section("sfrs")));
#define IC2BUF IC2BUF
extern volatile unsigned int   IC2BUF __attribute__((section("sfrs")));
#define IC3CON IC3CON
extern volatile unsigned int   IC3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC3CONbits_t;
extern volatile __IC3CONbits_t IC3CONbits __asm__ ("IC3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC3CONINV __attribute__((section("sfrs")));
#define IC3BUF IC3BUF
extern volatile unsigned int   IC3BUF __attribute__((section("sfrs")));
#define IC4CON IC4CON
extern volatile unsigned int   IC4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC4CONbits_t;
extern volatile __IC4CONbits_t IC4CONbits __asm__ ("IC4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC4CONINV __attribute__((section("sfrs")));
#define IC4BUF IC4BUF
extern volatile unsigned int   IC4BUF __attribute__((section("sfrs")));
#define IC5CON IC5CON
extern volatile unsigned int   IC5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC5CONbits_t;
extern volatile __IC5CONbits_t IC5CONbits __asm__ ("IC5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC5CONINV __attribute__((section("sfrs")));
#define IC5BUF IC5BUF
extern volatile unsigned int   IC5BUF __attribute__((section("sfrs")));
#define IC6CON IC6CON
extern volatile unsigned int   IC6CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC6CONbits_t;
extern volatile __IC6CONbits_t IC6CONbits __asm__ ("IC6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC6CONINV __attribute__((section("sfrs")));
#define IC6BUF IC6BUF
extern volatile unsigned int   IC6BUF __attribute__((section("sfrs")));
#define IC7CON IC7CON
extern volatile unsigned int   IC7CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC7CONbits_t;
extern volatile __IC7CONbits_t IC7CONbits __asm__ ("IC7CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC7CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC7CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC7CONINV __attribute__((section("sfrs")));
#define IC7BUF IC7BUF
extern volatile unsigned int   IC7BUF __attribute__((section("sfrs")));
#define IC8CON IC8CON
extern volatile unsigned int   IC8CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC8CONbits_t;
extern volatile __IC8CONbits_t IC8CONbits __asm__ ("IC8CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC8CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC8CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC8CONINV __attribute__((section("sfrs")));
#define IC8BUF IC8BUF
extern volatile unsigned int   IC8BUF __attribute__((section("sfrs")));
#define IC9CON IC9CON
extern volatile unsigned int   IC9CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ICM:3;
    unsigned ICBNE:1;
    unsigned ICOV:1;
    unsigned ICI:2;
    unsigned ICTMR:1;
    unsigned C32:1;
    unsigned FEDGE:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned ICM0:1;
    unsigned ICM1:1;
    unsigned ICM2:1;
    unsigned :2;
    unsigned ICI0:1;
    unsigned ICI1:1;
  };
  struct {
    unsigned :13;
    unsigned ICSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __IC9CONbits_t;
extern volatile __IC9CONbits_t IC9CONbits __asm__ ("IC9CON") __attribute__((section("sfrs")));
extern volatile unsigned int        IC9CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        IC9CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        IC9CONINV __attribute__((section("sfrs")));
#define IC9BUF IC9BUF
extern volatile unsigned int   IC9BUF __attribute__((section("sfrs")));
#define OC1CON OC1CON
extern volatile unsigned int   OC1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC1CONbits_t;
extern volatile __OC1CONbits_t OC1CONbits __asm__ ("OC1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC1CONINV __attribute__((section("sfrs")));
#define OC1R OC1R
extern volatile unsigned int   OC1R __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RINV __attribute__((section("sfrs")));
#define OC1RS OC1RS
extern volatile unsigned int   OC1RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC1RSINV __attribute__((section("sfrs")));
#define OC2CON OC2CON
extern volatile unsigned int   OC2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC2CONbits_t;
extern volatile __OC2CONbits_t OC2CONbits __asm__ ("OC2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC2CONINV __attribute__((section("sfrs")));
#define OC2R OC2R
extern volatile unsigned int   OC2R __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RINV __attribute__((section("sfrs")));
#define OC2RS OC2RS
extern volatile unsigned int   OC2RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC2RSINV __attribute__((section("sfrs")));
#define OC3CON OC3CON
extern volatile unsigned int   OC3CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC3CONbits_t;
extern volatile __OC3CONbits_t OC3CONbits __asm__ ("OC3CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC3CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC3CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC3CONINV __attribute__((section("sfrs")));
#define OC3R OC3R
extern volatile unsigned int   OC3R __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RINV __attribute__((section("sfrs")));
#define OC3RS OC3RS
extern volatile unsigned int   OC3RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC3RSINV __attribute__((section("sfrs")));
#define OC4CON OC4CON
extern volatile unsigned int   OC4CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC4CONbits_t;
extern volatile __OC4CONbits_t OC4CONbits __asm__ ("OC4CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC4CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC4CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC4CONINV __attribute__((section("sfrs")));
#define OC4R OC4R
extern volatile unsigned int   OC4R __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RINV __attribute__((section("sfrs")));
#define OC4RS OC4RS
extern volatile unsigned int   OC4RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC4RSINV __attribute__((section("sfrs")));
#define OC5CON OC5CON
extern volatile unsigned int   OC5CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC5CONbits_t;
extern volatile __OC5CONbits_t OC5CONbits __asm__ ("OC5CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC5CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC5CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC5CONINV __attribute__((section("sfrs")));
#define OC5R OC5R
extern volatile unsigned int   OC5R __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RINV __attribute__((section("sfrs")));
#define OC5RS OC5RS
extern volatile unsigned int   OC5RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC5RSINV __attribute__((section("sfrs")));
#define OC6CON OC6CON
extern volatile unsigned int   OC6CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC6CONbits_t;
extern volatile __OC6CONbits_t OC6CONbits __asm__ ("OC6CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC6CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC6CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC6CONINV __attribute__((section("sfrs")));
#define OC6R OC6R
extern volatile unsigned int   OC6R __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RINV __attribute__((section("sfrs")));
#define OC6RS OC6RS
extern volatile unsigned int   OC6RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC6RSINV __attribute__((section("sfrs")));
#define OC7CON OC7CON
extern volatile unsigned int   OC7CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC7CONbits_t;
extern volatile __OC7CONbits_t OC7CONbits __asm__ ("OC7CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC7CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC7CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC7CONINV __attribute__((section("sfrs")));
#define OC7R OC7R
extern volatile unsigned int   OC7R __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RINV __attribute__((section("sfrs")));
#define OC7RS OC7RS
extern volatile unsigned int   OC7RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC7RSINV __attribute__((section("sfrs")));
#define OC8CON OC8CON
extern volatile unsigned int   OC8CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC8CONbits_t;
extern volatile __OC8CONbits_t OC8CONbits __asm__ ("OC8CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC8CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC8CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC8CONINV __attribute__((section("sfrs")));
#define OC8R OC8R
extern volatile unsigned int   OC8R __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RINV __attribute__((section("sfrs")));
#define OC8RS OC8RS
extern volatile unsigned int   OC8RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC8RSINV __attribute__((section("sfrs")));
#define OC9CON OC9CON
extern volatile unsigned int   OC9CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned OCM:3;
    unsigned OCTSEL:1;
    unsigned OCFLT:1;
    unsigned OC32:1;
    unsigned :7;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
  };
  struct {
    unsigned OCM0:1;
    unsigned OCM1:1;
    unsigned OCM2:1;
  };
  struct {
    unsigned :13;
    unsigned OCSIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __OC9CONbits_t;
extern volatile __OC9CONbits_t OC9CONbits __asm__ ("OC9CON") __attribute__((section("sfrs")));
extern volatile unsigned int        OC9CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC9CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC9CONINV __attribute__((section("sfrs")));
#define OC9R OC9R
extern volatile unsigned int   OC9R __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RINV __attribute__((section("sfrs")));
#define OC9RS OC9RS
extern volatile unsigned int   OC9RS __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RSSET __attribute__((section("sfrs")));
extern volatile unsigned int        OC9RSINV __attribute__((section("sfrs")));
#define ADCCON1 ADCCON1
extern volatile unsigned int   ADCCON1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned STRGLVL:1;
  unsigned IRQVS:3;
  unsigned :2;
  unsigned FSPBCLKEN:1;
  unsigned FSSCLKEN:1;
  unsigned CVDEN:1;
  unsigned AICPMPEN:1;
  unsigned SIDL:1;
  unsigned :1;
  unsigned ON:1;
  unsigned STRGSRC:5;
  unsigned SELRES:2;
  unsigned FRACT:1;
  unsigned TRBSLV:3;
  unsigned TRBMST:3;
  unsigned TRBERR:1;
  unsigned TRBEN:1;
} __ADCCON1bits_t;
extern volatile __ADCCON1bits_t ADCCON1bits __asm__ ("ADCCON1") __attribute__((section("sfrs")));
#define ADCCON2 ADCCON2
extern volatile unsigned int   ADCCON2 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCDIV:7;
  unsigned :1;
  unsigned ADCEIS:3;
  unsigned :1;
  unsigned ADCEIOVR:1;
  unsigned EOSIEN:1;
  unsigned REFFLTIEN:1;
  unsigned BGVRIEN:1;
  unsigned SAMC:10;
  unsigned CVDCPL:3;
  unsigned EOSRDY:1;
  unsigned REFFLT:1;
  unsigned BGVRRDY:1;
} __ADCCON2bits_t;
extern volatile __ADCCON2bits_t ADCCON2bits __asm__ ("ADCCON2") __attribute__((section("sfrs")));
#define ADCCON3 ADCCON3
extern volatile unsigned int   ADCCON3 __attribute__((section("sfrs")));
typedef struct {
  unsigned ADINSEL:6;
  unsigned GSWTRG:1;
  unsigned GLSWTRG:1;
  unsigned RQCNVRT:1;
  unsigned SAMP:1;
  unsigned UPDRDY:1;
  unsigned UPDIEN:1;
  unsigned TRGSUSP:1;
  unsigned VREFSEL:3;
  unsigned DIGEN0:1;
  unsigned DIGEN1:1;
  unsigned DIGEN2:1;
  unsigned DIGEN3:1;
  unsigned DIGEN4:1;
  unsigned :2;
  unsigned DIGEN7:1;
  unsigned CONCLKDIV:6;
  unsigned ADCSEL:2;
} __ADCCON3bits_t;
extern volatile __ADCCON3bits_t ADCCON3bits __asm__ ("ADCCON3") __attribute__((section("sfrs")));
#define ADCTRGMODE ADCTRGMODE
extern volatile unsigned int   ADCTRGMODE __attribute__((section("sfrs")));
typedef struct {
  unsigned SSAMPEN0:1;
  unsigned SSAMPEN1:1;
  unsigned SSAMPEN2:1;
  unsigned SSAMPEN3:1;
  unsigned SSAMPEN4:1;
  unsigned :3;
  unsigned STRGEN0:1;
  unsigned STRGEN1:1;
  unsigned STRGEN2:1;
  unsigned STRGEN3:1;
  unsigned STRGEN4:1;
  unsigned :3;
  unsigned SH0ALT:2;
  unsigned SH1ALT:2;
  unsigned SH2ALT:2;
  unsigned SH3ALT:2;
  unsigned SH4ALT:2;
} __ADCTRGMODEbits_t;
extern volatile __ADCTRGMODEbits_t ADCTRGMODEbits __asm__ ("ADCTRGMODE") __attribute__((section("sfrs")));
#define ADCIMCON1 ADCIMCON1
extern volatile unsigned int   ADCIMCON1 __attribute__((section("sfrs")));
typedef struct {
  unsigned SIGN0:1;
  unsigned DIFF0:1;
  unsigned SIGN1:1;
  unsigned DIFF1:1;
  unsigned SIGN2:1;
  unsigned DIFF2:1;
  unsigned SIGN3:1;
  unsigned DIFF3:1;
  unsigned SIGN4:1;
  unsigned DIFF4:1;
  unsigned SIGN5:1;
  unsigned DIFF5:1;
  unsigned SIGN6:1;
  unsigned DIFF6:1;
  unsigned SIGN7:1;
  unsigned DIFF7:1;
  unsigned SIGN8:1;
  unsigned DIFF8:1;
  unsigned SIGN9:1;
  unsigned DIFF9:1;
  unsigned SIGN10:1;
  unsigned DIFF10:1;
  unsigned SIGN11:1;
  unsigned DIFF11:1;
  unsigned SIGN12:1;
  unsigned DIFF12:1;
  unsigned SIGN13:1;
  unsigned DIFF13:1;
  unsigned SIGN14:1;
  unsigned DIFF14:1;
  unsigned SIGN15:1;
  unsigned DIFF15:1;
} __ADCIMCON1bits_t;
extern volatile __ADCIMCON1bits_t ADCIMCON1bits __asm__ ("ADCIMCON1") __attribute__((section("sfrs")));
#define ADCIMCON2 ADCIMCON2
extern volatile unsigned int   ADCIMCON2 __attribute__((section("sfrs")));
typedef struct {
  unsigned SIGN16:1;
  unsigned DIFF16:1;
  unsigned SIGN17:1;
  unsigned DIFF17:1;
  unsigned SIGN18:1;
  unsigned DIFF18:1;
  unsigned SIGN19:1;
  unsigned DIFF19:1;
  unsigned SIGN20:1;
  unsigned DIFF20:1;
  unsigned SIGN21:1;
  unsigned DIFF21:1;
  unsigned SIGN22:1;
  unsigned DIFF22:1;
  unsigned SIGN23:1;
  unsigned DIFF23:1;
  unsigned SIGN24:1;
  unsigned DIFF24:1;
  unsigned SIGN25:1;
  unsigned DIFF25:1;
  unsigned SIGN26:1;
  unsigned DIFF26:1;
  unsigned SIGN27:1;
  unsigned DIFF27:1;
  unsigned SIGN28:1;
  unsigned DIFF28:1;
  unsigned SIGN29:1;
  unsigned DIFF29:1;
  unsigned SIGN30:1;
  unsigned DIFF30:1;
  unsigned SIGN31:1;
  unsigned DIFF31:1;
} __ADCIMCON2bits_t;
extern volatile __ADCIMCON2bits_t ADCIMCON2bits __asm__ ("ADCIMCON2") __attribute__((section("sfrs")));
#define ADCIMCON3 ADCIMCON3
extern volatile unsigned int   ADCIMCON3 __attribute__((section("sfrs")));
typedef struct {
  unsigned SIGN32:1;
  unsigned DIFF32:1;
  unsigned SIGN33:1;
  unsigned DIFF33:1;
  unsigned SIGN34:1;
  unsigned DIFF34:1;
  unsigned SIGN35:1;
  unsigned DIFF35:1;
  unsigned SIGN36:1;
  unsigned DIFF36:1;
  unsigned SIGN37:1;
  unsigned DIFF37:1;
  unsigned SIGN38:1;
  unsigned DIFF38:1;
  unsigned SIGN39:1;
  unsigned DIFF39:1;
  unsigned SIGN40:1;
  unsigned DIFF40:1;
  unsigned SIGN41:1;
  unsigned DIFF41:1;
  unsigned SIGN42:1;
  unsigned DIFF42:1;
  unsigned SIGN43:1;
  unsigned DIFF43:1;
  unsigned SIGN44:1;
  unsigned DIFF44:1;
} __ADCIMCON3bits_t;
extern volatile __ADCIMCON3bits_t ADCIMCON3bits __asm__ ("ADCIMCON3") __attribute__((section("sfrs")));
#define ADCGIRQEN1 ADCGIRQEN1
extern volatile unsigned int   ADCGIRQEN1 __attribute__((section("sfrs")));
typedef struct {
  unsigned AGIEN0:1;
  unsigned AGIEN1:1;
  unsigned AGIEN2:1;
  unsigned AGIEN3:1;
  unsigned AGIEN4:1;
  unsigned AGIEN5:1;
  unsigned AGIEN6:1;
  unsigned AGIEN7:1;
  unsigned AGIEN8:1;
  unsigned AGIEN9:1;
  unsigned AGIEN10:1;
  unsigned AGIEN11:1;
  unsigned AGIEN12:1;
  unsigned AGIEN13:1;
  unsigned AGIEN14:1;
  unsigned AGIEN15:1;
  unsigned AGIEN16:1;
  unsigned AGIEN17:1;
  unsigned AGIEN18:1;
  unsigned AGIEN19:1;
  unsigned AGIEN20:1;
  unsigned AGIEN21:1;
  unsigned AGIEN22:1;
  unsigned AGIEN23:1;
  unsigned AGIEN24:1;
  unsigned AGIEN25:1;
  unsigned AGIEN26:1;
  unsigned AGIEN27:1;
  unsigned AGIEN28:1;
  unsigned AGIEN29:1;
  unsigned AGIEN30:1;
  unsigned AGIEN31:1;
} __ADCGIRQEN1bits_t;
extern volatile __ADCGIRQEN1bits_t ADCGIRQEN1bits __asm__ ("ADCGIRQEN1") __attribute__((section("sfrs")));
#define ADCGIRQEN2 ADCGIRQEN2
extern volatile unsigned int   ADCGIRQEN2 __attribute__((section("sfrs")));
typedef struct {
  unsigned AGIEN32:1;
  unsigned AGIEN33:1;
  unsigned AGIEN34:1;
  unsigned AGIEN35:1;
  unsigned AGIEN36:1;
  unsigned AGIEN37:1;
  unsigned AGIEN38:1;
  unsigned AGIEN39:1;
  unsigned AGIEN40:1;
  unsigned AGIEN41:1;
  unsigned AGIEN42:1;
  unsigned AGIEN43:1;
  unsigned AGIEN44:1;
} __ADCGIRQEN2bits_t;
extern volatile __ADCGIRQEN2bits_t ADCGIRQEN2bits __asm__ ("ADCGIRQEN2") __attribute__((section("sfrs")));
#define ADCCSS1 ADCCSS1
extern volatile unsigned int   ADCCSS1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CSS0:1;
  unsigned CSS1:1;
  unsigned CSS2:1;
  unsigned CSS3:1;
  unsigned CSS4:1;
  unsigned CSS5:1;
  unsigned CSS6:1;
  unsigned CSS7:1;
  unsigned CSS8:1;
  unsigned CSS9:1;
  unsigned CSS10:1;
  unsigned CSS11:1;
  unsigned CSS12:1;
  unsigned CSS13:1;
  unsigned CSS14:1;
  unsigned CSS15:1;
  unsigned CSS16:1;
  unsigned CSS17:1;
  unsigned CSS18:1;
  unsigned CSS19:1;
  unsigned CSS20:1;
  unsigned CSS21:1;
  unsigned CSS22:1;
  unsigned CSS23:1;
  unsigned CSS24:1;
  unsigned CSS25:1;
  unsigned CSS26:1;
  unsigned CSS27:1;
  unsigned CSS28:1;
  unsigned CSS29:1;
  unsigned CSS30:1;
  unsigned CSS31:1;
} __ADCCSS1bits_t;
extern volatile __ADCCSS1bits_t ADCCSS1bits __asm__ ("ADCCSS1") __attribute__((section("sfrs")));
#define ADCCSS2 ADCCSS2
extern volatile unsigned int   ADCCSS2 __attribute__((section("sfrs")));
typedef struct {
  unsigned CSS32:1;
  unsigned CSS33:1;
  unsigned CSS34:1;
  unsigned CSS35:1;
  unsigned CSS36:1;
  unsigned CSS37:1;
  unsigned CSS38:1;
  unsigned CSS39:1;
  unsigned CSS40:1;
  unsigned CSS41:1;
  unsigned CSS42:1;
  unsigned CSS43:1;
  unsigned CSS44:1;
} __ADCCSS2bits_t;
extern volatile __ADCCSS2bits_t ADCCSS2bits __asm__ ("ADCCSS2") __attribute__((section("sfrs")));
#define ADCDSTAT1 ADCDSTAT1
extern volatile unsigned int   ADCDSTAT1 __attribute__((section("sfrs")));
typedef struct {
  unsigned ARDY0:1;
  unsigned ARDY1:1;
  unsigned ARDY2:1;
  unsigned ARDY3:1;
  unsigned ARDY4:1;
  unsigned ARDY5:1;
  unsigned ARDY6:1;
  unsigned ARDY7:1;
  unsigned ARDY8:1;
  unsigned ARDY9:1;
  unsigned ARDY10:1;
  unsigned ARDY11:1;
  unsigned ARDY12:1;
  unsigned ARDY13:1;
  unsigned ARDY14:1;
  unsigned ARDY15:1;
  unsigned ARDY16:1;
  unsigned ARDY17:1;
  unsigned ARDY18:1;
  unsigned ARDY19:1;
  unsigned ARDY20:1;
  unsigned ARDY21:1;
  unsigned ARDY22:1;
  unsigned ARDY23:1;
  unsigned ARDY24:1;
  unsigned ARDY25:1;
  unsigned ARDY26:1;
  unsigned ARDY27:1;
  unsigned ARDY28:1;
  unsigned ARDY29:1;
  unsigned ARDY30:1;
  unsigned ARDY31:1;
} __ADCDSTAT1bits_t;
extern volatile __ADCDSTAT1bits_t ADCDSTAT1bits __asm__ ("ADCDSTAT1") __attribute__((section("sfrs")));
#define ADCDSTAT2 ADCDSTAT2
extern volatile unsigned int   ADCDSTAT2 __attribute__((section("sfrs")));
typedef struct {
  unsigned ARDY32:1;
  unsigned ARDY33:1;
  unsigned ARDY34:1;
  unsigned ARDY35:1;
  unsigned ARDY36:1;
  unsigned ARDY37:1;
  unsigned ARDY38:1;
  unsigned ARDY39:1;
  unsigned ARDY40:1;
  unsigned ARDY41:1;
  unsigned ARDY42:1;
  unsigned ARDY43:1;
  unsigned ARDY44:1;
} __ADCDSTAT2bits_t;
extern volatile __ADCDSTAT2bits_t ADCDSTAT2bits __asm__ ("ADCDSTAT2") __attribute__((section("sfrs")));
#define ADCCMPEN1 ADCCMPEN1
extern volatile unsigned int   ADCCMPEN1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __ADCCMPEN1bits_t;
extern volatile __ADCCMPEN1bits_t ADCCMPEN1bits __asm__ ("ADCCMPEN1") __attribute__((section("sfrs")));
#define ADCCMP1 ADCCMP1
extern volatile unsigned int   ADCCMP1 __attribute__((section("sfrs")));
typedef struct {
  unsigned DCMPLO:16;
  unsigned DCMPHI:16;
} __ADCCMP1bits_t;
extern volatile __ADCCMP1bits_t ADCCMP1bits __asm__ ("ADCCMP1") __attribute__((section("sfrs")));
#define ADCCMPEN2 ADCCMPEN2
extern volatile unsigned int   ADCCMPEN2 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __ADCCMPEN2bits_t;
extern volatile __ADCCMPEN2bits_t ADCCMPEN2bits __asm__ ("ADCCMPEN2") __attribute__((section("sfrs")));
#define ADCCMP2 ADCCMP2
extern volatile unsigned int   ADCCMP2 __attribute__((section("sfrs")));
typedef struct {
  unsigned DCMPLO:16;
  unsigned DCMPHI:16;
} __ADCCMP2bits_t;
extern volatile __ADCCMP2bits_t ADCCMP2bits __asm__ ("ADCCMP2") __attribute__((section("sfrs")));
#define ADCCMPEN3 ADCCMPEN3
extern volatile unsigned int   ADCCMPEN3 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __ADCCMPEN3bits_t;
extern volatile __ADCCMPEN3bits_t ADCCMPEN3bits __asm__ ("ADCCMPEN3") __attribute__((section("sfrs")));
#define ADCCMP3 ADCCMP3
extern volatile unsigned int   ADCCMP3 __attribute__((section("sfrs")));
typedef struct {
  unsigned DCMPLO:16;
  unsigned DCMPHI:16;
} __ADCCMP3bits_t;
extern volatile __ADCCMP3bits_t ADCCMP3bits __asm__ ("ADCCMP3") __attribute__((section("sfrs")));
#define ADCCMPEN4 ADCCMPEN4
extern volatile unsigned int   ADCCMPEN4 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __ADCCMPEN4bits_t;
extern volatile __ADCCMPEN4bits_t ADCCMPEN4bits __asm__ ("ADCCMPEN4") __attribute__((section("sfrs")));
#define ADCCMP4 ADCCMP4
extern volatile unsigned int   ADCCMP4 __attribute__((section("sfrs")));
typedef struct {
  unsigned DCMPLO:16;
  unsigned DCMPHI:16;
} __ADCCMP4bits_t;
extern volatile __ADCCMP4bits_t ADCCMP4bits __asm__ ("ADCCMP4") __attribute__((section("sfrs")));
#define ADCCMPEN5 ADCCMPEN5
extern volatile unsigned int   ADCCMPEN5 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __ADCCMPEN5bits_t;
extern volatile __ADCCMPEN5bits_t ADCCMPEN5bits __asm__ ("ADCCMPEN5") __attribute__((section("sfrs")));
#define ADCCMP5 ADCCMP5
extern volatile unsigned int   ADCCMP5 __attribute__((section("sfrs")));
typedef struct {
  unsigned DCMPLO:16;
  unsigned DCMPHI:16;
} __ADCCMP5bits_t;
extern volatile __ADCCMP5bits_t ADCCMP5bits __asm__ ("ADCCMP5") __attribute__((section("sfrs")));
#define ADCCMPEN6 ADCCMPEN6
extern volatile unsigned int   ADCCMPEN6 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMPE0:1;
  unsigned CMPE1:1;
  unsigned CMPE2:1;
  unsigned CMPE3:1;
  unsigned CMPE4:1;
  unsigned CMPE5:1;
  unsigned CMPE6:1;
  unsigned CMPE7:1;
  unsigned CMPE8:1;
  unsigned CMPE9:1;
  unsigned CMPE10:1;
  unsigned CMPE11:1;
  unsigned CMPE12:1;
  unsigned CMPE13:1;
  unsigned CMPE14:1;
  unsigned CMPE15:1;
  unsigned CMPE16:1;
  unsigned CMPE17:1;
  unsigned CMPE18:1;
  unsigned CMPE19:1;
  unsigned CMPE20:1;
  unsigned CMPE21:1;
  unsigned CMPE22:1;
  unsigned CMPE23:1;
  unsigned CMPE24:1;
  unsigned CMPE25:1;
  unsigned CMPE26:1;
  unsigned CMPE27:1;
  unsigned CMPE28:1;
  unsigned CMPE29:1;
  unsigned CMPE30:1;
  unsigned CMPE31:1;
} __ADCCMPEN6bits_t;
extern volatile __ADCCMPEN6bits_t ADCCMPEN6bits __asm__ ("ADCCMPEN6") __attribute__((section("sfrs")));
#define ADCCMP6 ADCCMP6
extern volatile unsigned int   ADCCMP6 __attribute__((section("sfrs")));
typedef struct {
  unsigned DCMPLO:16;
  unsigned DCMPHI:16;
} __ADCCMP6bits_t;
extern volatile __ADCCMP6bits_t ADCCMP6bits __asm__ ("ADCCMP6") __attribute__((section("sfrs")));
#define ADCFLTR1 ADCFLTR1
extern volatile unsigned int   ADCFLTR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:5;
  unsigned :3;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned DFMODE:1;
  unsigned DATA16EN:1;
  unsigned AFEN:1;
} __ADCFLTR1bits_t;
extern volatile __ADCFLTR1bits_t ADCFLTR1bits __asm__ ("ADCFLTR1") __attribute__((section("sfrs")));
#define ADCFLTR2 ADCFLTR2
extern volatile unsigned int   ADCFLTR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:5;
  unsigned :3;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned DFMODE:1;
  unsigned DATA16EN:1;
  unsigned AFEN:1;
} __ADCFLTR2bits_t;
extern volatile __ADCFLTR2bits_t ADCFLTR2bits __asm__ ("ADCFLTR2") __attribute__((section("sfrs")));
#define ADCFLTR3 ADCFLTR3
extern volatile unsigned int   ADCFLTR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:5;
  unsigned :3;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned DFMODE:1;
  unsigned DATA16EN:1;
  unsigned AFEN:1;
} __ADCFLTR3bits_t;
extern volatile __ADCFLTR3bits_t ADCFLTR3bits __asm__ ("ADCFLTR3") __attribute__((section("sfrs")));
#define ADCFLTR4 ADCFLTR4
extern volatile unsigned int   ADCFLTR4 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:5;
  unsigned :3;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned DFMODE:1;
  unsigned DATA16EN:1;
  unsigned AFEN:1;
} __ADCFLTR4bits_t;
extern volatile __ADCFLTR4bits_t ADCFLTR4bits __asm__ ("ADCFLTR4") __attribute__((section("sfrs")));
#define ADCFLTR5 ADCFLTR5
extern volatile unsigned int   ADCFLTR5 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:5;
  unsigned :3;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned DFMODE:1;
  unsigned DATA16EN:1;
  unsigned AFEN:1;
} __ADCFLTR5bits_t;
extern volatile __ADCFLTR5bits_t ADCFLTR5bits __asm__ ("ADCFLTR5") __attribute__((section("sfrs")));
#define ADCFLTR6 ADCFLTR6
extern volatile unsigned int   ADCFLTR6 __attribute__((section("sfrs")));
typedef struct {
  unsigned FLTRDATA:16;
  unsigned CHNLID:5;
  unsigned :3;
  unsigned AFRDY:1;
  unsigned AFGIEN:1;
  unsigned OVRSAM:3;
  unsigned DFMODE:1;
  unsigned DATA16EN:1;
  unsigned AFEN:1;
} __ADCFLTR6bits_t;
extern volatile __ADCFLTR6bits_t ADCFLTR6bits __asm__ ("ADCFLTR6") __attribute__((section("sfrs")));
#define ADCTRG1 ADCTRG1
extern volatile unsigned int   ADCTRG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRGSRC0:5;
  unsigned :3;
  unsigned TRGSRC1:5;
  unsigned :3;
  unsigned TRGSRC2:5;
  unsigned :3;
  unsigned TRGSRC3:5;
} __ADCTRG1bits_t;
extern volatile __ADCTRG1bits_t ADCTRG1bits __asm__ ("ADCTRG1") __attribute__((section("sfrs")));
#define ADCTRG2 ADCTRG2
extern volatile unsigned int   ADCTRG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRGSRC4:5;
  unsigned :3;
  unsigned TRGSRC5:5;
  unsigned :3;
  unsigned TRGSRC6:5;
  unsigned :3;
  unsigned TRGSRC7:5;
} __ADCTRG2bits_t;
extern volatile __ADCTRG2bits_t ADCTRG2bits __asm__ ("ADCTRG2") __attribute__((section("sfrs")));
#define ADCTRG3 ADCTRG3
extern volatile unsigned int   ADCTRG3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRGSRC8:5;
  unsigned :3;
  unsigned TRGSRC9:5;
  unsigned :3;
  unsigned TRGSRC10:5;
  unsigned :3;
  unsigned TRGSRC11:5;
} __ADCTRG3bits_t;
extern volatile __ADCTRG3bits_t ADCTRG3bits __asm__ ("ADCTRG3") __attribute__((section("sfrs")));
#define ADCCMPCON1 ADCCMPCON1
extern volatile unsigned int   ADCCMPCON1 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:6;
  unsigned :2;
  unsigned CVDDATA:16;
} __ADCCMPCON1bits_t;
extern volatile __ADCCMPCON1bits_t ADCCMPCON1bits __asm__ ("ADCCMPCON1") __attribute__((section("sfrs")));
#define ADCCMPCON2 ADCCMPCON2
extern volatile unsigned int   ADCCMPCON2 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __ADCCMPCON2bits_t;
extern volatile __ADCCMPCON2bits_t ADCCMPCON2bits __asm__ ("ADCCMPCON2") __attribute__((section("sfrs")));
#define ADCCMPCON3 ADCCMPCON3
extern volatile unsigned int   ADCCMPCON3 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __ADCCMPCON3bits_t;
extern volatile __ADCCMPCON3bits_t ADCCMPCON3bits __asm__ ("ADCCMPCON3") __attribute__((section("sfrs")));
#define ADCCMPCON4 ADCCMPCON4
extern volatile unsigned int   ADCCMPCON4 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __ADCCMPCON4bits_t;
extern volatile __ADCCMPCON4bits_t ADCCMPCON4bits __asm__ ("ADCCMPCON4") __attribute__((section("sfrs")));
#define ADCCMPCON5 ADCCMPCON5
extern volatile unsigned int   ADCCMPCON5 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __ADCCMPCON5bits_t;
extern volatile __ADCCMPCON5bits_t ADCCMPCON5bits __asm__ ("ADCCMPCON5") __attribute__((section("sfrs")));
#define ADCCMPCON6 ADCCMPCON6
extern volatile unsigned int   ADCCMPCON6 __attribute__((section("sfrs")));
typedef struct {
  unsigned IELOLO:1;
  unsigned IELOHI:1;
  unsigned IEHILO:1;
  unsigned IEHIHI:1;
  unsigned IEBTWN:1;
  unsigned DCMPED:1;
  unsigned DCMPGIEN:1;
  unsigned ENDCMP:1;
  unsigned AINID:5;
} __ADCCMPCON6bits_t;
extern volatile __ADCCMPCON6bits_t ADCCMPCON6bits __asm__ ("ADCCMPCON6") __attribute__((section("sfrs")));
#define ADCFSTAT ADCFSTAT
extern volatile unsigned int   ADCFSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCID:3;
  unsigned :4;
  unsigned FSIGN:1;
  unsigned FCNT:8;
  unsigned :5;
  unsigned FWROVERR:1;
  unsigned FRDY:1;
  unsigned FIEN:1;
  unsigned ADC0EN:1;
  unsigned ADC1EN:1;
  unsigned ADC2EN:1;
  unsigned ADC3EN:1;
  unsigned ADC4EN:1;
  unsigned :2;
  unsigned FEN:1;
} __ADCFSTATbits_t;
extern volatile __ADCFSTATbits_t ADCFSTATbits __asm__ ("ADCFSTAT") __attribute__((section("sfrs")));
#define ADCFIFO ADCFIFO
extern volatile unsigned int   ADCFIFO __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCFIFObits_t;
extern volatile __ADCFIFObits_t ADCFIFObits __asm__ ("ADCFIFO") __attribute__((section("sfrs")));
#define ADCBASE ADCBASE
extern volatile unsigned int   ADCBASE __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCBASE:16;
} __ADCBASEbits_t;
extern volatile __ADCBASEbits_t ADCBASEbits __asm__ ("ADCBASE") __attribute__((section("sfrs")));
#define ADCTRGSNS ADCTRGSNS
extern volatile unsigned int   ADCTRGSNS __attribute__((section("sfrs")));
typedef struct {
  unsigned LVL0:1;
  unsigned LVL1:1;
  unsigned LVL2:1;
  unsigned LVL3:1;
  unsigned LVL4:1;
  unsigned LVL5:1;
  unsigned LVL6:1;
  unsigned LVL7:1;
  unsigned LVL8:1;
  unsigned LVL9:1;
  unsigned LVL10:1;
  unsigned LVL11:1;
} __ADCTRGSNSbits_t;
extern volatile __ADCTRGSNSbits_t ADCTRGSNSbits __asm__ ("ADCTRGSNS") __attribute__((section("sfrs")));
#define ADC0TIME ADC0TIME
extern volatile unsigned int   ADC0TIME __attribute__((section("sfrs")));
typedef struct {
  unsigned SAMC:10;
  unsigned :6;
  unsigned ADCDIV:7;
  unsigned :1;
  unsigned SELRES:2;
  unsigned ADCEIS:3;
} __ADC0TIMEbits_t;
extern volatile __ADC0TIMEbits_t ADC0TIMEbits __asm__ ("ADC0TIME") __attribute__((section("sfrs")));
#define ADC1TIME ADC1TIME
extern volatile unsigned int   ADC1TIME __attribute__((section("sfrs")));
typedef struct {
  unsigned SAMC:10;
  unsigned :6;
  unsigned ADCDIV:7;
  unsigned :1;
  unsigned SELRES:2;
  unsigned ADCEIS:3;
} __ADC1TIMEbits_t;
extern volatile __ADC1TIMEbits_t ADC1TIMEbits __asm__ ("ADC1TIME") __attribute__((section("sfrs")));
#define ADC2TIME ADC2TIME
extern volatile unsigned int   ADC2TIME __attribute__((section("sfrs")));
typedef struct {
  unsigned SAMC:10;
  unsigned :6;
  unsigned ADCDIV:7;
  unsigned :1;
  unsigned SELRES:2;
  unsigned ADCEIS:3;
} __ADC2TIMEbits_t;
extern volatile __ADC2TIMEbits_t ADC2TIMEbits __asm__ ("ADC2TIME") __attribute__((section("sfrs")));
#define ADC3TIME ADC3TIME
extern volatile unsigned int   ADC3TIME __attribute__((section("sfrs")));
typedef struct {
  unsigned SAMC:10;
  unsigned :6;
  unsigned ADCDIV:7;
  unsigned :1;
  unsigned SELRES:2;
  unsigned ADCEIS:3;
} __ADC3TIMEbits_t;
extern volatile __ADC3TIMEbits_t ADC3TIMEbits __asm__ ("ADC3TIME") __attribute__((section("sfrs")));
#define ADC4TIME ADC4TIME
extern volatile unsigned int   ADC4TIME __attribute__((section("sfrs")));
typedef struct {
  unsigned SAMC:10;
  unsigned :6;
  unsigned ADCDIV:7;
  unsigned :1;
  unsigned SELRES:2;
  unsigned ADCEIS:3;
} __ADC4TIMEbits_t;
extern volatile __ADC4TIMEbits_t ADC4TIMEbits __asm__ ("ADC4TIME") __attribute__((section("sfrs")));
#define ADCEIEN1 ADCEIEN1
extern volatile unsigned int   ADCEIEN1 __attribute__((section("sfrs")));
typedef struct {
  unsigned EIEN0:1;
  unsigned EIEN1:1;
  unsigned EIEN2:1;
  unsigned EIEN3:1;
  unsigned EIEN4:1;
  unsigned EIEN5:1;
  unsigned EIEN6:1;
  unsigned EIEN7:1;
  unsigned EIEN8:1;
  unsigned EIEN9:1;
  unsigned EIEN10:1;
  unsigned EIEN11:1;
  unsigned EIEN12:1;
  unsigned EIEN13:1;
  unsigned EIEN14:1;
  unsigned EIEN15:1;
  unsigned EIEN16:1;
  unsigned EIEN17:1;
  unsigned EIEN18:1;
  unsigned EIEN19:1;
  unsigned EIEN20:1;
  unsigned EIEN21:1;
  unsigned EIEN22:1;
  unsigned EIEN23:1;
  unsigned EIEN24:1;
  unsigned EIEN25:1;
  unsigned EIEN26:1;
  unsigned EIEN27:1;
  unsigned EIEN28:1;
  unsigned EIEN29:1;
  unsigned EIEN30:1;
  unsigned EIEN31:1;
} __ADCEIEN1bits_t;
extern volatile __ADCEIEN1bits_t ADCEIEN1bits __asm__ ("ADCEIEN1") __attribute__((section("sfrs")));
#define ADCEIEN2 ADCEIEN2
extern volatile unsigned int   ADCEIEN2 __attribute__((section("sfrs")));
typedef struct {
  unsigned EIEN32:1;
  unsigned EIEN33:1;
  unsigned EIEN34:1;
  unsigned EIEN35:1;
  unsigned EIEN36:1;
  unsigned EIEN37:1;
  unsigned EIEN38:1;
  unsigned EIEN39:1;
  unsigned EIEN40:1;
  unsigned EIEN41:1;
  unsigned EIEN42:1;
  unsigned EIEN43:1;
  unsigned EIEN44:1;
} __ADCEIEN2bits_t;
extern volatile __ADCEIEN2bits_t ADCEIEN2bits __asm__ ("ADCEIEN2") __attribute__((section("sfrs")));
#define ADCEISTAT1 ADCEISTAT1
extern volatile unsigned int   ADCEISTAT1 __attribute__((section("sfrs")));
typedef struct {
  unsigned EIRDY0:1;
  unsigned EIRDY1:1;
  unsigned EIRDY2:1;
  unsigned EIRDY3:1;
  unsigned EIRDY4:1;
  unsigned EIRDY5:1;
  unsigned EIRDY6:1;
  unsigned EIRDY7:1;
  unsigned EIRDY8:1;
  unsigned EIRDY9:1;
  unsigned EIRDY10:1;
  unsigned EIRDY11:1;
  unsigned EIRDY12:1;
  unsigned EIRDY13:1;
  unsigned EIRDY14:1;
  unsigned EIRDY15:1;
  unsigned EIRDY16:1;
  unsigned EIRDY17:1;
  unsigned EIRDY18:1;
  unsigned EIRDY19:1;
  unsigned EIRDY20:1;
  unsigned EIRDY21:1;
  unsigned EIRDY22:1;
  unsigned EIRDY23:1;
  unsigned EIRDY24:1;
  unsigned EIRDY25:1;
  unsigned EIRDY26:1;
  unsigned EIRDY27:1;
  unsigned EIRDY28:1;
  unsigned EIRDY29:1;
  unsigned EIRDY30:1;
  unsigned EIRDY31:1;
} __ADCEISTAT1bits_t;
extern volatile __ADCEISTAT1bits_t ADCEISTAT1bits __asm__ ("ADCEISTAT1") __attribute__((section("sfrs")));
#define ADCEISTAT2 ADCEISTAT2
extern volatile unsigned int   ADCEISTAT2 __attribute__((section("sfrs")));
typedef struct {
  unsigned EIRDY32:1;
  unsigned EIRDY33:1;
  unsigned EIRDY34:1;
  unsigned EIRDY35:1;
  unsigned EIRDY36:1;
  unsigned EIRDY37:1;
  unsigned EIRDY38:1;
  unsigned EIRDY39:1;
  unsigned EIRDY40:1;
  unsigned EIRDY41:1;
  unsigned EIRDY42:1;
  unsigned EIRDY43:1;
  unsigned EIRDY44:1;
} __ADCEISTAT2bits_t;
extern volatile __ADCEISTAT2bits_t ADCEISTAT2bits __asm__ ("ADCEISTAT2") __attribute__((section("sfrs")));
#define ADCANCON ADCANCON
extern volatile unsigned int   ADCANCON __attribute__((section("sfrs")));
typedef struct {
  unsigned ANEN0:1;
  unsigned ANEN1:1;
  unsigned ANEN2:1;
  unsigned ANEN3:1;
  unsigned ANEN4:1;
  unsigned :2;
  unsigned ANEN7:1;
  unsigned WKRDY0:1;
  unsigned WKRDY1:1;
  unsigned WKRDY2:1;
  unsigned WKRDY3:1;
  unsigned WKRDY4:1;
  unsigned :2;
  unsigned WKRDY7:1;
  unsigned WKIEN0:1;
  unsigned WKIEN1:1;
  unsigned WKIEN2:1;
  unsigned WKIEN3:1;
  unsigned WKIEN4:1;
  unsigned :2;
  unsigned WKIEN7:1;
  unsigned WKUPCLKCNT:4;
} __ADCANCONbits_t;
extern volatile __ADCANCONbits_t ADCANCONbits __asm__ ("ADCANCON") __attribute__((section("sfrs")));
#define ADC0CFG ADC0CFG
extern volatile unsigned int   ADC0CFG __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCCFG:32;
} __ADC0CFGbits_t;
extern volatile __ADC0CFGbits_t ADC0CFGbits __asm__ ("ADC0CFG") __attribute__((section("sfrs")));
#define ADC1CFG ADC1CFG
extern volatile unsigned int   ADC1CFG __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCCFG:32;
} __ADC1CFGbits_t;
extern volatile __ADC1CFGbits_t ADC1CFGbits __asm__ ("ADC1CFG") __attribute__((section("sfrs")));
#define ADC2CFG ADC2CFG
extern volatile unsigned int   ADC2CFG __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCCFG:32;
} __ADC2CFGbits_t;
extern volatile __ADC2CFGbits_t ADC2CFGbits __asm__ ("ADC2CFG") __attribute__((section("sfrs")));
#define ADC3CFG ADC3CFG
extern volatile unsigned int   ADC3CFG __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCCFG:32;
} __ADC3CFGbits_t;
extern volatile __ADC3CFGbits_t ADC3CFGbits __asm__ ("ADC3CFG") __attribute__((section("sfrs")));
#define ADC4CFG ADC4CFG
extern volatile unsigned int   ADC4CFG __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCCFG:32;
} __ADC4CFGbits_t;
extern volatile __ADC4CFGbits_t ADC4CFGbits __asm__ ("ADC4CFG") __attribute__((section("sfrs")));
#define ADC7CFG ADC7CFG
extern volatile unsigned int   ADC7CFG __attribute__((section("sfrs")));
typedef struct {
  unsigned ADCCFG:32;
} __ADC7CFGbits_t;
extern volatile __ADC7CFGbits_t ADC7CFGbits __asm__ ("ADC7CFG") __attribute__((section("sfrs")));
#define ADCSYSCFG0 ADCSYSCFG0
extern volatile unsigned int   ADCSYSCFG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned AN0:1;
  unsigned AN1:1;
  unsigned AN2:1;
  unsigned AN3:1;
  unsigned AN4:1;
  unsigned AN5:1;
  unsigned AN6:1;
  unsigned AN7:1;
  unsigned AN8:1;
  unsigned AN9:1;
  unsigned AN10:1;
  unsigned AN11:1;
  unsigned AN12:1;
  unsigned AN13:1;
  unsigned AN14:1;
  unsigned AN15:1;
  unsigned AN16:1;
  unsigned AN17:1;
  unsigned AN18:1;
  unsigned AN19:1;
  unsigned AN20:1;
  unsigned AN21:1;
  unsigned AN22:1;
  unsigned AN23:1;
  unsigned AN24:1;
  unsigned AN25:1;
  unsigned AN26:1;
  unsigned AN27:1;
  unsigned AN28:1;
  unsigned AN29:1;
  unsigned AN30:1;
  unsigned AN31:1;
} __ADCSYSCFG0bits_t;
extern volatile __ADCSYSCFG0bits_t ADCSYSCFG0bits __asm__ ("ADCSYSCFG0") __attribute__((section("sfrs")));
#define ADCSYSCFG1 ADCSYSCFG1
extern volatile unsigned int   ADCSYSCFG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned AN32:1;
  unsigned AN33:1;
  unsigned AN34:1;
  unsigned AN35:1;
  unsigned AN36:1;
  unsigned AN37:1;
  unsigned AN38:1;
  unsigned AN39:1;
  unsigned AN40:1;
  unsigned AN41:1;
  unsigned AN42:1;
  unsigned AN43:1;
  unsigned AN44:1;
  unsigned AN45:1;
  unsigned AN46:1;
  unsigned AN47:1;
  unsigned AN48:1;
  unsigned AN49:1;
  unsigned AN50:1;
  unsigned AN51:1;
  unsigned AN52:1;
  unsigned AN53:1;
  unsigned AN54:1;
  unsigned AN55:1;
  unsigned AN56:1;
  unsigned AN57:1;
  unsigned AN58:1;
  unsigned AN59:1;
  unsigned AN60:1;
  unsigned AN61:1;
  unsigned AN62:1;
  unsigned AN63:1;
} __ADCSYSCFG1bits_t;
extern volatile __ADCSYSCFG1bits_t ADCSYSCFG1bits __asm__ ("ADCSYSCFG1") __attribute__((section("sfrs")));
#define ADCDATA0 ADCDATA0
extern volatile unsigned int   ADCDATA0 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA0bits_t;
extern volatile __ADCDATA0bits_t ADCDATA0bits __asm__ ("ADCDATA0") __attribute__((section("sfrs")));
#define ADCDATA1 ADCDATA1
extern volatile unsigned int   ADCDATA1 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA1bits_t;
extern volatile __ADCDATA1bits_t ADCDATA1bits __asm__ ("ADCDATA1") __attribute__((section("sfrs")));
#define ADCDATA2 ADCDATA2
extern volatile unsigned int   ADCDATA2 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA2bits_t;
extern volatile __ADCDATA2bits_t ADCDATA2bits __asm__ ("ADCDATA2") __attribute__((section("sfrs")));
#define ADCDATA3 ADCDATA3
extern volatile unsigned int   ADCDATA3 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA3bits_t;
extern volatile __ADCDATA3bits_t ADCDATA3bits __asm__ ("ADCDATA3") __attribute__((section("sfrs")));
#define ADCDATA4 ADCDATA4
extern volatile unsigned int   ADCDATA4 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA4bits_t;
extern volatile __ADCDATA4bits_t ADCDATA4bits __asm__ ("ADCDATA4") __attribute__((section("sfrs")));
#define ADCDATA5 ADCDATA5
extern volatile unsigned int   ADCDATA5 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA5bits_t;
extern volatile __ADCDATA5bits_t ADCDATA5bits __asm__ ("ADCDATA5") __attribute__((section("sfrs")));
#define ADCDATA6 ADCDATA6
extern volatile unsigned int   ADCDATA6 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA6bits_t;
extern volatile __ADCDATA6bits_t ADCDATA6bits __asm__ ("ADCDATA6") __attribute__((section("sfrs")));
#define ADCDATA7 ADCDATA7
extern volatile unsigned int   ADCDATA7 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA7bits_t;
extern volatile __ADCDATA7bits_t ADCDATA7bits __asm__ ("ADCDATA7") __attribute__((section("sfrs")));
#define ADCDATA8 ADCDATA8
extern volatile unsigned int   ADCDATA8 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA8bits_t;
extern volatile __ADCDATA8bits_t ADCDATA8bits __asm__ ("ADCDATA8") __attribute__((section("sfrs")));
#define ADCDATA9 ADCDATA9
extern volatile unsigned int   ADCDATA9 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA9bits_t;
extern volatile __ADCDATA9bits_t ADCDATA9bits __asm__ ("ADCDATA9") __attribute__((section("sfrs")));
#define ADCDATA10 ADCDATA10
extern volatile unsigned int   ADCDATA10 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA10bits_t;
extern volatile __ADCDATA10bits_t ADCDATA10bits __asm__ ("ADCDATA10") __attribute__((section("sfrs")));
#define ADCDATA11 ADCDATA11
extern volatile unsigned int   ADCDATA11 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA11bits_t;
extern volatile __ADCDATA11bits_t ADCDATA11bits __asm__ ("ADCDATA11") __attribute__((section("sfrs")));
#define ADCDATA12 ADCDATA12
extern volatile unsigned int   ADCDATA12 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA12bits_t;
extern volatile __ADCDATA12bits_t ADCDATA12bits __asm__ ("ADCDATA12") __attribute__((section("sfrs")));
#define ADCDATA13 ADCDATA13
extern volatile unsigned int   ADCDATA13 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA13bits_t;
extern volatile __ADCDATA13bits_t ADCDATA13bits __asm__ ("ADCDATA13") __attribute__((section("sfrs")));
#define ADCDATA14 ADCDATA14
extern volatile unsigned int   ADCDATA14 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA14bits_t;
extern volatile __ADCDATA14bits_t ADCDATA14bits __asm__ ("ADCDATA14") __attribute__((section("sfrs")));
#define ADCDATA15 ADCDATA15
extern volatile unsigned int   ADCDATA15 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA15bits_t;
extern volatile __ADCDATA15bits_t ADCDATA15bits __asm__ ("ADCDATA15") __attribute__((section("sfrs")));
#define ADCDATA16 ADCDATA16
extern volatile unsigned int   ADCDATA16 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA16bits_t;
extern volatile __ADCDATA16bits_t ADCDATA16bits __asm__ ("ADCDATA16") __attribute__((section("sfrs")));
#define ADCDATA17 ADCDATA17
extern volatile unsigned int   ADCDATA17 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA17bits_t;
extern volatile __ADCDATA17bits_t ADCDATA17bits __asm__ ("ADCDATA17") __attribute__((section("sfrs")));
#define ADCDATA18 ADCDATA18
extern volatile unsigned int   ADCDATA18 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA18bits_t;
extern volatile __ADCDATA18bits_t ADCDATA18bits __asm__ ("ADCDATA18") __attribute__((section("sfrs")));
#define ADCDATA19 ADCDATA19
extern volatile unsigned int   ADCDATA19 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA19bits_t;
extern volatile __ADCDATA19bits_t ADCDATA19bits __asm__ ("ADCDATA19") __attribute__((section("sfrs")));
#define ADCDATA20 ADCDATA20
extern volatile unsigned int   ADCDATA20 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA20bits_t;
extern volatile __ADCDATA20bits_t ADCDATA20bits __asm__ ("ADCDATA20") __attribute__((section("sfrs")));
#define ADCDATA21 ADCDATA21
extern volatile unsigned int   ADCDATA21 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA21bits_t;
extern volatile __ADCDATA21bits_t ADCDATA21bits __asm__ ("ADCDATA21") __attribute__((section("sfrs")));
#define ADCDATA22 ADCDATA22
extern volatile unsigned int   ADCDATA22 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA22bits_t;
extern volatile __ADCDATA22bits_t ADCDATA22bits __asm__ ("ADCDATA22") __attribute__((section("sfrs")));
#define ADCDATA23 ADCDATA23
extern volatile unsigned int   ADCDATA23 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA23bits_t;
extern volatile __ADCDATA23bits_t ADCDATA23bits __asm__ ("ADCDATA23") __attribute__((section("sfrs")));
#define ADCDATA24 ADCDATA24
extern volatile unsigned int   ADCDATA24 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA24bits_t;
extern volatile __ADCDATA24bits_t ADCDATA24bits __asm__ ("ADCDATA24") __attribute__((section("sfrs")));
#define ADCDATA25 ADCDATA25
extern volatile unsigned int   ADCDATA25 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA25bits_t;
extern volatile __ADCDATA25bits_t ADCDATA25bits __asm__ ("ADCDATA25") __attribute__((section("sfrs")));
#define ADCDATA26 ADCDATA26
extern volatile unsigned int   ADCDATA26 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA26bits_t;
extern volatile __ADCDATA26bits_t ADCDATA26bits __asm__ ("ADCDATA26") __attribute__((section("sfrs")));
#define ADCDATA27 ADCDATA27
extern volatile unsigned int   ADCDATA27 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA27bits_t;
extern volatile __ADCDATA27bits_t ADCDATA27bits __asm__ ("ADCDATA27") __attribute__((section("sfrs")));
#define ADCDATA28 ADCDATA28
extern volatile unsigned int   ADCDATA28 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA28bits_t;
extern volatile __ADCDATA28bits_t ADCDATA28bits __asm__ ("ADCDATA28") __attribute__((section("sfrs")));
#define ADCDATA29 ADCDATA29
extern volatile unsigned int   ADCDATA29 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA29bits_t;
extern volatile __ADCDATA29bits_t ADCDATA29bits __asm__ ("ADCDATA29") __attribute__((section("sfrs")));
#define ADCDATA30 ADCDATA30
extern volatile unsigned int   ADCDATA30 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA30bits_t;
extern volatile __ADCDATA30bits_t ADCDATA30bits __asm__ ("ADCDATA30") __attribute__((section("sfrs")));
#define ADCDATA31 ADCDATA31
extern volatile unsigned int   ADCDATA31 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA31bits_t;
extern volatile __ADCDATA31bits_t ADCDATA31bits __asm__ ("ADCDATA31") __attribute__((section("sfrs")));
#define ADCDATA32 ADCDATA32
extern volatile unsigned int   ADCDATA32 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA32bits_t;
extern volatile __ADCDATA32bits_t ADCDATA32bits __asm__ ("ADCDATA32") __attribute__((section("sfrs")));
#define ADCDATA33 ADCDATA33
extern volatile unsigned int   ADCDATA33 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA33bits_t;
extern volatile __ADCDATA33bits_t ADCDATA33bits __asm__ ("ADCDATA33") __attribute__((section("sfrs")));
#define ADCDATA34 ADCDATA34
extern volatile unsigned int   ADCDATA34 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA34bits_t;
extern volatile __ADCDATA34bits_t ADCDATA34bits __asm__ ("ADCDATA34") __attribute__((section("sfrs")));
#define ADCDATA43 ADCDATA43
extern volatile unsigned int   ADCDATA43 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA43bits_t;
extern volatile __ADCDATA43bits_t ADCDATA43bits __asm__ ("ADCDATA43") __attribute__((section("sfrs")));
#define ADCDATA44 ADCDATA44
extern volatile unsigned int   ADCDATA44 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __ADCDATA44bits_t;
extern volatile __ADCDATA44bits_t ADCDATA44bits __asm__ ("ADCDATA44") __attribute__((section("sfrs")));
#define CM1CON CM1CON
extern volatile unsigned int   CM1CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CCH:2;
    unsigned :2;
    unsigned CREF:1;
    unsigned :1;
    unsigned EVPOL:2;
    unsigned COUT:1;
    unsigned :4;
    unsigned CPOL:1;
    unsigned COE:1;
    unsigned ON:1;
  };
  struct {
    unsigned CCH0:1;
    unsigned CCH1:1;
    unsigned :4;
    unsigned EVPOL0:1;
    unsigned EVPOL1:1;
  };
  struct {
    unsigned w:32;
  };
} __CM1CONbits_t;
extern volatile __CM1CONbits_t CM1CONbits __asm__ ("CM1CON") __attribute__((section("sfrs")));
extern volatile unsigned int        CM1CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CM1CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        CM1CONINV __attribute__((section("sfrs")));
#define CM2CON CM2CON
extern volatile unsigned int   CM2CON __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CCH:2;
    unsigned :2;
    unsigned CREF:1;
    unsigned :1;
    unsigned EVPOL:2;
    unsigned COUT:1;
    unsigned :4;
    unsigned CPOL:1;
    unsigned COE:1;
    unsigned ON:1;
  };
  struct {
    unsigned CCH0:1;
    unsigned CCH1:1;
    unsigned :4;
    unsigned EVPOL0:1;
    unsigned EVPOL1:1;
  };
  struct {
    unsigned w:32;
  };
} __CM2CONbits_t;
extern volatile __CM2CONbits_t CM2CONbits __asm__ ("CM2CON") __attribute__((section("sfrs")));
extern volatile unsigned int        CM2CONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CM2CONSET __attribute__((section("sfrs")));
extern volatile unsigned int        CM2CONINV __attribute__((section("sfrs")));
#define CMSTAT CMSTAT
extern volatile unsigned int   CMSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned C1OUT:1;
    unsigned C2OUT:1;
    unsigned :11;
    unsigned SIDL:1;
  };
  struct {
    unsigned w:32;
  };
} __CMSTATbits_t;
extern volatile __CMSTATbits_t CMSTATbits __asm__ ("CMSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        CMSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CMSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        CMSTATINV __attribute__((section("sfrs")));
#define ANSELA ANSELA
extern volatile unsigned int   ANSELA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ANSA0:1;
    unsigned ANSA1:1;
    unsigned :3;
    unsigned ANSA5:1;
    unsigned :3;
    unsigned ANSA9:1;
    unsigned ANSA10:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELAbits_t;
extern volatile __ANSELAbits_t ANSELAbits __asm__ ("ANSELA") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELACLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELASET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELAINV __attribute__((section("sfrs")));
#define TRISA TRISA
extern volatile unsigned int   TRISA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISA0:1;
    unsigned TRISA1:1;
    unsigned TRISA2:1;
    unsigned TRISA3:1;
    unsigned TRISA4:1;
    unsigned TRISA5:1;
    unsigned TRISA6:1;
    unsigned TRISA7:1;
    unsigned :1;
    unsigned TRISA9:1;
    unsigned TRISA10:1;
    unsigned :3;
    unsigned TRISA14:1;
    unsigned TRISA15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISAbits_t;
extern volatile __TRISAbits_t TRISAbits __asm__ ("TRISA") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISACLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISASET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISAINV __attribute__((section("sfrs")));
#define PORTA PORTA
extern volatile unsigned int   PORTA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RA0:1;
    unsigned RA1:1;
    unsigned RA2:1;
    unsigned RA3:1;
    unsigned RA4:1;
    unsigned RA5:1;
    unsigned RA6:1;
    unsigned RA7:1;
    unsigned :1;
    unsigned RA9:1;
    unsigned RA10:1;
    unsigned :3;
    unsigned RA14:1;
    unsigned RA15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTAbits_t;
extern volatile __PORTAbits_t PORTAbits __asm__ ("PORTA") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTACLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTASET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTAINV __attribute__((section("sfrs")));
#define LATA LATA
extern volatile unsigned int   LATA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATA0:1;
    unsigned LATA1:1;
    unsigned LATA2:1;
    unsigned LATA3:1;
    unsigned LATA4:1;
    unsigned LATA5:1;
    unsigned LATA6:1;
    unsigned LATA7:1;
    unsigned :1;
    unsigned LATA9:1;
    unsigned LATA10:1;
    unsigned :3;
    unsigned LATA14:1;
    unsigned LATA15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATAbits_t;
extern volatile __LATAbits_t LATAbits __asm__ ("LATA") __attribute__((section("sfrs")));
extern volatile unsigned int        LATACLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATASET __attribute__((section("sfrs")));
extern volatile unsigned int        LATAINV __attribute__((section("sfrs")));
#define ODCA ODCA
extern volatile unsigned int   ODCA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCA0:1;
    unsigned ODCA1:1;
    unsigned ODCA2:1;
    unsigned ODCA3:1;
    unsigned ODCA4:1;
    unsigned ODCA5:1;
    unsigned ODCA6:1;
    unsigned ODCA7:1;
    unsigned :1;
    unsigned ODCA9:1;
    unsigned ODCA10:1;
    unsigned :3;
    unsigned ODCA14:1;
    unsigned ODCA15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCAbits_t;
extern volatile __ODCAbits_t ODCAbits __asm__ ("ODCA") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCACLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCASET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCAINV __attribute__((section("sfrs")));
#define CNPUA CNPUA
extern volatile unsigned int   CNPUA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUA0:1;
    unsigned CNPUA1:1;
    unsigned CNPUA2:1;
    unsigned CNPUA3:1;
    unsigned CNPUA4:1;
    unsigned CNPUA5:1;
    unsigned CNPUA6:1;
    unsigned CNPUA7:1;
    unsigned :1;
    unsigned CNPUA9:1;
    unsigned CNPUA10:1;
    unsigned :3;
    unsigned CNPUA14:1;
    unsigned CNPUA15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUAbits_t;
extern volatile __CNPUAbits_t CNPUAbits __asm__ ("CNPUA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUAINV __attribute__((section("sfrs")));
#define CNPDA CNPDA
extern volatile unsigned int   CNPDA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDA0:1;
    unsigned CNPDA1:1;
    unsigned CNPDA2:1;
    unsigned CNPDA3:1;
    unsigned CNPDA4:1;
    unsigned CNPDA5:1;
    unsigned CNPDA6:1;
    unsigned CNPDA7:1;
    unsigned :1;
    unsigned CNPDA9:1;
    unsigned CNPDA10:1;
    unsigned :3;
    unsigned CNPDA14:1;
    unsigned CNPDA15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDAbits_t;
extern volatile __CNPDAbits_t CNPDAbits __asm__ ("CNPDA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDAINV __attribute__((section("sfrs")));
#define CNCONA CNCONA
extern volatile unsigned int   CNCONA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :11;
    unsigned EDGEDETECT:1;
    unsigned :3;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONAbits_t;
extern volatile __CNCONAbits_t CNCONAbits __asm__ ("CNCONA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONAINV __attribute__((section("sfrs")));
#define CNENA CNENA
extern volatile unsigned int   CNENA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEA0:1;
    unsigned CNIEA1:1;
    unsigned CNIEA2:1;
    unsigned CNIEA3:1;
    unsigned CNIEA4:1;
    unsigned CNIEA5:1;
    unsigned CNIEA6:1;
    unsigned CNIEA7:1;
    unsigned :1;
    unsigned CNIEA9:1;
    unsigned CNIEA10:1;
    unsigned :3;
    unsigned CNIEA14:1;
    unsigned CNIEA15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENAbits_t;
extern volatile __CNENAbits_t CNENAbits __asm__ ("CNENA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENAINV __attribute__((section("sfrs")));
#define CNSTATA CNSTATA
extern volatile unsigned int   CNSTATA __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATA0:1;
    unsigned CNSTATA1:1;
    unsigned CNSTATA2:1;
    unsigned CNSTATA3:1;
    unsigned CNSTATA4:1;
    unsigned CNSTATA5:1;
    unsigned CNSTATA6:1;
    unsigned CNSTATA7:1;
    unsigned :1;
    unsigned CNSTATA9:1;
    unsigned CNSTATA10:1;
    unsigned :3;
    unsigned CNSTATA14:1;
    unsigned CNSTATA15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATAbits_t;
extern volatile __CNSTATAbits_t CNSTATAbits __asm__ ("CNSTATA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATAINV __attribute__((section("sfrs")));
#define CNNEA CNNEA
extern volatile unsigned int   CNNEA __attribute__((section("sfrs")));
typedef struct {
  unsigned CNNEA0:1;
  unsigned CNNEA1:1;
  unsigned CNNEA2:1;
  unsigned CNNEA3:1;
  unsigned CNNEA4:1;
  unsigned CNNEA5:1;
  unsigned CNNEA6:1;
  unsigned CNNEA7:1;
  unsigned :1;
  unsigned CNNEA9:1;
  unsigned CNNEA10:1;
  unsigned :3;
  unsigned CNNEA14:1;
  unsigned CNNEA15:1;
} __CNNEAbits_t;
extern volatile __CNNEAbits_t CNNEAbits __asm__ ("CNNEA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEAINV __attribute__((section("sfrs")));
#define CNFA CNFA
extern volatile unsigned int   CNFA __attribute__((section("sfrs")));
typedef struct {
  unsigned CNFA0:1;
  unsigned CNFA1:1;
  unsigned CNFA2:1;
  unsigned CNFA3:1;
  unsigned CNFA4:1;
  unsigned CNFA5:1;
  unsigned CNFA6:1;
  unsigned CNFA7:1;
  unsigned :1;
  unsigned CNFA9:1;
  unsigned CNFA10:1;
  unsigned :3;
  unsigned CNFA14:1;
  unsigned CNFA15:1;
} __CNFAbits_t;
extern volatile __CNFAbits_t CNFAbits __asm__ ("CNFA") __attribute__((section("sfrs")));
extern volatile unsigned int        CNFACLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNFASET __attribute__((section("sfrs")));
extern volatile unsigned int        CNFAINV __attribute__((section("sfrs")));
#define SRCON0A SRCON0A
extern volatile unsigned int   SRCON0A __attribute__((section("sfrs")));
typedef struct {
  unsigned :6;
  unsigned SR0A6:1;
  unsigned SR0A7:1;
} __SRCON0Abits_t;
extern volatile __SRCON0Abits_t SRCON0Abits __asm__ ("SRCON0A") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0ACLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0ASET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0AINV __attribute__((section("sfrs")));
#define SRCON1A SRCON1A
extern volatile unsigned int   SRCON1A __attribute__((section("sfrs")));
typedef struct {
  unsigned :6;
  unsigned SR1A6:1;
  unsigned SR1A7:1;
} __SRCON1Abits_t;
extern volatile __SRCON1Abits_t SRCON1Abits __asm__ ("SRCON1A") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1ACLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1ASET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1AINV __attribute__((section("sfrs")));
#define ANSELB ANSELB
extern volatile unsigned int   ANSELB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ANSB0:1;
    unsigned ANSB1:1;
    unsigned ANSB2:1;
    unsigned ANSB3:1;
    unsigned ANSB4:1;
    unsigned ANSB5:1;
    unsigned ANSB6:1;
    unsigned ANSB7:1;
    unsigned ANSB8:1;
    unsigned ANSB9:1;
    unsigned ANSB10:1;
    unsigned ANSB11:1;
    unsigned ANSB12:1;
    unsigned ANSB13:1;
    unsigned ANSB14:1;
    unsigned ANSB15:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELBbits_t;
extern volatile __ANSELBbits_t ANSELBbits __asm__ ("ANSELB") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELBSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELBINV __attribute__((section("sfrs")));
#define TRISB TRISB
extern volatile unsigned int   TRISB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISB0:1;
    unsigned TRISB1:1;
    unsigned TRISB2:1;
    unsigned TRISB3:1;
    unsigned TRISB4:1;
    unsigned TRISB5:1;
    unsigned TRISB6:1;
    unsigned TRISB7:1;
    unsigned TRISB8:1;
    unsigned TRISB9:1;
    unsigned TRISB10:1;
    unsigned TRISB11:1;
    unsigned TRISB12:1;
    unsigned TRISB13:1;
    unsigned TRISB14:1;
    unsigned TRISB15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISBbits_t;
extern volatile __TRISBbits_t TRISBbits __asm__ ("TRISB") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISBSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISBINV __attribute__((section("sfrs")));
#define PORTB PORTB
extern volatile unsigned int   PORTB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RB0:1;
    unsigned RB1:1;
    unsigned RB2:1;
    unsigned RB3:1;
    unsigned RB4:1;
    unsigned RB5:1;
    unsigned RB6:1;
    unsigned RB7:1;
    unsigned RB8:1;
    unsigned RB9:1;
    unsigned RB10:1;
    unsigned RB11:1;
    unsigned RB12:1;
    unsigned RB13:1;
    unsigned RB14:1;
    unsigned RB15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTBbits_t;
extern volatile __PORTBbits_t PORTBbits __asm__ ("PORTB") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTBSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTBINV __attribute__((section("sfrs")));
#define LATB LATB
extern volatile unsigned int   LATB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATB0:1;
    unsigned LATB1:1;
    unsigned LATB2:1;
    unsigned LATB3:1;
    unsigned LATB4:1;
    unsigned LATB5:1;
    unsigned LATB6:1;
    unsigned LATB7:1;
    unsigned LATB8:1;
    unsigned LATB9:1;
    unsigned LATB10:1;
    unsigned LATB11:1;
    unsigned LATB12:1;
    unsigned LATB13:1;
    unsigned LATB14:1;
    unsigned LATB15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATBbits_t;
extern volatile __LATBbits_t LATBbits __asm__ ("LATB") __attribute__((section("sfrs")));
extern volatile unsigned int        LATBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATBSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATBINV __attribute__((section("sfrs")));
#define ODCB ODCB
extern volatile unsigned int   ODCB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCB0:1;
    unsigned ODCB1:1;
    unsigned ODCB2:1;
    unsigned ODCB3:1;
    unsigned ODCB4:1;
    unsigned ODCB5:1;
    unsigned ODCB6:1;
    unsigned ODCB7:1;
    unsigned ODCB8:1;
    unsigned ODCB9:1;
    unsigned ODCB10:1;
    unsigned ODCB11:1;
    unsigned ODCB12:1;
    unsigned ODCB13:1;
    unsigned ODCB14:1;
    unsigned ODCB15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCBbits_t;
extern volatile __ODCBbits_t ODCBbits __asm__ ("ODCB") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCBSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCBINV __attribute__((section("sfrs")));
#define CNPUB CNPUB
extern volatile unsigned int   CNPUB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUB0:1;
    unsigned CNPUB1:1;
    unsigned CNPUB2:1;
    unsigned CNPUB3:1;
    unsigned CNPUB4:1;
    unsigned CNPUB5:1;
    unsigned CNPUB6:1;
    unsigned CNPUB7:1;
    unsigned CNPUB8:1;
    unsigned CNPUB9:1;
    unsigned CNPUB10:1;
    unsigned CNPUB11:1;
    unsigned CNPUB12:1;
    unsigned CNPUB13:1;
    unsigned CNPUB14:1;
    unsigned CNPUB15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUBbits_t;
extern volatile __CNPUBbits_t CNPUBbits __asm__ ("CNPUB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUBINV __attribute__((section("sfrs")));
#define CNPDB CNPDB
extern volatile unsigned int   CNPDB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDB0:1;
    unsigned CNPDB1:1;
    unsigned CNPDB2:1;
    unsigned CNPDB3:1;
    unsigned CNPDB4:1;
    unsigned CNPDB5:1;
    unsigned CNPDB6:1;
    unsigned CNPDB7:1;
    unsigned CNPDB8:1;
    unsigned CNPDB9:1;
    unsigned CNPDB10:1;
    unsigned CNPDB11:1;
    unsigned CNPDB12:1;
    unsigned CNPDB13:1;
    unsigned CNPDB14:1;
    unsigned CNPDB15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDBbits_t;
extern volatile __CNPDBbits_t CNPDBbits __asm__ ("CNPDB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDBINV __attribute__((section("sfrs")));
#define CNCONB CNCONB
extern volatile unsigned int   CNCONB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :11;
    unsigned EDGEDETECT:1;
    unsigned :3;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONBbits_t;
extern volatile __CNCONBbits_t CNCONBbits __asm__ ("CNCONB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONBINV __attribute__((section("sfrs")));
#define CNENB CNENB
extern volatile unsigned int   CNENB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEB0:1;
    unsigned CNIEB1:1;
    unsigned CNIEB2:1;
    unsigned CNIEB3:1;
    unsigned CNIEB4:1;
    unsigned CNIEB5:1;
    unsigned CNIEB6:1;
    unsigned CNIEB7:1;
    unsigned CNIEB8:1;
    unsigned CNIEB9:1;
    unsigned CNIEB10:1;
    unsigned CNIEB11:1;
    unsigned CNIEB12:1;
    unsigned CNIEB13:1;
    unsigned CNIEB14:1;
    unsigned CNIEB15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENBbits_t;
extern volatile __CNENBbits_t CNENBbits __asm__ ("CNENB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENBINV __attribute__((section("sfrs")));
#define CNSTATB CNSTATB
extern volatile unsigned int   CNSTATB __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATB0:1;
    unsigned CNSTATB1:1;
    unsigned CNSTATB2:1;
    unsigned CNSTATB3:1;
    unsigned CNSTATB4:1;
    unsigned CNSTATB5:1;
    unsigned CNSTATB6:1;
    unsigned CNSTATB7:1;
    unsigned CNSTATB8:1;
    unsigned CNSTATB9:1;
    unsigned CNSTATB10:1;
    unsigned CNSTATB11:1;
    unsigned CNSTATB12:1;
    unsigned CNSTATB13:1;
    unsigned CNSTATB14:1;
    unsigned CNSTATB15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATBbits_t;
extern volatile __CNSTATBbits_t CNSTATBbits __asm__ ("CNSTATB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATBINV __attribute__((section("sfrs")));
#define CNNEB CNNEB
extern volatile unsigned int   CNNEB __attribute__((section("sfrs")));
typedef struct {
  unsigned CNNEB0:1;
  unsigned CNNEB1:1;
  unsigned CNNEB2:1;
  unsigned CNNEB3:1;
  unsigned CNNEB4:1;
  unsigned CNNEB5:1;
  unsigned CNNEB6:1;
  unsigned CNNEB7:1;
  unsigned CNNEB8:1;
  unsigned CNNEB9:1;
  unsigned CNNEB10:1;
  unsigned CNNEB11:1;
  unsigned CNNEB12:1;
  unsigned CNNEB13:1;
  unsigned CNNEB14:1;
  unsigned CNNEB15:1;
} __CNNEBbits_t;
extern volatile __CNNEBbits_t CNNEBbits __asm__ ("CNNEB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEBINV __attribute__((section("sfrs")));
#define CNFB CNFB
extern volatile unsigned int   CNFB __attribute__((section("sfrs")));
typedef struct {
  unsigned CNFB0:1;
  unsigned CNFB1:1;
  unsigned CNFB2:1;
  unsigned CNFB3:1;
  unsigned CNFB4:1;
  unsigned CNFB5:1;
  unsigned CNFB6:1;
  unsigned CNFB7:1;
  unsigned CNFB8:1;
  unsigned CNFB9:1;
  unsigned CNFB10:1;
  unsigned CNFB11:1;
  unsigned CNFB12:1;
  unsigned CNFB13:1;
  unsigned CNFB14:1;
  unsigned CNFB15:1;
} __CNFBbits_t;
extern volatile __CNFBbits_t CNFBbits __asm__ ("CNFB") __attribute__((section("sfrs")));
extern volatile unsigned int        CNFBCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNFBSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNFBINV __attribute__((section("sfrs")));
#define SRCON0B SRCON0B
extern volatile unsigned int   SRCON0B __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SR0B3:1;
  unsigned :1;
  unsigned SR0B5:1;
  unsigned :2;
  unsigned SR0B8:1;
  unsigned SR0B9:1;
  unsigned SR0B10:1;
  unsigned :3;
  unsigned SR0B14:1;
} __SRCON0Bbits_t;
extern volatile __SRCON0Bbits_t SRCON0Bbits __asm__ ("SRCON0B") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0BCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0BSET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0BINV __attribute__((section("sfrs")));
#define SRCON1B SRCON1B
extern volatile unsigned int   SRCON1B __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SR1B3:1;
  unsigned :1;
  unsigned SR1B5:1;
  unsigned :2;
  unsigned SR1B8:1;
  unsigned SR1B9:1;
  unsigned SR1B10:1;
  unsigned :3;
  unsigned SR1B14:1;
} __SRCON1Bbits_t;
extern volatile __SRCON1Bbits_t SRCON1Bbits __asm__ ("SRCON1B") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1BCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1BSET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1BINV __attribute__((section("sfrs")));
#define ANSELC ANSELC
extern volatile unsigned int   ANSELC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned ANSC1:1;
    unsigned ANSC2:1;
    unsigned ANSC3:1;
    unsigned ANSC4:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELCbits_t;
extern volatile __ANSELCbits_t ANSELCbits __asm__ ("ANSELC") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELCSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELCINV __attribute__((section("sfrs")));
#define TRISC TRISC
extern volatile unsigned int   TRISC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned TRISC1:1;
    unsigned TRISC2:1;
    unsigned TRISC3:1;
    unsigned TRISC4:1;
    unsigned :7;
    unsigned TRISC12:1;
    unsigned TRISC13:1;
    unsigned TRISC14:1;
    unsigned TRISC15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISCbits_t;
extern volatile __TRISCbits_t TRISCbits __asm__ ("TRISC") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISCSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISCINV __attribute__((section("sfrs")));
#define PORTC PORTC
extern volatile unsigned int   PORTC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned RC1:1;
    unsigned RC2:1;
    unsigned RC3:1;
    unsigned RC4:1;
    unsigned :7;
    unsigned RC12:1;
    unsigned RC13:1;
    unsigned RC14:1;
    unsigned RC15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTCbits_t;
extern volatile __PORTCbits_t PORTCbits __asm__ ("PORTC") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTCSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTCINV __attribute__((section("sfrs")));
#define LATC LATC
extern volatile unsigned int   LATC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned LATC1:1;
    unsigned LATC2:1;
    unsigned LATC3:1;
    unsigned LATC4:1;
    unsigned :7;
    unsigned LATC12:1;
    unsigned LATC13:1;
    unsigned LATC14:1;
    unsigned LATC15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATCbits_t;
extern volatile __LATCbits_t LATCbits __asm__ ("LATC") __attribute__((section("sfrs")));
extern volatile unsigned int        LATCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATCSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATCINV __attribute__((section("sfrs")));
#define ODCC ODCC
extern volatile unsigned int   ODCC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned ODCC1:1;
    unsigned ODCC2:1;
    unsigned ODCC3:1;
    unsigned ODCC4:1;
    unsigned :7;
    unsigned ODCC12:1;
    unsigned ODCC13:1;
    unsigned ODCC14:1;
    unsigned ODCC15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCCbits_t;
extern volatile __ODCCbits_t ODCCbits __asm__ ("ODCC") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCCSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCCINV __attribute__((section("sfrs")));
#define CNPUC CNPUC
extern volatile unsigned int   CNPUC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned CNPUC1:1;
    unsigned CNPUC2:1;
    unsigned CNPUC3:1;
    unsigned CNPUC4:1;
    unsigned :7;
    unsigned CNPUC12:1;
    unsigned CNPUC13:1;
    unsigned CNPUC14:1;
    unsigned CNPUC15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUCbits_t;
extern volatile __CNPUCbits_t CNPUCbits __asm__ ("CNPUC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUCINV __attribute__((section("sfrs")));
#define CNPDC CNPDC
extern volatile unsigned int   CNPDC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned CNPDC1:1;
    unsigned CNPDC2:1;
    unsigned CNPDC3:1;
    unsigned CNPDC4:1;
    unsigned :7;
    unsigned CNPDC12:1;
    unsigned CNPDC13:1;
    unsigned CNPDC14:1;
    unsigned CNPDC15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDCbits_t;
extern volatile __CNPDCbits_t CNPDCbits __asm__ ("CNPDC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDCINV __attribute__((section("sfrs")));
#define CNCONC CNCONC
extern volatile unsigned int   CNCONC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :11;
    unsigned EDGEDETECT:1;
    unsigned :3;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONCbits_t;
extern volatile __CNCONCbits_t CNCONCbits __asm__ ("CNCONC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONCINV __attribute__((section("sfrs")));
#define CNENC CNENC
extern volatile unsigned int   CNENC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned CNIEC1:1;
    unsigned CNIEC2:1;
    unsigned CNIEC3:1;
    unsigned CNIEC4:1;
    unsigned :7;
    unsigned CNIEC12:1;
    unsigned CNIEC13:1;
    unsigned CNIEC14:1;
    unsigned CNIEC15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENCbits_t;
extern volatile __CNENCbits_t CNENCbits __asm__ ("CNENC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENCINV __attribute__((section("sfrs")));
#define CNSTATC CNSTATC
extern volatile unsigned int   CNSTATC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :1;
    unsigned CNSTATC1:1;
    unsigned CNSTATC2:1;
    unsigned CNSTATC3:1;
    unsigned CNSTATC4:1;
    unsigned :7;
    unsigned CNSTATC12:1;
    unsigned CNSTATC13:1;
    unsigned CNSTATC14:1;
    unsigned CNSTATC15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATCbits_t;
extern volatile __CNSTATCbits_t CNSTATCbits __asm__ ("CNSTATC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATCINV __attribute__((section("sfrs")));
#define CNNEC CNNEC
extern volatile unsigned int   CNNEC __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned CNNEC1:1;
  unsigned CNNEC2:1;
  unsigned CNNEC3:1;
  unsigned CNNEC4:1;
  unsigned :7;
  unsigned CNNEC12:1;
  unsigned CNNEC13:1;
  unsigned CNNEC14:1;
  unsigned CNNEC15:1;
} __CNNECbits_t;
extern volatile __CNNECbits_t CNNECbits __asm__ ("CNNEC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNNECCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNNECSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNNECINV __attribute__((section("sfrs")));
#define CNFC CNFC
extern volatile unsigned int   CNFC __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned CNFC1:1;
  unsigned CNFC2:1;
  unsigned CNFC3:1;
  unsigned CNFC4:1;
  unsigned :7;
  unsigned CNFC12:1;
  unsigned CNFC13:1;
  unsigned CNFC14:1;
  unsigned CNFC15:1;
} __CNFCbits_t;
extern volatile __CNFCbits_t CNFCbits __asm__ ("CNFC") __attribute__((section("sfrs")));
extern volatile unsigned int        CNFCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNFCSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNFCINV __attribute__((section("sfrs")));
#define ANSELD ANSELD
extern volatile unsigned int   ANSELD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :14;
    unsigned ANSD14:1;
    unsigned ANSD15:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELDbits_t;
extern volatile __ANSELDbits_t ANSELDbits __asm__ ("ANSELD") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELDSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELDINV __attribute__((section("sfrs")));
#define TRISD TRISD
extern volatile unsigned int   TRISD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISD0:1;
    unsigned TRISD1:1;
    unsigned TRISD2:1;
    unsigned TRISD3:1;
    unsigned TRISD4:1;
    unsigned TRISD5:1;
    unsigned :3;
    unsigned TRISD9:1;
    unsigned TRISD10:1;
    unsigned TRISD11:1;
    unsigned TRISD12:1;
    unsigned TRISD13:1;
    unsigned TRISD14:1;
    unsigned TRISD15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISDbits_t;
extern volatile __TRISDbits_t TRISDbits __asm__ ("TRISD") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISDSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISDINV __attribute__((section("sfrs")));
#define PORTD PORTD
extern volatile unsigned int   PORTD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RD0:1;
    unsigned RD1:1;
    unsigned RD2:1;
    unsigned RD3:1;
    unsigned RD4:1;
    unsigned RD5:1;
    unsigned :3;
    unsigned RD9:1;
    unsigned RD10:1;
    unsigned RD11:1;
    unsigned RD12:1;
    unsigned RD13:1;
    unsigned RD14:1;
    unsigned RD15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTDbits_t;
extern volatile __PORTDbits_t PORTDbits __asm__ ("PORTD") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTDSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTDINV __attribute__((section("sfrs")));
#define LATD LATD
extern volatile unsigned int   LATD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATD0:1;
    unsigned LATD1:1;
    unsigned LATD2:1;
    unsigned LATD3:1;
    unsigned LATD4:1;
    unsigned LATD5:1;
    unsigned :3;
    unsigned LATD9:1;
    unsigned LATD10:1;
    unsigned LATD11:1;
    unsigned LATD12:1;
    unsigned LATD13:1;
    unsigned LATD14:1;
    unsigned LATD15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATDbits_t;
extern volatile __LATDbits_t LATDbits __asm__ ("LATD") __attribute__((section("sfrs")));
extern volatile unsigned int        LATDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATDSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATDINV __attribute__((section("sfrs")));
#define ODCD ODCD
extern volatile unsigned int   ODCD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCD0:1;
    unsigned ODCD1:1;
    unsigned ODCD2:1;
    unsigned ODCD3:1;
    unsigned ODCD4:1;
    unsigned ODCD5:1;
    unsigned :3;
    unsigned ODCD9:1;
    unsigned ODCD10:1;
    unsigned ODCD11:1;
    unsigned ODCD12:1;
    unsigned ODCD13:1;
    unsigned ODCD14:1;
    unsigned ODCD15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCDbits_t;
extern volatile __ODCDbits_t ODCDbits __asm__ ("ODCD") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCDSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCDINV __attribute__((section("sfrs")));
#define CNPUD CNPUD
extern volatile unsigned int   CNPUD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUD0:1;
    unsigned CNPUD1:1;
    unsigned CNPUD2:1;
    unsigned CNPUD3:1;
    unsigned CNPUD4:1;
    unsigned CNPUD5:1;
    unsigned :3;
    unsigned CNPUD9:1;
    unsigned CNPUD10:1;
    unsigned CNPUD11:1;
    unsigned CNPUD12:1;
    unsigned CNPUD13:1;
    unsigned CNPUD14:1;
    unsigned CNPUD15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUDbits_t;
extern volatile __CNPUDbits_t CNPUDbits __asm__ ("CNPUD") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUDINV __attribute__((section("sfrs")));
#define CNPDD CNPDD
extern volatile unsigned int   CNPDD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDD0:1;
    unsigned CNPDD1:1;
    unsigned CNPDD2:1;
    unsigned CNPDD3:1;
    unsigned CNPDD4:1;
    unsigned CNPDD5:1;
    unsigned :3;
    unsigned CNPDD9:1;
    unsigned CNPDD10:1;
    unsigned CNPDD11:1;
    unsigned CNPDD12:1;
    unsigned CNPDD13:1;
    unsigned CNPDD14:1;
    unsigned CNPDD15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDDbits_t;
extern volatile __CNPDDbits_t CNPDDbits __asm__ ("CNPDD") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDDINV __attribute__((section("sfrs")));
#define CNCOND CNCOND
extern volatile unsigned int   CNCOND __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :11;
    unsigned EDGEDETECT:1;
    unsigned :3;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONDbits_t;
extern volatile __CNCONDbits_t CNCONDbits __asm__ ("CNCOND") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONDINV __attribute__((section("sfrs")));
#define CNEND CNEND
extern volatile unsigned int   CNEND __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIED0:1;
    unsigned CNIED1:1;
    unsigned CNIED2:1;
    unsigned CNIED3:1;
    unsigned CNIED4:1;
    unsigned CNIED5:1;
    unsigned :3;
    unsigned CNIED9:1;
    unsigned CNIED10:1;
    unsigned CNIED11:1;
    unsigned CNIED12:1;
    unsigned CNIED13:1;
    unsigned CNIED14:1;
    unsigned CNIED15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENDbits_t;
extern volatile __CNENDbits_t CNENDbits __asm__ ("CNEND") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENDINV __attribute__((section("sfrs")));
#define CNSTATD CNSTATD
extern volatile unsigned int   CNSTATD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATD0:1;
    unsigned CNSTATD1:1;
    unsigned CNSTATD2:1;
    unsigned CNSTATD3:1;
    unsigned CNSTATD4:1;
    unsigned CNSTATD5:1;
    unsigned :3;
    unsigned CNSTATD9:1;
    unsigned CNSTATD10:1;
    unsigned CNSTATD11:1;
    unsigned CNSTATD12:1;
    unsigned CNSTATD13:1;
    unsigned CNSTATD14:1;
    unsigned CNSTATD15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATDbits_t;
extern volatile __CNSTATDbits_t CNSTATDbits __asm__ ("CNSTATD") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATDINV __attribute__((section("sfrs")));
#define CNNED CNNED
extern volatile unsigned int   CNNED __attribute__((section("sfrs")));
typedef struct {
  unsigned CNNED0:1;
  unsigned CNNED1:1;
  unsigned CNNED2:1;
  unsigned CNNED3:1;
  unsigned CNNED4:1;
  unsigned CNNED5:1;
  unsigned :3;
  unsigned CNNED9:1;
  unsigned CNNED10:1;
  unsigned CNNED11:1;
  unsigned CNNED12:1;
  unsigned CNNED13:1;
  unsigned CNNED14:1;
  unsigned CNNED15:1;
} __CNNEDbits_t;
extern volatile __CNNEDbits_t CNNEDbits __asm__ ("CNNED") __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEDINV __attribute__((section("sfrs")));
#define CNFD CNFD
extern volatile unsigned int   CNFD __attribute__((section("sfrs")));
typedef struct {
  unsigned CNFD0:1;
  unsigned CNFD1:1;
  unsigned CNFD2:1;
  unsigned CNFD3:1;
  unsigned CNFD4:1;
  unsigned CNFD5:1;
  unsigned :3;
  unsigned CNFD9:1;
  unsigned CNFD10:1;
  unsigned CNFD11:1;
  unsigned CNFD12:1;
  unsigned CNFD13:1;
  unsigned CNFD14:1;
  unsigned CNFD15:1;
} __CNFDbits_t;
extern volatile __CNFDbits_t CNFDbits __asm__ ("CNFD") __attribute__((section("sfrs")));
extern volatile unsigned int        CNFDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNFDSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNFDINV __attribute__((section("sfrs")));
#define ANSELE ANSELE
extern volatile unsigned int   ANSELE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :4;
    unsigned ANSE4:1;
    unsigned ANSE5:1;
    unsigned ANSE6:1;
    unsigned ANSE7:1;
    unsigned ANSE8:1;
    unsigned ANSE9:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELEbits_t;
extern volatile __ANSELEbits_t ANSELEbits __asm__ ("ANSELE") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELESET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELEINV __attribute__((section("sfrs")));
#define TRISE TRISE
extern volatile unsigned int   TRISE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISE0:1;
    unsigned TRISE1:1;
    unsigned TRISE2:1;
    unsigned TRISE3:1;
    unsigned TRISE4:1;
    unsigned TRISE5:1;
    unsigned TRISE6:1;
    unsigned TRISE7:1;
    unsigned TRISE8:1;
    unsigned TRISE9:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISEbits_t;
extern volatile __TRISEbits_t TRISEbits __asm__ ("TRISE") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISECLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISESET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISEINV __attribute__((section("sfrs")));
#define PORTE PORTE
extern volatile unsigned int   PORTE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RE0:1;
    unsigned RE1:1;
    unsigned RE2:1;
    unsigned RE3:1;
    unsigned RE4:1;
    unsigned RE5:1;
    unsigned RE6:1;
    unsigned RE7:1;
    unsigned RE8:1;
    unsigned RE9:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTEbits_t;
extern volatile __PORTEbits_t PORTEbits __asm__ ("PORTE") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTECLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTESET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTEINV __attribute__((section("sfrs")));
#define LATE LATE
extern volatile unsigned int   LATE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATE0:1;
    unsigned LATE1:1;
    unsigned LATE2:1;
    unsigned LATE3:1;
    unsigned LATE4:1;
    unsigned LATE5:1;
    unsigned LATE6:1;
    unsigned LATE7:1;
    unsigned LATE8:1;
    unsigned LATE9:1;
  };
  struct {
    unsigned w:32;
  };
} __LATEbits_t;
extern volatile __LATEbits_t LATEbits __asm__ ("LATE") __attribute__((section("sfrs")));
extern volatile unsigned int        LATECLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATESET __attribute__((section("sfrs")));
extern volatile unsigned int        LATEINV __attribute__((section("sfrs")));
#define ODCE ODCE
extern volatile unsigned int   ODCE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCE0:1;
    unsigned ODCE1:1;
    unsigned ODCE2:1;
    unsigned ODCE3:1;
    unsigned ODCE4:1;
    unsigned ODCE5:1;
    unsigned ODCE6:1;
    unsigned ODCE7:1;
    unsigned ODCE8:1;
    unsigned ODCE9:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCEbits_t;
extern volatile __ODCEbits_t ODCEbits __asm__ ("ODCE") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCECLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCESET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCEINV __attribute__((section("sfrs")));
#define CNPUE CNPUE
extern volatile unsigned int   CNPUE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUE0:1;
    unsigned CNPUE1:1;
    unsigned CNPUE2:1;
    unsigned CNPUE3:1;
    unsigned CNPUE4:1;
    unsigned CNPUE5:1;
    unsigned CNPUE6:1;
    unsigned CNPUE7:1;
    unsigned CNPUE8:1;
    unsigned CNPUE9:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUEbits_t;
extern volatile __CNPUEbits_t CNPUEbits __asm__ ("CNPUE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUEINV __attribute__((section("sfrs")));
#define CNPDE CNPDE
extern volatile unsigned int   CNPDE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDE0:1;
    unsigned CNPDE1:1;
    unsigned CNPDE2:1;
    unsigned CNPDE3:1;
    unsigned CNPDE4:1;
    unsigned CNPDE5:1;
    unsigned CNPDE6:1;
    unsigned CNPDE7:1;
    unsigned CNPDE8:1;
    unsigned CNPDE9:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDEbits_t;
extern volatile __CNPDEbits_t CNPDEbits __asm__ ("CNPDE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDEINV __attribute__((section("sfrs")));
#define CNCONE CNCONE
extern volatile unsigned int   CNCONE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :11;
    unsigned EDGEDETECT:1;
    unsigned :3;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONEbits_t;
extern volatile __CNCONEbits_t CNCONEbits __asm__ ("CNCONE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONEINV __attribute__((section("sfrs")));
#define CNENE CNENE
extern volatile unsigned int   CNENE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEE0:1;
    unsigned CNIEE1:1;
    unsigned CNIEE2:1;
    unsigned CNIEE3:1;
    unsigned CNIEE4:1;
    unsigned CNIEE5:1;
    unsigned CNIEE6:1;
    unsigned CNIEE7:1;
    unsigned CNIEE8:1;
    unsigned CNIEE9:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENEbits_t;
extern volatile __CNENEbits_t CNENEbits __asm__ ("CNENE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENEINV __attribute__((section("sfrs")));
#define CNSTATE CNSTATE
extern volatile unsigned int   CNSTATE __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATE0:1;
    unsigned CNSTATE1:1;
    unsigned CNSTATE2:1;
    unsigned CNSTATE3:1;
    unsigned CNSTATE4:1;
    unsigned CNSTATE5:1;
    unsigned CNSTATE6:1;
    unsigned CNSTATE7:1;
    unsigned CNSTATE8:1;
    unsigned CNSTATE9:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATEbits_t;
extern volatile __CNSTATEbits_t CNSTATEbits __asm__ ("CNSTATE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATEINV __attribute__((section("sfrs")));
#define CNNEE CNNEE
extern volatile unsigned int   CNNEE __attribute__((section("sfrs")));
typedef struct {
  unsigned CNNEE0:1;
  unsigned CNNEE1:1;
  unsigned CNNEE2:1;
  unsigned CNNEE3:1;
  unsigned CNNEE4:1;
  unsigned CNNEE5:1;
  unsigned CNNEE6:1;
  unsigned CNNEE7:1;
  unsigned CNNEE8:1;
  unsigned CNNEE9:1;
} __CNNEEbits_t;
extern volatile __CNNEEbits_t CNNEEbits __asm__ ("CNNEE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEEINV __attribute__((section("sfrs")));
#define CNFE CNFE
extern volatile unsigned int   CNFE __attribute__((section("sfrs")));
typedef struct {
  unsigned CNFE0:1;
  unsigned CNFE1:1;
  unsigned CNFE2:1;
  unsigned CNFE3:1;
  unsigned CNFE4:1;
  unsigned CNFE5:1;
  unsigned CNFE6:1;
  unsigned CNFE7:1;
  unsigned CNFE8:1;
  unsigned CNFE9:1;
} __CNFEbits_t;
extern volatile __CNFEbits_t CNFEbits __asm__ ("CNFE") __attribute__((section("sfrs")));
extern volatile unsigned int        CNFECLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNFESET __attribute__((section("sfrs")));
extern volatile unsigned int        CNFEINV __attribute__((section("sfrs")));
#define SRCON0E SRCON0E
extern volatile unsigned int   SRCON0E __attribute__((section("sfrs")));
typedef struct {
  unsigned SR0E0:1;
  unsigned SR0E1:1;
  unsigned SR0E2:1;
  unsigned SR0E3:1;
} __SRCON0Ebits_t;
extern volatile __SRCON0Ebits_t SRCON0Ebits __asm__ ("SRCON0E") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0ECLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0ESET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0EINV __attribute__((section("sfrs")));
#define SRCON1E SRCON1E
extern volatile unsigned int   SRCON1E __attribute__((section("sfrs")));
typedef struct {
  unsigned SR1E0:1;
  unsigned SR1E1:1;
  unsigned SR1E2:1;
  unsigned SR1E3:1;
} __SRCON1Ebits_t;
extern volatile __SRCON1Ebits_t SRCON1Ebits __asm__ ("SRCON1E") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1ECLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1ESET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1EINV __attribute__((section("sfrs")));
#define ANSELF ANSELF
extern volatile unsigned int   ANSELF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :12;
    unsigned ANSF12:1;
    unsigned ANSF13:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELFbits_t;
extern volatile __ANSELFbits_t ANSELFbits __asm__ ("ANSELF") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELFSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELFINV __attribute__((section("sfrs")));
#define TRISF TRISF
extern volatile unsigned int   TRISF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISF0:1;
    unsigned TRISF1:1;
    unsigned TRISF2:1;
    unsigned TRISF3:1;
    unsigned TRISF4:1;
    unsigned TRISF5:1;
    unsigned :2;
    unsigned TRISF8:1;
    unsigned :3;
    unsigned TRISF12:1;
    unsigned TRISF13:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISFbits_t;
extern volatile __TRISFbits_t TRISFbits __asm__ ("TRISF") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISFSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISFINV __attribute__((section("sfrs")));
#define PORTF PORTF
extern volatile unsigned int   PORTF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RF0:1;
    unsigned RF1:1;
    unsigned RF2:1;
    unsigned RF3:1;
    unsigned RF4:1;
    unsigned RF5:1;
    unsigned :2;
    unsigned RF8:1;
    unsigned :3;
    unsigned RF12:1;
    unsigned RF13:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTFbits_t;
extern volatile __PORTFbits_t PORTFbits __asm__ ("PORTF") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTFSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTFINV __attribute__((section("sfrs")));
#define LATF LATF
extern volatile unsigned int   LATF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATF0:1;
    unsigned LATF1:1;
    unsigned LATF2:1;
    unsigned LATF3:1;
    unsigned LATF4:1;
    unsigned LATF5:1;
    unsigned :2;
    unsigned LATF8:1;
    unsigned :3;
    unsigned LATF12:1;
    unsigned LATF13:1;
  };
  struct {
    unsigned w:32;
  };
} __LATFbits_t;
extern volatile __LATFbits_t LATFbits __asm__ ("LATF") __attribute__((section("sfrs")));
extern volatile unsigned int        LATFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATFSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATFINV __attribute__((section("sfrs")));
#define ODCF ODCF
extern volatile unsigned int   ODCF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCF0:1;
    unsigned ODCF1:1;
    unsigned ODCF2:1;
    unsigned ODCF3:1;
    unsigned ODCF4:1;
    unsigned ODCF5:1;
    unsigned :2;
    unsigned ODCF8:1;
    unsigned :3;
    unsigned ODCF12:1;
    unsigned ODCF13:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCFbits_t;
extern volatile __ODCFbits_t ODCFbits __asm__ ("ODCF") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCFSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCFINV __attribute__((section("sfrs")));
#define CNPUF CNPUF
extern volatile unsigned int   CNPUF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUF0:1;
    unsigned CNPUF1:1;
    unsigned CNPUF2:1;
    unsigned CNPUF3:1;
    unsigned CNPUF4:1;
    unsigned CNPUF5:1;
    unsigned :2;
    unsigned CNPUF8:1;
    unsigned :3;
    unsigned CNPUF12:1;
    unsigned CNPUF13:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUFbits_t;
extern volatile __CNPUFbits_t CNPUFbits __asm__ ("CNPUF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUFINV __attribute__((section("sfrs")));
#define CNPDF CNPDF
extern volatile unsigned int   CNPDF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDF0:1;
    unsigned CNPDF1:1;
    unsigned CNPDF2:1;
    unsigned CNPDF3:1;
    unsigned CNPDF4:1;
    unsigned CNPDF5:1;
    unsigned :2;
    unsigned CNPDF8:1;
    unsigned :3;
    unsigned CNPDF12:1;
    unsigned CNPDF13:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDFbits_t;
extern volatile __CNPDFbits_t CNPDFbits __asm__ ("CNPDF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDFINV __attribute__((section("sfrs")));
#define CNCONF CNCONF
extern volatile unsigned int   CNCONF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :11;
    unsigned EDGEDETECT:1;
    unsigned :3;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONFbits_t;
extern volatile __CNCONFbits_t CNCONFbits __asm__ ("CNCONF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONFINV __attribute__((section("sfrs")));
#define CNENF CNENF
extern volatile unsigned int   CNENF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEF0:1;
    unsigned CNIEF1:1;
    unsigned CNIEF2:1;
    unsigned CNIEF3:1;
    unsigned CNIEF4:1;
    unsigned CNIEF5:1;
    unsigned :2;
    unsigned CNIEF8:1;
    unsigned :3;
    unsigned CNIEF12:1;
    unsigned CNIEF13:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENFbits_t;
extern volatile __CNENFbits_t CNENFbits __asm__ ("CNENF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENFINV __attribute__((section("sfrs")));
#define CNSTATF CNSTATF
extern volatile unsigned int   CNSTATF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATF0:1;
    unsigned CNSTATF1:1;
    unsigned CNSTATF2:1;
    unsigned CNSTATF3:1;
    unsigned CNSTATF4:1;
    unsigned CNSTATF5:1;
    unsigned :2;
    unsigned CNSTATF8:1;
    unsigned :3;
    unsigned CNSTATF12:1;
    unsigned CNSTATF13:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATFbits_t;
extern volatile __CNSTATFbits_t CNSTATFbits __asm__ ("CNSTATF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATFINV __attribute__((section("sfrs")));
#define CNNEF CNNEF
extern volatile unsigned int   CNNEF __attribute__((section("sfrs")));
typedef struct {
  unsigned CNNEF0:1;
  unsigned CNNEF1:1;
  unsigned CNNEF2:1;
  unsigned CNNEF3:1;
  unsigned CNNEF4:1;
  unsigned CNNEF5:1;
  unsigned :2;
  unsigned CNNEF8:1;
  unsigned :3;
  unsigned CNNEF12:1;
  unsigned CNNEF13:1;
} __CNNEFbits_t;
extern volatile __CNNEFbits_t CNNEFbits __asm__ ("CNNEF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEFINV __attribute__((section("sfrs")));
#define CNFF CNFF
extern volatile unsigned int   CNFF __attribute__((section("sfrs")));
typedef struct {
  unsigned CNFF0:1;
  unsigned CNFF1:1;
  unsigned CNFF2:1;
  unsigned CNFF3:1;
  unsigned CNFF4:1;
  unsigned CNFF5:1;
  unsigned :2;
  unsigned CNFF8:1;
  unsigned :3;
  unsigned CNFF12:1;
  unsigned CNFF13:1;
} __CNFFbits_t;
extern volatile __CNFFbits_t CNFFbits __asm__ ("CNFF") __attribute__((section("sfrs")));
extern volatile unsigned int        CNFFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNFFSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNFFINV __attribute__((section("sfrs")));
#define SRCON0F SRCON0F
extern volatile unsigned int   SRCON0F __attribute__((section("sfrs")));
typedef struct {
  unsigned SR0F0:1;
  unsigned SR0F1:1;
} __SRCON0Fbits_t;
extern volatile __SRCON0Fbits_t SRCON0Fbits __asm__ ("SRCON0F") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0FCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0FSET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0FINV __attribute__((section("sfrs")));
#define SRCON1F SRCON1F
extern volatile unsigned int   SRCON1F __attribute__((section("sfrs")));
typedef struct {
  unsigned SR1F0:1;
  unsigned SR1F1:1;
} __SRCON1Fbits_t;
extern volatile __SRCON1Fbits_t SRCON1Fbits __asm__ ("SRCON1F") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1FCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1FSET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1FINV __attribute__((section("sfrs")));
#define ANSELG ANSELG
extern volatile unsigned int   ANSELG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :6;
    unsigned ANSG6:1;
    unsigned ANSG7:1;
    unsigned ANSG8:1;
    unsigned ANSG9:1;
    unsigned :5;
    unsigned ANSG15:1;
  };
  struct {
    unsigned w:32;
  };
} __ANSELGbits_t;
extern volatile __ANSELGbits_t ANSELGbits __asm__ ("ANSELG") __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELGSET __attribute__((section("sfrs")));
extern volatile unsigned int        ANSELGINV __attribute__((section("sfrs")));
#define TRISG TRISG
extern volatile unsigned int   TRISG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TRISG0:1;
    unsigned TRISG1:1;
    unsigned :4;
    unsigned TRISG6:1;
    unsigned TRISG7:1;
    unsigned TRISG8:1;
    unsigned TRISG9:1;
    unsigned :2;
    unsigned TRISG12:1;
    unsigned TRISG13:1;
    unsigned TRISG14:1;
    unsigned TRISG15:1;
  };
  struct {
    unsigned w:32;
  };
} __TRISGbits_t;
extern volatile __TRISGbits_t TRISGbits __asm__ ("TRISG") __attribute__((section("sfrs")));
extern volatile unsigned int        TRISGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        TRISGSET __attribute__((section("sfrs")));
extern volatile unsigned int        TRISGINV __attribute__((section("sfrs")));
#define PORTG PORTG
extern volatile unsigned int   PORTG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RG0:1;
    unsigned RG1:1;
    unsigned :4;
    unsigned RG6:1;
    unsigned RG7:1;
    unsigned RG8:1;
    unsigned RG9:1;
    unsigned :2;
    unsigned RG12:1;
    unsigned RG13:1;
    unsigned RG14:1;
    unsigned RG15:1;
  };
  struct {
    unsigned w:32;
  };
} __PORTGbits_t;
extern volatile __PORTGbits_t PORTGbits __asm__ ("PORTG") __attribute__((section("sfrs")));
extern volatile unsigned int        PORTGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PORTGSET __attribute__((section("sfrs")));
extern volatile unsigned int        PORTGINV __attribute__((section("sfrs")));
#define LATG LATG
extern volatile unsigned int   LATG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned LATG0:1;
    unsigned LATG1:1;
    unsigned :4;
    unsigned LATG6:1;
    unsigned LATG7:1;
    unsigned LATG8:1;
    unsigned LATG9:1;
    unsigned :2;
    unsigned LATG12:1;
    unsigned LATG13:1;
    unsigned LATG14:1;
    unsigned LATG15:1;
  };
  struct {
    unsigned w:32;
  };
} __LATGbits_t;
extern volatile __LATGbits_t LATGbits __asm__ ("LATG") __attribute__((section("sfrs")));
extern volatile unsigned int        LATGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        LATGSET __attribute__((section("sfrs")));
extern volatile unsigned int        LATGINV __attribute__((section("sfrs")));
#define ODCG ODCG
extern volatile unsigned int   ODCG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ODCG0:1;
    unsigned ODCG1:1;
    unsigned :4;
    unsigned ODCG6:1;
    unsigned ODCG7:1;
    unsigned ODCG8:1;
    unsigned ODCG9:1;
    unsigned :2;
    unsigned ODCG12:1;
    unsigned ODCG13:1;
    unsigned ODCG14:1;
    unsigned ODCG15:1;
  };
  struct {
    unsigned w:32;
  };
} __ODCGbits_t;
extern volatile __ODCGbits_t ODCGbits __asm__ ("ODCG") __attribute__((section("sfrs")));
extern volatile unsigned int        ODCGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ODCGSET __attribute__((section("sfrs")));
extern volatile unsigned int        ODCGINV __attribute__((section("sfrs")));
#define CNPUG CNPUG
extern volatile unsigned int   CNPUG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPUG0:1;
    unsigned CNPUG1:1;
    unsigned :4;
    unsigned CNPUG6:1;
    unsigned CNPUG7:1;
    unsigned CNPUG8:1;
    unsigned CNPUG9:1;
    unsigned :2;
    unsigned CNPUG12:1;
    unsigned CNPUG13:1;
    unsigned CNPUG14:1;
    unsigned CNPUG15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPUGbits_t;
extern volatile __CNPUGbits_t CNPUGbits __asm__ ("CNPUG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPUGINV __attribute__((section("sfrs")));
#define CNPDG CNPDG
extern volatile unsigned int   CNPDG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNPDG0:1;
    unsigned CNPDG1:1;
    unsigned :4;
    unsigned CNPDG6:1;
    unsigned CNPDG7:1;
    unsigned CNPDG8:1;
    unsigned CNPDG9:1;
    unsigned :2;
    unsigned CNPDG12:1;
    unsigned CNPDG13:1;
    unsigned CNPDG14:1;
    unsigned CNPDG15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNPDGbits_t;
extern volatile __CNPDGbits_t CNPDGbits __asm__ ("CNPDG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNPDGINV __attribute__((section("sfrs")));
#define CNCONG CNCONG
extern volatile unsigned int   CNCONG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :11;
    unsigned EDGEDETECT:1;
    unsigned :3;
    unsigned ON:1;
  };
  struct {
    unsigned w:32;
  };
} __CNCONGbits_t;
extern volatile __CNCONGbits_t CNCONGbits __asm__ ("CNCONG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNCONGINV __attribute__((section("sfrs")));
#define CNENG CNENG
extern volatile unsigned int   CNENG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNIEG0:1;
    unsigned CNIEG1:1;
    unsigned :4;
    unsigned CNIEG6:1;
    unsigned CNIEG7:1;
    unsigned CNIEG8:1;
    unsigned CNIEG9:1;
    unsigned :2;
    unsigned CNIEG12:1;
    unsigned CNIEG13:1;
    unsigned CNIEG14:1;
    unsigned CNIEG15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNENGbits_t;
extern volatile __CNENGbits_t CNENGbits __asm__ ("CNENG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNENGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNENGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNENGINV __attribute__((section("sfrs")));
#define CNSTATG CNSTATG
extern volatile unsigned int   CNSTATG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned CNSTATG0:1;
    unsigned CNSTATG1:1;
    unsigned :4;
    unsigned CNSTATG6:1;
    unsigned CNSTATG7:1;
    unsigned CNSTATG8:1;
    unsigned CNSTATG9:1;
    unsigned :2;
    unsigned CNSTATG12:1;
    unsigned CNSTATG13:1;
    unsigned CNSTATG14:1;
    unsigned CNSTATG15:1;
  };
  struct {
    unsigned w:32;
  };
} __CNSTATGbits_t;
extern volatile __CNSTATGbits_t CNSTATGbits __asm__ ("CNSTATG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNSTATGINV __attribute__((section("sfrs")));
#define CNNEG CNNEG
extern volatile unsigned int   CNNEG __attribute__((section("sfrs")));
typedef struct {
  unsigned CNNEG0:1;
  unsigned CNNEG1:1;
  unsigned :4;
  unsigned CNNEG6:1;
  unsigned CNNEG7:1;
  unsigned CNNEG8:1;
  unsigned CNNEG9:1;
  unsigned :2;
  unsigned CNNEG12:1;
  unsigned CNNEG13:1;
  unsigned CNNEG14:1;
  unsigned CNNEG15:1;
} __CNNEGbits_t;
extern volatile __CNNEGbits_t CNNEGbits __asm__ ("CNNEG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNNEGINV __attribute__((section("sfrs")));
#define CNFG CNFG
extern volatile unsigned int   CNFG __attribute__((section("sfrs")));
typedef struct {
  unsigned CNFG0:1;
  unsigned CNFG1:1;
  unsigned :4;
  unsigned CNFG6:1;
  unsigned CNFG7:1;
  unsigned CNFG8:1;
  unsigned CNFG9:1;
  unsigned :2;
  unsigned CNFG12:1;
  unsigned CNFG13:1;
  unsigned CNFG14:1;
  unsigned CNFG15:1;
} __CNFGbits_t;
extern volatile __CNFGbits_t CNFGbits __asm__ ("CNFG") __attribute__((section("sfrs")));
extern volatile unsigned int        CNFGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        CNFGSET __attribute__((section("sfrs")));
extern volatile unsigned int        CNFGINV __attribute__((section("sfrs")));
#define SRCON0G SRCON0G
extern volatile unsigned int   SRCON0G __attribute__((section("sfrs")));
typedef struct {
  unsigned :6;
  unsigned SR0G6:1;
  unsigned :2;
  unsigned SR0G9:1;
  unsigned :2;
  unsigned SR0G12:1;
  unsigned SR0G13:1;
  unsigned SR0G14:1;
} __SRCON0Gbits_t;
extern volatile __SRCON0Gbits_t SRCON0Gbits __asm__ ("SRCON0G") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0GCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0GSET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON0GINV __attribute__((section("sfrs")));
#define SRCON1G SRCON1G
extern volatile unsigned int   SRCON1G __attribute__((section("sfrs")));
typedef struct {
  unsigned :6;
  unsigned SR1G6:1;
  unsigned :2;
  unsigned SR1G9:1;
  unsigned :2;
  unsigned SR1G12:1;
  unsigned SR1G13:1;
  unsigned SR1G14:1;
} __SRCON1Gbits_t;
extern volatile __SRCON1Gbits_t SRCON1Gbits __asm__ ("SRCON1G") __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1GCLR __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1GSET __attribute__((section("sfrs")));
extern volatile unsigned int        SRCON1GINV __attribute__((section("sfrs")));
#define ETHCON1 ETHCON1
extern volatile unsigned int   ETHCON1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned BUFCDEC:1;
    unsigned :3;
    unsigned MANFC:1;
    unsigned :2;
    unsigned AUTOFC:1;
    unsigned RXEN:1;
    unsigned TXRTS:1;
    unsigned :3;
    unsigned SIDL:1;
    unsigned :1;
    unsigned ON:1;
    unsigned PTV:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHCON1bits_t;
extern volatile __ETHCON1bits_t ETHCON1bits __asm__ ("ETHCON1") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON1SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON1INV __attribute__((section("sfrs")));
#define ETHCON2 ETHCON2
extern volatile unsigned int   ETHCON2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :4;
    unsigned RXBUF_SZ:7;
  };
  struct {
    unsigned w:32;
  };
} __ETHCON2bits_t;
extern volatile __ETHCON2bits_t ETHCON2bits __asm__ ("ETHCON2") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON2SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHCON2INV __attribute__((section("sfrs")));
#define ETHTXST ETHTXST
extern volatile unsigned int   ETHTXST __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :2;
    unsigned TXSTADDR:30;
  };
  struct {
    unsigned w:32;
  };
} __ETHTXSTbits_t;
extern volatile __ETHTXSTbits_t ETHTXSTbits __asm__ ("ETHTXST") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHTXSTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHTXSTSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHTXSTINV __attribute__((section("sfrs")));
#define ETHRXST ETHRXST
extern volatile unsigned int   ETHRXST __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :2;
    unsigned RXSTADDR:30;
  };
  struct {
    unsigned w:32;
  };
} __ETHRXSTbits_t;
extern volatile __ETHRXSTbits_t ETHRXSTbits __asm__ ("ETHRXST") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXSTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXSTSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXSTINV __attribute__((section("sfrs")));
#define ETHHT0 ETHHT0
extern volatile unsigned int   ETHHT0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned w:32;
  };
  struct {
    unsigned HTLOWER:32;
  };
} __ETHHT0bits_t;
extern volatile __ETHHT0bits_t ETHHT0bits __asm__ ("ETHHT0") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT0SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT0INV __attribute__((section("sfrs")));
#define ETHHT1 ETHHT1
extern volatile unsigned int   ETHHT1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned w:32;
  };
  struct {
    unsigned HTUPPER:32;
  };
} __ETHHT1bits_t;
extern volatile __ETHHT1bits_t ETHHT1bits __asm__ ("ETHHT1") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT1SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHHT1INV __attribute__((section("sfrs")));
#define ETHPMM0 ETHPMM0
extern volatile unsigned int   ETHPMM0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned w:32;
  };
  struct {
    unsigned PMMLOWER:32;
  };
} __ETHPMM0bits_t;
extern volatile __ETHPMM0bits_t ETHPMM0bits __asm__ ("ETHPMM0") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM0SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM0INV __attribute__((section("sfrs")));
#define ETHPMM1 ETHPMM1
extern volatile unsigned int   ETHPMM1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned w:32;
  };
  struct {
    unsigned PMMUPPER:32;
  };
} __ETHPMM1bits_t;
extern volatile __ETHPMM1bits_t ETHPMM1bits __asm__ ("ETHPMM1") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM1SET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMM1INV __attribute__((section("sfrs")));
#define ETHPMCS ETHPMCS
extern volatile unsigned int   ETHPMCS __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMCS:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHPMCSbits_t;
extern volatile __ETHPMCSbits_t ETHPMCSbits __asm__ ("ETHPMCS") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMCSCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMCSSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMCSINV __attribute__((section("sfrs")));
#define ETHPMO ETHPMO
extern volatile unsigned int   ETHPMO __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned PMO:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHPMObits_t;
extern volatile __ETHPMObits_t ETHPMObits __asm__ ("ETHPMO") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMOCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMOSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHPMOINV __attribute__((section("sfrs")));
#define ETHRXFC ETHRXFC
extern volatile unsigned int   ETHRXFC __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned BCEN:1;
    unsigned MCEN:1;
    unsigned NOTMEEN:1;
    unsigned UCEN:1;
    unsigned RUNTEN:1;
    unsigned RUNTERREN:1;
    unsigned CRCOKEN:1;
    unsigned CRCERREN:1;
    unsigned PMMODE:4;
    unsigned NOTPM:1;
    unsigned :1;
    unsigned MPEN:1;
    unsigned HTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ETHRXFCbits_t;
extern volatile __ETHRXFCbits_t ETHRXFCbits __asm__ ("ETHRXFC") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXFCCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXFCSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXFCINV __attribute__((section("sfrs")));
#define ETHRXWM ETHRXWM
extern volatile unsigned int   ETHRXWM __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXEWM:8;
    unsigned :8;
    unsigned RXFWM:8;
  };
  struct {
    unsigned w:32;
  };
} __ETHRXWMbits_t;
extern volatile __ETHRXWMbits_t ETHRXWMbits __asm__ ("ETHRXWM") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXWMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXWMSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXWMINV __attribute__((section("sfrs")));
#define ETHIEN ETHIEN
extern volatile unsigned int   ETHIEN __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXOVFLWIE:1;
    unsigned RXBUFNAIE:1;
    unsigned TXABORTIE:1;
    unsigned TXDONEIE:1;
    unsigned :1;
    unsigned RXACTIE:1;
    unsigned PKTPENDIE:1;
    unsigned RXDONEIE:1;
    unsigned FWMARKIE:1;
    unsigned EWMARKIE:1;
    unsigned :3;
    unsigned RXBUSEIE:1;
    unsigned TXBUSEIE:1;
  };
  struct {
    unsigned w:32;
  };
} __ETHIENbits_t;
extern volatile __ETHIENbits_t ETHIENbits __asm__ ("ETHIEN") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIENCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIENSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIENINV __attribute__((section("sfrs")));
#define ETHIRQ ETHIRQ
extern volatile unsigned int   ETHIRQ __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXOVFLW:1;
    unsigned RXBUFNA:1;
    unsigned TXABORT:1;
    unsigned TXDONE:1;
    unsigned :1;
    unsigned RXACT:1;
    unsigned PKTPEND:1;
    unsigned RXDONE:1;
    unsigned FWMARK:1;
    unsigned EWMARK:1;
    unsigned :3;
    unsigned RXBUSE:1;
    unsigned TXBUSE:1;
  };
  struct {
    unsigned w:32;
  };
} __ETHIRQbits_t;
extern volatile __ETHIRQbits_t ETHIRQbits __asm__ ("ETHIRQ") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIRQCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIRQSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHIRQINV __attribute__((section("sfrs")));
#define ETHSTAT ETHSTAT
extern volatile unsigned int   ETHSTAT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :5;
    unsigned RXBUSY:1;
    unsigned TXBUSY:1;
    unsigned BUSY:1;
    unsigned :8;
    unsigned BUFCNT:8;
  };
  struct {
    unsigned :7;
    unsigned ETHBUSY:1;
  };
  struct {
    unsigned w:32;
  };
} __ETHSTATbits_t;
extern volatile __ETHSTATbits_t ETHSTATbits __asm__ ("ETHSTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSTATINV __attribute__((section("sfrs")));
#define ETHRXOVFLOW ETHRXOVFLOW
extern volatile unsigned int   ETHRXOVFLOW __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXOVFLWCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHRXOVFLOWbits_t;
extern volatile __ETHRXOVFLOWbits_t ETHRXOVFLOWbits __asm__ ("ETHRXOVFLOW") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXOVFLOWCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXOVFLOWSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHRXOVFLOWINV __attribute__((section("sfrs")));
#define ETHFRMTXOK ETHFRMTXOK
extern volatile unsigned int   ETHFRMTXOK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FRMTXOKCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHFRMTXOKbits_t;
extern volatile __ETHFRMTXOKbits_t ETHFRMTXOKbits __asm__ ("ETHFRMTXOK") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMTXOKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMTXOKSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMTXOKINV __attribute__((section("sfrs")));
#define ETHSCOLFRM ETHSCOLFRM
extern volatile unsigned int   ETHSCOLFRM __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SCOLFRMCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHSCOLFRMbits_t;
extern volatile __ETHSCOLFRMbits_t ETHSCOLFRMbits __asm__ ("ETHSCOLFRM") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSCOLFRMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSCOLFRMSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHSCOLFRMINV __attribute__((section("sfrs")));
#define ETHMCOLFRM ETHMCOLFRM
extern volatile unsigned int   ETHMCOLFRM __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MCOLFRMCNT:16;
  };
  struct {
    unsigned MCOLFRM_CNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHMCOLFRMbits_t;
extern volatile __ETHMCOLFRMbits_t ETHMCOLFRMbits __asm__ ("ETHMCOLFRM") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHMCOLFRMCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHMCOLFRMSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHMCOLFRMINV __attribute__((section("sfrs")));
#define ETHFRMRXOK ETHFRMRXOK
extern volatile unsigned int   ETHFRMRXOK __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FRMRXOKCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHFRMRXOKbits_t;
extern volatile __ETHFRMRXOKbits_t ETHFRMRXOKbits __asm__ ("ETHFRMRXOK") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMRXOKCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMRXOKSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFRMRXOKINV __attribute__((section("sfrs")));
#define ETHFCSERR ETHFCSERR
extern volatile unsigned int   ETHFCSERR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FCSERRCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHFCSERRbits_t;
extern volatile __ETHFCSERRbits_t ETHFCSERRbits __asm__ ("ETHFCSERR") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFCSERRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFCSERRSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHFCSERRINV __attribute__((section("sfrs")));
#define ETHALGNERR ETHALGNERR
extern volatile unsigned int   ETHALGNERR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned ALGNERRCNT:16;
  };
  struct {
    unsigned w:32;
  };
} __ETHALGNERRbits_t;
extern volatile __ETHALGNERRbits_t ETHALGNERRbits __asm__ ("ETHALGNERR") __attribute__((section("sfrs")));
extern volatile unsigned int        ETHALGNERRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        ETHALGNERRSET __attribute__((section("sfrs")));
extern volatile unsigned int        ETHALGNERRINV __attribute__((section("sfrs")));
#define EMAC1CFG1 EMAC1CFG1
extern volatile unsigned int   EMAC1CFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXENABLE:1;
    unsigned PASSALL:1;
    unsigned RXPAUSE:1;
    unsigned TXPAUSE:1;
    unsigned LOOPBACK:1;
    unsigned :3;
    unsigned RESETTFUN:1;
    unsigned RESETTMCS:1;
    unsigned RESETRFUN:1;
    unsigned RESETRMCS:1;
    unsigned :2;
    unsigned SIMRESET:1;
    unsigned SOFTRESET:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1CFG1bits_t;
extern volatile __EMAC1CFG1bits_t EMAC1CFG1bits __asm__ ("EMAC1CFG1") __attribute__((section("sfrs")));
#define EMACxCFG1 EMACxCFG1
extern volatile unsigned int   EMACxCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXENABLE:1;
    unsigned PASSALL:1;
    unsigned RXPAUSE:1;
    unsigned TXPAUSE:1;
    unsigned LOOPBACK:1;
    unsigned :3;
    unsigned RESETTFUN:1;
    unsigned RESETTMCS:1;
    unsigned RESETRFUN:1;
    unsigned RESETRMCS:1;
    unsigned :2;
    unsigned SIMRESET:1;
    unsigned SOFTRESET:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxCFG1bits_t;
extern volatile __EMACxCFG1bits_t EMACxCFG1bits __asm__ ("EMACxCFG1") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG1SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG1SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG1INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG1INV __attribute__((section("sfrs")));
#define EMAC1CFG2 EMAC1CFG2
extern volatile unsigned int   EMAC1CFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FULLDPLX:1;
    unsigned LENGTHCK:1;
    unsigned HUGEFRM:1;
    unsigned DELAYCRC:1;
    unsigned CRCENABLE:1;
    unsigned PADENABLE:1;
    unsigned VLANPAD:1;
    unsigned AUTOPAD:1;
    unsigned PUREPRE:1;
    unsigned LONGPRE:1;
    unsigned :2;
    unsigned NOBKOFF:1;
    unsigned BPNOBKOFF:1;
    unsigned EXCESSDFR:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1CFG2bits_t;
extern volatile __EMAC1CFG2bits_t EMAC1CFG2bits __asm__ ("EMAC1CFG2") __attribute__((section("sfrs")));
#define EMACxCFG2 EMACxCFG2
extern volatile unsigned int   EMACxCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FULLDPLX:1;
    unsigned LENGTHCK:1;
    unsigned HUGEFRM:1;
    unsigned DELAYCRC:1;
    unsigned CRCENABLE:1;
    unsigned PADENABLE:1;
    unsigned VLANPAD:1;
    unsigned AUTOPAD:1;
    unsigned PUREPRE:1;
    unsigned LONGPRE:1;
    unsigned :2;
    unsigned NOBKOFF:1;
    unsigned BPNOBKOFF:1;
    unsigned EXCESSDFR:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxCFG2bits_t;
extern volatile __EMACxCFG2bits_t EMACxCFG2bits __asm__ ("EMACxCFG2") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG2SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG2SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CFG2INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCFG2INV __attribute__((section("sfrs")));
#define EMAC1IPGT EMAC1IPGT
extern volatile unsigned int   EMAC1IPGT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned B2BIPKTGP:7;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1IPGTbits_t;
extern volatile __EMAC1IPGTbits_t EMAC1IPGTbits __asm__ ("EMAC1IPGT") __attribute__((section("sfrs")));
#define EMACxIPGT EMACxIPGT
extern volatile unsigned int   EMACxIPGT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned B2BIPKTGP:7;
  };
  struct {
    unsigned w:32;
  };
} __EMACxIPGTbits_t;
extern volatile __EMACxIPGTbits_t EMACxIPGTbits __asm__ ("EMACxIPGT") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGTINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGTINV __attribute__((section("sfrs")));
#define EMAC1IPGR EMAC1IPGR
extern volatile unsigned int   EMAC1IPGR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned NB2BIPKTGP2:7;
    unsigned :1;
    unsigned NB2BIPKTGP1:7;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1IPGRbits_t;
extern volatile __EMAC1IPGRbits_t EMAC1IPGRbits __asm__ ("EMAC1IPGR") __attribute__((section("sfrs")));
#define EMACxIPGR EMACxIPGR
extern volatile unsigned int   EMACxIPGR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned NB2BIPKTGP2:7;
    unsigned :1;
    unsigned NB2BIPKTGP1:7;
  };
  struct {
    unsigned w:32;
  };
} __EMACxIPGRbits_t;
extern volatile __EMACxIPGRbits_t EMACxIPGRbits __asm__ ("EMACxIPGR") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGRSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGRSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1IPGRINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxIPGRINV __attribute__((section("sfrs")));
#define EMAC1CLRT EMAC1CLRT
extern volatile unsigned int   EMAC1CLRT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RETX:4;
    unsigned :4;
    unsigned CWINDOW:6;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1CLRTbits_t;
extern volatile __EMAC1CLRTbits_t EMAC1CLRTbits __asm__ ("EMAC1CLRT") __attribute__((section("sfrs")));
#define EMACxCLRT EMACxCLRT
extern volatile unsigned int   EMACxCLRT __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RETX:4;
    unsigned :4;
    unsigned CWINDOW:6;
  };
  struct {
    unsigned w:32;
  };
} __EMACxCLRTbits_t;
extern volatile __EMACxCLRTbits_t EMACxCLRTbits __asm__ ("EMACxCLRT") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CLRTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCLRTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CLRTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCLRTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1CLRTINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxCLRTINV __attribute__((section("sfrs")));
#define EMAC1MAXF EMAC1MAXF
extern volatile unsigned int   EMAC1MAXF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MACMAXF:16;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MAXFbits_t;
extern volatile __EMAC1MAXFbits_t EMAC1MAXFbits __asm__ ("EMAC1MAXF") __attribute__((section("sfrs")));
#define EMACxMAXF EMACxMAXF
extern volatile unsigned int   EMACxMAXF __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MACMAXF:16;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMAXFbits_t;
extern volatile __EMACxMAXFbits_t EMACxMAXFbits __asm__ ("EMACxMAXF") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MAXFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMAXFCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MAXFSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMAXFSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MAXFINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMAXFINV __attribute__((section("sfrs")));
#define EMAC1SUPP EMAC1SUPP
extern volatile unsigned int   EMAC1SUPP __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SPEEDRMII:1;
    unsigned :2;
    unsigned RESETRMII:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1SUPPbits_t;
extern volatile __EMAC1SUPPbits_t EMAC1SUPPbits __asm__ ("EMAC1SUPP") __attribute__((section("sfrs")));
#define EMACxSUPP EMACxSUPP
extern volatile unsigned int   EMACxSUPP __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :8;
    unsigned SPEEDRMII:1;
    unsigned :2;
    unsigned RESETRMII:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxSUPPbits_t;
extern volatile __EMACxSUPPbits_t EMACxSUPPbits __asm__ ("EMACxSUPP") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SUPPCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSUPPCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SUPPSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSUPPSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SUPPINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSUPPINV __attribute__((section("sfrs")));
#define EMAC1TEST EMAC1TEST
extern volatile unsigned int   EMAC1TEST __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SHRTQNTA:1;
    unsigned TESTPAUSE:1;
    unsigned TESTBP:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1TESTbits_t;
extern volatile __EMAC1TESTbits_t EMAC1TESTbits __asm__ ("EMAC1TEST") __attribute__((section("sfrs")));
#define EMACxTEST EMACxTEST
extern volatile unsigned int   EMACxTEST __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SHRTQNTA:1;
    unsigned TESTPAUSE:1;
    unsigned TESTBP:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxTESTbits_t;
extern volatile __EMACxTESTbits_t EMACxTESTbits __asm__ ("EMACxTEST") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1TESTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxTESTCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1TESTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxTESTSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1TESTINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxTESTINV __attribute__((section("sfrs")));
#define EMAC1MCFG EMAC1MCFG
extern volatile unsigned int   EMAC1MCFG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SCANINC:1;
    unsigned NOPRE:1;
    unsigned CLKSEL:4;
    unsigned :9;
    unsigned RESETMGMT:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MCFGbits_t;
extern volatile __EMAC1MCFGbits_t EMAC1MCFGbits __asm__ ("EMAC1MCFG") __attribute__((section("sfrs")));
#define EMACxMCFG EMACxMCFG
extern volatile unsigned int   EMACxMCFG __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SCANINC:1;
    unsigned NOPRE:1;
    unsigned CLKSEL:4;
    unsigned :9;
    unsigned RESETMGMT:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMCFGbits_t;
extern volatile __EMACxMCFGbits_t EMACxMCFGbits __asm__ ("EMACxMCFG") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCFGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCFGCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCFGSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCFGSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCFGINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCFGINV __attribute__((section("sfrs")));
#define EMAC1MCMD EMAC1MCMD
extern volatile unsigned int   EMAC1MCMD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned READ:1;
    unsigned SCAN:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MCMDbits_t;
extern volatile __EMAC1MCMDbits_t EMAC1MCMDbits __asm__ ("EMAC1MCMD") __attribute__((section("sfrs")));
#define EMACxMCMD EMACxMCMD
extern volatile unsigned int   EMACxMCMD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned READ:1;
    unsigned SCAN:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMCMDbits_t;
extern volatile __EMACxMCMDbits_t EMACxMCMDbits __asm__ ("EMACxMCMD") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCMDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCMDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCMDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCMDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MCMDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMCMDINV __attribute__((section("sfrs")));
#define EMAC1MADR EMAC1MADR
extern volatile unsigned int   EMAC1MADR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned REGADDR:5;
    unsigned :3;
    unsigned PHYADDR:5;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MADRbits_t;
extern volatile __EMAC1MADRbits_t EMAC1MADRbits __asm__ ("EMAC1MADR") __attribute__((section("sfrs")));
#define EMACxMADR EMACxMADR
extern volatile unsigned int   EMACxMADR __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned REGADDR:5;
    unsigned :3;
    unsigned PHYADDR:5;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMADRbits_t;
extern volatile __EMACxMADRbits_t EMACxMADRbits __asm__ ("EMACxMADR") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MADRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMADRCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MADRSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMADRSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MADRINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMADRINV __attribute__((section("sfrs")));
#define EMAC1MWTD EMAC1MWTD
extern volatile unsigned int   EMAC1MWTD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MWTD:16;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MWTDbits_t;
extern volatile __EMAC1MWTDbits_t EMAC1MWTDbits __asm__ ("EMAC1MWTD") __attribute__((section("sfrs")));
#define EMACxMWTD EMACxMWTD
extern volatile unsigned int   EMACxMWTD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MWTD:16;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMWTDbits_t;
extern volatile __EMACxMWTDbits_t EMACxMWTDbits __asm__ ("EMACxMWTD") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MWTDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMWTDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MWTDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMWTDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MWTDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMWTDINV __attribute__((section("sfrs")));
#define EMAC1MRDD EMAC1MRDD
extern volatile unsigned int   EMAC1MRDD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MRDD:16;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MRDDbits_t;
extern volatile __EMAC1MRDDbits_t EMAC1MRDDbits __asm__ ("EMAC1MRDD") __attribute__((section("sfrs")));
#define EMACxMRDD EMACxMRDD
extern volatile unsigned int   EMACxMRDD __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MRDD:16;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMRDDbits_t;
extern volatile __EMACxMRDDbits_t EMACxMRDDbits __asm__ ("EMACxMRDD") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MRDDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMRDDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MRDDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMRDDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MRDDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMRDDINV __attribute__((section("sfrs")));
#define EMAC1MIND EMAC1MIND
extern volatile unsigned int   EMAC1MIND __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MIIMBUSY:1;
    unsigned SCAN:1;
    unsigned NOTVALID:1;
    unsigned LINKFAIL:1;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1MINDbits_t;
extern volatile __EMAC1MINDbits_t EMAC1MINDbits __asm__ ("EMAC1MIND") __attribute__((section("sfrs")));
#define EMACxMIND EMACxMIND
extern volatile unsigned int   EMACxMIND __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned MIIMBUSY:1;
    unsigned SCAN:1;
    unsigned NOTVALID:1;
    unsigned LINKFAIL:1;
  };
  struct {
    unsigned w:32;
  };
} __EMACxMINDbits_t;
extern volatile __EMACxMINDbits_t EMACxMINDbits __asm__ ("EMACxMIND") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MINDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMINDCLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MINDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMINDSET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1MINDINV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxMINDINV __attribute__((section("sfrs")));
#define EMAC1SA0 EMAC1SA0
extern volatile unsigned int   EMAC1SA0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR5:8;
    unsigned STNADDR6:8;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1SA0bits_t;
extern volatile __EMAC1SA0bits_t EMAC1SA0bits __asm__ ("EMAC1SA0") __attribute__((section("sfrs")));
#define EMACxSA0 EMACxSA0
extern volatile unsigned int   EMACxSA0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR5:8;
    unsigned STNADDR6:8;
  };
  struct {
    unsigned w:32;
  };
} __EMACxSA0bits_t;
extern volatile __EMACxSA0bits_t EMACxSA0bits __asm__ ("EMACxSA0") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA0CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA0SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA0SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA0INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA0INV __attribute__((section("sfrs")));
#define EMAC1SA1 EMAC1SA1
extern volatile unsigned int   EMAC1SA1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR3:8;
    unsigned STNADDR4:8;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1SA1bits_t;
extern volatile __EMAC1SA1bits_t EMAC1SA1bits __asm__ ("EMAC1SA1") __attribute__((section("sfrs")));
#define EMACxSA1 EMACxSA1
extern volatile unsigned int   EMACxSA1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR3:8;
    unsigned STNADDR4:8;
  };
  struct {
    unsigned w:32;
  };
} __EMACxSA1bits_t;
extern volatile __EMACxSA1bits_t EMACxSA1bits __asm__ ("EMACxSA1") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA1CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA1SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA1SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA1INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA1INV __attribute__((section("sfrs")));
#define EMAC1SA2 EMAC1SA2
extern volatile unsigned int   EMAC1SA2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR1:8;
    unsigned STNADDR2:8;
  };
  struct {
    unsigned w:32;
  };
} __EMAC1SA2bits_t;
extern volatile __EMAC1SA2bits_t EMAC1SA2bits __asm__ ("EMAC1SA2") __attribute__((section("sfrs")));
#define EMACxSA2 EMACxSA2
extern volatile unsigned int   EMACxSA2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned STNADDR1:8;
    unsigned STNADDR2:8;
  };
  struct {
    unsigned w:32;
  };
} __EMACxSA2bits_t;
extern volatile __EMACxSA2bits_t EMACxSA2bits __asm__ ("EMACxSA2") __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA2CLR __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA2SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA2SET __attribute__((section("sfrs")));
extern volatile unsigned int        EMAC1SA2INV __attribute__((section("sfrs")));
extern volatile unsigned int        EMACxSA2INV __attribute__((section("sfrs")));
#define USBCRCON USBCRCON
extern volatile unsigned int   USBCRCON __attribute__((section("sfrs")));
typedef struct {
  unsigned USBWKUPEN:1;
  unsigned USBRIE:1;
  unsigned USBIE:1;
  unsigned SENDMONEN:1;
  unsigned BSVALMONEN:1;
  unsigned ASVALMONEN:1;
  unsigned VBUSMONEN:1;
  unsigned PHYIDEN:1;
  unsigned USBIDVAL:1;
  unsigned USBIDOVEN:1;
  unsigned :14;
  unsigned USBWKUP:1;
  unsigned USBRF:1;
  unsigned USBIF:1;
} __USBCRCONbits_t;
extern volatile __USBCRCONbits_t USBCRCONbits __asm__ ("USBCRCON") __attribute__((section("sfrs")));
#define PRECON PRECON
extern volatile unsigned int   PRECON __attribute__((section("sfrs")));
typedef struct {
  unsigned PFMWS:3;
  unsigned :1;
  unsigned PREFEN:2;
  unsigned :20;
  unsigned PFMSECEN:1;
} __PRECONbits_t;
extern volatile __PRECONbits_t PRECONbits __asm__ ("PRECON") __attribute__((section("sfrs")));
extern volatile unsigned int        PRECONCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PRECONSET __attribute__((section("sfrs")));
extern volatile unsigned int        PRECONINV __attribute__((section("sfrs")));
#define PRESTAT PRESTAT
extern volatile unsigned int   PRESTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned PFMSECCNT:8;
  unsigned :18;
  unsigned PFMSEC:1;
  unsigned PFMDED:1;
} __PRESTATbits_t;
extern volatile __PRESTATbits_t PRESTATbits __asm__ ("PRESTAT") __attribute__((section("sfrs")));
extern volatile unsigned int        PRESTATCLR __attribute__((section("sfrs")));
extern volatile unsigned int        PRESTATSET __attribute__((section("sfrs")));
extern volatile unsigned int        PRESTATINV __attribute__((section("sfrs")));
#define EBICS0 EBICS0
extern volatile unsigned int   EBICS0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned CSADDR:16;
} __EBICS0bits_t;
extern volatile __EBICS0bits_t EBICS0bits __asm__ ("EBICS0") __attribute__((section("sfrs")));
#define EBICS1 EBICS1
extern volatile unsigned int   EBICS1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned CSADDR:16;
} __EBICS1bits_t;
extern volatile __EBICS1bits_t EBICS1bits __asm__ ("EBICS1") __attribute__((section("sfrs")));
#define EBICS2 EBICS2
extern volatile unsigned int   EBICS2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned CSADDR:16;
} __EBICS2bits_t;
extern volatile __EBICS2bits_t EBICS2bits __asm__ ("EBICS2") __attribute__((section("sfrs")));
#define EBICS3 EBICS3
extern volatile unsigned int   EBICS3 __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned CSADDR:16;
} __EBICS3bits_t;
extern volatile __EBICS3bits_t EBICS3bits __asm__ ("EBICS3") __attribute__((section("sfrs")));
#define EBIMSK0 EBIMSK0
extern volatile unsigned int   EBIMSK0 __attribute__((section("sfrs")));
typedef struct {
  unsigned MEMSIZE:5;
  unsigned MEMTYPE:3;
  unsigned REGSEL:3;
} __EBIMSK0bits_t;
extern volatile __EBIMSK0bits_t EBIMSK0bits __asm__ ("EBIMSK0") __attribute__((section("sfrs")));
#define EBIMSK1 EBIMSK1
extern volatile unsigned int   EBIMSK1 __attribute__((section("sfrs")));
typedef struct {
  unsigned MEMSIZE:5;
  unsigned MEMTYPE:3;
  unsigned REGSEL:3;
} __EBIMSK1bits_t;
extern volatile __EBIMSK1bits_t EBIMSK1bits __asm__ ("EBIMSK1") __attribute__((section("sfrs")));
#define EBIMSK2 EBIMSK2
extern volatile unsigned int   EBIMSK2 __attribute__((section("sfrs")));
typedef struct {
  unsigned MEMSIZE:5;
  unsigned MEMTYPE:3;
  unsigned REGSEL:3;
} __EBIMSK2bits_t;
extern volatile __EBIMSK2bits_t EBIMSK2bits __asm__ ("EBIMSK2") __attribute__((section("sfrs")));
#define EBIMSK3 EBIMSK3
extern volatile unsigned int   EBIMSK3 __attribute__((section("sfrs")));
typedef struct {
  unsigned MEMSIZE:5;
  unsigned MEMTYPE:3;
  unsigned REGSEL:3;
} __EBIMSK3bits_t;
extern volatile __EBIMSK3bits_t EBIMSK3bits __asm__ ("EBIMSK3") __attribute__((section("sfrs")));
#define EBISMT0 EBISMT0
extern volatile unsigned int   EBISMT0 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRC:6;
  unsigned TAS:2;
  unsigned TWR:2;
  unsigned TWP:6;
  unsigned TBTA:3;
  unsigned TPRC:4;
  unsigned PAGEMODE:1;
  unsigned PAGESIZE:2;
  unsigned RDYMODE:1;
} __EBISMT0bits_t;
extern volatile __EBISMT0bits_t EBISMT0bits __asm__ ("EBISMT0") __attribute__((section("sfrs")));
#define EBISMT1 EBISMT1
extern volatile unsigned int   EBISMT1 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRC:6;
  unsigned TAS:2;
  unsigned TWR:2;
  unsigned TWP:6;
  unsigned TBTA:3;
  unsigned TPRC:4;
  unsigned PAGEMODE:1;
  unsigned PAGESIZE:2;
  unsigned RDYMODE:1;
} __EBISMT1bits_t;
extern volatile __EBISMT1bits_t EBISMT1bits __asm__ ("EBISMT1") __attribute__((section("sfrs")));
#define EBISMT2 EBISMT2
extern volatile unsigned int   EBISMT2 __attribute__((section("sfrs")));
typedef struct {
  unsigned TRC:6;
  unsigned TAS:2;
  unsigned TWR:2;
  unsigned TWP:6;
  unsigned TBTA:3;
  unsigned TPRC:4;
  unsigned PAGEMODE:1;
  unsigned PAGESIZE:2;
  unsigned RDYMODE:1;
} __EBISMT2bits_t;
extern volatile __EBISMT2bits_t EBISMT2bits __asm__ ("EBISMT2") __attribute__((section("sfrs")));
#define EBIFTRPD EBIFTRPD
extern volatile unsigned int   EBIFTRPD __attribute__((section("sfrs")));
typedef struct {
  unsigned TRPD:31;
} __EBIFTRPDbits_t;
extern volatile __EBIFTRPDbits_t EBIFTRPDbits __asm__ ("EBIFTRPD") __attribute__((section("sfrs")));
#define EBISMCON EBISMCON
extern volatile unsigned int   EBISMCON __attribute__((section("sfrs")));
typedef struct {
  unsigned SMRP:1;
  unsigned :6;
  unsigned SMDWIDTH0:3;
  unsigned SMDWIDTH1:3;
  unsigned SMDWIDTH2:3;
} __EBISMCONbits_t;
extern volatile __EBISMCONbits_t EBISMCONbits __asm__ ("EBISMCON") __attribute__((section("sfrs")));
#define SQI1XCON1 SQI1XCON1
extern volatile unsigned int   SQI1XCON1 __attribute__((section("sfrs")));
typedef struct {
  unsigned TYPECMD:2;
  unsigned TYPEADDR:2;
  unsigned TYPEMODE:2;
  unsigned TYPEDUMMY:2;
  unsigned TYPEDATA:2;
  unsigned READOPCODE:8;
  unsigned ADDRBYTES:3;
  unsigned DUMMYBYTES:3;
  unsigned DDRCMD:1;
  unsigned DDRADDR:1;
  unsigned DDRMODE:1;
  unsigned DDRDUMMY:1;
  unsigned DDRDATA:1;
  unsigned SDRCMD:1;
} __SQI1XCON1bits_t;
extern volatile __SQI1XCON1bits_t SQI1XCON1bits __asm__ ("SQI1XCON1") __attribute__((section("sfrs")));
#define SQI1XCON2 SQI1XCON2
extern volatile unsigned int   SQI1XCON2 __attribute__((section("sfrs")));
typedef struct {
  unsigned MODECODE:8;
  unsigned MODEBYTES:2;
  unsigned DEVSEL:2;
} __SQI1XCON2bits_t;
extern volatile __SQI1XCON2bits_t SQI1XCON2bits __asm__ ("SQI1XCON2") __attribute__((section("sfrs")));
#define SQI1CFG SQI1CFG
extern volatile unsigned int   SQI1CFG __attribute__((section("sfrs")));
typedef struct {
  unsigned MODE:3;
  unsigned CPHA:1;
  unsigned CPOL:1;
  unsigned LSBF:1;
  unsigned :3;
  unsigned WP:1;
  unsigned HOLD:1;
  unsigned :1;
  unsigned BURSTEN:1;
  unsigned :3;
  unsigned RESET:1;
  unsigned TXBUFRST:1;
  unsigned RXBUFRST:1;
  unsigned CONBUFRST:1;
  unsigned DATAEN:2;
  unsigned :1;
  unsigned SQIEN:1;
  unsigned CSEN:2;
} __SQI1CFGbits_t;
extern volatile __SQI1CFGbits_t SQI1CFGbits __asm__ ("SQI1CFG") __attribute__((section("sfrs")));
#define SQI1CON SQI1CON
extern volatile unsigned int   SQI1CON __attribute__((section("sfrs")));
typedef struct {
  unsigned TXRXCOUNT:16;
  unsigned CMDINIT:2;
  unsigned LANEMODE:2;
  unsigned DEVSEL:2;
  unsigned DASSERT:1;
  unsigned DDRMODE:1;
  unsigned SCHECK:1;
} __SQI1CONbits_t;
extern volatile __SQI1CONbits_t SQI1CONbits __asm__ ("SQI1CON") __attribute__((section("sfrs")));
#define SQI1CLKCON SQI1CLKCON
extern volatile unsigned int   SQI1CLKCON __attribute__((section("sfrs")));
typedef struct {
  unsigned EN:1;
  unsigned STABLE:1;
  unsigned :6;
  unsigned CLKDIV:11;
} __SQI1CLKCONbits_t;
extern volatile __SQI1CLKCONbits_t SQI1CLKCONbits __asm__ ("SQI1CLKCON") __attribute__((section("sfrs")));
#define SQI1CMDTHR SQI1CMDTHR
extern volatile unsigned int   SQI1CMDTHR __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCMDTHR:6;
  unsigned :2;
  unsigned TXCMDTHR:6;
} __SQI1CMDTHRbits_t;
extern volatile __SQI1CMDTHRbits_t SQI1CMDTHRbits __asm__ ("SQI1CMDTHR") __attribute__((section("sfrs")));
#define SQI1INTTHR SQI1INTTHR
extern volatile unsigned int   SQI1INTTHR __attribute__((section("sfrs")));
typedef struct {
  unsigned RXINTTHR:6;
  unsigned :2;
  unsigned TXINTTHR:6;
} __SQI1INTTHRbits_t;
extern volatile __SQI1INTTHRbits_t SQI1INTTHRbits __asm__ ("SQI1INTTHR") __attribute__((section("sfrs")));
#define SQI1INTEN SQI1INTEN
extern volatile unsigned int   SQI1INTEN __attribute__((section("sfrs")));
typedef struct {
  unsigned TXEMPTYIE:1;
  unsigned TXFULLIE:1;
  unsigned TXTHRIE:1;
  unsigned RXEMPTYIE:1;
  unsigned RXFULLIE:1;
  unsigned RXTHRIE:1;
  unsigned CONFULLIE:1;
  unsigned CONEMPTYIE:1;
  unsigned CONTHRIE:1;
  unsigned BDDONEIE:1;
  unsigned PKTCOMPIE:1;
  unsigned DMAEIE:1;
} __SQI1INTENbits_t;
extern volatile __SQI1INTENbits_t SQI1INTENbits __asm__ ("SQI1INTEN") __attribute__((section("sfrs")));
#define SQI1INTSTAT SQI1INTSTAT
extern volatile unsigned int   SQI1INTSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned TXEMPTYIF:1;
  unsigned TXFULLIF:1;
  unsigned TXTHRIF:1;
  unsigned RXEMPTYIF:1;
  unsigned RXFULLIF:1;
  unsigned RXTHRIF:1;
  unsigned CONFULLIF:1;
  unsigned CONEMPTYIF:1;
  unsigned CONTHRIF:1;
  unsigned BDDONEIF:1;
  unsigned PKTCOMPIF:1;
  unsigned DMAEIF:1;
} __SQI1INTSTATbits_t;
extern volatile __SQI1INTSTATbits_t SQI1INTSTATbits __asm__ ("SQI1INTSTAT") __attribute__((section("sfrs")));
#define SQI1TXDATA SQI1TXDATA
extern volatile unsigned int   SQI1TXDATA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXDATA:32;
} __SQI1TXDATAbits_t;
extern volatile __SQI1TXDATAbits_t SQI1TXDATAbits __asm__ ("SQI1TXDATA") __attribute__((section("sfrs")));
#define SQI1RXDATA SQI1RXDATA
extern volatile unsigned int   SQI1RXDATA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXDATA:32;
} __SQI1RXDATAbits_t;
extern volatile __SQI1RXDATAbits_t SQI1RXDATAbits __asm__ ("SQI1RXDATA") __attribute__((section("sfrs")));
#define SQI1STAT1 SQI1STAT1
extern volatile unsigned int   SQI1STAT1 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXBUFCNT:6;
  unsigned :10;
  unsigned TXBUFFREE:6;
} __SQI1STAT1bits_t;
extern volatile __SQI1STAT1bits_t SQI1STAT1bits __asm__ ("SQI1STAT1") __attribute__((section("sfrs")));
#define SQI1STAT2 SQI1STAT2
extern volatile unsigned int   SQI1STAT2 __attribute__((section("sfrs")));
typedef struct {
  unsigned TXOV:1;
  unsigned RXUN:1;
  unsigned :1;
  unsigned SQID0:1;
  unsigned SQID1:1;
  unsigned SQID2:1;
  unsigned SQID3:1;
  unsigned CONAVAIL:4;
  unsigned :5;
  unsigned CMDSTAT:2;
} __SQI1STAT2bits_t;
extern volatile __SQI1STAT2bits_t SQI1STAT2bits __asm__ ("SQI1STAT2") __attribute__((section("sfrs")));
#define SQI1BDCON SQI1BDCON
extern volatile unsigned int   SQI1BDCON __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned POLLEN:1;
  unsigned START:1;
} __SQI1BDCONbits_t;
extern volatile __SQI1BDCONbits_t SQI1BDCONbits __asm__ ("SQI1BDCON") __attribute__((section("sfrs")));
#define SQI1BDCURADD SQI1BDCURADD
extern volatile unsigned int   SQI1BDCURADD __attribute__((section("sfrs")));
typedef struct {
  unsigned BDCURRADDR:32;
} __SQI1BDCURADDbits_t;
extern volatile __SQI1BDCURADDbits_t SQI1BDCURADDbits __asm__ ("SQI1BDCURADD") __attribute__((section("sfrs")));
#define SQI1BDBASEADD SQI1BDBASEADD
extern volatile unsigned int   SQI1BDBASEADD __attribute__((section("sfrs")));
typedef struct {
  unsigned BDADDR:32;
} __SQI1BDBASEADDbits_t;
extern volatile __SQI1BDBASEADDbits_t SQI1BDBASEADDbits __asm__ ("SQI1BDBASEADD") __attribute__((section("sfrs")));
#define SQI1BDSTAT SQI1BDSTAT
extern volatile unsigned int   SQI1BDSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned BDCON:16;
  unsigned DMAACTV:1;
  unsigned DMASTART:1;
  unsigned BDSTATE:4;
} __SQI1BDSTATbits_t;
extern volatile __SQI1BDSTATbits_t SQI1BDSTATbits __asm__ ("SQI1BDSTAT") __attribute__((section("sfrs")));
#define SQI1BDPOLLCON SQI1BDPOLLCON
extern volatile unsigned int   SQI1BDPOLLCON __attribute__((section("sfrs")));
typedef struct {
  unsigned POLLCON:16;
} __SQI1BDPOLLCONbits_t;
extern volatile __SQI1BDPOLLCONbits_t SQI1BDPOLLCONbits __asm__ ("SQI1BDPOLLCON") __attribute__((section("sfrs")));
#define SQI1BDTXDSTAT SQI1BDTXDSTAT
extern volatile unsigned int   SQI1BDTXDSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned TXCURBUFLEN:9;
  unsigned :7;
  unsigned TXBUFCNT:5;
  unsigned :4;
  unsigned TXSTATE:4;
} __SQI1BDTXDSTATbits_t;
extern volatile __SQI1BDTXDSTATbits_t SQI1BDTXDSTATbits __asm__ ("SQI1BDTXDSTAT") __attribute__((section("sfrs")));
#define SQI1BDRXDSTAT SQI1BDRXDSTAT
extern volatile unsigned int   SQI1BDRXDSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCURBUFLEN:9;
  unsigned :7;
  unsigned RXBUFCNT:5;
  unsigned :4;
  unsigned RXSTATE:4;
} __SQI1BDRXDSTATbits_t;
extern volatile __SQI1BDRXDSTATbits_t SQI1BDRXDSTATbits __asm__ ("SQI1BDRXDSTAT") __attribute__((section("sfrs")));
#define SQI1THR SQI1THR
extern volatile unsigned int   SQI1THR __attribute__((section("sfrs")));
typedef struct {
  unsigned THRES:4;
} __SQI1THRbits_t;
extern volatile __SQI1THRbits_t SQI1THRbits __asm__ ("SQI1THR") __attribute__((section("sfrs")));
#define SQI1INTSIGEN SQI1INTSIGEN
extern volatile unsigned int   SQI1INTSIGEN __attribute__((section("sfrs")));
typedef struct {
  unsigned TXEMPTYISE:1;
  unsigned TXFULLISE:1;
  unsigned TXTHRISE:1;
  unsigned RXEMPTYISE:1;
  unsigned RXFULLISE:1;
  unsigned RXTHRISE:1;
  unsigned CONFULLISE:1;
  unsigned CONEMPTYISE:1;
  unsigned CONTHRISE:1;
  unsigned BDDONEISE:1;
  unsigned PKTCOMPISE:1;
  unsigned DMAEISE:1;
} __SQI1INTSIGENbits_t;
extern volatile __SQI1INTSIGENbits_t SQI1INTSIGENbits __asm__ ("SQI1INTSIGEN") __attribute__((section("sfrs")));
#define SQI1TAPCON SQI1TAPCON
extern volatile unsigned int   SQI1TAPCON __attribute__((section("sfrs")));
typedef struct {
  unsigned CLKOUTDLY:4;
  unsigned DATAOUTDLY:4;
  unsigned SDRCLKINDLY:6;
} __SQI1TAPCONbits_t;
extern volatile __SQI1TAPCONbits_t SQI1TAPCONbits __asm__ ("SQI1TAPCON") __attribute__((section("sfrs")));
#define SQI1MEMSTAT SQI1MEMSTAT
extern volatile unsigned int   SQI1MEMSTAT __attribute__((section("sfrs")));
typedef struct {
  unsigned STATCMD:16;
  unsigned STATBYTES:2;
  unsigned STATTYPE:2;
  unsigned STATPOS:1;
} __SQI1MEMSTATbits_t;
extern volatile __SQI1MEMSTATbits_t SQI1MEMSTATbits __asm__ ("SQI1MEMSTAT") __attribute__((section("sfrs")));
#define SQI1XCON3 SQI1XCON3
extern volatile unsigned int   SQI1XCON3 __attribute__((section("sfrs")));
typedef struct {
  unsigned INIT1CMD1:8;
  unsigned INIT1CMD2:8;
  unsigned INIT1CMD3:8;
  unsigned INIT1TYPE:2;
  unsigned INIT1COUNT:2;
  unsigned INIT1SCHECK:1;
} __SQI1XCON3bits_t;
extern volatile __SQI1XCON3bits_t SQI1XCON3bits __asm__ ("SQI1XCON3") __attribute__((section("sfrs")));
#define SQI1XCON4 SQI1XCON4
extern volatile unsigned int   SQI1XCON4 __attribute__((section("sfrs")));
typedef struct {
  unsigned INIT2CMD1:8;
  unsigned INIT2CMD2:8;
  unsigned INIT2CMD3:8;
  unsigned INIT2TYPE:2;
  unsigned INIT2COUNT:2;
  unsigned INIT2SCHECK:1;
} __SQI1XCON4bits_t;
extern volatile __SQI1XCON4bits_t SQI1XCON4bits __asm__ ("SQI1XCON4") __attribute__((section("sfrs")));
#define USBCSR0 USBCSR0
extern volatile unsigned int   USBCSR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned FUNC:7;
  unsigned :1;
  unsigned SUSPEN:1;
  unsigned SUSPMODE:1;
  unsigned RESUME:1;
  unsigned RESET:1;
  unsigned HSMODE:1;
  unsigned HSEN:1;
  unsigned SOFTCONN:1;
  unsigned ISOUPD:1;
  unsigned EP0IF:1;
  unsigned EP1TXIF:1;
  unsigned EP2TXIF:1;
  unsigned EP3TXIF:1;
  unsigned EP4TXIF:1;
  unsigned EP5TXIF:1;
  unsigned EP6TXIF:1;
  unsigned EP7TXIF:1;
} __USBCSR0bits_t;
extern volatile __USBCSR0bits_t USBCSR0bits __asm__ ("USBCSR0") __attribute__((section("sfrs")));
#define USBCSR1 USBCSR1
extern volatile unsigned int   USBCSR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned EP1RXIF:1;
  unsigned EP2RXIF:1;
  unsigned EP3RXIF:1;
  unsigned EP4RXIF:1;
  unsigned EP5RXIF:1;
  unsigned EP6RXIF:1;
  unsigned EP7RXIF:1;
  unsigned :8;
  unsigned EP0IE:1;
  unsigned EP1TXIE:1;
  unsigned EP2TXIE:1;
  unsigned EP3TXIE:1;
  unsigned EP4TXIE:1;
  unsigned EP5TXIE:1;
  unsigned EP6TXIE:1;
  unsigned EP7TXIE:1;
} __USBCSR1bits_t;
extern volatile __USBCSR1bits_t USBCSR1bits __asm__ ("USBCSR1") __attribute__((section("sfrs")));
#define USBCSR2 USBCSR2
extern volatile unsigned int   USBCSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned EP1RXIE:1;
  unsigned EP2RXIE:1;
  unsigned EP3RXIE:1;
  unsigned EP4RXIE:1;
  unsigned EP5RXIE:1;
  unsigned EP6RXIE:1;
  unsigned EP7RXIE:1;
  unsigned :8;
  unsigned SUSPIF:1;
  unsigned RESUMEIF:1;
  unsigned RESETIF:1;
  unsigned SOFIF:1;
  unsigned CONNIF:1;
  unsigned DISCONIF:1;
  unsigned SESSRQIF:1;
  unsigned VBUSERRIF:1;
  unsigned SUSPIE:1;
  unsigned RESUMEIE:1;
  unsigned RESETIE:1;
  unsigned SOFIE:1;
  unsigned CONNIE:1;
  unsigned DISCONIE:1;
  unsigned SESSRQIE:1;
  unsigned VBUSERRIE:1;
} __USBCSR2bits_t;
extern volatile __USBCSR2bits_t USBCSR2bits __asm__ ("USBCSR2") __attribute__((section("sfrs")));
#define USBCSR3 USBCSR3
extern volatile unsigned int   USBCSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned RFRMNUM:11;
  unsigned :5;
  unsigned ENDPOINT:4;
  unsigned :4;
  unsigned NAK:1;
  unsigned TESTJ:1;
  unsigned TESTK:1;
  unsigned PACKET:1;
  unsigned FORCEHS:1;
  unsigned FORCEFS:1;
  unsigned FIFOACC:1;
  unsigned FORCEHST:1;
} __USBCSR3bits_t;
extern volatile __USBCSR3bits_t USBCSR3bits __asm__ ("USBCSR3") __attribute__((section("sfrs")));
#define USBIENCSR0 USBIENCSR0
extern volatile unsigned int   USBIENCSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBIENCSR0bits_t;
extern volatile __USBIENCSR0bits_t USBIENCSR0bits __asm__ ("USBIENCSR0") __attribute__((section("sfrs")));
#define USBIENCSR1 USBIENCSR1
extern volatile unsigned int   USBIENCSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned OVERRUN:1;
    unsigned DATAERR:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :5;
    unsigned DISNYET:1;
    unsigned :1;
    unsigned ISO:1;
  };
} __USBIENCSR1bits_t;
extern volatile __USBIENCSR1bits_t USBIENCSR1bits __asm__ ("USBIENCSR1") __attribute__((section("sfrs")));
#define USBIENCSR2 USBIENCSR2
extern volatile unsigned int   USBIENCSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBIENCSR2bits_t;
extern volatile __USBIENCSR2bits_t USBIENCSR2bits __asm__ ("USBIENCSR2") __attribute__((section("sfrs")));
#define USBIENCSR3 USBIENCSR3
extern volatile unsigned int   USBIENCSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBIENCSR3bits_t;
extern volatile __USBIENCSR3bits_t USBIENCSR3bits __asm__ ("USBIENCSR3") __attribute__((section("sfrs")));
#define USBFIFO0 USBFIFO0
extern volatile unsigned int   USBFIFO0 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO0bits_t;
extern volatile __USBFIFO0bits_t USBFIFO0bits __asm__ ("USBFIFO0") __attribute__((section("sfrs")));
#define USBFIFO1 USBFIFO1
extern volatile unsigned int   USBFIFO1 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO1bits_t;
extern volatile __USBFIFO1bits_t USBFIFO1bits __asm__ ("USBFIFO1") __attribute__((section("sfrs")));
#define USBFIFO2 USBFIFO2
extern volatile unsigned int   USBFIFO2 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO2bits_t;
extern volatile __USBFIFO2bits_t USBFIFO2bits __asm__ ("USBFIFO2") __attribute__((section("sfrs")));
#define USBFIFO3 USBFIFO3
extern volatile unsigned int   USBFIFO3 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO3bits_t;
extern volatile __USBFIFO3bits_t USBFIFO3bits __asm__ ("USBFIFO3") __attribute__((section("sfrs")));
#define USBFIFO4 USBFIFO4
extern volatile unsigned int   USBFIFO4 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO4bits_t;
extern volatile __USBFIFO4bits_t USBFIFO4bits __asm__ ("USBFIFO4") __attribute__((section("sfrs")));
#define USBFIFO5 USBFIFO5
extern volatile unsigned int   USBFIFO5 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO5bits_t;
extern volatile __USBFIFO5bits_t USBFIFO5bits __asm__ ("USBFIFO5") __attribute__((section("sfrs")));
#define USBFIFO6 USBFIFO6
extern volatile unsigned int   USBFIFO6 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO6bits_t;
extern volatile __USBFIFO6bits_t USBFIFO6bits __asm__ ("USBFIFO6") __attribute__((section("sfrs")));
#define USBFIFO7 USBFIFO7
extern volatile unsigned int   USBFIFO7 __attribute__((section("sfrs")));
typedef struct {
  unsigned DATA:32;
} __USBFIFO7bits_t;
extern volatile __USBFIFO7bits_t USBFIFO7bits __asm__ ("USBFIFO7") __attribute__((section("sfrs")));
#define USBOTG USBOTG
extern volatile unsigned int   USBOTG __attribute__((section("sfrs")));
typedef struct {
  unsigned SESSION:1;
  unsigned HOSTREQ:1;
  unsigned HOSTMODE:1;
  unsigned VBUS:2;
  unsigned LSDEV:1;
  unsigned FSDEV:1;
  unsigned BDEV:1;
  unsigned RXEDMA:1;
  unsigned TXEDMA:1;
  unsigned :6;
  unsigned TXFIFOSZ:4;
  unsigned TXDPB:1;
  unsigned :3;
  unsigned RXFIFOSZ:4;
  unsigned RXDPB:1;
} __USBOTGbits_t;
extern volatile __USBOTGbits_t USBOTGbits __asm__ ("USBOTG") __attribute__((section("sfrs")));
#define USBFIFOA USBFIFOA
extern volatile unsigned int   USBFIFOA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFIFOAD:13;
  unsigned :3;
  unsigned RXFIFOAD:13;
} __USBFIFOAbits_t;
extern volatile __USBFIFOAbits_t USBFIFOAbits __asm__ ("USBFIFOA") __attribute__((section("sfrs")));
#define USBHWVER USBHWVER
extern volatile unsigned int   USBHWVER __attribute__((section("sfrs")));
typedef struct {
  unsigned VERMINOR:10;
  unsigned VERMAJOR:5;
  unsigned RC:1;
} __USBHWVERbits_t;
extern volatile __USBHWVERbits_t USBHWVERbits __asm__ ("USBHWVER") __attribute__((section("sfrs")));
#define USBINFO USBINFO
extern volatile unsigned int   USBINFO __attribute__((section("sfrs")));
typedef struct {
  unsigned TXENDPTS:4;
  unsigned RXENDPTS:4;
  unsigned RAMBITS:4;
  unsigned DMACHANS:4;
  unsigned WTID:4;
  unsigned WTCON:4;
  unsigned VPLEN:8;
} __USBINFObits_t;
extern volatile __USBINFObits_t USBINFObits __asm__ ("USBINFO") __attribute__((section("sfrs")));
#define USBEOFRST USBEOFRST
extern volatile unsigned int   USBEOFRST __attribute__((section("sfrs")));
typedef struct {
  unsigned HSEOF:8;
  unsigned FSEOF:8;
  unsigned LSEOF:8;
  unsigned SOFRST:8;
} __USBEOFRSTbits_t;
extern volatile __USBEOFRSTbits_t USBEOFRSTbits __asm__ ("USBEOFRST") __attribute__((section("sfrs")));
#define USBE0TXA USBE0TXA
extern volatile unsigned int   USBE0TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE0TXAbits_t;
extern volatile __USBE0TXAbits_t USBE0TXAbits __asm__ ("USBE0TXA") __attribute__((section("sfrs")));
#define USBE0RXA USBE0RXA
extern volatile unsigned int   USBE0RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned :16;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE0RXAbits_t;
extern volatile __USBE0RXAbits_t USBE0RXAbits __asm__ ("USBE0RXA") __attribute__((section("sfrs")));
#define USBE1TXA USBE1TXA
extern volatile unsigned int   USBE1TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE1TXAbits_t;
extern volatile __USBE1TXAbits_t USBE1TXAbits __asm__ ("USBE1TXA") __attribute__((section("sfrs")));
#define USBE1RXA USBE1RXA
extern volatile unsigned int   USBE1RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE1RXAbits_t;
extern volatile __USBE1RXAbits_t USBE1RXAbits __asm__ ("USBE1RXA") __attribute__((section("sfrs")));
#define USBE2TXA USBE2TXA
extern volatile unsigned int   USBE2TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE2TXAbits_t;
extern volatile __USBE2TXAbits_t USBE2TXAbits __asm__ ("USBE2TXA") __attribute__((section("sfrs")));
#define USBE2RXA USBE2RXA
extern volatile unsigned int   USBE2RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE2RXAbits_t;
extern volatile __USBE2RXAbits_t USBE2RXAbits __asm__ ("USBE2RXA") __attribute__((section("sfrs")));
#define USBE3TXA USBE3TXA
extern volatile unsigned int   USBE3TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE3TXAbits_t;
extern volatile __USBE3TXAbits_t USBE3TXAbits __asm__ ("USBE3TXA") __attribute__((section("sfrs")));
#define USBE3RXA USBE3RXA
extern volatile unsigned int   USBE3RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE3RXAbits_t;
extern volatile __USBE3RXAbits_t USBE3RXAbits __asm__ ("USBE3RXA") __attribute__((section("sfrs")));
#define USBE4TXA USBE4TXA
extern volatile unsigned int   USBE4TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE4TXAbits_t;
extern volatile __USBE4TXAbits_t USBE4TXAbits __asm__ ("USBE4TXA") __attribute__((section("sfrs")));
#define USBE4RXA USBE4RXA
extern volatile unsigned int   USBE4RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE4RXAbits_t;
extern volatile __USBE4RXAbits_t USBE4RXAbits __asm__ ("USBE4RXA") __attribute__((section("sfrs")));
#define USBE5TXA USBE5TXA
extern volatile unsigned int   USBE5TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE5TXAbits_t;
extern volatile __USBE5TXAbits_t USBE5TXAbits __asm__ ("USBE5TXA") __attribute__((section("sfrs")));
#define USBE5RXA USBE5RXA
extern volatile unsigned int   USBE5RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE5RXAbits_t;
extern volatile __USBE5RXAbits_t USBE5RXAbits __asm__ ("USBE5RXA") __attribute__((section("sfrs")));
#define USBE6TXA USBE6TXA
extern volatile unsigned int   USBE6TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE6TXAbits_t;
extern volatile __USBE6TXAbits_t USBE6TXAbits __asm__ ("USBE6TXA") __attribute__((section("sfrs")));
#define USBE6RXA USBE6RXA
extern volatile unsigned int   USBE6RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE6RXAbits_t;
extern volatile __USBE6RXAbits_t USBE6RXAbits __asm__ ("USBE6RXA") __attribute__((section("sfrs")));
#define USBE7TXA USBE7TXA
extern volatile unsigned int   USBE7TXA __attribute__((section("sfrs")));
typedef struct {
  unsigned TXFADDR:7;
  unsigned :9;
  unsigned TXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned TXHUBPRT:7;
} __USBE7TXAbits_t;
extern volatile __USBE7TXAbits_t USBE7TXAbits __asm__ ("USBE7TXA") __attribute__((section("sfrs")));
#define USBE7RXA USBE7RXA
extern volatile unsigned int   USBE7RXA __attribute__((section("sfrs")));
typedef struct {
  unsigned RXFADDR:7;
  unsigned :9;
  unsigned RXHUBADD:7;
  unsigned MULTTRAN:1;
  unsigned RXHUBPRT:7;
} __USBE7RXAbits_t;
extern volatile __USBE7RXAbits_t USBE7RXAbits __asm__ ("USBE7RXA") __attribute__((section("sfrs")));
#define USBE0CSR0 USBE0CSR0
extern volatile unsigned int   USBE0CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned :5;
    unsigned RXRDY:1;
    unsigned TXRDY:1;
    unsigned STALLED:1;
    unsigned SETUP:1;
    unsigned ERROR:1;
    unsigned REQPKT:1;
    unsigned STATUS:1;
    unsigned NAKTO:1;
    unsigned FLUSH:1;
    unsigned DT:1;
    unsigned DTWE:1;
  };
  struct {
    unsigned :19;
    unsigned DATAEND:1;
    unsigned SETEND:1;
    unsigned STALL:1;
    unsigned RXRDYC:1;
    unsigned SETENDC:1;
  };
} __USBE0CSR0bits_t;
extern volatile __USBE0CSR0bits_t USBE0CSR0bits __asm__ ("USBE0CSR0") __attribute__((section("sfrs")));
#define USBE0CSR2 USBE0CSR2
extern volatile unsigned int   USBE0CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:7;
  unsigned :15;
  unsigned SPEED:2;
  unsigned NAKLIM:4;
} __USBE0CSR2bits_t;
extern volatile __USBE0CSR2bits_t USBE0CSR2bits __asm__ ("USBE0CSR2") __attribute__((section("sfrs")));
#define USBE0CSR3 USBE0CSR3
extern volatile unsigned int   USBE0CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned UTMIDWID:1;
  unsigned SOFTCONE:1;
  unsigned DYNFIFOS:1;
  unsigned HBTXEN:1;
  unsigned HBRXEN:1;
  unsigned BIGEND:1;
  unsigned MPTXEN:1;
  unsigned MPRXEN:1;
} __USBE0CSR3bits_t;
extern volatile __USBE0CSR3bits_t USBE0CSR3bits __asm__ ("USBE0CSR3") __attribute__((section("sfrs")));
#define USBE1CSR0 USBE1CSR0
extern volatile unsigned int   USBE1CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE1CSR0bits_t;
extern volatile __USBE1CSR0bits_t USBE1CSR0bits __asm__ ("USBE1CSR0") __attribute__((section("sfrs")));
#define USBE1CSR1 USBE1CSR1
extern volatile unsigned int   USBE1CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE1CSR1bits_t;
extern volatile __USBE1CSR1bits_t USBE1CSR1bits __asm__ ("USBE1CSR1") __attribute__((section("sfrs")));
#define USBE1CSR2 USBE1CSR2
extern volatile unsigned int   USBE1CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE1CSR2bits_t;
extern volatile __USBE1CSR2bits_t USBE1CSR2bits __asm__ ("USBE1CSR2") __attribute__((section("sfrs")));
#define USBE1CSR3 USBE1CSR3
extern volatile unsigned int   USBE1CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE1CSR3bits_t;
extern volatile __USBE1CSR3bits_t USBE1CSR3bits __asm__ ("USBE1CSR3") __attribute__((section("sfrs")));
#define USBE2CSR0 USBE2CSR0
extern volatile unsigned int   USBE2CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE2CSR0bits_t;
extern volatile __USBE2CSR0bits_t USBE2CSR0bits __asm__ ("USBE2CSR0") __attribute__((section("sfrs")));
#define USBE2CSR1 USBE2CSR1
extern volatile unsigned int   USBE2CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE2CSR1bits_t;
extern volatile __USBE2CSR1bits_t USBE2CSR1bits __asm__ ("USBE2CSR1") __attribute__((section("sfrs")));
#define USBE2CSR2 USBE2CSR2
extern volatile unsigned int   USBE2CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE2CSR2bits_t;
extern volatile __USBE2CSR2bits_t USBE2CSR2bits __asm__ ("USBE2CSR2") __attribute__((section("sfrs")));
#define USBE2CSR3 USBE2CSR3
extern volatile unsigned int   USBE2CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE2CSR3bits_t;
extern volatile __USBE2CSR3bits_t USBE2CSR3bits __asm__ ("USBE2CSR3") __attribute__((section("sfrs")));
#define USBE3CSR0 USBE3CSR0
extern volatile unsigned int   USBE3CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE3CSR0bits_t;
extern volatile __USBE3CSR0bits_t USBE3CSR0bits __asm__ ("USBE3CSR0") __attribute__((section("sfrs")));
#define USBE3CSR1 USBE3CSR1
extern volatile unsigned int   USBE3CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE3CSR1bits_t;
extern volatile __USBE3CSR1bits_t USBE3CSR1bits __asm__ ("USBE3CSR1") __attribute__((section("sfrs")));
#define USBE3CSR2 USBE3CSR2
extern volatile unsigned int   USBE3CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE3CSR2bits_t;
extern volatile __USBE3CSR2bits_t USBE3CSR2bits __asm__ ("USBE3CSR2") __attribute__((section("sfrs")));
#define USBE3CSR3 USBE3CSR3
extern volatile unsigned int   USBE3CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE3CSR3bits_t;
extern volatile __USBE3CSR3bits_t USBE3CSR3bits __asm__ ("USBE3CSR3") __attribute__((section("sfrs")));
#define USBE4CSR0 USBE4CSR0
extern volatile unsigned int   USBE4CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE4CSR0bits_t;
extern volatile __USBE4CSR0bits_t USBE4CSR0bits __asm__ ("USBE4CSR0") __attribute__((section("sfrs")));
#define USBE4CSR1 USBE4CSR1
extern volatile unsigned int   USBE4CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE4CSR1bits_t;
extern volatile __USBE4CSR1bits_t USBE4CSR1bits __asm__ ("USBE4CSR1") __attribute__((section("sfrs")));
#define USBE4CSR2 USBE4CSR2
extern volatile unsigned int   USBE4CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE4CSR2bits_t;
extern volatile __USBE4CSR2bits_t USBE4CSR2bits __asm__ ("USBE4CSR2") __attribute__((section("sfrs")));
#define USBE4CSR3 USBE4CSR3
extern volatile unsigned int   USBE4CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE4CSR3bits_t;
extern volatile __USBE4CSR3bits_t USBE4CSR3bits __asm__ ("USBE4CSR3") __attribute__((section("sfrs")));
#define USBE5CSR0 USBE5CSR0
extern volatile unsigned int   USBE5CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE5CSR0bits_t;
extern volatile __USBE5CSR0bits_t USBE5CSR0bits __asm__ ("USBE5CSR0") __attribute__((section("sfrs")));
#define USBE5CSR1 USBE5CSR1
extern volatile unsigned int   USBE5CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE5CSR1bits_t;
extern volatile __USBE5CSR1bits_t USBE5CSR1bits __asm__ ("USBE5CSR1") __attribute__((section("sfrs")));
#define USBE5CSR2 USBE5CSR2
extern volatile unsigned int   USBE5CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE5CSR2bits_t;
extern volatile __USBE5CSR2bits_t USBE5CSR2bits __asm__ ("USBE5CSR2") __attribute__((section("sfrs")));
#define USBE5CSR3 USBE5CSR3
extern volatile unsigned int   USBE5CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE5CSR3bits_t;
extern volatile __USBE5CSR3bits_t USBE5CSR3bits __asm__ ("USBE5CSR3") __attribute__((section("sfrs")));
#define USBE6CSR0 USBE6CSR0
extern volatile unsigned int   USBE6CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE6CSR0bits_t;
extern volatile __USBE6CSR0bits_t USBE6CSR0bits __asm__ ("USBE6CSR0") __attribute__((section("sfrs")));
#define USBE6CSR1 USBE6CSR1
extern volatile unsigned int   USBE6CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE6CSR1bits_t;
extern volatile __USBE6CSR1bits_t USBE6CSR1bits __asm__ ("USBE6CSR1") __attribute__((section("sfrs")));
#define USBE6CSR2 USBE6CSR2
extern volatile unsigned int   USBE6CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE6CSR2bits_t;
extern volatile __USBE6CSR2bits_t USBE6CSR2bits __asm__ ("USBE6CSR2") __attribute__((section("sfrs")));
#define USBE6CSR3 USBE6CSR3
extern volatile unsigned int   USBE6CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE6CSR3bits_t;
extern volatile __USBE6CSR3bits_t USBE6CSR3bits __asm__ ("USBE6CSR3") __attribute__((section("sfrs")));
#define USBE7CSR0 USBE7CSR0
extern volatile unsigned int   USBE7CSR0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TXMAXP:11;
    unsigned MULT:5;
    unsigned TXPKTRDY:1;
    unsigned FIFONE:1;
    unsigned ERROR:1;
    unsigned FLUSH:1;
    unsigned SETUPPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned NAKTMOUT:1;
    unsigned DATATGGL:1;
    unsigned DTWREN:1;
    unsigned DMAREQMD:1;
    unsigned FRCDATTG:1;
    unsigned DMAREQEN:1;
    unsigned MODE:1;
    unsigned :1;
    unsigned AUTOSET:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE7CSR0bits_t;
extern volatile __USBE7CSR0bits_t USBE7CSR0bits __asm__ ("USBE7CSR0") __attribute__((section("sfrs")));
#define USBE7CSR1 USBE7CSR1
extern volatile unsigned int   USBE7CSR1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned RXMAXP:11;
    unsigned MULT:5;
    unsigned RXPKTRDY:1;
    unsigned FIFOFULL:1;
    unsigned ERROR:1;
    unsigned DERRNAKT:1;
    unsigned FLUSH:1;
    unsigned REQPKT:1;
    unsigned RXSTALL:1;
    unsigned CLRDT:1;
    unsigned INCOMPRX:1;
    unsigned DATATGGL:1;
    unsigned DATATWEN:1;
    unsigned DMAREQMD:1;
    unsigned PIDERR:1;
    unsigned DMAREQEN:1;
    unsigned AUTORQ:1;
    unsigned AUTOCLR:1;
  };
  struct {
    unsigned :18;
    unsigned UNDERRUN:1;
    unsigned :1;
    unsigned SENDSTALL:1;
    unsigned SENTSTALL:1;
    unsigned :1;
    unsigned INCOMPTX:1;
    unsigned :6;
    unsigned ISO:1;
  };
} __USBE7CSR1bits_t;
extern volatile __USBE7CSR1bits_t USBE7CSR1bits __asm__ ("USBE7CSR1") __attribute__((section("sfrs")));
#define USBE7CSR2 USBE7CSR2
extern volatile unsigned int   USBE7CSR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RXCNT:14;
  unsigned :2;
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned TXINTERV:8;
} __USBE7CSR2bits_t;
extern volatile __USBE7CSR2bits_t USBE7CSR2bits __asm__ ("USBE7CSR2") __attribute__((section("sfrs")));
#define USBE7CSR3 USBE7CSR3
extern volatile unsigned int   USBE7CSR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned TEP:4;
  unsigned PROTOCOL:2;
  unsigned SPEED:2;
  unsigned RXINTERV:8;
  unsigned :8;
  unsigned TXFIFOSZ:4;
  unsigned RXFIFOSZ:4;
} __USBE7CSR3bits_t;
extern volatile __USBE7CSR3bits_t USBE7CSR3bits __asm__ ("USBE7CSR3") __attribute__((section("sfrs")));
#define USBDMAINT USBDMAINT
extern volatile unsigned int   USBDMAINT __attribute__((section("sfrs")));
typedef struct {
  unsigned DMA1IF:1;
  unsigned DMA2IF:1;
  unsigned DMA3IF:1;
  unsigned DMA4IF:1;
  unsigned DMA5IF:1;
  unsigned DMA6IF:1;
  unsigned DMA7IF:1;
  unsigned DMA8IF:1;
} __USBDMAINTbits_t;
extern volatile __USBDMAINTbits_t USBDMAINTbits __asm__ ("USBDMAINT") __attribute__((section("sfrs")));
#define USBDMA1C USBDMA1C
extern volatile unsigned int   USBDMA1C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA1Cbits_t;
extern volatile __USBDMA1Cbits_t USBDMA1Cbits __asm__ ("USBDMA1C") __attribute__((section("sfrs")));
#define USBDMA1A USBDMA1A
extern volatile unsigned int   USBDMA1A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA1Abits_t;
extern volatile __USBDMA1Abits_t USBDMA1Abits __asm__ ("USBDMA1A") __attribute__((section("sfrs")));
#define USBDMA1N USBDMA1N
extern volatile unsigned int   USBDMA1N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA1Nbits_t;
extern volatile __USBDMA1Nbits_t USBDMA1Nbits __asm__ ("USBDMA1N") __attribute__((section("sfrs")));
#define USBDMA2C USBDMA2C
extern volatile unsigned int   USBDMA2C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA2Cbits_t;
extern volatile __USBDMA2Cbits_t USBDMA2Cbits __asm__ ("USBDMA2C") __attribute__((section("sfrs")));
#define USBDMA2A USBDMA2A
extern volatile unsigned int   USBDMA2A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA2Abits_t;
extern volatile __USBDMA2Abits_t USBDMA2Abits __asm__ ("USBDMA2A") __attribute__((section("sfrs")));
#define USBDMA2N USBDMA2N
extern volatile unsigned int   USBDMA2N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA2Nbits_t;
extern volatile __USBDMA2Nbits_t USBDMA2Nbits __asm__ ("USBDMA2N") __attribute__((section("sfrs")));
#define USBDMA3C USBDMA3C
extern volatile unsigned int   USBDMA3C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA3Cbits_t;
extern volatile __USBDMA3Cbits_t USBDMA3Cbits __asm__ ("USBDMA3C") __attribute__((section("sfrs")));
#define USBDMA3A USBDMA3A
extern volatile unsigned int   USBDMA3A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA3Abits_t;
extern volatile __USBDMA3Abits_t USBDMA3Abits __asm__ ("USBDMA3A") __attribute__((section("sfrs")));
#define USBDMA3N USBDMA3N
extern volatile unsigned int   USBDMA3N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA3Nbits_t;
extern volatile __USBDMA3Nbits_t USBDMA3Nbits __asm__ ("USBDMA3N") __attribute__((section("sfrs")));
#define USBDMA4C USBDMA4C
extern volatile unsigned int   USBDMA4C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA4Cbits_t;
extern volatile __USBDMA4Cbits_t USBDMA4Cbits __asm__ ("USBDMA4C") __attribute__((section("sfrs")));
#define USBDMA4A USBDMA4A
extern volatile unsigned int   USBDMA4A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA4Abits_t;
extern volatile __USBDMA4Abits_t USBDMA4Abits __asm__ ("USBDMA4A") __attribute__((section("sfrs")));
#define USBDMA4N USBDMA4N
extern volatile unsigned int   USBDMA4N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA4Nbits_t;
extern volatile __USBDMA4Nbits_t USBDMA4Nbits __asm__ ("USBDMA4N") __attribute__((section("sfrs")));
#define USBDMA5C USBDMA5C
extern volatile unsigned int   USBDMA5C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA5Cbits_t;
extern volatile __USBDMA5Cbits_t USBDMA5Cbits __asm__ ("USBDMA5C") __attribute__((section("sfrs")));
#define USBDMA5A USBDMA5A
extern volatile unsigned int   USBDMA5A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA5Abits_t;
extern volatile __USBDMA5Abits_t USBDMA5Abits __asm__ ("USBDMA5A") __attribute__((section("sfrs")));
#define USBDMA5N USBDMA5N
extern volatile unsigned int   USBDMA5N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA5Nbits_t;
extern volatile __USBDMA5Nbits_t USBDMA5Nbits __asm__ ("USBDMA5N") __attribute__((section("sfrs")));
#define USBDMA6C USBDMA6C
extern volatile unsigned int   USBDMA6C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA6Cbits_t;
extern volatile __USBDMA6Cbits_t USBDMA6Cbits __asm__ ("USBDMA6C") __attribute__((section("sfrs")));
#define USBDMA6A USBDMA6A
extern volatile unsigned int   USBDMA6A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA6Abits_t;
extern volatile __USBDMA6Abits_t USBDMA6Abits __asm__ ("USBDMA6A") __attribute__((section("sfrs")));
#define USBDMA6N USBDMA6N
extern volatile unsigned int   USBDMA6N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA6Nbits_t;
extern volatile __USBDMA6Nbits_t USBDMA6Nbits __asm__ ("USBDMA6N") __attribute__((section("sfrs")));
#define USBDMA7C USBDMA7C
extern volatile unsigned int   USBDMA7C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA7Cbits_t;
extern volatile __USBDMA7Cbits_t USBDMA7Cbits __asm__ ("USBDMA7C") __attribute__((section("sfrs")));
#define USBDMA7A USBDMA7A
extern volatile unsigned int   USBDMA7A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA7Abits_t;
extern volatile __USBDMA7Abits_t USBDMA7Abits __asm__ ("USBDMA7A") __attribute__((section("sfrs")));
#define USBDMA7N USBDMA7N
extern volatile unsigned int   USBDMA7N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA7Nbits_t;
extern volatile __USBDMA7Nbits_t USBDMA7Nbits __asm__ ("USBDMA7N") __attribute__((section("sfrs")));
#define USBDMA8C USBDMA8C
extern volatile unsigned int   USBDMA8C __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAEN:1;
  unsigned DMADIR:1;
  unsigned DMAMODE:1;
  unsigned DMAIE:1;
  unsigned DMAEP:4;
  unsigned DMAERR:1;
  unsigned DMABRSTM:2;
} __USBDMA8Cbits_t;
extern volatile __USBDMA8Cbits_t USBDMA8Cbits __asm__ ("USBDMA8C") __attribute__((section("sfrs")));
#define USBDMA8A USBDMA8A
extern volatile unsigned int   USBDMA8A __attribute__((section("sfrs")));
typedef struct {
  unsigned DMAADDR:32;
} __USBDMA8Abits_t;
extern volatile __USBDMA8Abits_t USBDMA8Abits __asm__ ("USBDMA8A") __attribute__((section("sfrs")));
#define USBDMA8N USBDMA8N
extern volatile unsigned int   USBDMA8N __attribute__((section("sfrs")));
typedef struct {
  unsigned DMACOUNT:32;
} __USBDMA8Nbits_t;
extern volatile __USBDMA8Nbits_t USBDMA8Nbits __asm__ ("USBDMA8N") __attribute__((section("sfrs")));
#define USBE1RPC USBE1RPC
extern volatile unsigned int   USBE1RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE1RPCbits_t;
extern volatile __USBE1RPCbits_t USBE1RPCbits __asm__ ("USBE1RPC") __attribute__((section("sfrs")));
#define USBE2RPC USBE2RPC
extern volatile unsigned int   USBE2RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE2RPCbits_t;
extern volatile __USBE2RPCbits_t USBE2RPCbits __asm__ ("USBE2RPC") __attribute__((section("sfrs")));
#define USBE3RPC USBE3RPC
extern volatile unsigned int   USBE3RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE3RPCbits_t;
extern volatile __USBE3RPCbits_t USBE3RPCbits __asm__ ("USBE3RPC") __attribute__((section("sfrs")));
#define USBE4RPC USBE4RPC
extern volatile unsigned int   USBE4RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE4RPCbits_t;
extern volatile __USBE4RPCbits_t USBE4RPCbits __asm__ ("USBE4RPC") __attribute__((section("sfrs")));
#define USBE5RPC USBE5RPC
extern volatile unsigned int   USBE5RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE5RPCbits_t;
extern volatile __USBE5RPCbits_t USBE5RPCbits __asm__ ("USBE5RPC") __attribute__((section("sfrs")));
#define USBE6RPC USBE6RPC
extern volatile unsigned int   USBE6RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE6RPCbits_t;
extern volatile __USBE6RPCbits_t USBE6RPCbits __asm__ ("USBE6RPC") __attribute__((section("sfrs")));
#define USBE7RPC USBE7RPC
extern volatile unsigned int   USBE7RPC __attribute__((section("sfrs")));
typedef struct {
  unsigned RQPKTCNT:16;
} __USBE7RPCbits_t;
extern volatile __USBE7RPCbits_t USBE7RPCbits __asm__ ("USBE7RPC") __attribute__((section("sfrs")));
#define USBDPBFD USBDPBFD
extern volatile unsigned int   USBDPBFD __attribute__((section("sfrs")));
typedef struct {
  unsigned :1;
  unsigned EP1RXD:1;
  unsigned EP2RXD:1;
  unsigned EP3RXD:1;
  unsigned EP4RXD:1;
  unsigned EP5RXD:1;
  unsigned EP6RXD:1;
  unsigned EP7RXD:1;
  unsigned :9;
  unsigned EP1TXD:1;
  unsigned EP2TXD:1;
  unsigned EP3TXD:1;
  unsigned EP4TXD:1;
  unsigned EP5TXD:1;
  unsigned EP6TXD:1;
  unsigned EP7TXD:1;
} __USBDPBFDbits_t;
extern volatile __USBDPBFDbits_t USBDPBFDbits __asm__ ("USBDPBFD") __attribute__((section("sfrs")));
#define USBTMCON1 USBTMCON1
extern volatile unsigned int   USBTMCON1 __attribute__((section("sfrs")));
typedef struct {
  unsigned TUCH:16;
  unsigned THHSRTN:16;
} __USBTMCON1bits_t;
extern volatile __USBTMCON1bits_t USBTMCON1bits __asm__ ("USBTMCON1") __attribute__((section("sfrs")));
#define USBTMCON2 USBTMCON2
extern volatile unsigned int   USBTMCON2 __attribute__((section("sfrs")));
typedef struct {
  unsigned THSBT:4;
} __USBTMCON2bits_t;
extern volatile __USBTMCON2bits_t USBTMCON2bits __asm__ ("USBTMCON2") __attribute__((section("sfrs")));
#define USBLPMR1 USBLPMR1
extern volatile unsigned int   USBLPMR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned LNKSTATE:4;
  unsigned HIRD:4;
  unsigned RMTWAK:1;
  unsigned :3;
  unsigned ENDPOINT:4;
  unsigned LPMXMT:1;
  unsigned LPMRES:1;
  unsigned LPMEN:2;
  unsigned LPMNAK:1;
  unsigned :3;
  unsigned LPMTOIE:1;
  unsigned LPMSTIE:1;
  unsigned LPMNYIE:1;
  unsigned LPMACKIE:1;
  unsigned LPMRESIE:1;
  unsigned LPMERRIE:1;
} __USBLPMR1bits_t;
extern volatile __USBLPMR1bits_t USBLPMR1bits __asm__ ("USBLPMR1") __attribute__((section("sfrs")));
#define USBLMPR2 USBLMPR2
extern volatile unsigned int   USBLMPR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned LPMST:1;
  unsigned LPMNY:1;
  unsigned LPMACK:1;
  unsigned LPMNC:1;
  unsigned LPMRES:1;
  unsigned LPMERR:1;
  unsigned :2;
  unsigned LPMFADDR:7;
} __USBLMPR2bits_t;
extern volatile __USBLMPR2bits_t USBLMPR2bits __asm__ ("USBLMPR2") __attribute__((section("sfrs")));
#define USBLPMP2 USBLPMP2
extern volatile unsigned int   USBLPMP2 __attribute__((section("sfrs")));
typedef struct {
  unsigned LPMST:1;
  unsigned LPMNY:1;
  unsigned LPMACK:1;
  unsigned LPMNC:1;
  unsigned LPMRES:1;
  unsigned LPMERR:1;
  unsigned :2;
  unsigned LPMFADDR:7;
} __USBLPMP2bits_t;
extern volatile __USBLPMP2bits_t USBLPMP2bits __asm__ ("USBLPMP2") __attribute__((section("sfrs")));
#define RNGVER RNGVER
extern volatile unsigned int   RNGVER __attribute__((section("sfrs")));
typedef struct {
  unsigned REVISION:7;
  unsigned VERSION:9;
  unsigned ID:16;
} __RNGVERbits_t;
extern volatile __RNGVERbits_t RNGVERbits __asm__ ("RNGVER") __attribute__((section("sfrs")));
#define RNGCON RNGCON
extern volatile unsigned int   RNGCON __attribute__((section("sfrs")));
typedef struct {
  unsigned PLEN:8;
  unsigned TRNGEN:1;
  unsigned PRNGEN:1;
  unsigned CONT:1;
  unsigned TRNGMODE:1;
  unsigned LOAD:1;
} __RNGCONbits_t;
extern volatile __RNGCONbits_t RNGCONbits __asm__ ("RNGCON") __attribute__((section("sfrs")));
#define RNGPOLY1 RNGPOLY1
extern volatile unsigned int   RNGPOLY1 __attribute__((section("sfrs")));
typedef struct {
  unsigned POLY:32;
} __RNGPOLY1bits_t;
extern volatile __RNGPOLY1bits_t RNGPOLY1bits __asm__ ("RNGPOLY1") __attribute__((section("sfrs")));
#define RNGPOLY2 RNGPOLY2
extern volatile unsigned int   RNGPOLY2 __attribute__((section("sfrs")));
typedef struct {
  unsigned POLY:32;
} __RNGPOLY2bits_t;
extern volatile __RNGPOLY2bits_t RNGPOLY2bits __asm__ ("RNGPOLY2") __attribute__((section("sfrs")));
#define RNGNUMGEN1 RNGNUMGEN1
extern volatile unsigned int   RNGNUMGEN1 __attribute__((section("sfrs")));
typedef struct {
  unsigned RNG:32;
} __RNGNUMGEN1bits_t;
extern volatile __RNGNUMGEN1bits_t RNGNUMGEN1bits __asm__ ("RNGNUMGEN1") __attribute__((section("sfrs")));
#define RNGNUMGEN2 RNGNUMGEN2
extern volatile unsigned int   RNGNUMGEN2 __attribute__((section("sfrs")));
typedef struct {
  unsigned RNG:32;
} __RNGNUMGEN2bits_t;
extern volatile __RNGNUMGEN2bits_t RNGNUMGEN2bits __asm__ ("RNGNUMGEN2") __attribute__((section("sfrs")));
#define RNGSEED1 RNGSEED1
extern volatile unsigned int   RNGSEED1 __attribute__((section("sfrs")));
typedef struct {
  unsigned SEED:32;
} __RNGSEED1bits_t;
extern volatile __RNGSEED1bits_t RNGSEED1bits __asm__ ("RNGSEED1") __attribute__((section("sfrs")));
#define RNGSEED2 RNGSEED2
extern volatile unsigned int   RNGSEED2 __attribute__((section("sfrs")));
typedef struct {
  unsigned SEED:32;
} __RNGSEED2bits_t;
extern volatile __RNGSEED2bits_t RNGSEED2bits __asm__ ("RNGSEED2") __attribute__((section("sfrs")));
#define RNGCNT RNGCNT
extern volatile unsigned int   RNGCNT __attribute__((section("sfrs")));
typedef struct {
  unsigned RCNT:7;
} __RNGCNTbits_t;
extern volatile __RNGCNTbits_t RNGCNTbits __asm__ ("RNGCNT") __attribute__((section("sfrs")));
#define SBFLAG SBFLAG
extern volatile unsigned int   SBFLAG __attribute__((section("sfrs")));
typedef struct {
  unsigned T0PGV:1;
  unsigned T1PGV:1;
  unsigned T2PGV:1;
  unsigned T3PGV:1;
  unsigned T4PGV:1;
  unsigned T5PGV:1;
  unsigned T6PGV:1;
  unsigned T7PGV:1;
  unsigned T8PGV:1;
  unsigned T9PGV:1;
  unsigned T10PGV:1;
  unsigned T11PGV:1;
  unsigned T12PGV:1;
  unsigned T13PGV:1;
} __SBFLAGbits_t;
extern volatile __SBFLAGbits_t SBFLAGbits __asm__ ("SBFLAG") __attribute__((section("sfrs")));
#define SBT0ELOG1 SBT0ELOG1
extern volatile unsigned int   SBT0ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT0ELOG1bits_t;
extern volatile __SBT0ELOG1bits_t SBT0ELOG1bits __asm__ ("SBT0ELOG1") __attribute__((section("sfrs")));
#define SBT0ELOG2 SBT0ELOG2
extern volatile unsigned int   SBT0ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT0ELOG2bits_t;
extern volatile __SBT0ELOG2bits_t SBT0ELOG2bits __asm__ ("SBT0ELOG2") __attribute__((section("sfrs")));
#define SBT0ECON SBT0ECON
extern volatile unsigned int   SBT0ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT0ECONbits_t;
extern volatile __SBT0ECONbits_t SBT0ECONbits __asm__ ("SBT0ECON") __attribute__((section("sfrs")));
#define SBT0ECLRS SBT0ECLRS
extern volatile unsigned int   SBT0ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT0ECLRSbits_t;
extern volatile __SBT0ECLRSbits_t SBT0ECLRSbits __asm__ ("SBT0ECLRS") __attribute__((section("sfrs")));
#define SBT0ECLRM SBT0ECLRM
extern volatile unsigned int   SBT0ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT0ECLRMbits_t;
extern volatile __SBT0ECLRMbits_t SBT0ECLRMbits __asm__ ("SBT0ECLRM") __attribute__((section("sfrs")));
#define SBT0REG0 SBT0REG0
extern volatile unsigned int   SBT0REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT0REG0bits_t;
extern volatile __SBT0REG0bits_t SBT0REG0bits __asm__ ("SBT0REG0") __attribute__((section("sfrs")));
#define SBT0RD0 SBT0RD0
extern volatile unsigned int   SBT0RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT0RD0bits_t;
extern volatile __SBT0RD0bits_t SBT0RD0bits __asm__ ("SBT0RD0") __attribute__((section("sfrs")));
#define SBT0WR0 SBT0WR0
extern volatile unsigned int   SBT0WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT0WR0bits_t;
extern volatile __SBT0WR0bits_t SBT0WR0bits __asm__ ("SBT0WR0") __attribute__((section("sfrs")));
#define SBT0REG1 SBT0REG1
extern volatile unsigned int   SBT0REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT0REG1bits_t;
extern volatile __SBT0REG1bits_t SBT0REG1bits __asm__ ("SBT0REG1") __attribute__((section("sfrs")));
#define SBT0RD1 SBT0RD1
extern volatile unsigned int   SBT0RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT0RD1bits_t;
extern volatile __SBT0RD1bits_t SBT0RD1bits __asm__ ("SBT0RD1") __attribute__((section("sfrs")));
#define SBT0WR1 SBT0WR1
extern volatile unsigned int   SBT0WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT0WR1bits_t;
extern volatile __SBT0WR1bits_t SBT0WR1bits __asm__ ("SBT0WR1") __attribute__((section("sfrs")));
#define SBT1ELOG1 SBT1ELOG1
extern volatile unsigned int   SBT1ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT1ELOG1bits_t;
extern volatile __SBT1ELOG1bits_t SBT1ELOG1bits __asm__ ("SBT1ELOG1") __attribute__((section("sfrs")));
#define SBT1ELOG2 SBT1ELOG2
extern volatile unsigned int   SBT1ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT1ELOG2bits_t;
extern volatile __SBT1ELOG2bits_t SBT1ELOG2bits __asm__ ("SBT1ELOG2") __attribute__((section("sfrs")));
#define SBT1ECON SBT1ECON
extern volatile unsigned int   SBT1ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT1ECONbits_t;
extern volatile __SBT1ECONbits_t SBT1ECONbits __asm__ ("SBT1ECON") __attribute__((section("sfrs")));
#define SBT1ECLRS SBT1ECLRS
extern volatile unsigned int   SBT1ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT1ECLRSbits_t;
extern volatile __SBT1ECLRSbits_t SBT1ECLRSbits __asm__ ("SBT1ECLRS") __attribute__((section("sfrs")));
#define SBT1ECLRM SBT1ECLRM
extern volatile unsigned int   SBT1ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT1ECLRMbits_t;
extern volatile __SBT1ECLRMbits_t SBT1ECLRMbits __asm__ ("SBT1ECLRM") __attribute__((section("sfrs")));
#define SBT1REG0 SBT1REG0
extern volatile unsigned int   SBT1REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG0bits_t;
extern volatile __SBT1REG0bits_t SBT1REG0bits __asm__ ("SBT1REG0") __attribute__((section("sfrs")));
#define SBT1RD0 SBT1RD0
extern volatile unsigned int   SBT1RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD0bits_t;
extern volatile __SBT1RD0bits_t SBT1RD0bits __asm__ ("SBT1RD0") __attribute__((section("sfrs")));
#define SBT1WR0 SBT1WR0
extern volatile unsigned int   SBT1WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR0bits_t;
extern volatile __SBT1WR0bits_t SBT1WR0bits __asm__ ("SBT1WR0") __attribute__((section("sfrs")));
#define SBT1REG2 SBT1REG2
extern volatile unsigned int   SBT1REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG2bits_t;
extern volatile __SBT1REG2bits_t SBT1REG2bits __asm__ ("SBT1REG2") __attribute__((section("sfrs")));
#define SBT1RD2 SBT1RD2
extern volatile unsigned int   SBT1RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD2bits_t;
extern volatile __SBT1RD2bits_t SBT1RD2bits __asm__ ("SBT1RD2") __attribute__((section("sfrs")));
#define SBT1WR2 SBT1WR2
extern volatile unsigned int   SBT1WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR2bits_t;
extern volatile __SBT1WR2bits_t SBT1WR2bits __asm__ ("SBT1WR2") __attribute__((section("sfrs")));
#define SBT1REG3 SBT1REG3
extern volatile unsigned int   SBT1REG3 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG3bits_t;
extern volatile __SBT1REG3bits_t SBT1REG3bits __asm__ ("SBT1REG3") __attribute__((section("sfrs")));
#define SBT1RD3 SBT1RD3
extern volatile unsigned int   SBT1RD3 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD3bits_t;
extern volatile __SBT1RD3bits_t SBT1RD3bits __asm__ ("SBT1RD3") __attribute__((section("sfrs")));
#define SBT1WR3 SBT1WR3
extern volatile unsigned int   SBT1WR3 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR3bits_t;
extern volatile __SBT1WR3bits_t SBT1WR3bits __asm__ ("SBT1WR3") __attribute__((section("sfrs")));
#define SBT1REG4 SBT1REG4
extern volatile unsigned int   SBT1REG4 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG4bits_t;
extern volatile __SBT1REG4bits_t SBT1REG4bits __asm__ ("SBT1REG4") __attribute__((section("sfrs")));
#define SBT1RD4 SBT1RD4
extern volatile unsigned int   SBT1RD4 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD4bits_t;
extern volatile __SBT1RD4bits_t SBT1RD4bits __asm__ ("SBT1RD4") __attribute__((section("sfrs")));
#define SBT1WR4 SBT1WR4
extern volatile unsigned int   SBT1WR4 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR4bits_t;
extern volatile __SBT1WR4bits_t SBT1WR4bits __asm__ ("SBT1WR4") __attribute__((section("sfrs")));
#define SBT1REG5 SBT1REG5
extern volatile unsigned int   SBT1REG5 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG5bits_t;
extern volatile __SBT1REG5bits_t SBT1REG5bits __asm__ ("SBT1REG5") __attribute__((section("sfrs")));
#define SBT1RD5 SBT1RD5
extern volatile unsigned int   SBT1RD5 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD5bits_t;
extern volatile __SBT1RD5bits_t SBT1RD5bits __asm__ ("SBT1RD5") __attribute__((section("sfrs")));
#define SBT1WR5 SBT1WR5
extern volatile unsigned int   SBT1WR5 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR5bits_t;
extern volatile __SBT1WR5bits_t SBT1WR5bits __asm__ ("SBT1WR5") __attribute__((section("sfrs")));
#define SBT1REG6 SBT1REG6
extern volatile unsigned int   SBT1REG6 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG6bits_t;
extern volatile __SBT1REG6bits_t SBT1REG6bits __asm__ ("SBT1REG6") __attribute__((section("sfrs")));
#define SBT1RD6 SBT1RD6
extern volatile unsigned int   SBT1RD6 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD6bits_t;
extern volatile __SBT1RD6bits_t SBT1RD6bits __asm__ ("SBT1RD6") __attribute__((section("sfrs")));
#define SBT1WR6 SBT1WR6
extern volatile unsigned int   SBT1WR6 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR6bits_t;
extern volatile __SBT1WR6bits_t SBT1WR6bits __asm__ ("SBT1WR6") __attribute__((section("sfrs")));
#define SBT1REG7 SBT1REG7
extern volatile unsigned int   SBT1REG7 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG7bits_t;
extern volatile __SBT1REG7bits_t SBT1REG7bits __asm__ ("SBT1REG7") __attribute__((section("sfrs")));
#define SBT1RD7 SBT1RD7
extern volatile unsigned int   SBT1RD7 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD7bits_t;
extern volatile __SBT1RD7bits_t SBT1RD7bits __asm__ ("SBT1RD7") __attribute__((section("sfrs")));
#define SBT1WR7 SBT1WR7
extern volatile unsigned int   SBT1WR7 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR7bits_t;
extern volatile __SBT1WR7bits_t SBT1WR7bits __asm__ ("SBT1WR7") __attribute__((section("sfrs")));
#define SBT1REG8 SBT1REG8
extern volatile unsigned int   SBT1REG8 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT1REG8bits_t;
extern volatile __SBT1REG8bits_t SBT1REG8bits __asm__ ("SBT1REG8") __attribute__((section("sfrs")));
#define SBT1RD8 SBT1RD8
extern volatile unsigned int   SBT1RD8 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1RD8bits_t;
extern volatile __SBT1RD8bits_t SBT1RD8bits __asm__ ("SBT1RD8") __attribute__((section("sfrs")));
#define SBT1WR8 SBT1WR8
extern volatile unsigned int   SBT1WR8 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT1WR8bits_t;
extern volatile __SBT1WR8bits_t SBT1WR8bits __asm__ ("SBT1WR8") __attribute__((section("sfrs")));
#define SBT2ELOG1 SBT2ELOG1
extern volatile unsigned int   SBT2ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT2ELOG1bits_t;
extern volatile __SBT2ELOG1bits_t SBT2ELOG1bits __asm__ ("SBT2ELOG1") __attribute__((section("sfrs")));
#define SBT2ELOG2 SBT2ELOG2
extern volatile unsigned int   SBT2ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT2ELOG2bits_t;
extern volatile __SBT2ELOG2bits_t SBT2ELOG2bits __asm__ ("SBT2ELOG2") __attribute__((section("sfrs")));
#define SBT2ECON SBT2ECON
extern volatile unsigned int   SBT2ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT2ECONbits_t;
extern volatile __SBT2ECONbits_t SBT2ECONbits __asm__ ("SBT2ECON") __attribute__((section("sfrs")));
#define SBT2ECLRS SBT2ECLRS
extern volatile unsigned int   SBT2ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT2ECLRSbits_t;
extern volatile __SBT2ECLRSbits_t SBT2ECLRSbits __asm__ ("SBT2ECLRS") __attribute__((section("sfrs")));
#define SBT2ECLRM SBT2ECLRM
extern volatile unsigned int   SBT2ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT2ECLRMbits_t;
extern volatile __SBT2ECLRMbits_t SBT2ECLRMbits __asm__ ("SBT2ECLRM") __attribute__((section("sfrs")));
#define SBT2REG0 SBT2REG0
extern volatile unsigned int   SBT2REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT2REG0bits_t;
extern volatile __SBT2REG0bits_t SBT2REG0bits __asm__ ("SBT2REG0") __attribute__((section("sfrs")));
#define SBT2RD0 SBT2RD0
extern volatile unsigned int   SBT2RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2RD0bits_t;
extern volatile __SBT2RD0bits_t SBT2RD0bits __asm__ ("SBT2RD0") __attribute__((section("sfrs")));
#define SBT2WR0 SBT2WR0
extern volatile unsigned int   SBT2WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2WR0bits_t;
extern volatile __SBT2WR0bits_t SBT2WR0bits __asm__ ("SBT2WR0") __attribute__((section("sfrs")));
#define SBT2REG1 SBT2REG1
extern volatile unsigned int   SBT2REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT2REG1bits_t;
extern volatile __SBT2REG1bits_t SBT2REG1bits __asm__ ("SBT2REG1") __attribute__((section("sfrs")));
#define SBT2RD1 SBT2RD1
extern volatile unsigned int   SBT2RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2RD1bits_t;
extern volatile __SBT2RD1bits_t SBT2RD1bits __asm__ ("SBT2RD1") __attribute__((section("sfrs")));
#define SBT2WR1 SBT2WR1
extern volatile unsigned int   SBT2WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2WR1bits_t;
extern volatile __SBT2WR1bits_t SBT2WR1bits __asm__ ("SBT2WR1") __attribute__((section("sfrs")));
#define SBT2REG2 SBT2REG2
extern volatile unsigned int   SBT2REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT2REG2bits_t;
extern volatile __SBT2REG2bits_t SBT2REG2bits __asm__ ("SBT2REG2") __attribute__((section("sfrs")));
#define SBT2RD2 SBT2RD2
extern volatile unsigned int   SBT2RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2RD2bits_t;
extern volatile __SBT2RD2bits_t SBT2RD2bits __asm__ ("SBT2RD2") __attribute__((section("sfrs")));
#define SBT2WR2 SBT2WR2
extern volatile unsigned int   SBT2WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT2WR2bits_t;
extern volatile __SBT2WR2bits_t SBT2WR2bits __asm__ ("SBT2WR2") __attribute__((section("sfrs")));
#define SBT3ELOG1 SBT3ELOG1
extern volatile unsigned int   SBT3ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT3ELOG1bits_t;
extern volatile __SBT3ELOG1bits_t SBT3ELOG1bits __asm__ ("SBT3ELOG1") __attribute__((section("sfrs")));
#define SBT3ELOG2 SBT3ELOG2
extern volatile unsigned int   SBT3ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT3ELOG2bits_t;
extern volatile __SBT3ELOG2bits_t SBT3ELOG2bits __asm__ ("SBT3ELOG2") __attribute__((section("sfrs")));
#define SBT3ECON SBT3ECON
extern volatile unsigned int   SBT3ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT3ECONbits_t;
extern volatile __SBT3ECONbits_t SBT3ECONbits __asm__ ("SBT3ECON") __attribute__((section("sfrs")));
#define SBT3ECLRS SBT3ECLRS
extern volatile unsigned int   SBT3ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT3ECLRSbits_t;
extern volatile __SBT3ECLRSbits_t SBT3ECLRSbits __asm__ ("SBT3ECLRS") __attribute__((section("sfrs")));
#define SBT3ECLRM SBT3ECLRM
extern volatile unsigned int   SBT3ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT3ECLRMbits_t;
extern volatile __SBT3ECLRMbits_t SBT3ECLRMbits __asm__ ("SBT3ECLRM") __attribute__((section("sfrs")));
#define SBT3REG0 SBT3REG0
extern volatile unsigned int   SBT3REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT3REG0bits_t;
extern volatile __SBT3REG0bits_t SBT3REG0bits __asm__ ("SBT3REG0") __attribute__((section("sfrs")));
#define SBT3RD0 SBT3RD0
extern volatile unsigned int   SBT3RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3RD0bits_t;
extern volatile __SBT3RD0bits_t SBT3RD0bits __asm__ ("SBT3RD0") __attribute__((section("sfrs")));
#define SBT3WR0 SBT3WR0
extern volatile unsigned int   SBT3WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3WR0bits_t;
extern volatile __SBT3WR0bits_t SBT3WR0bits __asm__ ("SBT3WR0") __attribute__((section("sfrs")));
#define SBT3REG1 SBT3REG1
extern volatile unsigned int   SBT3REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT3REG1bits_t;
extern volatile __SBT3REG1bits_t SBT3REG1bits __asm__ ("SBT3REG1") __attribute__((section("sfrs")));
#define SBT3RD1 SBT3RD1
extern volatile unsigned int   SBT3RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3RD1bits_t;
extern volatile __SBT3RD1bits_t SBT3RD1bits __asm__ ("SBT3RD1") __attribute__((section("sfrs")));
#define SBT3WR1 SBT3WR1
extern volatile unsigned int   SBT3WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3WR1bits_t;
extern volatile __SBT3WR1bits_t SBT3WR1bits __asm__ ("SBT3WR1") __attribute__((section("sfrs")));
#define SBT3REG2 SBT3REG2
extern volatile unsigned int   SBT3REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT3REG2bits_t;
extern volatile __SBT3REG2bits_t SBT3REG2bits __asm__ ("SBT3REG2") __attribute__((section("sfrs")));
#define SBT3RD2 SBT3RD2
extern volatile unsigned int   SBT3RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3RD2bits_t;
extern volatile __SBT3RD2bits_t SBT3RD2bits __asm__ ("SBT3RD2") __attribute__((section("sfrs")));
#define SBT3WR2 SBT3WR2
extern volatile unsigned int   SBT3WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT3WR2bits_t;
extern volatile __SBT3WR2bits_t SBT3WR2bits __asm__ ("SBT3WR2") __attribute__((section("sfrs")));
#define SBT4ELOG1 SBT4ELOG1
extern volatile unsigned int   SBT4ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT4ELOG1bits_t;
extern volatile __SBT4ELOG1bits_t SBT4ELOG1bits __asm__ ("SBT4ELOG1") __attribute__((section("sfrs")));
#define SBT4ELOG2 SBT4ELOG2
extern volatile unsigned int   SBT4ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT4ELOG2bits_t;
extern volatile __SBT4ELOG2bits_t SBT4ELOG2bits __asm__ ("SBT4ELOG2") __attribute__((section("sfrs")));
#define SBT4ECON SBT4ECON
extern volatile unsigned int   SBT4ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT4ECONbits_t;
extern volatile __SBT4ECONbits_t SBT4ECONbits __asm__ ("SBT4ECON") __attribute__((section("sfrs")));
#define SBT4ECLRS SBT4ECLRS
extern volatile unsigned int   SBT4ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT4ECLRSbits_t;
extern volatile __SBT4ECLRSbits_t SBT4ECLRSbits __asm__ ("SBT4ECLRS") __attribute__((section("sfrs")));
#define SBT4ECLRM SBT4ECLRM
extern volatile unsigned int   SBT4ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT4ECLRMbits_t;
extern volatile __SBT4ECLRMbits_t SBT4ECLRMbits __asm__ ("SBT4ECLRM") __attribute__((section("sfrs")));
#define SBT4REG0 SBT4REG0
extern volatile unsigned int   SBT4REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT4REG0bits_t;
extern volatile __SBT4REG0bits_t SBT4REG0bits __asm__ ("SBT4REG0") __attribute__((section("sfrs")));
#define SBT4RD0 SBT4RD0
extern volatile unsigned int   SBT4RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT4RD0bits_t;
extern volatile __SBT4RD0bits_t SBT4RD0bits __asm__ ("SBT4RD0") __attribute__((section("sfrs")));
#define SBT4WR0 SBT4WR0
extern volatile unsigned int   SBT4WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT4WR0bits_t;
extern volatile __SBT4WR0bits_t SBT4WR0bits __asm__ ("SBT4WR0") __attribute__((section("sfrs")));
#define SBT4REG2 SBT4REG2
extern volatile unsigned int   SBT4REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT4REG2bits_t;
extern volatile __SBT4REG2bits_t SBT4REG2bits __asm__ ("SBT4REG2") __attribute__((section("sfrs")));
#define SBT4RD2 SBT4RD2
extern volatile unsigned int   SBT4RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT4RD2bits_t;
extern volatile __SBT4RD2bits_t SBT4RD2bits __asm__ ("SBT4RD2") __attribute__((section("sfrs")));
#define SBT4WR2 SBT4WR2
extern volatile unsigned int   SBT4WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT4WR2bits_t;
extern volatile __SBT4WR2bits_t SBT4WR2bits __asm__ ("SBT4WR2") __attribute__((section("sfrs")));
#define SBT5ELOG1 SBT5ELOG1
extern volatile unsigned int   SBT5ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT5ELOG1bits_t;
extern volatile __SBT5ELOG1bits_t SBT5ELOG1bits __asm__ ("SBT5ELOG1") __attribute__((section("sfrs")));
#define SBT5ELOG2 SBT5ELOG2
extern volatile unsigned int   SBT5ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT5ELOG2bits_t;
extern volatile __SBT5ELOG2bits_t SBT5ELOG2bits __asm__ ("SBT5ELOG2") __attribute__((section("sfrs")));
#define SBT5ECON SBT5ECON
extern volatile unsigned int   SBT5ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT5ECONbits_t;
extern volatile __SBT5ECONbits_t SBT5ECONbits __asm__ ("SBT5ECON") __attribute__((section("sfrs")));
#define SBT5ECLRS SBT5ECLRS
extern volatile unsigned int   SBT5ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT5ECLRSbits_t;
extern volatile __SBT5ECLRSbits_t SBT5ECLRSbits __asm__ ("SBT5ECLRS") __attribute__((section("sfrs")));
#define SBT5ECLRM SBT5ECLRM
extern volatile unsigned int   SBT5ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT5ECLRMbits_t;
extern volatile __SBT5ECLRMbits_t SBT5ECLRMbits __asm__ ("SBT5ECLRM") __attribute__((section("sfrs")));
#define SBT5REG0 SBT5REG0
extern volatile unsigned int   SBT5REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT5REG0bits_t;
extern volatile __SBT5REG0bits_t SBT5REG0bits __asm__ ("SBT5REG0") __attribute__((section("sfrs")));
#define SBT5RD0 SBT5RD0
extern volatile unsigned int   SBT5RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5RD0bits_t;
extern volatile __SBT5RD0bits_t SBT5RD0bits __asm__ ("SBT5RD0") __attribute__((section("sfrs")));
#define SBT5WR0 SBT5WR0
extern volatile unsigned int   SBT5WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5WR0bits_t;
extern volatile __SBT5WR0bits_t SBT5WR0bits __asm__ ("SBT5WR0") __attribute__((section("sfrs")));
#define SBT5REG1 SBT5REG1
extern volatile unsigned int   SBT5REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT5REG1bits_t;
extern volatile __SBT5REG1bits_t SBT5REG1bits __asm__ ("SBT5REG1") __attribute__((section("sfrs")));
#define SBT5RD1 SBT5RD1
extern volatile unsigned int   SBT5RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5RD1bits_t;
extern volatile __SBT5RD1bits_t SBT5RD1bits __asm__ ("SBT5RD1") __attribute__((section("sfrs")));
#define SBT5WR1 SBT5WR1
extern volatile unsigned int   SBT5WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5WR1bits_t;
extern volatile __SBT5WR1bits_t SBT5WR1bits __asm__ ("SBT5WR1") __attribute__((section("sfrs")));
#define SBT5REG2 SBT5REG2
extern volatile unsigned int   SBT5REG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT5REG2bits_t;
extern volatile __SBT5REG2bits_t SBT5REG2bits __asm__ ("SBT5REG2") __attribute__((section("sfrs")));
#define SBT5RD2 SBT5RD2
extern volatile unsigned int   SBT5RD2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5RD2bits_t;
extern volatile __SBT5RD2bits_t SBT5RD2bits __asm__ ("SBT5RD2") __attribute__((section("sfrs")));
#define SBT5WR2 SBT5WR2
extern volatile unsigned int   SBT5WR2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT5WR2bits_t;
extern volatile __SBT5WR2bits_t SBT5WR2bits __asm__ ("SBT5WR2") __attribute__((section("sfrs")));
#define SBT6ELOG1 SBT6ELOG1
extern volatile unsigned int   SBT6ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT6ELOG1bits_t;
extern volatile __SBT6ELOG1bits_t SBT6ELOG1bits __asm__ ("SBT6ELOG1") __attribute__((section("sfrs")));
#define SBT6ELOG2 SBT6ELOG2
extern volatile unsigned int   SBT6ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT6ELOG2bits_t;
extern volatile __SBT6ELOG2bits_t SBT6ELOG2bits __asm__ ("SBT6ELOG2") __attribute__((section("sfrs")));
#define SBT6ECON SBT6ECON
extern volatile unsigned int   SBT6ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT6ECONbits_t;
extern volatile __SBT6ECONbits_t SBT6ECONbits __asm__ ("SBT6ECON") __attribute__((section("sfrs")));
#define SBT6ECLRS SBT6ECLRS
extern volatile unsigned int   SBT6ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT6ECLRSbits_t;
extern volatile __SBT6ECLRSbits_t SBT6ECLRSbits __asm__ ("SBT6ECLRS") __attribute__((section("sfrs")));
#define SBT6ECLRM SBT6ECLRM
extern volatile unsigned int   SBT6ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT6ECLRMbits_t;
extern volatile __SBT6ECLRMbits_t SBT6ECLRMbits __asm__ ("SBT6ECLRM") __attribute__((section("sfrs")));
#define SBT6REG0 SBT6REG0
extern volatile unsigned int   SBT6REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT6REG0bits_t;
extern volatile __SBT6REG0bits_t SBT6REG0bits __asm__ ("SBT6REG0") __attribute__((section("sfrs")));
#define SBT6RD0 SBT6RD0
extern volatile unsigned int   SBT6RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT6RD0bits_t;
extern volatile __SBT6RD0bits_t SBT6RD0bits __asm__ ("SBT6RD0") __attribute__((section("sfrs")));
#define SBT6WR0 SBT6WR0
extern volatile unsigned int   SBT6WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT6WR0bits_t;
extern volatile __SBT6WR0bits_t SBT6WR0bits __asm__ ("SBT6WR0") __attribute__((section("sfrs")));
#define SBT6REG1 SBT6REG1
extern volatile unsigned int   SBT6REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT6REG1bits_t;
extern volatile __SBT6REG1bits_t SBT6REG1bits __asm__ ("SBT6REG1") __attribute__((section("sfrs")));
#define SBT6RD1 SBT6RD1
extern volatile unsigned int   SBT6RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT6RD1bits_t;
extern volatile __SBT6RD1bits_t SBT6RD1bits __asm__ ("SBT6RD1") __attribute__((section("sfrs")));
#define SBT6WR1 SBT6WR1
extern volatile unsigned int   SBT6WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT6WR1bits_t;
extern volatile __SBT6WR1bits_t SBT6WR1bits __asm__ ("SBT6WR1") __attribute__((section("sfrs")));
#define SBT7ELOG1 SBT7ELOG1
extern volatile unsigned int   SBT7ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT7ELOG1bits_t;
extern volatile __SBT7ELOG1bits_t SBT7ELOG1bits __asm__ ("SBT7ELOG1") __attribute__((section("sfrs")));
#define SBT7ELOG2 SBT7ELOG2
extern volatile unsigned int   SBT7ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT7ELOG2bits_t;
extern volatile __SBT7ELOG2bits_t SBT7ELOG2bits __asm__ ("SBT7ELOG2") __attribute__((section("sfrs")));
#define SBT7ECON SBT7ECON
extern volatile unsigned int   SBT7ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT7ECONbits_t;
extern volatile __SBT7ECONbits_t SBT7ECONbits __asm__ ("SBT7ECON") __attribute__((section("sfrs")));
#define SBT7ECLRS SBT7ECLRS
extern volatile unsigned int   SBT7ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT7ECLRSbits_t;
extern volatile __SBT7ECLRSbits_t SBT7ECLRSbits __asm__ ("SBT7ECLRS") __attribute__((section("sfrs")));
#define SBT7ECLRM SBT7ECLRM
extern volatile unsigned int   SBT7ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT7ECLRMbits_t;
extern volatile __SBT7ECLRMbits_t SBT7ECLRMbits __asm__ ("SBT7ECLRM") __attribute__((section("sfrs")));
#define SBT7REG0 SBT7REG0
extern volatile unsigned int   SBT7REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT7REG0bits_t;
extern volatile __SBT7REG0bits_t SBT7REG0bits __asm__ ("SBT7REG0") __attribute__((section("sfrs")));
#define SBT7RD0 SBT7RD0
extern volatile unsigned int   SBT7RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT7RD0bits_t;
extern volatile __SBT7RD0bits_t SBT7RD0bits __asm__ ("SBT7RD0") __attribute__((section("sfrs")));
#define SBT7WR0 SBT7WR0
extern volatile unsigned int   SBT7WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT7WR0bits_t;
extern volatile __SBT7WR0bits_t SBT7WR0bits __asm__ ("SBT7WR0") __attribute__((section("sfrs")));
#define SBT7REG1 SBT7REG1
extern volatile unsigned int   SBT7REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT7REG1bits_t;
extern volatile __SBT7REG1bits_t SBT7REG1bits __asm__ ("SBT7REG1") __attribute__((section("sfrs")));
#define SBT7RD1 SBT7RD1
extern volatile unsigned int   SBT7RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT7RD1bits_t;
extern volatile __SBT7RD1bits_t SBT7RD1bits __asm__ ("SBT7RD1") __attribute__((section("sfrs")));
#define SBT7WR1 SBT7WR1
extern volatile unsigned int   SBT7WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT7WR1bits_t;
extern volatile __SBT7WR1bits_t SBT7WR1bits __asm__ ("SBT7WR1") __attribute__((section("sfrs")));
#define SBT8ELOG1 SBT8ELOG1
extern volatile unsigned int   SBT8ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT8ELOG1bits_t;
extern volatile __SBT8ELOG1bits_t SBT8ELOG1bits __asm__ ("SBT8ELOG1") __attribute__((section("sfrs")));
#define SBT8ELOG2 SBT8ELOG2
extern volatile unsigned int   SBT8ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT8ELOG2bits_t;
extern volatile __SBT8ELOG2bits_t SBT8ELOG2bits __asm__ ("SBT8ELOG2") __attribute__((section("sfrs")));
#define SBT8ECON SBT8ECON
extern volatile unsigned int   SBT8ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT8ECONbits_t;
extern volatile __SBT8ECONbits_t SBT8ECONbits __asm__ ("SBT8ECON") __attribute__((section("sfrs")));
#define SBT8ECLRS SBT8ECLRS
extern volatile unsigned int   SBT8ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT8ECLRSbits_t;
extern volatile __SBT8ECLRSbits_t SBT8ECLRSbits __asm__ ("SBT8ECLRS") __attribute__((section("sfrs")));
#define SBT8ECLRM SBT8ECLRM
extern volatile unsigned int   SBT8ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT8ECLRMbits_t;
extern volatile __SBT8ECLRMbits_t SBT8ECLRMbits __asm__ ("SBT8ECLRM") __attribute__((section("sfrs")));
#define SBT8REG0 SBT8REG0
extern volatile unsigned int   SBT8REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT8REG0bits_t;
extern volatile __SBT8REG0bits_t SBT8REG0bits __asm__ ("SBT8REG0") __attribute__((section("sfrs")));
#define SBT8RD0 SBT8RD0
extern volatile unsigned int   SBT8RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT8RD0bits_t;
extern volatile __SBT8RD0bits_t SBT8RD0bits __asm__ ("SBT8RD0") __attribute__((section("sfrs")));
#define SBT8WR0 SBT8WR0
extern volatile unsigned int   SBT8WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT8WR0bits_t;
extern volatile __SBT8WR0bits_t SBT8WR0bits __asm__ ("SBT8WR0") __attribute__((section("sfrs")));
#define SBT8REG1 SBT8REG1
extern volatile unsigned int   SBT8REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT8REG1bits_t;
extern volatile __SBT8REG1bits_t SBT8REG1bits __asm__ ("SBT8REG1") __attribute__((section("sfrs")));
#define SBT8RD1 SBT8RD1
extern volatile unsigned int   SBT8RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT8RD1bits_t;
extern volatile __SBT8RD1bits_t SBT8RD1bits __asm__ ("SBT8RD1") __attribute__((section("sfrs")));
#define SBT8WR1 SBT8WR1
extern volatile unsigned int   SBT8WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT8WR1bits_t;
extern volatile __SBT8WR1bits_t SBT8WR1bits __asm__ ("SBT8WR1") __attribute__((section("sfrs")));
#define SBT9ELOG1 SBT9ELOG1
extern volatile unsigned int   SBT9ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT9ELOG1bits_t;
extern volatile __SBT9ELOG1bits_t SBT9ELOG1bits __asm__ ("SBT9ELOG1") __attribute__((section("sfrs")));
#define SBT9ELOG2 SBT9ELOG2
extern volatile unsigned int   SBT9ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT9ELOG2bits_t;
extern volatile __SBT9ELOG2bits_t SBT9ELOG2bits __asm__ ("SBT9ELOG2") __attribute__((section("sfrs")));
#define SBT9ECON SBT9ECON
extern volatile unsigned int   SBT9ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT9ECONbits_t;
extern volatile __SBT9ECONbits_t SBT9ECONbits __asm__ ("SBT9ECON") __attribute__((section("sfrs")));
#define SBT9ECLRS SBT9ECLRS
extern volatile unsigned int   SBT9ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT9ECLRSbits_t;
extern volatile __SBT9ECLRSbits_t SBT9ECLRSbits __asm__ ("SBT9ECLRS") __attribute__((section("sfrs")));
#define SBT9ECLRM SBT9ECLRM
extern volatile unsigned int   SBT9ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT9ECLRMbits_t;
extern volatile __SBT9ECLRMbits_t SBT9ECLRMbits __asm__ ("SBT9ECLRM") __attribute__((section("sfrs")));
#define SBT9REG0 SBT9REG0
extern volatile unsigned int   SBT9REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT9REG0bits_t;
extern volatile __SBT9REG0bits_t SBT9REG0bits __asm__ ("SBT9REG0") __attribute__((section("sfrs")));
#define SBT9RD0 SBT9RD0
extern volatile unsigned int   SBT9RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT9RD0bits_t;
extern volatile __SBT9RD0bits_t SBT9RD0bits __asm__ ("SBT9RD0") __attribute__((section("sfrs")));
#define SBT9WR0 SBT9WR0
extern volatile unsigned int   SBT9WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT9WR0bits_t;
extern volatile __SBT9WR0bits_t SBT9WR0bits __asm__ ("SBT9WR0") __attribute__((section("sfrs")));
#define SBT9REG1 SBT9REG1
extern volatile unsigned int   SBT9REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT9REG1bits_t;
extern volatile __SBT9REG1bits_t SBT9REG1bits __asm__ ("SBT9REG1") __attribute__((section("sfrs")));
#define SBT9RD1 SBT9RD1
extern volatile unsigned int   SBT9RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT9RD1bits_t;
extern volatile __SBT9RD1bits_t SBT9RD1bits __asm__ ("SBT9RD1") __attribute__((section("sfrs")));
#define SBT9WR1 SBT9WR1
extern volatile unsigned int   SBT9WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT9WR1bits_t;
extern volatile __SBT9WR1bits_t SBT9WR1bits __asm__ ("SBT9WR1") __attribute__((section("sfrs")));
#define SBT10ELOG1 SBT10ELOG1
extern volatile unsigned int   SBT10ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT10ELOG1bits_t;
extern volatile __SBT10ELOG1bits_t SBT10ELOG1bits __asm__ ("SBT10ELOG1") __attribute__((section("sfrs")));
#define SBT10ELOG2 SBT10ELOG2
extern volatile unsigned int   SBT10ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT10ELOG2bits_t;
extern volatile __SBT10ELOG2bits_t SBT10ELOG2bits __asm__ ("SBT10ELOG2") __attribute__((section("sfrs")));
#define SBT10ECON SBT10ECON
extern volatile unsigned int   SBT10ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT10ECONbits_t;
extern volatile __SBT10ECONbits_t SBT10ECONbits __asm__ ("SBT10ECON") __attribute__((section("sfrs")));
#define SBT10ECLRS SBT10ECLRS
extern volatile unsigned int   SBT10ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT10ECLRSbits_t;
extern volatile __SBT10ECLRSbits_t SBT10ECLRSbits __asm__ ("SBT10ECLRS") __attribute__((section("sfrs")));
#define SBT10ECLRM SBT10ECLRM
extern volatile unsigned int   SBT10ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT10ECLRMbits_t;
extern volatile __SBT10ECLRMbits_t SBT10ECLRMbits __asm__ ("SBT10ECLRM") __attribute__((section("sfrs")));
#define SBT10REG0 SBT10REG0
extern volatile unsigned int   SBT10REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT10REG0bits_t;
extern volatile __SBT10REG0bits_t SBT10REG0bits __asm__ ("SBT10REG0") __attribute__((section("sfrs")));
#define SBT10RD0 SBT10RD0
extern volatile unsigned int   SBT10RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT10RD0bits_t;
extern volatile __SBT10RD0bits_t SBT10RD0bits __asm__ ("SBT10RD0") __attribute__((section("sfrs")));
#define SBT10WR0 SBT10WR0
extern volatile unsigned int   SBT10WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT10WR0bits_t;
extern volatile __SBT10WR0bits_t SBT10WR0bits __asm__ ("SBT10WR0") __attribute__((section("sfrs")));
#define SBT11ELOG1 SBT11ELOG1
extern volatile unsigned int   SBT11ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT11ELOG1bits_t;
extern volatile __SBT11ELOG1bits_t SBT11ELOG1bits __asm__ ("SBT11ELOG1") __attribute__((section("sfrs")));
#define SBT11ELOG2 SBT11ELOG2
extern volatile unsigned int   SBT11ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT11ELOG2bits_t;
extern volatile __SBT11ELOG2bits_t SBT11ELOG2bits __asm__ ("SBT11ELOG2") __attribute__((section("sfrs")));
#define SBT11ECON SBT11ECON
extern volatile unsigned int   SBT11ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT11ECONbits_t;
extern volatile __SBT11ECONbits_t SBT11ECONbits __asm__ ("SBT11ECON") __attribute__((section("sfrs")));
#define SBT11ECLRS SBT11ECLRS
extern volatile unsigned int   SBT11ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT11ECLRSbits_t;
extern volatile __SBT11ECLRSbits_t SBT11ECLRSbits __asm__ ("SBT11ECLRS") __attribute__((section("sfrs")));
#define SBT11ECLRM SBT11ECLRM
extern volatile unsigned int   SBT11ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT11ECLRMbits_t;
extern volatile __SBT11ECLRMbits_t SBT11ECLRMbits __asm__ ("SBT11ECLRM") __attribute__((section("sfrs")));
#define SBT11REG0 SBT11REG0
extern volatile unsigned int   SBT11REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT11REG0bits_t;
extern volatile __SBT11REG0bits_t SBT11REG0bits __asm__ ("SBT11REG0") __attribute__((section("sfrs")));
#define SBT11RD0 SBT11RD0
extern volatile unsigned int   SBT11RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT11RD0bits_t;
extern volatile __SBT11RD0bits_t SBT11RD0bits __asm__ ("SBT11RD0") __attribute__((section("sfrs")));
#define SBT11WR0 SBT11WR0
extern volatile unsigned int   SBT11WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT11WR0bits_t;
extern volatile __SBT11WR0bits_t SBT11WR0bits __asm__ ("SBT11WR0") __attribute__((section("sfrs")));
#define SBT11REG1 SBT11REG1
extern volatile unsigned int   SBT11REG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT11REG1bits_t;
extern volatile __SBT11REG1bits_t SBT11REG1bits __asm__ ("SBT11REG1") __attribute__((section("sfrs")));
#define SBT11RD1 SBT11RD1
extern volatile unsigned int   SBT11RD1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT11RD1bits_t;
extern volatile __SBT11RD1bits_t SBT11RD1bits __asm__ ("SBT11RD1") __attribute__((section("sfrs")));
#define SBT11WR1 SBT11WR1
extern volatile unsigned int   SBT11WR1 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT11WR1bits_t;
extern volatile __SBT11WR1bits_t SBT11WR1bits __asm__ ("SBT11WR1") __attribute__((section("sfrs")));
#define SBT12ELOG1 SBT12ELOG1
extern volatile unsigned int   SBT12ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT12ELOG1bits_t;
extern volatile __SBT12ELOG1bits_t SBT12ELOG1bits __asm__ ("SBT12ELOG1") __attribute__((section("sfrs")));
#define SBT12ELOG2 SBT12ELOG2
extern volatile unsigned int   SBT12ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT12ELOG2bits_t;
extern volatile __SBT12ELOG2bits_t SBT12ELOG2bits __asm__ ("SBT12ELOG2") __attribute__((section("sfrs")));
#define SBT12ECON SBT12ECON
extern volatile unsigned int   SBT12ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT12ECONbits_t;
extern volatile __SBT12ECONbits_t SBT12ECONbits __asm__ ("SBT12ECON") __attribute__((section("sfrs")));
#define SBT12ECLRS SBT12ECLRS
extern volatile unsigned int   SBT12ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT12ECLRSbits_t;
extern volatile __SBT12ECLRSbits_t SBT12ECLRSbits __asm__ ("SBT12ECLRS") __attribute__((section("sfrs")));
#define SBT12ECLRM SBT12ECLRM
extern volatile unsigned int   SBT12ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT12ECLRMbits_t;
extern volatile __SBT12ECLRMbits_t SBT12ECLRMbits __asm__ ("SBT12ECLRM") __attribute__((section("sfrs")));
#define SBT12REG0 SBT12REG0
extern volatile unsigned int   SBT12REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT12REG0bits_t;
extern volatile __SBT12REG0bits_t SBT12REG0bits __asm__ ("SBT12REG0") __attribute__((section("sfrs")));
#define SBT12RD0 SBT12RD0
extern volatile unsigned int   SBT12RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT12RD0bits_t;
extern volatile __SBT12RD0bits_t SBT12RD0bits __asm__ ("SBT12RD0") __attribute__((section("sfrs")));
#define SBT12WR0 SBT12WR0
extern volatile unsigned int   SBT12WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT12WR0bits_t;
extern volatile __SBT12WR0bits_t SBT12WR0bits __asm__ ("SBT12WR0") __attribute__((section("sfrs")));
#define SBT13ELOG1 SBT13ELOG1
extern volatile unsigned int   SBT13ELOG1 __attribute__((section("sfrs")));
typedef struct {
  unsigned CMD:3;
  unsigned :1;
  unsigned REGION:4;
  unsigned INITID:8;
  unsigned :8;
  unsigned CODE:4;
  unsigned :3;
  unsigned MULTI:1;
} __SBT13ELOG1bits_t;
extern volatile __SBT13ELOG1bits_t SBT13ELOG1bits __asm__ ("SBT13ELOG1") __attribute__((section("sfrs")));
#define SBT13ELOG2 SBT13ELOG2
extern volatile unsigned int   SBT13ELOG2 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP:2;
} __SBT13ELOG2bits_t;
extern volatile __SBT13ELOG2bits_t SBT13ELOG2bits __asm__ ("SBT13ELOG2") __attribute__((section("sfrs")));
#define SBT13ECON SBT13ECON
extern volatile unsigned int   SBT13ECON __attribute__((section("sfrs")));
typedef struct {
  unsigned :24;
  unsigned ERRP:1;
} __SBT13ECONbits_t;
extern volatile __SBT13ECONbits_t SBT13ECONbits __asm__ ("SBT13ECON") __attribute__((section("sfrs")));
#define SBT13ECLRS SBT13ECLRS
extern volatile unsigned int   SBT13ECLRS __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT13ECLRSbits_t;
extern volatile __SBT13ECLRSbits_t SBT13ECLRSbits __asm__ ("SBT13ECLRS") __attribute__((section("sfrs")));
#define SBT13ECLRM SBT13ECLRM
extern volatile unsigned int   SBT13ECLRM __attribute__((section("sfrs")));
typedef struct {
  unsigned CLEAR:1;
} __SBT13ECLRMbits_t;
extern volatile __SBT13ECLRMbits_t SBT13ECLRMbits __asm__ ("SBT13ECLRM") __attribute__((section("sfrs")));
#define SBT13REG0 SBT13REG0
extern volatile unsigned int   SBT13REG0 __attribute__((section("sfrs")));
typedef struct {
  unsigned :3;
  unsigned SIZE:5;
  unsigned :1;
  unsigned PRI:1;
  unsigned BASE:22;
} __SBT13REG0bits_t;
extern volatile __SBT13REG0bits_t SBT13REG0bits __asm__ ("SBT13REG0") __attribute__((section("sfrs")));
#define SBT13RD0 SBT13RD0
extern volatile unsigned int   SBT13RD0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT13RD0bits_t;
extern volatile __SBT13RD0bits_t SBT13RD0bits __asm__ ("SBT13RD0") __attribute__((section("sfrs")));
#define SBT13WR0 SBT13WR0
extern volatile unsigned int   SBT13WR0 __attribute__((section("sfrs")));
typedef struct {
  unsigned GROUP0:1;
  unsigned GROUP1:1;
  unsigned GROUP2:1;
  unsigned GROUP3:1;
} __SBT13WR0bits_t;
extern volatile __SBT13WR0bits_t SBT13WR0bits __asm__ ("SBT13WR0") __attribute__((section("sfrs")));
#define DEVCFG3 DEVCFG3
extern volatile unsigned int   DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __DEVCFG3bits_t;
extern volatile __DEVCFG3bits_t DEVCFG3bits __asm__ ("DEVCFG3") __attribute__((section("sfrs")));
#define DEVCFG2 DEVCFG2
extern volatile unsigned int   DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
  };
  struct {
    unsigned w:32;
  };
} __DEVCFG2bits_t;
extern volatile __DEVCFG2bits_t DEVCFG2bits __asm__ ("DEVCFG2") __attribute__((section("sfrs")));
#define DEVCFG1 DEVCFG1
extern volatile unsigned int   DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __DEVCFG1bits_t;
extern volatile __DEVCFG1bits_t DEVCFG1bits __asm__ ("DEVCFG1") __attribute__((section("sfrs")));
#define DEVCFG0 DEVCFG0
extern volatile unsigned int   DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned SMCLR:1;
    unsigned SOSCGAIN:2;
    unsigned SOSCBOOST:1;
    unsigned POSCGAIN:2;
    unsigned POSCBOOST:1;
    unsigned :8;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __DEVCFG0bits_t;
extern volatile __DEVCFG0bits_t DEVCFG0bits __asm__ ("DEVCFG0") __attribute__((section("sfrs")));
#define DEVCP3 DEVCP3
extern volatile unsigned int   DEVCP3 __attribute__((section("sfrs")));
#define DEVCP2 DEVCP2
extern volatile unsigned int   DEVCP2 __attribute__((section("sfrs")));
#define DEVCP1 DEVCP1
extern volatile unsigned int   DEVCP1 __attribute__((section("sfrs")));
#define DEVCP0 DEVCP0
extern volatile unsigned int   DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __DEVCP0bits_t;
extern volatile __DEVCP0bits_t DEVCP0bits __asm__ ("DEVCP0") __attribute__((section("sfrs")));
#define DEVSIGN3 DEVSIGN3
extern volatile unsigned int   DEVSIGN3 __attribute__((section("sfrs")));
#define DEVSIGN2 DEVSIGN2
extern volatile unsigned int   DEVSIGN2 __attribute__((section("sfrs")));
#define DEVSIGN1 DEVSIGN1
extern volatile unsigned int   DEVSIGN1 __attribute__((section("sfrs")));
#define DEVSIGN0 DEVSIGN0
extern volatile unsigned int   DEVSIGN0 __attribute__((section("sfrs")));
#define SEQ3 SEQ3
extern volatile unsigned int   SEQ3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __SEQ3bits_t;
extern volatile __SEQ3bits_t SEQ3bits __asm__ ("SEQ3") __attribute__((section("sfrs")));
#define SEQ2 SEQ2
extern volatile unsigned int   SEQ2 __attribute__((section("sfrs")));
#define SEQ1 SEQ1
extern volatile unsigned int   SEQ1 __attribute__((section("sfrs")));
#define SEQ0 SEQ0
extern volatile unsigned int   SEQ0 __attribute__((section("sfrs")));
#define DEVSN0 DEVSN0
extern volatile unsigned int   DEVSN0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SN:32;
  };
  struct {
    unsigned w:32;
  };
} __DEVSN0bits_t;
extern volatile __DEVSN0bits_t DEVSN0bits __asm__ ("DEVSN0") __attribute__((section("sfrs")));
#define DEVSN1 DEVSN1
extern volatile unsigned int   DEVSN1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned SN:32;
  };
  struct {
    unsigned w:32;
  };
} __DEVSN1bits_t;
extern volatile __DEVSN1bits_t DEVSN1bits __asm__ ("DEVSN1") __attribute__((section("sfrs")));
#define ADEVCFG3 ADEVCFG3
extern volatile unsigned int   ADEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCFG3bits_t;
extern volatile __ADEVCFG3bits_t ADEVCFG3bits __asm__ ("ADEVCFG3") __attribute__((section("sfrs")));
#define ADEVCFG2 ADEVCFG2
extern volatile unsigned int   ADEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCFG2bits_t;
extern volatile __ADEVCFG2bits_t ADEVCFG2bits __asm__ ("ADEVCFG2") __attribute__((section("sfrs")));
#define ADEVCFG1 ADEVCFG1
extern volatile unsigned int   ADEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCFG1bits_t;
extern volatile __ADEVCFG1bits_t ADEVCFG1bits __asm__ ("ADEVCFG1") __attribute__((section("sfrs")));
#define ADEVCFG0 ADEVCFG0
extern volatile unsigned int   ADEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned SMCLR:1;
    unsigned SOSCGAIN:2;
    unsigned SOSCBOOST:1;
    unsigned POSCGAIN:2;
    unsigned POSCBOOST:1;
    unsigned :8;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCFG0bits_t;
extern volatile __ADEVCFG0bits_t ADEVCFG0bits __asm__ ("ADEVCFG0") __attribute__((section("sfrs")));
#define ADEVCP3 ADEVCP3
extern volatile unsigned int   ADEVCP3 __attribute__((section("sfrs")));
#define ADEVCP2 ADEVCP2
extern volatile unsigned int   ADEVCP2 __attribute__((section("sfrs")));
#define ADEVCP1 ADEVCP1
extern volatile unsigned int   ADEVCP1 __attribute__((section("sfrs")));
#define ADEVCP0 ADEVCP0
extern volatile unsigned int   ADEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __ADEVCP0bits_t;
extern volatile __ADEVCP0bits_t ADEVCP0bits __asm__ ("ADEVCP0") __attribute__((section("sfrs")));
#define ADEVSIGN3 ADEVSIGN3
extern volatile unsigned int   ADEVSIGN3 __attribute__((section("sfrs")));
#define ADEVSIGN2 ADEVSIGN2
extern volatile unsigned int   ADEVSIGN2 __attribute__((section("sfrs")));
#define ADEVSIGN1 ADEVSIGN1
extern volatile unsigned int   ADEVSIGN1 __attribute__((section("sfrs")));
#define ADEVSIGN0 ADEVSIGN0
extern volatile unsigned int   ADEVSIGN0 __attribute__((section("sfrs")));
#define ASEQ3 ASEQ3
extern volatile unsigned int   ASEQ3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __ASEQ3bits_t;
extern volatile __ASEQ3bits_t ASEQ3bits __asm__ ("ASEQ3") __attribute__((section("sfrs")));
#define ASEQ2 ASEQ2
extern volatile unsigned int   ASEQ2 __attribute__((section("sfrs")));
#define ASEQ1 ASEQ1
extern volatile unsigned int   ASEQ1 __attribute__((section("sfrs")));
#define ASEQ0 ASEQ0
extern volatile unsigned int   ASEQ0 __attribute__((section("sfrs")));
#define AUBADEVCFG3 AUBADEVCFG3
extern volatile unsigned int   AUBADEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __AUBADEVCFG3bits_t;
extern volatile __AUBADEVCFG3bits_t AUBADEVCFG3bits __asm__ ("AUBADEVCFG3") __attribute__((section("sfrs")));
#define AUBADEVCFG2 AUBADEVCFG2
extern volatile unsigned int   AUBADEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
  };
  struct {
    unsigned w:32;
  };
} __AUBADEVCFG2bits_t;
extern volatile __AUBADEVCFG2bits_t AUBADEVCFG2bits __asm__ ("AUBADEVCFG2") __attribute__((section("sfrs")));
#define AUBADEVCFG1 AUBADEVCFG1
extern volatile unsigned int   AUBADEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __AUBADEVCFG1bits_t;
extern volatile __AUBADEVCFG1bits_t AUBADEVCFG1bits __asm__ ("AUBADEVCFG1") __attribute__((section("sfrs")));
#define AUBADEVCFG0 AUBADEVCFG0
extern volatile unsigned int   AUBADEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned SMCLR:1;
    unsigned SOSCGAIN:2;
    unsigned SOSCBOOST:1;
    unsigned POSCGAIN:2;
    unsigned POSCBOOST:1;
    unsigned :8;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __AUBADEVCFG0bits_t;
extern volatile __AUBADEVCFG0bits_t AUBADEVCFG0bits __asm__ ("AUBADEVCFG0") __attribute__((section("sfrs")));
#define AUBADEVCP3 AUBADEVCP3
extern volatile unsigned int   AUBADEVCP3 __attribute__((section("sfrs")));
#define AUBADEVCP2 AUBADEVCP2
extern volatile unsigned int   AUBADEVCP2 __attribute__((section("sfrs")));
#define AUBADEVCP1 AUBADEVCP1
extern volatile unsigned int   AUBADEVCP1 __attribute__((section("sfrs")));
#define AUBADEVCP0 AUBADEVCP0
extern volatile unsigned int   AUBADEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __AUBADEVCP0bits_t;
extern volatile __AUBADEVCP0bits_t AUBADEVCP0bits __asm__ ("AUBADEVCP0") __attribute__((section("sfrs")));
#define AUBADEVSIGN3 AUBADEVSIGN3
extern volatile unsigned int   AUBADEVSIGN3 __attribute__((section("sfrs")));
#define AUBADEVSIGN2 AUBADEVSIGN2
extern volatile unsigned int   AUBADEVSIGN2 __attribute__((section("sfrs")));
#define AUBADEVSIGN1 AUBADEVSIGN1
extern volatile unsigned int   AUBADEVSIGN1 __attribute__((section("sfrs")));
#define AUBADEVSIGN0 AUBADEVSIGN0
extern volatile unsigned int   AUBADEVSIGN0 __attribute__((section("sfrs")));
#define AUBASEQ3 AUBASEQ3
extern volatile unsigned int   AUBASEQ3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __AUBASEQ3bits_t;
extern volatile __AUBASEQ3bits_t AUBASEQ3bits __asm__ ("AUBASEQ3") __attribute__((section("sfrs")));
#define AUBASEQ2 AUBASEQ2
extern volatile unsigned int   AUBASEQ2 __attribute__((section("sfrs")));
#define AUBASEQ1 AUBASEQ1
extern volatile unsigned int   AUBASEQ1 __attribute__((section("sfrs")));
#define AUBASEQ0 AUBASEQ0
extern volatile unsigned int   AUBASEQ0 __attribute__((section("sfrs")));
#define UBADEVCFG3 UBADEVCFG3
extern volatile unsigned int   UBADEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __UBADEVCFG3bits_t;
extern volatile __UBADEVCFG3bits_t UBADEVCFG3bits __asm__ ("UBADEVCFG3") __attribute__((section("sfrs")));
#define UBADEVCFG2 UBADEVCFG2
extern volatile unsigned int   UBADEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
  };
  struct {
    unsigned w:32;
  };
} __UBADEVCFG2bits_t;
extern volatile __UBADEVCFG2bits_t UBADEVCFG2bits __asm__ ("UBADEVCFG2") __attribute__((section("sfrs")));
#define UBADEVCFG1 UBADEVCFG1
extern volatile unsigned int   UBADEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __UBADEVCFG1bits_t;
extern volatile __UBADEVCFG1bits_t UBADEVCFG1bits __asm__ ("UBADEVCFG1") __attribute__((section("sfrs")));
#define UBADEVCFG0 UBADEVCFG0
extern volatile unsigned int   UBADEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned SMCLR:1;
    unsigned SOSCGAIN:2;
    unsigned SOSCBOOST:1;
    unsigned POSCGAIN:2;
    unsigned POSCBOOST:1;
    unsigned :8;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __UBADEVCFG0bits_t;
extern volatile __UBADEVCFG0bits_t UBADEVCFG0bits __asm__ ("UBADEVCFG0") __attribute__((section("sfrs")));
#define UBADEVCP3 UBADEVCP3
extern volatile unsigned int   UBADEVCP3 __attribute__((section("sfrs")));
#define UBADEVCP2 UBADEVCP2
extern volatile unsigned int   UBADEVCP2 __attribute__((section("sfrs")));
#define UBADEVCP1 UBADEVCP1
extern volatile unsigned int   UBADEVCP1 __attribute__((section("sfrs")));
#define UBADEVCP0 UBADEVCP0
extern volatile unsigned int   UBADEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __UBADEVCP0bits_t;
extern volatile __UBADEVCP0bits_t UBADEVCP0bits __asm__ ("UBADEVCP0") __attribute__((section("sfrs")));
#define UBADEVSIGN3 UBADEVSIGN3
extern volatile unsigned int   UBADEVSIGN3 __attribute__((section("sfrs")));
#define UBADEVSIGN2 UBADEVSIGN2
extern volatile unsigned int   UBADEVSIGN2 __attribute__((section("sfrs")));
#define UBADEVSIGN1 UBADEVSIGN1
extern volatile unsigned int   UBADEVSIGN1 __attribute__((section("sfrs")));
#define UBADEVSIGN0 UBADEVSIGN0
extern volatile unsigned int   UBADEVSIGN0 __attribute__((section("sfrs")));
#define UBASEQ3 UBASEQ3
extern volatile unsigned int   UBASEQ3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __UBASEQ3bits_t;
extern volatile __UBASEQ3bits_t UBASEQ3bits __asm__ ("UBASEQ3") __attribute__((section("sfrs")));
#define UBASEQ2 UBASEQ2
extern volatile unsigned int   UBASEQ2 __attribute__((section("sfrs")));
#define UBASEQ1 UBASEQ1
extern volatile unsigned int   UBASEQ1 __attribute__((section("sfrs")));
#define UBASEQ0 UBASEQ0
extern volatile unsigned int   UBASEQ0 __attribute__((section("sfrs")));
#define ABF1DEVCFG3 ABF1DEVCFG3
extern volatile unsigned int   ABF1DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCFG3bits_t;
extern volatile __ABF1DEVCFG3bits_t ABF1DEVCFG3bits __asm__ ("ABF1DEVCFG3") __attribute__((section("sfrs")));
#define ABF1DEVCFG2 ABF1DEVCFG2
extern volatile unsigned int   ABF1DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCFG2bits_t;
extern volatile __ABF1DEVCFG2bits_t ABF1DEVCFG2bits __asm__ ("ABF1DEVCFG2") __attribute__((section("sfrs")));
#define ABF1DEVCFG1 ABF1DEVCFG1
extern volatile unsigned int   ABF1DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCFG1bits_t;
extern volatile __ABF1DEVCFG1bits_t ABF1DEVCFG1bits __asm__ ("ABF1DEVCFG1") __attribute__((section("sfrs")));
#define ABF1DEVCFG0 ABF1DEVCFG0
extern volatile unsigned int   ABF1DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned SMCLR:1;
    unsigned SOSCGAIN:2;
    unsigned SOSCBOOST:1;
    unsigned POSCGAIN:2;
    unsigned POSCBOOST:1;
    unsigned :8;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCFG0bits_t;
extern volatile __ABF1DEVCFG0bits_t ABF1DEVCFG0bits __asm__ ("ABF1DEVCFG0") __attribute__((section("sfrs")));
#define ABF1DEVCP3 ABF1DEVCP3
extern volatile unsigned int   ABF1DEVCP3 __attribute__((section("sfrs")));
#define ABF1DEVCP2 ABF1DEVCP2
extern volatile unsigned int   ABF1DEVCP2 __attribute__((section("sfrs")));
#define ABF1DEVCP1 ABF1DEVCP1
extern volatile unsigned int   ABF1DEVCP1 __attribute__((section("sfrs")));
#define ABF1DEVCP0 ABF1DEVCP0
extern volatile unsigned int   ABF1DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF1DEVCP0bits_t;
extern volatile __ABF1DEVCP0bits_t ABF1DEVCP0bits __asm__ ("ABF1DEVCP0") __attribute__((section("sfrs")));
#define ABF1DEVSIGN3 ABF1DEVSIGN3
extern volatile unsigned int   ABF1DEVSIGN3 __attribute__((section("sfrs")));
#define ABF1DEVSIGN2 ABF1DEVSIGN2
extern volatile unsigned int   ABF1DEVSIGN2 __attribute__((section("sfrs")));
#define ABF1DEVSIGN1 ABF1DEVSIGN1
extern volatile unsigned int   ABF1DEVSIGN1 __attribute__((section("sfrs")));
#define ABF1DEVSIGN0 ABF1DEVSIGN0
extern volatile unsigned int   ABF1DEVSIGN0 __attribute__((section("sfrs")));
#define ABF1SEQ3 ABF1SEQ3
extern volatile unsigned int   ABF1SEQ3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __ABF1SEQ3bits_t;
extern volatile __ABF1SEQ3bits_t ABF1SEQ3bits __asm__ ("ABF1SEQ3") __attribute__((section("sfrs")));
#define ABF1SEQ2 ABF1SEQ2
extern volatile unsigned int   ABF1SEQ2 __attribute__((section("sfrs")));
#define ABF1SEQ1 ABF1SEQ1
extern volatile unsigned int   ABF1SEQ1 __attribute__((section("sfrs")));
#define ABF1SEQ0 ABF1SEQ0
extern volatile unsigned int   ABF1SEQ0 __attribute__((section("sfrs")));
#define BF1DEVCFG3 BF1DEVCFG3
extern volatile unsigned int   BF1DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCFG3bits_t;
extern volatile __BF1DEVCFG3bits_t BF1DEVCFG3bits __asm__ ("BF1DEVCFG3") __attribute__((section("sfrs")));
#define BF1DEVCFG2 BF1DEVCFG2
extern volatile unsigned int   BF1DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCFG2bits_t;
extern volatile __BF1DEVCFG2bits_t BF1DEVCFG2bits __asm__ ("BF1DEVCFG2") __attribute__((section("sfrs")));
#define BF1DEVCFG1 BF1DEVCFG1
extern volatile unsigned int   BF1DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCFG1bits_t;
extern volatile __BF1DEVCFG1bits_t BF1DEVCFG1bits __asm__ ("BF1DEVCFG1") __attribute__((section("sfrs")));
#define BF1DEVCFG0 BF1DEVCFG0
extern volatile unsigned int   BF1DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned SMCLR:1;
    unsigned SOSCGAIN:2;
    unsigned SOSCBOOST:1;
    unsigned POSCGAIN:2;
    unsigned POSCBOOST:1;
    unsigned :8;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCFG0bits_t;
extern volatile __BF1DEVCFG0bits_t BF1DEVCFG0bits __asm__ ("BF1DEVCFG0") __attribute__((section("sfrs")));
#define BF1DEVCP3 BF1DEVCP3
extern volatile unsigned int   BF1DEVCP3 __attribute__((section("sfrs")));
#define BF1DEVCP2 BF1DEVCP2
extern volatile unsigned int   BF1DEVCP2 __attribute__((section("sfrs")));
#define BF1DEVCP1 BF1DEVCP1
extern volatile unsigned int   BF1DEVCP1 __attribute__((section("sfrs")));
#define BF1DEVCP0 BF1DEVCP0
extern volatile unsigned int   BF1DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __BF1DEVCP0bits_t;
extern volatile __BF1DEVCP0bits_t BF1DEVCP0bits __asm__ ("BF1DEVCP0") __attribute__((section("sfrs")));
#define BF1DEVSIGN3 BF1DEVSIGN3
extern volatile unsigned int   BF1DEVSIGN3 __attribute__((section("sfrs")));
#define BF1DEVSIGN2 BF1DEVSIGN2
extern volatile unsigned int   BF1DEVSIGN2 __attribute__((section("sfrs")));
#define BF1DEVSIGN1 BF1DEVSIGN1
extern volatile unsigned int   BF1DEVSIGN1 __attribute__((section("sfrs")));
#define BF1DEVSIGN0 BF1DEVSIGN0
extern volatile unsigned int   BF1DEVSIGN0 __attribute__((section("sfrs")));
#define BF1SEQ3 BF1SEQ3
extern volatile unsigned int   BF1SEQ3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __BF1SEQ3bits_t;
extern volatile __BF1SEQ3bits_t BF1SEQ3bits __asm__ ("BF1SEQ3") __attribute__((section("sfrs")));
#define BF1SEQ2 BF1SEQ2
extern volatile unsigned int   BF1SEQ2 __attribute__((section("sfrs")));
#define BF1SEQ1 BF1SEQ1
extern volatile unsigned int   BF1SEQ1 __attribute__((section("sfrs")));
#define BF1SEQ0 BF1SEQ0
extern volatile unsigned int   BF1SEQ0 __attribute__((section("sfrs")));
#define ABF2DEVCFG3 ABF2DEVCFG3
extern volatile unsigned int   ABF2DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCFG3bits_t;
extern volatile __ABF2DEVCFG3bits_t ABF2DEVCFG3bits __asm__ ("ABF2DEVCFG3") __attribute__((section("sfrs")));
#define ABF2DEVCFG2 ABF2DEVCFG2
extern volatile unsigned int   ABF2DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCFG2bits_t;
extern volatile __ABF2DEVCFG2bits_t ABF2DEVCFG2bits __asm__ ("ABF2DEVCFG2") __attribute__((section("sfrs")));
#define ABF2DEVCFG1 ABF2DEVCFG1
extern volatile unsigned int   ABF2DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCFG1bits_t;
extern volatile __ABF2DEVCFG1bits_t ABF2DEVCFG1bits __asm__ ("ABF2DEVCFG1") __attribute__((section("sfrs")));
#define ABF2DEVCFG0 ABF2DEVCFG0
extern volatile unsigned int   ABF2DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned SMCLR:1;
    unsigned SOSCGAIN:2;
    unsigned SOSCBOOST:1;
    unsigned POSCGAIN:2;
    unsigned POSCBOOST:1;
    unsigned :8;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCFG0bits_t;
extern volatile __ABF2DEVCFG0bits_t ABF2DEVCFG0bits __asm__ ("ABF2DEVCFG0") __attribute__((section("sfrs")));
#define ABF2DEVCP3 ABF2DEVCP3
extern volatile unsigned int   ABF2DEVCP3 __attribute__((section("sfrs")));
#define ABF2DEVCP2 ABF2DEVCP2
extern volatile unsigned int   ABF2DEVCP2 __attribute__((section("sfrs")));
#define ABF2DEVCP1 ABF2DEVCP1
extern volatile unsigned int   ABF2DEVCP1 __attribute__((section("sfrs")));
#define ABF2DEVCP0 ABF2DEVCP0
extern volatile unsigned int   ABF2DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __ABF2DEVCP0bits_t;
extern volatile __ABF2DEVCP0bits_t ABF2DEVCP0bits __asm__ ("ABF2DEVCP0") __attribute__((section("sfrs")));
#define ABF2DEVSIGN3 ABF2DEVSIGN3
extern volatile unsigned int   ABF2DEVSIGN3 __attribute__((section("sfrs")));
#define ABF2DEVSIGN2 ABF2DEVSIGN2
extern volatile unsigned int   ABF2DEVSIGN2 __attribute__((section("sfrs")));
#define ABF2DEVSIGN1 ABF2DEVSIGN1
extern volatile unsigned int   ABF2DEVSIGN1 __attribute__((section("sfrs")));
#define ABF2DEVSIGN0 ABF2DEVSIGN0
extern volatile unsigned int   ABF2DEVSIGN0 __attribute__((section("sfrs")));
#define ABF2SEQ3 ABF2SEQ3
extern volatile unsigned int   ABF2SEQ3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __ABF2SEQ3bits_t;
extern volatile __ABF2SEQ3bits_t ABF2SEQ3bits __asm__ ("ABF2SEQ3") __attribute__((section("sfrs")));
#define ABF2SEQ2 ABF2SEQ2
extern volatile unsigned int   ABF2SEQ2 __attribute__((section("sfrs")));
#define ABF2SEQ1 ABF2SEQ1
extern volatile unsigned int   ABF2SEQ1 __attribute__((section("sfrs")));
#define ABF2SEQ0 ABF2SEQ0
extern volatile unsigned int   ABF2SEQ0 __attribute__((section("sfrs")));
#define BF2DEVCFG3 BF2DEVCFG3
extern volatile unsigned int   BF2DEVCFG3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned USERID:16;
    unsigned :8;
    unsigned FMIIEN:1;
    unsigned FETHIO:1;
    unsigned :1;
    unsigned PGL1WAY:1;
    unsigned PMDL1WAY:1;
    unsigned IOL1WAY:1;
    unsigned FUSBIDIO:1;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCFG3bits_t;
extern volatile __BF2DEVCFG3bits_t BF2DEVCFG3bits __asm__ ("BF2DEVCFG3") __attribute__((section("sfrs")));
#define BF2DEVCFG2 BF2DEVCFG2
extern volatile unsigned int   BF2DEVCFG2 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FPLLIDIV:3;
    unsigned :1;
    unsigned FPLLRNG:3;
    unsigned FPLLICLK:1;
    unsigned FPLLMULT:7;
    unsigned :1;
    unsigned FPLLODIV:3;
    unsigned :11;
    unsigned UPLLFSEL:1;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCFG2bits_t;
extern volatile __BF2DEVCFG2bits_t BF2DEVCFG2bits __asm__ ("BF2DEVCFG2") __attribute__((section("sfrs")));
#define BF2DEVCFG1 BF2DEVCFG1
extern volatile unsigned int   BF2DEVCFG1 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned FNOSC:3;
    unsigned DMTINTV:3;
    unsigned FSOSCEN:1;
    unsigned IESO:1;
    unsigned POSCMOD:2;
    unsigned OSCIOFNC:1;
    unsigned :3;
    unsigned FCKSM:2;
    unsigned WDTPS:5;
    unsigned WDTSPGM:1;
    unsigned WINDIS:1;
    unsigned FWDTEN:1;
    unsigned FWDTWINSZ:2;
    unsigned DMTCNT:5;
    unsigned FDMTEN:1;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCFG1bits_t;
extern volatile __BF2DEVCFG1bits_t BF2DEVCFG1bits __asm__ ("BF2DEVCFG1") __attribute__((section("sfrs")));
#define BF2DEVCFG0 BF2DEVCFG0
extern volatile unsigned int   BF2DEVCFG0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned DEBUG:2;
    unsigned JTAGEN:1;
    unsigned ICESEL:2;
    unsigned TRCEN:1;
    unsigned BOOTISA:1;
    unsigned :1;
    unsigned FECCCON:2;
    unsigned FSLEEP:1;
    unsigned :1;
    unsigned DBGPER:3;
    unsigned SMCLR:1;
    unsigned SOSCGAIN:2;
    unsigned SOSCBOOST:1;
    unsigned POSCGAIN:2;
    unsigned POSCBOOST:1;
    unsigned :8;
    unsigned EJTAGBEN:1;
  };
  struct {
    unsigned FDEBUG:2;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCFG0bits_t;
extern volatile __BF2DEVCFG0bits_t BF2DEVCFG0bits __asm__ ("BF2DEVCFG0") __attribute__((section("sfrs")));
#define BF2DEVCP3 BF2DEVCP3
extern volatile unsigned int   BF2DEVCP3 __attribute__((section("sfrs")));
#define BF2DEVCP2 BF2DEVCP2
extern volatile unsigned int   BF2DEVCP2 __attribute__((section("sfrs")));
#define BF2DEVCP1 BF2DEVCP1
extern volatile unsigned int   BF2DEVCP1 __attribute__((section("sfrs")));
#define BF2DEVCP0 BF2DEVCP0
extern volatile unsigned int   BF2DEVCP0 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned :28;
    unsigned CP:1;
  };
  struct {
    unsigned w:32;
  };
} __BF2DEVCP0bits_t;
extern volatile __BF2DEVCP0bits_t BF2DEVCP0bits __asm__ ("BF2DEVCP0") __attribute__((section("sfrs")));
#define BF2DEVSIGN3 BF2DEVSIGN3
extern volatile unsigned int   BF2DEVSIGN3 __attribute__((section("sfrs")));
#define BF2DEVSIGN2 BF2DEVSIGN2
extern volatile unsigned int   BF2DEVSIGN2 __attribute__((section("sfrs")));
#define BF2DEVSIGN1 BF2DEVSIGN1
extern volatile unsigned int   BF2DEVSIGN1 __attribute__((section("sfrs")));
#define BF2DEVSIGN0 BF2DEVSIGN0
extern volatile unsigned int   BF2DEVSIGN0 __attribute__((section("sfrs")));
#define BF2SEQ3 BF2SEQ3
extern volatile unsigned int   BF2SEQ3 __attribute__((section("sfrs")));
typedef union {
  struct {
    unsigned TSEQ:16;
    unsigned CSEQ:16;
  };
  struct {
    unsigned w:32;
  };
} __BF2SEQ3bits_t;
extern volatile __BF2SEQ3bits_t BF2SEQ3bits __asm__ ("BF2SEQ3") __attribute__((section("sfrs")));
#define BF2SEQ2 BF2SEQ2
extern volatile unsigned int   BF2SEQ2 __attribute__((section("sfrs")));
#define BF2SEQ1 BF2SEQ1
extern volatile unsigned int   BF2SEQ1 __attribute__((section("sfrs")));
#define BF2SEQ0 BF2SEQ0
extern volatile unsigned int   BF2SEQ0 __attribute__((section("sfrs")));
#ifdef __cplusplus
}
#endif

#elif defined (__LANGUAGE_ASSEMBLY__)
  .extern CFGCON           /* 0xBF800000 */
  .extern DEVID            /* 0xBF800020 */
  .extern SYSKEY           /* 0xBF800030 */
  .extern PMD1             /* 0xBF800040 */
  .extern PMD1CLR          /* 0xBF800044 */
  .extern PMD1SET          /* 0xBF800048 */
  .extern PMD1INV          /* 0xBF80004C */
  .extern PMD2             /* 0xBF800050 */
  .extern PMD2CLR          /* 0xBF800054 */
  .extern PMD2SET          /* 0xBF800058 */
  .extern PMD2INV          /* 0xBF80005C */
  .extern PMD3             /* 0xBF800060 */
  .extern PMD3CLR          /* 0xBF800064 */
  .extern PMD3SET          /* 0xBF800068 */
  .extern PMD3INV          /* 0xBF80006C */
  .extern PMD4             /* 0xBF800070 */
  .extern PMD4CLR          /* 0xBF800074 */
  .extern PMD4SET          /* 0xBF800078 */
  .extern PMD4INV          /* 0xBF80007C */
  .extern PMD5             /* 0xBF800080 */
  .extern PMD5CLR          /* 0xBF800084 */
  .extern PMD5SET          /* 0xBF800088 */
  .extern PMD5INV          /* 0xBF80008C */
  .extern PMD6             /* 0xBF800090 */
  .extern PMD6CLR          /* 0xBF800094 */
  .extern PMD6SET          /* 0xBF800098 */
  .extern PMD6INV          /* 0xBF80009C */
  .extern PMD7             /* 0xBF8000A0 */
  .extern PMD7CLR          /* 0xBF8000A4 */
  .extern PMD7SET          /* 0xBF8000A8 */
  .extern PMD7INV          /* 0xBF8000AC */
  .extern CFGEBIA          /* 0xBF8000C0 */
  .extern CFGEBIACLR       /* 0xBF8000C4 */
  .extern CFGEBIASET       /* 0xBF8000C8 */
  .extern CFGEBIAINV       /* 0xBF8000CC */
  .extern CFGEBIC          /* 0xBF8000D0 */
  .extern CFGEBICCLR       /* 0xBF8000D4 */
  .extern CFGEBICSET       /* 0xBF8000D8 */
  .extern CFGEBICINV       /* 0xBF8000DC */
  .extern CFGPG            /* 0xBF8000E0 */
  .extern CFGPGCLR         /* 0xBF8000E4 */
  .extern CFGPGSET         /* 0xBF8000E8 */
  .extern CFGPGINV         /* 0xBF8000EC */
  .extern NVMCON           /* 0xBF800600 */
  .extern NVMCONCLR        /* 0xBF800604 */
  .extern NVMCONSET        /* 0xBF800608 */
  .extern NVMCONINV        /* 0xBF80060C */
  .extern NVMKEY           /* 0xBF800610 */
  .extern NVMADDR          /* 0xBF800620 */
  .extern NVMADDRCLR       /* 0xBF800624 */
  .extern NVMADDRSET       /* 0xBF800628 */
  .extern NVMADDRINV       /* 0xBF80062C */
  .extern NVMDATA0         /* 0xBF800630 */
  .extern NVMDATA0CLR      /* 0xBF800634 */
  .extern NVMDATA0SET      /* 0xBF800638 */
  .extern NVMDATA0INV      /* 0xBF80063C */
  .extern NVMDATA1         /* 0xBF800640 */
  .extern NVMDATA1CLR      /* 0xBF800644 */
  .extern NVMDATA1SET      /* 0xBF800648 */
  .extern NVMDATA1INV      /* 0xBF80064C */
  .extern NVMDATA2         /* 0xBF800650 */
  .extern NVMDATA2CLR      /* 0xBF800654 */
  .extern NVMDATA2SET      /* 0xBF800658 */
  .extern NVMDATA2INV      /* 0xBF80065C */
  .extern NVMDATA3         /* 0xBF800660 */
  .extern NVMDATA3CLR      /* 0xBF800664 */
  .extern NVMDATA3SET      /* 0xBF800668 */
  .extern NVMDATA3INV      /* 0xBF80066C */
  .extern NVMSRCADDR       /* 0xBF800670 */
  .extern NVMSRCADDRCLR    /* 0xBF800674 */
  .extern NVMSRCADDRSET    /* 0xBF800678 */
  .extern NVMSRCADDRINV    /* 0xBF80067C */
  .extern NVMPWP           /* 0xBF800680 */
  .extern NVMPWPCLR        /* 0xBF800684 */
  .extern NVMPWPSET        /* 0xBF800688 */
  .extern NVMPWPINV        /* 0xBF80068C */
  .extern NVMBWP           /* 0xBF800690 */
  .extern NVMBWPCLR        /* 0xBF800694 */
  .extern NVMBWPSET        /* 0xBF800698 */
  .extern NVMBWPINV        /* 0xBF80069C */
  .extern NVMCON2          /* 0xBF8006A0 */
  .extern NVMCON2CLR       /* 0xBF8006A4 */
  .extern NVMCON2SET       /* 0xBF8006A8 */
  .extern NVMCON2INV       /* 0xBF8006AC */
  .extern WDTCON           /* 0xBF800800 */
  .extern WDTCONCLR        /* 0xBF800804 */
  .extern WDTCONSET        /* 0xBF800808 */
  .extern WDTCONINV        /* 0xBF80080C */
  .extern DMTCON           /* 0xBF800A00 */
  .extern DMTPRECLR        /* 0xBF800A10 */
  .extern DMTCLR           /* 0xBF800A20 */
  .extern DMTSTAT          /* 0xBF800A30 */
  .extern DMTCNT           /* 0xBF800A40 */
  .extern DMTPSCNT         /* 0xBF800A60 */
  .extern DMTPSINTV        /* 0xBF800A70 */
  .extern RTCCON           /* 0xBF800C00 */
  .extern RTCCONCLR        /* 0xBF800C04 */
  .extern RTCCONSET        /* 0xBF800C08 */
  .extern RTCCONINV        /* 0xBF800C0C */
  .extern RTCALRM          /* 0xBF800C10 */
  .extern RTCALRMCLR       /* 0xBF800C14 */
  .extern RTCALRMSET       /* 0xBF800C18 */
  .extern RTCALRMINV       /* 0xBF800C1C */
  .extern RTCTIME          /* 0xBF800C20 */
  .extern RTCTIMECLR       /* 0xBF800C24 */
  .extern RTCTIMESET       /* 0xBF800C28 */
  .extern RTCTIMEINV       /* 0xBF800C2C */
  .extern RTCDATE          /* 0xBF800C30 */
  .extern RTCDATECLR       /* 0xBF800C34 */
  .extern RTCDATESET       /* 0xBF800C38 */
  .extern RTCDATEINV       /* 0xBF800C3C */
  .extern ALRMTIME         /* 0xBF800C40 */
  .extern ALRMTIMECLR      /* 0xBF800C44 */
  .extern ALRMTIMESET      /* 0xBF800C48 */
  .extern ALRMTIMEINV      /* 0xBF800C4C */
  .extern ALRMDATE         /* 0xBF800C50 */
  .extern ALRMDATECLR      /* 0xBF800C54 */
  .extern ALRMDATESET      /* 0xBF800C58 */
  .extern ALRMDATEINV      /* 0xBF800C5C */
  .extern CVRCON           /* 0xBF800E00 */
  .extern CVRCONCLR        /* 0xBF800E04 */
  .extern CVRCONSET        /* 0xBF800E08 */
  .extern CVRCONINV        /* 0xBF800E0C */
  .extern _ICDCON          /* 0xBF801130 */
  .extern _ICDSTAT         /* 0xBF801140 */
  .extern OSCCON           /* 0xBF801200 */
  .extern OSCCONCLR        /* 0xBF801204 */
  .extern OSCCONSET        /* 0xBF801208 */
  .extern OSCCONINV        /* 0xBF80120C */
  .extern OSCTUN           /* 0xBF801210 */
  .extern OSCTUNCLR        /* 0xBF801214 */
  .extern OSCTUNSET        /* 0xBF801218 */
  .extern OSCTUNINV        /* 0xBF80121C */
  .extern SPLLCON          /* 0xBF801220 */
  .extern SPLLCONCLR       /* 0xBF801224 */
  .extern SPLLCONSET       /* 0xBF801228 */
  .extern SPLLCONINV       /* 0xBF80122C */
  .extern RCON             /* 0xBF801240 */
  .extern RCONCLR          /* 0xBF801244 */
  .extern RCONSET          /* 0xBF801248 */
  .extern RCONINV          /* 0xBF80124C */
  .extern RSWRST           /* 0xBF801250 */
  .extern RSWRSTCLR        /* 0xBF801254 */
  .extern RSWRSTSET        /* 0xBF801258 */
  .extern RSWRSTINV        /* 0xBF80125C */
  .extern RNMICON          /* 0xBF801260 */
  .extern RNMICONCLR       /* 0xBF801264 */
  .extern RNMICONSET       /* 0xBF801268 */
  .extern RNMICONINV       /* 0xBF80126C */
  .extern PWRCON           /* 0xBF801270 */
  .extern PWRCONCLR        /* 0xBF801274 */
  .extern PWRCONSET        /* 0xBF801278 */
  .extern PWRCONINV        /* 0xBF80127C */
  .extern REFO1CON         /* 0xBF801280 */
  .extern REFO1CONCLR      /* 0xBF801284 */
  .extern REFO1CONSET      /* 0xBF801288 */
  .extern REFO1CONINV      /* 0xBF80128C */
  .extern REFO1TRIM        /* 0xBF801290 */
  .extern REFO1TRIMCLR     /* 0xBF801294 */
  .extern REFO1TRIMSET     /* 0xBF801298 */
  .extern REFO1TRIMINV     /* 0xBF80129C */
  .extern REFO2CON         /* 0xBF8012A0 */
  .extern REFO2CONCLR      /* 0xBF8012A4 */
  .extern REFO2CONSET      /* 0xBF8012A8 */
  .extern REFO2CONINV      /* 0xBF8012AC */
  .extern REFO2TRIM        /* 0xBF8012B0 */
  .extern REFO2TRIMCLR     /* 0xBF8012B4 */
  .extern REFO2TRIMSET     /* 0xBF8012B8 */
  .extern REFO2TRIMINV     /* 0xBF8012BC */
  .extern REFO3CON         /* 0xBF8012C0 */
  .extern REFO3CONCLR      /* 0xBF8012C4 */
  .extern REFO3CONSET      /* 0xBF8012C8 */
  .extern REFO3CONINV      /* 0xBF8012CC */
  .extern REFO3TRIM        /* 0xBF8012D0 */
  .extern REFO3TRIMCLR     /* 0xBF8012D4 */
  .extern REFO3TRIMSET     /* 0xBF8012D8 */
  .extern REFO3TRIMINV     /* 0xBF8012DC */
  .extern REFO4CON         /* 0xBF8012E0 */
  .extern REFO4CONCLR      /* 0xBF8012E4 */
  .extern REFO4CONSET      /* 0xBF8012E8 */
  .extern REFO4CONINV      /* 0xBF8012EC */
  .extern REFO4TRIM        /* 0xBF8012F0 */
  .extern REFO4TRIMCLR     /* 0xBF8012F4 */
  .extern REFO4TRIMSET     /* 0xBF8012F8 */
  .extern REFO4TRIMINV     /* 0xBF8012FC */
  .extern PB1DIV           /* 0xBF801300 */
  .extern PB1DIVCLR        /* 0xBF801304 */
  .extern PB1DIVSET        /* 0xBF801308 */
  .extern PB1DIVINV        /* 0xBF80130C */
  .extern PB2DIV           /* 0xBF801310 */
  .extern PB2DIVCLR        /* 0xBF801314 */
  .extern PB2DIVSET        /* 0xBF801318 */
  .extern PB2DIVINV        /* 0xBF80131C */
  .extern PB3DIV           /* 0xBF801320 */
  .extern PB3DIVCLR        /* 0xBF801324 */
  .extern PB3DIVSET        /* 0xBF801328 */
  .extern PB3DIVINV        /* 0xBF80132C */
  .extern PB4DIV           /* 0xBF801330 */
  .extern PB4DIVCLR        /* 0xBF801334 */
  .extern PB4DIVSET        /* 0xBF801338 */
  .extern PB4DIVINV        /* 0xBF80133C */
  .extern PB5DIV           /* 0xBF801340 */
  .extern PB5DIVCLR        /* 0xBF801344 */
  .extern PB5DIVSET        /* 0xBF801348 */
  .extern PB5DIVINV        /* 0xBF80134C */
  .extern PB7DIV           /* 0xBF801360 */
  .extern PB7DIVCLR        /* 0xBF801364 */
  .extern PB7DIVSET        /* 0xBF801368 */
  .extern PB7DIVINV        /* 0xBF80136C */
  .extern PB8DIV           /* 0xBF801370 */
  .extern PB8DIVCLR        /* 0xBF801374 */
  .extern PB8DIVSET        /* 0xBF801378 */
  .extern PB8DIVINV        /* 0xBF80137C */
  .extern SLEWCON          /* 0xBF8013C0 */
  .extern SLEWCONCLR       /* 0xBF8013C4 */
  .extern SLEWCONSET       /* 0xBF8013C8 */
  .extern SLEWCONINV       /* 0xBF8013CC */
  .extern CLKSTAT          /* 0xBF8013D0 */
  .extern CLKSTATCLR       /* 0xBF8013D4 */
  .extern CLKSTATSET       /* 0xBF8013D8 */
  .extern CLKSTATINV       /* 0xBF8013DC */
  .extern INT1R            /* 0xBF801404 */
  .extern INT2R            /* 0xBF801408 */
  .extern INT3R            /* 0xBF80140C */
  .extern INT4R            /* 0xBF801410 */
  .extern T2CKR            /* 0xBF801418 */
  .extern T3CKR            /* 0xBF80141C */
  .extern T4CKR            /* 0xBF801420 */
  .extern T5CKR            /* 0xBF801424 */
  .extern T6CKR            /* 0xBF801428 */
  .extern T7CKR            /* 0xBF80142C */
  .extern T8CKR            /* 0xBF801430 */
  .extern T9CKR            /* 0xBF801434 */
  .extern IC1R             /* 0xBF801438 */
  .extern IC2R             /* 0xBF80143C */
  .extern IC3R             /* 0xBF801440 */
  .extern IC4R             /* 0xBF801444 */
  .extern IC5R             /* 0xBF801448 */
  .extern IC6R             /* 0xBF80144C */
  .extern IC7R             /* 0xBF801450 */
  .extern IC8R             /* 0xBF801454 */
  .extern IC9R             /* 0xBF801458 */
  .extern OCFAR            /* 0xBF801460 */
  .extern U1RXR            /* 0xBF801468 */
  .extern U1CTSR           /* 0xBF80146C */
  .extern U2RXR            /* 0xBF801470 */
  .extern U2CTSR           /* 0xBF801474 */
  .extern U3RXR            /* 0xBF801478 */
  .extern U3CTSR           /* 0xBF80147C */
  .extern U4RXR            /* 0xBF801480 */
  .extern U4CTSR           /* 0xBF801484 */
  .extern U5RXR            /* 0xBF801488 */
  .extern U5CTSR           /* 0xBF80148C */
  .extern U6RXR            /* 0xBF801490 */
  .extern U6CTSR           /* 0xBF801494 */
  .extern SDI1R            /* 0xBF80149C */
  .extern SS1R             /* 0xBF8014A0 */
  .extern SDI2R            /* 0xBF8014A8 */
  .extern SS2R             /* 0xBF8014AC */
  .extern SDI3R            /* 0xBF8014B4 */
  .extern SS3R             /* 0xBF8014B8 */
  .extern SDI4R            /* 0xBF8014C0 */
  .extern SS4R             /* 0xBF8014C4 */
  .extern SDI5R            /* 0xBF8014CC */
  .extern SS5R             /* 0xBF8014D0 */
  .extern SDI6R            /* 0xBF8014D8 */
  .extern SS6R             /* 0xBF8014DC */
  .extern REFCLKI1R        /* 0xBF8014E8 */
  .extern REFCLKI3R        /* 0xBF8014F0 */
  .extern REFCLKI4R        /* 0xBF8014F4 */
  .extern RPA14R           /* 0xBF801538 */
  .extern RPA15R           /* 0xBF80153C */
  .extern RPB0R            /* 0xBF801540 */
  .extern RPB1R            /* 0xBF801544 */
  .extern RPB2R            /* 0xBF801548 */
  .extern RPB3R            /* 0xBF80154C */
  .extern RPB5R            /* 0xBF801554 */
  .extern RPB6R            /* 0xBF801558 */
  .extern RPB7R            /* 0xBF80155C */
  .extern RPB8R            /* 0xBF801560 */
  .extern RPB9R            /* 0xBF801564 */
  .extern RPB10R           /* 0xBF801568 */
  .extern RPB14R           /* 0xBF801578 */
  .extern RPB15R           /* 0xBF80157C */
  .extern RPC1R            /* 0xBF801584 */
  .extern RPC2R            /* 0xBF801588 */
  .extern RPC3R            /* 0xBF80158C */
  .extern RPC4R            /* 0xBF801590 */
  .extern RPC13R           /* 0xBF8015B4 */
  .extern RPC14R           /* 0xBF8015B8 */
  .extern RPD0R            /* 0xBF8015C0 */
  .extern RPD1R            /* 0xBF8015C4 */
  .extern RPD2R            /* 0xBF8015C8 */
  .extern RPD3R            /* 0xBF8015CC */
  .extern RPD4R            /* 0xBF8015D0 */
  .extern RPD5R            /* 0xBF8015D4 */
  .extern RPD9R            /* 0xBF8015E4 */
  .extern RPD10R           /* 0xBF8015E8 */
  .extern RPD11R           /* 0xBF8015EC */
  .extern RPD12R           /* 0xBF8015F0 */
  .extern RPD14R           /* 0xBF8015F8 */
  .extern RPD15R           /* 0xBF8015FC */
  .extern RPE3R            /* 0xBF80160C */
  .extern RPE5R            /* 0xBF801614 */
  .extern RPE8R            /* 0xBF801620 */
  .extern RPE9R            /* 0xBF801624 */
  .extern RPF0R            /* 0xBF801640 */
  .extern RPF1R            /* 0xBF801644 */
  .extern RPF2R            /* 0xBF801648 */
  .extern RPF3R            /* 0xBF80164C */
  .extern RPF4R            /* 0xBF801650 */
  .extern RPF5R            /* 0xBF801654 */
  .extern RPF8R            /* 0xBF801660 */
  .extern RPF12R           /* 0xBF801670 */
  .extern RPF13R           /* 0xBF801674 */
  .extern RPG0R            /* 0xBF801680 */
  .extern RPG1R            /* 0xBF801684 */
  .extern RPG6R            /* 0xBF801698 */
  .extern RPG7R            /* 0xBF80169C */
  .extern RPG8R            /* 0xBF8016A0 */
  .extern RPG9R            /* 0xBF8016A4 */
  .extern INTCON           /* 0xBF810000 */
  .extern INTCONCLR        /* 0xBF810004 */
  .extern INTCONSET        /* 0xBF810008 */
  .extern INTCONINV        /* 0xBF81000C */
  .extern PRISS            /* 0xBF810010 */
  .extern PRISSCLR         /* 0xBF810014 */
  .extern PRISSSET         /* 0xBF810018 */
  .extern PRISSINV         /* 0xBF81001C */
  .extern INTSTAT          /* 0xBF810020 */
  .extern INTSTATCLR       /* 0xBF810024 */
  .extern INTSTATSET       /* 0xBF810028 */
  .extern INTSTATINV       /* 0xBF81002C */
  .extern IPTMR            /* 0xBF810030 */
  .extern IPTMRCLR         /* 0xBF810034 */
  .extern IPTMRSET         /* 0xBF810038 */
  .extern IPTMRINV         /* 0xBF81003C */
  .extern IFS0             /* 0xBF810040 */
  .extern IFS0CLR          /* 0xBF810044 */
  .extern IFS0SET          /* 0xBF810048 */
  .extern IFS0INV          /* 0xBF81004C */
  .extern IFS1             /* 0xBF810050 */
  .extern IFS1CLR          /* 0xBF810054 */
  .extern IFS1SET          /* 0xBF810058 */
  .extern IFS1INV          /* 0xBF81005C */
  .extern IFS2             /* 0xBF810060 */
  .extern IFS2CLR          /* 0xBF810064 */
  .extern IFS2SET          /* 0xBF810068 */
  .extern IFS2INV          /* 0xBF81006C */
  .extern IFS3             /* 0xBF810070 */
  .extern IFS3CLR          /* 0xBF810074 */
  .extern IFS3SET          /* 0xBF810078 */
  .extern IFS3INV          /* 0xBF81007C */
  .extern IFS4             /* 0xBF810080 */
  .extern IFS4CLR          /* 0xBF810084 */
  .extern IFS4SET          /* 0xBF810088 */
  .extern IFS4INV          /* 0xBF81008C */
  .extern IFS5             /* 0xBF810090 */
  .extern IFS5CLR          /* 0xBF810094 */
  .extern IFS5SET          /* 0xBF810098 */
  .extern IFS5INV          /* 0xBF81009C */
  .extern IFS6             /* 0xBF8100A0 */
  .extern IFS6CLR          /* 0xBF8100A4 */
  .extern IFS6SET          /* 0xBF8100A8 */
  .extern IFS6INV          /* 0xBF8100AC */
  .extern IEC0             /* 0xBF8100C0 */
  .extern IEC0CLR          /* 0xBF8100C4 */
  .extern IEC0SET          /* 0xBF8100C8 */
  .extern IEC0INV          /* 0xBF8100CC */
  .extern IEC1             /* 0xBF8100D0 */
  .extern IEC1CLR          /* 0xBF8100D4 */
  .extern IEC1SET          /* 0xBF8100D8 */
  .extern IEC1INV          /* 0xBF8100DC */
  .extern IEC2             /* 0xBF8100E0 */
  .extern IEC2CLR          /* 0xBF8100E4 */
  .extern IEC2SET          /* 0xBF8100E8 */
  .extern IEC2INV          /* 0xBF8100EC */
  .extern IEC3             /* 0xBF8100F0 */
  .extern IEC3CLR          /* 0xBF8100F4 */
  .extern IEC3SET          /* 0xBF8100F8 */
  .extern IEC3INV          /* 0xBF8100FC */
  .extern IEC4             /* 0xBF810100 */
  .extern IEC4CLR          /* 0xBF810104 */
  .extern IEC4SET          /* 0xBF810108 */
  .extern IEC4INV          /* 0xBF81010C */
  .extern IEC5             /* 0xBF810110 */
  .extern IEC5CLR          /* 0xBF810114 */
  .extern IEC5SET          /* 0xBF810118 */
  .extern IEC5INV          /* 0xBF81011C */
  .extern IEC6             /* 0xBF810120 */
  .extern IEC6CLR          /* 0xBF810124 */
  .extern IEC6SET          /* 0xBF810128 */
  .extern IEC6INV          /* 0xBF81012C */
  .extern IPC0             /* 0xBF810140 */
  .extern IPC0CLR          /* 0xBF810144 */
  .extern IPC0SET          /* 0xBF810148 */
  .extern IPC0INV          /* 0xBF81014C */
  .extern IPC1             /* 0xBF810150 */
  .extern IPC1CLR          /* 0xBF810154 */
  .extern IPC1SET          /* 0xBF810158 */
  .extern IPC1INV          /* 0xBF81015C */
  .extern IPC2             /* 0xBF810160 */
  .extern IPC2CLR          /* 0xBF810164 */
  .extern IPC2SET          /* 0xBF810168 */
  .extern IPC2INV          /* 0xBF81016C */
  .extern IPC3             /* 0xBF810170 */
  .extern IPC3CLR          /* 0xBF810174 */
  .extern IPC3SET          /* 0xBF810178 */
  .extern IPC3INV          /* 0xBF81017C */
  .extern IPC4             /* 0xBF810180 */
  .extern IPC4CLR          /* 0xBF810184 */
  .extern IPC4SET          /* 0xBF810188 */
  .extern IPC4INV          /* 0xBF81018C */
  .extern IPC5             /* 0xBF810190 */
  .extern IPC5CLR          /* 0xBF810194 */
  .extern IPC5SET          /* 0xBF810198 */
  .extern IPC5INV          /* 0xBF81019C */
  .extern IPC6             /* 0xBF8101A0 */
  .extern IPC6CLR          /* 0xBF8101A4 */
  .extern IPC6SET          /* 0xBF8101A8 */
  .extern IPC6INV          /* 0xBF8101AC */
  .extern IPC7             /* 0xBF8101B0 */
  .extern IPC7CLR          /* 0xBF8101B4 */
  .extern IPC7SET          /* 0xBF8101B8 */
  .extern IPC7INV          /* 0xBF8101BC */
  .extern IPC8             /* 0xBF8101C0 */
  .extern IPC8CLR          /* 0xBF8101C4 */
  .extern IPC8SET          /* 0xBF8101C8 */
  .extern IPC8INV          /* 0xBF8101CC */
  .extern IPC9             /* 0xBF8101D0 */
  .extern IPC9CLR          /* 0xBF8101D4 */
  .extern IPC9SET          /* 0xBF8101D8 */
  .extern IPC9INV          /* 0xBF8101DC */
  .extern IPC10            /* 0xBF8101E0 */
  .extern IPC10CLR         /* 0xBF8101E4 */
  .extern IPC10SET         /* 0xBF8101E8 */
  .extern IPC10INV         /* 0xBF8101EC */
  .extern IPC11            /* 0xBF8101F0 */
  .extern IPC11CLR         /* 0xBF8101F4 */
  .extern IPC11SET         /* 0xBF8101F8 */
  .extern IPC11INV         /* 0xBF8101FC */
  .extern IPC12            /* 0xBF810200 */
  .extern IPC12CLR         /* 0xBF810204 */
  .extern IPC12SET         /* 0xBF810208 */
  .extern IPC12INV         /* 0xBF81020C */
  .extern IPC13            /* 0xBF810210 */
  .extern IPC13CLR         /* 0xBF810214 */
  .extern IPC13SET         /* 0xBF810218 */
  .extern IPC13INV         /* 0xBF81021C */
  .extern IPC14            /* 0xBF810220 */
  .extern IPC14CLR         /* 0xBF810224 */
  .extern IPC14SET         /* 0xBF810228 */
  .extern IPC14INV         /* 0xBF81022C */
  .extern IPC15            /* 0xBF810230 */
  .extern IPC15CLR         /* 0xBF810234 */
  .extern IPC15SET         /* 0xBF810238 */
  .extern IPC15INV         /* 0xBF81023C */
  .extern IPC16            /* 0xBF810240 */
  .extern IPC16CLR         /* 0xBF810244 */
  .extern IPC16SET         /* 0xBF810248 */
  .extern IPC16INV         /* 0xBF81024C */
  .extern IPC17            /* 0xBF810250 */
  .extern IPC17CLR         /* 0xBF810254 */
  .extern IPC17SET         /* 0xBF810258 */
  .extern IPC17INV         /* 0xBF81025C */
  .extern IPC18            /* 0xBF810260 */
  .extern IPC18CLR         /* 0xBF810264 */
  .extern IPC18SET         /* 0xBF810268 */
  .extern IPC18INV         /* 0xBF81026C */
  .extern IPC19            /* 0xBF810270 */
  .extern IPC19CLR         /* 0xBF810274 */
  .extern IPC19SET         /* 0xBF810278 */
  .extern IPC19INV         /* 0xBF81027C */
  .extern IPC20            /* 0xBF810280 */
  .extern IPC20CLR         /* 0xBF810284 */
  .extern IPC20SET         /* 0xBF810288 */
  .extern IPC20INV         /* 0xBF81028C */
  .extern IPC21            /* 0xBF810290 */
  .extern IPC21CLR         /* 0xBF810294 */
  .extern IPC21SET         /* 0xBF810298 */
  .extern IPC21INV         /* 0xBF81029C */
  .extern IPC22            /* 0xBF8102A0 */
  .extern IPC22CLR         /* 0xBF8102A4 */
  .extern IPC22SET         /* 0xBF8102A8 */
  .extern IPC22INV         /* 0xBF8102AC */
  .extern IPC23            /* 0xBF8102B0 */
  .extern IPC23CLR         /* 0xBF8102B4 */
  .extern IPC23SET         /* 0xBF8102B8 */
  .extern IPC23INV         /* 0xBF8102BC */
  .extern IPC25            /* 0xBF8102D0 */
  .extern IPC25CLR         /* 0xBF8102D4 */
  .extern IPC25SET         /* 0xBF8102D8 */
  .extern IPC25INV         /* 0xBF8102DC */
  .extern IPC26            /* 0xBF8102E0 */
  .extern IPC26CLR         /* 0xBF8102E4 */
  .extern IPC26SET         /* 0xBF8102E8 */
  .extern IPC26INV         /* 0xBF8102EC */
  .extern IPC27            /* 0xBF8102F0 */
  .extern IPC27CLR         /* 0xBF8102F4 */
  .extern IPC27SET         /* 0xBF8102F8 */
  .extern IPC27INV         /* 0xBF8102FC */
  .extern IPC28            /* 0xBF810300 */
  .extern IPC28CLR         /* 0xBF810304 */
  .extern IPC28SET         /* 0xBF810308 */
  .extern IPC28INV         /* 0xBF81030C */
  .extern IPC29            /* 0xBF810310 */
  .extern IPC29CLR         /* 0xBF810314 */
  .extern IPC29SET         /* 0xBF810318 */
  .extern IPC29INV         /* 0xBF81031C */
  .extern IPC30            /* 0xBF810320 */
  .extern IPC30CLR         /* 0xBF810324 */
  .extern IPC30SET         /* 0xBF810328 */
  .extern IPC30INV         /* 0xBF81032C */
  .extern IPC31            /* 0xBF810330 */
  .extern IPC31CLR         /* 0xBF810334 */
  .extern IPC31SET         /* 0xBF810338 */
  .extern IPC31INV         /* 0xBF81033C */
  .extern IPC32            /* 0xBF810340 */
  .extern IPC32CLR         /* 0xBF810344 */
  .extern IPC32SET         /* 0xBF810348 */
  .extern IPC32INV         /* 0xBF81034C */
  .extern IPC33            /* 0xBF810350 */
  .extern IPC33CLR         /* 0xBF810354 */
  .extern IPC33SET         /* 0xBF810358 */
  .extern IPC33INV         /* 0xBF81035C */
  .extern IPC34            /* 0xBF810360 */
  .extern IPC34CLR         /* 0xBF810364 */
  .extern IPC34SET         /* 0xBF810368 */
  .extern IPC34INV         /* 0xBF81036C */
  .extern IPC35            /* 0xBF810370 */
  .extern IPC35CLR         /* 0xBF810374 */
  .extern IPC35SET         /* 0xBF810378 */
  .extern IPC35INV         /* 0xBF81037C */
  .extern IPC36            /* 0xBF810380 */
  .extern IPC36CLR         /* 0xBF810384 */
  .extern IPC36SET         /* 0xBF810388 */
  .extern IPC36INV         /* 0xBF81038C */
  .extern IPC37            /* 0xBF810390 */
  .extern IPC37CLR         /* 0xBF810394 */
  .extern IPC37SET         /* 0xBF810398 */
  .extern IPC37INV         /* 0xBF81039C */
  .extern IPC38            /* 0xBF8103A0 */
  .extern IPC38CLR         /* 0xBF8103A4 */
  .extern IPC38SET         /* 0xBF8103A8 */
  .extern IPC38INV         /* 0xBF8103AC */
  .extern IPC39            /* 0xBF8103B0 */
  .extern IPC39CLR         /* 0xBF8103B4 */
  .extern IPC39SET         /* 0xBF8103B8 */
  .extern IPC39INV         /* 0xBF8103BC */
  .extern IPC40            /* 0xBF8103C0 */
  .extern IPC40CLR         /* 0xBF8103C4 */
  .extern IPC40SET         /* 0xBF8103C8 */
  .extern IPC40INV         /* 0xBF8103CC */
  .extern IPC41            /* 0xBF8103D0 */
  .extern IPC41CLR         /* 0xBF8103D4 */
  .extern IPC41SET         /* 0xBF8103D8 */
  .extern IPC41INV         /* 0xBF8103DC */
  .extern IPC42            /* 0xBF8103E0 */
  .extern IPC42CLR         /* 0xBF8103E4 */
  .extern IPC42SET         /* 0xBF8103E8 */
  .extern IPC42INV         /* 0xBF8103EC */
  .extern IPC43            /* 0xBF8103F0 */
  .extern IPC43CLR         /* 0xBF8103F4 */
  .extern IPC43SET         /* 0xBF8103F8 */
  .extern IPC43INV         /* 0xBF8103FC */
  .extern IPC44            /* 0xBF810400 */
  .extern IPC44CLR         /* 0xBF810404 */
  .extern IPC44SET         /* 0xBF810408 */
  .extern IPC44INV         /* 0xBF81040C */
  .extern IPC45            /* 0xBF810410 */
  .extern IPC45CLR         /* 0xBF810414 */
  .extern IPC45SET         /* 0xBF810418 */
  .extern IPC45INV         /* 0xBF81041C */
  .extern IPC46            /* 0xBF810420 */
  .extern IPC46CLR         /* 0xBF810424 */
  .extern IPC46SET         /* 0xBF810428 */
  .extern IPC46INV         /* 0xBF81042C */
  .extern IPC47            /* 0xBF810430 */
  .extern IPC47CLR         /* 0xBF810434 */
  .extern IPC47SET         /* 0xBF810438 */
  .extern IPC47INV         /* 0xBF81043C */
  .extern IPC48            /* 0xBF810440 */
  .extern IPC48CLR         /* 0xBF810444 */
  .extern IPC48SET         /* 0xBF810448 */
  .extern IPC48INV         /* 0xBF81044C */
  .extern IPC49            /* 0xBF810450 */
  .extern IPC49CLR         /* 0xBF810454 */
  .extern IPC49SET         /* 0xBF810458 */
  .extern IPC49INV         /* 0xBF81045C */
  .extern IPC50            /* 0xBF810460 */
  .extern IPC50CLR         /* 0xBF810464 */
  .extern IPC50SET         /* 0xBF810468 */
  .extern IPC50INV         /* 0xBF81046C */
  .extern IPC51            /* 0xBF810470 */
  .extern IPC51CLR         /* 0xBF810474 */
  .extern IPC51SET         /* 0xBF810478 */
  .extern IPC51INV         /* 0xBF81047C */
  .extern IPC52            /* 0xBF810480 */
  .extern IPC52CLR         /* 0xBF810484 */
  .extern IPC52SET         /* 0xBF810488 */
  .extern IPC52INV         /* 0xBF81048C */
  .extern IPC53            /* 0xBF810490 */
  .extern IPC53CLR         /* 0xBF810494 */
  .extern IPC53SET         /* 0xBF810498 */
  .extern IPC53INV         /* 0xBF81049C */
  .extern OFF000           /* 0xBF810540 */
  .extern OFF001           /* 0xBF810544 */
  .extern OFF002           /* 0xBF810548 */
  .extern OFF003           /* 0xBF81054C */
  .extern OFF004           /* 0xBF810550 */
  .extern OFF005           /* 0xBF810554 */
  .extern OFF006           /* 0xBF810558 */
  .extern OFF007           /* 0xBF81055C */
  .extern OFF008           /* 0xBF810560 */
  .extern OFF009           /* 0xBF810564 */
  .extern OFF010           /* 0xBF810568 */
  .extern OFF011           /* 0xBF81056C */
  .extern OFF012           /* 0xBF810570 */
  .extern OFF013           /* 0xBF810574 */
  .extern OFF014           /* 0xBF810578 */
  .extern OFF015           /* 0xBF81057C */
  .extern OFF016           /* 0xBF810580 */
  .extern OFF017           /* 0xBF810584 */
  .extern OFF018           /* 0xBF810588 */
  .extern OFF019           /* 0xBF81058C */
  .extern OFF020           /* 0xBF810590 */
  .extern OFF021           /* 0xBF810594 */
  .extern OFF022           /* 0xBF810598 */
  .extern OFF023           /* 0xBF81059C */
  .extern OFF024           /* 0xBF8105A0 */
  .extern OFF025           /* 0xBF8105A4 */
  .extern OFF026           /* 0xBF8105A8 */
  .extern OFF027           /* 0xBF8105AC */
  .extern OFF028           /* 0xBF8105B0 */
  .extern OFF029           /* 0xBF8105B4 */
  .extern OFF030           /* 0xBF8105B8 */
  .extern OFF031           /* 0xBF8105BC */
  .extern OFF032           /* 0xBF8105C0 */
  .extern OFF033           /* 0xBF8105C4 */
  .extern OFF034           /* 0xBF8105C8 */
  .extern OFF035           /* 0xBF8105CC */
  .extern OFF036           /* 0xBF8105D0 */
  .extern OFF037           /* 0xBF8105D4 */
  .extern OFF038           /* 0xBF8105D8 */
  .extern OFF039           /* 0xBF8105DC */
  .extern OFF040           /* 0xBF8105E0 */
  .extern OFF041           /* 0xBF8105E4 */
  .extern OFF042           /* 0xBF8105E8 */
  .extern OFF043           /* 0xBF8105EC */
  .extern OFF044           /* 0xBF8105F0 */
  .extern OFF045           /* 0xBF8105F4 */
  .extern OFF046           /* 0xBF8105F8 */
  .extern OFF047           /* 0xBF8105FC */
  .extern OFF048           /* 0xBF810600 */
  .extern OFF049           /* 0xBF810604 */
  .extern OFF050           /* 0xBF810608 */
  .extern OFF051           /* 0xBF81060C */
  .extern OFF052           /* 0xBF810610 */
  .extern OFF053           /* 0xBF810614 */
  .extern OFF054           /* 0xBF810618 */
  .extern OFF055           /* 0xBF81061C */
  .extern OFF056           /* 0xBF810620 */
  .extern OFF057           /* 0xBF810624 */
  .extern OFF058           /* 0xBF810628 */
  .extern OFF059           /* 0xBF81062C */
  .extern OFF060           /* 0xBF810630 */
  .extern OFF061           /* 0xBF810634 */
  .extern OFF062           /* 0xBF810638 */
  .extern OFF063           /* 0xBF81063C */
  .extern OFF064           /* 0xBF810640 */
  .extern OFF065           /* 0xBF810644 */
  .extern OFF066           /* 0xBF810648 */
  .extern OFF067           /* 0xBF81064C */
  .extern OFF068           /* 0xBF810650 */
  .extern OFF069           /* 0xBF810654 */
  .extern OFF070           /* 0xBF810658 */
  .extern OFF071           /* 0xBF81065C */
  .extern OFF072           /* 0xBF810660 */
  .extern OFF073           /* 0xBF810664 */
  .extern OFF074           /* 0xBF810668 */
  .extern OFF075           /* 0xBF81066C */
  .extern OFF076           /* 0xBF810670 */
  .extern OFF077           /* 0xBF810674 */
  .extern OFF078           /* 0xBF810678 */
  .extern OFF079           /* 0xBF81067C */
  .extern OFF080           /* 0xBF810680 */
  .extern OFF081           /* 0xBF810684 */
  .extern OFF082           /* 0xBF810688 */
  .extern OFF083           /* 0xBF81068C */
  .extern OFF084           /* 0xBF810690 */
  .extern OFF085           /* 0xBF810694 */
  .extern OFF086           /* 0xBF810698 */
  .extern OFF087           /* 0xBF81069C */
  .extern OFF088           /* 0xBF8106A0 */
  .extern OFF089           /* 0xBF8106A4 */
  .extern OFF090           /* 0xBF8106A8 */
  .extern OFF091           /* 0xBF8106AC */
  .extern OFF092           /* 0xBF8106B0 */
  .extern OFF093           /* 0xBF8106B4 */
  .extern OFF102           /* 0xBF8106D8 */
  .extern OFF103           /* 0xBF8106DC */
  .extern OFF104           /* 0xBF8106E0 */
  .extern OFF105           /* 0xBF8106E4 */
  .extern OFF106           /* 0xBF8106E8 */
  .extern OFF109           /* 0xBF8106F4 */
  .extern OFF110           /* 0xBF8106F8 */
  .extern OFF111           /* 0xBF8106FC */
  .extern OFF112           /* 0xBF810700 */
  .extern OFF113           /* 0xBF810704 */
  .extern OFF114           /* 0xBF810708 */
  .extern OFF115           /* 0xBF81070C */
  .extern OFF116           /* 0xBF810710 */
  .extern OFF117           /* 0xBF810714 */
  .extern OFF118           /* 0xBF810718 */
  .extern OFF119           /* 0xBF81071C */
  .extern OFF120           /* 0xBF810720 */
  .extern OFF121           /* 0xBF810724 */
  .extern OFF122           /* 0xBF810728 */
  .extern OFF123           /* 0xBF81072C */
  .extern OFF124           /* 0xBF810730 */
  .extern OFF128           /* 0xBF810740 */
  .extern OFF129           /* 0xBF810744 */
  .extern OFF130           /* 0xBF810748 */
  .extern OFF131           /* 0xBF81074C */
  .extern OFF132           /* 0xBF810750 */
  .extern OFF133           /* 0xBF810754 */
  .extern OFF134           /* 0xBF810758 */
  .extern OFF135           /* 0xBF81075C */
  .extern OFF136           /* 0xBF810760 */
  .extern OFF137           /* 0xBF810764 */
  .extern OFF138           /* 0xBF810768 */
  .extern OFF139           /* 0xBF81076C */
  .extern OFF140           /* 0xBF810770 */
  .extern OFF141           /* 0xBF810774 */
  .extern OFF142           /* 0xBF810778 */
  .extern OFF143           /* 0xBF81077C */
  .extern OFF144           /* 0xBF810780 */
  .extern OFF145           /* 0xBF810784 */
  .extern OFF146           /* 0xBF810788 */
  .extern OFF147           /* 0xBF81078C */
  .extern OFF148           /* 0xBF810790 */
  .extern OFF149           /* 0xBF810794 */
  .extern OFF150           /* 0xBF810798 */
  .extern OFF153           /* 0xBF8107A4 */
  .extern OFF154           /* 0xBF8107A8 */
  .extern OFF155           /* 0xBF8107AC */
  .extern OFF156           /* 0xBF8107B0 */
  .extern OFF157           /* 0xBF8107B4 */
  .extern OFF158           /* 0xBF8107B8 */
  .extern OFF159           /* 0xBF8107BC */
  .extern OFF160           /* 0xBF8107C0 */
  .extern OFF161           /* 0xBF8107C4 */
  .extern OFF162           /* 0xBF8107C8 */
  .extern OFF163           /* 0xBF8107CC */
  .extern OFF164           /* 0xBF8107D0 */
  .extern OFF165           /* 0xBF8107D4 */
  .extern OFF166           /* 0xBF8107D8 */
  .extern OFF167           /* 0xBF8107DC */
  .extern OFF168           /* 0xBF8107E0 */
  .extern OFF169           /* 0xBF8107E4 */
  .extern OFF170           /* 0xBF8107E8 */
  .extern OFF171           /* 0xBF8107EC */
  .extern OFF172           /* 0xBF8107F0 */
  .extern OFF173           /* 0xBF8107F4 */
  .extern OFF174           /* 0xBF8107F8 */
  .extern OFF175           /* 0xBF8107FC */
  .extern OFF176           /* 0xBF810800 */
  .extern OFF177           /* 0xBF810804 */
  .extern OFF178           /* 0xBF810808 */
  .extern OFF179           /* 0xBF81080C */
  .extern OFF180           /* 0xBF810810 */
  .extern OFF181           /* 0xBF810814 */
  .extern OFF182           /* 0xBF810818 */
  .extern OFF183           /* 0xBF81081C */
  .extern OFF184           /* 0xBF810820 */
  .extern OFF185           /* 0xBF810824 */
  .extern OFF186           /* 0xBF810828 */
  .extern OFF187           /* 0xBF81082C */
  .extern OFF188           /* 0xBF810830 */
  .extern OFF189           /* 0xBF810834 */
  .extern OFF190           /* 0xBF810838 */
  .extern OFF192           /* 0xBF810840 */
  .extern OFF193           /* 0xBF810844 */
  .extern OFF194           /* 0xBF810848 */
  .extern OFF196           /* 0xBF810850 */
  .extern OFF198           /* 0xBF810858 */
  .extern OFF199           /* 0xBF81085C */
  .extern OFF200           /* 0xBF810860 */
  .extern OFF201           /* 0xBF810864 */
  .extern OFF202           /* 0xBF810868 */
  .extern OFF205           /* 0xBF810874 */
  .extern OFF206           /* 0xBF810878 */
  .extern OFF207           /* 0xBF81087C */
  .extern OFF208           /* 0xBF810880 */
  .extern OFF209           /* 0xBF810884 */
  .extern OFF210           /* 0xBF810888 */
  .extern OFF213           /* 0xBF810894 */
  .extern DMACON           /* 0xBF811000 */
  .extern DMACONCLR        /* 0xBF811004 */
  .extern DMACONSET        /* 0xBF811008 */
  .extern DMACONINV        /* 0xBF81100C */
  .extern DMASTAT          /* 0xBF811010 */
  .extern DMASTATCLR       /* 0xBF811014 */
  .extern DMASTATSET       /* 0xBF811018 */
  .extern DMASTATINV       /* 0xBF81101C */
  .extern DMAADDR          /* 0xBF811020 */
  .extern DMAADDRCLR       /* 0xBF811024 */
  .extern DMAADDRSET       /* 0xBF811028 */
  .extern DMAADDRINV       /* 0xBF81102C */
  .extern DCRCCON          /* 0xBF811030 */
  .extern DCRCCONCLR       /* 0xBF811034 */
  .extern DCRCCONSET       /* 0xBF811038 */
  .extern DCRCCONINV       /* 0xBF81103C */
  .extern DCRCDATA         /* 0xBF811040 */
  .extern DCRCDATACLR      /* 0xBF811044 */
  .extern DCRCDATASET      /* 0xBF811048 */
  .extern DCRCDATAINV      /* 0xBF81104C */
  .extern DCRCXOR          /* 0xBF811050 */
  .extern DCRCXORCLR       /* 0xBF811054 */
  .extern DCRCXORSET       /* 0xBF811058 */
  .extern DCRCXORINV       /* 0xBF81105C */
  .extern DCH0CON          /* 0xBF811060 */
  .extern DCH0CONCLR       /* 0xBF811064 */
  .extern DCH0CONSET       /* 0xBF811068 */
  .extern DCH0CONINV       /* 0xBF81106C */
  .extern DCH0ECON         /* 0xBF811070 */
  .extern DCH0ECONCLR      /* 0xBF811074 */
  .extern DCH0ECONSET      /* 0xBF811078 */
  .extern DCH0ECONINV      /* 0xBF81107C */
  .extern DCH0INT          /* 0xBF811080 */
  .extern DCH0INTCLR       /* 0xBF811084 */
  .extern DCH0INTSET       /* 0xBF811088 */
  .extern DCH0INTINV       /* 0xBF81108C */
  .extern DCH0SSA          /* 0xBF811090 */
  .extern DCH0SSACLR       /* 0xBF811094 */
  .extern DCH0SSASET       /* 0xBF811098 */
  .extern DCH0SSAINV       /* 0xBF81109C */
  .extern DCH0DSA          /* 0xBF8110A0 */
  .extern DCH0DSACLR       /* 0xBF8110A4 */
  .extern DCH0DSASET       /* 0xBF8110A8 */
  .extern DCH0DSAINV       /* 0xBF8110AC */
  .extern DCH0SSIZ         /* 0xBF8110B0 */
  .extern DCH0SSIZCLR      /* 0xBF8110B4 */
  .extern DCH0SSIZSET      /* 0xBF8110B8 */
  .extern DCH0SSIZINV      /* 0xBF8110BC */
  .extern DCH0DSIZ         /* 0xBF8110C0 */
  .extern DCH0DSIZCLR      /* 0xBF8110C4 */
  .extern DCH0DSIZSET      /* 0xBF8110C8 */
  .extern DCH0DSIZINV      /* 0xBF8110CC */
  .extern DCH0SPTR         /* 0xBF8110D0 */
  .extern DCH0SPTRCLR      /* 0xBF8110D4 */
  .extern DCH0SPTRSET      /* 0xBF8110D8 */
  .extern DCH0SPTRINV      /* 0xBF8110DC */
  .extern DCH0DPTR         /* 0xBF8110E0 */
  .extern DCH0DPTRCLR      /* 0xBF8110E4 */
  .extern DCH0DPTRSET      /* 0xBF8110E8 */
  .extern DCH0DPTRINV      /* 0xBF8110EC */
  .extern DCH0CSIZ         /* 0xBF8110F0 */
  .extern DCH0CSIZCLR      /* 0xBF8110F4 */
  .extern DCH0CSIZSET      /* 0xBF8110F8 */
  .extern DCH0CSIZINV      /* 0xBF8110FC */
  .extern DCH0CPTR         /* 0xBF811100 */
  .extern DCS0CPTR         /* 0xBF811100 */
  .extern DCH0CPTRCLR      /* 0xBF811104 */
  .extern DCS0CPTRCLR      /* 0xBF811104 */
  .extern DCH0CPTRSET      /* 0xBF811108 */
  .extern DCS0CPTRSET      /* 0xBF811108 */
  .extern DCH0CPTRINV      /* 0xBF81110C */
  .extern DCS0CPTRINV      /* 0xBF81110C */
  .extern DCH0DAT          /* 0xBF811110 */
  .extern DCH0DATCLR       /* 0xBF811114 */
  .extern DCH0DATSET       /* 0xBF811118 */
  .extern DCH0DATINV       /* 0xBF81111C */
  .extern DCH1CON          /* 0xBF811120 */
  .extern DCH1CONCLR       /* 0xBF811124 */
  .extern DCH1CONSET       /* 0xBF811128 */
  .extern DCH1CONINV       /* 0xBF81112C */
  .extern DCH1ECON         /* 0xBF811130 */
  .extern DCH1ECONCLR      /* 0xBF811134 */
  .extern DCH1ECONSET      /* 0xBF811138 */
  .extern DCH1ECONINV      /* 0xBF81113C */
  .extern DCH1INT          /* 0xBF811140 */
  .extern DCH1INTCLR       /* 0xBF811144 */
  .extern DCH1INTSET       /* 0xBF811148 */
  .extern DCH1INTINV       /* 0xBF81114C */
  .extern DCH1SSA          /* 0xBF811150 */
  .extern DCH1SSACLR       /* 0xBF811154 */
  .extern DCH1SSASET       /* 0xBF811158 */
  .extern DCH1SSAINV       /* 0xBF81115C */
  .extern DCH1DSA          /* 0xBF811160 */
  .extern DCH1DSACLR       /* 0xBF811164 */
  .extern DCH1DSASET       /* 0xBF811168 */
  .extern DCH1DSAINV       /* 0xBF81116C */
  .extern DCH1SSIZ         /* 0xBF811170 */
  .extern DCH1SSIZCLR      /* 0xBF811174 */
  .extern DCH1SSIZSET      /* 0xBF811178 */
  .extern DCH1SSIZINV      /* 0xBF81117C */
  .extern DCH1DSIZ         /* 0xBF811180 */
  .extern DCH1DSIZCLR      /* 0xBF811184 */
  .extern DCH1DSIZSET      /* 0xBF811188 */
  .extern DCH1DSIZINV      /* 0xBF81118C */
  .extern DCH1SPTR         /* 0xBF811190 */
  .extern DCH1SPTRCLR      /* 0xBF811194 */
  .extern DCH1SPTRSET      /* 0xBF811198 */
  .extern DCH1SPTRINV      /* 0xBF81119C */
  .extern DCH1DPTR         /* 0xBF8111A0 */
  .extern DCH1DPTRCLR      /* 0xBF8111A4 */
  .extern DCH1DPTRSET      /* 0xBF8111A8 */
  .extern DCH1DPTRINV      /* 0xBF8111AC */
  .extern DCH1CSIZ         /* 0xBF8111B0 */
  .extern DCH1CSIZCLR      /* 0xBF8111B4 */
  .extern DCH1CSIZSET      /* 0xBF8111B8 */
  .extern DCH1CSIZINV      /* 0xBF8111BC */
  .extern DCH1CPTR         /* 0xBF8111C0 */
  .extern DCS1CPTR         /* 0xBF8111C0 */
  .extern DCH1CPTRCLR      /* 0xBF8111C4 */
  .extern DCS1CPTRCLR      /* 0xBF8111C4 */
  .extern DCH1CPTRSET      /* 0xBF8111C8 */
  .extern DCS1CPTRSET      /* 0xBF8111C8 */
  .extern DCH1CPTRINV      /* 0xBF8111CC */
  .extern DCS1CPTRINV      /* 0xBF8111CC */
  .extern DCH1DAT          /* 0xBF8111D0 */
  .extern DCH1DATCLR       /* 0xBF8111D4 */
  .extern DCH1DATSET       /* 0xBF8111D8 */
  .extern DCH1DATINV       /* 0xBF8111DC */
  .extern DCH2CON          /* 0xBF8111E0 */
  .extern DCH2CONCLR       /* 0xBF8111E4 */
  .extern DCH2CONSET       /* 0xBF8111E8 */
  .extern DCH2CONINV       /* 0xBF8111EC */
  .extern DCH2ECON         /* 0xBF8111F0 */
  .extern DCH2ECONCLR      /* 0xBF8111F4 */
  .extern DCH2ECONSET      /* 0xBF8111F8 */
  .extern DCH2ECONINV      /* 0xBF8111FC */
  .extern DCH2INT          /* 0xBF811200 */
  .extern DCH2INTCLR       /* 0xBF811204 */
  .extern DCH2INTSET       /* 0xBF811208 */
  .extern DCH2INTINV       /* 0xBF81120C */
  .extern DCH2SSA          /* 0xBF811210 */
  .extern DCH2SSACLR       /* 0xBF811214 */
  .extern DCH2SSASET       /* 0xBF811218 */
  .extern DCH2SSAINV       /* 0xBF81121C */
  .extern DCH2DSA          /* 0xBF811220 */
  .extern DCH2DSACLR       /* 0xBF811224 */
  .extern DCH2DSASET       /* 0xBF811228 */
  .extern DCH2DSAINV       /* 0xBF81122C */
  .extern DCH2SSIZ         /* 0xBF811230 */
  .extern DCH2SSIZCLR      /* 0xBF811234 */
  .extern DCH2SSIZSET      /* 0xBF811238 */
  .extern DCH2SSIZINV      /* 0xBF81123C */
  .extern DCH2DSIZ         /* 0xBF811240 */
  .extern DCH2DSIZCLR      /* 0xBF811244 */
  .extern DCH2DSIZSET      /* 0xBF811248 */
  .extern DCH2DSIZINV      /* 0xBF81124C */
  .extern DCH2SPTR         /* 0xBF811250 */
  .extern DCH2SPTRCLR      /* 0xBF811254 */
  .extern DCH2SPTRSET      /* 0xBF811258 */
  .extern DCH2SPTRINV      /* 0xBF81125C */
  .extern DCH2DPTR         /* 0xBF811260 */
  .extern DCH2DPTRCLR      /* 0xBF811264 */
  .extern DCH2DPTRSET      /* 0xBF811268 */
  .extern DCH2DPTRINV      /* 0xBF81126C */
  .extern DCH2CSIZ         /* 0xBF811270 */
  .extern DCH2CSIZCLR      /* 0xBF811274 */
  .extern DCH2CSIZSET      /* 0xBF811278 */
  .extern DCH2CSIZINV      /* 0xBF81127C */
  .extern DCH2CPTR         /* 0xBF811280 */
  .extern DCS2CPTR         /* 0xBF811280 */
  .extern DCH2CPTRCLR      /* 0xBF811284 */
  .extern DCS2CPTRCLR      /* 0xBF811284 */
  .extern DCH2CPTRSET      /* 0xBF811288 */
  .extern DCS2CPTRSET      /* 0xBF811288 */
  .extern DCH2CPTRINV      /* 0xBF81128C */
  .extern DCS2CPTRINV      /* 0xBF81128C */
  .extern DCH2DAT          /* 0xBF811290 */
  .extern DCH2DATCLR       /* 0xBF811294 */
  .extern DCH2DATSET       /* 0xBF811298 */
  .extern DCH2DATINV       /* 0xBF81129C */
  .extern DCH3CON          /* 0xBF8112A0 */
  .extern DCH3CONCLR       /* 0xBF8112A4 */
  .extern DCH3CONSET       /* 0xBF8112A8 */
  .extern DCH3CONINV       /* 0xBF8112AC */
  .extern DCH3ECON         /* 0xBF8112B0 */
  .extern DCH3ECONCLR      /* 0xBF8112B4 */
  .extern DCH3ECONSET      /* 0xBF8112B8 */
  .extern DCH3ECONINV      /* 0xBF8112BC */
  .extern DCH3INT          /* 0xBF8112C0 */
  .extern DCH3INTCLR       /* 0xBF8112C4 */
  .extern DCH3INTSET       /* 0xBF8112C8 */
  .extern DCH3INTINV       /* 0xBF8112CC */
  .extern DCH3SSA          /* 0xBF8112D0 */
  .extern DCH3SSACLR       /* 0xBF8112D4 */
  .extern DCH3SSASET       /* 0xBF8112D8 */
  .extern DCH3SSAINV       /* 0xBF8112DC */
  .extern DCH3DSA          /* 0xBF8112E0 */
  .extern DCH3DSACLR       /* 0xBF8112E4 */
  .extern DCH3DSASET       /* 0xBF8112E8 */
  .extern DCH3DSAINV       /* 0xBF8112EC */
  .extern DCH3SSIZ         /* 0xBF8112F0 */
  .extern DCH3SSIZCLR      /* 0xBF8112F4 */
  .extern DCH3SSIZSET      /* 0xBF8112F8 */
  .extern DCH3SSIZINV      /* 0xBF8112FC */
  .extern DCH3DSIZ         /* 0xBF811300 */
  .extern DCH3DSIZCLR      /* 0xBF811304 */
  .extern DCH3DSIZSET      /* 0xBF811308 */
  .extern DCH3DSIZINV      /* 0xBF81130C */
  .extern DCH3SPTR         /* 0xBF811310 */
  .extern DCH3SPTRCLR      /* 0xBF811314 */
  .extern DCH3SPTRSET      /* 0xBF811318 */
  .extern DCH3SPTRINV      /* 0xBF81131C */
  .extern DCH3DPTR         /* 0xBF811320 */
  .extern DCH3DPTRCLR      /* 0xBF811324 */
  .extern DCH3DPTRSET      /* 0xBF811328 */
  .extern DCH3DPTRINV      /* 0xBF81132C */
  .extern DCH3CSIZ         /* 0xBF811330 */
  .extern DCH3CSIZCLR      /* 0xBF811334 */
  .extern DCH3CSIZSET      /* 0xBF811338 */
  .extern DCH3CSIZINV      /* 0xBF81133C */
  .extern DCH3CPTR         /* 0xBF811340 */
  .extern DCS3CPTR         /* 0xBF811340 */
  .extern DCH3CPTRCLR      /* 0xBF811344 */
  .extern DCS3CPTRCLR      /* 0xBF811344 */
  .extern DCH3CPTRSET      /* 0xBF811348 */
  .extern DCS3CPTRSET      /* 0xBF811348 */
  .extern DCH3CPTRINV      /* 0xBF81134C */
  .extern DCS3CPTRINV      /* 0xBF81134C */
  .extern DCH3DAT          /* 0xBF811350 */
  .extern DCH3DATCLR       /* 0xBF811354 */
  .extern DCH3DATSET       /* 0xBF811358 */
  .extern DCH3DATINV       /* 0xBF81135C */
  .extern DCH4CON          /* 0xBF811360 */
  .extern DCH4CONCLR       /* 0xBF811364 */
  .extern DCH4CONSET       /* 0xBF811368 */
  .extern DCH4CONINV       /* 0xBF81136C */
  .extern DCH4ECON         /* 0xBF811370 */
  .extern DCH4ECONCLR      /* 0xBF811374 */
  .extern DCH4ECONSET      /* 0xBF811378 */
  .extern DCH4ECONINV      /* 0xBF81137C */
  .extern DCH4INT          /* 0xBF811380 */
  .extern DCH4INTCLR       /* 0xBF811384 */
  .extern DCH4INTSET       /* 0xBF811388 */
  .extern DCH4INTINV       /* 0xBF81138C */
  .extern DCH4SSA          /* 0xBF811390 */
  .extern DCH4SSACLR       /* 0xBF811394 */
  .extern DCH4SSASET       /* 0xBF811398 */
  .extern DCH4SSAINV       /* 0xBF81139C */
  .extern DCH4DSA          /* 0xBF8113A0 */
  .extern DCH4DSACLR       /* 0xBF8113A4 */
  .extern DCH4DSASET       /* 0xBF8113A8 */
  .extern DCH4DSAINV       /* 0xBF8113AC */
  .extern DCH4SSIZ         /* 0xBF8113B0 */
  .extern DCH4SSIZCLR      /* 0xBF8113B4 */
  .extern DCH4SSIZSET      /* 0xBF8113B8 */
  .extern DCH4SSIZINV      /* 0xBF8113BC */
  .extern DCH4DSIZ         /* 0xBF8113C0 */
  .extern DCH4DSIZCLR      /* 0xBF8113C4 */
  .extern DCH4DSIZSET      /* 0xBF8113C8 */
  .extern DCH4DSIZINV      /* 0xBF8113CC */
  .extern DCH4SPTR         /* 0xBF8113D0 */
  .extern DCH4SPTRCLR      /* 0xBF8113D4 */
  .extern DCH4SPTRSET      /* 0xBF8113D8 */
  .extern DCH4SPTRINV      /* 0xBF8113DC */
  .extern DCH4DPTR         /* 0xBF8113E0 */
  .extern DCH4DPTRCLR      /* 0xBF8113E4 */
  .extern DCH4DPTRSET      /* 0xBF8113E8 */
  .extern DCH4DPTRINV      /* 0xBF8113EC */
  .extern DCH4CSIZ         /* 0xBF8113F0 */
  .extern DCH4CSIZCLR      /* 0xBF8113F4 */
  .extern DCH4CSIZSET      /* 0xBF8113F8 */
  .extern DCH4CSIZINV      /* 0xBF8113FC */
  .extern DCH4CPTR         /* 0xBF811400 */
  .extern DCS4CPTR         /* 0xBF811400 */
  .extern DCH4CPTRCLR      /* 0xBF811404 */
  .extern DCS4CPTRCLR      /* 0xBF811404 */
  .extern DCH4CPTRSET      /* 0xBF811408 */
  .extern DCS4CPTRSET      /* 0xBF811408 */
  .extern DCH4CPTRINV      /* 0xBF81140C */
  .extern DCS4CPTRINV      /* 0xBF81140C */
  .extern DCH4DAT          /* 0xBF811410 */
  .extern DCH4DATCLR       /* 0xBF811414 */
  .extern DCH4DATSET       /* 0xBF811418 */
  .extern DCH4DATINV       /* 0xBF81141C */
  .extern DCH5CON          /* 0xBF811420 */
  .extern DCH5CONCLR       /* 0xBF811424 */
  .extern DCH5CONSET       /* 0xBF811428 */
  .extern DCH5CONINV       /* 0xBF81142C */
  .extern DCH5ECON         /* 0xBF811430 */
  .extern DCH5ECONCLR      /* 0xBF811434 */
  .extern DCH5ECONSET      /* 0xBF811438 */
  .extern DCH5ECONINV      /* 0xBF81143C */
  .extern DCH5INT          /* 0xBF811440 */
  .extern DCH5INTCLR       /* 0xBF811444 */
  .extern DCH5INTSET       /* 0xBF811448 */
  .extern DCH5INTINV       /* 0xBF81144C */
  .extern DCH5SSA          /* 0xBF811450 */
  .extern DCH5SSACLR       /* 0xBF811454 */
  .extern DCH5SSASET       /* 0xBF811458 */
  .extern DCH5SSAINV       /* 0xBF81145C */
  .extern DCH5DSA          /* 0xBF811460 */
  .extern DCH5DSACLR       /* 0xBF811464 */
  .extern DCH5DSASET       /* 0xBF811468 */
  .extern DCH5DSAINV       /* 0xBF81146C */
  .extern DCH5SSIZ         /* 0xBF811470 */
  .extern DCH5SSIZCLR      /* 0xBF811474 */
  .extern DCH5SSIZSET      /* 0xBF811478 */
  .extern DCH5SSIZINV      /* 0xBF81147C */
  .extern DCH5DSIZ         /* 0xBF811480 */
  .extern DCH5DSIZCLR      /* 0xBF811484 */
  .extern DCH5DSIZSET      /* 0xBF811488 */
  .extern DCH5DSIZINV      /* 0xBF81148C */
  .extern DCH5SPTR         /* 0xBF811490 */
  .extern DCH5SPTRCLR      /* 0xBF811494 */
  .extern DCH5SPTRSET      /* 0xBF811498 */
  .extern DCH5SPTRINV      /* 0xBF81149C */
  .extern DCH5DPTR         /* 0xBF8114A0 */
  .extern DCH5DPTRCLR      /* 0xBF8114A4 */
  .extern DCH5DPTRSET      /* 0xBF8114A8 */
  .extern DCH5DPTRINV      /* 0xBF8114AC */
  .extern DCH5CSIZ         /* 0xBF8114B0 */
  .extern DCH5CSIZCLR      /* 0xBF8114B4 */
  .extern DCH5CSIZSET      /* 0xBF8114B8 */
  .extern DCH5CSIZINV      /* 0xBF8114BC */
  .extern DCH5CPTR         /* 0xBF8114C0 */
  .extern DCS5CPTR         /* 0xBF8114C0 */
  .extern DCH5CPTRCLR      /* 0xBF8114C4 */
  .extern DCS5CPTRCLR      /* 0xBF8114C4 */
  .extern DCH5CPTRSET      /* 0xBF8114C8 */
  .extern DCS5CPTRSET      /* 0xBF8114C8 */
  .extern DCH5CPTRINV      /* 0xBF8114CC */
  .extern DCS5CPTRINV      /* 0xBF8114CC */
  .extern DCH5DAT          /* 0xBF8114D0 */
  .extern DCH5DATCLR       /* 0xBF8114D4 */
  .extern DCH5DATSET       /* 0xBF8114D8 */
  .extern DCH5DATINV       /* 0xBF8114DC */
  .extern DCH6CON          /* 0xBF8114E0 */
  .extern DCH6CONCLR       /* 0xBF8114E4 */
  .extern DCH6CONSET       /* 0xBF8114E8 */
  .extern DCH6CONINV       /* 0xBF8114EC */
  .extern DCH6ECON         /* 0xBF8114F0 */
  .extern DCH6ECONCLR      /* 0xBF8114F4 */
  .extern DCH6ECONSET      /* 0xBF8114F8 */
  .extern DCH6ECONINV      /* 0xBF8114FC */
  .extern DCH6INT          /* 0xBF811500 */
  .extern DCH6INTCLR       /* 0xBF811504 */
  .extern DCH6INTSET       /* 0xBF811508 */
  .extern DCH6INTINV       /* 0xBF81150C */
  .extern DCH6SSA          /* 0xBF811510 */
  .extern DCH6SSACLR       /* 0xBF811514 */
  .extern DCH6SSASET       /* 0xBF811518 */
  .extern DCH6SSAINV       /* 0xBF81151C */
  .extern DCH6DSA          /* 0xBF811520 */
  .extern DCH6DSACLR       /* 0xBF811524 */
  .extern DCH6DSASET       /* 0xBF811528 */
  .extern DCH6DSAINV       /* 0xBF81152C */
  .extern DCH6SSIZ         /* 0xBF811530 */
  .extern DCH6SSIZCLR      /* 0xBF811534 */
  .extern DCH6SSIZSET      /* 0xBF811538 */
  .extern DCH6SSIZINV      /* 0xBF81153C */
  .extern DCH6DSIZ         /* 0xBF811540 */
  .extern DCH6DSIZCLR      /* 0xBF811544 */
  .extern DCH6DSIZSET      /* 0xBF811548 */
  .extern DCH6DSIZINV      /* 0xBF81154C */
  .extern DCH6SPTR         /* 0xBF811550 */
  .extern DCH6SPTRCLR      /* 0xBF811554 */
  .extern DCH6SPTRSET      /* 0xBF811558 */
  .extern DCH6SPTRINV      /* 0xBF81155C */
  .extern DCH6DPTR         /* 0xBF811560 */
  .extern DCH6DPTRCLR      /* 0xBF811564 */
  .extern DCH6DPTRSET      /* 0xBF811568 */
  .extern DCH6DPTRINV      /* 0xBF81156C */
  .extern DCH6CSIZ         /* 0xBF811570 */
  .extern DCH6CSIZCLR      /* 0xBF811574 */
  .extern DCH6CSIZSET      /* 0xBF811578 */
  .extern DCH6CSIZINV      /* 0xBF81157C */
  .extern DCH6CPTR         /* 0xBF811580 */
  .extern DCS6CPTR         /* 0xBF811580 */
  .extern DCH6CPTRCLR      /* 0xBF811584 */
  .extern DCS6CPTRCLR      /* 0xBF811584 */
  .extern DCH6CPTRSET      /* 0xBF811588 */
  .extern DCS6CPTRSET      /* 0xBF811588 */
  .extern DCH6CPTRINV      /* 0xBF81158C */
  .extern DCS6CPTRINV      /* 0xBF81158C */
  .extern DCH6DAT          /* 0xBF811590 */
  .extern DCH6DATCLR       /* 0xBF811594 */
  .extern DCH6DATSET       /* 0xBF811598 */
  .extern DCH6DATINV       /* 0xBF81159C */
  .extern DCH7CON          /* 0xBF8115A0 */
  .extern DCH7CONCLR       /* 0xBF8115A4 */
  .extern DCH7CONSET       /* 0xBF8115A8 */
  .extern DCH7CONINV       /* 0xBF8115AC */
  .extern DCH7ECON         /* 0xBF8115B0 */
  .extern DCH7ECONCLR      /* 0xBF8115B4 */
  .extern DCH7ECONSET      /* 0xBF8115B8 */
  .extern DCH7ECONINV      /* 0xBF8115BC */
  .extern DCH7INT          /* 0xBF8115C0 */
  .extern DCH7INTCLR       /* 0xBF8115C4 */
  .extern DCH7INTSET       /* 0xBF8115C8 */
  .extern DCH7INTINV       /* 0xBF8115CC */
  .extern DCH7SSA          /* 0xBF8115D0 */
  .extern DCH7SSACLR       /* 0xBF8115D4 */
  .extern DCH7SSASET       /* 0xBF8115D8 */
  .extern DCH7SSAINV       /* 0xBF8115DC */
  .extern DCH7DSA          /* 0xBF8115E0 */
  .extern DCH7DSACLR       /* 0xBF8115E4 */
  .extern DCH7DSASET       /* 0xBF8115E8 */
  .extern DCH7DSAINV       /* 0xBF8115EC */
  .extern DCH7SSIZ         /* 0xBF8115F0 */
  .extern DCH7SSIZCLR      /* 0xBF8115F4 */
  .extern DCH7SSIZSET      /* 0xBF8115F8 */
  .extern DCH7SSIZINV      /* 0xBF8115FC */
  .extern DCH7DSIZ         /* 0xBF811600 */
  .extern DCH7DSIZCLR      /* 0xBF811604 */
  .extern DCH7DSIZSET      /* 0xBF811608 */
  .extern DCH7DSIZINV      /* 0xBF81160C */
  .extern DCH7SPTR         /* 0xBF811610 */
  .extern DCH7SPTRCLR      /* 0xBF811614 */
  .extern DCH7SPTRSET      /* 0xBF811618 */
  .extern DCH7SPTRINV      /* 0xBF81161C */
  .extern DCH7DPTR         /* 0xBF811620 */
  .extern DCH7DPTRCLR      /* 0xBF811624 */
  .extern DCH7DPTRSET      /* 0xBF811628 */
  .extern DCH7DPTRINV      /* 0xBF81162C */
  .extern DCH7CSIZ         /* 0xBF811630 */
  .extern DCH7CSIZCLR      /* 0xBF811634 */
  .extern DCH7CSIZSET      /* 0xBF811638 */
  .extern DCH7CSIZINV      /* 0xBF81163C */
  .extern DCH7CPTR         /* 0xBF811640 */
  .extern DCS7CPTR         /* 0xBF811640 */
  .extern DCH7CPTRCLR      /* 0xBF811644 */
  .extern DCS7CPTRCLR      /* 0xBF811644 */
  .extern DCH7CPTRSET      /* 0xBF811648 */
  .extern DCS7CPTRSET      /* 0xBF811648 */
  .extern DCH7CPTRINV      /* 0xBF81164C */
  .extern DCS7CPTRINV      /* 0xBF81164C */
  .extern DCH7DAT          /* 0xBF811650 */
  .extern DCH7DATCLR       /* 0xBF811654 */
  .extern DCH7DATSET       /* 0xBF811658 */
  .extern DCH7DATINV       /* 0xBF81165C */
  .extern I2C1CON          /* 0xBF820000 */
  .extern I2C1CONCLR       /* 0xBF820004 */
  .extern I2C1CONSET       /* 0xBF820008 */
  .extern I2C1CONINV       /* 0xBF82000C */
  .extern I2C1STAT         /* 0xBF820010 */
  .extern I2C1STATCLR      /* 0xBF820014 */
  .extern I2C1STATSET      /* 0xBF820018 */
  .extern I2C1STATINV      /* 0xBF82001C */
  .extern I2C1ADD          /* 0xBF820020 */
  .extern I2C1ADDCLR       /* 0xBF820024 */
  .extern I2C1ADDSET       /* 0xBF820028 */
  .extern I2C1ADDINV       /* 0xBF82002C */
  .extern I2C1MSK          /* 0xBF820030 */
  .extern I2C1MSKCLR       /* 0xBF820034 */
  .extern I2C1MSKSET       /* 0xBF820038 */
  .extern I2C1MSKINV       /* 0xBF82003C */
  .extern I2C1BRG          /* 0xBF820040 */
  .extern I2C1BRGCLR       /* 0xBF820044 */
  .extern I2C1BRGSET       /* 0xBF820048 */
  .extern I2C1BRGINV       /* 0xBF82004C */
  .extern I2C1TRN          /* 0xBF820050 */
  .extern I2C1TRNCLR       /* 0xBF820054 */
  .extern I2C1TRNSET       /* 0xBF820058 */
  .extern I2C1TRNINV       /* 0xBF82005C */
  .extern I2C1RCV          /* 0xBF820060 */
  .extern I2C1RCVCLR       /* 0xBF820064 */
  .extern I2C1RCVSET       /* 0xBF820068 */
  .extern I2C1RCVINV       /* 0xBF82006C */
  .extern I2C2CON          /* 0xBF820200 */
  .extern I2C2CONCLR       /* 0xBF820204 */
  .extern I2C2CONSET       /* 0xBF820208 */
  .extern I2C2CONINV       /* 0xBF82020C */
  .extern I2C2STAT         /* 0xBF820210 */
  .extern I2C2STATCLR      /* 0xBF820214 */
  .extern I2C2STATSET      /* 0xBF820218 */
  .extern I2C2STATINV      /* 0xBF82021C */
  .extern I2C2ADD          /* 0xBF820220 */
  .extern I2C2ADDCLR       /* 0xBF820224 */
  .extern I2C2ADDSET       /* 0xBF820228 */
  .extern I2C2ADDINV       /* 0xBF82022C */
  .extern I2C2MSK          /* 0xBF820230 */
  .extern I2C2MSKCLR       /* 0xBF820234 */
  .extern I2C2MSKSET       /* 0xBF820238 */
  .extern I2C2MSKINV       /* 0xBF82023C */
  .extern I2C2BRG          /* 0xBF820240 */
  .extern I2C2BRGCLR       /* 0xBF820244 */
  .extern I2C2BRGSET       /* 0xBF820248 */
  .extern I2C2BRGINV       /* 0xBF82024C */
  .extern I2C2TRN          /* 0xBF820250 */
  .extern I2C2TRNCLR       /* 0xBF820254 */
  .extern I2C2TRNSET       /* 0xBF820258 */
  .extern I2C2TRNINV       /* 0xBF82025C */
  .extern I2C2RCV          /* 0xBF820260 */
  .extern I2C2RCVCLR       /* 0xBF820264 */
  .extern I2C2RCVSET       /* 0xBF820268 */
  .extern I2C2RCVINV       /* 0xBF82026C */
  .extern I2C3CON          /* 0xBF820400 */
  .extern I2C3CONCLR       /* 0xBF820404 */
  .extern I2C3CONSET       /* 0xBF820408 */
  .extern I2C3CONINV       /* 0xBF82040C */
  .extern I2C3STAT         /* 0xBF820410 */
  .extern I2C3STATCLR      /* 0xBF820414 */
  .extern I2C3STATSET      /* 0xBF820418 */
  .extern I2C3STATINV      /* 0xBF82041C */
  .extern I2C3ADD          /* 0xBF820420 */
  .extern I2C3ADDCLR       /* 0xBF820424 */
  .extern I2C3ADDSET       /* 0xBF820428 */
  .extern I2C3ADDINV       /* 0xBF82042C */
  .extern I2C3MSK          /* 0xBF820430 */
  .extern I2C3MSKCLR       /* 0xBF820434 */
  .extern I2C3MSKSET       /* 0xBF820438 */
  .extern I2C3MSKINV       /* 0xBF82043C */
  .extern I2C3BRG          /* 0xBF820440 */
  .extern I2C3BRGCLR       /* 0xBF820444 */
  .extern I2C3BRGSET       /* 0xBF820448 */
  .extern I2C3BRGINV       /* 0xBF82044C */
  .extern I2C3TRN          /* 0xBF820450 */
  .extern I2C3TRNCLR       /* 0xBF820454 */
  .extern I2C3TRNSET       /* 0xBF820458 */
  .extern I2C3TRNINV       /* 0xBF82045C */
  .extern I2C3RCV          /* 0xBF820460 */
  .extern I2C3RCVCLR       /* 0xBF820464 */
  .extern I2C3RCVSET       /* 0xBF820468 */
  .extern I2C3RCVINV       /* 0xBF82046C */
  .extern I2C4CON          /* 0xBF820600 */
  .extern I2C4CONCLR       /* 0xBF820604 */
  .extern I2C4CONSET       /* 0xBF820608 */
  .extern I2C4CONINV       /* 0xBF82060C */
  .extern I2C4STAT         /* 0xBF820610 */
  .extern I2C4STATCLR      /* 0xBF820614 */
  .extern I2C4STATSET      /* 0xBF820618 */
  .extern I2C4STATINV      /* 0xBF82061C */
  .extern I2C4ADD          /* 0xBF820620 */
  .extern I2C4ADDCLR       /* 0xBF820624 */
  .extern I2C4ADDSET       /* 0xBF820628 */
  .extern I2C4ADDINV       /* 0xBF82062C */
  .extern I2C4MSK          /* 0xBF820630 */
  .extern I2C4MSKCLR       /* 0xBF820634 */
  .extern I2C4MSKSET       /* 0xBF820638 */
  .extern I2C4MSKINV       /* 0xBF82063C */
  .extern I2C4BRG          /* 0xBF820640 */
  .extern I2C4BRGCLR       /* 0xBF820644 */
  .extern I2C4BRGSET       /* 0xBF820648 */
  .extern I2C4BRGINV       /* 0xBF82064C */
  .extern I2C4TRN          /* 0xBF820650 */
  .extern I2C4TRNCLR       /* 0xBF820654 */
  .extern I2C4TRNSET       /* 0xBF820658 */
  .extern I2C4TRNINV       /* 0xBF82065C */
  .extern I2C4RCV          /* 0xBF820660 */
  .extern I2C4RCVCLR       /* 0xBF820664 */
  .extern I2C4RCVSET       /* 0xBF820668 */
  .extern I2C4RCVINV       /* 0xBF82066C */
  .extern I2C5CON          /* 0xBF820800 */
  .extern I2C5CONCLR       /* 0xBF820804 */
  .extern I2C5CONSET       /* 0xBF820808 */
  .extern I2C5CONINV       /* 0xBF82080C */
  .extern I2C5STAT         /* 0xBF820810 */
  .extern I2C5STATCLR      /* 0xBF820814 */
  .extern I2C5STATSET      /* 0xBF820818 */
  .extern I2C5STATINV      /* 0xBF82081C */
  .extern I2C5ADD          /* 0xBF820820 */
  .extern I2C5ADDCLR       /* 0xBF820824 */
  .extern I2C5ADDSET       /* 0xBF820828 */
  .extern I2C5ADDINV       /* 0xBF82082C */
  .extern I2C5MSK          /* 0xBF820830 */
  .extern I2C5MSKCLR       /* 0xBF820834 */
  .extern I2C5MSKSET       /* 0xBF820838 */
  .extern I2C5MSKINV       /* 0xBF82083C */
  .extern I2C5BRG          /* 0xBF820840 */
  .extern I2C5BRGCLR       /* 0xBF820844 */
  .extern I2C5BRGSET       /* 0xBF820848 */
  .extern I2C5BRGINV       /* 0xBF82084C */
  .extern I2C5TRN          /* 0xBF820850 */
  .extern I2C5TRNCLR       /* 0xBF820854 */
  .extern I2C5TRNSET       /* 0xBF820858 */
  .extern I2C5TRNINV       /* 0xBF82085C */
  .extern I2C5RCV          /* 0xBF820860 */
  .extern I2C5RCVCLR       /* 0xBF820864 */
  .extern I2C5RCVSET       /* 0xBF820868 */
  .extern I2C5RCVINV       /* 0xBF82086C */
  .extern SPI1CON          /* 0xBF821000 */
  .extern SPI1CONCLR       /* 0xBF821004 */
  .extern SPI1CONSET       /* 0xBF821008 */
  .extern SPI1CONINV       /* 0xBF82100C */
  .extern SPI1STAT         /* 0xBF821010 */
  .extern SPI1STATCLR      /* 0xBF821014 */
  .extern SPI1STATSET      /* 0xBF821018 */
  .extern SPI1STATINV      /* 0xBF82101C */
  .extern SPI1BUF          /* 0xBF821020 */
  .extern SPI1BRG          /* 0xBF821030 */
  .extern SPI1BRGCLR       /* 0xBF821034 */
  .extern SPI1BRGSET       /* 0xBF821038 */
  .extern SPI1BRGINV       /* 0xBF82103C */
  .extern SPI1CON2         /* 0xBF821040 */
  .extern SPI1CON2CLR      /* 0xBF821044 */
  .extern SPI1CON2SET      /* 0xBF821048 */
  .extern SPI1CON2INV      /* 0xBF82104C */
  .extern SPI2CON          /* 0xBF821200 */
  .extern SPI2CONCLR       /* 0xBF821204 */
  .extern SPI2CONSET       /* 0xBF821208 */
  .extern SPI2CONINV       /* 0xBF82120C */
  .extern SPI2STAT         /* 0xBF821210 */
  .extern SPI2STATCLR      /* 0xBF821214 */
  .extern SPI2STATSET      /* 0xBF821218 */
  .extern SPI2STATINV      /* 0xBF82121C */
  .extern SPI2BUF          /* 0xBF821220 */
  .extern SPI2BRG          /* 0xBF821230 */
  .extern SPI2BRGCLR       /* 0xBF821234 */
  .extern SPI2BRGSET       /* 0xBF821238 */
  .extern SPI2BRGINV       /* 0xBF82123C */
  .extern SPI2CON2         /* 0xBF821240 */
  .extern SPI2CON2CLR      /* 0xBF821244 */
  .extern SPI2CON2SET      /* 0xBF821248 */
  .extern SPI2CON2INV      /* 0xBF82124C */
  .extern SPI3CON          /* 0xBF821400 */
  .extern SPI3CONCLR       /* 0xBF821404 */
  .extern SPI3CONSET       /* 0xBF821408 */
  .extern SPI3CONINV       /* 0xBF82140C */
  .extern SPI3STAT         /* 0xBF821410 */
  .extern SPI3STATCLR      /* 0xBF821414 */
  .extern SPI3STATSET      /* 0xBF821418 */
  .extern SPI3STATINV      /* 0xBF82141C */
  .extern SPI3BUF          /* 0xBF821420 */
  .extern SPI3BRG          /* 0xBF821430 */
  .extern SPI3BRGCLR       /* 0xBF821434 */
  .extern SPI3BRGSET       /* 0xBF821438 */
  .extern SPI3BRGINV       /* 0xBF82143C */
  .extern SPI3CON2         /* 0xBF821440 */
  .extern SPI3CON2CLR      /* 0xBF821444 */
  .extern SPI3CON2SET      /* 0xBF821448 */
  .extern SPI3CON2INV      /* 0xBF82144C */
  .extern SPI4CON          /* 0xBF821600 */
  .extern SPI4CONCLR       /* 0xBF821604 */
  .extern SPI4CONSET       /* 0xBF821608 */
  .extern SPI4CONINV       /* 0xBF82160C */
  .extern SPI4STAT         /* 0xBF821610 */
  .extern SPI4STATCLR      /* 0xBF821614 */
  .extern SPI4STATSET      /* 0xBF821618 */
  .extern SPI4STATINV      /* 0xBF82161C */
  .extern SPI4BUF          /* 0xBF821620 */
  .extern SPI4BRG          /* 0xBF821630 */
  .extern SPI4BRGCLR       /* 0xBF821634 */
  .extern SPI4BRGSET       /* 0xBF821638 */
  .extern SPI4BRGINV       /* 0xBF82163C */
  .extern SPI4CON2         /* 0xBF821640 */
  .extern SPI4CON2CLR      /* 0xBF821644 */
  .extern SPI4CON2SET      /* 0xBF821648 */
  .extern SPI4CON2INV      /* 0xBF82164C */
  .extern SPI5CON          /* 0xBF821800 */
  .extern SPI5CONCLR       /* 0xBF821804 */
  .extern SPI5CONSET       /* 0xBF821808 */
  .extern SPI5CONINV       /* 0xBF82180C */
  .extern SPI5STAT         /* 0xBF821810 */
  .extern SPI5STATCLR      /* 0xBF821814 */
  .extern SPI5STATSET      /* 0xBF821818 */
  .extern SPI5STATINV      /* 0xBF82181C */
  .extern SPI5BUF          /* 0xBF821820 */
  .extern SPI5BRG          /* 0xBF821830 */
  .extern SPI5BRGCLR       /* 0xBF821834 */
  .extern SPI5BRGSET       /* 0xBF821838 */
  .extern SPI5BRGINV       /* 0xBF82183C */
  .extern SPI5CON2         /* 0xBF821840 */
  .extern SPI5CON2CLR      /* 0xBF821844 */
  .extern SPI5CON2SET      /* 0xBF821848 */
  .extern SPI5CON2INV      /* 0xBF82184C */
  .extern SPI6CON          /* 0xBF821A00 */
  .extern SPI6CONCLR       /* 0xBF821A04 */
  .extern SPI6CONSET       /* 0xBF821A08 */
  .extern SPI6CONINV       /* 0xBF821A0C */
  .extern SPI6STAT         /* 0xBF821A10 */
  .extern SPI6STATCLR      /* 0xBF821A14 */
  .extern SPI6STATSET      /* 0xBF821A18 */
  .extern SPI6STATINV      /* 0xBF821A1C */
  .extern SPI6BUF          /* 0xBF821A20 */
  .extern SPI6BRG          /* 0xBF821A30 */
  .extern SPI6BRGCLR       /* 0xBF821A34 */
  .extern SPI6BRGSET       /* 0xBF821A38 */
  .extern SPI6BRGINV       /* 0xBF821A3C */
  .extern SPI6CON2         /* 0xBF821A40 */
  .extern SPI6CON2CLR      /* 0xBF821A44 */
  .extern SPI6CON2SET      /* 0xBF821A48 */
  .extern SPI6CON2INV      /* 0xBF821A4C */
  .extern U1MODE           /* 0xBF822000 */
  .extern UABMODE          /* 0xBF822000 */
  .extern U1MODECLR        /* 0xBF822004 */
  .extern UABMODECLR       /* 0xBF822004 */
  .extern U1MODESET        /* 0xBF822008 */
  .extern UABMODESET       /* 0xBF822008 */
  .extern U1MODEINV        /* 0xBF82200C */
  .extern UABMODEINV       /* 0xBF82200C */
  .extern U1STA            /* 0xBF822010 */
  .extern UABSTA           /* 0xBF822010 */
  .extern U1STACLR         /* 0xBF822014 */
  .extern UABSTACLR        /* 0xBF822014 */
  .extern U1STASET         /* 0xBF822018 */
  .extern UABSTASET        /* 0xBF822018 */
  .extern U1STAINV         /* 0xBF82201C */
  .extern UABSTAINV        /* 0xBF82201C */
  .extern U1TXREG          /* 0xBF822020 */
  .extern UABTXREG         /* 0xBF822020 */
  .extern U1RXREG          /* 0xBF822030 */
  .extern UABRXREG         /* 0xBF822030 */
  .extern U1BRG            /* 0xBF822040 */
  .extern UABBRG           /* 0xBF822040 */
  .extern U1BRGCLR         /* 0xBF822044 */
  .extern UABBRGCLR        /* 0xBF822044 */
  .extern U1BRGSET         /* 0xBF822048 */
  .extern UABBRGSET        /* 0xBF822048 */
  .extern U1BRGINV         /* 0xBF82204C */
  .extern UABBRGINV        /* 0xBF82204C */
  .extern U2MODE           /* 0xBF822200 */
  .extern UCDMODE          /* 0xBF822200 */
  .extern U2MODECLR        /* 0xBF822204 */
  .extern UCDMODECLR       /* 0xBF822204 */
  .extern U2MODESET        /* 0xBF822208 */
  .extern UCDMODESET       /* 0xBF822208 */
  .extern U2MODEINV        /* 0xBF82220C */
  .extern UCDMODEINV       /* 0xBF82220C */
  .extern U2STA            /* 0xBF822210 */
  .extern UCDSTA           /* 0xBF822210 */
  .extern U2STACLR         /* 0xBF822214 */
  .extern UCDSTACLR        /* 0xBF822214 */
  .extern U2STASET         /* 0xBF822218 */
  .extern UCDSTASET        /* 0xBF822218 */
  .extern U2STAINV         /* 0xBF82221C */
  .extern UCDSTAINV        /* 0xBF82221C */
  .extern U2TXREG          /* 0xBF822220 */
  .extern UCDTXREG         /* 0xBF822220 */
  .extern U2RXREG          /* 0xBF822230 */
  .extern UCDRXREG         /* 0xBF822230 */
  .extern U2BRG            /* 0xBF822240 */
  .extern UCDBRG           /* 0xBF822240 */
  .extern U2BRGCLR         /* 0xBF822244 */
  .extern UCDBRGCLR        /* 0xBF822244 */
  .extern U2BRGSET         /* 0xBF822248 */
  .extern UCDBRGSET        /* 0xBF822248 */
  .extern U2BRGINV         /* 0xBF82224C */
  .extern UCDBRGINV        /* 0xBF82224C */
  .extern U3MODE           /* 0xBF822400 */
  .extern UEFMODE          /* 0xBF822400 */
  .extern U3MODECLR        /* 0xBF822404 */
  .extern UEFMODECLR       /* 0xBF822404 */
  .extern U3MODESET        /* 0xBF822408 */
  .extern UEFMODESET       /* 0xBF822408 */
  .extern U3MODEINV        /* 0xBF82240C */
  .extern UEFMODEINV       /* 0xBF82240C */
  .extern U3STA            /* 0xBF822410 */
  .extern UEFSTA           /* 0xBF822410 */
  .extern U3STACLR         /* 0xBF822414 */
  .extern UEFSTACLR        /* 0xBF822414 */
  .extern U3STASET         /* 0xBF822418 */
  .extern UEFSTASET        /* 0xBF822418 */
  .extern U3STAINV         /* 0xBF82241C */
  .extern UEFSTAINV        /* 0xBF82241C */
  .extern U3TXREG          /* 0xBF822420 */
  .extern UEFTXREG         /* 0xBF822420 */
  .extern U3RXREG          /* 0xBF822430 */
  .extern UEFRXREG         /* 0xBF822430 */
  .extern U3BRG            /* 0xBF822440 */
  .extern UEFBRG           /* 0xBF822440 */
  .extern U3BRGCLR         /* 0xBF822444 */
  .extern UEFBRGCLR        /* 0xBF822444 */
  .extern U3BRGSET         /* 0xBF822448 */
  .extern UEFBRGSET        /* 0xBF822448 */
  .extern U3BRGINV         /* 0xBF82244C */
  .extern UEFBRGINV        /* 0xBF82244C */
  .extern U4MODE           /* 0xBF822600 */
  .extern UGHMODE          /* 0xBF822600 */
  .extern U4MODECLR        /* 0xBF822604 */
  .extern UGHMODECLR       /* 0xBF822604 */
  .extern U4MODESET        /* 0xBF822608 */
  .extern UGHMODESET       /* 0xBF822608 */
  .extern U4MODEINV        /* 0xBF82260C */
  .extern UGHMODEINV       /* 0xBF82260C */
  .extern U4STA            /* 0xBF822610 */
  .extern UGHSTA           /* 0xBF822610 */
  .extern U4STACLR         /* 0xBF822614 */
  .extern UGHSTACLR        /* 0xBF822614 */
  .extern U4STASET         /* 0xBF822618 */
  .extern UGHSTASET        /* 0xBF822618 */
  .extern U4STAINV         /* 0xBF82261C */
  .extern UGHSTAINV        /* 0xBF82261C */
  .extern U4TXREG          /* 0xBF822620 */
  .extern UGHTXREG         /* 0xBF822620 */
  .extern U4RXREG          /* 0xBF822630 */
  .extern UGHRXREG         /* 0xBF822630 */
  .extern U4BRG            /* 0xBF822640 */
  .extern UGHBRG           /* 0xBF822640 */
  .extern U4BRGCLR         /* 0xBF822644 */
  .extern UGHBRGCLR        /* 0xBF822644 */
  .extern U4BRGSET         /* 0xBF822648 */
  .extern UGHBRGSET        /* 0xBF822648 */
  .extern U4BRGINV         /* 0xBF82264C */
  .extern UGHBRGINV        /* 0xBF82264C */
  .extern U5MODE           /* 0xBF822800 */
  .extern UJKMODE          /* 0xBF822800 */
  .extern U5MODECLR        /* 0xBF822804 */
  .extern UJKMODECLR       /* 0xBF822804 */
  .extern U5MODESET        /* 0xBF822808 */
  .extern UJKMODESET       /* 0xBF822808 */
  .extern U5MODEINV        /* 0xBF82280C */
  .extern UJKMODEINV       /* 0xBF82280C */
  .extern U5STA            /* 0xBF822810 */
  .extern UJKSTA           /* 0xBF822810 */
  .extern U5STACLR         /* 0xBF822814 */
  .extern UJKSTACLR        /* 0xBF822814 */
  .extern U5STASET         /* 0xBF822818 */
  .extern UJKSTASET        /* 0xBF822818 */
  .extern U5STAINV         /* 0xBF82281C */
  .extern UJKSTAINV        /* 0xBF82281C */
  .extern U5TXREG          /* 0xBF822820 */
  .extern UJKTXREG         /* 0xBF822820 */
  .extern U5RXREG          /* 0xBF822830 */
  .extern UJKRXREG         /* 0xBF822830 */
  .extern U5BRG            /* 0xBF822840 */
  .extern UJKBRG           /* 0xBF822840 */
  .extern U5BRGCLR         /* 0xBF822844 */
  .extern UJKBRGCLR        /* 0xBF822844 */
  .extern U5BRGSET         /* 0xBF822848 */
  .extern UJKBRGSET        /* 0xBF822848 */
  .extern U5BRGINV         /* 0xBF82284C */
  .extern UJKBRGINV        /* 0xBF82284C */
  .extern U6MODE           /* 0xBF822A00 */
  .extern ULMMODE          /* 0xBF822A00 */
  .extern U6MODECLR        /* 0xBF822A04 */
  .extern ULMMODECLR       /* 0xBF822A04 */
  .extern U6MODESET        /* 0xBF822A08 */
  .extern ULMMODESET       /* 0xBF822A08 */
  .extern U6MODEINV        /* 0xBF822A0C */
  .extern ULMMODEINV       /* 0xBF822A0C */
  .extern U6STA            /* 0xBF822A10 */
  .extern ULMSTA           /* 0xBF822A10 */
  .extern U6STACLR         /* 0xBF822A14 */
  .extern ULMSTACLR        /* 0xBF822A14 */
  .extern U6STASET         /* 0xBF822A18 */
  .extern ULMSTASET        /* 0xBF822A18 */
  .extern U6STAINV         /* 0xBF822A1C */
  .extern ULMSTAINV        /* 0xBF822A1C */
  .extern U6TXREG          /* 0xBF822A20 */
  .extern ULMTXREG         /* 0xBF822A20 */
  .extern U6RXREG          /* 0xBF822A30 */
  .extern ULMRXREG         /* 0xBF822A30 */
  .extern U6BRG            /* 0xBF822A40 */
  .extern ULMBRG           /* 0xBF822A40 */
  .extern U6BRGCLR         /* 0xBF822A44 */
  .extern ULMBRGCLR        /* 0xBF822A44 */
  .extern U6BRGSET         /* 0xBF822A48 */
  .extern ULMBRGSET        /* 0xBF822A48 */
  .extern U6BRGINV         /* 0xBF822A4C */
  .extern ULMBRGINV        /* 0xBF822A4C */
  .extern PMCON            /* 0xBF82E000 */
  .extern PMCONCLR         /* 0xBF82E004 */
  .extern PMCONSET         /* 0xBF82E008 */
  .extern PMCONINV         /* 0xBF82E00C */
  .extern PMMODE           /* 0xBF82E010 */
  .extern PMMODECLR        /* 0xBF82E014 */
  .extern PMMODESET        /* 0xBF82E018 */
  .extern PMMODEINV        /* 0xBF82E01C */
  .extern PMADDR           /* 0xBF82E020 */
  .extern PMADDRCLR        /* 0xBF82E024 */
  .extern PMADDRSET        /* 0xBF82E028 */
  .extern PMADDRINV        /* 0xBF82E02C */
  .extern PMDOUT           /* 0xBF82E030 */
  .extern PMDOUTCLR        /* 0xBF82E034 */
  .extern PMDOUTSET        /* 0xBF82E038 */
  .extern PMDOUTINV        /* 0xBF82E03C */
  .extern PMDIN            /* 0xBF82E040 */
  .extern PMDINCLR         /* 0xBF82E044 */
  .extern PMDINSET         /* 0xBF82E048 */
  .extern PMDININV         /* 0xBF82E04C */
  .extern PMAEN            /* 0xBF82E050 */
  .extern PMAENCLR         /* 0xBF82E054 */
  .extern PMAENSET         /* 0xBF82E058 */
  .extern PMAENINV         /* 0xBF82E05C */
  .extern PMSTAT           /* 0xBF82E060 */
  .extern PMSTATCLR        /* 0xBF82E064 */
  .extern PMSTATSET        /* 0xBF82E068 */
  .extern PMSTATINV        /* 0xBF82E06C */
  .extern PMWADDR          /* 0xBF82E070 */
  .extern PMWADDRCLR       /* 0xBF82E074 */
  .extern PMWADDRSET       /* 0xBF82E078 */
  .extern PMWADDRINV       /* 0xBF82E07C */
  .extern PMRADDR          /* 0xBF82E080 */
  .extern PMRADDRCLR       /* 0xBF82E084 */
  .extern PMRADDRSET       /* 0xBF82E088 */
  .extern PMRADDRINV       /* 0xBF82E08C */
  .extern PMRDIN           /* 0xBF82E090 */
  .extern PMRDINCLR        /* 0xBF82E094 */
  .extern PMRDINSET        /* 0xBF82E098 */
  .extern PMRDININV        /* 0xBF82E09C */
  .extern T1CON            /* 0xBF840000 */
  .extern T1CONCLR         /* 0xBF840004 */
  .extern T1CONSET         /* 0xBF840008 */
  .extern T1CONINV         /* 0xBF84000C */
  .extern TMR1             /* 0xBF840010 */
  .extern TMR1CLR          /* 0xBF840014 */
  .extern TMR1SET          /* 0xBF840018 */
  .extern TMR1INV          /* 0xBF84001C */
  .extern PR1              /* 0xBF840020 */
  .extern PR1CLR           /* 0xBF840024 */
  .extern PR1SET           /* 0xBF840028 */
  .extern PR1INV           /* 0xBF84002C */
  .extern T2CON            /* 0xBF840200 */
  .extern T2CONCLR         /* 0xBF840204 */
  .extern T2CONSET         /* 0xBF840208 */
  .extern T2CONINV         /* 0xBF84020C */
  .extern TMR2             /* 0xBF840210 */
  .extern TMR2CLR          /* 0xBF840214 */
  .extern TMR2SET          /* 0xBF840218 */
  .extern TMR2INV          /* 0xBF84021C */
  .extern PR2              /* 0xBF840220 */
  .extern PR2CLR           /* 0xBF840224 */
  .extern PR2SET           /* 0xBF840228 */
  .extern PR2INV           /* 0xBF84022C */
  .extern T3CON            /* 0xBF840400 */
  .extern T3CONCLR         /* 0xBF840404 */
  .extern T3CONSET         /* 0xBF840408 */
  .extern T3CONINV         /* 0xBF84040C */
  .extern TMR3             /* 0xBF840410 */
  .extern TMR3CLR          /* 0xBF840414 */
  .extern TMR3SET          /* 0xBF840418 */
  .extern TMR3INV          /* 0xBF84041C */
  .extern PR3              /* 0xBF840420 */
  .extern PR3CLR           /* 0xBF840424 */
  .extern PR3SET           /* 0xBF840428 */
  .extern PR3INV           /* 0xBF84042C */
  .extern T4CON            /* 0xBF840600 */
  .extern T4CONCLR         /* 0xBF840604 */
  .extern T4CONSET         /* 0xBF840608 */
  .extern T4CONINV         /* 0xBF84060C */
  .extern TMR4             /* 0xBF840610 */
  .extern TMR4CLR          /* 0xBF840614 */
  .extern TMR4SET          /* 0xBF840618 */
  .extern TMR4INV          /* 0xBF84061C */
  .extern PR4              /* 0xBF840620 */
  .extern PR4CLR           /* 0xBF840624 */
  .extern PR4SET           /* 0xBF840628 */
  .extern PR4INV           /* 0xBF84062C */
  .extern T5CON            /* 0xBF840800 */
  .extern T5CONCLR         /* 0xBF840804 */
  .extern T5CONSET         /* 0xBF840808 */
  .extern T5CONINV         /* 0xBF84080C */
  .extern TMR5             /* 0xBF840810 */
  .extern TMR5CLR          /* 0xBF840814 */
  .extern TMR5SET          /* 0xBF840818 */
  .extern TMR5INV          /* 0xBF84081C */
  .extern PR5              /* 0xBF840820 */
  .extern PR5CLR           /* 0xBF840824 */
  .extern PR5SET           /* 0xBF840828 */
  .extern PR5INV           /* 0xBF84082C */
  .extern T6CON            /* 0xBF840A00 */
  .extern T6CONCLR         /* 0xBF840A04 */
  .extern T6CONSET         /* 0xBF840A08 */
  .extern T6CONINV         /* 0xBF840A0C */
  .extern TMR6             /* 0xBF840A10 */
  .extern TMR6CLR          /* 0xBF840A14 */
  .extern TMR6SET          /* 0xBF840A18 */
  .extern TMR6INV          /* 0xBF840A1C */
  .extern PR6              /* 0xBF840A20 */
  .extern PR6CLR           /* 0xBF840A24 */
  .extern PR6SET           /* 0xBF840A28 */
  .extern PR6INV           /* 0xBF840A2C */
  .extern T7CON            /* 0xBF840C00 */
  .extern T7CONCLR         /* 0xBF840C04 */
  .extern T7CONSET         /* 0xBF840C08 */
  .extern T7CONINV         /* 0xBF840C0C */
  .extern TMR7             /* 0xBF840C10 */
  .extern TMR7CLR          /* 0xBF840C14 */
  .extern TMR7SET          /* 0xBF840C18 */
  .extern TMR7INV          /* 0xBF840C1C */
  .extern PR7              /* 0xBF840C20 */
  .extern PR7CLR           /* 0xBF840C24 */
  .extern PR7SET           /* 0xBF840C28 */
  .extern PR7INV           /* 0xBF840C2C */
  .extern T8CON            /* 0xBF840E00 */
  .extern T8CONCLR         /* 0xBF840E04 */
  .extern T8CONSET         /* 0xBF840E08 */
  .extern T8CONINV         /* 0xBF840E0C */
  .extern TMR8             /* 0xBF840E10 */
  .extern TMR8CLR          /* 0xBF840E14 */
  .extern TMR8SET          /* 0xBF840E18 */
  .extern TMR8INV          /* 0xBF840E1C */
  .extern PR8              /* 0xBF840E20 */
  .extern PR8CLR           /* 0xBF840E24 */
  .extern PR8SET           /* 0xBF840E28 */
  .extern PR8INV           /* 0xBF840E2C */
  .extern T9CON            /* 0xBF841000 */
  .extern T9CONCLR         /* 0xBF841004 */
  .extern T9CONSET         /* 0xBF841008 */
  .extern T9CONINV         /* 0xBF84100C */
  .extern TMR9             /* 0xBF841010 */
  .extern TMR9CLR          /* 0xBF841014 */
  .extern TMR9SET          /* 0xBF841018 */
  .extern TMR9INV          /* 0xBF84101C */
  .extern PR9              /* 0xBF841020 */
  .extern PR9CLR           /* 0xBF841024 */
  .extern PR9SET           /* 0xBF841028 */
  .extern PR9INV           /* 0xBF84102C */
  .extern IC1CON           /* 0xBF842000 */
  .extern IC1CONCLR        /* 0xBF842004 */
  .extern IC1CONSET        /* 0xBF842008 */
  .extern IC1CONINV        /* 0xBF84200C */
  .extern IC1BUF           /* 0xBF842010 */
  .extern IC2CON           /* 0xBF842200 */
  .extern IC2CONCLR        /* 0xBF842204 */
  .extern IC2CONSET        /* 0xBF842208 */
  .extern IC2CONINV        /* 0xBF84220C */
  .extern IC2BUF           /* 0xBF842210 */
  .extern IC3CON           /* 0xBF842400 */
  .extern IC3CONCLR        /* 0xBF842404 */
  .extern IC3CONSET        /* 0xBF842408 */
  .extern IC3CONINV        /* 0xBF84240C */
  .extern IC3BUF           /* 0xBF842410 */
  .extern IC4CON           /* 0xBF842600 */
  .extern IC4CONCLR        /* 0xBF842604 */
  .extern IC4CONSET        /* 0xBF842608 */
  .extern IC4CONINV        /* 0xBF84260C */
  .extern IC4BUF           /* 0xBF842610 */
  .extern IC5CON           /* 0xBF842800 */
  .extern IC5CONCLR        /* 0xBF842804 */
  .extern IC5CONSET        /* 0xBF842808 */
  .extern IC5CONINV        /* 0xBF84280C */
  .extern IC5BUF           /* 0xBF842810 */
  .extern IC6CON           /* 0xBF842A00 */
  .extern IC6CONCLR        /* 0xBF842A04 */
  .extern IC6CONSET        /* 0xBF842A08 */
  .extern IC6CONINV        /* 0xBF842A0C */
  .extern IC6BUF           /* 0xBF842A10 */
  .extern IC7CON           /* 0xBF842C00 */
  .extern IC7CONCLR        /* 0xBF842C04 */
  .extern IC7CONSET        /* 0xBF842C08 */
  .extern IC7CONINV        /* 0xBF842C0C */
  .extern IC7BUF           /* 0xBF842C10 */
  .extern IC8CON           /* 0xBF842E00 */
  .extern IC8CONCLR        /* 0xBF842E04 */
  .extern IC8CONSET        /* 0xBF842E08 */
  .extern IC8CONINV        /* 0xBF842E0C */
  .extern IC8BUF           /* 0xBF842E10 */
  .extern IC9CON           /* 0xBF843000 */
  .extern IC9CONCLR        /* 0xBF843004 */
  .extern IC9CONSET        /* 0xBF843008 */
  .extern IC9CONINV        /* 0xBF84300C */
  .extern IC9BUF           /* 0xBF843010 */
  .extern OC1CON           /* 0xBF844000 */
  .extern OC1CONCLR        /* 0xBF844004 */
  .extern OC1CONSET        /* 0xBF844008 */
  .extern OC1CONINV        /* 0xBF84400C */
  .extern OC1R             /* 0xBF844010 */
  .extern OC1RCLR          /* 0xBF844014 */
  .extern OC1RSET          /* 0xBF844018 */
  .extern OC1RINV          /* 0xBF84401C */
  .extern OC1RS            /* 0xBF844020 */
  .extern OC1RSCLR         /* 0xBF844024 */
  .extern OC1RSSET         /* 0xBF844028 */
  .extern OC1RSINV         /* 0xBF84402C */
  .extern OC2CON           /* 0xBF844200 */
  .extern OC2CONCLR        /* 0xBF844204 */
  .extern OC2CONSET        /* 0xBF844208 */
  .extern OC2CONINV        /* 0xBF84420C */
  .extern OC2R             /* 0xBF844210 */
  .extern OC2RCLR          /* 0xBF844214 */
  .extern OC2RSET          /* 0xBF844218 */
  .extern OC2RINV          /* 0xBF84421C */
  .extern OC2RS            /* 0xBF844220 */
  .extern OC2RSCLR         /* 0xBF844224 */
  .extern OC2RSSET         /* 0xBF844228 */
  .extern OC2RSINV         /* 0xBF84422C */
  .extern OC3CON           /* 0xBF844400 */
  .extern OC3CONCLR        /* 0xBF844404 */
  .extern OC3CONSET        /* 0xBF844408 */
  .extern OC3CONINV        /* 0xBF84440C */
  .extern OC3R             /* 0xBF844410 */
  .extern OC3RCLR          /* 0xBF844414 */
  .extern OC3RSET          /* 0xBF844418 */
  .extern OC3RINV          /* 0xBF84441C */
  .extern OC3RS            /* 0xBF844420 */
  .extern OC3RSCLR         /* 0xBF844424 */
  .extern OC3RSSET         /* 0xBF844428 */
  .extern OC3RSINV         /* 0xBF84442C */
  .extern OC4CON           /* 0xBF844600 */
  .extern OC4CONCLR        /* 0xBF844604 */
  .extern OC4CONSET        /* 0xBF844608 */
  .extern OC4CONINV        /* 0xBF84460C */
  .extern OC4R             /* 0xBF844610 */
  .extern OC4RCLR          /* 0xBF844614 */
  .extern OC4RSET          /* 0xBF844618 */
  .extern OC4RINV          /* 0xBF84461C */
  .extern OC4RS            /* 0xBF844620 */
  .extern OC4RSCLR         /* 0xBF844624 */
  .extern OC4RSSET         /* 0xBF844628 */
  .extern OC4RSINV         /* 0xBF84462C */
  .extern OC5CON           /* 0xBF844800 */
  .extern OC5CONCLR        /* 0xBF844804 */
  .extern OC5CONSET        /* 0xBF844808 */
  .extern OC5CONINV        /* 0xBF84480C */
  .extern OC5R             /* 0xBF844810 */
  .extern OC5RCLR          /* 0xBF844814 */
  .extern OC5RSET          /* 0xBF844818 */
  .extern OC5RINV          /* 0xBF84481C */
  .extern OC5RS            /* 0xBF844820 */
  .extern OC5RSCLR         /* 0xBF844824 */
  .extern OC5RSSET         /* 0xBF844828 */
  .extern OC5RSINV         /* 0xBF84482C */
  .extern OC6CON           /* 0xBF844A00 */
  .extern OC6CONCLR        /* 0xBF844A04 */
  .extern OC6CONSET        /* 0xBF844A08 */
  .extern OC6CONINV        /* 0xBF844A0C */
  .extern OC6R             /* 0xBF844A10 */
  .extern OC6RCLR          /* 0xBF844A14 */
  .extern OC6RSET          /* 0xBF844A18 */
  .extern OC6RINV          /* 0xBF844A1C */
  .extern OC6RS            /* 0xBF844A20 */
  .extern OC6RSCLR         /* 0xBF844A24 */
  .extern OC6RSSET         /* 0xBF844A28 */
  .extern OC6RSINV         /* 0xBF844A2C */
  .extern OC7CON           /* 0xBF844C00 */
  .extern OC7CONCLR        /* 0xBF844C04 */
  .extern OC7CONSET        /* 0xBF844C08 */
  .extern OC7CONINV        /* 0xBF844C0C */
  .extern OC7R             /* 0xBF844C10 */
  .extern OC7RCLR          /* 0xBF844C14 */
  .extern OC7RSET          /* 0xBF844C18 */
  .extern OC7RINV          /* 0xBF844C1C */
  .extern OC7RS            /* 0xBF844C20 */
  .extern OC7RSCLR         /* 0xBF844C24 */
  .extern OC7RSSET         /* 0xBF844C28 */
  .extern OC7RSINV         /* 0xBF844C2C */
  .extern OC8CON           /* 0xBF844E00 */
  .extern OC8CONCLR        /* 0xBF844E04 */
  .extern OC8CONSET        /* 0xBF844E08 */
  .extern OC8CONINV        /* 0xBF844E0C */
  .extern OC8R             /* 0xBF844E10 */
  .extern OC8RCLR          /* 0xBF844E14 */
  .extern OC8RSET          /* 0xBF844E18 */
  .extern OC8RINV          /* 0xBF844E1C */
  .extern OC8RS            /* 0xBF844E20 */
  .extern OC8RSCLR         /* 0xBF844E24 */
  .extern OC8RSSET         /* 0xBF844E28 */
  .extern OC8RSINV         /* 0xBF844E2C */
  .extern OC9CON           /* 0xBF845000 */
  .extern OC9CONCLR        /* 0xBF845004 */
  .extern OC9CONSET        /* 0xBF845008 */
  .extern OC9CONINV        /* 0xBF84500C */
  .extern OC9R             /* 0xBF845010 */
  .extern OC9RCLR          /* 0xBF845014 */
  .extern OC9RSET          /* 0xBF845018 */
  .extern OC9RINV          /* 0xBF84501C */
  .extern OC9RS            /* 0xBF845020 */
  .extern OC9RSCLR         /* 0xBF845024 */
  .extern OC9RSSET         /* 0xBF845028 */
  .extern OC9RSINV         /* 0xBF84502C */
  .extern ADCCON1          /* 0xBF84B000 */
  .extern ADCCON2          /* 0xBF84B004 */
  .extern ADCCON3          /* 0xBF84B008 */
  .extern ADCTRGMODE       /* 0xBF84B00C */
  .extern ADCIMCON1        /* 0xBF84B010 */
  .extern ADCIMCON2        /* 0xBF84B014 */
  .extern ADCIMCON3        /* 0xBF84B018 */
  .extern ADCGIRQEN1       /* 0xBF84B020 */
  .extern ADCGIRQEN2       /* 0xBF84B024 */
  .extern ADCCSS1          /* 0xBF84B028 */
  .extern ADCCSS2          /* 0xBF84B02C */
  .extern ADCDSTAT1        /* 0xBF84B030 */
  .extern ADCDSTAT2        /* 0xBF84B034 */
  .extern ADCCMPEN1        /* 0xBF84B038 */
  .extern ADCCMP1          /* 0xBF84B03C */
  .extern ADCCMPEN2        /* 0xBF84B040 */
  .extern ADCCMP2          /* 0xBF84B044 */
  .extern ADCCMPEN3        /* 0xBF84B048 */
  .extern ADCCMP3          /* 0xBF84B04C */
  .extern ADCCMPEN4        /* 0xBF84B050 */
  .extern ADCCMP4          /* 0xBF84B054 */
  .extern ADCCMPEN5        /* 0xBF84B058 */
  .extern ADCCMP5          /* 0xBF84B05C */
  .extern ADCCMPEN6        /* 0xBF84B060 */
  .extern ADCCMP6          /* 0xBF84B064 */
  .extern ADCFLTR1         /* 0xBF84B068 */
  .extern ADCFLTR2         /* 0xBF84B06C */
  .extern ADCFLTR3         /* 0xBF84B070 */
  .extern ADCFLTR4         /* 0xBF84B074 */
  .extern ADCFLTR5         /* 0xBF84B078 */
  .extern ADCFLTR6         /* 0xBF84B07C */
  .extern ADCTRG1          /* 0xBF84B080 */
  .extern ADCTRG2          /* 0xBF84B084 */
  .extern ADCTRG3          /* 0xBF84B088 */
  .extern ADCCMPCON1       /* 0xBF84B0A0 */
  .extern ADCCMPCON2       /* 0xBF84B0A4 */
  .extern ADCCMPCON3       /* 0xBF84B0A8 */
  .extern ADCCMPCON4       /* 0xBF84B0AC */
  .extern ADCCMPCON5       /* 0xBF84B0B0 */
  .extern ADCCMPCON6       /* 0xBF84B0B4 */
  .extern ADCFSTAT         /* 0xBF84B0B8 */
  .extern ADCFIFO          /* 0xBF84B0BC */
  .extern ADCBASE          /* 0xBF84B0C0 */
  .extern ADCTRGSNS        /* 0xBF84B0D0 */
  .extern ADC0TIME         /* 0xBF84B0D4 */
  .extern ADC1TIME         /* 0xBF84B0D8 */
  .extern ADC2TIME         /* 0xBF84B0DC */
  .extern ADC3TIME         /* 0xBF84B0E0 */
  .extern ADC4TIME         /* 0xBF84B0E4 */
  .extern ADCEIEN1         /* 0xBF84B0F0 */
  .extern ADCEIEN2         /* 0xBF84B0F4 */
  .extern ADCEISTAT1       /* 0xBF84B0F8 */
  .extern ADCEISTAT2       /* 0xBF84B0FC */
  .extern ADCANCON         /* 0xBF84B100 */
  .extern ADC0CFG          /* 0xBF84B180 */
  .extern ADC1CFG          /* 0xBF84B184 */
  .extern ADC2CFG          /* 0xBF84B188 */
  .extern ADC3CFG          /* 0xBF84B18C */
  .extern ADC4CFG          /* 0xBF84B190 */
  .extern ADC7CFG          /* 0xBF84B19C */
  .extern ADCSYSCFG0       /* 0xBF84B1C0 */
  .extern ADCSYSCFG1       /* 0xBF84B1C4 */
  .extern ADCDATA0         /* 0xBF84B200 */
  .extern ADCDATA1         /* 0xBF84B204 */
  .extern ADCDATA2         /* 0xBF84B208 */
  .extern ADCDATA3         /* 0xBF84B20C */
  .extern ADCDATA4         /* 0xBF84B210 */
  .extern ADCDATA5         /* 0xBF84B214 */
  .extern ADCDATA6         /* 0xBF84B218 */
  .extern ADCDATA7         /* 0xBF84B21C */
  .extern ADCDATA8         /* 0xBF84B220 */
  .extern ADCDATA9         /* 0xBF84B224 */
  .extern ADCDATA10        /* 0xBF84B228 */
  .extern ADCDATA11        /* 0xBF84B22C */
  .extern ADCDATA12        /* 0xBF84B230 */
  .extern ADCDATA13        /* 0xBF84B234 */
  .extern ADCDATA14        /* 0xBF84B238 */
  .extern ADCDATA15        /* 0xBF84B23C */
  .extern ADCDATA16        /* 0xBF84B240 */
  .extern ADCDATA17        /* 0xBF84B244 */
  .extern ADCDATA18        /* 0xBF84B248 */
  .extern ADCDATA19        /* 0xBF84B24C */
  .extern ADCDATA20        /* 0xBF84B250 */
  .extern ADCDATA21        /* 0xBF84B254 */
  .extern ADCDATA22        /* 0xBF84B258 */
  .extern ADCDATA23        /* 0xBF84B25C */
  .extern ADCDATA24        /* 0xBF84B260 */
  .extern ADCDATA25        /* 0xBF84B264 */
  .extern ADCDATA26        /* 0xBF84B268 */
  .extern ADCDATA27        /* 0xBF84B26C */
  .extern ADCDATA28        /* 0xBF84B270 */
  .extern ADCDATA29        /* 0xBF84B274 */
  .extern ADCDATA30        /* 0xBF84B278 */
  .extern ADCDATA31        /* 0xBF84B27C */
  .extern ADCDATA32        /* 0xBF84B280 */
  .extern ADCDATA33        /* 0xBF84B284 */
  .extern ADCDATA34        /* 0xBF84B288 */
  .extern ADCDATA43        /* 0xBF84B2AC */
  .extern ADCDATA44        /* 0xBF84B2B0 */
  .extern CM1CON           /* 0xBF84C000 */
  .extern CM1CONCLR        /* 0xBF84C004 */
  .extern CM1CONSET        /* 0xBF84C008 */
  .extern CM1CONINV        /* 0xBF84C00C */
  .extern CM2CON           /* 0xBF84C010 */
  .extern CM2CONCLR        /* 0xBF84C014 */
  .extern CM2CONSET        /* 0xBF84C018 */
  .extern CM2CONINV        /* 0xBF84C01C */
  .extern CMSTAT           /* 0xBF84C060 */
  .extern CMSTATCLR        /* 0xBF84C064 */
  .extern CMSTATSET        /* 0xBF84C068 */
  .extern CMSTATINV        /* 0xBF84C06C */
  .extern ANSELA           /* 0xBF860000 */
  .extern ANSELACLR        /* 0xBF860004 */
  .extern ANSELASET        /* 0xBF860008 */
  .extern ANSELAINV        /* 0xBF86000C */
  .extern TRISA            /* 0xBF860010 */
  .extern TRISACLR         /* 0xBF860014 */
  .extern TRISASET         /* 0xBF860018 */
  .extern TRISAINV         /* 0xBF86001C */
  .extern PORTA            /* 0xBF860020 */
  .extern PORTACLR         /* 0xBF860024 */
  .extern PORTASET         /* 0xBF860028 */
  .extern PORTAINV         /* 0xBF86002C */
  .extern LATA             /* 0xBF860030 */
  .extern LATACLR          /* 0xBF860034 */
  .extern LATASET          /* 0xBF860038 */
  .extern LATAINV          /* 0xBF86003C */
  .extern ODCA             /* 0xBF860040 */
  .extern ODCACLR          /* 0xBF860044 */
  .extern ODCASET          /* 0xBF860048 */
  .extern ODCAINV          /* 0xBF86004C */
  .extern CNPUA            /* 0xBF860050 */
  .extern CNPUACLR         /* 0xBF860054 */
  .extern CNPUASET         /* 0xBF860058 */
  .extern CNPUAINV         /* 0xBF86005C */
  .extern CNPDA            /* 0xBF860060 */
  .extern CNPDACLR         /* 0xBF860064 */
  .extern CNPDASET         /* 0xBF860068 */
  .extern CNPDAINV         /* 0xBF86006C */
  .extern CNCONA           /* 0xBF860070 */
  .extern CNCONACLR        /* 0xBF860074 */
  .extern CNCONASET        /* 0xBF860078 */
  .extern CNCONAINV        /* 0xBF86007C */
  .extern CNENA            /* 0xBF860080 */
  .extern CNENACLR         /* 0xBF860084 */
  .extern CNENASET         /* 0xBF860088 */
  .extern CNENAINV         /* 0xBF86008C */
  .extern CNSTATA          /* 0xBF860090 */
  .extern CNSTATACLR       /* 0xBF860094 */
  .extern CNSTATASET       /* 0xBF860098 */
  .extern CNSTATAINV       /* 0xBF86009C */
  .extern CNNEA            /* 0xBF8600A0 */
  .extern CNNEACLR         /* 0xBF8600A4 */
  .extern CNNEASET         /* 0xBF8600A8 */
  .extern CNNEAINV         /* 0xBF8600AC */
  .extern CNFA             /* 0xBF8600B0 */
  .extern CNFACLR          /* 0xBF8600B4 */
  .extern CNFASET          /* 0xBF8600B8 */
  .extern CNFAINV          /* 0xBF8600BC */
  .extern SRCON0A          /* 0xBF8600C0 */
  .extern SRCON0ACLR       /* 0xBF8600C4 */
  .extern SRCON0ASET       /* 0xBF8600C8 */
  .extern SRCON0AINV       /* 0xBF8600CC */
  .extern SRCON1A          /* 0xBF8600D0 */
  .extern SRCON1ACLR       /* 0xBF8600D4 */
  .extern SRCON1ASET       /* 0xBF8600D8 */
  .extern SRCON1AINV       /* 0xBF8600DC */
  .extern ANSELB           /* 0xBF860100 */
  .extern ANSELBCLR        /* 0xBF860104 */
  .extern ANSELBSET        /* 0xBF860108 */
  .extern ANSELBINV        /* 0xBF86010C */
  .extern TRISB            /* 0xBF860110 */
  .extern TRISBCLR         /* 0xBF860114 */
  .extern TRISBSET         /* 0xBF860118 */
  .extern TRISBINV         /* 0xBF86011C */
  .extern PORTB            /* 0xBF860120 */
  .extern PORTBCLR         /* 0xBF860124 */
  .extern PORTBSET         /* 0xBF860128 */
  .extern PORTBINV         /* 0xBF86012C */
  .extern LATB             /* 0xBF860130 */
  .extern LATBCLR          /* 0xBF860134 */
  .extern LATBSET          /* 0xBF860138 */
  .extern LATBINV          /* 0xBF86013C */
  .extern ODCB             /* 0xBF860140 */
  .extern ODCBCLR          /* 0xBF860144 */
  .extern ODCBSET          /* 0xBF860148 */
  .extern ODCBINV          /* 0xBF86014C */
  .extern CNPUB            /* 0xBF860150 */
  .extern CNPUBCLR         /* 0xBF860154 */
  .extern CNPUBSET         /* 0xBF860158 */
  .extern CNPUBINV         /* 0xBF86015C */
  .extern CNPDB            /* 0xBF860160 */
  .extern CNPDBCLR         /* 0xBF860164 */
  .extern CNPDBSET         /* 0xBF860168 */
  .extern CNPDBINV         /* 0xBF86016C */
  .extern CNCONB           /* 0xBF860170 */
  .extern CNCONBCLR        /* 0xBF860174 */
  .extern CNCONBSET        /* 0xBF860178 */
  .extern CNCONBINV        /* 0xBF86017C */
  .extern CNENB            /* 0xBF860180 */
  .extern CNENBCLR         /* 0xBF860184 */
  .extern CNENBSET         /* 0xBF860188 */
  .extern CNENBINV         /* 0xBF86018C */
  .extern CNSTATB          /* 0xBF860190 */
  .extern CNSTATBCLR       /* 0xBF860194 */
  .extern CNSTATBSET       /* 0xBF860198 */
  .extern CNSTATBINV       /* 0xBF86019C */
  .extern CNNEB            /* 0xBF8601A0 */
  .extern CNNEBCLR         /* 0xBF8601A4 */
  .extern CNNEBSET         /* 0xBF8601A8 */
  .extern CNNEBINV         /* 0xBF8601AC */
  .extern CNFB             /* 0xBF8601B0 */
  .extern CNFBCLR          /* 0xBF8601B4 */
  .extern CNFBSET          /* 0xBF8601B8 */
  .extern CNFBINV          /* 0xBF8601BC */
  .extern SRCON0B          /* 0xBF8601C0 */
  .extern SRCON0BCLR       /* 0xBF8601C4 */
  .extern SRCON0BSET       /* 0xBF8601C8 */
  .extern SRCON0BINV       /* 0xBF8601CC */
  .extern SRCON1B          /* 0xBF8601D0 */
  .extern SRCON1BCLR       /* 0xBF8601D4 */
  .extern SRCON1BSET       /* 0xBF8601D8 */
  .extern SRCON1BINV       /* 0xBF8601DC */
  .extern ANSELC           /* 0xBF860200 */
  .extern ANSELCCLR        /* 0xBF860204 */
  .extern ANSELCSET        /* 0xBF860208 */
  .extern ANSELCINV        /* 0xBF86020C */
  .extern TRISC            /* 0xBF860210 */
  .extern TRISCCLR         /* 0xBF860214 */
  .extern TRISCSET         /* 0xBF860218 */
  .extern TRISCINV         /* 0xBF86021C */
  .extern PORTC            /* 0xBF860220 */
  .extern PORTCCLR         /* 0xBF860224 */
  .extern PORTCSET         /* 0xBF860228 */
  .extern PORTCINV         /* 0xBF86022C */
  .extern LATC             /* 0xBF860230 */
  .extern LATCCLR          /* 0xBF860234 */
  .extern LATCSET          /* 0xBF860238 */
  .extern LATCINV          /* 0xBF86023C */
  .extern ODCC             /* 0xBF860240 */
  .extern ODCCCLR          /* 0xBF860244 */
  .extern ODCCSET          /* 0xBF860248 */
  .extern ODCCINV          /* 0xBF86024C */
  .extern CNPUC            /* 0xBF860250 */
  .extern CNPUCCLR         /* 0xBF860254 */
  .extern CNPUCSET         /* 0xBF860258 */
  .extern CNPUCINV         /* 0xBF86025C */
  .extern CNPDC            /* 0xBF860260 */
  .extern CNPDCCLR         /* 0xBF860264 */
  .extern CNPDCSET         /* 0xBF860268 */
  .extern CNPDCINV         /* 0xBF86026C */
  .extern CNCONC           /* 0xBF860270 */
  .extern CNCONCCLR        /* 0xBF860274 */
  .extern CNCONCSET        /* 0xBF860278 */
  .extern CNCONCINV        /* 0xBF86027C */
  .extern CNENC            /* 0xBF860280 */
  .extern CNENCCLR         /* 0xBF860284 */
  .extern CNENCSET         /* 0xBF860288 */
  .extern CNENCINV         /* 0xBF86028C */
  .extern CNSTATC          /* 0xBF860290 */
  .extern CNSTATCCLR       /* 0xBF860294 */
  .extern CNSTATCSET       /* 0xBF860298 */
  .extern CNSTATCINV       /* 0xBF86029C */
  .extern CNNEC            /* 0xBF8602A0 */
  .extern CNNECCLR         /* 0xBF8602A4 */
  .extern CNNECSET         /* 0xBF8602A8 */
  .extern CNNECINV         /* 0xBF8602AC */
  .extern CNFC             /* 0xBF8602B0 */
  .extern CNFCCLR          /* 0xBF8602B4 */
  .extern CNFCSET          /* 0xBF8602B8 */
  .extern CNFCINV          /* 0xBF8602BC */
  .extern ANSELD           /* 0xBF860300 */
  .extern ANSELDCLR        /* 0xBF860304 */
  .extern ANSELDSET        /* 0xBF860308 */
  .extern ANSELDINV        /* 0xBF86030C */
  .extern TRISD            /* 0xBF860310 */
  .extern TRISDCLR         /* 0xBF860314 */
  .extern TRISDSET         /* 0xBF860318 */
  .extern TRISDINV         /* 0xBF86031C */
  .extern PORTD            /* 0xBF860320 */
  .extern PORTDCLR         /* 0xBF860324 */
  .extern PORTDSET         /* 0xBF860328 */
  .extern PORTDINV         /* 0xBF86032C */
  .extern LATD             /* 0xBF860330 */
  .extern LATDCLR          /* 0xBF860334 */
  .extern LATDSET          /* 0xBF860338 */
  .extern LATDINV          /* 0xBF86033C */
  .extern ODCD             /* 0xBF860340 */
  .extern ODCDCLR          /* 0xBF860344 */
  .extern ODCDSET          /* 0xBF860348 */
  .extern ODCDINV          /* 0xBF86034C */
  .extern CNPUD            /* 0xBF860350 */
  .extern CNPUDCLR         /* 0xBF860354 */
  .extern CNPUDSET         /* 0xBF860358 */
  .extern CNPUDINV         /* 0xBF86035C */
  .extern CNPDD            /* 0xBF860360 */
  .extern CNPDDCLR         /* 0xBF860364 */
  .extern CNPDDSET         /* 0xBF860368 */
  .extern CNPDDINV         /* 0xBF86036C */
  .extern CNCOND           /* 0xBF860370 */
  .extern CNCONDCLR        /* 0xBF860374 */
  .extern CNCONDSET        /* 0xBF860378 */
  .extern CNCONDINV        /* 0xBF86037C */
  .extern CNEND            /* 0xBF860380 */
  .extern CNENDCLR         /* 0xBF860384 */
  .extern CNENDSET         /* 0xBF860388 */
  .extern CNENDINV         /* 0xBF86038C */
  .extern CNSTATD          /* 0xBF860390 */
  .extern CNSTATDCLR       /* 0xBF860394 */
  .extern CNSTATDSET       /* 0xBF860398 */
  .extern CNSTATDINV       /* 0xBF86039C */
  .extern CNNED            /* 0xBF8603A0 */
  .extern CNNEDCLR         /* 0xBF8603A4 */
  .extern CNNEDSET         /* 0xBF8603A8 */
  .extern CNNEDINV         /* 0xBF8603AC */
  .extern CNFD             /* 0xBF8603B0 */
  .extern CNFDCLR          /* 0xBF8603B4 */
  .extern CNFDSET          /* 0xBF8603B8 */
  .extern CNFDINV          /* 0xBF8603BC */
  .extern ANSELE           /* 0xBF860400 */
  .extern ANSELECLR        /* 0xBF860404 */
  .extern ANSELESET        /* 0xBF860408 */
  .extern ANSELEINV        /* 0xBF86040C */
  .extern TRISE            /* 0xBF860410 */
  .extern TRISECLR         /* 0xBF860414 */
  .extern TRISESET         /* 0xBF860418 */
  .extern TRISEINV         /* 0xBF86041C */
  .extern PORTE            /* 0xBF860420 */
  .extern PORTECLR         /* 0xBF860424 */
  .extern PORTESET         /* 0xBF860428 */
  .extern PORTEINV         /* 0xBF86042C */
  .extern LATE             /* 0xBF860430 */
  .extern LATECLR          /* 0xBF860434 */
  .extern LATESET          /* 0xBF860438 */
  .extern LATEINV          /* 0xBF86043C */
  .extern ODCE             /* 0xBF860440 */
  .extern ODCECLR          /* 0xBF860444 */
  .extern ODCESET          /* 0xBF860448 */
  .extern ODCEINV          /* 0xBF86044C */
  .extern CNPUE            /* 0xBF860450 */
  .extern CNPUECLR         /* 0xBF860454 */
  .extern CNPUESET         /* 0xBF860458 */
  .extern CNPUEINV         /* 0xBF86045C */
  .extern CNPDE            /* 0xBF860460 */
  .extern CNPDECLR         /* 0xBF860464 */
  .extern CNPDESET         /* 0xBF860468 */
  .extern CNPDEINV         /* 0xBF86046C */
  .extern CNCONE           /* 0xBF860470 */
  .extern CNCONECLR        /* 0xBF860474 */
  .extern CNCONESET        /* 0xBF860478 */
  .extern CNCONEINV        /* 0xBF86047C */
  .extern CNENE            /* 0xBF860480 */
  .extern CNENECLR         /* 0xBF860484 */
  .extern CNENESET         /* 0xBF860488 */
  .extern CNENEINV         /* 0xBF86048C */
  .extern CNSTATE          /* 0xBF860490 */
  .extern CNSTATECLR       /* 0xBF860494 */
  .extern CNSTATESET       /* 0xBF860498 */
  .extern CNSTATEINV       /* 0xBF86049C */
  .extern CNNEE            /* 0xBF8604A0 */
  .extern CNNEECLR         /* 0xBF8604A4 */
  .extern CNNEESET         /* 0xBF8604A8 */
  .extern CNNEEINV         /* 0xBF8604AC */
  .extern CNFE             /* 0xBF8604B0 */
  .extern CNFECLR          /* 0xBF8604B4 */
  .extern CNFESET          /* 0xBF8604B8 */
  .extern CNFEINV          /* 0xBF8604BC */
  .extern SRCON0E          /* 0xBF8604C0 */
  .extern SRCON0ECLR       /* 0xBF8604C4 */
  .extern SRCON0ESET       /* 0xBF8604C8 */
  .extern SRCON0EINV       /* 0xBF8604CC */
  .extern SRCON1E          /* 0xBF8604D0 */
  .extern SRCON1ECLR       /* 0xBF8604D4 */
  .extern SRCON1ESET       /* 0xBF8604D8 */
  .extern SRCON1EINV       /* 0xBF8604DC */
  .extern ANSELF           /* 0xBF860500 */
  .extern ANSELFCLR        /* 0xBF860504 */
  .extern ANSELFSET        /* 0xBF860508 */
  .extern ANSELFINV        /* 0xBF86050C */
  .extern TRISF            /* 0xBF860510 */
  .extern TRISFCLR         /* 0xBF860514 */
  .extern TRISFSET         /* 0xBF860518 */
  .extern TRISFINV         /* 0xBF86051C */
  .extern PORTF            /* 0xBF860520 */
  .extern PORTFCLR         /* 0xBF860524 */
  .extern PORTFSET         /* 0xBF860528 */
  .extern PORTFINV         /* 0xBF86052C */
  .extern LATF             /* 0xBF860530 */
  .extern LATFCLR          /* 0xBF860534 */
  .extern LATFSET          /* 0xBF860538 */
  .extern LATFINV          /* 0xBF86053C */
  .extern ODCF             /* 0xBF860540 */
  .extern ODCFCLR          /* 0xBF860544 */
  .extern ODCFSET          /* 0xBF860548 */
  .extern ODCFINV          /* 0xBF86054C */
  .extern CNPUF            /* 0xBF860550 */
  .extern CNPUFCLR         /* 0xBF860554 */
  .extern CNPUFSET         /* 0xBF860558 */
  .extern CNPUFINV         /* 0xBF86055C */
  .extern CNPDF            /* 0xBF860560 */
  .extern CNPDFCLR         /* 0xBF860564 */
  .extern CNPDFSET         /* 0xBF860568 */
  .extern CNPDFINV         /* 0xBF86056C */
  .extern CNCONF           /* 0xBF860570 */
  .extern CNCONFCLR        /* 0xBF860574 */
  .extern CNCONFSET        /* 0xBF860578 */
  .extern CNCONFINV        /* 0xBF86057C */
  .extern CNENF            /* 0xBF860580 */
  .extern CNENFCLR         /* 0xBF860584 */
  .extern CNENFSET         /* 0xBF860588 */
  .extern CNENFINV         /* 0xBF86058C */
  .extern CNSTATF          /* 0xBF860590 */
  .extern CNSTATFCLR       /* 0xBF860594 */
  .extern CNSTATFSET       /* 0xBF860598 */
  .extern CNSTATFINV       /* 0xBF86059C */
  .extern CNNEF            /* 0xBF8605A0 */
  .extern CNNEFCLR         /* 0xBF8605A4 */
  .extern CNNEFSET         /* 0xBF8605A8 */
  .extern CNNEFINV         /* 0xBF8605AC */
  .extern CNFF             /* 0xBF8605B0 */
  .extern CNFFCLR          /* 0xBF8605B4 */
  .extern CNFFSET          /* 0xBF8605B8 */
  .extern CNFFINV          /* 0xBF8605BC */
  .extern SRCON0F          /* 0xBF8605C0 */
  .extern SRCON0FCLR       /* 0xBF8605C4 */
  .extern SRCON0FSET       /* 0xBF8605C8 */
  .extern SRCON0FINV       /* 0xBF8605CC */
  .extern SRCON1F          /* 0xBF8605D0 */
  .extern SRCON1FCLR       /* 0xBF8605D4 */
  .extern SRCON1FSET       /* 0xBF8605D8 */
  .extern SRCON1FINV       /* 0xBF8605DC */
  .extern ANSELG           /* 0xBF860600 */
  .extern ANSELGCLR        /* 0xBF860604 */
  .extern ANSELGSET        /* 0xBF860608 */
  .extern ANSELGINV        /* 0xBF86060C */
  .extern TRISG            /* 0xBF860610 */
  .extern TRISGCLR         /* 0xBF860614 */
  .extern TRISGSET         /* 0xBF860618 */
  .extern TRISGINV         /* 0xBF86061C */
  .extern PORTG            /* 0xBF860620 */
  .extern PORTGCLR         /* 0xBF860624 */
  .extern PORTGSET         /* 0xBF860628 */
  .extern PORTGINV         /* 0xBF86062C */
  .extern LATG             /* 0xBF860630 */
  .extern LATGCLR          /* 0xBF860634 */
  .extern LATGSET          /* 0xBF860638 */
  .extern LATGINV          /* 0xBF86063C */
  .extern ODCG             /* 0xBF860640 */
  .extern ODCGCLR          /* 0xBF860644 */
  .extern ODCGSET          /* 0xBF860648 */
  .extern ODCGINV          /* 0xBF86064C */
  .extern CNPUG            /* 0xBF860650 */
  .extern CNPUGCLR         /* 0xBF860654 */
  .extern CNPUGSET         /* 0xBF860658 */
  .extern CNPUGINV         /* 0xBF86065C */
  .extern CNPDG            /* 0xBF860660 */
  .extern CNPDGCLR         /* 0xBF860664 */
  .extern CNPDGSET         /* 0xBF860668 */
  .extern CNPDGINV         /* 0xBF86066C */
  .extern CNCONG           /* 0xBF860670 */
  .extern CNCONGCLR        /* 0xBF860674 */
  .extern CNCONGSET        /* 0xBF860678 */
  .extern CNCONGINV        /* 0xBF86067C */
  .extern CNENG            /* 0xBF860680 */
  .extern CNENGCLR         /* 0xBF860684 */
  .extern CNENGSET         /* 0xBF860688 */
  .extern CNENGINV         /* 0xBF86068C */
  .extern CNSTATG          /* 0xBF860690 */
  .extern CNSTATGCLR       /* 0xBF860694 */
  .extern CNSTATGSET       /* 0xBF860698 */
  .extern CNSTATGINV       /* 0xBF86069C */
  .extern CNNEG            /* 0xBF8606A0 */
  .extern CNNEGCLR         /* 0xBF8606A4 */
  .extern CNNEGSET         /* 0xBF8606A8 */
  .extern CNNEGINV         /* 0xBF8606AC */
  .extern CNFG             /* 0xBF8606B0 */
  .extern CNFGCLR          /* 0xBF8606B4 */
  .extern CNFGSET          /* 0xBF8606B8 */
  .extern CNFGINV          /* 0xBF8606BC */
  .extern SRCON0G          /* 0xBF8606C0 */
  .extern SRCON0GCLR       /* 0xBF8606C4 */
  .extern SRCON0GSET       /* 0xBF8606C8 */
  .extern SRCON0GINV       /* 0xBF8606CC */
  .extern SRCON1G          /* 0xBF8606D0 */
  .extern SRCON1GCLR       /* 0xBF8606D4 */
  .extern SRCON1GSET       /* 0xBF8606D8 */
  .extern SRCON1GINV       /* 0xBF8606DC */
  .extern ETHCON1          /* 0xBF882000 */
  .extern ETHCON1CLR       /* 0xBF882004 */
  .extern ETHCON1SET       /* 0xBF882008 */
  .extern ETHCON1INV       /* 0xBF88200C */
  .extern ETHCON2          /* 0xBF882010 */
  .extern ETHCON2CLR       /* 0xBF882014 */
  .extern ETHCON2SET       /* 0xBF882018 */
  .extern ETHCON2INV       /* 0xBF88201C */
  .extern ETHTXST          /* 0xBF882020 */
  .extern ETHTXSTCLR       /* 0xBF882024 */
  .extern ETHTXSTSET       /* 0xBF882028 */
  .extern ETHTXSTINV       /* 0xBF88202C */
  .extern ETHRXST          /* 0xBF882030 */
  .extern ETHRXSTCLR       /* 0xBF882034 */
  .extern ETHRXSTSET       /* 0xBF882038 */
  .extern ETHRXSTINV       /* 0xBF88203C */
  .extern ETHHT0           /* 0xBF882040 */
  .extern ETHHT0CLR        /* 0xBF882044 */
  .extern ETHHT0SET        /* 0xBF882048 */
  .extern ETHHT0INV        /* 0xBF88204C */
  .extern ETHHT1           /* 0xBF882050 */
  .extern ETHHT1CLR        /* 0xBF882054 */
  .extern ETHHT1SET        /* 0xBF882058 */
  .extern ETHHT1INV        /* 0xBF88205C */
  .extern ETHPMM0          /* 0xBF882060 */
  .extern ETHPMM0CLR       /* 0xBF882064 */
  .extern ETHPMM0SET       /* 0xBF882068 */
  .extern ETHPMM0INV       /* 0xBF88206C */
  .extern ETHPMM1          /* 0xBF882070 */
  .extern ETHPMM1CLR       /* 0xBF882074 */
  .extern ETHPMM1SET       /* 0xBF882078 */
  .extern ETHPMM1INV       /* 0xBF88207C */
  .extern ETHPMCS          /* 0xBF882080 */
  .extern ETHPMCSCLR       /* 0xBF882084 */
  .extern ETHPMCSSET       /* 0xBF882088 */
  .extern ETHPMCSINV       /* 0xBF88208C */
  .extern ETHPMO           /* 0xBF882090 */
  .extern ETHPMOCLR        /* 0xBF882094 */
  .extern ETHPMOSET        /* 0xBF882098 */
  .extern ETHPMOINV        /* 0xBF88209C */
  .extern ETHRXFC          /* 0xBF8820A0 */
  .extern ETHRXFCCLR       /* 0xBF8820A4 */
  .extern ETHRXFCSET       /* 0xBF8820A8 */
  .extern ETHRXFCINV       /* 0xBF8820AC */
  .extern ETHRXWM          /* 0xBF8820B0 */
  .extern ETHRXWMCLR       /* 0xBF8820B4 */
  .extern ETHRXWMSET       /* 0xBF8820B8 */
  .extern ETHRXWMINV       /* 0xBF8820BC */
  .extern ETHIEN           /* 0xBF8820C0 */
  .extern ETHIENCLR        /* 0xBF8820C4 */
  .extern ETHIENSET        /* 0xBF8820C8 */
  .extern ETHIENINV        /* 0xBF8820CC */
  .extern ETHIRQ           /* 0xBF8820D0 */
  .extern ETHIRQCLR        /* 0xBF8820D4 */
  .extern ETHIRQSET        /* 0xBF8820D8 */
  .extern ETHIRQINV        /* 0xBF8820DC */
  .extern ETHSTAT          /* 0xBF8820E0 */
  .extern ETHSTATCLR       /* 0xBF8820E4 */
  .extern ETHSTATSET       /* 0xBF8820E8 */
  .extern ETHSTATINV       /* 0xBF8820EC */
  .extern ETHRXOVFLOW      /* 0xBF882100 */
  .extern ETHRXOVFLOWCLR   /* 0xBF882104 */
  .extern ETHRXOVFLOWSET   /* 0xBF882108 */
  .extern ETHRXOVFLOWINV   /* 0xBF88210C */
  .extern ETHFRMTXOK       /* 0xBF882110 */
  .extern ETHFRMTXOKCLR    /* 0xBF882114 */
  .extern ETHFRMTXOKSET    /* 0xBF882118 */
  .extern ETHFRMTXOKINV    /* 0xBF88211C */
  .extern ETHSCOLFRM       /* 0xBF882120 */
  .extern ETHSCOLFRMCLR    /* 0xBF882124 */
  .extern ETHSCOLFRMSET    /* 0xBF882128 */
  .extern ETHSCOLFRMINV    /* 0xBF88212C */
  .extern ETHMCOLFRM       /* 0xBF882130 */
  .extern ETHMCOLFRMCLR    /* 0xBF882134 */
  .extern ETHMCOLFRMSET    /* 0xBF882138 */
  .extern ETHMCOLFRMINV    /* 0xBF88213C */
  .extern ETHFRMRXOK       /* 0xBF882140 */
  .extern ETHFRMRXOKCLR    /* 0xBF882144 */
  .extern ETHFRMRXOKSET    /* 0xBF882148 */
  .extern ETHFRMRXOKINV    /* 0xBF88214C */
  .extern ETHFCSERR        /* 0xBF882150 */
  .extern ETHFCSERRCLR     /* 0xBF882154 */
  .extern ETHFCSERRSET     /* 0xBF882158 */
  .extern ETHFCSERRINV     /* 0xBF88215C */
  .extern ETHALGNERR       /* 0xBF882160 */
  .extern ETHALGNERRCLR    /* 0xBF882164 */
  .extern ETHALGNERRSET    /* 0xBF882168 */
  .extern ETHALGNERRINV    /* 0xBF88216C */
  .extern EMAC1CFG1        /* 0xBF882200 */
  .extern EMACxCFG1        /* 0xBF882200 */
  .extern EMAC1CFG1CLR     /* 0xBF882204 */
  .extern EMACxCFG1CLR     /* 0xBF882204 */
  .extern EMAC1CFG1SET     /* 0xBF882208 */
  .extern EMACxCFG1SET     /* 0xBF882208 */
  .extern EMAC1CFG1INV     /* 0xBF88220C */
  .extern EMACxCFG1INV     /* 0xBF88220C */
  .extern EMAC1CFG2        /* 0xBF882210 */
  .extern EMACxCFG2        /* 0xBF882210 */
  .extern EMAC1CFG2CLR     /* 0xBF882214 */
  .extern EMACxCFG2CLR     /* 0xBF882214 */
  .extern EMAC1CFG2SET     /* 0xBF882218 */
  .extern EMACxCFG2SET     /* 0xBF882218 */
  .extern EMAC1CFG2INV     /* 0xBF88221C */
  .extern EMACxCFG2INV     /* 0xBF88221C */
  .extern EMAC1IPGT        /* 0xBF882220 */
  .extern EMACxIPGT        /* 0xBF882220 */
  .extern EMAC1IPGTCLR     /* 0xBF882224 */
  .extern EMACxIPGTCLR     /* 0xBF882224 */
  .extern EMAC1IPGTSET     /* 0xBF882228 */
  .extern EMACxIPGTSET     /* 0xBF882228 */
  .extern EMAC1IPGTINV     /* 0xBF88222C */
  .extern EMACxIPGTINV     /* 0xBF88222C */
  .extern EMAC1IPGR        /* 0xBF882230 */
  .extern EMACxIPGR        /* 0xBF882230 */
  .extern EMAC1IPGRCLR     /* 0xBF882234 */
  .extern EMACxIPGRCLR     /* 0xBF882234 */
  .extern EMAC1IPGRSET     /* 0xBF882238 */
  .extern EMACxIPGRSET     /* 0xBF882238 */
  .extern EMAC1IPGRINV     /* 0xBF88223C */
  .extern EMACxIPGRINV     /* 0xBF88223C */
  .extern EMAC1CLRT        /* 0xBF882240 */
  .extern EMACxCLRT        /* 0xBF882240 */
  .extern EMAC1CLRTCLR     /* 0xBF882244 */
  .extern EMACxCLRTCLR     /* 0xBF882244 */
  .extern EMAC1CLRTSET     /* 0xBF882248 */
  .extern EMACxCLRTSET     /* 0xBF882248 */
  .extern EMAC1CLRTINV     /* 0xBF88224C */
  .extern EMACxCLRTINV     /* 0xBF88224C */
  .extern EMAC1MAXF        /* 0xBF882250 */
  .extern EMACxMAXF        /* 0xBF882250 */
  .extern EMAC1MAXFCLR     /* 0xBF882254 */
  .extern EMACxMAXFCLR     /* 0xBF882254 */
  .extern EMAC1MAXFSET     /* 0xBF882258 */
  .extern EMACxMAXFSET     /* 0xBF882258 */
  .extern EMAC1MAXFINV     /* 0xBF88225C */
  .extern EMACxMAXFINV     /* 0xBF88225C */
  .extern EMAC1SUPP        /* 0xBF882260 */
  .extern EMACxSUPP        /* 0xBF882260 */
  .extern EMAC1SUPPCLR     /* 0xBF882264 */
  .extern EMACxSUPPCLR     /* 0xBF882264 */
  .extern EMAC1SUPPSET     /* 0xBF882268 */
  .extern EMACxSUPPSET     /* 0xBF882268 */
  .extern EMAC1SUPPINV     /* 0xBF88226C */
  .extern EMACxSUPPINV     /* 0xBF88226C */
  .extern EMAC1TEST        /* 0xBF882270 */
  .extern EMACxTEST        /* 0xBF882270 */
  .extern EMAC1TESTCLR     /* 0xBF882274 */
  .extern EMACxTESTCLR     /* 0xBF882274 */
  .extern EMAC1TESTSET     /* 0xBF882278 */
  .extern EMACxTESTSET     /* 0xBF882278 */
  .extern EMAC1TESTINV     /* 0xBF88227C */
  .extern EMACxTESTINV     /* 0xBF88227C */
  .extern EMAC1MCFG        /* 0xBF882280 */
  .extern EMACxMCFG        /* 0xBF882280 */
  .extern EMAC1MCFGCLR     /* 0xBF882284 */
  .extern EMACxMCFGCLR     /* 0xBF882284 */
  .extern EMAC1MCFGSET     /* 0xBF882288 */
  .extern EMACxMCFGSET     /* 0xBF882288 */
  .extern EMAC1MCFGINV     /* 0xBF88228C */
  .extern EMACxMCFGINV     /* 0xBF88228C */
  .extern EMAC1MCMD        /* 0xBF882290 */
  .extern EMACxMCMD        /* 0xBF882290 */
  .extern EMAC1MCMDCLR     /* 0xBF882294 */
  .extern EMACxMCMDCLR     /* 0xBF882294 */
  .extern EMAC1MCMDSET     /* 0xBF882298 */
  .extern EMACxMCMDSET     /* 0xBF882298 */
  .extern EMAC1MCMDINV     /* 0xBF88229C */
  .extern EMACxMCMDINV     /* 0xBF88229C */
  .extern EMAC1MADR        /* 0xBF8822A0 */
  .extern EMACxMADR        /* 0xBF8822A0 */
  .extern EMAC1MADRCLR     /* 0xBF8822A4 */
  .extern EMACxMADRCLR     /* 0xBF8822A4 */
  .extern EMAC1MADRSET     /* 0xBF8822A8 */
  .extern EMACxMADRSET     /* 0xBF8822A8 */
  .extern EMAC1MADRINV     /* 0xBF8822AC */
  .extern EMACxMADRINV     /* 0xBF8822AC */
  .extern EMAC1MWTD        /* 0xBF8822B0 */
  .extern EMACxMWTD        /* 0xBF8822B0 */
  .extern EMAC1MWTDCLR     /* 0xBF8822B4 */
  .extern EMACxMWTDCLR     /* 0xBF8822B4 */
  .extern EMAC1MWTDSET     /* 0xBF8822B8 */
  .extern EMACxMWTDSET     /* 0xBF8822B8 */
  .extern EMAC1MWTDINV     /* 0xBF8822BC */
  .extern EMACxMWTDINV     /* 0xBF8822BC */
  .extern EMAC1MRDD        /* 0xBF8822C0 */
  .extern EMACxMRDD        /* 0xBF8822C0 */
  .extern EMAC1MRDDCLR     /* 0xBF8822C4 */
  .extern EMACxMRDDCLR     /* 0xBF8822C4 */
  .extern EMAC1MRDDSET     /* 0xBF8822C8 */
  .extern EMACxMRDDSET     /* 0xBF8822C8 */
  .extern EMAC1MRDDINV     /* 0xBF8822CC */
  .extern EMACxMRDDINV     /* 0xBF8822CC */
  .extern EMAC1MIND        /* 0xBF8822D0 */
  .extern EMACxMIND        /* 0xBF8822D0 */
  .extern EMAC1MINDCLR     /* 0xBF8822D4 */
  .extern EMACxMINDCLR     /* 0xBF8822D4 */
  .extern EMAC1MINDSET     /* 0xBF8822D8 */
  .extern EMACxMINDSET     /* 0xBF8822D8 */
  .extern EMAC1MINDINV     /* 0xBF8822DC */
  .extern EMACxMINDINV     /* 0xBF8822DC */
  .extern EMAC1SA0         /* 0xBF882300 */
  .extern EMACxSA0         /* 0xBF882300 */
  .extern EMAC1SA0CLR      /* 0xBF882304 */
  .extern EMACxSA0CLR      /* 0xBF882304 */
  .extern EMAC1SA0SET      /* 0xBF882308 */
  .extern EMACxSA0SET      /* 0xBF882308 */
  .extern EMAC1SA0INV      /* 0xBF88230C */
  .extern EMACxSA0INV      /* 0xBF88230C */
  .extern EMAC1SA1         /* 0xBF882310 */
  .extern EMACxSA1         /* 0xBF882310 */
  .extern EMAC1SA1CLR      /* 0xBF882314 */
  .extern EMACxSA1CLR      /* 0xBF882314 */
  .extern EMAC1SA1SET      /* 0xBF882318 */
  .extern EMACxSA1SET      /* 0xBF882318 */
  .extern EMAC1SA1INV      /* 0xBF88231C */
  .extern EMACxSA1INV      /* 0xBF88231C */
  .extern EMAC1SA2         /* 0xBF882320 */
  .extern EMACxSA2         /* 0xBF882320 */
  .extern EMAC1SA2CLR      /* 0xBF882324 */
  .extern EMACxSA2CLR      /* 0xBF882324 */
  .extern EMAC1SA2SET      /* 0xBF882328 */
  .extern EMACxSA2SET      /* 0xBF882328 */
  .extern EMAC1SA2INV      /* 0xBF88232C */
  .extern EMACxSA2INV      /* 0xBF88232C */
  .extern USBCRCON         /* 0xBF884000 */
  .extern PRECON           /* 0xBF8E0000 */
  .extern PRECONCLR        /* 0xBF8E0004 */
  .extern PRECONSET        /* 0xBF8E0008 */
  .extern PRECONINV        /* 0xBF8E000C */
  .extern PRESTAT          /* 0xBF8E0010 */
  .extern PRESTATCLR       /* 0xBF8E0014 */
  .extern PRESTATSET       /* 0xBF8E0018 */
  .extern PRESTATINV       /* 0xBF8E001C */
  .extern EBICS0           /* 0xBF8E1014 */
  .extern EBICS1           /* 0xBF8E1018 */
  .extern EBICS2           /* 0xBF8E101C */
  .extern EBICS3           /* 0xBF8E1020 */
  .extern EBIMSK0          /* 0xBF8E1054 */
  .extern EBIMSK1          /* 0xBF8E1058 */
  .extern EBIMSK2          /* 0xBF8E105C */
  .extern EBIMSK3          /* 0xBF8E1060 */
  .extern EBISMT0          /* 0xBF8E1094 */
  .extern EBISMT1          /* 0xBF8E1098 */
  .extern EBISMT2          /* 0xBF8E109C */
  .extern EBIFTRPD         /* 0xBF8E10A0 */
  .extern EBISMCON         /* 0xBF8E10A4 */
  .extern SQI1XCON1        /* 0xBF8E2000 */
  .extern SQI1XCON2        /* 0xBF8E2004 */
  .extern SQI1CFG          /* 0xBF8E2008 */
  .extern SQI1CON          /* 0xBF8E200C */
  .extern SQI1CLKCON       /* 0xBF8E2010 */
  .extern SQI1CMDTHR       /* 0xBF8E2014 */
  .extern SQI1INTTHR       /* 0xBF8E2018 */
  .extern SQI1INTEN        /* 0xBF8E201C */
  .extern SQI1INTSTAT      /* 0xBF8E2020 */
  .extern SQI1TXDATA       /* 0xBF8E2024 */
  .extern SQI1RXDATA       /* 0xBF8E2028 */
  .extern SQI1STAT1        /* 0xBF8E202C */
  .extern SQI1STAT2        /* 0xBF8E2030 */
  .extern SQI1BDCON        /* 0xBF8E2034 */
  .extern SQI1BDCURADD     /* 0xBF8E2038 */
  .extern SQI1BDBASEADD    /* 0xBF8E2040 */
  .extern SQI1BDSTAT       /* 0xBF8E2044 */
  .extern SQI1BDPOLLCON    /* 0xBF8E2048 */
  .extern SQI1BDTXDSTAT    /* 0xBF8E204C */
  .extern SQI1BDRXDSTAT    /* 0xBF8E2050 */
  .extern SQI1THR          /* 0xBF8E2054 */
  .extern SQI1INTSIGEN     /* 0xBF8E2058 */
  .extern SQI1TAPCON       /* 0xBF8E205C */
  .extern SQI1MEMSTAT      /* 0xBF8E2060 */
  .extern SQI1XCON3        /* 0xBF8E2064 */
  .extern SQI1XCON4        /* 0xBF8E2068 */
  .extern USBCSR0          /* 0xBF8E3000 */
  .extern USBCSR1          /* 0xBF8E3004 */
  .extern USBCSR2          /* 0xBF8E3008 */
  .extern USBCSR3          /* 0xBF8E300C */
  .extern USBIENCSR0       /* 0xBF8E3010 */
  .extern USBIENCSR1       /* 0xBF8E3014 */
  .extern USBIENCSR2       /* 0xBF8E3018 */
  .extern USBIENCSR3       /* 0xBF8E301C */
  .extern USBFIFO0         /* 0xBF8E3020 */
  .extern USBFIFO1         /* 0xBF8E3024 */
  .extern USBFIFO2         /* 0xBF8E3028 */
  .extern USBFIFO3         /* 0xBF8E302C */
  .extern USBFIFO4         /* 0xBF8E3030 */
  .extern USBFIFO5         /* 0xBF8E3034 */
  .extern USBFIFO6         /* 0xBF8E3038 */
  .extern USBFIFO7         /* 0xBF8E303C */
  .extern USBOTG           /* 0xBF8E3060 */
  .extern USBFIFOA         /* 0xBF8E3064 */
  .extern USBHWVER         /* 0xBF8E306C */
  .extern USBINFO          /* 0xBF8E3078 */
  .extern USBEOFRST        /* 0xBF8E307C */
  .extern USBE0TXA         /* 0xBF8E3080 */
  .extern USBE0RXA         /* 0xBF8E3084 */
  .extern USBE1TXA         /* 0xBF8E3088 */
  .extern USBE1RXA         /* 0xBF8E308C */
  .extern USBE2TXA         /* 0xBF8E3090 */
  .extern USBE2RXA         /* 0xBF8E3094 */
  .extern USBE3TXA         /* 0xBF8E3098 */
  .extern USBE3RXA         /* 0xBF8E309C */
  .extern USBE4TXA         /* 0xBF8E30A0 */
  .extern USBE4RXA         /* 0xBF8E30A4 */
  .extern USBE5TXA         /* 0xBF8E30A8 */
  .extern USBE5RXA         /* 0xBF8E30AC */
  .extern USBE6TXA         /* 0xBF8E30B0 */
  .extern USBE6RXA         /* 0xBF8E30B4 */
  .extern USBE7TXA         /* 0xBF8E30B8 */
  .extern USBE7RXA         /* 0xBF8E30BC */
  .extern USBE0CSR0        /* 0xBF8E3100 */
  .extern USBE0CSR2        /* 0xBF8E3108 */
  .extern USBE0CSR3        /* 0xBF8E310C */
  .extern USBE1CSR0        /* 0xBF8E3110 */
  .extern USBE1CSR1        /* 0xBF8E3114 */
  .extern USBE1CSR2        /* 0xBF8E3118 */
  .extern USBE1CSR3        /* 0xBF8E311C */
  .extern USBE2CSR0        /* 0xBF8E3120 */
  .extern USBE2CSR1        /* 0xBF8E3124 */
  .extern USBE2CSR2        /* 0xBF8E3128 */
  .extern USBE2CSR3        /* 0xBF8E312C */
  .extern USBE3CSR0        /* 0xBF8E3130 */
  .extern USBE3CSR1        /* 0xBF8E3134 */
  .extern USBE3CSR2        /* 0xBF8E3138 */
  .extern USBE3CSR3        /* 0xBF8E313C */
  .extern USBE4CSR0        /* 0xBF8E3140 */
  .extern USBE4CSR1        /* 0xBF8E3144 */
  .extern USBE4CSR2        /* 0xBF8E3148 */
  .extern USBE4CSR3        /* 0xBF8E314C */
  .extern USBE5CSR0        /* 0xBF8E3150 */
  .extern USBE5CSR1        /* 0xBF8E3154 */
  .extern USBE5CSR2        /* 0xBF8E3158 */
  .extern USBE5CSR3        /* 0xBF8E315C */
  .extern USBE6CSR0        /* 0xBF8E3160 */
  .extern USBE6CSR1        /* 0xBF8E3164 */
  .extern USBE6CSR2        /* 0xBF8E3168 */
  .extern USBE6CSR3        /* 0xBF8E316C */
  .extern USBE7CSR0        /* 0xBF8E3170 */
  .extern USBE7CSR1        /* 0xBF8E3174 */
  .extern USBE7CSR2        /* 0xBF8E3178 */
  .extern USBE7CSR3        /* 0xBF8E317C */
  .extern USBDMAINT        /* 0xBF8E3200 */
  .extern USBDMA1C         /* 0xBF8E3204 */
  .extern USBDMA1A         /* 0xBF8E3208 */
  .extern USBDMA1N         /* 0xBF8E320C */
  .extern USBDMA2C         /* 0xBF8E3214 */
  .extern USBDMA2A         /* 0xBF8E3218 */
  .extern USBDMA2N         /* 0xBF8E321C */
  .extern USBDMA3C         /* 0xBF8E3224 */
  .extern USBDMA3A         /* 0xBF8E3228 */
  .extern USBDMA3N         /* 0xBF8E322C */
  .extern USBDMA4C         /* 0xBF8E3234 */
  .extern USBDMA4A         /* 0xBF8E3238 */
  .extern USBDMA4N         /* 0xBF8E323C */
  .extern USBDMA5C         /* 0xBF8E3244 */
  .extern USBDMA5A         /* 0xBF8E3248 */
  .extern USBDMA5N         /* 0xBF8E324C */
  .extern USBDMA6C         /* 0xBF8E3254 */
  .extern USBDMA6A         /* 0xBF8E3258 */
  .extern USBDMA6N         /* 0xBF8E325C */
  .extern USBDMA7C         /* 0xBF8E3264 */
  .extern USBDMA7A         /* 0xBF8E3268 */
  .extern USBDMA7N         /* 0xBF8E326C */
  .extern USBDMA8C         /* 0xBF8E3274 */
  .extern USBDMA8A         /* 0xBF8E3278 */
  .extern USBDMA8N         /* 0xBF8E327C */
  .extern USBE1RPC         /* 0xBF8E3304 */
  .extern USBE2RPC         /* 0xBF8E3308 */
  .extern USBE3RPC         /* 0xBF8E330C */
  .extern USBE4RPC         /* 0xBF8E3310 */
  .extern USBE5RPC         /* 0xBF8E3314 */
  .extern USBE6RPC         /* 0xBF8E3318 */
  .extern USBE7RPC         /* 0xBF8E331C */
  .extern USBDPBFD         /* 0xBF8E3340 */
  .extern USBTMCON1        /* 0xBF8E3344 */
  .extern USBTMCON2        /* 0xBF8E3348 */
  .extern USBLPMR1         /* 0xBF8E3360 */
  .extern USBLMPR2         /* 0xBF8E3364 */
  .extern USBLPMP2         /* 0xBF8E3364 */
  .extern RNGVER           /* 0xBF8E6000 */
  .extern RNGCON           /* 0xBF8E6004 */
  .extern RNGPOLY1         /* 0xBF8E6008 */
  .extern RNGPOLY2         /* 0xBF8E600C */
  .extern RNGNUMGEN1       /* 0xBF8E6010 */
  .extern RNGNUMGEN2       /* 0xBF8E6014 */
  .extern RNGSEED1         /* 0xBF8E6018 */
  .extern RNGSEED2         /* 0xBF8E601C */
  .extern RNGCNT           /* 0xBF8E6020 */
  .extern SBFLAG           /* 0xBF8F0510 */
  .extern SBT0ELOG1        /* 0xBF8F8020 */
  .extern SBT0ELOG2        /* 0xBF8F8024 */
  .extern SBT0ECON         /* 0xBF8F8028 */
  .extern SBT0ECLRS        /* 0xBF8F8030 */
  .extern SBT0ECLRM        /* 0xBF8F8038 */
  .extern SBT0REG0         /* 0xBF8F8040 */
  .extern SBT0RD0          /* 0xBF8F8050 */
  .extern SBT0WR0          /* 0xBF8F8058 */
  .extern SBT0REG1         /* 0xBF8F8060 */
  .extern SBT0RD1          /* 0xBF8F8070 */
  .extern SBT0WR1          /* 0xBF8F8078 */
  .extern SBT1ELOG1        /* 0xBF8F8420 */
  .extern SBT1ELOG2        /* 0xBF8F8424 */
  .extern SBT1ECON         /* 0xBF8F8428 */
  .extern SBT1ECLRS        /* 0xBF8F8430 */
  .extern SBT1ECLRM        /* 0xBF8F8438 */
  .extern SBT1REG0         /* 0xBF8F8440 */
  .extern SBT1RD0          /* 0xBF8F8450 */
  .extern SBT1WR0          /* 0xBF8F8458 */
  .extern SBT1REG2         /* 0xBF8F8480 */
  .extern SBT1RD2          /* 0xBF8F8490 */
  .extern SBT1WR2          /* 0xBF8F8498 */
  .extern SBT1REG3         /* 0xBF8F84A0 */
  .extern SBT1RD3          /* 0xBF8F84B0 */
  .extern SBT1WR3          /* 0xBF8F84B8 */
  .extern SBT1REG4         /* 0xBF8F84C0 */
  .extern SBT1RD4          /* 0xBF8F84D0 */
  .extern SBT1WR4          /* 0xBF8F84D8 */
  .extern SBT1REG5         /* 0xBF8F84E0 */
  .extern SBT1RD5          /* 0xBF8F84F0 */
  .extern SBT1WR5          /* 0xBF8F84F8 */
  .extern SBT1REG6         /* 0xBF8F8500 */
  .extern SBT1RD6          /* 0xBF8F8510 */
  .extern SBT1WR6          /* 0xBF8F8518 */
  .extern SBT1REG7         /* 0xBF8F8520 */
  .extern SBT1RD7          /* 0xBF8F8530 */
  .extern SBT1WR7          /* 0xBF8F8538 */
  .extern SBT1REG8         /* 0xBF8F8540 */
  .extern SBT1RD8          /* 0xBF8F8550 */
  .extern SBT1WR8          /* 0xBF8F8558 */
  .extern SBT2ELOG1        /* 0xBF8F8820 */
  .extern SBT2ELOG2        /* 0xBF8F8824 */
  .extern SBT2ECON         /* 0xBF8F8828 */
  .extern SBT2ECLRS        /* 0xBF8F8830 */
  .extern SBT2ECLRM        /* 0xBF8F8838 */
  .extern SBT2REG0         /* 0xBF8F8840 */
  .extern SBT2RD0          /* 0xBF8F8850 */
  .extern SBT2WR0          /* 0xBF8F8858 */
  .extern SBT2REG1         /* 0xBF8F8860 */
  .extern SBT2RD1          /* 0xBF8F8870 */
  .extern SBT2WR1          /* 0xBF8F8878 */
  .extern SBT2REG2         /* 0xBF8F8880 */
  .extern SBT2RD2          /* 0xBF8F8890 */
  .extern SBT2WR2          /* 0xBF8F8898 */
  .extern SBT3ELOG1        /* 0xBF8F8C20 */
  .extern SBT3ELOG2        /* 0xBF8F8C24 */
  .extern SBT3ECON         /* 0xBF8F8C28 */
  .extern SBT3ECLRS        /* 0xBF8F8C30 */
  .extern SBT3ECLRM        /* 0xBF8F8C38 */
  .extern SBT3REG0         /* 0xBF8F8C40 */
  .extern SBT3RD0          /* 0xBF8F8C50 */
  .extern SBT3WR0          /* 0xBF8F8C58 */
  .extern SBT3REG1         /* 0xBF8F8C60 */
  .extern SBT3RD1          /* 0xBF8F8C70 */
  .extern SBT3WR1          /* 0xBF8F8C78 */
  .extern SBT3REG2         /* 0xBF8F8C80 */
  .extern SBT3RD2          /* 0xBF8F8C90 */
  .extern SBT3WR2          /* 0xBF8F8C98 */
  .extern SBT4ELOG1        /* 0xBF8F9020 */
  .extern SBT4ELOG2        /* 0xBF8F9024 */
  .extern SBT4ECON         /* 0xBF8F9028 */
  .extern SBT4ECLRS        /* 0xBF8F9030 */
  .extern SBT4ECLRM        /* 0xBF8F9038 */
  .extern SBT4REG0         /* 0xBF8F9040 */
  .extern SBT4RD0          /* 0xBF8F9050 */
  .extern SBT4WR0          /* 0xBF8F9058 */
  .extern SBT4REG2         /* 0xBF8F9080 */
  .extern SBT4RD2          /* 0xBF8F9090 */
  .extern SBT4WR2          /* 0xBF8F9098 */
  .extern SBT5ELOG1        /* 0xBF8F9420 */
  .extern SBT5ELOG2        /* 0xBF8F9424 */
  .extern SBT5ECON         /* 0xBF8F9428 */
  .extern SBT5ECLRS        /* 0xBF8F9430 */
  .extern SBT5ECLRM        /* 0xBF8F9438 */
  .extern SBT5REG0         /* 0xBF8F9440 */
  .extern SBT5RD0          /* 0xBF8F9450 */
  .extern SBT5WR0          /* 0xBF8F9458 */
  .extern SBT5REG1         /* 0xBF8F9460 */
  .extern SBT5RD1          /* 0xBF8F9470 */
  .extern SBT5WR1          /* 0xBF8F9478 */
  .extern SBT5REG2         /* 0xBF8F9480 */
  .extern SBT5RD2          /* 0xBF8F9490 */
  .extern SBT5WR2          /* 0xBF8F9498 */
  .extern SBT6ELOG1        /* 0xBF8F9820 */
  .extern SBT6ELOG2        /* 0xBF8F9824 */
  .extern SBT6ECON         /* 0xBF8F9828 */
  .extern SBT6ECLRS        /* 0xBF8F9830 */
  .extern SBT6ECLRM        /* 0xBF8F9838 */
  .extern SBT6REG0         /* 0xBF8F9840 */
  .extern SBT6RD0          /* 0xBF8F9850 */
  .extern SBT6WR0          /* 0xBF8F9858 */
  .extern SBT6REG1         /* 0xBF8F9860 */
  .extern SBT6RD1          /* 0xBF8F9870 */
  .extern SBT6WR1          /* 0xBF8F9878 */
  .extern SBT7ELOG1        /* 0xBF8F9C20 */
  .extern SBT7ELOG2        /* 0xBF8F9C24 */
  .extern SBT7ECON         /* 0xBF8F9C28 */
  .extern SBT7ECLRS        /* 0xBF8F9C30 */
  .extern SBT7ECLRM        /* 0xBF8F9C38 */
  .extern SBT7REG0         /* 0xBF8F9C40 */
  .extern SBT7RD0          /* 0xBF8F9C50 */
  .extern SBT7WR0          /* 0xBF8F9C58 */
  .extern SBT7REG1         /* 0xBF8F9C60 */
  .extern SBT7RD1          /* 0xBF8F9C70 */
  .extern SBT7WR1          /* 0xBF8F9C78 */
  .extern SBT8ELOG1        /* 0xBF8FA020 */
  .extern SBT8ELOG2        /* 0xBF8FA024 */
  .extern SBT8ECON         /* 0xBF8FA028 */
  .extern SBT8ECLRS        /* 0xBF8FA030 */
  .extern SBT8ECLRM        /* 0xBF8FA038 */
  .extern SBT8REG0         /* 0xBF8FA040 */
  .extern SBT8RD0          /* 0xBF8FA050 */
  .extern SBT8WR0          /* 0xBF8FA058 */
  .extern SBT8REG1         /* 0xBF8FA060 */
  .extern SBT8RD1          /* 0xBF8FA070 */
  .extern SBT8WR1          /* 0xBF8FA078 */
  .extern SBT9ELOG1        /* 0xBF8FA420 */
  .extern SBT9ELOG2        /* 0xBF8FA424 */
  .extern SBT9ECON         /* 0xBF8FA428 */
  .extern SBT9ECLRS        /* 0xBF8FA430 */
  .extern SBT9ECLRM        /* 0xBF8FA438 */
  .extern SBT9REG0         /* 0xBF8FA440 */
  .extern SBT9RD0          /* 0xBF8FA450 */
  .extern SBT9WR0          /* 0xBF8FA458 */
  .extern SBT9REG1         /* 0xBF8FA460 */
  .extern SBT9RD1          /* 0xBF8FA470 */
  .extern SBT9WR1          /* 0xBF8FA478 */
  .extern SBT10ELOG1       /* 0xBF8FA820 */
  .extern SBT10ELOG2       /* 0xBF8FA824 */
  .extern SBT10ECON        /* 0xBF8FA828 */
  .extern SBT10ECLRS       /* 0xBF8FA830 */
  .extern SBT10ECLRM       /* 0xBF8FA838 */
  .extern SBT10REG0        /* 0xBF8FA840 */
  .extern SBT10RD0         /* 0xBF8FA850 */
  .extern SBT10WR0         /* 0xBF8FA858 */
  .extern SBT11ELOG1       /* 0xBF8FAC20 */
  .extern SBT11ELOG2       /* 0xBF8FAC24 */
  .extern SBT11ECON        /* 0xBF8FAC28 */
  .extern SBT11ECLRS       /* 0xBF8FAC30 */
  .extern SBT11ECLRM       /* 0xBF8FAC38 */
  .extern SBT11REG0        /* 0xBF8FAC40 */
  .extern SBT11RD0         /* 0xBF8FAC50 */
  .extern SBT11WR0         /* 0xBF8FAC58 */
  .extern SBT11REG1        /* 0xBF8FAC60 */
  .extern SBT11RD1         /* 0xBF8FAC70 */
  .extern SBT11WR1         /* 0xBF8FAC78 */
  .extern SBT12ELOG1       /* 0xBF8FB020 */
  .extern SBT12ELOG2       /* 0xBF8FB024 */
  .extern SBT12ECON        /* 0xBF8FB028 */
  .extern SBT12ECLRS       /* 0xBF8FB030 */
  .extern SBT12ECLRM       /* 0xBF8FB038 */
  .extern SBT12REG0        /* 0xBF8FB040 */
  .extern SBT12RD0         /* 0xBF8FB050 */
  .extern SBT12WR0         /* 0xBF8FB058 */
  .extern SBT13ELOG1       /* 0xBF8FB420 */
  .extern SBT13ELOG2       /* 0xBF8FB424 */
  .extern SBT13ECON        /* 0xBF8FB428 */
  .extern SBT13ECLRS       /* 0xBF8FB430 */
  .extern SBT13ECLRM       /* 0xBF8FB438 */
  .extern SBT13REG0        /* 0xBF8FB440 */
  .extern SBT13RD0         /* 0xBF8FB450 */
  .extern SBT13WR0         /* 0xBF8FB458 */
  .extern DEVCFG3          /* 0xBFC0FFC0 */
  .extern DEVCFG2          /* 0xBFC0FFC4 */
  .extern DEVCFG1          /* 0xBFC0FFC8 */
  .extern DEVCFG0          /* 0xBFC0FFCC */
  .extern DEVCP3           /* 0xBFC0FFD0 */
  .extern DEVCP2           /* 0xBFC0FFD4 */
  .extern DEVCP1           /* 0xBFC0FFD8 */
  .extern DEVCP0           /* 0xBFC0FFDC */
  .extern DEVSIGN3         /* 0xBFC0FFE0 */
  .extern DEVSIGN2         /* 0xBFC0FFE4 */
  .extern DEVSIGN1         /* 0xBFC0FFE8 */
  .extern DEVSIGN0         /* 0xBFC0FFEC */
  .extern SEQ3             /* 0xBFC0FFF0 */
  .extern SEQ2             /* 0xBFC0FFF4 */
  .extern SEQ1             /* 0xBFC0FFF8 */
  .extern SEQ0             /* 0xBFC0FFFC */
  .extern DEVSN0           /* 0xBFC54020 */
  .extern DEVSN1           /* 0xBFC54024 */
  .extern ADEVCFG3         /* 0xBFC0FF40 */
  .extern ADEVCFG2         /* 0xBFC0FF44 */
  .extern ADEVCFG1         /* 0xBFC0FF48 */
  .extern ADEVCFG0         /* 0xBFC0FF4C */
  .extern ADEVCP3          /* 0xBFC0FF50 */
  .extern ADEVCP2          /* 0xBFC0FF54 */
  .extern ADEVCP1          /* 0xBFC0FF58 */
  .extern ADEVCP0          /* 0xBFC0FF5C */
  .extern ADEVSIGN3        /* 0xBFC0FF60 */
  .extern ADEVSIGN2        /* 0xBFC0FF64 */
  .extern ADEVSIGN1        /* 0xBFC0FF68 */
  .extern ADEVSIGN0        /* 0xBFC0FF6C */
  .extern ASEQ3            /* 0xBFC0FF70 */
  .extern ASEQ2            /* 0xBFC0FF74 */
  .extern ASEQ1            /* 0xBFC0FF78 */
  .extern ASEQ0            /* 0xBFC0FF7C */
  .extern AUBADEVCFG3      /* 0xBFC2FF40 */
  .extern AUBADEVCFG2      /* 0xBFC2FF44 */
  .extern AUBADEVCFG1      /* 0xBFC2FF48 */
  .extern AUBADEVCFG0      /* 0xBFC2FF4C */
  .extern AUBADEVCP3       /* 0xBFC2FF50 */
  .extern AUBADEVCP2       /* 0xBFC2FF54 */
  .extern AUBADEVCP1       /* 0xBFC2FF58 */
  .extern AUBADEVCP0       /* 0xBFC2FF5C */
  .extern AUBADEVSIGN3     /* 0xBFC2FF60 */
  .extern AUBADEVSIGN2     /* 0xBFC2FF64 */
  .extern AUBADEVSIGN1     /* 0xBFC2FF68 */
  .extern AUBADEVSIGN0     /* 0xBFC2FF6C */
  .extern AUBASEQ3         /* 0xBFC2FF70 */
  .extern AUBASEQ2         /* 0xBFC2FF74 */
  .extern AUBASEQ1         /* 0xBFC2FF78 */
  .extern AUBASEQ0         /* 0xBFC2FF7C */
  .extern UBADEVCFG3       /* 0xBFC2FFC0 */
  .extern UBADEVCFG2       /* 0xBFC2FFC4 */
  .extern UBADEVCFG1       /* 0xBFC2FFC8 */
  .extern UBADEVCFG0       /* 0xBFC2FFCC */
  .extern UBADEVCP3        /* 0xBFC2FFD0 */
  .extern UBADEVCP2        /* 0xBFC2FFD4 */
  .extern UBADEVCP1        /* 0xBFC2FFD8 */
  .extern UBADEVCP0        /* 0xBFC2FFDC */
  .extern UBADEVSIGN3      /* 0xBFC2FFE0 */
  .extern UBADEVSIGN2      /* 0xBFC2FFE4 */
  .extern UBADEVSIGN1      /* 0xBFC2FFE8 */
  .extern UBADEVSIGN0      /* 0xBFC2FFEC */
  .extern UBASEQ3          /* 0xBFC2FFF0 */
  .extern UBASEQ2          /* 0xBFC2FFF4 */
  .extern UBASEQ1          /* 0xBFC2FFF8 */
  .extern UBASEQ0          /* 0xBFC2FFFC */
  .extern ABF1DEVCFG3      /* 0xBFC4FF40 */
  .extern ABF1DEVCFG2      /* 0xBFC4FF44 */
  .extern ABF1DEVCFG1      /* 0xBFC4FF48 */
  .extern ABF1DEVCFG0      /* 0xBFC4FF4C */
  .extern ABF1DEVCP3       /* 0xBFC4FF50 */
  .extern ABF1DEVCP2       /* 0xBFC4FF54 */
  .extern ABF1DEVCP1       /* 0xBFC4FF58 */
  .extern ABF1DEVCP0       /* 0xBFC4FF5C */
  .extern ABF1DEVSIGN3     /* 0xBFC4FF60 */
  .extern ABF1DEVSIGN2     /* 0xBFC4FF64 */
  .extern ABF1DEVSIGN1     /* 0xBFC4FF68 */
  .extern ABF1DEVSIGN0     /* 0xBFC4FF6C */
  .extern ABF1SEQ3         /* 0xBFC4FF70 */
  .extern ABF1SEQ2         /* 0xBFC4FF74 */
  .extern ABF1SEQ1         /* 0xBFC4FF78 */
  .extern ABF1SEQ0         /* 0xBFC4FF7C */
  .extern BF1DEVCFG3       /* 0xBFC4FFC0 */
  .extern BF1DEVCFG2       /* 0xBFC4FFC4 */
  .extern BF1DEVCFG1       /* 0xBFC4FFC8 */
  .extern BF1DEVCFG0       /* 0xBFC4FFCC */
  .extern BF1DEVCP3        /* 0xBFC4FFD0 */
  .extern BF1DEVCP2        /* 0xBFC4FFD4 */
  .extern BF1DEVCP1        /* 0xBFC4FFD8 */
  .extern BF1DEVCP0        /* 0xBFC4FFDC */
  .extern BF1DEVSIGN3      /* 0xBFC4FFE0 */
  .extern BF1DEVSIGN2      /* 0xBFC4FFE4 */
  .extern BF1DEVSIGN1      /* 0xBFC4FFE8 */
  .extern BF1DEVSIGN0      /* 0xBFC4FFEC */
  .extern BF1SEQ3          /* 0xBFC4FFF0 */
  .extern BF1SEQ2          /* 0xBFC4FFF4 */
  .extern BF1SEQ1          /* 0xBFC4FFF8 */
  .extern BF1SEQ0          /* 0xBFC4FFFC */
  .extern ABF2DEVCFG3      /* 0xBFC6FF40 */
  .extern ABF2DEVCFG2      /* 0xBFC6FF44 */
  .extern ABF2DEVCFG1      /* 0xBFC6FF48 */
  .extern ABF2DEVCFG0      /* 0xBFC6FF4C */
  .extern ABF2DEVCP3       /* 0xBFC6FF50 */
  .extern ABF2DEVCP2       /* 0xBFC6FF54 */
  .extern ABF2DEVCP1       /* 0xBFC6FF58 */
  .extern ABF2DEVCP0       /* 0xBFC6FF5C */
  .extern ABF2DEVSIGN3     /* 0xBFC6FF60 */
  .extern ABF2DEVSIGN2     /* 0xBFC6FF64 */
  .extern ABF2DEVSIGN1     /* 0xBFC6FF68 */
  .extern ABF2DEVSIGN0     /* 0xBFC6FF6C */
  .extern ABF2SEQ3         /* 0xBFC6FF70 */
  .extern ABF2SEQ2         /* 0xBFC6FF74 */
  .extern ABF2SEQ1         /* 0xBFC6FF78 */
  .extern ABF2SEQ0         /* 0xBFC6FF7C */
  .extern BF2DEVCFG3       /* 0xBFC6FFC0 */
  .extern BF2DEVCFG2       /* 0xBFC6FFC4 */
  .extern BF2DEVCFG1       /* 0xBFC6FFC8 */
  .extern BF2DEVCFG0       /* 0xBFC6FFCC */
  .extern BF2DEVCP3        /* 0xBFC6FFD0 */
  .extern BF2DEVCP2        /* 0xBFC6FFD4 */
  .extern BF2DEVCP1        /* 0xBFC6FFD8 */
  .extern BF2DEVCP0        /* 0xBFC6FFDC */
  .extern BF2DEVSIGN3      /* 0xBFC6FFE0 */
  .extern BF2DEVSIGN2      /* 0xBFC6FFE4 */
  .extern BF2DEVSIGN1      /* 0xBFC6FFE8 */
  .extern BF2DEVSIGN0      /* 0xBFC6FFEC */
  .extern BF2SEQ3          /* 0xBFC6FFF0 */
  .extern BF2SEQ2          /* 0xBFC6FFF4 */
  .extern BF2SEQ1          /* 0xBFC6FFF8 */
  .extern BF2SEQ0          /* 0xBFC6FFFC */
#else
#error Unknown language!
#endif

#define _CFGCON_TDOEN_POSITION                   0x00000000
#define _CFGCON_TDOEN_MASK                       0x00000001
#define _CFGCON_TDOEN_LENGTH                     0x00000001

#define _CFGCON_TROEN_POSITION                   0x00000002
#define _CFGCON_TROEN_MASK                       0x00000004
#define _CFGCON_TROEN_LENGTH                     0x00000001

#define _CFGCON_JTAGEN_POSITION                  0x00000003
#define _CFGCON_JTAGEN_MASK                      0x00000008
#define _CFGCON_JTAGEN_LENGTH                    0x00000001

#define _CFGCON_ECCCON_POSITION                  0x00000004
#define _CFGCON_ECCCON_MASK                      0x00000030
#define _CFGCON_ECCCON_LENGTH                    0x00000002

#define _CFGCON_IOANCPN_POSITION                 0x00000007
#define _CFGCON_IOANCPN_MASK                     0x00000080
#define _CFGCON_IOANCPN_LENGTH                   0x00000001

#define _CFGCON_USBSSEN_POSITION                 0x00000008
#define _CFGCON_USBSSEN_MASK                     0x00000100
#define _CFGCON_USBSSEN_LENGTH                   0x00000001

#define _CFGCON_PGLOCK_POSITION                  0x0000000B
#define _CFGCON_PGLOCK_MASK                      0x00000800
#define _CFGCON_PGLOCK_LENGTH                    0x00000001

#define _CFGCON_PMDLOCK_POSITION                 0x0000000C
#define _CFGCON_PMDLOCK_MASK                     0x00001000
#define _CFGCON_PMDLOCK_LENGTH                   0x00000001

#define _CFGCON_IOLOCK_POSITION                  0x0000000D
#define _CFGCON_IOLOCK_MASK                      0x00002000
#define _CFGCON_IOLOCK_LENGTH                    0x00000001

#define _CFGCON_OCACLK_POSITION                  0x00000010
#define _CFGCON_OCACLK_MASK                      0x00010000
#define _CFGCON_OCACLK_LENGTH                    0x00000001

#define _CFGCON_ICACLK_POSITION                  0x00000011
#define _CFGCON_ICACLK_MASK                      0x00020000
#define _CFGCON_ICACLK_LENGTH                    0x00000001

#define _CFGCON_CPUPRI_POSITION                  0x00000018
#define _CFGCON_CPUPRI_MASK                      0x01000000
#define _CFGCON_CPUPRI_LENGTH                    0x00000001

#define _CFGCON_DMAPRI_POSITION                  0x00000019
#define _CFGCON_DMAPRI_MASK                      0x02000000
#define _CFGCON_DMAPRI_LENGTH                    0x00000001

#define _DEVID_DEVID_POSITION                    0x00000000
#define _DEVID_DEVID_MASK                        0x0FFFFFFF
#define _DEVID_DEVID_LENGTH                      0x0000001C

#define _DEVID_VER_POSITION                      0x0000001C
#define _DEVID_VER_MASK                          0xF0000000
#define _DEVID_VER_LENGTH                        0x00000004

#define _SYSKEY_SYSKEY_POSITION                  0x00000000
#define _SYSKEY_SYSKEY_MASK                      0xFFFFFFFF
#define _SYSKEY_SYSKEY_LENGTH                    0x00000020

#define _PMD1_ADCMD_POSITION                     0x00000000
#define _PMD1_ADCMD_MASK                         0x00000001
#define _PMD1_ADCMD_LENGTH                       0x00000001

#define _PMD1_CVRMD_POSITION                     0x0000000C
#define _PMD1_CVRMD_MASK                         0x00001000
#define _PMD1_CVRMD_LENGTH                       0x00000001

#define _PMD2_CMP1MD_POSITION                    0x00000000
#define _PMD2_CMP1MD_MASK                        0x00000001
#define _PMD2_CMP1MD_LENGTH                      0x00000001

#define _PMD2_CMP2MD_POSITION                    0x00000001
#define _PMD2_CMP2MD_MASK                        0x00000002
#define _PMD2_CMP2MD_LENGTH                      0x00000001

#define _PMD3_IC1MD_POSITION                     0x00000000
#define _PMD3_IC1MD_MASK                         0x00000001
#define _PMD3_IC1MD_LENGTH                       0x00000001

#define _PMD3_IC2MD_POSITION                     0x00000001
#define _PMD3_IC2MD_MASK                         0x00000002
#define _PMD3_IC2MD_LENGTH                       0x00000001

#define _PMD3_IC3MD_POSITION                     0x00000002
#define _PMD3_IC3MD_MASK                         0x00000004
#define _PMD3_IC3MD_LENGTH                       0x00000001

#define _PMD3_IC4MD_POSITION                     0x00000003
#define _PMD3_IC4MD_MASK                         0x00000008
#define _PMD3_IC4MD_LENGTH                       0x00000001

#define _PMD3_IC5MD_POSITION                     0x00000004
#define _PMD3_IC5MD_MASK                         0x00000010
#define _PMD3_IC5MD_LENGTH                       0x00000001

#define _PMD3_IC6MD_POSITION                     0x00000005
#define _PMD3_IC6MD_MASK                         0x00000020
#define _PMD3_IC6MD_LENGTH                       0x00000001

#define _PMD3_IC7MD_POSITION                     0x00000006
#define _PMD3_IC7MD_MASK                         0x00000040
#define _PMD3_IC7MD_LENGTH                       0x00000001

#define _PMD3_IC8MD_POSITION                     0x00000007
#define _PMD3_IC8MD_MASK                         0x00000080
#define _PMD3_IC8MD_LENGTH                       0x00000001

#define _PMD3_IC9MD_POSITION                     0x00000008
#define _PMD3_IC9MD_MASK                         0x00000100
#define _PMD3_IC9MD_LENGTH                       0x00000001

#define _PMD3_OC1MD_POSITION                     0x00000010
#define _PMD3_OC1MD_MASK                         0x00010000
#define _PMD3_OC1MD_LENGTH                       0x00000001

#define _PMD3_OC2MD_POSITION                     0x00000011
#define _PMD3_OC2MD_MASK                         0x00020000
#define _PMD3_OC2MD_LENGTH                       0x00000001

#define _PMD3_OC3MD_POSITION                     0x00000012
#define _PMD3_OC3MD_MASK                         0x00040000
#define _PMD3_OC3MD_LENGTH                       0x00000001

#define _PMD3_OC4MD_POSITION                     0x00000013
#define _PMD3_OC4MD_MASK                         0x00080000
#define _PMD3_OC4MD_LENGTH                       0x00000001

#define _PMD3_OC5MD_POSITION                     0x00000014
#define _PMD3_OC5MD_MASK                         0x00100000
#define _PMD3_OC5MD_LENGTH                       0x00000001

#define _PMD3_OC6MD_POSITION                     0x00000015
#define _PMD3_OC6MD_MASK                         0x00200000
#define _PMD3_OC6MD_LENGTH                       0x00000001

#define _PMD3_OC7MD_POSITION                     0x00000016
#define _PMD3_OC7MD_MASK                         0x00400000
#define _PMD3_OC7MD_LENGTH                       0x00000001

#define _PMD3_OC8MD_POSITION                     0x00000017
#define _PMD3_OC8MD_MASK                         0x00800000
#define _PMD3_OC8MD_LENGTH                       0x00000001

#define _PMD3_OC9MD_POSITION                     0x00000018
#define _PMD3_OC9MD_MASK                         0x01000000
#define _PMD3_OC9MD_LENGTH                       0x00000001

#define _PMD4_T1MD_POSITION                      0x00000000
#define _PMD4_T1MD_MASK                          0x00000001
#define _PMD4_T1MD_LENGTH                        0x00000001

#define _PMD4_T2MD_POSITION                      0x00000001
#define _PMD4_T2MD_MASK                          0x00000002
#define _PMD4_T2MD_LENGTH                        0x00000001

#define _PMD4_T3MD_POSITION                      0x00000002
#define _PMD4_T3MD_MASK                          0x00000004
#define _PMD4_T3MD_LENGTH                        0x00000001

#define _PMD4_T4MD_POSITION                      0x00000003
#define _PMD4_T4MD_MASK                          0x00000008
#define _PMD4_T4MD_LENGTH                        0x00000001

#define _PMD4_T5MD_POSITION                      0x00000004
#define _PMD4_T5MD_MASK                          0x00000010
#define _PMD4_T5MD_LENGTH                        0x00000001

#define _PMD4_T6MD_POSITION                      0x00000005
#define _PMD4_T6MD_MASK                          0x00000020
#define _PMD4_T6MD_LENGTH                        0x00000001

#define _PMD4_T7MD_POSITION                      0x00000006
#define _PMD4_T7MD_MASK                          0x00000040
#define _PMD4_T7MD_LENGTH                        0x00000001

#define _PMD4_T8MD_POSITION                      0x00000007
#define _PMD4_T8MD_MASK                          0x00000080
#define _PMD4_T8MD_LENGTH                        0x00000001

#define _PMD4_T9MD_POSITION                      0x00000008
#define _PMD4_T9MD_MASK                          0x00000100
#define _PMD4_T9MD_LENGTH                        0x00000001

#define _PMD5_U1MD_POSITION                      0x00000000
#define _PMD5_U1MD_MASK                          0x00000001
#define _PMD5_U1MD_LENGTH                        0x00000001

#define _PMD5_U2MD_POSITION                      0x00000001
#define _PMD5_U2MD_MASK                          0x00000002
#define _PMD5_U2MD_LENGTH                        0x00000001

#define _PMD5_U3MD_POSITION                      0x00000002
#define _PMD5_U3MD_MASK                          0x00000004
#define _PMD5_U3MD_LENGTH                        0x00000001

#define _PMD5_U4MD_POSITION                      0x00000003
#define _PMD5_U4MD_MASK                          0x00000008
#define _PMD5_U4MD_LENGTH                        0x00000001

#define _PMD5_U5MD_POSITION                      0x00000004
#define _PMD5_U5MD_MASK                          0x00000010
#define _PMD5_U5MD_LENGTH                        0x00000001

#define _PMD5_U6MD_POSITION                      0x00000005
#define _PMD5_U6MD_MASK                          0x00000020
#define _PMD5_U6MD_LENGTH                        0x00000001

#define _PMD5_SPI1MD_POSITION                    0x00000008
#define _PMD5_SPI1MD_MASK                        0x00000100
#define _PMD5_SPI1MD_LENGTH                      0x00000001

#define _PMD5_SPI2MD_POSITION                    0x00000009
#define _PMD5_SPI2MD_MASK                        0x00000200
#define _PMD5_SPI2MD_LENGTH                      0x00000001

#define _PMD5_SPI3MD_POSITION                    0x0000000A
#define _PMD5_SPI3MD_MASK                        0x00000400
#define _PMD5_SPI3MD_LENGTH                      0x00000001

#define _PMD5_SPI4MD_POSITION                    0x0000000B
#define _PMD5_SPI4MD_MASK                        0x00000800
#define _PMD5_SPI4MD_LENGTH                      0x00000001

#define _PMD5_SPI5MD_POSITION                    0x0000000C
#define _PMD5_SPI5MD_MASK                        0x00001000
#define _PMD5_SPI5MD_LENGTH                      0x00000001

#define _PMD5_SPI6MD_POSITION                    0x0000000D
#define _PMD5_SPI6MD_MASK                        0x00002000
#define _PMD5_SPI6MD_LENGTH                      0x00000001

#define _PMD5_I2C1MD_POSITION                    0x00000010
#define _PMD5_I2C1MD_MASK                        0x00010000
#define _PMD5_I2C1MD_LENGTH                      0x00000001

#define _PMD5_I2C2MD_POSITION                    0x00000011
#define _PMD5_I2C2MD_MASK                        0x00020000
#define _PMD5_I2C2MD_LENGTH                      0x00000001

#define _PMD5_I2C3MD_POSITION                    0x00000012
#define _PMD5_I2C3MD_MASK                        0x00040000
#define _PMD5_I2C3MD_LENGTH                      0x00000001

#define _PMD5_I2C4MD_POSITION                    0x00000013
#define _PMD5_I2C4MD_MASK                        0x00080000
#define _PMD5_I2C4MD_LENGTH                      0x00000001

#define _PMD5_I2C5MD_POSITION                    0x00000014
#define _PMD5_I2C5MD_MASK                        0x00100000
#define _PMD5_I2C5MD_LENGTH                      0x00000001

#define _PMD5_USBMD_POSITION                     0x00000018
#define _PMD5_USBMD_MASK                         0x01000000
#define _PMD5_USBMD_LENGTH                       0x00000001

#define _PMD6_RTCCMD_POSITION                    0x00000000
#define _PMD6_RTCCMD_MASK                        0x00000001
#define _PMD6_RTCCMD_LENGTH                      0x00000001

#define _PMD6_REFO1MD_POSITION                   0x00000008
#define _PMD6_REFO1MD_MASK                       0x00000100
#define _PMD6_REFO1MD_LENGTH                     0x00000001

#define _PMD6_REFO2MD_POSITION                   0x00000009
#define _PMD6_REFO2MD_MASK                       0x00000200
#define _PMD6_REFO2MD_LENGTH                     0x00000001

#define _PMD6_REFO3MD_POSITION                   0x0000000A
#define _PMD6_REFO3MD_MASK                       0x00000400
#define _PMD6_REFO3MD_LENGTH                     0x00000001

#define _PMD6_REFO4MD_POSITION                   0x0000000B
#define _PMD6_REFO4MD_MASK                       0x00000800
#define _PMD6_REFO4MD_LENGTH                     0x00000001

#define _PMD6_PMPMD_POSITION                     0x00000010
#define _PMD6_PMPMD_MASK                         0x00010000
#define _PMD6_PMPMD_LENGTH                       0x00000001

#define _PMD6_EBIMD_POSITION                     0x00000011
#define _PMD6_EBIMD_MASK                         0x00020000
#define _PMD6_EBIMD_LENGTH                       0x00000001

#define _PMD6_SQI1MD_POSITION                    0x00000017
#define _PMD6_SQI1MD_MASK                        0x00800000
#define _PMD6_SQI1MD_LENGTH                      0x00000001

#define _PMD6_ETHMD_POSITION                     0x0000001C
#define _PMD6_ETHMD_MASK                         0x10000000
#define _PMD6_ETHMD_LENGTH                       0x00000001

#define _PMD7_DMAMD_POSITION                     0x00000004
#define _PMD7_DMAMD_MASK                         0x00000010
#define _PMD7_DMAMD_LENGTH                       0x00000001

#define _PMD7_RNGMD_POSITION                     0x00000014
#define _PMD7_RNGMD_MASK                         0x00100000
#define _PMD7_RNGMD_LENGTH                       0x00000001

#define _CFGEBIA_EBIA0EN_POSITION                0x00000000
#define _CFGEBIA_EBIA0EN_MASK                    0x00000001
#define _CFGEBIA_EBIA0EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA1EN_POSITION                0x00000001
#define _CFGEBIA_EBIA1EN_MASK                    0x00000002
#define _CFGEBIA_EBIA1EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA2EN_POSITION                0x00000002
#define _CFGEBIA_EBIA2EN_MASK                    0x00000004
#define _CFGEBIA_EBIA2EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA3EN_POSITION                0x00000003
#define _CFGEBIA_EBIA3EN_MASK                    0x00000008
#define _CFGEBIA_EBIA3EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA4EN_POSITION                0x00000004
#define _CFGEBIA_EBIA4EN_MASK                    0x00000010
#define _CFGEBIA_EBIA4EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA5EN_POSITION                0x00000005
#define _CFGEBIA_EBIA5EN_MASK                    0x00000020
#define _CFGEBIA_EBIA5EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA6EN_POSITION                0x00000006
#define _CFGEBIA_EBIA6EN_MASK                    0x00000040
#define _CFGEBIA_EBIA6EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA7EN_POSITION                0x00000007
#define _CFGEBIA_EBIA7EN_MASK                    0x00000080
#define _CFGEBIA_EBIA7EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA8EN_POSITION                0x00000008
#define _CFGEBIA_EBIA8EN_MASK                    0x00000100
#define _CFGEBIA_EBIA8EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA9EN_POSITION                0x00000009
#define _CFGEBIA_EBIA9EN_MASK                    0x00000200
#define _CFGEBIA_EBIA9EN_LENGTH                  0x00000001

#define _CFGEBIA_EBIA10EN_POSITION               0x0000000A
#define _CFGEBIA_EBIA10EN_MASK                   0x00000400
#define _CFGEBIA_EBIA10EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA11EN_POSITION               0x0000000B
#define _CFGEBIA_EBIA11EN_MASK                   0x00000800
#define _CFGEBIA_EBIA11EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA12EN_POSITION               0x0000000C
#define _CFGEBIA_EBIA12EN_MASK                   0x00001000
#define _CFGEBIA_EBIA12EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA13EN_POSITION               0x0000000D
#define _CFGEBIA_EBIA13EN_MASK                   0x00002000
#define _CFGEBIA_EBIA13EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA14EN_POSITION               0x0000000E
#define _CFGEBIA_EBIA14EN_MASK                   0x00004000
#define _CFGEBIA_EBIA14EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA15EN_POSITION               0x0000000F
#define _CFGEBIA_EBIA15EN_MASK                   0x00008000
#define _CFGEBIA_EBIA15EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA16EN_POSITION               0x00000010
#define _CFGEBIA_EBIA16EN_MASK                   0x00010000
#define _CFGEBIA_EBIA16EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA17EN_POSITION               0x00000011
#define _CFGEBIA_EBIA17EN_MASK                   0x00020000
#define _CFGEBIA_EBIA17EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA18EN_POSITION               0x00000012
#define _CFGEBIA_EBIA18EN_MASK                   0x00040000
#define _CFGEBIA_EBIA18EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA19EN_POSITION               0x00000013
#define _CFGEBIA_EBIA19EN_MASK                   0x00080000
#define _CFGEBIA_EBIA19EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA20EN_POSITION               0x00000014
#define _CFGEBIA_EBIA20EN_MASK                   0x00100000
#define _CFGEBIA_EBIA20EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA21EN_POSITION               0x00000015
#define _CFGEBIA_EBIA21EN_MASK                   0x00200000
#define _CFGEBIA_EBIA21EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA22EN_POSITION               0x00000016
#define _CFGEBIA_EBIA22EN_MASK                   0x00400000
#define _CFGEBIA_EBIA22EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIA23EN_POSITION               0x00000017
#define _CFGEBIA_EBIA23EN_MASK                   0x00800000
#define _CFGEBIA_EBIA23EN_LENGTH                 0x00000001

#define _CFGEBIA_EBIPINEN_POSITION               0x0000001F
#define _CFGEBIA_EBIPINEN_MASK                   0x80000000
#define _CFGEBIA_EBIPINEN_LENGTH                 0x00000001

#define _CFGEBIC_EBIDEN0_POSITION                0x00000000
#define _CFGEBIC_EBIDEN0_MASK                    0x00000001
#define _CFGEBIC_EBIDEN0_LENGTH                  0x00000001

#define _CFGEBIC_EBIDEN1_POSITION                0x00000001
#define _CFGEBIC_EBIDEN1_MASK                    0x00000002
#define _CFGEBIC_EBIDEN1_LENGTH                  0x00000001

#define _CFGEBIC_EBICSEN0_POSITION               0x00000004
#define _CFGEBIC_EBICSEN0_MASK                   0x00000010
#define _CFGEBIC_EBICSEN0_LENGTH                 0x00000001

#define _CFGEBIC_EBICSEN1_POSITION               0x00000005
#define _CFGEBIC_EBICSEN1_MASK                   0x00000020
#define _CFGEBIC_EBICSEN1_LENGTH                 0x00000001

#define _CFGEBIC_EBICSEN2_POSITION               0x00000006
#define _CFGEBIC_EBICSEN2_MASK                   0x00000040
#define _CFGEBIC_EBICSEN2_LENGTH                 0x00000001

#define _CFGEBIC_EBICSEN3_POSITION               0x00000007
#define _CFGEBIC_EBICSEN3_MASK                   0x00000080
#define _CFGEBIC_EBICSEN3_LENGTH                 0x00000001

#define _CFGEBIC_EBIBSEN0_POSITION               0x00000008
#define _CFGEBIC_EBIBSEN0_MASK                   0x00000100
#define _CFGEBIC_EBIBSEN0_LENGTH                 0x00000001

#define _CFGEBIC_EBIBSEN1_POSITION               0x00000009
#define _CFGEBIC_EBIBSEN1_MASK                   0x00000200
#define _CFGEBIC_EBIBSEN1_LENGTH                 0x00000001

#define _CFGEBIC_EBIOEEN_POSITION                0x0000000C
#define _CFGEBIC_EBIOEEN_MASK                    0x00001000
#define _CFGEBIC_EBIOEEN_LENGTH                  0x00000001

#define _CFGEBIC_EBIWEEN_POSITION                0x0000000D
#define _CFGEBIC_EBIWEEN_MASK                    0x00002000
#define _CFGEBIC_EBIWEEN_LENGTH                  0x00000001

#define _CFGEBIC_EBIRPEN_POSITION                0x00000010
#define _CFGEBIC_EBIRPEN_MASK                    0x00010000
#define _CFGEBIC_EBIRPEN_LENGTH                  0x00000001

#define _CFGEBIC_EBIRDYLVL_POSITION              0x00000011
#define _CFGEBIC_EBIRDYLVL_MASK                  0x00020000
#define _CFGEBIC_EBIRDYLVL_LENGTH                0x00000001

#define _CFGEBIC_EBIRDYEN1_POSITION              0x00000019
#define _CFGEBIC_EBIRDYEN1_MASK                  0x02000000
#define _CFGEBIC_EBIRDYEN1_LENGTH                0x00000001

#define _CFGEBIC_EBIRDYEN2_POSITION              0x0000001A
#define _CFGEBIC_EBIRDYEN2_MASK                  0x04000000
#define _CFGEBIC_EBIRDYEN2_LENGTH                0x00000001

#define _CFGEBIC_EBIRDYEN3_POSITION              0x0000001B
#define _CFGEBIC_EBIRDYEN3_MASK                  0x08000000
#define _CFGEBIC_EBIRDYEN3_LENGTH                0x00000001

#define _CFGEBIC_EBIRDYINV1_POSITION             0x0000001D
#define _CFGEBIC_EBIRDYINV1_MASK                 0x20000000
#define _CFGEBIC_EBIRDYINV1_LENGTH               0x00000001

#define _CFGEBIC_EBIRDYINV2_POSITION             0x0000001E
#define _CFGEBIC_EBIRDYINV2_MASK                 0x40000000
#define _CFGEBIC_EBIRDYINV2_LENGTH               0x00000001

#define _CFGEBIC_EBIRDYINV3_POSITION             0x0000001F
#define _CFGEBIC_EBIRDYINV3_MASK                 0x80000000
#define _CFGEBIC_EBIRDYINV3_LENGTH               0x00000001

#define _CFGPG_CPUPG_POSITION                    0x00000000
#define _CFGPG_CPUPG_MASK                        0x00000003
#define _CFGPG_CPUPG_LENGTH                      0x00000002

#define _CFGPG_DMAPG_POSITION                    0x00000004
#define _CFGPG_DMAPG_MASK                        0x00000030
#define _CFGPG_DMAPG_LENGTH                      0x00000002

#define _CFGPG_USBPG_POSITION                    0x00000008
#define _CFGPG_USBPG_MASK                        0x00000300
#define _CFGPG_USBPG_LENGTH                      0x00000002

#define _CFGPG_ETHPG_POSITION                    0x00000010
#define _CFGPG_ETHPG_MASK                        0x00030000
#define _CFGPG_ETHPG_LENGTH                      0x00000002

#define _CFGPG_SQI1PG_POSITION                   0x00000014
#define _CFGPG_SQI1PG_MASK                       0x00300000
#define _CFGPG_SQI1PG_LENGTH                     0x00000002

#define _CFGPG_FCPG_POSITION                     0x00000016
#define _CFGPG_FCPG_MASK                         0x00C00000
#define _CFGPG_FCPG_LENGTH                       0x00000002

#define _CFGPG_ICD1PG_POSITION                   0x0000001E
#define _CFGPG_ICD1PG_MASK                       0xC0000000
#define _CFGPG_ICD1PG_LENGTH                     0x00000002

#define _NVMCON_NVMOP_POSITION                   0x00000000
#define _NVMCON_NVMOP_MASK                       0x0000000F
#define _NVMCON_NVMOP_LENGTH                     0x00000004

#define _NVMCON_BFSWAP_POSITION                  0x00000006
#define _NVMCON_BFSWAP_MASK                      0x00000040
#define _NVMCON_BFSWAP_LENGTH                    0x00000001

#define _NVMCON_PFSWAP_POSITION                  0x00000007
#define _NVMCON_PFSWAP_MASK                      0x00000080
#define _NVMCON_PFSWAP_LENGTH                    0x00000001

#define _NVMCON_LVDERR_POSITION                  0x0000000C
#define _NVMCON_LVDERR_MASK                      0x00001000
#define _NVMCON_LVDERR_LENGTH                    0x00000001

#define _NVMCON_WRERR_POSITION                   0x0000000D
#define _NVMCON_WRERR_MASK                       0x00002000
#define _NVMCON_WRERR_LENGTH                     0x00000001

#define _NVMCON_WREN_POSITION                    0x0000000E
#define _NVMCON_WREN_MASK                        0x00004000
#define _NVMCON_WREN_LENGTH                      0x00000001

#define _NVMCON_WR_POSITION                      0x0000000F
#define _NVMCON_WR_MASK                          0x00008000
#define _NVMCON_WR_LENGTH                        0x00000001

#define _NVMCON_NVMOP0_POSITION                  0x00000000
#define _NVMCON_NVMOP0_MASK                      0x00000001
#define _NVMCON_NVMOP0_LENGTH                    0x00000001

#define _NVMCON_NVMOP1_POSITION                  0x00000001
#define _NVMCON_NVMOP1_MASK                      0x00000002
#define _NVMCON_NVMOP1_LENGTH                    0x00000001

#define _NVMCON_NVMOP2_POSITION                  0x00000002
#define _NVMCON_NVMOP2_MASK                      0x00000004
#define _NVMCON_NVMOP2_LENGTH                    0x00000001

#define _NVMCON_NVMOP3_POSITION                  0x00000003
#define _NVMCON_NVMOP3_MASK                      0x00000008
#define _NVMCON_NVMOP3_LENGTH                    0x00000001

#define _NVMCON_SWAP_POSITION                    0x00000007
#define _NVMCON_SWAP_MASK                        0x00000080
#define _NVMCON_SWAP_LENGTH                      0x00000001

#define _NVMCON_PROGOP_POSITION                  0x00000000
#define _NVMCON_PROGOP_MASK                      0x0000000F
#define _NVMCON_PROGOP_LENGTH                    0x00000004

#define _NVMCON_PROGOP0_POSITION                 0x00000000
#define _NVMCON_PROGOP0_MASK                     0x00000001
#define _NVMCON_PROGOP0_LENGTH                   0x00000001

#define _NVMCON_PROGOP1_POSITION                 0x00000001
#define _NVMCON_PROGOP1_MASK                     0x00000002
#define _NVMCON_PROGOP1_LENGTH                   0x00000001

#define _NVMCON_PROGOP2_POSITION                 0x00000002
#define _NVMCON_PROGOP2_MASK                     0x00000004
#define _NVMCON_PROGOP2_LENGTH                   0x00000001

#define _NVMCON_PROGOP3_POSITION                 0x00000003
#define _NVMCON_PROGOP3_MASK                     0x00000008
#define _NVMCON_PROGOP3_LENGTH                   0x00000001

#define _NVMCON_w_POSITION                       0x00000000
#define _NVMCON_w_MASK                           0xFFFFFFFF
#define _NVMCON_w_LENGTH                         0x00000020

#define _NVMPWP_PWP_POSITION                     0x00000000
#define _NVMPWP_PWP_MASK                         0x00FFFFFF
#define _NVMPWP_PWP_LENGTH                       0x00000018

#define _NVMPWP_PWPULOCK_POSITION                0x0000001F
#define _NVMPWP_PWPULOCK_MASK                    0x80000000
#define _NVMPWP_PWPULOCK_LENGTH                  0x00000001

#define _NVMBWP_UBWP0_POSITION                   0x00000000
#define _NVMBWP_UBWP0_MASK                       0x00000001
#define _NVMBWP_UBWP0_LENGTH                     0x00000001

#define _NVMBWP_UBWP1_POSITION                   0x00000001
#define _NVMBWP_UBWP1_MASK                       0x00000002
#define _NVMBWP_UBWP1_LENGTH                     0x00000001

#define _NVMBWP_UBWP2_POSITION                   0x00000002
#define _NVMBWP_UBWP2_MASK                       0x00000004
#define _NVMBWP_UBWP2_LENGTH                     0x00000001

#define _NVMBWP_UBWP3_POSITION                   0x00000003
#define _NVMBWP_UBWP3_MASK                       0x00000008
#define _NVMBWP_UBWP3_LENGTH                     0x00000001

#define _NVMBWP_UBWP4_POSITION                   0x00000004
#define _NVMBWP_UBWP4_MASK                       0x00000010
#define _NVMBWP_UBWP4_LENGTH                     0x00000001

#define _NVMBWP_UBWPULOCK_POSITION               0x00000007
#define _NVMBWP_UBWPULOCK_MASK                   0x00000080
#define _NVMBWP_UBWPULOCK_LENGTH                 0x00000001

#define _NVMBWP_LBWP0_POSITION                   0x00000008
#define _NVMBWP_LBWP0_MASK                       0x00000100
#define _NVMBWP_LBWP0_LENGTH                     0x00000001

#define _NVMBWP_LBWP1_POSITION                   0x00000009
#define _NVMBWP_LBWP1_MASK                       0x00000200
#define _NVMBWP_LBWP1_LENGTH                     0x00000001

#define _NVMBWP_LBWP2_POSITION                   0x0000000A
#define _NVMBWP_LBWP2_MASK                       0x00000400
#define _NVMBWP_LBWP2_LENGTH                     0x00000001

#define _NVMBWP_LBWP3_POSITION                   0x0000000B
#define _NVMBWP_LBWP3_MASK                       0x00000800
#define _NVMBWP_LBWP3_LENGTH                     0x00000001

#define _NVMBWP_LBWP4_POSITION                   0x0000000C
#define _NVMBWP_LBWP4_MASK                       0x00001000
#define _NVMBWP_LBWP4_LENGTH                     0x00000001

#define _NVMBWP_LBWPULOCK_POSITION               0x0000000F
#define _NVMBWP_LBWPULOCK_MASK                   0x00008000
#define _NVMBWP_LBWPULOCK_LENGTH                 0x00000001

#define _NVMCON2_SWAPLOCK_POSITION               0x00000006
#define _NVMCON2_SWAPLOCK_MASK                   0x000000C0
#define _NVMCON2_SWAPLOCK_LENGTH                 0x00000002

#define _NVMCON2_ERETRY_POSITION                 0x00000008
#define _NVMCON2_ERETRY_MASK                     0x00000300
#define _NVMCON2_ERETRY_LENGTH                   0x00000002

#define _NVMCON2_VREAD1_POSITION                 0x0000000C
#define _NVMCON2_VREAD1_MASK                     0x00001000
#define _NVMCON2_VREAD1_LENGTH                   0x00000001

#define _NVMCON2_CREAD1_POSITION                 0x0000000D
#define _NVMCON2_CREAD1_MASK                     0x00002000
#define _NVMCON2_CREAD1_LENGTH                   0x00000001

#define _NVMCON2_LPRD_POSITION                   0x0000000F
#define _NVMCON2_LPRD_MASK                       0x00008000
#define _NVMCON2_LPRD_LENGTH                     0x00000001

#define _NVMCON2_LPRDWS_POSITION                 0x00000010
#define _NVMCON2_LPRDWS_MASK                     0x001F0000
#define _NVMCON2_LPRDWS_LENGTH                   0x00000005

#define _NVMCON2_ERSCNT_POSITION                 0x0000001C
#define _NVMCON2_ERSCNT_MASK                     0xF0000000
#define _NVMCON2_ERSCNT_LENGTH                   0x00000004

#define _WDTCON_WDTWINEN_POSITION                0x00000000
#define _WDTCON_WDTWINEN_MASK                    0x00000001
#define _WDTCON_WDTWINEN_LENGTH                  0x00000001

#define _WDTCON_RUNDIV_POSITION                  0x00000008
#define _WDTCON_RUNDIV_MASK                      0x00001F00
#define _WDTCON_RUNDIV_LENGTH                    0x00000005

#define _WDTCON_ON_POSITION                      0x0000000F
#define _WDTCON_ON_MASK                          0x00008000
#define _WDTCON_ON_LENGTH                        0x00000001

#define _WDTCON_WDTCLRKEY_POSITION               0x00000010
#define _WDTCON_WDTCLRKEY_MASK                   0xFFFF0000
#define _WDTCON_WDTCLRKEY_LENGTH                 0x00000010

#define _DMTCON_ON_POSITION                      0x0000000F
#define _DMTCON_ON_MASK                          0x00008000
#define _DMTCON_ON_LENGTH                        0x00000001

#define _DMTPRECLR_STEP1_POSITION                0x00000008
#define _DMTPRECLR_STEP1_MASK                    0x0000FF00
#define _DMTPRECLR_STEP1_LENGTH                  0x00000008

#define _DMTCLR_STEP2_POSITION                   0x00000000
#define _DMTCLR_STEP2_MASK                       0x000000FF
#define _DMTCLR_STEP2_LENGTH                     0x00000008

#define _DMTSTAT_WINOPN_POSITION                 0x00000000
#define _DMTSTAT_WINOPN_MASK                     0x00000001
#define _DMTSTAT_WINOPN_LENGTH                   0x00000001

#define _DMTSTAT_DMTEVENT_POSITION               0x00000005
#define _DMTSTAT_DMTEVENT_MASK                   0x00000020
#define _DMTSTAT_DMTEVENT_LENGTH                 0x00000001

#define _DMTSTAT_BAD_POSITION                    0x00000006
#define _DMTSTAT_BAD_MASK                        0x000000C0
#define _DMTSTAT_BAD_LENGTH                      0x00000002

#define _DMTSTAT_BAD2_POSITION                   0x00000006
#define _DMTSTAT_BAD2_MASK                       0x00000040
#define _DMTSTAT_BAD2_LENGTH                     0x00000001

#define _DMTSTAT_BAD1_POSITION                   0x00000007
#define _DMTSTAT_BAD1_MASK                       0x00000080
#define _DMTSTAT_BAD1_LENGTH                     0x00000001

#define _DMTSTAT_w_POSITION                      0x00000000
#define _DMTSTAT_w_MASK                          0xFFFFFFFF
#define _DMTSTAT_w_LENGTH                        0x00000020

#define _DMTCNT_COUNTER_POSITION                 0x00000000
#define _DMTCNT_COUNTER_MASK                     0xFFFFFFFF
#define _DMTCNT_COUNTER_LENGTH                   0x00000020

#define _DMTPSCNT_PSCNT_POSITION                 0x00000000
#define _DMTPSCNT_PSCNT_MASK                     0xFFFFFFFF
#define _DMTPSCNT_PSCNT_LENGTH                   0x00000020

#define _DMTPSINTV_PSINTV_POSITION               0x00000000
#define _DMTPSINTV_PSINTV_MASK                   0xFFFFFFFF
#define _DMTPSINTV_PSINTV_LENGTH                 0x00000020

#define _RTCCON_RTCOE_POSITION                   0x00000000
#define _RTCCON_RTCOE_MASK                       0x00000001
#define _RTCCON_RTCOE_LENGTH                     0x00000001

#define _RTCCON_HALFSEC_POSITION                 0x00000001
#define _RTCCON_HALFSEC_MASK                     0x00000002
#define _RTCCON_HALFSEC_LENGTH                   0x00000001

#define _RTCCON_RTCSYNC_POSITION                 0x00000002
#define _RTCCON_RTCSYNC_MASK                     0x00000004
#define _RTCCON_RTCSYNC_LENGTH                   0x00000001

#define _RTCCON_RTCWREN_POSITION                 0x00000003
#define _RTCCON_RTCWREN_MASK                     0x00000008
#define _RTCCON_RTCWREN_LENGTH                   0x00000001

#define _RTCCON_RTCCLKON_POSITION                0x00000006
#define _RTCCON_RTCCLKON_MASK                    0x00000040
#define _RTCCON_RTCCLKON_LENGTH                  0x00000001

#define _RTCCON_RTCOUTSEL_POSITION               0x00000007
#define _RTCCON_RTCOUTSEL_MASK                   0x00000180
#define _RTCCON_RTCOUTSEL_LENGTH                 0x00000002

#define _RTCCON_RTCCLKSEL_POSITION               0x00000009
#define _RTCCON_RTCCLKSEL_MASK                   0x00000600
#define _RTCCON_RTCCLKSEL_LENGTH                 0x00000002

#define _RTCCON_SIDL_POSITION                    0x0000000D
#define _RTCCON_SIDL_MASK                        0x00002000
#define _RTCCON_SIDL_LENGTH                      0x00000001

#define _RTCCON_ON_POSITION                      0x0000000F
#define _RTCCON_ON_MASK                          0x00008000
#define _RTCCON_ON_LENGTH                        0x00000001

#define _RTCCON_CAL_POSITION                     0x00000010
#define _RTCCON_CAL_MASK                         0x03FF0000
#define _RTCCON_CAL_LENGTH                       0x0000000A

#define _RTCCON_w_POSITION                       0x00000000
#define _RTCCON_w_MASK                           0xFFFFFFFF
#define _RTCCON_w_LENGTH                         0x00000020

#define _RTCALRM_ARPT_POSITION                   0x00000000
#define _RTCALRM_ARPT_MASK                       0x000000FF
#define _RTCALRM_ARPT_LENGTH                     0x00000008

#define _RTCALRM_AMASK_POSITION                  0x00000008
#define _RTCALRM_AMASK_MASK                      0x00000F00
#define _RTCALRM_AMASK_LENGTH                    0x00000004

#define _RTCALRM_ALRMSYNC_POSITION               0x0000000C
#define _RTCALRM_ALRMSYNC_MASK                   0x00001000
#define _RTCALRM_ALRMSYNC_LENGTH                 0x00000001

#define _RTCALRM_PIV_POSITION                    0x0000000D
#define _RTCALRM_PIV_MASK                        0x00002000
#define _RTCALRM_PIV_LENGTH                      0x00000001

#define _RTCALRM_CHIME_POSITION                  0x0000000E
#define _RTCALRM_CHIME_MASK                      0x00004000
#define _RTCALRM_CHIME_LENGTH                    0x00000001

#define _RTCALRM_ALRMEN_POSITION                 0x0000000F
#define _RTCALRM_ALRMEN_MASK                     0x00008000
#define _RTCALRM_ALRMEN_LENGTH                   0x00000001

#define _RTCALRM_w_POSITION                      0x00000000
#define _RTCALRM_w_MASK                          0xFFFFFFFF
#define _RTCALRM_w_LENGTH                        0x00000020

#define _RTCTIME_SEC01_POSITION                  0x00000008
#define _RTCTIME_SEC01_MASK                      0x00000F00
#define _RTCTIME_SEC01_LENGTH                    0x00000004

#define _RTCTIME_SEC10_POSITION                  0x0000000C
#define _RTCTIME_SEC10_MASK                      0x0000F000
#define _RTCTIME_SEC10_LENGTH                    0x00000004

#define _RTCTIME_MIN01_POSITION                  0x00000010
#define _RTCTIME_MIN01_MASK                      0x000F0000
#define _RTCTIME_MIN01_LENGTH                    0x00000004

#define _RTCTIME_MIN10_POSITION                  0x00000014
#define _RTCTIME_MIN10_MASK                      0x00F00000
#define _RTCTIME_MIN10_LENGTH                    0x00000004

#define _RTCTIME_HR01_POSITION                   0x00000018
#define _RTCTIME_HR01_MASK                       0x0F000000
#define _RTCTIME_HR01_LENGTH                     0x00000004

#define _RTCTIME_HR10_POSITION                   0x0000001C
#define _RTCTIME_HR10_MASK                       0xF0000000
#define _RTCTIME_HR10_LENGTH                     0x00000004

#define _RTCTIME_w_POSITION                      0x00000000
#define _RTCTIME_w_MASK                          0xFFFFFFFF
#define _RTCTIME_w_LENGTH                        0x00000020

#define _RTCDATE_WDAY01_POSITION                 0x00000000
#define _RTCDATE_WDAY01_MASK                     0x0000000F
#define _RTCDATE_WDAY01_LENGTH                   0x00000004

#define _RTCDATE_DAY01_POSITION                  0x00000008
#define _RTCDATE_DAY01_MASK                      0x00000F00
#define _RTCDATE_DAY01_LENGTH                    0x00000004

#define _RTCDATE_DAY10_POSITION                  0x0000000C
#define _RTCDATE_DAY10_MASK                      0x0000F000
#define _RTCDATE_DAY10_LENGTH                    0x00000004

#define _RTCDATE_MONTH01_POSITION                0x00000010
#define _RTCDATE_MONTH01_MASK                    0x000F0000
#define _RTCDATE_MONTH01_LENGTH                  0x00000004

#define _RTCDATE_MONTH10_POSITION                0x00000014
#define _RTCDATE_MONTH10_MASK                    0x00F00000
#define _RTCDATE_MONTH10_LENGTH                  0x00000004

#define _RTCDATE_YEAR01_POSITION                 0x00000018
#define _RTCDATE_YEAR01_MASK                     0x0F000000
#define _RTCDATE_YEAR01_LENGTH                   0x00000004

#define _RTCDATE_YEAR10_POSITION                 0x0000001C
#define _RTCDATE_YEAR10_MASK                     0xF0000000
#define _RTCDATE_YEAR10_LENGTH                   0x00000004

#define _RTCDATE_w_POSITION                      0x00000000
#define _RTCDATE_w_MASK                          0xFFFFFFFF
#define _RTCDATE_w_LENGTH                        0x00000020

#define _ALRMTIME_SEC01_POSITION                 0x00000008
#define _ALRMTIME_SEC01_MASK                     0x00000F00
#define _ALRMTIME_SEC01_LENGTH                   0x00000004

#define _ALRMTIME_SEC10_POSITION                 0x0000000C
#define _ALRMTIME_SEC10_MASK                     0x0000F000
#define _ALRMTIME_SEC10_LENGTH                   0x00000004

#define _ALRMTIME_MIN01_POSITION                 0x00000010
#define _ALRMTIME_MIN01_MASK                     0x000F0000
#define _ALRMTIME_MIN01_LENGTH                   0x00000004

#define _ALRMTIME_MIN10_POSITION                 0x00000014
#define _ALRMTIME_MIN10_MASK                     0x00F00000
#define _ALRMTIME_MIN10_LENGTH                   0x00000004

#define _ALRMTIME_HR01_POSITION                  0x00000018
#define _ALRMTIME_HR01_MASK                      0x0F000000
#define _ALRMTIME_HR01_LENGTH                    0x00000004

#define _ALRMTIME_HR10_POSITION                  0x0000001C
#define _ALRMTIME_HR10_MASK                      0xF0000000
#define _ALRMTIME_HR10_LENGTH                    0x00000004

#define _ALRMTIME_w_POSITION                     0x00000000
#define _ALRMTIME_w_MASK                         0xFFFFFFFF
#define _ALRMTIME_w_LENGTH                       0x00000020

#define _ALRMDATE_WDAY01_POSITION                0x00000000
#define _ALRMDATE_WDAY01_MASK                    0x0000000F
#define _ALRMDATE_WDAY01_LENGTH                  0x00000004

#define _ALRMDATE_DAY01_POSITION                 0x00000008
#define _ALRMDATE_DAY01_MASK                     0x00000F00
#define _ALRMDATE_DAY01_LENGTH                   0x00000004

#define _ALRMDATE_DAY10_POSITION                 0x0000000C
#define _ALRMDATE_DAY10_MASK                     0x0000F000
#define _ALRMDATE_DAY10_LENGTH                   0x00000004

#define _ALRMDATE_MONTH01_POSITION               0x00000010
#define _ALRMDATE_MONTH01_MASK                   0x000F0000
#define _ALRMDATE_MONTH01_LENGTH                 0x00000004

#define _ALRMDATE_MONTH10_POSITION               0x00000014
#define _ALRMDATE_MONTH10_MASK                   0x00F00000
#define _ALRMDATE_MONTH10_LENGTH                 0x00000004

#define _ALRMDATE_w_POSITION                     0x00000000
#define _ALRMDATE_w_MASK                         0xFFFFFFFF
#define _ALRMDATE_w_LENGTH                       0x00000020

#define _CVRCON_CVR_POSITION                     0x00000000
#define _CVRCON_CVR_MASK                         0x0000000F
#define _CVRCON_CVR_LENGTH                       0x00000004

#define _CVRCON_CVRSS_POSITION                   0x00000004
#define _CVRCON_CVRSS_MASK                       0x00000010
#define _CVRCON_CVRSS_LENGTH                     0x00000001

#define _CVRCON_CVRR_POSITION                    0x00000005
#define _CVRCON_CVRR_MASK                        0x00000020
#define _CVRCON_CVRR_LENGTH                      0x00000001

#define _CVRCON_CVROE_POSITION                   0x00000006
#define _CVRCON_CVROE_MASK                       0x00000040
#define _CVRCON_CVROE_LENGTH                     0x00000001

#define _CVRCON_ON_POSITION                      0x0000000F
#define _CVRCON_ON_MASK                          0x00008000
#define _CVRCON_ON_LENGTH                        0x00000001

#define _CVRCON_CVR0_POSITION                    0x00000000
#define _CVRCON_CVR0_MASK                        0x00000001
#define _CVRCON_CVR0_LENGTH                      0x00000001

#define _CVRCON_CVR1_POSITION                    0x00000001
#define _CVRCON_CVR1_MASK                        0x00000002
#define _CVRCON_CVR1_LENGTH                      0x00000001

#define _CVRCON_CVR2_POSITION                    0x00000002
#define _CVRCON_CVR2_MASK                        0x00000004
#define _CVRCON_CVR2_LENGTH                      0x00000001

#define _CVRCON_CVR3_POSITION                    0x00000003
#define _CVRCON_CVR3_MASK                        0x00000008
#define _CVRCON_CVR3_LENGTH                      0x00000001

#define _CVRCON_w_POSITION                       0x00000000
#define _CVRCON_w_MASK                           0xFFFFFFFF
#define _CVRCON_w_LENGTH                         0x00000020

#define __ICDCON_CKSWBKEN_POSITION               0x00000000
#define __ICDCON_CKSWBKEN_MASK                   0x00000001
#define __ICDCON_CKSWBKEN_LENGTH                 0x00000001

#define __ICDCON_SLPBKEN_POSITION                0x00000001
#define __ICDCON_SLPBKEN_MASK                    0x00000002
#define __ICDCON_SLPBKEN_LENGTH                  0x00000001

#define __ICDCON_WDTBKEN_POSITION                0x00000002
#define __ICDCON_WDTBKEN_MASK                    0x00000004
#define __ICDCON_WDTBKEN_LENGTH                  0x00000001

#define __ICDCON_WDTEN_POSITION                  0x00000003
#define __ICDCON_WDTEN_MASK                      0x00000008
#define __ICDCON_WDTEN_LENGTH                    0x00000001

#define __ICDCON_RSTBUG_POSITION                 0x00000004
#define __ICDCON_RSTBUG_MASK                     0x00000010
#define __ICDCON_RSTBUG_LENGTH                   0x00000001

#define __ICDCON_DMTBKEN_POSITION                0x00000005
#define __ICDCON_DMTBKEN_MASK                    0x00000020
#define __ICDCON_DMTBKEN_LENGTH                  0x00000001

#define __ICDCON_DMTEN_POSITION                  0x00000006
#define __ICDCON_DMTEN_MASK                      0x00000040
#define __ICDCON_DMTEN_LENGTH                    0x00000001

#define __ICDCON_FRZ_POSITION                    0x0000000E
#define __ICDCON_FRZ_MASK                        0x00004000
#define __ICDCON_FRZ_LENGTH                      0x00000001

#define __ICDSTAT_CKSWBF_POSITION                0x00000000
#define __ICDSTAT_CKSWBF_MASK                    0x00000001
#define __ICDSTAT_CKSWBF_LENGTH                  0x00000001

#define __ICDSTAT_SLPBF_POSITION                 0x00000001
#define __ICDSTAT_SLPBF_MASK                     0x00000002
#define __ICDSTAT_SLPBF_LENGTH                   0x00000001

#define __ICDSTAT_WDTBF_POSITION                 0x00000002
#define __ICDSTAT_WDTBF_MASK                     0x00000004
#define __ICDSTAT_WDTBF_LENGTH                   0x00000001

#define __ICDSTAT_DMTBF_POSITION                 0x00000003
#define __ICDSTAT_DMTBF_MASK                     0x00000008
#define __ICDSTAT_DMTBF_LENGTH                   0x00000001

#define _OSCCON_OSWEN_POSITION                   0x00000000
#define _OSCCON_OSWEN_MASK                       0x00000001
#define _OSCCON_OSWEN_LENGTH                     0x00000001

#define _OSCCON_SOSCEN_POSITION                  0x00000001
#define _OSCCON_SOSCEN_MASK                      0x00000002
#define _OSCCON_SOSCEN_LENGTH                    0x00000001

#define _OSCCON_CF_POSITION                      0x00000003
#define _OSCCON_CF_MASK                          0x00000008
#define _OSCCON_CF_LENGTH                        0x00000001

#define _OSCCON_SLPEN_POSITION                   0x00000004
#define _OSCCON_SLPEN_MASK                       0x00000010
#define _OSCCON_SLPEN_LENGTH                     0x00000001

#define _OSCCON_CLKLOCK_POSITION                 0x00000007
#define _OSCCON_CLKLOCK_MASK                     0x00000080
#define _OSCCON_CLKLOCK_LENGTH                   0x00000001

#define _OSCCON_NOSC_POSITION                    0x00000008
#define _OSCCON_NOSC_MASK                        0x00000700
#define _OSCCON_NOSC_LENGTH                      0x00000003

#define _OSCCON_COSC_POSITION                    0x0000000C
#define _OSCCON_COSC_MASK                        0x00007000
#define _OSCCON_COSC_LENGTH                      0x00000003

#define _OSCCON_SLP2SPD_POSITION                 0x00000015
#define _OSCCON_SLP2SPD_MASK                     0x00200000
#define _OSCCON_SLP2SPD_LENGTH                   0x00000001

#define _OSCCON_DRMEN_POSITION                   0x00000017
#define _OSCCON_DRMEN_MASK                       0x00800000
#define _OSCCON_DRMEN_LENGTH                     0x00000001

#define _OSCCON_FRCDIV_POSITION                  0x00000018
#define _OSCCON_FRCDIV_MASK                      0x07000000
#define _OSCCON_FRCDIV_LENGTH                    0x00000003

#define _OSCTUN_TUN_POSITION                     0x00000000
#define _OSCTUN_TUN_MASK                         0x0000003F
#define _OSCTUN_TUN_LENGTH                       0x00000006

#define _SPLLCON_PLLRANGE_POSITION               0x00000000
#define _SPLLCON_PLLRANGE_MASK                   0x00000007
#define _SPLLCON_PLLRANGE_LENGTH                 0x00000003

#define _SPLLCON_PLLICLK_POSITION                0x00000007
#define _SPLLCON_PLLICLK_MASK                    0x00000080
#define _SPLLCON_PLLICLK_LENGTH                  0x00000001

#define _SPLLCON_PLLIDIV_POSITION                0x00000008
#define _SPLLCON_PLLIDIV_MASK                    0x00000700
#define _SPLLCON_PLLIDIV_LENGTH                  0x00000003

#define _SPLLCON_PLLMULT_POSITION                0x00000010
#define _SPLLCON_PLLMULT_MASK                    0x007F0000
#define _SPLLCON_PLLMULT_LENGTH                  0x00000007

#define _SPLLCON_PLLODIV_POSITION                0x00000018
#define _SPLLCON_PLLODIV_MASK                    0x07000000
#define _SPLLCON_PLLODIV_LENGTH                  0x00000003

#define _RCON_POR_POSITION                       0x00000000
#define _RCON_POR_MASK                           0x00000001
#define _RCON_POR_LENGTH                         0x00000001

#define _RCON_BOR_POSITION                       0x00000001
#define _RCON_BOR_MASK                           0x00000002
#define _RCON_BOR_LENGTH                         0x00000001

#define _RCON_IDLE_POSITION                      0x00000002
#define _RCON_IDLE_MASK                          0x00000004
#define _RCON_IDLE_LENGTH                        0x00000001

#define _RCON_SLEEP_POSITION                     0x00000003
#define _RCON_SLEEP_MASK                         0x00000008
#define _RCON_SLEEP_LENGTH                       0x00000001

#define _RCON_WDTO_POSITION                      0x00000004
#define _RCON_WDTO_MASK                          0x00000010
#define _RCON_WDTO_LENGTH                        0x00000001

#define _RCON_DMTO_POSITION                      0x00000005
#define _RCON_DMTO_MASK                          0x00000020
#define _RCON_DMTO_LENGTH                        0x00000001

#define _RCON_SWR_POSITION                       0x00000006
#define _RCON_SWR_MASK                           0x00000040
#define _RCON_SWR_LENGTH                         0x00000001

#define _RCON_EXTR_POSITION                      0x00000007
#define _RCON_EXTR_MASK                          0x00000080
#define _RCON_EXTR_LENGTH                        0x00000001

#define _RCON_CMR_POSITION                       0x00000009
#define _RCON_CMR_MASK                           0x00000200
#define _RCON_CMR_LENGTH                         0x00000001

#define _RCON_BCFGFAIL_POSITION                  0x0000001A
#define _RCON_BCFGFAIL_MASK                      0x04000000
#define _RCON_BCFGFAIL_LENGTH                    0x00000001

#define _RCON_BCFGERR_POSITION                   0x0000001B
#define _RCON_BCFGERR_MASK                       0x08000000
#define _RCON_BCFGERR_LENGTH                     0x00000001

#define _RSWRST_SWRST_POSITION                   0x00000000
#define _RSWRST_SWRST_MASK                       0x00000001
#define _RSWRST_SWRST_LENGTH                     0x00000001

#define _RNMICON_NMICNT_POSITION                 0x00000000
#define _RNMICON_NMICNT_MASK                     0x0000FFFF
#define _RNMICON_NMICNT_LENGTH                   0x00000010

#define _RNMICON_WDTS_POSITION                   0x00000010
#define _RNMICON_WDTS_MASK                       0x00010000
#define _RNMICON_WDTS_LENGTH                     0x00000001

#define _RNMICON_CF_POSITION                     0x00000011
#define _RNMICON_CF_MASK                         0x00020000
#define _RNMICON_CF_LENGTH                       0x00000001

#define _RNMICON_GNMI_POSITION                   0x00000013
#define _RNMICON_GNMI_MASK                       0x00080000
#define _RNMICON_GNMI_LENGTH                     0x00000001

#define _RNMICON_SWNMI_POSITION                  0x00000017
#define _RNMICON_SWNMI_MASK                      0x00800000
#define _RNMICON_SWNMI_LENGTH                    0x00000001

#define _RNMICON_WDTO_POSITION                   0x00000018
#define _RNMICON_WDTO_MASK                       0x01000000
#define _RNMICON_WDTO_LENGTH                     0x00000001

#define _RNMICON_DMTO_POSITION                   0x00000019
#define _RNMICON_DMTO_MASK                       0x02000000
#define _RNMICON_DMTO_LENGTH                     0x00000001

#define _RNMICON_WDTR_POSITION                   0x00000018
#define _RNMICON_WDTR_MASK                       0x01000000
#define _RNMICON_WDTR_LENGTH                     0x00000001

#define _PWRCON_VREGS_POSITION                   0x00000000
#define _PWRCON_VREGS_MASK                       0x00000001
#define _PWRCON_VREGS_LENGTH                     0x00000001

#define _REFO1CON_ROSEL_POSITION                 0x00000000
#define _REFO1CON_ROSEL_MASK                     0x0000000F
#define _REFO1CON_ROSEL_LENGTH                   0x00000004

#define _REFO1CON_ACTIVE_POSITION                0x00000008
#define _REFO1CON_ACTIVE_MASK                    0x00000100
#define _REFO1CON_ACTIVE_LENGTH                  0x00000001

#define _REFO1CON_DIVSWEN_POSITION               0x00000009
#define _REFO1CON_DIVSWEN_MASK                   0x00000200
#define _REFO1CON_DIVSWEN_LENGTH                 0x00000001

#define _REFO1CON_RSLP_POSITION                  0x0000000B
#define _REFO1CON_RSLP_MASK                      0x00000800
#define _REFO1CON_RSLP_LENGTH                    0x00000001

#define _REFO1CON_OE_POSITION                    0x0000000C
#define _REFO1CON_OE_MASK                        0x00001000
#define _REFO1CON_OE_LENGTH                      0x00000001

#define _REFO1CON_SIDL_POSITION                  0x0000000D
#define _REFO1CON_SIDL_MASK                      0x00002000
#define _REFO1CON_SIDL_LENGTH                    0x00000001

#define _REFO1CON_ON_POSITION                    0x0000000F
#define _REFO1CON_ON_MASK                        0x00008000
#define _REFO1CON_ON_LENGTH                      0x00000001

#define _REFO1CON_RODIV_POSITION                 0x00000010
#define _REFO1CON_RODIV_MASK                     0x7FFF0000
#define _REFO1CON_RODIV_LENGTH                   0x0000000F

#define _REFO1TRIM_ROTRIM_POSITION               0x00000017
#define _REFO1TRIM_ROTRIM_MASK                   0xFF800000
#define _REFO1TRIM_ROTRIM_LENGTH                 0x00000009

#define _REFO2CON_ROSEL_POSITION                 0x00000000
#define _REFO2CON_ROSEL_MASK                     0x0000000F
#define _REFO2CON_ROSEL_LENGTH                   0x00000004

#define _REFO2CON_ACTIVE_POSITION                0x00000008
#define _REFO2CON_ACTIVE_MASK                    0x00000100
#define _REFO2CON_ACTIVE_LENGTH                  0x00000001

#define _REFO2CON_DIVSWEN_POSITION               0x00000009
#define _REFO2CON_DIVSWEN_MASK                   0x00000200
#define _REFO2CON_DIVSWEN_LENGTH                 0x00000001

#define _REFO2CON_RSLP_POSITION                  0x0000000B
#define _REFO2CON_RSLP_MASK                      0x00000800
#define _REFO2CON_RSLP_LENGTH                    0x00000001

#define _REFO2CON_OE_POSITION                    0x0000000C
#define _REFO2CON_OE_MASK                        0x00001000
#define _REFO2CON_OE_LENGTH                      0x00000001

#define _REFO2CON_SIDL_POSITION                  0x0000000D
#define _REFO2CON_SIDL_MASK                      0x00002000
#define _REFO2CON_SIDL_LENGTH                    0x00000001

#define _REFO2CON_ON_POSITION                    0x0000000F
#define _REFO2CON_ON_MASK                        0x00008000
#define _REFO2CON_ON_LENGTH                      0x00000001

#define _REFO2CON_RODIV_POSITION                 0x00000010
#define _REFO2CON_RODIV_MASK                     0x7FFF0000
#define _REFO2CON_RODIV_LENGTH                   0x0000000F

#define _REFO2TRIM_ROTRIM_POSITION               0x00000017
#define _REFO2TRIM_ROTRIM_MASK                   0xFF800000
#define _REFO2TRIM_ROTRIM_LENGTH                 0x00000009

#define _REFO3CON_ROSEL_POSITION                 0x00000000
#define _REFO3CON_ROSEL_MASK                     0x0000000F
#define _REFO3CON_ROSEL_LENGTH                   0x00000004

#define _REFO3CON_ACTIVE_POSITION                0x00000008
#define _REFO3CON_ACTIVE_MASK                    0x00000100
#define _REFO3CON_ACTIVE_LENGTH                  0x00000001

#define _REFO3CON_DIVSWEN_POSITION               0x00000009
#define _REFO3CON_DIVSWEN_MASK                   0x00000200
#define _REFO3CON_DIVSWEN_LENGTH                 0x00000001

#define _REFO3CON_RSLP_POSITION                  0x0000000B
#define _REFO3CON_RSLP_MASK                      0x00000800
#define _REFO3CON_RSLP_LENGTH                    0x00000001

#define _REFO3CON_OE_POSITION                    0x0000000C
#define _REFO3CON_OE_MASK                        0x00001000
#define _REFO3CON_OE_LENGTH                      0x00000001

#define _REFO3CON_SIDL_POSITION                  0x0000000D
#define _REFO3CON_SIDL_MASK                      0x00002000
#define _REFO3CON_SIDL_LENGTH                    0x00000001

#define _REFO3CON_ON_POSITION                    0x0000000F
#define _REFO3CON_ON_MASK                        0x00008000
#define _REFO3CON_ON_LENGTH                      0x00000001

#define _REFO3CON_RODIV_POSITION                 0x00000010
#define _REFO3CON_RODIV_MASK                     0x7FFF0000
#define _REFO3CON_RODIV_LENGTH                   0x0000000F

#define _REFO3TRIM_ROTRIM_POSITION               0x00000017
#define _REFO3TRIM_ROTRIM_MASK                   0xFF800000
#define _REFO3TRIM_ROTRIM_LENGTH                 0x00000009

#define _REFO4CON_ROSEL_POSITION                 0x00000000
#define _REFO4CON_ROSEL_MASK                     0x0000000F
#define _REFO4CON_ROSEL_LENGTH                   0x00000004

#define _REFO4CON_ACTIVE_POSITION                0x00000008
#define _REFO4CON_ACTIVE_MASK                    0x00000100
#define _REFO4CON_ACTIVE_LENGTH                  0x00000001

#define _REFO4CON_DIVSWEN_POSITION               0x00000009
#define _REFO4CON_DIVSWEN_MASK                   0x00000200
#define _REFO4CON_DIVSWEN_LENGTH                 0x00000001

#define _REFO4CON_RSLP_POSITION                  0x0000000B
#define _REFO4CON_RSLP_MASK                      0x00000800
#define _REFO4CON_RSLP_LENGTH                    0x00000001

#define _REFO4CON_OE_POSITION                    0x0000000C
#define _REFO4CON_OE_MASK                        0x00001000
#define _REFO4CON_OE_LENGTH                      0x00000001

#define _REFO4CON_SIDL_POSITION                  0x0000000D
#define _REFO4CON_SIDL_MASK                      0x00002000
#define _REFO4CON_SIDL_LENGTH                    0x00000001

#define _REFO4CON_ON_POSITION                    0x0000000F
#define _REFO4CON_ON_MASK                        0x00008000
#define _REFO4CON_ON_LENGTH                      0x00000001

#define _REFO4CON_RODIV_POSITION                 0x00000010
#define _REFO4CON_RODIV_MASK                     0x7FFF0000
#define _REFO4CON_RODIV_LENGTH                   0x0000000F

#define _REFO4TRIM_ROTRIM_POSITION               0x00000017
#define _REFO4TRIM_ROTRIM_MASK                   0xFF800000
#define _REFO4TRIM_ROTRIM_LENGTH                 0x00000009

#define _PB1DIV_PBDIV_POSITION                   0x00000000
#define _PB1DIV_PBDIV_MASK                       0x0000007F
#define _PB1DIV_PBDIV_LENGTH                     0x00000007

#define _PB1DIV_PBDIVRDY_POSITION                0x0000000B
#define _PB1DIV_PBDIVRDY_MASK                    0x00000800
#define _PB1DIV_PBDIVRDY_LENGTH                  0x00000001

#define _PB2DIV_PBDIV_POSITION                   0x00000000
#define _PB2DIV_PBDIV_MASK                       0x0000007F
#define _PB2DIV_PBDIV_LENGTH                     0x00000007

#define _PB2DIV_PBDIVRDY_POSITION                0x0000000B
#define _PB2DIV_PBDIVRDY_MASK                    0x00000800
#define _PB2DIV_PBDIVRDY_LENGTH                  0x00000001

#define _PB2DIV_ON_POSITION                      0x0000000F
#define _PB2DIV_ON_MASK                          0x00008000
#define _PB2DIV_ON_LENGTH                        0x00000001

#define _PB3DIV_PBDIV_POSITION                   0x00000000
#define _PB3DIV_PBDIV_MASK                       0x0000007F
#define _PB3DIV_PBDIV_LENGTH                     0x00000007

#define _PB3DIV_PBDIVRDY_POSITION                0x0000000B
#define _PB3DIV_PBDIVRDY_MASK                    0x00000800
#define _PB3DIV_PBDIVRDY_LENGTH                  0x00000001

#define _PB3DIV_ON_POSITION                      0x0000000F
#define _PB3DIV_ON_MASK                          0x00008000
#define _PB3DIV_ON_LENGTH                        0x00000001

#define _PB4DIV_PBDIV_POSITION                   0x00000000
#define _PB4DIV_PBDIV_MASK                       0x0000007F
#define _PB4DIV_PBDIV_LENGTH                     0x00000007

#define _PB4DIV_PBDIVRDY_POSITION                0x0000000B
#define _PB4DIV_PBDIVRDY_MASK                    0x00000800
#define _PB4DIV_PBDIVRDY_LENGTH                  0x00000001

#define _PB4DIV_ON_POSITION                      0x0000000F
#define _PB4DIV_ON_MASK                          0x00008000
#define _PB4DIV_ON_LENGTH                        0x00000001

#define _PB5DIV_PBDIV_POSITION                   0x00000000
#define _PB5DIV_PBDIV_MASK                       0x0000007F
#define _PB5DIV_PBDIV_LENGTH                     0x00000007

#define _PB5DIV_PBDIVRDY_POSITION                0x0000000B
#define _PB5DIV_PBDIVRDY_MASK                    0x00000800
#define _PB5DIV_PBDIVRDY_LENGTH                  0x00000001

#define _PB5DIV_ON_POSITION                      0x0000000F
#define _PB5DIV_ON_MASK                          0x00008000
#define _PB5DIV_ON_LENGTH                        0x00000001

#define _PB7DIV_PBDIV_POSITION                   0x00000000
#define _PB7DIV_PBDIV_MASK                       0x0000007F
#define _PB7DIV_PBDIV_LENGTH                     0x00000007

#define _PB7DIV_PBDIVRDY_POSITION                0x0000000B
#define _PB7DIV_PBDIVRDY_MASK                    0x00000800
#define _PB7DIV_PBDIVRDY_LENGTH                  0x00000001

#define _PB7DIV_ON_POSITION                      0x0000000F
#define _PB7DIV_ON_MASK                          0x00008000
#define _PB7DIV_ON_LENGTH                        0x00000001

#define _PB8DIV_PBDIV_POSITION                   0x00000000
#define _PB8DIV_PBDIV_MASK                       0x0000007F
#define _PB8DIV_PBDIV_LENGTH                     0x00000007

#define _PB8DIV_PBDIVRDY_POSITION                0x0000000B
#define _PB8DIV_PBDIVRDY_MASK                    0x00000800
#define _PB8DIV_PBDIVRDY_LENGTH                  0x00000001

#define _PB8DIV_ON_POSITION                      0x0000000F
#define _PB8DIV_ON_MASK                          0x00008000
#define _PB8DIV_ON_LENGTH                        0x00000001

#define _SLEWCON_BUSY_POSITION                   0x00000000
#define _SLEWCON_BUSY_MASK                       0x00000001
#define _SLEWCON_BUSY_LENGTH                     0x00000001

#define _SLEWCON_DNEN_POSITION                   0x00000001
#define _SLEWCON_DNEN_MASK                       0x00000002
#define _SLEWCON_DNEN_LENGTH                     0x00000001

#define _SLEWCON_UPEN_POSITION                   0x00000002
#define _SLEWCON_UPEN_MASK                       0x00000004
#define _SLEWCON_UPEN_LENGTH                     0x00000001

#define _SLEWCON_SLWDIV_POSITION                 0x00000008
#define _SLEWCON_SLWDIV_MASK                     0x00000700
#define _SLEWCON_SLWDIV_LENGTH                   0x00000003

#define _SLEWCON_SYSDIV_POSITION                 0x00000010
#define _SLEWCON_SYSDIV_MASK                     0x000F0000
#define _SLEWCON_SYSDIV_LENGTH                   0x00000004

#define _CLKSTAT_FRCRDY_POSITION                 0x00000000
#define _CLKSTAT_FRCRDY_MASK                     0x00000001
#define _CLKSTAT_FRCRDY_LENGTH                   0x00000001

#define _CLKSTAT_SPDIVRDY_POSITION               0x00000001
#define _CLKSTAT_SPDIVRDY_MASK                   0x00000002
#define _CLKSTAT_SPDIVRDY_LENGTH                 0x00000001

#define _CLKSTAT_POSCRDY_POSITION                0x00000002
#define _CLKSTAT_POSCRDY_MASK                    0x00000004
#define _CLKSTAT_POSCRDY_LENGTH                  0x00000001

#define _CLKSTAT_SOSCRDY_POSITION                0x00000004
#define _CLKSTAT_SOSCRDY_MASK                    0x00000010
#define _CLKSTAT_SOSCRDY_LENGTH                  0x00000001

#define _CLKSTAT_LPRCRDY_POSITION                0x00000005
#define _CLKSTAT_LPRCRDY_MASK                    0x00000020
#define _CLKSTAT_LPRCRDY_LENGTH                  0x00000001

#define _CLKSTAT_DIVSPLLRDY_POSITION             0x00000001
#define _CLKSTAT_DIVSPLLRDY_MASK                 0x00000002
#define _CLKSTAT_DIVSPLLRDY_LENGTH               0x00000001

#define _INT1R_INT1R_POSITION                    0x00000000
#define _INT1R_INT1R_MASK                        0x0000000F
#define _INT1R_INT1R_LENGTH                      0x00000004

#define _INT2R_INT2R_POSITION                    0x00000000
#define _INT2R_INT2R_MASK                        0x0000000F
#define _INT2R_INT2R_LENGTH                      0x00000004

#define _INT3R_INT3R_POSITION                    0x00000000
#define _INT3R_INT3R_MASK                        0x0000000F
#define _INT3R_INT3R_LENGTH                      0x00000004

#define _INT4R_INT4R_POSITION                    0x00000000
#define _INT4R_INT4R_MASK                        0x0000000F
#define _INT4R_INT4R_LENGTH                      0x00000004

#define _T2CKR_T2CKR_POSITION                    0x00000000
#define _T2CKR_T2CKR_MASK                        0x0000000F
#define _T2CKR_T2CKR_LENGTH                      0x00000004

#define _T3CKR_T3CKR_POSITION                    0x00000000
#define _T3CKR_T3CKR_MASK                        0x0000000F
#define _T3CKR_T3CKR_LENGTH                      0x00000004

#define _T4CKR_T4CKR_POSITION                    0x00000000
#define _T4CKR_T4CKR_MASK                        0x0000000F
#define _T4CKR_T4CKR_LENGTH                      0x00000004

#define _T5CKR_T5CKR_POSITION                    0x00000000
#define _T5CKR_T5CKR_MASK                        0x0000000F
#define _T5CKR_T5CKR_LENGTH                      0x00000004

#define _T6CKR_T6CKR_POSITION                    0x00000000
#define _T6CKR_T6CKR_MASK                        0x0000000F
#define _T6CKR_T6CKR_LENGTH                      0x00000004

#define _T7CKR_T7CKR_POSITION                    0x00000000
#define _T7CKR_T7CKR_MASK                        0x0000000F
#define _T7CKR_T7CKR_LENGTH                      0x00000004

#define _T8CKR_T8CKR_POSITION                    0x00000000
#define _T8CKR_T8CKR_MASK                        0x0000000F
#define _T8CKR_T8CKR_LENGTH                      0x00000004

#define _T9CKR_T9CKR_POSITION                    0x00000000
#define _T9CKR_T9CKR_MASK                        0x0000000F
#define _T9CKR_T9CKR_LENGTH                      0x00000004

#define _IC1R_IC1R_POSITION                      0x00000000
#define _IC1R_IC1R_MASK                          0x0000000F
#define _IC1R_IC1R_LENGTH                        0x00000004

#define _IC2R_IC2R_POSITION                      0x00000000
#define _IC2R_IC2R_MASK                          0x0000000F
#define _IC2R_IC2R_LENGTH                        0x00000004

#define _IC3R_IC3R_POSITION                      0x00000000
#define _IC3R_IC3R_MASK                          0x0000000F
#define _IC3R_IC3R_LENGTH                        0x00000004

#define _IC4R_IC4R_POSITION                      0x00000000
#define _IC4R_IC4R_MASK                          0x0000000F
#define _IC4R_IC4R_LENGTH                        0x00000004

#define _IC5R_IC5R_POSITION                      0x00000000
#define _IC5R_IC5R_MASK                          0x0000000F
#define _IC5R_IC5R_LENGTH                        0x00000004

#define _IC6R_IC6R_POSITION                      0x00000000
#define _IC6R_IC6R_MASK                          0x0000000F
#define _IC6R_IC6R_LENGTH                        0x00000004

#define _IC7R_IC7R_POSITION                      0x00000000
#define _IC7R_IC7R_MASK                          0x0000000F
#define _IC7R_IC7R_LENGTH                        0x00000004

#define _IC8R_IC8R_POSITION                      0x00000000
#define _IC8R_IC8R_MASK                          0x0000000F
#define _IC8R_IC8R_LENGTH                        0x00000004

#define _IC9R_IC9R_POSITION                      0x00000000
#define _IC9R_IC9R_MASK                          0x0000000F
#define _IC9R_IC9R_LENGTH                        0x00000004

#define _OCFAR_OCFAR_POSITION                    0x00000000
#define _OCFAR_OCFAR_MASK                        0x0000000F
#define _OCFAR_OCFAR_LENGTH                      0x00000004

#define _U1RXR_U1RXR_POSITION                    0x00000000
#define _U1RXR_U1RXR_MASK                        0x0000000F
#define _U1RXR_U1RXR_LENGTH                      0x00000004

#define _U1CTSR_U1CTSR_POSITION                  0x00000000
#define _U1CTSR_U1CTSR_MASK                      0x0000000F
#define _U1CTSR_U1CTSR_LENGTH                    0x00000004

#define _U2RXR_U2RXR_POSITION                    0x00000000
#define _U2RXR_U2RXR_MASK                        0x0000000F
#define _U2RXR_U2RXR_LENGTH                      0x00000004

#define _U2CTSR_U2CTSR_POSITION                  0x00000000
#define _U2CTSR_U2CTSR_MASK                      0x0000000F
#define _U2CTSR_U2CTSR_LENGTH                    0x00000004

#define _U3RXR_U3RXR_POSITION                    0x00000000
#define _U3RXR_U3RXR_MASK                        0x0000000F
#define _U3RXR_U3RXR_LENGTH                      0x00000004

#define _U3CTSR_U3CTSR_POSITION                  0x00000000
#define _U3CTSR_U3CTSR_MASK                      0x0000000F
#define _U3CTSR_U3CTSR_LENGTH                    0x00000004

#define _U4RXR_U4RXR_POSITION                    0x00000000
#define _U4RXR_U4RXR_MASK                        0x0000000F
#define _U4RXR_U4RXR_LENGTH                      0x00000004

#define _U4CTSR_U4CTSR_POSITION                  0x00000000
#define _U4CTSR_U4CTSR_MASK                      0x0000000F
#define _U4CTSR_U4CTSR_LENGTH                    0x00000004

#define _U5RXR_U5RXR_POSITION                    0x00000000
#define _U5RXR_U5RXR_MASK                        0x0000000F
#define _U5RXR_U5RXR_LENGTH                      0x00000004

#define _U5CTSR_U5CTSR_POSITION                  0x00000000
#define _U5CTSR_U5CTSR_MASK                      0x0000000F
#define _U5CTSR_U5CTSR_LENGTH                    0x00000004

#define _U6RXR_U6RXR_POSITION                    0x00000000
#define _U6RXR_U6RXR_MASK                        0x0000000F
#define _U6RXR_U6RXR_LENGTH                      0x00000004

#define _U6CTSR_U6CTSR_POSITION                  0x00000000
#define _U6CTSR_U6CTSR_MASK                      0x0000000F
#define _U6CTSR_U6CTSR_LENGTH                    0x00000004

#define _SDI1R_SDI1R_POSITION                    0x00000000
#define _SDI1R_SDI1R_MASK                        0x0000000F
#define _SDI1R_SDI1R_LENGTH                      0x00000004

#define _SS1R_SS1R_POSITION                      0x00000000
#define _SS1R_SS1R_MASK                          0x0000000F
#define _SS1R_SS1R_LENGTH                        0x00000004

#define _SDI2R_SDI2R_POSITION                    0x00000000
#define _SDI2R_SDI2R_MASK                        0x0000000F
#define _SDI2R_SDI2R_LENGTH                      0x00000004

#define _SS2R_SS2R_POSITION                      0x00000000
#define _SS2R_SS2R_MASK                          0x0000000F
#define _SS2R_SS2R_LENGTH                        0x00000004

#define _SDI3R_SDI3R_POSITION                    0x00000000
#define _SDI3R_SDI3R_MASK                        0x0000000F
#define _SDI3R_SDI3R_LENGTH                      0x00000004

#define _SS3R_SS3R_POSITION                      0x00000000
#define _SS3R_SS3R_MASK                          0x0000000F
#define _SS3R_SS3R_LENGTH                        0x00000004

#define _SDI4R_SDI4R_POSITION                    0x00000000
#define _SDI4R_SDI4R_MASK                        0x0000000F
#define _SDI4R_SDI4R_LENGTH                      0x00000004

#define _SS4R_SS4R_POSITION                      0x00000000
#define _SS4R_SS4R_MASK                          0x0000000F
#define _SS4R_SS4R_LENGTH                        0x00000004

#define _SDI5R_SDI5R_POSITION                    0x00000000
#define _SDI5R_SDI5R_MASK                        0x0000000F
#define _SDI5R_SDI5R_LENGTH                      0x00000004

#define _SS5R_SS5R_POSITION                      0x00000000
#define _SS5R_SS5R_MASK                          0x0000000F
#define _SS5R_SS5R_LENGTH                        0x00000004

#define _SDI6R_SDI6R_POSITION                    0x00000000
#define _SDI6R_SDI6R_MASK                        0x0000000F
#define _SDI6R_SDI6R_LENGTH                      0x00000004

#define _SS6R_SS6R_POSITION                      0x00000000
#define _SS6R_SS6R_MASK                          0x0000000F
#define _SS6R_SS6R_LENGTH                        0x00000004

#define _REFCLKI1R_REFCLKI1R_POSITION            0x00000000
#define _REFCLKI1R_REFCLKI1R_MASK                0x0000000F
#define _REFCLKI1R_REFCLKI1R_LENGTH              0x00000004

#define _REFCLKI3R_REFCLKI3R_POSITION            0x00000000
#define _REFCLKI3R_REFCLKI3R_MASK                0x0000000F
#define _REFCLKI3R_REFCLKI3R_LENGTH              0x00000004

#define _REFCLKI4R_REFCLKI4R_POSITION            0x00000000
#define _REFCLKI4R_REFCLKI4R_MASK                0x0000000F
#define _REFCLKI4R_REFCLKI4R_LENGTH              0x00000004

#define _RPA14R_RPA14R_POSITION                  0x00000000
#define _RPA14R_RPA14R_MASK                      0x0000000F
#define _RPA14R_RPA14R_LENGTH                    0x00000004

#define _RPA15R_RPA15R_POSITION                  0x00000000
#define _RPA15R_RPA15R_MASK                      0x0000000F
#define _RPA15R_RPA15R_LENGTH                    0x00000004

#define _RPB0R_RPB0R_POSITION                    0x00000000
#define _RPB0R_RPB0R_MASK                        0x0000000F
#define _RPB0R_RPB0R_LENGTH                      0x00000004

#define _RPB1R_RPB1R_POSITION                    0x00000000
#define _RPB1R_RPB1R_MASK                        0x0000000F
#define _RPB1R_RPB1R_LENGTH                      0x00000004

#define _RPB2R_RPB2R_POSITION                    0x00000000
#define _RPB2R_RPB2R_MASK                        0x0000000F
#define _RPB2R_RPB2R_LENGTH                      0x00000004

#define _RPB3R_RPB3R_POSITION                    0x00000000
#define _RPB3R_RPB3R_MASK                        0x0000000F
#define _RPB3R_RPB3R_LENGTH                      0x00000004

#define _RPB5R_RPB5R_POSITION                    0x00000000
#define _RPB5R_RPB5R_MASK                        0x0000000F
#define _RPB5R_RPB5R_LENGTH                      0x00000004

#define _RPB6R_RPB6R_POSITION                    0x00000000
#define _RPB6R_RPB6R_MASK                        0x0000000F
#define _RPB6R_RPB6R_LENGTH                      0x00000004

#define _RPB7R_RPB7R_POSITION                    0x00000000
#define _RPB7R_RPB7R_MASK                        0x0000000F
#define _RPB7R_RPB7R_LENGTH                      0x00000004

#define _RPB8R_RPB8R_POSITION                    0x00000000
#define _RPB8R_RPB8R_MASK                        0x0000000F
#define _RPB8R_RPB8R_LENGTH                      0x00000004

#define _RPB9R_RPB9R_POSITION                    0x00000000
#define _RPB9R_RPB9R_MASK                        0x0000000F
#define _RPB9R_RPB9R_LENGTH                      0x00000004

#define _RPB10R_RPB10R_POSITION                  0x00000000
#define _RPB10R_RPB10R_MASK                      0x0000000F
#define _RPB10R_RPB10R_LENGTH                    0x00000004

#define _RPB14R_RPB14R_POSITION                  0x00000000
#define _RPB14R_RPB14R_MASK                      0x0000000F
#define _RPB14R_RPB14R_LENGTH                    0x00000004

#define _RPB15R_RPB15R_POSITION                  0x00000000
#define _RPB15R_RPB15R_MASK                      0x0000000F
#define _RPB15R_RPB15R_LENGTH                    0x00000004

#define _RPC1R_RPC1R_POSITION                    0x00000000
#define _RPC1R_RPC1R_MASK                        0x0000000F
#define _RPC1R_RPC1R_LENGTH                      0x00000004

#define _RPC2R_RPC2R_POSITION                    0x00000000
#define _RPC2R_RPC2R_MASK                        0x0000000F
#define _RPC2R_RPC2R_LENGTH                      0x00000004

#define _RPC3R_RPC3R_POSITION                    0x00000000
#define _RPC3R_RPC3R_MASK                        0x0000000F
#define _RPC3R_RPC3R_LENGTH                      0x00000004

#define _RPC4R_RPC4R_POSITION                    0x00000000
#define _RPC4R_RPC4R_MASK                        0x0000000F
#define _RPC4R_RPC4R_LENGTH                      0x00000004

#define _RPC13R_RPC13R_POSITION                  0x00000000
#define _RPC13R_RPC13R_MASK                      0x0000000F
#define _RPC13R_RPC13R_LENGTH                    0x00000004

#define _RPC14R_RPC14R_POSITION                  0x00000000
#define _RPC14R_RPC14R_MASK                      0x0000000F
#define _RPC14R_RPC14R_LENGTH                    0x00000004

#define _RPD0R_RPD0R_POSITION                    0x00000000
#define _RPD0R_RPD0R_MASK                        0x0000000F
#define _RPD0R_RPD0R_LENGTH                      0x00000004

#define _RPD1R_RPD1R_POSITION                    0x00000000
#define _RPD1R_RPD1R_MASK                        0x0000000F
#define _RPD1R_RPD1R_LENGTH                      0x00000004

#define _RPD2R_RPD2R_POSITION                    0x00000000
#define _RPD2R_RPD2R_MASK                        0x0000000F
#define _RPD2R_RPD2R_LENGTH                      0x00000004

#define _RPD3R_RPD3R_POSITION                    0x00000000
#define _RPD3R_RPD3R_MASK                        0x0000000F
#define _RPD3R_RPD3R_LENGTH                      0x00000004

#define _RPD4R_RPD4R_POSITION                    0x00000000
#define _RPD4R_RPD4R_MASK                        0x0000000F
#define _RPD4R_RPD4R_LENGTH                      0x00000004

#define _RPD5R_RPD5R_POSITION                    0x00000000
#define _RPD5R_RPD5R_MASK                        0x0000000F
#define _RPD5R_RPD5R_LENGTH                      0x00000004

#define _RPD9R_RPD9R_POSITION                    0x00000000
#define _RPD9R_RPD9R_MASK                        0x0000000F
#define _RPD9R_RPD9R_LENGTH                      0x00000004

#define _RPD10R_RPD10R_POSITION                  0x00000000
#define _RPD10R_RPD10R_MASK                      0x0000000F
#define _RPD10R_RPD10R_LENGTH                    0x00000004

#define _RPD11R_RPD11R_POSITION                  0x00000000
#define _RPD11R_RPD11R_MASK                      0x0000000F
#define _RPD11R_RPD11R_LENGTH                    0x00000004

#define _RPD12R_RPD12R_POSITION                  0x00000000
#define _RPD12R_RPD12R_MASK                      0x0000000F
#define _RPD12R_RPD12R_LENGTH                    0x00000004

#define _RPD14R_RPD14R_POSITION                  0x00000000
#define _RPD14R_RPD14R_MASK                      0x0000000F
#define _RPD14R_RPD14R_LENGTH                    0x00000004

#define _RPD15R_RPD15R_POSITION                  0x00000000
#define _RPD15R_RPD15R_MASK                      0x0000000F
#define _RPD15R_RPD15R_LENGTH                    0x00000004

#define _RPE3R_RPE3R_POSITION                    0x00000000
#define _RPE3R_RPE3R_MASK                        0x0000000F
#define _RPE3R_RPE3R_LENGTH                      0x00000004

#define _RPE5R_RPE5R_POSITION                    0x00000000
#define _RPE5R_RPE5R_MASK                        0x0000000F
#define _RPE5R_RPE5R_LENGTH                      0x00000004

#define _RPE8R_RPE8R_POSITION                    0x00000000
#define _RPE8R_RPE8R_MASK                        0x0000000F
#define _RPE8R_RPE8R_LENGTH                      0x00000004

#define _RPE9R_RPE9R_POSITION                    0x00000000
#define _RPE9R_RPE9R_MASK                        0x0000000F
#define _RPE9R_RPE9R_LENGTH                      0x00000004

#define _RPF0R_RPF0R_POSITION                    0x00000000
#define _RPF0R_RPF0R_MASK                        0x0000000F
#define _RPF0R_RPF0R_LENGTH                      0x00000004

#define _RPF1R_RPF1R_POSITION                    0x00000000
#define _RPF1R_RPF1R_MASK                        0x0000000F
#define _RPF1R_RPF1R_LENGTH                      0x00000004

#define _RPF2R_RPF2R_POSITION                    0x00000000
#define _RPF2R_RPF2R_MASK                        0x0000000F
#define _RPF2R_RPF2R_LENGTH                      0x00000004

#define _RPF3R_RPF3R_POSITION                    0x00000000
#define _RPF3R_RPF3R_MASK                        0x0000000F
#define _RPF3R_RPF3R_LENGTH                      0x00000004

#define _RPF4R_RPF4R_POSITION                    0x00000000
#define _RPF4R_RPF4R_MASK                        0x0000000F
#define _RPF4R_RPF4R_LENGTH                      0x00000004

#define _RPF5R_RPF5R_POSITION                    0x00000000
#define _RPF5R_RPF5R_MASK                        0x0000000F
#define _RPF5R_RPF5R_LENGTH                      0x00000004

#define _RPF8R_RPF8R_POSITION                    0x00000000
#define _RPF8R_RPF8R_MASK                        0x0000000F
#define _RPF8R_RPF8R_LENGTH                      0x00000004

#define _RPF12R_RPF12R_POSITION                  0x00000000
#define _RPF12R_RPF12R_MASK                      0x0000000F
#define _RPF12R_RPF12R_LENGTH                    0x00000004

#define _RPF13R_RPF13R_POSITION                  0x00000000
#define _RPF13R_RPF13R_MASK                      0x0000000F
#define _RPF13R_RPF13R_LENGTH                    0x00000004

#define _RPG0R_RPG0R_POSITION                    0x00000000
#define _RPG0R_RPG0R_MASK                        0x0000000F
#define _RPG0R_RPG0R_LENGTH                      0x00000004

#define _RPG1R_RPG1R_POSITION                    0x00000000
#define _RPG1R_RPG1R_MASK                        0x0000000F
#define _RPG1R_RPG1R_LENGTH                      0x00000004

#define _RPG6R_RPG6R_POSITION                    0x00000000
#define _RPG6R_RPG6R_MASK                        0x0000000F
#define _RPG6R_RPG6R_LENGTH                      0x00000004

#define _RPG7R_RPG7R_POSITION                    0x00000000
#define _RPG7R_RPG7R_MASK                        0x0000000F
#define _RPG7R_RPG7R_LENGTH                      0x00000004

#define _RPG8R_RPG8R_POSITION                    0x00000000
#define _RPG8R_RPG8R_MASK                        0x0000000F
#define _RPG8R_RPG8R_LENGTH                      0x00000004

#define _RPG9R_RPG9R_POSITION                    0x00000000
#define _RPG9R_RPG9R_MASK                        0x0000000F
#define _RPG9R_RPG9R_LENGTH                      0x00000004

#define _INTCON_INT0EP_POSITION                  0x00000000
#define _INTCON_INT0EP_MASK                      0x00000001
#define _INTCON_INT0EP_LENGTH                    0x00000001

#define _INTCON_INT1EP_POSITION                  0x00000001
#define _INTCON_INT1EP_MASK                      0x00000002
#define _INTCON_INT1EP_LENGTH                    0x00000001

#define _INTCON_INT2EP_POSITION                  0x00000002
#define _INTCON_INT2EP_MASK                      0x00000004
#define _INTCON_INT2EP_LENGTH                    0x00000001

#define _INTCON_INT3EP_POSITION                  0x00000003
#define _INTCON_INT3EP_MASK                      0x00000008
#define _INTCON_INT3EP_LENGTH                    0x00000001

#define _INTCON_INT4EP_POSITION                  0x00000004
#define _INTCON_INT4EP_MASK                      0x00000010
#define _INTCON_INT4EP_LENGTH                    0x00000001

#define _INTCON_TPC_POSITION                     0x00000008
#define _INTCON_TPC_MASK                         0x00000700
#define _INTCON_TPC_LENGTH                       0x00000003

#define _INTCON_MVEC_POSITION                    0x0000000C
#define _INTCON_MVEC_MASK                        0x00001000
#define _INTCON_MVEC_LENGTH                      0x00000001

#define _INTCON_NMIKEY_POSITION                  0x00000018
#define _INTCON_NMIKEY_MASK                      0xFF000000
#define _INTCON_NMIKEY_LENGTH                    0x00000008

#define _PRISS_SS0_POSITION                      0x00000000
#define _PRISS_SS0_MASK                          0x00000001
#define _PRISS_SS0_LENGTH                        0x00000001

#define _PRISS_PRI1SS_POSITION                   0x00000004
#define _PRISS_PRI1SS_MASK                       0x000000F0
#define _PRISS_PRI1SS_LENGTH                     0x00000004

#define _PRISS_PRI2SS_POSITION                   0x00000008
#define _PRISS_PRI2SS_MASK                       0x00000F00
#define _PRISS_PRI2SS_LENGTH                     0x00000004

#define _PRISS_PRI3SS_POSITION                   0x0000000C
#define _PRISS_PRI3SS_MASK                       0x0000F000
#define _PRISS_PRI3SS_LENGTH                     0x00000004

#define _PRISS_PRI4SS_POSITION                   0x00000010
#define _PRISS_PRI4SS_MASK                       0x000F0000
#define _PRISS_PRI4SS_LENGTH                     0x00000004

#define _PRISS_PRI5SS_POSITION                   0x00000014
#define _PRISS_PRI5SS_MASK                       0x00F00000
#define _PRISS_PRI5SS_LENGTH                     0x00000004

#define _PRISS_PRI6SS_POSITION                   0x00000018
#define _PRISS_PRI6SS_MASK                       0x0F000000
#define _PRISS_PRI6SS_LENGTH                     0x00000004

#define _PRISS_PRI7SS_POSITION                   0x0000001C
#define _PRISS_PRI7SS_MASK                       0xF0000000
#define _PRISS_PRI7SS_LENGTH                     0x00000004

#define _INTSTAT_SIRQ_POSITION                   0x00000000
#define _INTSTAT_SIRQ_MASK                       0x000000FF
#define _INTSTAT_SIRQ_LENGTH                     0x00000008

#define _INTSTAT_SRIPL_POSITION                  0x00000008
#define _INTSTAT_SRIPL_MASK                      0x00000700
#define _INTSTAT_SRIPL_LENGTH                    0x00000003

#define _IPTMR_IPTMR_POSITION                    0x00000000
#define _IPTMR_IPTMR_MASK                        0xFFFFFFFF
#define _IPTMR_IPTMR_LENGTH                      0x00000020

#define _IFS0_CTIF_POSITION                      0x00000000
#define _IFS0_CTIF_MASK                          0x00000001
#define _IFS0_CTIF_LENGTH                        0x00000001

#define _IFS0_CS0IF_POSITION                     0x00000001
#define _IFS0_CS0IF_MASK                         0x00000002
#define _IFS0_CS0IF_LENGTH                       0x00000001

#define _IFS0_CS1IF_POSITION                     0x00000002
#define _IFS0_CS1IF_MASK                         0x00000004
#define _IFS0_CS1IF_LENGTH                       0x00000001

#define _IFS0_INT0IF_POSITION                    0x00000003
#define _IFS0_INT0IF_MASK                        0x00000008
#define _IFS0_INT0IF_LENGTH                      0x00000001

#define _IFS0_T1IF_POSITION                      0x00000004
#define _IFS0_T1IF_MASK                          0x00000010
#define _IFS0_T1IF_LENGTH                        0x00000001

#define _IFS0_IC1EIF_POSITION                    0x00000005
#define _IFS0_IC1EIF_MASK                        0x00000020
#define _IFS0_IC1EIF_LENGTH                      0x00000001

#define _IFS0_IC1IF_POSITION                     0x00000006
#define _IFS0_IC1IF_MASK                         0x00000040
#define _IFS0_IC1IF_LENGTH                       0x00000001

#define _IFS0_OC1IF_POSITION                     0x00000007
#define _IFS0_OC1IF_MASK                         0x00000080
#define _IFS0_OC1IF_LENGTH                       0x00000001

#define _IFS0_INT1IF_POSITION                    0x00000008
#define _IFS0_INT1IF_MASK                        0x00000100
#define _IFS0_INT1IF_LENGTH                      0x00000001

#define _IFS0_T2IF_POSITION                      0x00000009
#define _IFS0_T2IF_MASK                          0x00000200
#define _IFS0_T2IF_LENGTH                        0x00000001

#define _IFS0_IC2EIF_POSITION                    0x0000000A
#define _IFS0_IC2EIF_MASK                        0x00000400
#define _IFS0_IC2EIF_LENGTH                      0x00000001

#define _IFS0_IC2IF_POSITION                     0x0000000B
#define _IFS0_IC2IF_MASK                         0x00000800
#define _IFS0_IC2IF_LENGTH                       0x00000001

#define _IFS0_OC2IF_POSITION                     0x0000000C
#define _IFS0_OC2IF_MASK                         0x00001000
#define _IFS0_OC2IF_LENGTH                       0x00000001

#define _IFS0_INT2IF_POSITION                    0x0000000D
#define _IFS0_INT2IF_MASK                        0x00002000
#define _IFS0_INT2IF_LENGTH                      0x00000001

#define _IFS0_T3IF_POSITION                      0x0000000E
#define _IFS0_T3IF_MASK                          0x00004000
#define _IFS0_T3IF_LENGTH                        0x00000001

#define _IFS0_IC3EIF_POSITION                    0x0000000F
#define _IFS0_IC3EIF_MASK                        0x00008000
#define _IFS0_IC3EIF_LENGTH                      0x00000001

#define _IFS0_IC3IF_POSITION                     0x00000010
#define _IFS0_IC3IF_MASK                         0x00010000
#define _IFS0_IC3IF_LENGTH                       0x00000001

#define _IFS0_OC3IF_POSITION                     0x00000011
#define _IFS0_OC3IF_MASK                         0x00020000
#define _IFS0_OC3IF_LENGTH                       0x00000001

#define _IFS0_INT3IF_POSITION                    0x00000012
#define _IFS0_INT3IF_MASK                        0x00040000
#define _IFS0_INT3IF_LENGTH                      0x00000001

#define _IFS0_T4IF_POSITION                      0x00000013
#define _IFS0_T4IF_MASK                          0x00080000
#define _IFS0_T4IF_LENGTH                        0x00000001

#define _IFS0_IC4EIF_POSITION                    0x00000014
#define _IFS0_IC4EIF_MASK                        0x00100000
#define _IFS0_IC4EIF_LENGTH                      0x00000001

#define _IFS0_IC4IF_POSITION                     0x00000015
#define _IFS0_IC4IF_MASK                         0x00200000
#define _IFS0_IC4IF_LENGTH                       0x00000001

#define _IFS0_OC4IF_POSITION                     0x00000016
#define _IFS0_OC4IF_MASK                         0x00400000
#define _IFS0_OC4IF_LENGTH                       0x00000001

#define _IFS0_INT4IF_POSITION                    0x00000017
#define _IFS0_INT4IF_MASK                        0x00800000
#define _IFS0_INT4IF_LENGTH                      0x00000001

#define _IFS0_T5IF_POSITION                      0x00000018
#define _IFS0_T5IF_MASK                          0x01000000
#define _IFS0_T5IF_LENGTH                        0x00000001

#define _IFS0_IC5EIF_POSITION                    0x00000019
#define _IFS0_IC5EIF_MASK                        0x02000000
#define _IFS0_IC5EIF_LENGTH                      0x00000001

#define _IFS0_IC5IF_POSITION                     0x0000001A
#define _IFS0_IC5IF_MASK                         0x04000000
#define _IFS0_IC5IF_LENGTH                       0x00000001

#define _IFS0_OC5IF_POSITION                     0x0000001B
#define _IFS0_OC5IF_MASK                         0x08000000
#define _IFS0_OC5IF_LENGTH                       0x00000001

#define _IFS0_T6IF_POSITION                      0x0000001C
#define _IFS0_T6IF_MASK                          0x10000000
#define _IFS0_T6IF_LENGTH                        0x00000001

#define _IFS0_IC6EIF_POSITION                    0x0000001D
#define _IFS0_IC6EIF_MASK                        0x20000000
#define _IFS0_IC6EIF_LENGTH                      0x00000001

#define _IFS0_IC6IF_POSITION                     0x0000001E
#define _IFS0_IC6IF_MASK                         0x40000000
#define _IFS0_IC6IF_LENGTH                       0x00000001

#define _IFS0_OC6IF_POSITION                     0x0000001F
#define _IFS0_OC6IF_MASK                         0x80000000
#define _IFS0_OC6IF_LENGTH                       0x00000001

#define _IFS0_w_POSITION                         0x00000000
#define _IFS0_w_MASK                             0xFFFFFFFF
#define _IFS0_w_LENGTH                           0x00000020

#define _IFS1_T7IF_POSITION                      0x00000000
#define _IFS1_T7IF_MASK                          0x00000001
#define _IFS1_T7IF_LENGTH                        0x00000001

#define _IFS1_IC7EIF_POSITION                    0x00000001
#define _IFS1_IC7EIF_MASK                        0x00000002
#define _IFS1_IC7EIF_LENGTH                      0x00000001

#define _IFS1_IC7IF_POSITION                     0x00000002
#define _IFS1_IC7IF_MASK                         0x00000004
#define _IFS1_IC7IF_LENGTH                       0x00000001

#define _IFS1_OC7IF_POSITION                     0x00000003
#define _IFS1_OC7IF_MASK                         0x00000008
#define _IFS1_OC7IF_LENGTH                       0x00000001

#define _IFS1_T8IF_POSITION                      0x00000004
#define _IFS1_T8IF_MASK                          0x00000010
#define _IFS1_T8IF_LENGTH                        0x00000001

#define _IFS1_IC8EIF_POSITION                    0x00000005
#define _IFS1_IC8EIF_MASK                        0x00000020
#define _IFS1_IC8EIF_LENGTH                      0x00000001

#define _IFS1_IC8IF_POSITION                     0x00000006
#define _IFS1_IC8IF_MASK                         0x00000040
#define _IFS1_IC8IF_LENGTH                       0x00000001

#define _IFS1_OC8IF_POSITION                     0x00000007
#define _IFS1_OC8IF_MASK                         0x00000080
#define _IFS1_OC8IF_LENGTH                       0x00000001

#define _IFS1_T9IF_POSITION                      0x00000008
#define _IFS1_T9IF_MASK                          0x00000100
#define _IFS1_T9IF_LENGTH                        0x00000001

#define _IFS1_IC9EIF_POSITION                    0x00000009
#define _IFS1_IC9EIF_MASK                        0x00000200
#define _IFS1_IC9EIF_LENGTH                      0x00000001

#define _IFS1_IC9IF_POSITION                     0x0000000A
#define _IFS1_IC9IF_MASK                         0x00000400
#define _IFS1_IC9IF_LENGTH                       0x00000001

#define _IFS1_OC9IF_POSITION                     0x0000000B
#define _IFS1_OC9IF_MASK                         0x00000800
#define _IFS1_OC9IF_LENGTH                       0x00000001

#define _IFS1_ADCIF_POSITION                     0x0000000C
#define _IFS1_ADCIF_MASK                         0x00001000
#define _IFS1_ADCIF_LENGTH                       0x00000001

#define _IFS1_ADCFIFOIF_POSITION                 0x0000000D
#define _IFS1_ADCFIFOIF_MASK                     0x00002000
#define _IFS1_ADCFIFOIF_LENGTH                   0x00000001

#define _IFS1_ADCDC1IF_POSITION                  0x0000000E
#define _IFS1_ADCDC1IF_MASK                      0x00004000
#define _IFS1_ADCDC1IF_LENGTH                    0x00000001

#define _IFS1_ADCDC2IF_POSITION                  0x0000000F
#define _IFS1_ADCDC2IF_MASK                      0x00008000
#define _IFS1_ADCDC2IF_LENGTH                    0x00000001

#define _IFS1_ADCDC3IF_POSITION                  0x00000010
#define _IFS1_ADCDC3IF_MASK                      0x00010000
#define _IFS1_ADCDC3IF_LENGTH                    0x00000001

#define _IFS1_ADCDC4IF_POSITION                  0x00000011
#define _IFS1_ADCDC4IF_MASK                      0x00020000
#define _IFS1_ADCDC4IF_LENGTH                    0x00000001

#define _IFS1_ADCDC5IF_POSITION                  0x00000012
#define _IFS1_ADCDC5IF_MASK                      0x00040000
#define _IFS1_ADCDC5IF_LENGTH                    0x00000001

#define _IFS1_ADCDC6IF_POSITION                  0x00000013
#define _IFS1_ADCDC6IF_MASK                      0x00080000
#define _IFS1_ADCDC6IF_LENGTH                    0x00000001

#define _IFS1_ADCDF1IF_POSITION                  0x00000014
#define _IFS1_ADCDF1IF_MASK                      0x00100000
#define _IFS1_ADCDF1IF_LENGTH                    0x00000001

#define _IFS1_ADCDF2IF_POSITION                  0x00000015
#define _IFS1_ADCDF2IF_MASK                      0x00200000
#define _IFS1_ADCDF2IF_LENGTH                    0x00000001

#define _IFS1_ADCDF3IF_POSITION                  0x00000016
#define _IFS1_ADCDF3IF_MASK                      0x00400000
#define _IFS1_ADCDF3IF_LENGTH                    0x00000001

#define _IFS1_ADCDF4IF_POSITION                  0x00000017
#define _IFS1_ADCDF4IF_MASK                      0x00800000
#define _IFS1_ADCDF4IF_LENGTH                    0x00000001

#define _IFS1_ADCDF5IF_POSITION                  0x00000018
#define _IFS1_ADCDF5IF_MASK                      0x01000000
#define _IFS1_ADCDF5IF_LENGTH                    0x00000001

#define _IFS1_ADCDF6IF_POSITION                  0x00000019
#define _IFS1_ADCDF6IF_MASK                      0x02000000
#define _IFS1_ADCDF6IF_LENGTH                    0x00000001

#define _IFS1_ADCFLTIF_POSITION                  0x0000001A
#define _IFS1_ADCFLTIF_MASK                      0x04000000
#define _IFS1_ADCFLTIF_LENGTH                    0x00000001

#define _IFS1_ADCD0IF_POSITION                   0x0000001B
#define _IFS1_ADCD0IF_MASK                       0x08000000
#define _IFS1_ADCD0IF_LENGTH                     0x00000001

#define _IFS1_ADCD1IF_POSITION                   0x0000001C
#define _IFS1_ADCD1IF_MASK                       0x10000000
#define _IFS1_ADCD1IF_LENGTH                     0x00000001

#define _IFS1_ADCD2IF_POSITION                   0x0000001D
#define _IFS1_ADCD2IF_MASK                       0x20000000
#define _IFS1_ADCD2IF_LENGTH                     0x00000001

#define _IFS1_ADCD3IF_POSITION                   0x0000001E
#define _IFS1_ADCD3IF_MASK                       0x40000000
#define _IFS1_ADCD3IF_LENGTH                     0x00000001

#define _IFS1_ADCD4IF_POSITION                   0x0000001F
#define _IFS1_ADCD4IF_MASK                       0x80000000
#define _IFS1_ADCD4IF_LENGTH                     0x00000001

#define _IFS1_w_POSITION                         0x00000000
#define _IFS1_w_MASK                             0xFFFFFFFF
#define _IFS1_w_LENGTH                           0x00000020

#define _IFS2_ADCD5IF_POSITION                   0x00000000
#define _IFS2_ADCD5IF_MASK                       0x00000001
#define _IFS2_ADCD5IF_LENGTH                     0x00000001

#define _IFS2_ADCD6IF_POSITION                   0x00000001
#define _IFS2_ADCD6IF_MASK                       0x00000002
#define _IFS2_ADCD6IF_LENGTH                     0x00000001

#define _IFS2_ADCD7IF_POSITION                   0x00000002
#define _IFS2_ADCD7IF_MASK                       0x00000004
#define _IFS2_ADCD7IF_LENGTH                     0x00000001

#define _IFS2_ADCD8IF_POSITION                   0x00000003
#define _IFS2_ADCD8IF_MASK                       0x00000008
#define _IFS2_ADCD8IF_LENGTH                     0x00000001

#define _IFS2_ADCD9IF_POSITION                   0x00000004
#define _IFS2_ADCD9IF_MASK                       0x00000010
#define _IFS2_ADCD9IF_LENGTH                     0x00000001

#define _IFS2_ADCD10IF_POSITION                  0x00000005
#define _IFS2_ADCD10IF_MASK                      0x00000020
#define _IFS2_ADCD10IF_LENGTH                    0x00000001

#define _IFS2_ADCD11IF_POSITION                  0x00000006
#define _IFS2_ADCD11IF_MASK                      0x00000040
#define _IFS2_ADCD11IF_LENGTH                    0x00000001

#define _IFS2_ADCD12IF_POSITION                  0x00000007
#define _IFS2_ADCD12IF_MASK                      0x00000080
#define _IFS2_ADCD12IF_LENGTH                    0x00000001

#define _IFS2_ADCD13IF_POSITION                  0x00000008
#define _IFS2_ADCD13IF_MASK                      0x00000100
#define _IFS2_ADCD13IF_LENGTH                    0x00000001

#define _IFS2_ADCD14IF_POSITION                  0x00000009
#define _IFS2_ADCD14IF_MASK                      0x00000200
#define _IFS2_ADCD14IF_LENGTH                    0x00000001

#define _IFS2_ADCD15IF_POSITION                  0x0000000A
#define _IFS2_ADCD15IF_MASK                      0x00000400
#define _IFS2_ADCD15IF_LENGTH                    0x00000001

#define _IFS2_ADCD16IF_POSITION                  0x0000000B
#define _IFS2_ADCD16IF_MASK                      0x00000800
#define _IFS2_ADCD16IF_LENGTH                    0x00000001

#define _IFS2_ADCD17IF_POSITION                  0x0000000C
#define _IFS2_ADCD17IF_MASK                      0x00001000
#define _IFS2_ADCD17IF_LENGTH                    0x00000001

#define _IFS2_ADCD18IF_POSITION                  0x0000000D
#define _IFS2_ADCD18IF_MASK                      0x00002000
#define _IFS2_ADCD18IF_LENGTH                    0x00000001

#define _IFS2_ADCD19IF_POSITION                  0x0000000E
#define _IFS2_ADCD19IF_MASK                      0x00004000
#define _IFS2_ADCD19IF_LENGTH                    0x00000001

#define _IFS2_ADCD20IF_POSITION                  0x0000000F
#define _IFS2_ADCD20IF_MASK                      0x00008000
#define _IFS2_ADCD20IF_LENGTH                    0x00000001

#define _IFS2_ADCD21IF_POSITION                  0x00000010
#define _IFS2_ADCD21IF_MASK                      0x00010000
#define _IFS2_ADCD21IF_LENGTH                    0x00000001

#define _IFS2_ADCD22IF_POSITION                  0x00000011
#define _IFS2_ADCD22IF_MASK                      0x00020000
#define _IFS2_ADCD22IF_LENGTH                    0x00000001

#define _IFS2_ADCD23IF_POSITION                  0x00000012
#define _IFS2_ADCD23IF_MASK                      0x00040000
#define _IFS2_ADCD23IF_LENGTH                    0x00000001

#define _IFS2_ADCD24IF_POSITION                  0x00000013
#define _IFS2_ADCD24IF_MASK                      0x00080000
#define _IFS2_ADCD24IF_LENGTH                    0x00000001

#define _IFS2_ADCD25IF_POSITION                  0x00000014
#define _IFS2_ADCD25IF_MASK                      0x00100000
#define _IFS2_ADCD25IF_LENGTH                    0x00000001

#define _IFS2_ADCD26IF_POSITION                  0x00000015
#define _IFS2_ADCD26IF_MASK                      0x00200000
#define _IFS2_ADCD26IF_LENGTH                    0x00000001

#define _IFS2_ADCD27IF_POSITION                  0x00000016
#define _IFS2_ADCD27IF_MASK                      0x00400000
#define _IFS2_ADCD27IF_LENGTH                    0x00000001

#define _IFS2_ADCD28IF_POSITION                  0x00000017
#define _IFS2_ADCD28IF_MASK                      0x00800000
#define _IFS2_ADCD28IF_LENGTH                    0x00000001

#define _IFS2_ADCD29IF_POSITION                  0x00000018
#define _IFS2_ADCD29IF_MASK                      0x01000000
#define _IFS2_ADCD29IF_LENGTH                    0x00000001

#define _IFS2_ADCD30IF_POSITION                  0x00000019
#define _IFS2_ADCD30IF_MASK                      0x02000000
#define _IFS2_ADCD30IF_LENGTH                    0x00000001

#define _IFS2_ADCD31IF_POSITION                  0x0000001A
#define _IFS2_ADCD31IF_MASK                      0x04000000
#define _IFS2_ADCD31IF_LENGTH                    0x00000001

#define _IFS2_ADCD32IF_POSITION                  0x0000001B
#define _IFS2_ADCD32IF_MASK                      0x08000000
#define _IFS2_ADCD32IF_LENGTH                    0x00000001

#define _IFS2_ADCD33IF_POSITION                  0x0000001C
#define _IFS2_ADCD33IF_MASK                      0x10000000
#define _IFS2_ADCD33IF_LENGTH                    0x00000001

#define _IFS2_ADCD34IF_POSITION                  0x0000001D
#define _IFS2_ADCD34IF_MASK                      0x20000000
#define _IFS2_ADCD34IF_LENGTH                    0x00000001

#define _IFS2_w_POSITION                         0x00000000
#define _IFS2_w_MASK                             0xFFFFFFFF
#define _IFS2_w_LENGTH                           0x00000020

#define _IFS3_ADCD43IF_POSITION                  0x00000006
#define _IFS3_ADCD43IF_MASK                      0x00000040
#define _IFS3_ADCD43IF_LENGTH                    0x00000001

#define _IFS3_ADCD44IF_POSITION                  0x00000007
#define _IFS3_ADCD44IF_MASK                      0x00000080
#define _IFS3_ADCD44IF_LENGTH                    0x00000001

#define _IFS3_CPCIF_POSITION                     0x00000008
#define _IFS3_CPCIF_MASK                         0x00000100
#define _IFS3_CPCIF_LENGTH                       0x00000001

#define _IFS3_CFDCIF_POSITION                    0x00000009
#define _IFS3_CFDCIF_MASK                        0x00000200
#define _IFS3_CFDCIF_LENGTH                      0x00000001

#define _IFS3_SBIF_POSITION                      0x0000000A
#define _IFS3_SBIF_MASK                          0x00000400
#define _IFS3_SBIF_LENGTH                        0x00000001

#define _IFS3_SPI1EIF_POSITION                   0x0000000D
#define _IFS3_SPI1EIF_MASK                       0x00002000
#define _IFS3_SPI1EIF_LENGTH                     0x00000001

#define _IFS3_SPI1RXIF_POSITION                  0x0000000E
#define _IFS3_SPI1RXIF_MASK                      0x00004000
#define _IFS3_SPI1RXIF_LENGTH                    0x00000001

#define _IFS3_SPI1TXIF_POSITION                  0x0000000F
#define _IFS3_SPI1TXIF_MASK                      0x00008000
#define _IFS3_SPI1TXIF_LENGTH                    0x00000001

#define _IFS3_U1EIF_POSITION                     0x00000010
#define _IFS3_U1EIF_MASK                         0x00010000
#define _IFS3_U1EIF_LENGTH                       0x00000001

#define _IFS3_U1RXIF_POSITION                    0x00000011
#define _IFS3_U1RXIF_MASK                        0x00020000
#define _IFS3_U1RXIF_LENGTH                      0x00000001

#define _IFS3_U1TXIF_POSITION                    0x00000012
#define _IFS3_U1TXIF_MASK                        0x00040000
#define _IFS3_U1TXIF_LENGTH                      0x00000001

#define _IFS3_I2C1BIF_POSITION                   0x00000013
#define _IFS3_I2C1BIF_MASK                       0x00080000
#define _IFS3_I2C1BIF_LENGTH                     0x00000001

#define _IFS3_I2C1SIF_POSITION                   0x00000014
#define _IFS3_I2C1SIF_MASK                       0x00100000
#define _IFS3_I2C1SIF_LENGTH                     0x00000001

#define _IFS3_I2C1MIF_POSITION                   0x00000015
#define _IFS3_I2C1MIF_MASK                       0x00200000
#define _IFS3_I2C1MIF_LENGTH                     0x00000001

#define _IFS3_CNAIF_POSITION                     0x00000016
#define _IFS3_CNAIF_MASK                         0x00400000
#define _IFS3_CNAIF_LENGTH                       0x00000001

#define _IFS3_CNBIF_POSITION                     0x00000017
#define _IFS3_CNBIF_MASK                         0x00800000
#define _IFS3_CNBIF_LENGTH                       0x00000001

#define _IFS3_CNCIF_POSITION                     0x00000018
#define _IFS3_CNCIF_MASK                         0x01000000
#define _IFS3_CNCIF_LENGTH                       0x00000001

#define _IFS3_CNDIF_POSITION                     0x00000019
#define _IFS3_CNDIF_MASK                         0x02000000
#define _IFS3_CNDIF_LENGTH                       0x00000001

#define _IFS3_CNEIF_POSITION                     0x0000001A
#define _IFS3_CNEIF_MASK                         0x04000000
#define _IFS3_CNEIF_LENGTH                       0x00000001

#define _IFS3_CNFIF_POSITION                     0x0000001B
#define _IFS3_CNFIF_MASK                         0x08000000
#define _IFS3_CNFIF_LENGTH                       0x00000001

#define _IFS3_CNGIF_POSITION                     0x0000001C
#define _IFS3_CNGIF_MASK                         0x10000000
#define _IFS3_CNGIF_LENGTH                       0x00000001

#define _IFS3_w_POSITION                         0x00000000
#define _IFS3_w_MASK                             0xFFFFFFFF
#define _IFS3_w_LENGTH                           0x00000020

#define _IFS4_PMPIF_POSITION                     0x00000000
#define _IFS4_PMPIF_MASK                         0x00000001
#define _IFS4_PMPIF_LENGTH                       0x00000001

#define _IFS4_PMPEIF_POSITION                    0x00000001
#define _IFS4_PMPEIF_MASK                        0x00000002
#define _IFS4_PMPEIF_LENGTH                      0x00000001

#define _IFS4_CMP1IF_POSITION                    0x00000002
#define _IFS4_CMP1IF_MASK                        0x00000004
#define _IFS4_CMP1IF_LENGTH                      0x00000001

#define _IFS4_CMP2IF_POSITION                    0x00000003
#define _IFS4_CMP2IF_MASK                        0x00000008
#define _IFS4_CMP2IF_LENGTH                      0x00000001

#define _IFS4_USBIF_POSITION                     0x00000004
#define _IFS4_USBIF_MASK                         0x00000010
#define _IFS4_USBIF_LENGTH                       0x00000001

#define _IFS4_USBDMAIF_POSITION                  0x00000005
#define _IFS4_USBDMAIF_MASK                      0x00000020
#define _IFS4_USBDMAIF_LENGTH                    0x00000001

#define _IFS4_DMA0IF_POSITION                    0x00000006
#define _IFS4_DMA0IF_MASK                        0x00000040
#define _IFS4_DMA0IF_LENGTH                      0x00000001

#define _IFS4_DMA1IF_POSITION                    0x00000007
#define _IFS4_DMA1IF_MASK                        0x00000080
#define _IFS4_DMA1IF_LENGTH                      0x00000001

#define _IFS4_DMA2IF_POSITION                    0x00000008
#define _IFS4_DMA2IF_MASK                        0x00000100
#define _IFS4_DMA2IF_LENGTH                      0x00000001

#define _IFS4_DMA3IF_POSITION                    0x00000009
#define _IFS4_DMA3IF_MASK                        0x00000200
#define _IFS4_DMA3IF_LENGTH                      0x00000001

#define _IFS4_DMA4IF_POSITION                    0x0000000A
#define _IFS4_DMA4IF_MASK                        0x00000400
#define _IFS4_DMA4IF_LENGTH                      0x00000001

#define _IFS4_DMA5IF_POSITION                    0x0000000B
#define _IFS4_DMA5IF_MASK                        0x00000800
#define _IFS4_DMA5IF_LENGTH                      0x00000001

#define _IFS4_DMA6IF_POSITION                    0x0000000C
#define _IFS4_DMA6IF_MASK                        0x00001000
#define _IFS4_DMA6IF_LENGTH                      0x00000001

#define _IFS4_DMA7IF_POSITION                    0x0000000D
#define _IFS4_DMA7IF_MASK                        0x00002000
#define _IFS4_DMA7IF_LENGTH                      0x00000001

#define _IFS4_SPI2EIF_POSITION                   0x0000000E
#define _IFS4_SPI2EIF_MASK                       0x00004000
#define _IFS4_SPI2EIF_LENGTH                     0x00000001

#define _IFS4_SPI2RXIF_POSITION                  0x0000000F
#define _IFS4_SPI2RXIF_MASK                      0x00008000
#define _IFS4_SPI2RXIF_LENGTH                    0x00000001

#define _IFS4_SPI2TXIF_POSITION                  0x00000010
#define _IFS4_SPI2TXIF_MASK                      0x00010000
#define _IFS4_SPI2TXIF_LENGTH                    0x00000001

#define _IFS4_U2EIF_POSITION                     0x00000011
#define _IFS4_U2EIF_MASK                         0x00020000
#define _IFS4_U2EIF_LENGTH                       0x00000001

#define _IFS4_U2RXIF_POSITION                    0x00000012
#define _IFS4_U2RXIF_MASK                        0x00040000
#define _IFS4_U2RXIF_LENGTH                      0x00000001

#define _IFS4_U2TXIF_POSITION                    0x00000013
#define _IFS4_U2TXIF_MASK                        0x00080000
#define _IFS4_U2TXIF_LENGTH                      0x00000001

#define _IFS4_I2C2BIF_POSITION                   0x00000014
#define _IFS4_I2C2BIF_MASK                       0x00100000
#define _IFS4_I2C2BIF_LENGTH                     0x00000001

#define _IFS4_I2C2SIF_POSITION                   0x00000015
#define _IFS4_I2C2SIF_MASK                       0x00200000
#define _IFS4_I2C2SIF_LENGTH                     0x00000001

#define _IFS4_I2C2MIF_POSITION                   0x00000016
#define _IFS4_I2C2MIF_MASK                       0x00400000
#define _IFS4_I2C2MIF_LENGTH                     0x00000001

#define _IFS4_ETHIF_POSITION                     0x00000019
#define _IFS4_ETHIF_MASK                         0x02000000
#define _IFS4_ETHIF_LENGTH                       0x00000001

#define _IFS4_SPI3EIF_POSITION                   0x0000001A
#define _IFS4_SPI3EIF_MASK                       0x04000000
#define _IFS4_SPI3EIF_LENGTH                     0x00000001

#define _IFS4_SPI3RXIF_POSITION                  0x0000001B
#define _IFS4_SPI3RXIF_MASK                      0x08000000
#define _IFS4_SPI3RXIF_LENGTH                    0x00000001

#define _IFS4_SPI3TXIF_POSITION                  0x0000001C
#define _IFS4_SPI3TXIF_MASK                      0x10000000
#define _IFS4_SPI3TXIF_LENGTH                    0x00000001

#define _IFS4_U3EIF_POSITION                     0x0000001D
#define _IFS4_U3EIF_MASK                         0x20000000
#define _IFS4_U3EIF_LENGTH                       0x00000001

#define _IFS4_U3RXIF_POSITION                    0x0000001E
#define _IFS4_U3RXIF_MASK                        0x40000000
#define _IFS4_U3RXIF_LENGTH                      0x00000001

#define _IFS4_U3TXIF_POSITION                    0x0000001F
#define _IFS4_U3TXIF_MASK                        0x80000000
#define _IFS4_U3TXIF_LENGTH                      0x00000001

#define _IFS4_w_POSITION                         0x00000000
#define _IFS4_w_MASK                             0xFFFFFFFF
#define _IFS4_w_LENGTH                           0x00000020

#define _IFS5_I2C3BIF_POSITION                   0x00000000
#define _IFS5_I2C3BIF_MASK                       0x00000001
#define _IFS5_I2C3BIF_LENGTH                     0x00000001

#define _IFS5_I2C3SIF_POSITION                   0x00000001
#define _IFS5_I2C3SIF_MASK                       0x00000002
#define _IFS5_I2C3SIF_LENGTH                     0x00000001

#define _IFS5_I2C3MIF_POSITION                   0x00000002
#define _IFS5_I2C3MIF_MASK                       0x00000004
#define _IFS5_I2C3MIF_LENGTH                     0x00000001

#define _IFS5_SPI4EIF_POSITION                   0x00000003
#define _IFS5_SPI4EIF_MASK                       0x00000008
#define _IFS5_SPI4EIF_LENGTH                     0x00000001

#define _IFS5_SPI4RXIF_POSITION                  0x00000004
#define _IFS5_SPI4RXIF_MASK                      0x00000010
#define _IFS5_SPI4RXIF_LENGTH                    0x00000001

#define _IFS5_SPI4TXIF_POSITION                  0x00000005
#define _IFS5_SPI4TXIF_MASK                      0x00000020
#define _IFS5_SPI4TXIF_LENGTH                    0x00000001

#define _IFS5_RTCCIF_POSITION                    0x00000006
#define _IFS5_RTCCIF_MASK                        0x00000040
#define _IFS5_RTCCIF_LENGTH                      0x00000001

#define _IFS5_FCEIF_POSITION                     0x00000007
#define _IFS5_FCEIF_MASK                         0x00000080
#define _IFS5_FCEIF_LENGTH                       0x00000001

#define _IFS5_PREIF_POSITION                     0x00000008
#define _IFS5_PREIF_MASK                         0x00000100
#define _IFS5_PREIF_LENGTH                       0x00000001

#define _IFS5_SQI1IF_POSITION                    0x00000009
#define _IFS5_SQI1IF_MASK                        0x00000200
#define _IFS5_SQI1IF_LENGTH                      0x00000001

#define _IFS5_U4EIF_POSITION                     0x0000000A
#define _IFS5_U4EIF_MASK                         0x00000400
#define _IFS5_U4EIF_LENGTH                       0x00000001

#define _IFS5_U4RXIF_POSITION                    0x0000000B
#define _IFS5_U4RXIF_MASK                        0x00000800
#define _IFS5_U4RXIF_LENGTH                      0x00000001

#define _IFS5_U4TXIF_POSITION                    0x0000000C
#define _IFS5_U4TXIF_MASK                        0x00001000
#define _IFS5_U4TXIF_LENGTH                      0x00000001

#define _IFS5_I2C4BIF_POSITION                   0x0000000D
#define _IFS5_I2C4BIF_MASK                       0x00002000
#define _IFS5_I2C4BIF_LENGTH                     0x00000001

#define _IFS5_I2C4SIF_POSITION                   0x0000000E
#define _IFS5_I2C4SIF_MASK                       0x00004000
#define _IFS5_I2C4SIF_LENGTH                     0x00000001

#define _IFS5_I2C4MIF_POSITION                   0x0000000F
#define _IFS5_I2C4MIF_MASK                       0x00008000
#define _IFS5_I2C4MIF_LENGTH                     0x00000001

#define _IFS5_SPI5EIF_POSITION                   0x00000010
#define _IFS5_SPI5EIF_MASK                       0x00010000
#define _IFS5_SPI5EIF_LENGTH                     0x00000001

#define _IFS5_SPI5RXIF_POSITION                  0x00000011
#define _IFS5_SPI5RXIF_MASK                      0x00020000
#define _IFS5_SPI5RXIF_LENGTH                    0x00000001

#define _IFS5_SPI5TXIF_POSITION                  0x00000012
#define _IFS5_SPI5TXIF_MASK                      0x00040000
#define _IFS5_SPI5TXIF_LENGTH                    0x00000001

#define _IFS5_U5EIF_POSITION                     0x00000013
#define _IFS5_U5EIF_MASK                         0x00080000
#define _IFS5_U5EIF_LENGTH                       0x00000001

#define _IFS5_U5RXIF_POSITION                    0x00000014
#define _IFS5_U5RXIF_MASK                        0x00100000
#define _IFS5_U5RXIF_LENGTH                      0x00000001

#define _IFS5_U5TXIF_POSITION                    0x00000015
#define _IFS5_U5TXIF_MASK                        0x00200000
#define _IFS5_U5TXIF_LENGTH                      0x00000001

#define _IFS5_I2C5BIF_POSITION                   0x00000016
#define _IFS5_I2C5BIF_MASK                       0x00400000
#define _IFS5_I2C5BIF_LENGTH                     0x00000001

#define _IFS5_I2C5SIF_POSITION                   0x00000017
#define _IFS5_I2C5SIF_MASK                       0x00800000
#define _IFS5_I2C5SIF_LENGTH                     0x00000001

#define _IFS5_I2C5MIF_POSITION                   0x00000018
#define _IFS5_I2C5MIF_MASK                       0x01000000
#define _IFS5_I2C5MIF_LENGTH                     0x00000001

#define _IFS5_SPI6IF_POSITION                    0x00000019
#define _IFS5_SPI6IF_MASK                        0x02000000
#define _IFS5_SPI6IF_LENGTH                      0x00000001

#define _IFS5_SPI6RXIF_POSITION                  0x0000001A
#define _IFS5_SPI6RXIF_MASK                      0x04000000
#define _IFS5_SPI6RXIF_LENGTH                    0x00000001

#define _IFS5_SPI6TX_POSITION                    0x0000001B
#define _IFS5_SPI6TX_MASK                        0x08000000
#define _IFS5_SPI6TX_LENGTH                      0x00000001

#define _IFS5_U6EIF_POSITION                     0x0000001C
#define _IFS5_U6EIF_MASK                         0x10000000
#define _IFS5_U6EIF_LENGTH                       0x00000001

#define _IFS5_U6RXIF_POSITION                    0x0000001D
#define _IFS5_U6RXIF_MASK                        0x20000000
#define _IFS5_U6RXIF_LENGTH                      0x00000001

#define _IFS5_U6TXIF_POSITION                    0x0000001E
#define _IFS5_U6TXIF_MASK                        0x40000000
#define _IFS5_U6TXIF_LENGTH                      0x00000001

#define _IFS5_w_POSITION                         0x00000000
#define _IFS5_w_MASK                             0xFFFFFFFF
#define _IFS5_w_LENGTH                           0x00000020

#define _IFS6_ADCEOSIF_POSITION                  0x00000000
#define _IFS6_ADCEOSIF_MASK                      0x00000001
#define _IFS6_ADCEOSIF_LENGTH                    0x00000001

#define _IFS6_ADCARDYIF_POSITION                 0x00000001
#define _IFS6_ADCARDYIF_MASK                     0x00000002
#define _IFS6_ADCARDYIF_LENGTH                   0x00000001

#define _IFS6_ADCURDYIF_POSITION                 0x00000002
#define _IFS6_ADCURDYIF_MASK                     0x00000004
#define _IFS6_ADCURDYIF_LENGTH                   0x00000001

#define _IFS6_ADCGRPIF_POSITION                  0x00000004
#define _IFS6_ADCGRPIF_MASK                      0x00000010
#define _IFS6_ADCGRPIF_LENGTH                    0x00000001

#define _IFS6_ADC0EIF_POSITION                   0x00000006
#define _IFS6_ADC0EIF_MASK                       0x00000040
#define _IFS6_ADC0EIF_LENGTH                     0x00000001

#define _IFS6_ADC1EIF_POSITION                   0x00000007
#define _IFS6_ADC1EIF_MASK                       0x00000080
#define _IFS6_ADC1EIF_LENGTH                     0x00000001

#define _IFS6_ADC2EIF_POSITION                   0x00000008
#define _IFS6_ADC2EIF_MASK                       0x00000100
#define _IFS6_ADC2EIF_LENGTH                     0x00000001

#define _IFS6_ADC3EIF_POSITION                   0x00000009
#define _IFS6_ADC3EIF_MASK                       0x00000200
#define _IFS6_ADC3EIF_LENGTH                     0x00000001

#define _IFS6_ADC4EIF_POSITION                   0x0000000A
#define _IFS6_ADC4EIF_MASK                       0x00000400
#define _IFS6_ADC4EIF_LENGTH                     0x00000001

#define _IFS6_ADC7EIF_POSITION                   0x0000000D
#define _IFS6_ADC7EIF_MASK                       0x00002000
#define _IFS6_ADC7EIF_LENGTH                     0x00000001

#define _IFS6_ADC0WIF_POSITION                   0x0000000E
#define _IFS6_ADC0WIF_MASK                       0x00004000
#define _IFS6_ADC0WIF_LENGTH                     0x00000001

#define _IFS6_ADC1WIF_POSITION                   0x0000000F
#define _IFS6_ADC1WIF_MASK                       0x00008000
#define _IFS6_ADC1WIF_LENGTH                     0x00000001

#define _IFS6_ADC2WIF_POSITION                   0x00000010
#define _IFS6_ADC2WIF_MASK                       0x00010000
#define _IFS6_ADC2WIF_LENGTH                     0x00000001

#define _IFS6_ADC3WIF_POSITION                   0x00000011
#define _IFS6_ADC3WIF_MASK                       0x00020000
#define _IFS6_ADC3WIF_LENGTH                     0x00000001

#define _IFS6_ADC4WIF_POSITION                   0x00000012
#define _IFS6_ADC4WIF_MASK                       0x00040000
#define _IFS6_ADC4WIF_LENGTH                     0x00000001

#define _IFS6_ADC7WIF_POSITION                   0x00000015
#define _IFS6_ADC7WIF_MASK                       0x00200000
#define _IFS6_ADC7WIF_LENGTH                     0x00000001

#define _IFS6_w_POSITION                         0x00000000
#define _IFS6_w_MASK                             0xFFFFFFFF
#define _IFS6_w_LENGTH                           0x00000020

#define _IEC0_CTIE_POSITION                      0x00000000
#define _IEC0_CTIE_MASK                          0x00000001
#define _IEC0_CTIE_LENGTH                        0x00000001

#define _IEC0_CS0IE_POSITION                     0x00000001
#define _IEC0_CS0IE_MASK                         0x00000002
#define _IEC0_CS0IE_LENGTH                       0x00000001

#define _IEC0_CS1IE_POSITION                     0x00000002
#define _IEC0_CS1IE_MASK                         0x00000004
#define _IEC0_CS1IE_LENGTH                       0x00000001

#define _IEC0_INT0IE_POSITION                    0x00000003
#define _IEC0_INT0IE_MASK                        0x00000008
#define _IEC0_INT0IE_LENGTH                      0x00000001

#define _IEC0_T1IE_POSITION                      0x00000004
#define _IEC0_T1IE_MASK                          0x00000010
#define _IEC0_T1IE_LENGTH                        0x00000001

#define _IEC0_IC1EIE_POSITION                    0x00000005
#define _IEC0_IC1EIE_MASK                        0x00000020
#define _IEC0_IC1EIE_LENGTH                      0x00000001

#define _IEC0_IC1IE_POSITION                     0x00000006
#define _IEC0_IC1IE_MASK                         0x00000040
#define _IEC0_IC1IE_LENGTH                       0x00000001

#define _IEC0_OC1IE_POSITION                     0x00000007
#define _IEC0_OC1IE_MASK                         0x00000080
#define _IEC0_OC1IE_LENGTH                       0x00000001

#define _IEC0_INT1IE_POSITION                    0x00000008
#define _IEC0_INT1IE_MASK                        0x00000100
#define _IEC0_INT1IE_LENGTH                      0x00000001

#define _IEC0_T2IE_POSITION                      0x00000009
#define _IEC0_T2IE_MASK                          0x00000200
#define _IEC0_T2IE_LENGTH                        0x00000001

#define _IEC0_IC2EIE_POSITION                    0x0000000A
#define _IEC0_IC2EIE_MASK                        0x00000400
#define _IEC0_IC2EIE_LENGTH                      0x00000001

#define _IEC0_IC2IE_POSITION                     0x0000000B
#define _IEC0_IC2IE_MASK                         0x00000800
#define _IEC0_IC2IE_LENGTH                       0x00000001

#define _IEC0_OC2IE_POSITION                     0x0000000C
#define _IEC0_OC2IE_MASK                         0x00001000
#define _IEC0_OC2IE_LENGTH                       0x00000001

#define _IEC0_INT2IE_POSITION                    0x0000000D
#define _IEC0_INT2IE_MASK                        0x00002000
#define _IEC0_INT2IE_LENGTH                      0x00000001

#define _IEC0_T3IE_POSITION                      0x0000000E
#define _IEC0_T3IE_MASK                          0x00004000
#define _IEC0_T3IE_LENGTH                        0x00000001

#define _IEC0_IC3EIE_POSITION                    0x0000000F
#define _IEC0_IC3EIE_MASK                        0x00008000
#define _IEC0_IC3EIE_LENGTH                      0x00000001

#define _IEC0_IC3IE_POSITION                     0x00000010
#define _IEC0_IC3IE_MASK                         0x00010000
#define _IEC0_IC3IE_LENGTH                       0x00000001

#define _IEC0_OC3IE_POSITION                     0x00000011
#define _IEC0_OC3IE_MASK                         0x00020000
#define _IEC0_OC3IE_LENGTH                       0x00000001

#define _IEC0_INT3IE_POSITION                    0x00000012
#define _IEC0_INT3IE_MASK                        0x00040000
#define _IEC0_INT3IE_LENGTH                      0x00000001

#define _IEC0_T4IE_POSITION                      0x00000013
#define _IEC0_T4IE_MASK                          0x00080000
#define _IEC0_T4IE_LENGTH                        0x00000001

#define _IEC0_IC4EIE_POSITION                    0x00000014
#define _IEC0_IC4EIE_MASK                        0x00100000
#define _IEC0_IC4EIE_LENGTH                      0x00000001

#define _IEC0_IC4IE_POSITION                     0x00000015
#define _IEC0_IC4IE_MASK                         0x00200000
#define _IEC0_IC4IE_LENGTH                       0x00000001

#define _IEC0_OC4IE_POSITION                     0x00000016
#define _IEC0_OC4IE_MASK                         0x00400000
#define _IEC0_OC4IE_LENGTH                       0x00000001

#define _IEC0_INT4IE_POSITION                    0x00000017
#define _IEC0_INT4IE_MASK                        0x00800000
#define _IEC0_INT4IE_LENGTH                      0x00000001

#define _IEC0_T5IE_POSITION                      0x00000018
#define _IEC0_T5IE_MASK                          0x01000000
#define _IEC0_T5IE_LENGTH                        0x00000001

#define _IEC0_IC5EIE_POSITION                    0x00000019
#define _IEC0_IC5EIE_MASK                        0x02000000
#define _IEC0_IC5EIE_LENGTH                      0x00000001

#define _IEC0_IC5IE_POSITION                     0x0000001A
#define _IEC0_IC5IE_MASK                         0x04000000
#define _IEC0_IC5IE_LENGTH                       0x00000001

#define _IEC0_OC5IE_POSITION                     0x0000001B
#define _IEC0_OC5IE_MASK                         0x08000000
#define _IEC0_OC5IE_LENGTH                       0x00000001

#define _IEC0_T6IE_POSITION                      0x0000001C
#define _IEC0_T6IE_MASK                          0x10000000
#define _IEC0_T6IE_LENGTH                        0x00000001

#define _IEC0_IC6EIE_POSITION                    0x0000001D
#define _IEC0_IC6EIE_MASK                        0x20000000
#define _IEC0_IC6EIE_LENGTH                      0x00000001

#define _IEC0_IC6IE_POSITION                     0x0000001E
#define _IEC0_IC6IE_MASK                         0x40000000
#define _IEC0_IC6IE_LENGTH                       0x00000001

#define _IEC0_OC6IE_POSITION                     0x0000001F
#define _IEC0_OC6IE_MASK                         0x80000000
#define _IEC0_OC6IE_LENGTH                       0x00000001

#define _IEC0_w_POSITION                         0x00000000
#define _IEC0_w_MASK                             0xFFFFFFFF
#define _IEC0_w_LENGTH                           0x00000020

#define _IEC1_T7IE_POSITION                      0x00000000
#define _IEC1_T7IE_MASK                          0x00000001
#define _IEC1_T7IE_LENGTH                        0x00000001

#define _IEC1_IC7EIE_POSITION                    0x00000001
#define _IEC1_IC7EIE_MASK                        0x00000002
#define _IEC1_IC7EIE_LENGTH                      0x00000001

#define _IEC1_IC7IE_POSITION                     0x00000002
#define _IEC1_IC7IE_MASK                         0x00000004
#define _IEC1_IC7IE_LENGTH                       0x00000001

#define _IEC1_OC7IE_POSITION                     0x00000003
#define _IEC1_OC7IE_MASK                         0x00000008
#define _IEC1_OC7IE_LENGTH                       0x00000001

#define _IEC1_T8IE_POSITION                      0x00000004
#define _IEC1_T8IE_MASK                          0x00000010
#define _IEC1_T8IE_LENGTH                        0x00000001

#define _IEC1_IC8EIE_POSITION                    0x00000005
#define _IEC1_IC8EIE_MASK                        0x00000020
#define _IEC1_IC8EIE_LENGTH                      0x00000001

#define _IEC1_IC8IE_POSITION                     0x00000006
#define _IEC1_IC8IE_MASK                         0x00000040
#define _IEC1_IC8IE_LENGTH                       0x00000001

#define _IEC1_OC8IE_POSITION                     0x00000007
#define _IEC1_OC8IE_MASK                         0x00000080
#define _IEC1_OC8IE_LENGTH                       0x00000001

#define _IEC1_T9IE_POSITION                      0x00000008
#define _IEC1_T9IE_MASK                          0x00000100
#define _IEC1_T9IE_LENGTH                        0x00000001

#define _IEC1_IC9EIE_POSITION                    0x00000009
#define _IEC1_IC9EIE_MASK                        0x00000200
#define _IEC1_IC9EIE_LENGTH                      0x00000001

#define _IEC1_IC9IE_POSITION                     0x0000000A
#define _IEC1_IC9IE_MASK                         0x00000400
#define _IEC1_IC9IE_LENGTH                       0x00000001

#define _IEC1_OC9IE_POSITION                     0x0000000B
#define _IEC1_OC9IE_MASK                         0x00000800
#define _IEC1_OC9IE_LENGTH                       0x00000001

#define _IEC1_ADCIE_POSITION                     0x0000000C
#define _IEC1_ADCIE_MASK                         0x00001000
#define _IEC1_ADCIE_LENGTH                       0x00000001

#define _IEC1_ADCFIFOIE_POSITION                 0x0000000D
#define _IEC1_ADCFIFOIE_MASK                     0x00002000
#define _IEC1_ADCFIFOIE_LENGTH                   0x00000001

#define _IEC1_ADCDC1IE_POSITION                  0x0000000E
#define _IEC1_ADCDC1IE_MASK                      0x00004000
#define _IEC1_ADCDC1IE_LENGTH                    0x00000001

#define _IEC1_ADCDC2IE_POSITION                  0x0000000F
#define _IEC1_ADCDC2IE_MASK                      0x00008000
#define _IEC1_ADCDC2IE_LENGTH                    0x00000001

#define _IEC1_ADCDC3IE_POSITION                  0x00000010
#define _IEC1_ADCDC3IE_MASK                      0x00010000
#define _IEC1_ADCDC3IE_LENGTH                    0x00000001

#define _IEC1_ADCDC4IE_POSITION                  0x00000011
#define _IEC1_ADCDC4IE_MASK                      0x00020000
#define _IEC1_ADCDC4IE_LENGTH                    0x00000001

#define _IEC1_ADCDC5IE_POSITION                  0x00000012
#define _IEC1_ADCDC5IE_MASK                      0x00040000
#define _IEC1_ADCDC5IE_LENGTH                    0x00000001

#define _IEC1_ADCDC6IE_POSITION                  0x00000013
#define _IEC1_ADCDC6IE_MASK                      0x00080000
#define _IEC1_ADCDC6IE_LENGTH                    0x00000001

#define _IEC1_ADCDF1IE_POSITION                  0x00000014
#define _IEC1_ADCDF1IE_MASK                      0x00100000
#define _IEC1_ADCDF1IE_LENGTH                    0x00000001

#define _IEC1_ADCDF2IE_POSITION                  0x00000015
#define _IEC1_ADCDF2IE_MASK                      0x00200000
#define _IEC1_ADCDF2IE_LENGTH                    0x00000001

#define _IEC1_ADCDF3IE_POSITION                  0x00000016
#define _IEC1_ADCDF3IE_MASK                      0x00400000
#define _IEC1_ADCDF3IE_LENGTH                    0x00000001

#define _IEC1_ADCDF4IE_POSITION                  0x00000017
#define _IEC1_ADCDF4IE_MASK                      0x00800000
#define _IEC1_ADCDF4IE_LENGTH                    0x00000001

#define _IEC1_ADCDF5IE_POSITION                  0x00000018
#define _IEC1_ADCDF5IE_MASK                      0x01000000
#define _IEC1_ADCDF5IE_LENGTH                    0x00000001

#define _IEC1_ADCDF6IE_POSITION                  0x00000019
#define _IEC1_ADCDF6IE_MASK                      0x02000000
#define _IEC1_ADCDF6IE_LENGTH                    0x00000001

#define _IEC1_ADCFLTIE_POSITION                  0x0000001A
#define _IEC1_ADCFLTIE_MASK                      0x04000000
#define _IEC1_ADCFLTIE_LENGTH                    0x00000001

#define _IEC1_ADCD0IE_POSITION                   0x0000001B
#define _IEC1_ADCD0IE_MASK                       0x08000000
#define _IEC1_ADCD0IE_LENGTH                     0x00000001

#define _IEC1_ADCD1IE_POSITION                   0x0000001C
#define _IEC1_ADCD1IE_MASK                       0x10000000
#define _IEC1_ADCD1IE_LENGTH                     0x00000001

#define _IEC1_ADCD2IE_POSITION                   0x0000001D
#define _IEC1_ADCD2IE_MASK                       0x20000000
#define _IEC1_ADCD2IE_LENGTH                     0x00000001

#define _IEC1_ADCD3IE_POSITION                   0x0000001E
#define _IEC1_ADCD3IE_MASK                       0x40000000
#define _IEC1_ADCD3IE_LENGTH                     0x00000001

#define _IEC1_ADCD4IE_POSITION                   0x0000001F
#define _IEC1_ADCD4IE_MASK                       0x80000000
#define _IEC1_ADCD4IE_LENGTH                     0x00000001

#define _IEC1_w_POSITION                         0x00000000
#define _IEC1_w_MASK                             0xFFFFFFFF
#define _IEC1_w_LENGTH                           0x00000020

#define _IEC2_ADCD5IE_POSITION                   0x00000000
#define _IEC2_ADCD5IE_MASK                       0x00000001
#define _IEC2_ADCD5IE_LENGTH                     0x00000001

#define _IEC2_ADCD6IE_POSITION                   0x00000001
#define _IEC2_ADCD6IE_MASK                       0x00000002
#define _IEC2_ADCD6IE_LENGTH                     0x00000001

#define _IEC2_ADCD7IE_POSITION                   0x00000002
#define _IEC2_ADCD7IE_MASK                       0x00000004
#define _IEC2_ADCD7IE_LENGTH                     0x00000001

#define _IEC2_ADCD8IE_POSITION                   0x00000003
#define _IEC2_ADCD8IE_MASK                       0x00000008
#define _IEC2_ADCD8IE_LENGTH                     0x00000001

#define _IEC2_ADCD9IE_POSITION                   0x00000004
#define _IEC2_ADCD9IE_MASK                       0x00000010
#define _IEC2_ADCD9IE_LENGTH                     0x00000001

#define _IEC2_ADCD10IE_POSITION                  0x00000005
#define _IEC2_ADCD10IE_MASK                      0x00000020
#define _IEC2_ADCD10IE_LENGTH                    0x00000001

#define _IEC2_ADCD11IE_POSITION                  0x00000006
#define _IEC2_ADCD11IE_MASK                      0x00000040
#define _IEC2_ADCD11IE_LENGTH                    0x00000001

#define _IEC2_ADCD12IE_POSITION                  0x00000007
#define _IEC2_ADCD12IE_MASK                      0x00000080
#define _IEC2_ADCD12IE_LENGTH                    0x00000001

#define _IEC2_ADCD13IE_POSITION                  0x00000008
#define _IEC2_ADCD13IE_MASK                      0x00000100
#define _IEC2_ADCD13IE_LENGTH                    0x00000001

#define _IEC2_ADCD14IE_POSITION                  0x00000009
#define _IEC2_ADCD14IE_MASK                      0x00000200
#define _IEC2_ADCD14IE_LENGTH                    0x00000001

#define _IEC2_ADCD15IE_POSITION                  0x0000000A
#define _IEC2_ADCD15IE_MASK                      0x00000400
#define _IEC2_ADCD15IE_LENGTH                    0x00000001

#define _IEC2_ADCD16IE_POSITION                  0x0000000B
#define _IEC2_ADCD16IE_MASK                      0x00000800
#define _IEC2_ADCD16IE_LENGTH                    0x00000001

#define _IEC2_ADCD17IE_POSITION                  0x0000000C
#define _IEC2_ADCD17IE_MASK                      0x00001000
#define _IEC2_ADCD17IE_LENGTH                    0x00000001

#define _IEC2_ADCD18IE_POSITION                  0x0000000D
#define _IEC2_ADCD18IE_MASK                      0x00002000
#define _IEC2_ADCD18IE_LENGTH                    0x00000001

#define _IEC2_ADCD19IE_POSITION                  0x0000000E
#define _IEC2_ADCD19IE_MASK                      0x00004000
#define _IEC2_ADCD19IE_LENGTH                    0x00000001

#define _IEC2_ADCD20IE_POSITION                  0x0000000F
#define _IEC2_ADCD20IE_MASK                      0x00008000
#define _IEC2_ADCD20IE_LENGTH                    0x00000001

#define _IEC2_ADCD21IE_POSITION                  0x00000010
#define _IEC2_ADCD21IE_MASK                      0x00010000
#define _IEC2_ADCD21IE_LENGTH                    0x00000001

#define _IEC2_ADCD22IE_POSITION                  0x00000011
#define _IEC2_ADCD22IE_MASK                      0x00020000
#define _IEC2_ADCD22IE_LENGTH                    0x00000001

#define _IEC2_ADCD23IE_POSITION                  0x00000012
#define _IEC2_ADCD23IE_MASK                      0x00040000
#define _IEC2_ADCD23IE_LENGTH                    0x00000001

#define _IEC2_ADCD24IE_POSITION                  0x00000013
#define _IEC2_ADCD24IE_MASK                      0x00080000
#define _IEC2_ADCD24IE_LENGTH                    0x00000001

#define _IEC2_ADCD25IE_POSITION                  0x00000014
#define _IEC2_ADCD25IE_MASK                      0x00100000
#define _IEC2_ADCD25IE_LENGTH                    0x00000001

#define _IEC2_ADCD26IE_POSITION                  0x00000015
#define _IEC2_ADCD26IE_MASK                      0x00200000
#define _IEC2_ADCD26IE_LENGTH                    0x00000001

#define _IEC2_ADCD27IE_POSITION                  0x00000016
#define _IEC2_ADCD27IE_MASK                      0x00400000
#define _IEC2_ADCD27IE_LENGTH                    0x00000001

#define _IEC2_ADCD28IE_POSITION                  0x00000017
#define _IEC2_ADCD28IE_MASK                      0x00800000
#define _IEC2_ADCD28IE_LENGTH                    0x00000001

#define _IEC2_ADCD29IE_POSITION                  0x00000018
#define _IEC2_ADCD29IE_MASK                      0x01000000
#define _IEC2_ADCD29IE_LENGTH                    0x00000001

#define _IEC2_ADCD30IE_POSITION                  0x00000019
#define _IEC2_ADCD30IE_MASK                      0x02000000
#define _IEC2_ADCD30IE_LENGTH                    0x00000001

#define _IEC2_ADCD31IE_POSITION                  0x0000001A
#define _IEC2_ADCD31IE_MASK                      0x04000000
#define _IEC2_ADCD31IE_LENGTH                    0x00000001

#define _IEC2_ADCD32IE_POSITION                  0x0000001B
#define _IEC2_ADCD32IE_MASK                      0x08000000
#define _IEC2_ADCD32IE_LENGTH                    0x00000001

#define _IEC2_ADCD33IE_POSITION                  0x0000001C
#define _IEC2_ADCD33IE_MASK                      0x10000000
#define _IEC2_ADCD33IE_LENGTH                    0x00000001

#define _IEC2_ADCD34IE_POSITION                  0x0000001D
#define _IEC2_ADCD34IE_MASK                      0x20000000
#define _IEC2_ADCD34IE_LENGTH                    0x00000001

#define _IEC2_w_POSITION                         0x00000000
#define _IEC2_w_MASK                             0xFFFFFFFF
#define _IEC2_w_LENGTH                           0x00000020

#define _IEC3_ADCD43IE_POSITION                  0x00000006
#define _IEC3_ADCD43IE_MASK                      0x00000040
#define _IEC3_ADCD43IE_LENGTH                    0x00000001

#define _IEC3_ADCD44IE_POSITION                  0x00000007
#define _IEC3_ADCD44IE_MASK                      0x00000080
#define _IEC3_ADCD44IE_LENGTH                    0x00000001

#define _IEC3_CPCIE_POSITION                     0x00000008
#define _IEC3_CPCIE_MASK                         0x00000100
#define _IEC3_CPCIE_LENGTH                       0x00000001

#define _IEC3_CFDCIE_POSITION                    0x00000009
#define _IEC3_CFDCIE_MASK                        0x00000200
#define _IEC3_CFDCIE_LENGTH                      0x00000001

#define _IEC3_SBIE_POSITION                      0x0000000A
#define _IEC3_SBIE_MASK                          0x00000400
#define _IEC3_SBIE_LENGTH                        0x00000001

#define _IEC3_SPI1EIE_POSITION                   0x0000000D
#define _IEC3_SPI1EIE_MASK                       0x00002000
#define _IEC3_SPI1EIE_LENGTH                     0x00000001

#define _IEC3_SPI1RXIE_POSITION                  0x0000000E
#define _IEC3_SPI1RXIE_MASK                      0x00004000
#define _IEC3_SPI1RXIE_LENGTH                    0x00000001

#define _IEC3_SPI1TXIE_POSITION                  0x0000000F
#define _IEC3_SPI1TXIE_MASK                      0x00008000
#define _IEC3_SPI1TXIE_LENGTH                    0x00000001

#define _IEC3_U1EIE_POSITION                     0x00000010
#define _IEC3_U1EIE_MASK                         0x00010000
#define _IEC3_U1EIE_LENGTH                       0x00000001

#define _IEC3_U1RXIE_POSITION                    0x00000011
#define _IEC3_U1RXIE_MASK                        0x00020000
#define _IEC3_U1RXIE_LENGTH                      0x00000001

#define _IEC3_U1TXIE_POSITION                    0x00000012
#define _IEC3_U1TXIE_MASK                        0x00040000
#define _IEC3_U1TXIE_LENGTH                      0x00000001

#define _IEC3_I2C1BIE_POSITION                   0x00000013
#define _IEC3_I2C1BIE_MASK                       0x00080000
#define _IEC3_I2C1BIE_LENGTH                     0x00000001

#define _IEC3_I2C1SIE_POSITION                   0x00000014
#define _IEC3_I2C1SIE_MASK                       0x00100000
#define _IEC3_I2C1SIE_LENGTH                     0x00000001

#define _IEC3_I2C1MIE_POSITION                   0x00000015
#define _IEC3_I2C1MIE_MASK                       0x00200000
#define _IEC3_I2C1MIE_LENGTH                     0x00000001

#define _IEC3_CNAIE_POSITION                     0x00000016
#define _IEC3_CNAIE_MASK                         0x00400000
#define _IEC3_CNAIE_LENGTH                       0x00000001

#define _IEC3_CNBIE_POSITION                     0x00000017
#define _IEC3_CNBIE_MASK                         0x00800000
#define _IEC3_CNBIE_LENGTH                       0x00000001

#define _IEC3_CNCIE_POSITION                     0x00000018
#define _IEC3_CNCIE_MASK                         0x01000000
#define _IEC3_CNCIE_LENGTH                       0x00000001

#define _IEC3_CNDIE_POSITION                     0x00000019
#define _IEC3_CNDIE_MASK                         0x02000000
#define _IEC3_CNDIE_LENGTH                       0x00000001

#define _IEC3_CNEIE_POSITION                     0x0000001A
#define _IEC3_CNEIE_MASK                         0x04000000
#define _IEC3_CNEIE_LENGTH                       0x00000001

#define _IEC3_CNFIE_POSITION                     0x0000001B
#define _IEC3_CNFIE_MASK                         0x08000000
#define _IEC3_CNFIE_LENGTH                       0x00000001

#define _IEC3_CNGIE_POSITION                     0x0000001C
#define _IEC3_CNGIE_MASK                         0x10000000
#define _IEC3_CNGIE_LENGTH                       0x00000001

#define _IEC3_w_POSITION                         0x00000000
#define _IEC3_w_MASK                             0xFFFFFFFF
#define _IEC3_w_LENGTH                           0x00000020

#define _IEC4_PMPIE_POSITION                     0x00000000
#define _IEC4_PMPIE_MASK                         0x00000001
#define _IEC4_PMPIE_LENGTH                       0x00000001

#define _IEC4_PMPEIE_POSITION                    0x00000001
#define _IEC4_PMPEIE_MASK                        0x00000002
#define _IEC4_PMPEIE_LENGTH                      0x00000001

#define _IEC4_CMP1IE_POSITION                    0x00000002
#define _IEC4_CMP1IE_MASK                        0x00000004
#define _IEC4_CMP1IE_LENGTH                      0x00000001

#define _IEC4_CMP2IE_POSITION                    0x00000003
#define _IEC4_CMP2IE_MASK                        0x00000008
#define _IEC4_CMP2IE_LENGTH                      0x00000001

#define _IEC4_USBIE_POSITION                     0x00000004
#define _IEC4_USBIE_MASK                         0x00000010
#define _IEC4_USBIE_LENGTH                       0x00000001

#define _IEC4_USBDMAIE_POSITION                  0x00000005
#define _IEC4_USBDMAIE_MASK                      0x00000020
#define _IEC4_USBDMAIE_LENGTH                    0x00000001

#define _IEC4_DMA0IE_POSITION                    0x00000006
#define _IEC4_DMA0IE_MASK                        0x00000040
#define _IEC4_DMA0IE_LENGTH                      0x00000001

#define _IEC4_DMA1IE_POSITION                    0x00000007
#define _IEC4_DMA1IE_MASK                        0x00000080
#define _IEC4_DMA1IE_LENGTH                      0x00000001

#define _IEC4_DMA2IE_POSITION                    0x00000008
#define _IEC4_DMA2IE_MASK                        0x00000100
#define _IEC4_DMA2IE_LENGTH                      0x00000001

#define _IEC4_DMA3IE_POSITION                    0x00000009
#define _IEC4_DMA3IE_MASK                        0x00000200
#define _IEC4_DMA3IE_LENGTH                      0x00000001

#define _IEC4_DMA4IE_POSITION                    0x0000000A
#define _IEC4_DMA4IE_MASK                        0x00000400
#define _IEC4_DMA4IE_LENGTH                      0x00000001

#define _IEC4_DMA5IE_POSITION                    0x0000000B
#define _IEC4_DMA5IE_MASK                        0x00000800
#define _IEC4_DMA5IE_LENGTH                      0x00000001

#define _IEC4_DMA6IE_POSITION                    0x0000000C
#define _IEC4_DMA6IE_MASK                        0x00001000
#define _IEC4_DMA6IE_LENGTH                      0x00000001

#define _IEC4_DMA7IE_POSITION                    0x0000000D
#define _IEC4_DMA7IE_MASK                        0x00002000
#define _IEC4_DMA7IE_LENGTH                      0x00000001

#define _IEC4_SPI2EIE_POSITION                   0x0000000E
#define _IEC4_SPI2EIE_MASK                       0x00004000
#define _IEC4_SPI2EIE_LENGTH                     0x00000001

#define _IEC4_SPI2RXIE_POSITION                  0x0000000F
#define _IEC4_SPI2RXIE_MASK                      0x00008000
#define _IEC4_SPI2RXIE_LENGTH                    0x00000001

#define _IEC4_SPI2TXIE_POSITION                  0x00000010
#define _IEC4_SPI2TXIE_MASK                      0x00010000
#define _IEC4_SPI2TXIE_LENGTH                    0x00000001

#define _IEC4_U2EIE_POSITION                     0x00000011
#define _IEC4_U2EIE_MASK                         0x00020000
#define _IEC4_U2EIE_LENGTH                       0x00000001

#define _IEC4_U2RXIE_POSITION                    0x00000012
#define _IEC4_U2RXIE_MASK                        0x00040000
#define _IEC4_U2RXIE_LENGTH                      0x00000001

#define _IEC4_U2TXIE_POSITION                    0x00000013
#define _IEC4_U2TXIE_MASK                        0x00080000
#define _IEC4_U2TXIE_LENGTH                      0x00000001

#define _IEC4_I2C2BIE_POSITION                   0x00000014
#define _IEC4_I2C2BIE_MASK                       0x00100000
#define _IEC4_I2C2BIE_LENGTH                     0x00000001

#define _IEC4_I2C2SIE_POSITION                   0x00000015
#define _IEC4_I2C2SIE_MASK                       0x00200000
#define _IEC4_I2C2SIE_LENGTH                     0x00000001

#define _IEC4_I2C2MIE_POSITION                   0x00000016
#define _IEC4_I2C2MIE_MASK                       0x00400000
#define _IEC4_I2C2MIE_LENGTH                     0x00000001

#define _IEC4_ETHIE_POSITION                     0x00000019
#define _IEC4_ETHIE_MASK                         0x02000000
#define _IEC4_ETHIE_LENGTH                       0x00000001

#define _IEC4_SPI3EIE_POSITION                   0x0000001A
#define _IEC4_SPI3EIE_MASK                       0x04000000
#define _IEC4_SPI3EIE_LENGTH                     0x00000001

#define _IEC4_SPI3RXIE_POSITION                  0x0000001B
#define _IEC4_SPI3RXIE_MASK                      0x08000000
#define _IEC4_SPI3RXIE_LENGTH                    0x00000001

#define _IEC4_SPI3TXIE_POSITION                  0x0000001C
#define _IEC4_SPI3TXIE_MASK                      0x10000000
#define _IEC4_SPI3TXIE_LENGTH                    0x00000001

#define _IEC4_U3EIE_POSITION                     0x0000001D
#define _IEC4_U3EIE_MASK                         0x20000000
#define _IEC4_U3EIE_LENGTH                       0x00000001

#define _IEC4_U3RXIE_POSITION                    0x0000001E
#define _IEC4_U3RXIE_MASK                        0x40000000
#define _IEC4_U3RXIE_LENGTH                      0x00000001

#define _IEC4_U3TXIE_POSITION                    0x0000001F
#define _IEC4_U3TXIE_MASK                        0x80000000
#define _IEC4_U3TXIE_LENGTH                      0x00000001

#define _IEC4_w_POSITION                         0x00000000
#define _IEC4_w_MASK                             0xFFFFFFFF
#define _IEC4_w_LENGTH                           0x00000020

#define _IEC5_I2C3BIE_POSITION                   0x00000000
#define _IEC5_I2C3BIE_MASK                       0x00000001
#define _IEC5_I2C3BIE_LENGTH                     0x00000001

#define _IEC5_I2C3SIE_POSITION                   0x00000001
#define _IEC5_I2C3SIE_MASK                       0x00000002
#define _IEC5_I2C3SIE_LENGTH                     0x00000001

#define _IEC5_I2C3MIE_POSITION                   0x00000002
#define _IEC5_I2C3MIE_MASK                       0x00000004
#define _IEC5_I2C3MIE_LENGTH                     0x00000001

#define _IEC5_SPI4EIE_POSITION                   0x00000003
#define _IEC5_SPI4EIE_MASK                       0x00000008
#define _IEC5_SPI4EIE_LENGTH                     0x00000001

#define _IEC5_SPI4RXIE_POSITION                  0x00000004
#define _IEC5_SPI4RXIE_MASK                      0x00000010
#define _IEC5_SPI4RXIE_LENGTH                    0x00000001

#define _IEC5_SPI4TXIE_POSITION                  0x00000005
#define _IEC5_SPI4TXIE_MASK                      0x00000020
#define _IEC5_SPI4TXIE_LENGTH                    0x00000001

#define _IEC5_RTCCIE_POSITION                    0x00000006
#define _IEC5_RTCCIE_MASK                        0x00000040
#define _IEC5_RTCCIE_LENGTH                      0x00000001

#define _IEC5_FCEIE_POSITION                     0x00000007
#define _IEC5_FCEIE_MASK                         0x00000080
#define _IEC5_FCEIE_LENGTH                       0x00000001

#define _IEC5_PREIE_POSITION                     0x00000008
#define _IEC5_PREIE_MASK                         0x00000100
#define _IEC5_PREIE_LENGTH                       0x00000001

#define _IEC5_SQI1IE_POSITION                    0x00000009
#define _IEC5_SQI1IE_MASK                        0x00000200
#define _IEC5_SQI1IE_LENGTH                      0x00000001

#define _IEC5_U4EIE_POSITION                     0x0000000A
#define _IEC5_U4EIE_MASK                         0x00000400
#define _IEC5_U4EIE_LENGTH                       0x00000001

#define _IEC5_U4RXIE_POSITION                    0x0000000B
#define _IEC5_U4RXIE_MASK                        0x00000800
#define _IEC5_U4RXIE_LENGTH                      0x00000001

#define _IEC5_U4TXIE_POSITION                    0x0000000C
#define _IEC5_U4TXIE_MASK                        0x00001000
#define _IEC5_U4TXIE_LENGTH                      0x00000001

#define _IEC5_I2C4BIE_POSITION                   0x0000000D
#define _IEC5_I2C4BIE_MASK                       0x00002000
#define _IEC5_I2C4BIE_LENGTH                     0x00000001

#define _IEC5_I2C4SIE_POSITION                   0x0000000E
#define _IEC5_I2C4SIE_MASK                       0x00004000
#define _IEC5_I2C4SIE_LENGTH                     0x00000001

#define _IEC5_I2C4MIE_POSITION                   0x0000000F
#define _IEC5_I2C4MIE_MASK                       0x00008000
#define _IEC5_I2C4MIE_LENGTH                     0x00000001

#define _IEC5_SPI5EIE_POSITION                   0x00000010
#define _IEC5_SPI5EIE_MASK                       0x00010000
#define _IEC5_SPI5EIE_LENGTH                     0x00000001

#define _IEC5_SPI5RXIE_POSITION                  0x00000011
#define _IEC5_SPI5RXIE_MASK                      0x00020000
#define _IEC5_SPI5RXIE_LENGTH                    0x00000001

#define _IEC5_SPI5TXIE_POSITION                  0x00000012
#define _IEC5_SPI5TXIE_MASK                      0x00040000
#define _IEC5_SPI5TXIE_LENGTH                    0x00000001

#define _IEC5_U5EIE_POSITION                     0x00000013
#define _IEC5_U5EIE_MASK                         0x00080000
#define _IEC5_U5EIE_LENGTH                       0x00000001

#define _IEC5_U5RXIE_POSITION                    0x00000014
#define _IEC5_U5RXIE_MASK                        0x00100000
#define _IEC5_U5RXIE_LENGTH                      0x00000001

#define _IEC5_U5TXIE_POSITION                    0x00000015
#define _IEC5_U5TXIE_MASK                        0x00200000
#define _IEC5_U5TXIE_LENGTH                      0x00000001

#define _IEC5_I2C5BIE_POSITION                   0x00000016
#define _IEC5_I2C5BIE_MASK                       0x00400000
#define _IEC5_I2C5BIE_LENGTH                     0x00000001

#define _IEC5_I2C5SIE_POSITION                   0x00000017
#define _IEC5_I2C5SIE_MASK                       0x00800000
#define _IEC5_I2C5SIE_LENGTH                     0x00000001

#define _IEC5_I2C5MIE_POSITION                   0x00000018
#define _IEC5_I2C5MIE_MASK                       0x01000000
#define _IEC5_I2C5MIE_LENGTH                     0x00000001

#define _IEC5_SPI6IE_POSITION                    0x00000019
#define _IEC5_SPI6IE_MASK                        0x02000000
#define _IEC5_SPI6IE_LENGTH                      0x00000001

#define _IEC5_SPI6RXIE_POSITION                  0x0000001A
#define _IEC5_SPI6RXIE_MASK                      0x04000000
#define _IEC5_SPI6RXIE_LENGTH                    0x00000001

#define _IEC5_SPI6TXIE_POSITION                  0x0000001B
#define _IEC5_SPI6TXIE_MASK                      0x08000000
#define _IEC5_SPI6TXIE_LENGTH                    0x00000001

#define _IEC5_U6EIE_POSITION                     0x0000001C
#define _IEC5_U6EIE_MASK                         0x10000000
#define _IEC5_U6EIE_LENGTH                       0x00000001

#define _IEC5_U6RXIE_POSITION                    0x0000001D
#define _IEC5_U6RXIE_MASK                        0x20000000
#define _IEC5_U6RXIE_LENGTH                      0x00000001

#define _IEC5_U6TXIE_POSITION                    0x0000001E
#define _IEC5_U6TXIE_MASK                        0x40000000
#define _IEC5_U6TXIE_LENGTH                      0x00000001

#define _IEC5_w_POSITION                         0x00000000
#define _IEC5_w_MASK                             0xFFFFFFFF
#define _IEC5_w_LENGTH                           0x00000020

#define _IEC6_ADCEOSIE_POSITION                  0x00000000
#define _IEC6_ADCEOSIE_MASK                      0x00000001
#define _IEC6_ADCEOSIE_LENGTH                    0x00000001

#define _IEC6_ADCARDYIE_POSITION                 0x00000001
#define _IEC6_ADCARDYIE_MASK                     0x00000002
#define _IEC6_ADCARDYIE_LENGTH                   0x00000001

#define _IEC6_ADCURDYIE_POSITION                 0x00000002
#define _IEC6_ADCURDYIE_MASK                     0x00000004
#define _IEC6_ADCURDYIE_LENGTH                   0x00000001

#define _IEC6_ADCGRPIE_POSITION                  0x00000004
#define _IEC6_ADCGRPIE_MASK                      0x00000010
#define _IEC6_ADCGRPIE_LENGTH                    0x00000001

#define _IEC6_ADC0EIE_POSITION                   0x00000006
#define _IEC6_ADC0EIE_MASK                       0x00000040
#define _IEC6_ADC0EIE_LENGTH                     0x00000001

#define _IEC6_ADC1EIE_POSITION                   0x00000007
#define _IEC6_ADC1EIE_MASK                       0x00000080
#define _IEC6_ADC1EIE_LENGTH                     0x00000001

#define _IEC6_ADC2EIE_POSITION                   0x00000008
#define _IEC6_ADC2EIE_MASK                       0x00000100
#define _IEC6_ADC2EIE_LENGTH                     0x00000001

#define _IEC6_ADC3EIE_POSITION                   0x00000009
#define _IEC6_ADC3EIE_MASK                       0x00000200
#define _IEC6_ADC3EIE_LENGTH                     0x00000001

#define _IEC6_ADC4EIE_POSITION                   0x0000000A
#define _IEC6_ADC4EIE_MASK                       0x00000400
#define _IEC6_ADC4EIE_LENGTH                     0x00000001

#define _IEC6_ADC7EIE_POSITION                   0x0000000D
#define _IEC6_ADC7EIE_MASK                       0x00002000
#define _IEC6_ADC7EIE_LENGTH                     0x00000001

#define _IEC6_ADC0WIE_POSITION                   0x0000000E
#define _IEC6_ADC0WIE_MASK                       0x00004000
#define _IEC6_ADC0WIE_LENGTH                     0x00000001

#define _IEC6_ADC1WIE_POSITION                   0x0000000F
#define _IEC6_ADC1WIE_MASK                       0x00008000
#define _IEC6_ADC1WIE_LENGTH                     0x00000001

#define _IEC6_ADC2WIE_POSITION                   0x00000010
#define _IEC6_ADC2WIE_MASK                       0x00010000
#define _IEC6_ADC2WIE_LENGTH                     0x00000001

#define _IEC6_ADC3WIE_POSITION                   0x00000011
#define _IEC6_ADC3WIE_MASK                       0x00020000
#define _IEC6_ADC3WIE_LENGTH                     0x00000001

#define _IEC6_ADC4WIE_POSITION                   0x00000012
#define _IEC6_ADC4WIE_MASK                       0x00040000
#define _IEC6_ADC4WIE_LENGTH                     0x00000001

#define _IEC6_ADC7WIE_POSITION                   0x00000015
#define _IEC6_ADC7WIE_MASK                       0x00200000
#define _IEC6_ADC7WIE_LENGTH                     0x00000001

#define _IEC6_w_POSITION                         0x00000000
#define _IEC6_w_MASK                             0xFFFFFFFF
#define _IEC6_w_LENGTH                           0x00000020

#define _IPC0_CTIS_POSITION                      0x00000000
#define _IPC0_CTIS_MASK                          0x00000003
#define _IPC0_CTIS_LENGTH                        0x00000002

#define _IPC0_CTIP_POSITION                      0x00000002
#define _IPC0_CTIP_MASK                          0x0000001C
#define _IPC0_CTIP_LENGTH                        0x00000003

#define _IPC0_CS0IS_POSITION                     0x00000008
#define _IPC0_CS0IS_MASK                         0x00000300
#define _IPC0_CS0IS_LENGTH                       0x00000002

#define _IPC0_CS0IP_POSITION                     0x0000000A
#define _IPC0_CS0IP_MASK                         0x00001C00
#define _IPC0_CS0IP_LENGTH                       0x00000003

#define _IPC0_CS1IS_POSITION                     0x00000010
#define _IPC0_CS1IS_MASK                         0x00030000
#define _IPC0_CS1IS_LENGTH                       0x00000002

#define _IPC0_CS1IP_POSITION                     0x00000012
#define _IPC0_CS1IP_MASK                         0x001C0000
#define _IPC0_CS1IP_LENGTH                       0x00000003

#define _IPC0_INT0IS_POSITION                    0x00000018
#define _IPC0_INT0IS_MASK                        0x03000000
#define _IPC0_INT0IS_LENGTH                      0x00000002

#define _IPC0_INT0IP_POSITION                    0x0000001A
#define _IPC0_INT0IP_MASK                        0x1C000000
#define _IPC0_INT0IP_LENGTH                      0x00000003

#define _IPC0_w_POSITION                         0x00000000
#define _IPC0_w_MASK                             0xFFFFFFFF
#define _IPC0_w_LENGTH                           0x00000020

#define _IPC1_T1IS_POSITION                      0x00000000
#define _IPC1_T1IS_MASK                          0x00000003
#define _IPC1_T1IS_LENGTH                        0x00000002

#define _IPC1_T1IP_POSITION                      0x00000002
#define _IPC1_T1IP_MASK                          0x0000001C
#define _IPC1_T1IP_LENGTH                        0x00000003

#define _IPC1_IC1EIS_POSITION                    0x00000008
#define _IPC1_IC1EIS_MASK                        0x00000300
#define _IPC1_IC1EIS_LENGTH                      0x00000002

#define _IPC1_IC1EIP_POSITION                    0x0000000A
#define _IPC1_IC1EIP_MASK                        0x00001C00
#define _IPC1_IC1EIP_LENGTH                      0x00000003

#define _IPC1_IC1IS_POSITION                     0x00000010
#define _IPC1_IC1IS_MASK                         0x00030000
#define _IPC1_IC1IS_LENGTH                       0x00000002

#define _IPC1_IC1IP_POSITION                     0x00000012
#define _IPC1_IC1IP_MASK                         0x001C0000
#define _IPC1_IC1IP_LENGTH                       0x00000003

#define _IPC1_OC1IS_POSITION                     0x00000018
#define _IPC1_OC1IS_MASK                         0x03000000
#define _IPC1_OC1IS_LENGTH                       0x00000002

#define _IPC1_OC1IP_POSITION                     0x0000001A
#define _IPC1_OC1IP_MASK                         0x1C000000
#define _IPC1_OC1IP_LENGTH                       0x00000003

#define _IPC1_w_POSITION                         0x00000000
#define _IPC1_w_MASK                             0xFFFFFFFF
#define _IPC1_w_LENGTH                           0x00000020

#define _IPC2_INT1IS_POSITION                    0x00000000
#define _IPC2_INT1IS_MASK                        0x00000003
#define _IPC2_INT1IS_LENGTH                      0x00000002

#define _IPC2_INT1IP_POSITION                    0x00000002
#define _IPC2_INT1IP_MASK                        0x0000001C
#define _IPC2_INT1IP_LENGTH                      0x00000003

#define _IPC2_T2IS_POSITION                      0x00000008
#define _IPC2_T2IS_MASK                          0x00000300
#define _IPC2_T2IS_LENGTH                        0x00000002

#define _IPC2_T2IP_POSITION                      0x0000000A
#define _IPC2_T2IP_MASK                          0x00001C00
#define _IPC2_T2IP_LENGTH                        0x00000003

#define _IPC2_IC2EIS_POSITION                    0x00000010
#define _IPC2_IC2EIS_MASK                        0x00030000
#define _IPC2_IC2EIS_LENGTH                      0x00000002

#define _IPC2_IC2EIP_POSITION                    0x00000012
#define _IPC2_IC2EIP_MASK                        0x001C0000
#define _IPC2_IC2EIP_LENGTH                      0x00000003

#define _IPC2_IC2IS_POSITION                     0x00000018
#define _IPC2_IC2IS_MASK                         0x03000000
#define _IPC2_IC2IS_LENGTH                       0x00000002

#define _IPC2_IC2IP_POSITION                     0x0000001A
#define _IPC2_IC2IP_MASK                         0x1C000000
#define _IPC2_IC2IP_LENGTH                       0x00000003

#define _IPC2_w_POSITION                         0x00000000
#define _IPC2_w_MASK                             0xFFFFFFFF
#define _IPC2_w_LENGTH                           0x00000020

#define _IPC3_OC2IS_POSITION                     0x00000000
#define _IPC3_OC2IS_MASK                         0x00000003
#define _IPC3_OC2IS_LENGTH                       0x00000002

#define _IPC3_OC2IP_POSITION                     0x00000002
#define _IPC3_OC2IP_MASK                         0x0000001C
#define _IPC3_OC2IP_LENGTH                       0x00000003

#define _IPC3_INT2IS_POSITION                    0x00000008
#define _IPC3_INT2IS_MASK                        0x00000300
#define _IPC3_INT2IS_LENGTH                      0x00000002

#define _IPC3_INT2IP_POSITION                    0x0000000A
#define _IPC3_INT2IP_MASK                        0x00001C00
#define _IPC3_INT2IP_LENGTH                      0x00000003

#define _IPC3_T3IS_POSITION                      0x00000010
#define _IPC3_T3IS_MASK                          0x00030000
#define _IPC3_T3IS_LENGTH                        0x00000002

#define _IPC3_T3IP_POSITION                      0x00000012
#define _IPC3_T3IP_MASK                          0x001C0000
#define _IPC3_T3IP_LENGTH                        0x00000003

#define _IPC3_IC3EIS_POSITION                    0x00000018
#define _IPC3_IC3EIS_MASK                        0x03000000
#define _IPC3_IC3EIS_LENGTH                      0x00000002

#define _IPC3_IC3EIP_POSITION                    0x0000001A
#define _IPC3_IC3EIP_MASK                        0x1C000000
#define _IPC3_IC3EIP_LENGTH                      0x00000003

#define _IPC3_w_POSITION                         0x00000000
#define _IPC3_w_MASK                             0xFFFFFFFF
#define _IPC3_w_LENGTH                           0x00000020

#define _IPC4_IC3IS_POSITION                     0x00000000
#define _IPC4_IC3IS_MASK                         0x00000003
#define _IPC4_IC3IS_LENGTH                       0x00000002

#define _IPC4_IC3IP_POSITION                     0x00000002
#define _IPC4_IC3IP_MASK                         0x0000001C
#define _IPC4_IC3IP_LENGTH                       0x00000003

#define _IPC4_OC3IS_POSITION                     0x00000008
#define _IPC4_OC3IS_MASK                         0x00000300
#define _IPC4_OC3IS_LENGTH                       0x00000002

#define _IPC4_OC3IP_POSITION                     0x0000000A
#define _IPC4_OC3IP_MASK                         0x00001C00
#define _IPC4_OC3IP_LENGTH                       0x00000003

#define _IPC4_INT3IS_POSITION                    0x00000010
#define _IPC4_INT3IS_MASK                        0x00030000
#define _IPC4_INT3IS_LENGTH                      0x00000002

#define _IPC4_INT3IP_POSITION                    0x00000012
#define _IPC4_INT3IP_MASK                        0x001C0000
#define _IPC4_INT3IP_LENGTH                      0x00000003

#define _IPC4_T4IS_POSITION                      0x00000018
#define _IPC4_T4IS_MASK                          0x03000000
#define _IPC4_T4IS_LENGTH                        0x00000002

#define _IPC4_T4IP_POSITION                      0x0000001A
#define _IPC4_T4IP_MASK                          0x1C000000
#define _IPC4_T4IP_LENGTH                        0x00000003

#define _IPC4_w_POSITION                         0x00000000
#define _IPC4_w_MASK                             0xFFFFFFFF
#define _IPC4_w_LENGTH                           0x00000020

#define _IPC5_IC4EIS_POSITION                    0x00000000
#define _IPC5_IC4EIS_MASK                        0x00000003
#define _IPC5_IC4EIS_LENGTH                      0x00000002

#define _IPC5_IC4EIP_POSITION                    0x00000002
#define _IPC5_IC4EIP_MASK                        0x0000001C
#define _IPC5_IC4EIP_LENGTH                      0x00000003

#define _IPC5_IC4IS_POSITION                     0x00000008
#define _IPC5_IC4IS_MASK                         0x00000300
#define _IPC5_IC4IS_LENGTH                       0x00000002

#define _IPC5_IC4IP_POSITION                     0x0000000A
#define _IPC5_IC4IP_MASK                         0x00001C00
#define _IPC5_IC4IP_LENGTH                       0x00000003

#define _IPC5_OC4IS_POSITION                     0x00000010
#define _IPC5_OC4IS_MASK                         0x00030000
#define _IPC5_OC4IS_LENGTH                       0x00000002

#define _IPC5_OC4IP_POSITION                     0x00000012
#define _IPC5_OC4IP_MASK                         0x001C0000
#define _IPC5_OC4IP_LENGTH                       0x00000003

#define _IPC5_INT4IS_POSITION                    0x00000018
#define _IPC5_INT4IS_MASK                        0x03000000
#define _IPC5_INT4IS_LENGTH                      0x00000002

#define _IPC5_INT4IP_POSITION                    0x0000001A
#define _IPC5_INT4IP_MASK                        0x1C000000
#define _IPC5_INT4IP_LENGTH                      0x00000003

#define _IPC5_w_POSITION                         0x00000000
#define _IPC5_w_MASK                             0xFFFFFFFF
#define _IPC5_w_LENGTH                           0x00000020

#define _IPC6_T5IS_POSITION                      0x00000000
#define _IPC6_T5IS_MASK                          0x00000003
#define _IPC6_T5IS_LENGTH                        0x00000002

#define _IPC6_T5IP_POSITION                      0x00000002
#define _IPC6_T5IP_MASK                          0x0000001C
#define _IPC6_T5IP_LENGTH                        0x00000003

#define _IPC6_IC5EIS_POSITION                    0x00000008
#define _IPC6_IC5EIS_MASK                        0x00000300
#define _IPC6_IC5EIS_LENGTH                      0x00000002

#define _IPC6_IC5EIP_POSITION                    0x0000000A
#define _IPC6_IC5EIP_MASK                        0x00001C00
#define _IPC6_IC5EIP_LENGTH                      0x00000003

#define _IPC6_IC5IS_POSITION                     0x00000010
#define _IPC6_IC5IS_MASK                         0x00030000
#define _IPC6_IC5IS_LENGTH                       0x00000002

#define _IPC6_IC5IP_POSITION                     0x00000012
#define _IPC6_IC5IP_MASK                         0x001C0000
#define _IPC6_IC5IP_LENGTH                       0x00000003

#define _IPC6_OC5IS_POSITION                     0x00000018
#define _IPC6_OC5IS_MASK                         0x03000000
#define _IPC6_OC5IS_LENGTH                       0x00000002

#define _IPC6_OC5IP_POSITION                     0x0000001A
#define _IPC6_OC5IP_MASK                         0x1C000000
#define _IPC6_OC5IP_LENGTH                       0x00000003

#define _IPC6_w_POSITION                         0x00000000
#define _IPC6_w_MASK                             0xFFFFFFFF
#define _IPC6_w_LENGTH                           0x00000020

#define _IPC7_T6IS_POSITION                      0x00000000
#define _IPC7_T6IS_MASK                          0x00000003
#define _IPC7_T6IS_LENGTH                        0x00000002

#define _IPC7_T6IP_POSITION                      0x00000002
#define _IPC7_T6IP_MASK                          0x0000001C
#define _IPC7_T6IP_LENGTH                        0x00000003

#define _IPC7_IC6EIS_POSITION                    0x00000008
#define _IPC7_IC6EIS_MASK                        0x00000300
#define _IPC7_IC6EIS_LENGTH                      0x00000002

#define _IPC7_IC6EIP_POSITION                    0x0000000A
#define _IPC7_IC6EIP_MASK                        0x00001C00
#define _IPC7_IC6EIP_LENGTH                      0x00000003

#define _IPC7_IC6IS_POSITION                     0x00000010
#define _IPC7_IC6IS_MASK                         0x00030000
#define _IPC7_IC6IS_LENGTH                       0x00000002

#define _IPC7_IC6IP_POSITION                     0x00000012
#define _IPC7_IC6IP_MASK                         0x001C0000
#define _IPC7_IC6IP_LENGTH                       0x00000003

#define _IPC7_OC6IS_POSITION                     0x00000018
#define _IPC7_OC6IS_MASK                         0x03000000
#define _IPC7_OC6IS_LENGTH                       0x00000002

#define _IPC7_OC6IP_POSITION                     0x0000001A
#define _IPC7_OC6IP_MASK                         0x1C000000
#define _IPC7_OC6IP_LENGTH                       0x00000003

#define _IPC7_w_POSITION                         0x00000000
#define _IPC7_w_MASK                             0xFFFFFFFF
#define _IPC7_w_LENGTH                           0x00000020

#define _IPC8_T7IS_POSITION                      0x00000000
#define _IPC8_T7IS_MASK                          0x00000003
#define _IPC8_T7IS_LENGTH                        0x00000002

#define _IPC8_T7IP_POSITION                      0x00000002
#define _IPC8_T7IP_MASK                          0x0000001C
#define _IPC8_T7IP_LENGTH                        0x00000003

#define _IPC8_IC7EIS_POSITION                    0x00000008
#define _IPC8_IC7EIS_MASK                        0x00000300
#define _IPC8_IC7EIS_LENGTH                      0x00000002

#define _IPC8_IC7EIP_POSITION                    0x0000000A
#define _IPC8_IC7EIP_MASK                        0x00001C00
#define _IPC8_IC7EIP_LENGTH                      0x00000003

#define _IPC8_IC7IS_POSITION                     0x00000010
#define _IPC8_IC7IS_MASK                         0x00030000
#define _IPC8_IC7IS_LENGTH                       0x00000002

#define _IPC8_IC7IP_POSITION                     0x00000012
#define _IPC8_IC7IP_MASK                         0x001C0000
#define _IPC8_IC7IP_LENGTH                       0x00000003

#define _IPC8_OC7IS_POSITION                     0x00000018
#define _IPC8_OC7IS_MASK                         0x03000000
#define _IPC8_OC7IS_LENGTH                       0x00000002

#define _IPC8_OC7IP_POSITION                     0x0000001A
#define _IPC8_OC7IP_MASK                         0x1C000000
#define _IPC8_OC7IP_LENGTH                       0x00000003

#define _IPC8_w_POSITION                         0x00000000
#define _IPC8_w_MASK                             0xFFFFFFFF
#define _IPC8_w_LENGTH                           0x00000020

#define _IPC9_T8IS_POSITION                      0x00000000
#define _IPC9_T8IS_MASK                          0x00000003
#define _IPC9_T8IS_LENGTH                        0x00000002

#define _IPC9_T8IP_POSITION                      0x00000002
#define _IPC9_T8IP_MASK                          0x0000001C
#define _IPC9_T8IP_LENGTH                        0x00000003

#define _IPC9_IC8EIS_POSITION                    0x00000008
#define _IPC9_IC8EIS_MASK                        0x00000300
#define _IPC9_IC8EIS_LENGTH                      0x00000002

#define _IPC9_IC8EIP_POSITION                    0x0000000A
#define _IPC9_IC8EIP_MASK                        0x00001C00
#define _IPC9_IC8EIP_LENGTH                      0x00000003

#define _IPC9_IC8IS_POSITION                     0x00000010
#define _IPC9_IC8IS_MASK                         0x00030000
#define _IPC9_IC8IS_LENGTH                       0x00000002

#define _IPC9_IC8IP_POSITION                     0x00000012
#define _IPC9_IC8IP_MASK                         0x001C0000
#define _IPC9_IC8IP_LENGTH                       0x00000003

#define _IPC9_OC8IS_POSITION                     0x00000018
#define _IPC9_OC8IS_MASK                         0x03000000
#define _IPC9_OC8IS_LENGTH                       0x00000002

#define _IPC9_OC8IP_POSITION                     0x0000001A
#define _IPC9_OC8IP_MASK                         0x1C000000
#define _IPC9_OC8IP_LENGTH                       0x00000003

#define _IPC9_w_POSITION                         0x00000000
#define _IPC9_w_MASK                             0xFFFFFFFF
#define _IPC9_w_LENGTH                           0x00000020

#define _IPC10_T9IS_POSITION                     0x00000000
#define _IPC10_T9IS_MASK                         0x00000003
#define _IPC10_T9IS_LENGTH                       0x00000002

#define _IPC10_T9IP_POSITION                     0x00000002
#define _IPC10_T9IP_MASK                         0x0000001C
#define _IPC10_T9IP_LENGTH                       0x00000003

#define _IPC10_IC9EIS_POSITION                   0x00000008
#define _IPC10_IC9EIS_MASK                       0x00000300
#define _IPC10_IC9EIS_LENGTH                     0x00000002

#define _IPC10_IC9EIP_POSITION                   0x0000000A
#define _IPC10_IC9EIP_MASK                       0x00001C00
#define _IPC10_IC9EIP_LENGTH                     0x00000003

#define _IPC10_IC9IS_POSITION                    0x00000010
#define _IPC10_IC9IS_MASK                        0x00030000
#define _IPC10_IC9IS_LENGTH                      0x00000002

#define _IPC10_IC9IP_POSITION                    0x00000012
#define _IPC10_IC9IP_MASK                        0x001C0000
#define _IPC10_IC9IP_LENGTH                      0x00000003

#define _IPC10_OC9IS_POSITION                    0x00000018
#define _IPC10_OC9IS_MASK                        0x03000000
#define _IPC10_OC9IS_LENGTH                      0x00000002

#define _IPC10_OC9IP_POSITION                    0x0000001A
#define _IPC10_OC9IP_MASK                        0x1C000000
#define _IPC10_OC9IP_LENGTH                      0x00000003

#define _IPC10_w_POSITION                        0x00000000
#define _IPC10_w_MASK                            0xFFFFFFFF
#define _IPC10_w_LENGTH                          0x00000020

#define _IPC11_ADCIS_POSITION                    0x00000000
#define _IPC11_ADCIS_MASK                        0x00000003
#define _IPC11_ADCIS_LENGTH                      0x00000002

#define _IPC11_ADCIP_POSITION                    0x00000002
#define _IPC11_ADCIP_MASK                        0x0000001C
#define _IPC11_ADCIP_LENGTH                      0x00000003

#define _IPC11_ADCFIFOIS_POSITION                0x00000008
#define _IPC11_ADCFIFOIS_MASK                    0x00000300
#define _IPC11_ADCFIFOIS_LENGTH                  0x00000002

#define _IPC11_ADCFIFOIP_POSITION                0x0000000A
#define _IPC11_ADCFIFOIP_MASK                    0x00001C00
#define _IPC11_ADCFIFOIP_LENGTH                  0x00000003

#define _IPC11_ADCDC1IS_POSITION                 0x00000010
#define _IPC11_ADCDC1IS_MASK                     0x00030000
#define _IPC11_ADCDC1IS_LENGTH                   0x00000002

#define _IPC11_ADCDC1IP_POSITION                 0x00000012
#define _IPC11_ADCDC1IP_MASK                     0x001C0000
#define _IPC11_ADCDC1IP_LENGTH                   0x00000003

#define _IPC11_ADCDC2IS_POSITION                 0x00000018
#define _IPC11_ADCDC2IS_MASK                     0x03000000
#define _IPC11_ADCDC2IS_LENGTH                   0x00000002

#define _IPC11_ADCDC2IP_POSITION                 0x0000001A
#define _IPC11_ADCDC2IP_MASK                     0x1C000000
#define _IPC11_ADCDC2IP_LENGTH                   0x00000003

#define _IPC11_w_POSITION                        0x00000000
#define _IPC11_w_MASK                            0xFFFFFFFF
#define _IPC11_w_LENGTH                          0x00000020

#define _IPC12_ADCDC3IS_POSITION                 0x00000000
#define _IPC12_ADCDC3IS_MASK                     0x00000003
#define _IPC12_ADCDC3IS_LENGTH                   0x00000002

#define _IPC12_ADCDC3IP_POSITION                 0x00000002
#define _IPC12_ADCDC3IP_MASK                     0x0000001C
#define _IPC12_ADCDC3IP_LENGTH                   0x00000003

#define _IPC12_ADCDC4IS_POSITION                 0x00000008
#define _IPC12_ADCDC4IS_MASK                     0x00000300
#define _IPC12_ADCDC4IS_LENGTH                   0x00000002

#define _IPC12_ADCDC4IP_POSITION                 0x0000000A
#define _IPC12_ADCDC4IP_MASK                     0x00001C00
#define _IPC12_ADCDC4IP_LENGTH                   0x00000003

#define _IPC12_ADCDC5IS_POSITION                 0x00000010
#define _IPC12_ADCDC5IS_MASK                     0x00030000
#define _IPC12_ADCDC5IS_LENGTH                   0x00000002

#define _IPC12_ADCDC5IP_POSITION                 0x00000012
#define _IPC12_ADCDC5IP_MASK                     0x001C0000
#define _IPC12_ADCDC5IP_LENGTH                   0x00000003

#define _IPC12_ADCDC6IS_POSITION                 0x00000018
#define _IPC12_ADCDC6IS_MASK                     0x03000000
#define _IPC12_ADCDC6IS_LENGTH                   0x00000002

#define _IPC12_ADCDC6IP_POSITION                 0x0000001A
#define _IPC12_ADCDC6IP_MASK                     0x1C000000
#define _IPC12_ADCDC6IP_LENGTH                   0x00000003

#define _IPC12_w_POSITION                        0x00000000
#define _IPC12_w_MASK                            0xFFFFFFFF
#define _IPC12_w_LENGTH                          0x00000020

#define _IPC13_ADCDF1IS_POSITION                 0x00000000
#define _IPC13_ADCDF1IS_MASK                     0x00000003
#define _IPC13_ADCDF1IS_LENGTH                   0x00000002

#define _IPC13_ADCDF1IP_POSITION                 0x00000002
#define _IPC13_ADCDF1IP_MASK                     0x0000001C
#define _IPC13_ADCDF1IP_LENGTH                   0x00000003

#define _IPC13_ADCDF2IS_POSITION                 0x00000008
#define _IPC13_ADCDF2IS_MASK                     0x00000300
#define _IPC13_ADCDF2IS_LENGTH                   0x00000002

#define _IPC13_ADCDF2IP_POSITION                 0x0000000A
#define _IPC13_ADCDF2IP_MASK                     0x00001C00
#define _IPC13_ADCDF2IP_LENGTH                   0x00000003

#define _IPC13_ADCDF3IS_POSITION                 0x00000010
#define _IPC13_ADCDF3IS_MASK                     0x00030000
#define _IPC13_ADCDF3IS_LENGTH                   0x00000002

#define _IPC13_ADCDF3IP_POSITION                 0x00000012
#define _IPC13_ADCDF3IP_MASK                     0x001C0000
#define _IPC13_ADCDF3IP_LENGTH                   0x00000003

#define _IPC13_ADCDF4IS_POSITION                 0x00000018
#define _IPC13_ADCDF4IS_MASK                     0x03000000
#define _IPC13_ADCDF4IS_LENGTH                   0x00000002

#define _IPC13_ADCDF4IP_POSITION                 0x0000001A
#define _IPC13_ADCDF4IP_MASK                     0x1C000000
#define _IPC13_ADCDF4IP_LENGTH                   0x00000003

#define _IPC13_w_POSITION                        0x00000000
#define _IPC13_w_MASK                            0xFFFFFFFF
#define _IPC13_w_LENGTH                          0x00000020

#define _IPC14_ADCDF5IS_POSITION                 0x00000000
#define _IPC14_ADCDF5IS_MASK                     0x00000003
#define _IPC14_ADCDF5IS_LENGTH                   0x00000002

#define _IPC14_ADCDF5IP_POSITION                 0x00000002
#define _IPC14_ADCDF5IP_MASK                     0x0000001C
#define _IPC14_ADCDF5IP_LENGTH                   0x00000003

#define _IPC14_ADCDF6IS_POSITION                 0x00000008
#define _IPC14_ADCDF6IS_MASK                     0x00000300
#define _IPC14_ADCDF6IS_LENGTH                   0x00000002

#define _IPC14_ADCDF6IP_POSITION                 0x0000000A
#define _IPC14_ADCDF6IP_MASK                     0x00001C00
#define _IPC14_ADCDF6IP_LENGTH                   0x00000003

#define _IPC14_ADCFLTIS_POSITION                 0x00000010
#define _IPC14_ADCFLTIS_MASK                     0x00030000
#define _IPC14_ADCFLTIS_LENGTH                   0x00000002

#define _IPC14_ADCFLTIP_POSITION                 0x00000012
#define _IPC14_ADCFLTIP_MASK                     0x001C0000
#define _IPC14_ADCFLTIP_LENGTH                   0x00000003

#define _IPC14_ADCD0IS_POSITION                  0x00000018
#define _IPC14_ADCD0IS_MASK                      0x03000000
#define _IPC14_ADCD0IS_LENGTH                    0x00000002

#define _IPC14_ADCD0IP_POSITION                  0x0000001A
#define _IPC14_ADCD0IP_MASK                      0x1C000000
#define _IPC14_ADCD0IP_LENGTH                    0x00000003

#define _IPC14_w_POSITION                        0x00000000
#define _IPC14_w_MASK                            0xFFFFFFFF
#define _IPC14_w_LENGTH                          0x00000020

#define _IPC15_ADCD1IS_POSITION                  0x00000000
#define _IPC15_ADCD1IS_MASK                      0x00000003
#define _IPC15_ADCD1IS_LENGTH                    0x00000002

#define _IPC15_ADCD1IP_POSITION                  0x00000002
#define _IPC15_ADCD1IP_MASK                      0x0000001C
#define _IPC15_ADCD1IP_LENGTH                    0x00000003

#define _IPC15_ADCD2IS_POSITION                  0x00000008
#define _IPC15_ADCD2IS_MASK                      0x00000300
#define _IPC15_ADCD2IS_LENGTH                    0x00000002

#define _IPC15_ADCD2IP_POSITION                  0x0000000A
#define _IPC15_ADCD2IP_MASK                      0x00001C00
#define _IPC15_ADCD2IP_LENGTH                    0x00000003

#define _IPC15_ADCD3IS_POSITION                  0x00000010
#define _IPC15_ADCD3IS_MASK                      0x00030000
#define _IPC15_ADCD3IS_LENGTH                    0x00000002

#define _IPC15_ADCD3IP_POSITION                  0x00000012
#define _IPC15_ADCD3IP_MASK                      0x001C0000
#define _IPC15_ADCD3IP_LENGTH                    0x00000003

#define _IPC15_ADCD4IS_POSITION                  0x00000018
#define _IPC15_ADCD4IS_MASK                      0x03000000
#define _IPC15_ADCD4IS_LENGTH                    0x00000002

#define _IPC15_ADCD4IP_POSITION                  0x0000001A
#define _IPC15_ADCD4IP_MASK                      0x1C000000
#define _IPC15_ADCD4IP_LENGTH                    0x00000003

#define _IPC15_w_POSITION                        0x00000000
#define _IPC15_w_MASK                            0xFFFFFFFF
#define _IPC15_w_LENGTH                          0x00000020

#define _IPC16_ADCD5IS_POSITION                  0x00000000
#define _IPC16_ADCD5IS_MASK                      0x00000003
#define _IPC16_ADCD5IS_LENGTH                    0x00000002

#define _IPC16_ADCD5IP_POSITION                  0x00000002
#define _IPC16_ADCD5IP_MASK                      0x0000001C
#define _IPC16_ADCD5IP_LENGTH                    0x00000003

#define _IPC16_ADCD6IS_POSITION                  0x00000008
#define _IPC16_ADCD6IS_MASK                      0x00000300
#define _IPC16_ADCD6IS_LENGTH                    0x00000002

#define _IPC16_ADCD6IP_POSITION                  0x0000000A
#define _IPC16_ADCD6IP_MASK                      0x00001C00
#define _IPC16_ADCD6IP_LENGTH                    0x00000003

#define _IPC16_ADCD7IS_POSITION                  0x00000010
#define _IPC16_ADCD7IS_MASK                      0x00030000
#define _IPC16_ADCD7IS_LENGTH                    0x00000002

#define _IPC16_ADCD7IP_POSITION                  0x00000012
#define _IPC16_ADCD7IP_MASK                      0x001C0000
#define _IPC16_ADCD7IP_LENGTH                    0x00000003

#define _IPC16_ADCD8IS_POSITION                  0x00000018
#define _IPC16_ADCD8IS_MASK                      0x03000000
#define _IPC16_ADCD8IS_LENGTH                    0x00000002

#define _IPC16_ADCD8IP_POSITION                  0x0000001A
#define _IPC16_ADCD8IP_MASK                      0x1C000000
#define _IPC16_ADCD8IP_LENGTH                    0x00000003

#define _IPC16_w_POSITION                        0x00000000
#define _IPC16_w_MASK                            0xFFFFFFFF
#define _IPC16_w_LENGTH                          0x00000020

#define _IPC17_ADCD9IS_POSITION                  0x00000000
#define _IPC17_ADCD9IS_MASK                      0x00000003
#define _IPC17_ADCD9IS_LENGTH                    0x00000002

#define _IPC17_ADCD9IP_POSITION                  0x00000002
#define _IPC17_ADCD9IP_MASK                      0x0000001C
#define _IPC17_ADCD9IP_LENGTH                    0x00000003

#define _IPC17_ADCD10IS_POSITION                 0x00000008
#define _IPC17_ADCD10IS_MASK                     0x00000300
#define _IPC17_ADCD10IS_LENGTH                   0x00000002

#define _IPC17_ADCD10IP_POSITION                 0x0000000A
#define _IPC17_ADCD10IP_MASK                     0x00001C00
#define _IPC17_ADCD10IP_LENGTH                   0x00000003

#define _IPC17_ADCD11IS_POSITION                 0x00000010
#define _IPC17_ADCD11IS_MASK                     0x00030000
#define _IPC17_ADCD11IS_LENGTH                   0x00000002

#define _IPC17_ADCD11IP_POSITION                 0x00000012
#define _IPC17_ADCD11IP_MASK                     0x001C0000
#define _IPC17_ADCD11IP_LENGTH                   0x00000003

#define _IPC17_ADCD12IS_POSITION                 0x00000018
#define _IPC17_ADCD12IS_MASK                     0x03000000
#define _IPC17_ADCD12IS_LENGTH                   0x00000002

#define _IPC17_ADCD12IP_POSITION                 0x0000001A
#define _IPC17_ADCD12IP_MASK                     0x1C000000
#define _IPC17_ADCD12IP_LENGTH                   0x00000003

#define _IPC17_w_POSITION                        0x00000000
#define _IPC17_w_MASK                            0xFFFFFFFF
#define _IPC17_w_LENGTH                          0x00000020

#define _IPC18_ADCD13IS_POSITION                 0x00000000
#define _IPC18_ADCD13IS_MASK                     0x00000003
#define _IPC18_ADCD13IS_LENGTH                   0x00000002

#define _IPC18_ADCD13IP_POSITION                 0x00000002
#define _IPC18_ADCD13IP_MASK                     0x0000001C
#define _IPC18_ADCD13IP_LENGTH                   0x00000003

#define _IPC18_ADCD14IS_POSITION                 0x00000008
#define _IPC18_ADCD14IS_MASK                     0x00000300
#define _IPC18_ADCD14IS_LENGTH                   0x00000002

#define _IPC18_ADCD14IP_POSITION                 0x0000000A
#define _IPC18_ADCD14IP_MASK                     0x00001C00
#define _IPC18_ADCD14IP_LENGTH                   0x00000003

#define _IPC18_ADCD15IS_POSITION                 0x00000010
#define _IPC18_ADCD15IS_MASK                     0x00030000
#define _IPC18_ADCD15IS_LENGTH                   0x00000002

#define _IPC18_ADCD15IP_POSITION                 0x00000012
#define _IPC18_ADCD15IP_MASK                     0x001C0000
#define _IPC18_ADCD15IP_LENGTH                   0x00000003

#define _IPC18_ADCD16IS_POSITION                 0x00000018
#define _IPC18_ADCD16IS_MASK                     0x03000000
#define _IPC18_ADCD16IS_LENGTH                   0x00000002

#define _IPC18_ADCD16IP_POSITION                 0x0000001A
#define _IPC18_ADCD16IP_MASK                     0x1C000000
#define _IPC18_ADCD16IP_LENGTH                   0x00000003

#define _IPC18_w_POSITION                        0x00000000
#define _IPC18_w_MASK                            0xFFFFFFFF
#define _IPC18_w_LENGTH                          0x00000020

#define _IPC19_ADCD17IS_POSITION                 0x00000000
#define _IPC19_ADCD17IS_MASK                     0x00000003
#define _IPC19_ADCD17IS_LENGTH                   0x00000002

#define _IPC19_ADCD17IP_POSITION                 0x00000002
#define _IPC19_ADCD17IP_MASK                     0x0000001C
#define _IPC19_ADCD17IP_LENGTH                   0x00000003

#define _IPC19_ADCD18IS_POSITION                 0x00000008
#define _IPC19_ADCD18IS_MASK                     0x00000300
#define _IPC19_ADCD18IS_LENGTH                   0x00000002

#define _IPC19_ADCD18IP_POSITION                 0x0000000A
#define _IPC19_ADCD18IP_MASK                     0x00001C00
#define _IPC19_ADCD18IP_LENGTH                   0x00000003

#define _IPC19_ADCD19IS_POSITION                 0x00000010
#define _IPC19_ADCD19IS_MASK                     0x00030000
#define _IPC19_ADCD19IS_LENGTH                   0x00000002

#define _IPC19_ADCD19IP_POSITION                 0x00000012
#define _IPC19_ADCD19IP_MASK                     0x001C0000
#define _IPC19_ADCD19IP_LENGTH                   0x00000003

#define _IPC19_ADCD20IS_POSITION                 0x00000018
#define _IPC19_ADCD20IS_MASK                     0x03000000
#define _IPC19_ADCD20IS_LENGTH                   0x00000002

#define _IPC19_ADCD20IP_POSITION                 0x0000001A
#define _IPC19_ADCD20IP_MASK                     0x1C000000
#define _IPC19_ADCD20IP_LENGTH                   0x00000003

#define _IPC19_w_POSITION                        0x00000000
#define _IPC19_w_MASK                            0xFFFFFFFF
#define _IPC19_w_LENGTH                          0x00000020

#define _IPC20_ADCD21IS_POSITION                 0x00000000
#define _IPC20_ADCD21IS_MASK                     0x00000003
#define _IPC20_ADCD21IS_LENGTH                   0x00000002

#define _IPC20_ADCD21IP_POSITION                 0x00000002
#define _IPC20_ADCD21IP_MASK                     0x0000001C
#define _IPC20_ADCD21IP_LENGTH                   0x00000003

#define _IPC20_ADCD22IS_POSITION                 0x00000008
#define _IPC20_ADCD22IS_MASK                     0x00000300
#define _IPC20_ADCD22IS_LENGTH                   0x00000002

#define _IPC20_ADCD22IP_POSITION                 0x0000000A
#define _IPC20_ADCD22IP_MASK                     0x00001C00
#define _IPC20_ADCD22IP_LENGTH                   0x00000003

#define _IPC20_ADCD23IS_POSITION                 0x00000010
#define _IPC20_ADCD23IS_MASK                     0x00030000
#define _IPC20_ADCD23IS_LENGTH                   0x00000002

#define _IPC20_ADCD23IP_POSITION                 0x00000012
#define _IPC20_ADCD23IP_MASK                     0x001C0000
#define _IPC20_ADCD23IP_LENGTH                   0x00000003

#define _IPC20_ADCD24IS_POSITION                 0x00000018
#define _IPC20_ADCD24IS_MASK                     0x03000000
#define _IPC20_ADCD24IS_LENGTH                   0x00000002

#define _IPC20_ADCD24IP_POSITION                 0x0000001A
#define _IPC20_ADCD24IP_MASK                     0x1C000000
#define _IPC20_ADCD24IP_LENGTH                   0x00000003

#define _IPC20_w_POSITION                        0x00000000
#define _IPC20_w_MASK                            0xFFFFFFFF
#define _IPC20_w_LENGTH                          0x00000020

#define _IPC21_ADCD25IS_POSITION                 0x00000000
#define _IPC21_ADCD25IS_MASK                     0x00000003
#define _IPC21_ADCD25IS_LENGTH                   0x00000002

#define _IPC21_ADCD25IP_POSITION                 0x00000002
#define _IPC21_ADCD25IP_MASK                     0x0000001C
#define _IPC21_ADCD25IP_LENGTH                   0x00000003

#define _IPC21_ADCD26IS_POSITION                 0x00000008
#define _IPC21_ADCD26IS_MASK                     0x00000300
#define _IPC21_ADCD26IS_LENGTH                   0x00000002

#define _IPC21_ADCD26IP_POSITION                 0x0000000A
#define _IPC21_ADCD26IP_MASK                     0x00001C00
#define _IPC21_ADCD26IP_LENGTH                   0x00000003

#define _IPC21_ADCD27IS_POSITION                 0x00000010
#define _IPC21_ADCD27IS_MASK                     0x00030000
#define _IPC21_ADCD27IS_LENGTH                   0x00000002

#define _IPC21_ADCD27IP_POSITION                 0x00000012
#define _IPC21_ADCD27IP_MASK                     0x001C0000
#define _IPC21_ADCD27IP_LENGTH                   0x00000003

#define _IPC21_ADCD28IS_POSITION                 0x00000018
#define _IPC21_ADCD28IS_MASK                     0x03000000
#define _IPC21_ADCD28IS_LENGTH                   0x00000002

#define _IPC21_ADCD28IP_POSITION                 0x0000001A
#define _IPC21_ADCD28IP_MASK                     0x1C000000
#define _IPC21_ADCD28IP_LENGTH                   0x00000003

#define _IPC21_w_POSITION                        0x00000000
#define _IPC21_w_MASK                            0xFFFFFFFF
#define _IPC21_w_LENGTH                          0x00000020

#define _IPC22_ADCD29IS_POSITION                 0x00000000
#define _IPC22_ADCD29IS_MASK                     0x00000003
#define _IPC22_ADCD29IS_LENGTH                   0x00000002

#define _IPC22_ADCD29IP_POSITION                 0x00000002
#define _IPC22_ADCD29IP_MASK                     0x0000001C
#define _IPC22_ADCD29IP_LENGTH                   0x00000003

#define _IPC22_ADCD30IS_POSITION                 0x00000008
#define _IPC22_ADCD30IS_MASK                     0x00000300
#define _IPC22_ADCD30IS_LENGTH                   0x00000002

#define _IPC22_ADCD30IP_POSITION                 0x0000000A
#define _IPC22_ADCD30IP_MASK                     0x00001C00
#define _IPC22_ADCD30IP_LENGTH                   0x00000003

#define _IPC22_ADCD31IS_POSITION                 0x00000010
#define _IPC22_ADCD31IS_MASK                     0x00030000
#define _IPC22_ADCD31IS_LENGTH                   0x00000002

#define _IPC22_ADCD31IP_POSITION                 0x00000012
#define _IPC22_ADCD31IP_MASK                     0x001C0000
#define _IPC22_ADCD31IP_LENGTH                   0x00000003

#define _IPC22_ADCD32IS_POSITION                 0x00000018
#define _IPC22_ADCD32IS_MASK                     0x03000000
#define _IPC22_ADCD32IS_LENGTH                   0x00000002

#define _IPC22_ADCD32IP_POSITION                 0x0000001A
#define _IPC22_ADCD32IP_MASK                     0x1C000000
#define _IPC22_ADCD32IP_LENGTH                   0x00000003

#define _IPC22_w_POSITION                        0x00000000
#define _IPC22_w_MASK                            0xFFFFFFFF
#define _IPC22_w_LENGTH                          0x00000020

#define _IPC23_ADCD33IS_POSITION                 0x00000000
#define _IPC23_ADCD33IS_MASK                     0x00000003
#define _IPC23_ADCD33IS_LENGTH                   0x00000002

#define _IPC23_ADCD33IP_POSITION                 0x00000002
#define _IPC23_ADCD33IP_MASK                     0x0000001C
#define _IPC23_ADCD33IP_LENGTH                   0x00000003

#define _IPC23_ADCD34IS_POSITION                 0x00000008
#define _IPC23_ADCD34IS_MASK                     0x00000300
#define _IPC23_ADCD34IS_LENGTH                   0x00000002

#define _IPC23_ADCD34IP_POSITION                 0x0000000A
#define _IPC23_ADCD34IP_MASK                     0x00001C00
#define _IPC23_ADCD34IP_LENGTH                   0x00000003

#define _IPC23_w_POSITION                        0x00000000
#define _IPC23_w_MASK                            0xFFFFFFFF
#define _IPC23_w_LENGTH                          0x00000020

#define _IPC25_ADCD43IS_POSITION                 0x00000010
#define _IPC25_ADCD43IS_MASK                     0x00030000
#define _IPC25_ADCD43IS_LENGTH                   0x00000002

#define _IPC25_ADCD43IP_POSITION                 0x00000012
#define _IPC25_ADCD43IP_MASK                     0x001C0000
#define _IPC25_ADCD43IP_LENGTH                   0x00000003

#define _IPC25_ADCD44IS_POSITION                 0x00000018
#define _IPC25_ADCD44IS_MASK                     0x03000000
#define _IPC25_ADCD44IS_LENGTH                   0x00000002

#define _IPC25_ADCD44IP_POSITION                 0x0000001A
#define _IPC25_ADCD44IP_MASK                     0x1C000000
#define _IPC25_ADCD44IP_LENGTH                   0x00000003

#define _IPC25_w_POSITION                        0x00000000
#define _IPC25_w_MASK                            0xFFFFFFFF
#define _IPC25_w_LENGTH                          0x00000020

#define _IPC26_CPCIS_POSITION                    0x00000000
#define _IPC26_CPCIS_MASK                        0x00000003
#define _IPC26_CPCIS_LENGTH                      0x00000002

#define _IPC26_CPCIP_POSITION                    0x00000002
#define _IPC26_CPCIP_MASK                        0x0000001C
#define _IPC26_CPCIP_LENGTH                      0x00000003

#define _IPC26_CFDCIS_POSITION                   0x00000008
#define _IPC26_CFDCIS_MASK                       0x00000300
#define _IPC26_CFDCIS_LENGTH                     0x00000002

#define _IPC26_CFDCIP_POSITION                   0x0000000A
#define _IPC26_CFDCIP_MASK                       0x00001C00
#define _IPC26_CFDCIP_LENGTH                     0x00000003

#define _IPC26_SBIS_POSITION                     0x00000010
#define _IPC26_SBIS_MASK                         0x00030000
#define _IPC26_SBIS_LENGTH                       0x00000002

#define _IPC26_SBIP_POSITION                     0x00000012
#define _IPC26_SBIP_MASK                         0x001C0000
#define _IPC26_SBIP_LENGTH                       0x00000003

#define _IPC26_w_POSITION                        0x00000000
#define _IPC26_w_MASK                            0xFFFFFFFF
#define _IPC26_w_LENGTH                          0x00000020

#define _IPC27_SPI1EIS_POSITION                  0x00000008
#define _IPC27_SPI1EIS_MASK                      0x00000300
#define _IPC27_SPI1EIS_LENGTH                    0x00000002

#define _IPC27_SPI1EIP_POSITION                  0x0000000A
#define _IPC27_SPI1EIP_MASK                      0x00001C00
#define _IPC27_SPI1EIP_LENGTH                    0x00000003

#define _IPC27_SPI1RXIS_POSITION                 0x00000010
#define _IPC27_SPI1RXIS_MASK                     0x00030000
#define _IPC27_SPI1RXIS_LENGTH                   0x00000002

#define _IPC27_SPI1RXIP_POSITION                 0x00000012
#define _IPC27_SPI1RXIP_MASK                     0x001C0000
#define _IPC27_SPI1RXIP_LENGTH                   0x00000003

#define _IPC27_SPI1TXIS_POSITION                 0x00000018
#define _IPC27_SPI1TXIS_MASK                     0x03000000
#define _IPC27_SPI1TXIS_LENGTH                   0x00000002

#define _IPC27_SPI1TXIP_POSITION                 0x0000001A
#define _IPC27_SPI1TXIP_MASK                     0x1C000000
#define _IPC27_SPI1TXIP_LENGTH                   0x00000003

#define _IPC27_w_POSITION                        0x00000000
#define _IPC27_w_MASK                            0xFFFFFFFF
#define _IPC27_w_LENGTH                          0x00000020

#define _IPC28_U1EIS_POSITION                    0x00000000
#define _IPC28_U1EIS_MASK                        0x00000003
#define _IPC28_U1EIS_LENGTH                      0x00000002

#define _IPC28_U1EIP_POSITION                    0x00000002
#define _IPC28_U1EIP_MASK                        0x0000001C
#define _IPC28_U1EIP_LENGTH                      0x00000003

#define _IPC28_U1RXIS_POSITION                   0x00000008
#define _IPC28_U1RXIS_MASK                       0x00000300
#define _IPC28_U1RXIS_LENGTH                     0x00000002

#define _IPC28_U1RXIP_POSITION                   0x0000000A
#define _IPC28_U1RXIP_MASK                       0x00001C00
#define _IPC28_U1RXIP_LENGTH                     0x00000003

#define _IPC28_U1TXIS_POSITION                   0x00000010
#define _IPC28_U1TXIS_MASK                       0x00030000
#define _IPC28_U1TXIS_LENGTH                     0x00000002

#define _IPC28_U1TXIP_POSITION                   0x00000012
#define _IPC28_U1TXIP_MASK                       0x001C0000
#define _IPC28_U1TXIP_LENGTH                     0x00000003

#define _IPC28_I2C1BIS_POSITION                  0x00000018
#define _IPC28_I2C1BIS_MASK                      0x03000000
#define _IPC28_I2C1BIS_LENGTH                    0x00000002

#define _IPC28_I2C1BIP_POSITION                  0x0000001A
#define _IPC28_I2C1BIP_MASK                      0x1C000000
#define _IPC28_I2C1BIP_LENGTH                    0x00000003

#define _IPC28_w_POSITION                        0x00000000
#define _IPC28_w_MASK                            0xFFFFFFFF
#define _IPC28_w_LENGTH                          0x00000020

#define _IPC29_I2C1SIS_POSITION                  0x00000000
#define _IPC29_I2C1SIS_MASK                      0x00000003
#define _IPC29_I2C1SIS_LENGTH                    0x00000002

#define _IPC29_I2C1SIP_POSITION                  0x00000002
#define _IPC29_I2C1SIP_MASK                      0x0000001C
#define _IPC29_I2C1SIP_LENGTH                    0x00000003

#define _IPC29_I2C1MIS_POSITION                  0x00000008
#define _IPC29_I2C1MIS_MASK                      0x00000300
#define _IPC29_I2C1MIS_LENGTH                    0x00000002

#define _IPC29_I2C1MIP_POSITION                  0x0000000A
#define _IPC29_I2C1MIP_MASK                      0x00001C00
#define _IPC29_I2C1MIP_LENGTH                    0x00000003

#define _IPC29_CNAIS_POSITION                    0x00000010
#define _IPC29_CNAIS_MASK                        0x00030000
#define _IPC29_CNAIS_LENGTH                      0x00000002

#define _IPC29_CNAIP_POSITION                    0x00000012
#define _IPC29_CNAIP_MASK                        0x001C0000
#define _IPC29_CNAIP_LENGTH                      0x00000003

#define _IPC29_CNBIS_POSITION                    0x00000018
#define _IPC29_CNBIS_MASK                        0x03000000
#define _IPC29_CNBIS_LENGTH                      0x00000002

#define _IPC29_CNBIP_POSITION                    0x0000001A
#define _IPC29_CNBIP_MASK                        0x1C000000
#define _IPC29_CNBIP_LENGTH                      0x00000003

#define _IPC29_w_POSITION                        0x00000000
#define _IPC29_w_MASK                            0xFFFFFFFF
#define _IPC29_w_LENGTH                          0x00000020

#define _IPC30_CNCIS_POSITION                    0x00000000
#define _IPC30_CNCIS_MASK                        0x00000003
#define _IPC30_CNCIS_LENGTH                      0x00000002

#define _IPC30_CNCIP_POSITION                    0x00000002
#define _IPC30_CNCIP_MASK                        0x0000001C
#define _IPC30_CNCIP_LENGTH                      0x00000003

#define _IPC30_CNDIS_POSITION                    0x00000008
#define _IPC30_CNDIS_MASK                        0x00000300
#define _IPC30_CNDIS_LENGTH                      0x00000002

#define _IPC30_CNDIP_POSITION                    0x0000000A
#define _IPC30_CNDIP_MASK                        0x00001C00
#define _IPC30_CNDIP_LENGTH                      0x00000003

#define _IPC30_CNEIS_POSITION                    0x00000010
#define _IPC30_CNEIS_MASK                        0x00030000
#define _IPC30_CNEIS_LENGTH                      0x00000002

#define _IPC30_CNEIP_POSITION                    0x00000012
#define _IPC30_CNEIP_MASK                        0x001C0000
#define _IPC30_CNEIP_LENGTH                      0x00000003

#define _IPC30_CNFIS_POSITION                    0x00000018
#define _IPC30_CNFIS_MASK                        0x03000000
#define _IPC30_CNFIS_LENGTH                      0x00000002

#define _IPC30_CNFIP_POSITION                    0x0000001A
#define _IPC30_CNFIP_MASK                        0x1C000000
#define _IPC30_CNFIP_LENGTH                      0x00000003

#define _IPC30_w_POSITION                        0x00000000
#define _IPC30_w_MASK                            0xFFFFFFFF
#define _IPC30_w_LENGTH                          0x00000020

#define _IPC31_CNGIS_POSITION                    0x00000000
#define _IPC31_CNGIS_MASK                        0x00000003
#define _IPC31_CNGIS_LENGTH                      0x00000002

#define _IPC31_CNGIP_POSITION                    0x00000002
#define _IPC31_CNGIP_MASK                        0x0000001C
#define _IPC31_CNGIP_LENGTH                      0x00000003

#define _IPC31_w_POSITION                        0x00000000
#define _IPC31_w_MASK                            0xFFFFFFFF
#define _IPC31_w_LENGTH                          0x00000020

#define _IPC32_PMPIS_POSITION                    0x00000000
#define _IPC32_PMPIS_MASK                        0x00000003
#define _IPC32_PMPIS_LENGTH                      0x00000002

#define _IPC32_PMPIP_POSITION                    0x00000002
#define _IPC32_PMPIP_MASK                        0x0000001C
#define _IPC32_PMPIP_LENGTH                      0x00000003

#define _IPC32_PMPEIS_POSITION                   0x00000008
#define _IPC32_PMPEIS_MASK                       0x00000300
#define _IPC32_PMPEIS_LENGTH                     0x00000002

#define _IPC32_PMPEIP_POSITION                   0x0000000A
#define _IPC32_PMPEIP_MASK                       0x00001C00
#define _IPC32_PMPEIP_LENGTH                     0x00000003

#define _IPC32_CMP1IS_POSITION                   0x00000010
#define _IPC32_CMP1IS_MASK                       0x00030000
#define _IPC32_CMP1IS_LENGTH                     0x00000002

#define _IPC32_CMP1IP_POSITION                   0x00000012
#define _IPC32_CMP1IP_MASK                       0x001C0000
#define _IPC32_CMP1IP_LENGTH                     0x00000003

#define _IPC32_CMP2IS_POSITION                   0x00000018
#define _IPC32_CMP2IS_MASK                       0x03000000
#define _IPC32_CMP2IS_LENGTH                     0x00000002

#define _IPC32_CMP2IP_POSITION                   0x0000001A
#define _IPC32_CMP2IP_MASK                       0x1C000000
#define _IPC32_CMP2IP_LENGTH                     0x00000003

#define _IPC32_w_POSITION                        0x00000000
#define _IPC32_w_MASK                            0xFFFFFFFF
#define _IPC32_w_LENGTH                          0x00000020

#define _IPC33_USBIS_POSITION                    0x00000000
#define _IPC33_USBIS_MASK                        0x00000003
#define _IPC33_USBIS_LENGTH                      0x00000002

#define _IPC33_USBIP_POSITION                    0x00000002
#define _IPC33_USBIP_MASK                        0x0000001C
#define _IPC33_USBIP_LENGTH                      0x00000003

#define _IPC33_USBDMAIS_POSITION                 0x00000008
#define _IPC33_USBDMAIS_MASK                     0x00000300
#define _IPC33_USBDMAIS_LENGTH                   0x00000002

#define _IPC33_USBDMAIP_POSITION                 0x0000000A
#define _IPC33_USBDMAIP_MASK                     0x00001C00
#define _IPC33_USBDMAIP_LENGTH                   0x00000003

#define _IPC33_DMA0IS_POSITION                   0x00000010
#define _IPC33_DMA0IS_MASK                       0x00030000
#define _IPC33_DMA0IS_LENGTH                     0x00000002

#define _IPC33_DMA0IP_POSITION                   0x00000012
#define _IPC33_DMA0IP_MASK                       0x001C0000
#define _IPC33_DMA0IP_LENGTH                     0x00000003

#define _IPC33_DMA1IS_POSITION                   0x00000018
#define _IPC33_DMA1IS_MASK                       0x03000000
#define _IPC33_DMA1IS_LENGTH                     0x00000002

#define _IPC33_DMA1IP_POSITION                   0x0000001A
#define _IPC33_DMA1IP_MASK                       0x1C000000
#define _IPC33_DMA1IP_LENGTH                     0x00000003

#define _IPC33_w_POSITION                        0x00000000
#define _IPC33_w_MASK                            0xFFFFFFFF
#define _IPC33_w_LENGTH                          0x00000020

#define _IPC34_DMA2IS_POSITION                   0x00000000
#define _IPC34_DMA2IS_MASK                       0x00000003
#define _IPC34_DMA2IS_LENGTH                     0x00000002

#define _IPC34_DMA2IP_POSITION                   0x00000002
#define _IPC34_DMA2IP_MASK                       0x0000001C
#define _IPC34_DMA2IP_LENGTH                     0x00000003

#define _IPC34_DMA3IS_POSITION                   0x00000008
#define _IPC34_DMA3IS_MASK                       0x00000300
#define _IPC34_DMA3IS_LENGTH                     0x00000002

#define _IPC34_DMA3IP_POSITION                   0x0000000A
#define _IPC34_DMA3IP_MASK                       0x00001C00
#define _IPC34_DMA3IP_LENGTH                     0x00000003

#define _IPC34_DMA4IS_POSITION                   0x00000010
#define _IPC34_DMA4IS_MASK                       0x00030000
#define _IPC34_DMA4IS_LENGTH                     0x00000002

#define _IPC34_DMA4IP_POSITION                   0x00000012
#define _IPC34_DMA4IP_MASK                       0x001C0000
#define _IPC34_DMA4IP_LENGTH                     0x00000003

#define _IPC34_DMA5IS_POSITION                   0x00000018
#define _IPC34_DMA5IS_MASK                       0x03000000
#define _IPC34_DMA5IS_LENGTH                     0x00000002

#define _IPC34_DMA5IP_POSITION                   0x0000001A
#define _IPC34_DMA5IP_MASK                       0x1C000000
#define _IPC34_DMA5IP_LENGTH                     0x00000003

#define _IPC34_w_POSITION                        0x00000000
#define _IPC34_w_MASK                            0xFFFFFFFF
#define _IPC34_w_LENGTH                          0x00000020

#define _IPC35_DMA6IS_POSITION                   0x00000000
#define _IPC35_DMA6IS_MASK                       0x00000003
#define _IPC35_DMA6IS_LENGTH                     0x00000002

#define _IPC35_DMA6IP_POSITION                   0x00000002
#define _IPC35_DMA6IP_MASK                       0x0000001C
#define _IPC35_DMA6IP_LENGTH                     0x00000003

#define _IPC35_DMA7IS_POSITION                   0x00000008
#define _IPC35_DMA7IS_MASK                       0x00000300
#define _IPC35_DMA7IS_LENGTH                     0x00000002

#define _IPC35_DMA7IP_POSITION                   0x0000000A
#define _IPC35_DMA7IP_MASK                       0x00001C00
#define _IPC35_DMA7IP_LENGTH                     0x00000003

#define _IPC35_SPI2EIS_POSITION                  0x00000010
#define _IPC35_SPI2EIS_MASK                      0x00030000
#define _IPC35_SPI2EIS_LENGTH                    0x00000002

#define _IPC35_SPI2EIP_POSITION                  0x00000012
#define _IPC35_SPI2EIP_MASK                      0x001C0000
#define _IPC35_SPI2EIP_LENGTH                    0x00000003

#define _IPC35_SPI2RXIS_POSITION                 0x00000018
#define _IPC35_SPI2RXIS_MASK                     0x03000000
#define _IPC35_SPI2RXIS_LENGTH                   0x00000002

#define _IPC35_SPI2RXIP_POSITION                 0x0000001A
#define _IPC35_SPI2RXIP_MASK                     0x1C000000
#define _IPC35_SPI2RXIP_LENGTH                   0x00000003

#define _IPC35_w_POSITION                        0x00000000
#define _IPC35_w_MASK                            0xFFFFFFFF
#define _IPC35_w_LENGTH                          0x00000020

#define _IPC36_SPI2TXIS_POSITION                 0x00000000
#define _IPC36_SPI2TXIS_MASK                     0x00000003
#define _IPC36_SPI2TXIS_LENGTH                   0x00000002

#define _IPC36_SPI2TXIP_POSITION                 0x00000002
#define _IPC36_SPI2TXIP_MASK                     0x0000001C
#define _IPC36_SPI2TXIP_LENGTH                   0x00000003

#define _IPC36_U2EIS_POSITION                    0x00000008
#define _IPC36_U2EIS_MASK                        0x00000300
#define _IPC36_U2EIS_LENGTH                      0x00000002

#define _IPC36_U2EIP_POSITION                    0x0000000A
#define _IPC36_U2EIP_MASK                        0x00001C00
#define _IPC36_U2EIP_LENGTH                      0x00000003

#define _IPC36_U2RXIS_POSITION                   0x00000010
#define _IPC36_U2RXIS_MASK                       0x00030000
#define _IPC36_U2RXIS_LENGTH                     0x00000002

#define _IPC36_U2RXIP_POSITION                   0x00000012
#define _IPC36_U2RXIP_MASK                       0x001C0000
#define _IPC36_U2RXIP_LENGTH                     0x00000003

#define _IPC36_U2TXIS_POSITION                   0x00000018
#define _IPC36_U2TXIS_MASK                       0x03000000
#define _IPC36_U2TXIS_LENGTH                     0x00000002

#define _IPC36_U2TXIP_POSITION                   0x0000001A
#define _IPC36_U2TXIP_MASK                       0x1C000000
#define _IPC36_U2TXIP_LENGTH                     0x00000003

#define _IPC36_w_POSITION                        0x00000000
#define _IPC36_w_MASK                            0xFFFFFFFF
#define _IPC36_w_LENGTH                          0x00000020

#define _IPC37_I2C2BIS_POSITION                  0x00000000
#define _IPC37_I2C2BIS_MASK                      0x00000003
#define _IPC37_I2C2BIS_LENGTH                    0x00000002

#define _IPC37_I2C2BIP_POSITION                  0x00000002
#define _IPC37_I2C2BIP_MASK                      0x0000001C
#define _IPC37_I2C2BIP_LENGTH                    0x00000003

#define _IPC37_I2C2SIS_POSITION                  0x00000008
#define _IPC37_I2C2SIS_MASK                      0x00000300
#define _IPC37_I2C2SIS_LENGTH                    0x00000002

#define _IPC37_I2C2SIP_POSITION                  0x0000000A
#define _IPC37_I2C2SIP_MASK                      0x00001C00
#define _IPC37_I2C2SIP_LENGTH                    0x00000003

#define _IPC37_I2C2MIS_POSITION                  0x00000010
#define _IPC37_I2C2MIS_MASK                      0x00030000
#define _IPC37_I2C2MIS_LENGTH                    0x00000002

#define _IPC37_I2C2MIP_POSITION                  0x00000012
#define _IPC37_I2C2MIP_MASK                      0x001C0000
#define _IPC37_I2C2MIP_LENGTH                    0x00000003

#define _IPC37_w_POSITION                        0x00000000
#define _IPC37_w_MASK                            0xFFFFFFFF
#define _IPC37_w_LENGTH                          0x00000020

#define _IPC38_ETHIS_POSITION                    0x00000008
#define _IPC38_ETHIS_MASK                        0x00000300
#define _IPC38_ETHIS_LENGTH                      0x00000002

#define _IPC38_ETHIP_POSITION                    0x0000000A
#define _IPC38_ETHIP_MASK                        0x00001C00
#define _IPC38_ETHIP_LENGTH                      0x00000003

#define _IPC38_SPI3EIS_POSITION                  0x00000010
#define _IPC38_SPI3EIS_MASK                      0x00030000
#define _IPC38_SPI3EIS_LENGTH                    0x00000002

#define _IPC38_SPI3EIP_POSITION                  0x00000012
#define _IPC38_SPI3EIP_MASK                      0x001C0000
#define _IPC38_SPI3EIP_LENGTH                    0x00000003

#define _IPC38_SPI3RXIS_POSITION                 0x00000018
#define _IPC38_SPI3RXIS_MASK                     0x03000000
#define _IPC38_SPI3RXIS_LENGTH                   0x00000002

#define _IPC38_SPI3RXIP_POSITION                 0x0000001A
#define _IPC38_SPI3RXIP_MASK                     0x1C000000
#define _IPC38_SPI3RXIP_LENGTH                   0x00000003

#define _IPC38_w_POSITION                        0x00000000
#define _IPC38_w_MASK                            0xFFFFFFFF
#define _IPC38_w_LENGTH                          0x00000020

#define _IPC39_SPI3TXIS_POSITION                 0x00000000
#define _IPC39_SPI3TXIS_MASK                     0x00000003
#define _IPC39_SPI3TXIS_LENGTH                   0x00000002

#define _IPC39_SPI3TXIP_POSITION                 0x00000002
#define _IPC39_SPI3TXIP_MASK                     0x0000001C
#define _IPC39_SPI3TXIP_LENGTH                   0x00000003

#define _IPC39_U3EIS_POSITION                    0x00000008
#define _IPC39_U3EIS_MASK                        0x00000300
#define _IPC39_U3EIS_LENGTH                      0x00000002

#define _IPC39_U3EIP_POSITION                    0x0000000A
#define _IPC39_U3EIP_MASK                        0x00001C00
#define _IPC39_U3EIP_LENGTH                      0x00000003

#define _IPC39_U3RXIS_POSITION                   0x00000010
#define _IPC39_U3RXIS_MASK                       0x00030000
#define _IPC39_U3RXIS_LENGTH                     0x00000002

#define _IPC39_U3RXIP_POSITION                   0x00000012
#define _IPC39_U3RXIP_MASK                       0x001C0000
#define _IPC39_U3RXIP_LENGTH                     0x00000003

#define _IPC39_U3TXIS_POSITION                   0x00000018
#define _IPC39_U3TXIS_MASK                       0x03000000
#define _IPC39_U3TXIS_LENGTH                     0x00000002

#define _IPC39_U3TXIP_POSITION                   0x0000001A
#define _IPC39_U3TXIP_MASK                       0x1C000000
#define _IPC39_U3TXIP_LENGTH                     0x00000003

#define _IPC39_w_POSITION                        0x00000000
#define _IPC39_w_MASK                            0xFFFFFFFF
#define _IPC39_w_LENGTH                          0x00000020

#define _IPC40_I2C3BIS_POSITION                  0x00000000
#define _IPC40_I2C3BIS_MASK                      0x00000003
#define _IPC40_I2C3BIS_LENGTH                    0x00000002

#define _IPC40_I2C3BIP_POSITION                  0x00000002
#define _IPC40_I2C3BIP_MASK                      0x0000001C
#define _IPC40_I2C3BIP_LENGTH                    0x00000003

#define _IPC40_I2C3SIS_POSITION                  0x00000008
#define _IPC40_I2C3SIS_MASK                      0x00000300
#define _IPC40_I2C3SIS_LENGTH                    0x00000002

#define _IPC40_I2C3SIP_POSITION                  0x0000000A
#define _IPC40_I2C3SIP_MASK                      0x00001C00
#define _IPC40_I2C3SIP_LENGTH                    0x00000003

#define _IPC40_I2C3MIS_POSITION                  0x00000010
#define _IPC40_I2C3MIS_MASK                      0x00030000
#define _IPC40_I2C3MIS_LENGTH                    0x00000002

#define _IPC40_I2C3MIP_POSITION                  0x00000012
#define _IPC40_I2C3MIP_MASK                      0x001C0000
#define _IPC40_I2C3MIP_LENGTH                    0x00000003

#define _IPC40_SPI4