/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef __MCU_DA1469X_LPCLK_H_
#define __MCU_DA1469X_LPCLK_H_

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void (da1469x_lpclk_cb)(uint32_t freq);

void da1469x_lpclk_register_cmac_cb(da1469x_lpclk_cb *cb);
/* Stable lp clock enabled (e.g. switched to XTAL after settling) */
void da1469x_lpclk_enabled(void);
/* Frequency of lp clock changed (e.g. after RCX recalibration) */
void da1469x_lpclk_updated(void);

#ifdef __cplusplus
}
#endif

#endif /* __MCU_DA1469X_LPCLK_H_ */
