"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const sinon = __importStar(require("sinon"));
const AjaxImpl_1 = require("../../impl/AjaxImpl");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
var protocolPage = StandardInits_1.StandardInits.protocolPage;
const mona_dish_1 = require("mona-dish");
const chai_1 = require("chai");
var HTML_PREFIX_EMBEDDED_BODY = StandardInits_1.StandardInits.HTML_PREFIX_EMBEDDED_BODY;
const mocha_1 = require("mocha");
const FileUtils_1 = require("../../impl/util/FileUtils");
const ExtDomQuery_1 = require("../../impl/util/ExtDomQuery");
/**
 * merges a list of key value entries into a target config
 * @param target the target receiving the key value entries
 * @param keyValueEntries a list of key value entries divided by =
 * @param paramsMapper a key value remapper
 */
function mergeKeyValueEntries(target, keyValueEntries, paramsMapper = (key, value) => [key, value]) {
    function fixKeyWithoutVal(keyVal) {
        var _a, _b;
        return keyVal.length < 3 ? [(_a = keyVal === null || keyVal === void 0 ? void 0 : keyVal[0]) !== null && _a !== void 0 ? _a : [], (_b = keyVal === null || keyVal === void 0 ? void 0 : keyVal[1]) !== null && _b !== void 0 ? _b : []] : keyVal;
    }
    let toMerge = new ExtDomQuery_1.ExtConfig({});
    keyValueEntries
        //special case of having keys without values
        .map(keyVal => fixKeyWithoutVal(keyVal))
        .map(keyVal => paramsMapper(keyVal[0], keyVal[1]))
        .each(keyVal => {
        var _a, _b;
        let value = (_b = (_a = keyVal === null || keyVal === void 0 ? void 0 : keyVal.splice(1)) === null || _a === void 0 ? void 0 : _a.join("")) !== null && _b !== void 0 ? _b : "";
        if (toMerge.getIfPresent(keyVal[0]).isPresent()) {
            toMerge.append(keyVal[0]).value = value;
        }
        else {
            toMerge.assign(keyVal[0]).value = value;
        }
    });
    target.shallowMerge(toMerge);
}
function getFormData(requestBody) {
    let ret = new mona_dish_1.Config({});
    mergeKeyValueEntries(ret, (0, FileUtils_1.decodeEncodedValues)(requestBody));
    return ret;
}
describe("test for proper request param patterns identical to the old implementation", function () {
    const UPDATE_INSERT_2 = {
        "op": "updateinsert2",
        "jakarta.faces.partial.event": "click",
        "jakarta.faces.source": "cmd_update_insert2",
        "jakarta.faces.partial.ajax": "true",
        "jakarta.faces.partial.execute": "cmd_update_insert2",
        "form1": "form1",
        "jakarta.faces.ViewState": "blubbblubblubb"
    };
    /**
     * matches two maps for absolute identicality
     */
    let matches = (item1, item2) => {
        if (Object.keys(item1).length != Object.keys(item2).length) {
            return false;
        }
        for (let key in item1) {
            if ((!(key in item2)) || item1[key] != item2[key]) {
                return false;
            }
        }
        return true;
    };
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = protocolPage();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.jsfAjaxResponse = sinon.stub(global.faces.ajax, "response");
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    AjaxImpl_1.Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    (0, mocha_1.it)("must pass updateinsert2 with proper parameters", function () {
        mona_dish_1.DQ.byId("cmd_update_insert2").click();
        let requestBody = this.requests[0].requestBody;
        let formData = getFormData(requestBody);
        (0, chai_1.expect)(matches(formData.value, UPDATE_INSERT_2)).to.be.true;
    });
    (0, mocha_1.it)("must handle base64 encoded strings properly as request data", function () {
        let probe = "YWFhYWFhc1Rlc3RpdCDDpGtvNDU5NjczMDA9PSsrNDU5MGV3b3UkJiUmLyQmJQ==";
        mona_dish_1.DQ.byId("jakarta.faces.ViewState").inputValue.value = probe;
        mona_dish_1.DQ.byId("cmd_update_insert2").click();
        let requestBody = this.requests[0].requestBody;
        //We check if the base64 encoded string matches the original
        let formData = getFormData(requestBody);
        (0, chai_1.expect)(formData.getIf("jakarta.faces.ViewState").value == probe).to.be.true;
    });
    (0, mocha_1.it)("must handle empty parameters properly", function () {
        let probe = "";
        mona_dish_1.DQ.byId("jakarta.faces.ViewState").inputValue.value = probe;
        mona_dish_1.DQ.byId("cmd_update_insert2").click();
        let requestBody = this.requests[0].requestBody;
        //We check if the base64 encoded string matches the original
        let formData = getFormData(requestBody);
        (0, chai_1.expect)(decodeURIComponent(formData.getIf("jakarta.faces.ViewState").value) == probe).to.be.true;
    });
    //KssbpZfCe+0lwDhgMRQ44wRFkaM1o1lbMMUO3lini5YhXWm6
    (0, mocha_1.it)("must handle base64 special cases properly (+ in encoding)", function () {
        let probe = "KssbpZfCe+0lwDhgMRQ44wRFkaM1o1lbMMUO3lini5YhXWm6";
        mona_dish_1.DQ.byId("jakarta.faces.ViewState").inputValue.value = probe;
        mona_dish_1.DQ.byId("cmd_update_insert2").click();
        let requestBody = this.requests[0].requestBody;
        //We check if the base64 encoded string matches the original
        let formData = getFormData(requestBody);
        (0, chai_1.expect)(decodeURIComponent(formData.getIf("jakarta.faces.ViewState").value) == probe).to.be.true;
    });
    (0, mocha_1.it)("must handle prefixed inputs properly (prefixes must be present) faces4", function (done) {
        window.document.body.innerHTML = HTML_PREFIX_EMBEDDED_BODY;
        global["debug_inp"] = true;
        //we now run the tests here
        try {
            let event = {
                isTrusted: true,
                type: 'change',
                target: document.getElementById("page:input::field"),
                currentTarget: document.getElementById("page:input::field")
            };
            faces.ajax.request(document.getElementById("page:input"), event, {
                render: "page:output",
                execute: "page:input",
                params: {
                    "booga2.xxx": "yyy",
                    "javax.faces.behavior.event": "change",
                    "booga": "bla"
                },
            });
        }
        catch (err) {
            console.error(err);
            (0, chai_1.expect)(false).to.eq(true);
        }
        const requestBody = this.requests[0].requestBody;
        //We check if the base64 encoded string matches the original
        (0, chai_1.expect)(requestBody.indexOf("javax.faces.behavior.event")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("javax.faces.behavior.event=change")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("page%3Ainput=input_value")).to.not.eq(-1);
        done();
    });
    /**
     * This test is based on Tobago 6 (Jakarte EE 9).
     */
    (0, mocha_1.it)("must handle ':' in IDs properly", function (done) {
        window.document.body.innerHTML = `

<tobago-page locale="en" class="container-fluid" id="page" focus-on-error="true" wait-overlay-delay-full="1000" wait-overlay-delay-ajax="1000">
    <form action="/content/010-input/10-in/In.xhtml?jfwid=q6qbeuqed" id="page::form" method="post" accept-charset="UTF-8" data-tobago-context-path="">
        <input type="hidden" name="jakarta.faces.source" id="jakarta.faces.source" disabled="disabled">
        <tobago-focus id="page::lastFocusId">
            <input type="hidden" name="page::lastFocusId" id="page::lastFocusId::field">
        </tobago-focus>
        <input type="hidden" name="org.apache.myfaces.tobago.webapp.Secret" id="org.apache.myfaces.tobago.webapp.Secret" value="secretValue">
        <tobago-in id="page:input" class="tobago-auto-spacing">
            <input type="text" name="page:input" id="page:input::field" class="form-control" value="Bob">
            <tobago-behavior event="change" client-id="page:input" field-id="page:input::field" execute="page:input" render="page:output"></tobago-behavior>
        </tobago-in>
        <tobago-out id="page:output" class="tobago-auto-spacing">
            <span class="form-control-plaintext"></span>
        </tobago-out>
        <div class="tobago-page-menuStore">
        </div>
        <span id="page::faces-state-container">
            <input type="hidden" name="jakarta.faces.ViewState" id="j_id__v_0:jakarta.faces.ViewState:1" value="viewStateValue" autocomplete="off">
            <input type="hidden" name="jakarta.faces.RenderKitId" value="tobago">
            <input type="hidden" id="j_id__v_0:jakarta.faces.ClientWindow:1" name="jakarta.faces.ClientWindow" value="clientWindowValue">
        </span>
    </form>
</tobago-page>
`;
        //we now run the tests here
        try {
            let event = {
                isTrusted: true,
                type: 'change',
                target: document.getElementById("page:input::field"),
                currentTarget: document.getElementById("page:input::field")
            };
            global.debug2 = true;
            faces.ajax.request(document.getElementById("page:input"), event, {
                "jakarta.faces.behavior.event": 'change',
                execute: "page:input",
                render: "page:output"
            });
        }
        catch (err) {
            console.error(err);
            (0, chai_1.expect)(false).to.eq(true);
        }
        const requestBody = this.requests[0].requestBody;
        (0, chai_1.expect)(requestBody.indexOf("org.apache.myfaces.tobago.webapp.Secret=secretValue")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("page%3Ainput=Bob")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("jakarta.faces.ViewState=viewStateValue")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("jakarta.faces.RenderKitId=tobago")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("jakarta.faces.ClientWindow=clientWindowValue")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("jakarta.faces.behavior.event=change")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("jakarta.faces.partial.event=change")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("jakarta.faces.source=page%3Ainput")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("jakarta.faces.partial.ajax=true")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("page%3A%3Aform=page%3A%3Aform")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("jakarta.faces.partial.execute=page%3Ainput")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("jakarta.faces.partial.render=page%3Aoutput")).to.not.eq(-1);
        done();
    });
});
//# sourceMappingURL=RequestParamsTest.spec.js.map