function TrNumberFormat(a0,a1,a2)
{
if(!a0)
alert("type for TrNumberFormat not defined!");
this._type=a0;
if(!a2)
{
a2={};
}
TrNumberFormat.CURRENCY_CODE="currencyCode";
TrNumberFormat.CURRENCY_SYMBOL="currencySymbol";
TrNumberFormat.NEGATIVE_PREFIX="negativePrefix";
TrNumberFormat.NEGATIVE_SUFFIX="negativeSuffix";
TrNumberFormat.IS_GROUPING_USED="isGroupingUsed";
TrNumberFormat.MAX_FRACTION_DIGITS="maxFractionDigits";
TrNumberFormat.MAX_INTEGER_DIGITS="maxIntegerDigits";
TrNumberFormat.MIN_FRACTION_DIGITS="minFractionDigits";
TrNumberFormat.MIN_INTEGER_DIGITS="minIntegerDigits";
TrNumberFormat.ROUNDING_MODE="roundingMode";
if(this._type=="percent")
{
this.setMaximumFractionDigits((a2[TrNumberFormat.MAX_FRACTION_DIGITS]!=null)?a2[TrNumberFormat.MAX_FRACTION_DIGITS]:0);
}
else
{
this.setMaximumFractionDigits((a2[TrNumberFormat.MAX_FRACTION_DIGITS]!=null)?a2[TrNumberFormat.MAX_FRACTION_DIGITS]:3);
}
this.setMaximumIntegerDigits((a2[TrNumberFormat.MAX_INTEGER_DIGITS]!=null)?a2[TrNumberFormat.MAX_INTEGER_DIGITS]:40);
if(this._type=="currency")
{
this.setMinimumFractionDigits((a2[TrNumberFormat.MIN_FRACTION_DIGITS]!=null)?a2[TrNumberFormat.MIN_FRACTION_DIGITS]:2);
}
else
{
this.setMinimumFractionDigits((a2[TrNumberFormat.MIN_FRACTION_DIGITS]!=null)?a2[TrNumberFormat.MIN_FRACTION_DIGITS]:0);
}
this.setMinimumIntegerDigits((a2[TrNumberFormat.MIN_INTEGER_DIGITS]!=null)?a2[TrNumberFormat.MIN_INTEGER_DIGITS]:1);
this.setGroupingUsed((a2[TrNumberFormat.IS_GROUPING_USED]!=null)?a2[TrNumberFormat.IS_GROUPING_USED]:true);
this.setRoundingMode(a2[TrNumberFormat.ROUNDING_MODE]);
this._updateLocaleAndSymbols(a1,a2);
}
TrNumberFormat.getNumberInstance=function(a3,a4)
{
return new TrNumberFormat("number",a3,a4);
}
TrNumberFormat.getCurrencyInstance=function(a5,a6)
{
return new TrNumberFormat("currency",a5,a6);
}
TrNumberFormat.getPercentInstance=function(a7,a8)
{
return new TrNumberFormat("percent",a7,a8);
}
TrNumberFormat.prototype.setGroupingUsed=function(a9)
{
this._groupingUsed=a9;
}
TrNumberFormat.prototype.isGroupingUsed=function()
{
return this._groupingUsed;
}
TrNumberFormat.prototype.setRoundingMode=function(a10)
{
this._roundingMode=a10;
}
TrNumberFormat.prototype.getRoundingMode=function()
{
return this._roundingMode;
}
TrNumberFormat.prototype.isRoundingModeSpecified=function()
{
return this.getRoundingMode()!=null;
}
TrNumberFormat.prototype.setMaximumIntegerDigits=function(a11)
{
if(a11!=null)
{
this._maxIntegerDigits=a11<0?0:a11;
if(this._minIntegerDigits>this._maxIntegerDigits)
{
this._minIntegerDigits=this._maxIntegerDigits;
}
}
}
TrNumberFormat.prototype.getMaximumIntegerDigits=function()
{
return this._maxIntegerDigits;
}
TrNumberFormat.prototype.setMaximumFractionDigits=function(a12)
{
if(a12!=null)
{
this._maxFractionDigits=a12<0?0:a12;
if(this._maxFractionDigits<this._minFractionDigits)
{
this._minFractionDigits=this._maxFractionDigits;
}
this._isMaxFractionDigitsSet=true;
}
}
TrNumberFormat.prototype.getMaximumFractionDigits=function()
{
return this._maxFractionDigits;
}
TrNumberFormat.prototype.setMinimumIntegerDigits=function(a13)
{
if(a13!=null)
{
this._minIntegerDigits=a13<0?0:a13;
if(this._minIntegerDigits>this._maxIntegerDigits)
{
this._maxIntegerDigits=this._minIntegerDigits;
}
}
}
TrNumberFormat.prototype.getMinimumIntegerDigits=function()
{
return this._minIntegerDigits;
}
TrNumberFormat.prototype.setMinimumFractionDigits=function(a14)
{
if(a14!=null)
{
this._minFractionDigits=a14<0?0:a14;
if(this._maxFractionDigits<this._minFractionDigits)
{
this._maxFractionDigits=this._minFractionDigits;
}
}
}
TrNumberFormat.prototype.getMinimumFractionDigits=function()
{
return this._minFractionDigits;
}
TrNumberFormat.prototype.format=function(a15)
{
if(this._type=="percent")
return this.percentageToString(a15);
else if(this._type=="currency")
return this.currencyToString(a15);
else if(this._type=="number")
return this.numberToString(a15);
}
TrNumberFormat.prototype.parse=function(a16)
{
if(this._type=="percent")
return this.stringToPercentage(a16);
else if(this._type=="currency")
return this.stringToCurrency(a16);
return this.stringToNumber(a16);
}
TrNumberFormat.prototype.stringToNumber=function(a17)
{
var a18=this.hasPrefixOrSuffix(a17);
var a19=1;
if(a18)
{
var a20=this.removePrefixAndSuffix(a17);
a17=a20[0]
var a21=a20[1];
if(!a21)
a19=-1;
}
if(isNaN(a17)||a17.indexOf('e')!=-1||a17.indexOf('E')!=-1)
{
throw new TrParseException("not able to parse number");
}
return parseFloat(a17)*a19;
}
TrNumberFormat.prototype.hasPrefixOrSuffix=function(a22)
{
var a23=a22.indexOf(this._nPrefix);
var a24=this._nSuffix;
if(a24&&(a24.charAt(0)==' '||a24.charAt(0)=='\xa0'))
{
a24=a24.substring(1);
}
var a25=a22.indexOf((a24=="")?null:a24);
if(a23==0||a25!=-1)
{
return true;
}
else
{
var a26=a22.indexOf(this._pPrefix);
var a27=this._pSuffix;
if(a27&&(a27.charAt(0)==' '||a27.charAt(0)=='\xa0'))
{
a27=a27.substring(1);
}
var a28=a22.indexOf((a27=="")?null:a27);
if(a26==0||a28!=-1)
{
return true;
}
}
return false;
}
TrNumberFormat.prototype.stringToCurrency=function(a29)
{
return this.stringToNumber(a29);
}
TrNumberFormat.prototype.removePrefixAndSuffix=function(a30)
{
var a31=[];
var a32=a30.indexOf(this._nPrefix);
var a33=this._nSuffix;
if(a33&&(a33.charAt(0)==' '||a33.charAt(0)=='\xa0'))
{
a33=a33.substring(1);
}
var a34=a30.indexOf(a33);
if(a32!=-1&&a34!=-1)
{
a31.push(a30.substr(this._nPrefix.length,a30.length-(this._nPrefix.length+a33.length)));
a31.push(false);
return a31;
}
else
{
var a35=a30.indexOf(this._pPrefix);
var a36=this._pSuffix;
if(a36&&(a36.charAt(0)==' '||a36.charAt(0)=='\xa0'))
{
a36=a36.substring(1);
}
var a37=a30.indexOf(a36);
if(a35!=-1&&a37!=-1)
{
a31.push(a30.substr(this._pPrefix.length,a30.length-(this._pPrefix.length+a36.length)));
a31.push(true);
return a31;
}
else
{
throw new TrParseException("not able to parse number");
}
}
}
TrNumberFormat.prototype.stringToPercentage=function(a38)
{
var a39=this._localeSymbols.getPercentSuffix().trim();
var a40=(a38.indexOf(a39)!=-1);
if(!a40)
{
throw new TrParseException("not able to parse number");
}
var a41=a38.replace(new RegExp(a39,'g'),'');
return this.stringToNumber(a41);
}
TrNumberFormat.prototype.numberToString=function(a42,a43)
{
var a44=a42<0;
if(a44)
a42=(a42*-1);
var a45=a42+"";
a45=TrNumberFormat.scientificToExpanded(a45);
var a46=a45.indexOf(".");
var a47=a45.length;
var a48;
var a49;
if(a46!=-1)
{
a48=a45.substring(0,a46);
a49=a45.substring(a46+1,a47);
}
else
{
a48=a45;
a49="";
}
a48=this._formatIntegers(a48);
a49=this._formatFractions(a49)
var a50=this._localeSymbols.getDecimalSeparator();
if(a49!="")
a45=(a48+a50+a49);
else
a45=(a48);
if(a43)
a45=a45+a43;
if(a44)
{
if(this._nPrefix||this._nSuffix)
{
a45=this.addPrefixAndSuffix(a45,false);
}
else
{
a45="-"+a45;
}
}
else
{
if(this._pPrefix||this._pSuffix)
{
a45=this.addPrefixAndSuffix(a45,true);
}
}
return a45;
}
TrNumberFormat.prototype.addPrefixAndSuffix=function(a51,a52)
{
if(a52)
{
return((this._pPrefix)?this._pPrefix:'')+a51+((this._pSuffix)?this._pSuffix:'');
}
else
{
return((this._nPrefix)?this._nPrefix:'')+a51+((this._nSuffix)?this._nSuffix:'');
}
}
TrNumberFormat.prototype.currencyToString=function(a53)
{
return this.numberToString(a53);
}
TrNumberFormat.prototype.percentageToString=function(a54)
{
a54=a54*100;
if(this._isMaxFractionDigitsSet==null&&
!this.isRoundingModeSpecified())
a54=this.getRounded(a54);
if(isNaN(a54))
{
throw new TrParseException("not able to parse number");
}
var a55=this._localeSymbols.getPercentSuffix();
if(!a55||a55=="")
{
throw new TrParseException("percent suffix undefined or empty");
}
return this.numberToString(a54,a55);
}
TrNumberFormat.scientificToExpanded=function(a56)
{
var a57=a56.indexOf('e');
if(a57==-1)
return a56;
var a58="";
if(a56.charAt(0)=='-')
{
a58="-";
a56=a56.substring(1);
a57-=1;
}
var a59=a56.charAt(a57+1)=='+';
var a60=parseInt(a56.substring(a57+2));
var a61=a57-2;
var a62="";
if(a59)
{
for(var a63=0;a63<a60-a61;++a63)
a62+="0";
return a58+a56.charAt(0)+a56.substring(2,a57)+a62;
}
for(var a63=0;a63<a60-1;++a63)
a62+="0";
return a58+"0."+a62+a56.charAt(0)+a56.substring(2,a57);
}
TrNumberFormat.trimLeadingZeroes=function(a64)
{
var a65=[];
var a66,ch;
for(a66=0;a66<a64.length;++a66)
{
ch=a64.charAt(a66);
if((ch>='1'&&ch<='9')||ch=='.')
break;
if(ch=='0'&&a66+1<a64.length&&a64.charAt(a66+1)!='.')
continue;
a65.push(ch);
}
return a65.join('')+a64.substring(a66);
}
TrNumberFormat.prototype.getRounded=function(a67)
{
a67=this.moveDecimalRight(a67);
a67=Math.round(a67);
a67=this.moveDecimalLeft(a67);
return a67;
}
TrNumberFormat.prototype.moveDecimalRight=function(a68)
{
var a69='';
a69=this.moveDecimal(a68,false);
return a69;
}
TrNumberFormat.prototype.moveDecimalLeft=function(a70)
{
var a71='';
a71=this.moveDecimal(a70,true);
return a71;
}
TrNumberFormat.prototype.moveDecimal=function(a72,a73)
{
var a74='';
a74=this.moveDecimalAsString(a72,a73);
return parseFloat(a74);
}
TrNumberFormat.prototype.moveDecimalAsString=function(a75,a76)
{
var a77=2;
if(a77<=0)
return a75;
var a78=a75+'';
var a79=this.getZeros(a77);
var a80=new RegExp('([0-9.]+)');
if(a76)
{
a78=a78.replace(a80,a79+'$1');
var a81=new RegExp('(-?)([0-9]*)([0-9]{'+a77+'})(\\.?)');
a78=a78.replace(a81,'$1$2.$3');
}
else
{
var a82=a80.exec(a78);
if(a82!=null)
{
a78=a78.substring(0,a82.index)+a82[1]+a79+a78.substring(a82.index+a82[0].length);
}
var a81=new RegExp('(-?)([0-9]*)(\\.?)([0-9]{'+a77+'})');
a78=a78.replace(a81,'$1$2$4.');
}
a78=a78.replace(/\.$/,'');
return a78;
}
TrNumberFormat.prototype.getZeros=function(a83)
{
var a84='';
var a85;
for(a85=0;a85<a83;a85++){
a84+='0';
}
return a84;
}
TrNumberFormat.prototype._updateLocaleAndSymbols=function(a86,a87)
{
var a88=(a87)?a87[TrNumberFormat.CURRENCY_CODE]:null;
var a89=(a87)?a87[TrNumberFormat.CURRENCY_SYMBOL]:null;
var a90=(a87)?a87[TrNumberFormat.NEGATIVE_PREFIX]:null;
var a91=(a87)?a87[TrNumberFormat.NEGATIVE_SUFFIX]:null;
this._localeSymbols=getLocaleSymbols(a86);
if(this._type=="percent"||this._type=="number")
{
this._nPrefix=(a90)?a90:null;
this._nSuffix=(a91)?a91:null;
this._pPrefix=null;
this._pSuffix=null;
}
else
{
this._pPrefix=this._localeSymbols.getPositivePrefix();
this._pSuffix=this._localeSymbols.getPositiveSuffix();
nCurrencyPrefix=this._localeSymbols.getNegativePrefix();
nCurrencySuffix=this._localeSymbols.getNegativeSuffix();
var a92=this._localeSymbols.getCurrencySymbol();
this._nPrefix=this._replaceFormattingPrefixAndSuffix(nCurrencyPrefix,a92,a90,true);
this._nSuffix=this._replaceFormattingPrefixAndSuffix(nCurrencySuffix,a92,a91,false);
if(a88)
{
var a93=this._localeSymbols.getCurrencyCode();
if(a93!=a88)
{
this._replaceCurrencyPrefixAndSuffix(a92,a88);
}
}
else if(a89)
{
this._replaceCurrencyPrefixAndSuffix(a92,a89);
}
}
}
TrNumberFormat.prototype._replaceCurrencyPrefixAndSuffix=function(a94,a95)
{
this._pPrefix=this._pPrefix.replace(a94,a95);
this._pSuffix=this._pSuffix.replace(a94,a95);
this._nPrefix=this._nPrefix.replace(a94,a95);
this._nSuffix=this._nSuffix.replace(a94,a95);
}
TrNumberFormat.prototype._replaceFormattingPrefixAndSuffix=function(
a96,
a97,
a98,
a99)
{
var a100=a96;
if(a98)
{
var a101=a96.trim().indexOf(a97);
if(a101==-1)
{
a100=a98;
}
else
{
if(a96.trim()==a97)
{
a100=(a99)?a98+a97:a97+a98;
}
else if(a101==0)
{
a100=a97+a98;
}
else
{
a100=a98+a97;
}
}
}
return a100;
}
TrNumberFormat.prototype._formatIntegers=function(a102)
{
var a103=a102.length;
var a104=this.getMaximumIntegerDigits();
var a105=this.getMinimumIntegerDigits();
var a106;
if(a103>a104)
{
a106=a103-a104;
a102=a102.substring(a106,a103);
}
else if(a103<a105)
{
a106=a105-a103;
var a107="";
while(a106>0)
{
a107="0"+a107;
--a106;
}
a102=a107+a102;
}
if(this.isGroupingUsed())
{
a102=this._addGroupingSeparators(a102);
}
return a102;
}
TrNumberFormat.prototype._formatFractions=function(a108)
{
var a109=a108.length;
var a110=this.getMaximumFractionDigits();
var a111=this.getMinimumFractionDigits();
if(a109>a110&&a110>=a111)
{
var a112=(this.isRoundingModeSpecified())?a109:a110;
a108=a108.substring(0,a112);
}
if(a109<a111)
{
var a113=a111-a109;
while(a113>0)
{
a108=a108+"0";
--a113;
}
}
return a108;
}
TrNumberFormat.prototype._addGroupingSeparators=function(a114)
{
var a115=a114.length;
var a116=a115%3;
var a117;
var a118;
var a119="";
var a120=this._localeSymbols.getGroupingSeparator();
if(a116>0)
{
a117=(a115<4)?a114.substring(0,a116):a114.substring(0,a116)+a120;
a118=a114.substring(a116,a115);
}
else
{
a117="";
a118=a114;
}
for(i=0;i<a118.length;i++)
{
if(i%3==0&&i!=0)
{
a119+=a120;
}
a119+=a118.charAt(i);
}
a114=a117+a119;
return a114;
}
function TrParseException(
a0
)
{
this._message=a0;
}
TrParseException.prototype.getMessage=function()
{
return this._message;
}
