/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.myfaces.trinidadinternal.style.xml.parse.EmbeddedIncludePropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludePropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludeStyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;

public class StyleNode {
    private final String _name;
    private final String _selector;
    private final String _clientRule;
    private final List<PropertyNode> _properties;
    private final List<PropertyNode> _skinProperties;
    private final List<IncludeStyleNode> _includedStyles;
    private final List<IncludePropertyNode> _includedProperties;
    private final List<EmbeddedIncludePropertyNode> _embeddedIncludeProperties;
    private final List<String> _inhibitedProperties;
    private final boolean _resetProperties;
    private final boolean _inhibitAll;
    private static final String _INHIBIT_ALL_VALUE = "all";

    public StyleNode(String name, String selector, String clientRule, PropertyNode[] properties, PropertyNode[] skinProperties, IncludeStyleNode[] includedStyles, IncludePropertyNode[] includedProperties, EmbeddedIncludePropertyNode[] embeddedIncludeProperties, Set<String> inhibitedProperties) {
        this(name, selector, clientRule, properties, skinProperties, includedStyles, includedProperties, embeddedIncludeProperties, inhibitedProperties, false);
    }

    public StyleNode(String name, String selector, String clientRule, PropertyNode[] properties, PropertyNode[] skinProperties, IncludeStyleNode[] includedStyles, IncludePropertyNode[] includedProperties, EmbeddedIncludePropertyNode[] embeddedIncludeProperties, Set<String> inhibitedProperties, boolean resetProperties) {
        this._name = name;
        this._selector = selector;
        this._clientRule = clientRule;
        this._resetProperties = resetProperties;
        this._properties = properties == null || properties.length == 0 ? Collections.emptyList() : (properties.length == 1 ? Collections.singletonList(properties[0]) : Collections.unmodifiableList(Arrays.asList(properties)));
        this._includedStyles = includedStyles == null || includedStyles.length == 0 ? Collections.emptyList() : (includedStyles.length == 1 ? Collections.singletonList(includedStyles[0]) : Collections.unmodifiableList(Arrays.asList(includedStyles)));
        this._includedProperties = includedProperties == null || includedProperties.length == 0 ? Collections.emptyList() : (includedProperties.length == 1 ? Collections.singletonList(includedProperties[0]) : Collections.unmodifiableList(Arrays.asList(includedProperties)));
        this._embeddedIncludeProperties = embeddedIncludeProperties == null || embeddedIncludeProperties.length == 0 ? Collections.emptyList() : (embeddedIncludeProperties.length == 1 ? Collections.singletonList(embeddedIncludeProperties[0]) : Collections.unmodifiableList(Arrays.asList(embeddedIncludeProperties)));
        this._skinProperties = skinProperties == null || skinProperties.length == 0 ? Collections.emptyList() : (skinProperties.length == 1 ? Collections.singletonList(skinProperties[0]) : Collections.unmodifiableList(Arrays.asList(skinProperties)));
        boolean inhibitAll = false;
        if (inhibitedProperties != null && !inhibitedProperties.isEmpty()) {
            ArrayList<String> inhibitedPropertiesList = new ArrayList<String>(inhibitedProperties.size());
            for (String property : inhibitedProperties) {
                if (_INHIBIT_ALL_VALUE.equalsIgnoreCase(property)) {
                    inhibitAll = true;
                    continue;
                }
                inhibitedPropertiesList.add(property);
            }
            this._inhibitedProperties = inhibitedPropertiesList.size() == 1 ? Collections.singletonList(inhibitedPropertiesList.get(0)) : Collections.unmodifiableList(inhibitedPropertiesList);
        } else {
            this._inhibitedProperties = Collections.emptyList();
        }
        this._inhibitAll = inhibitAll;
    }

    public String getName() {
        return this._name;
    }

    public String getSelector() {
        return this._selector;
    }

    public String getClientRule() {
        return this._clientRule;
    }

    public boolean hasClientRule() {
        return this._clientRule != null && !this._clientRule.isEmpty();
    }

    public boolean isEmpty() {
        if (!this._properties.isEmpty()) {
            return false;
        }
        if (!this._includedStyles.isEmpty()) {
            return false;
        }
        return this._includedProperties.isEmpty();
    }

    public Collection<PropertyNode> getProperties() {
        return this._properties;
    }

    public Collection<PropertyNode> getSkinProperties() {
        return this._skinProperties;
    }

    public Collection<EmbeddedIncludePropertyNode> getEmbeddedIncludeProperties() {
        return this._embeddedIncludeProperties;
    }

    public Collection<IncludeStyleNode> getIncludedStyles() {
        return this._includedStyles;
    }

    public Collection<IncludePropertyNode> getIncludedProperties() {
        return this._includedProperties;
    }

    public Collection<String> getInhibitedProperties() {
        return this._inhibitedProperties;
    }

    public boolean isInhibitingAll() {
        return this._inhibitAll;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StyleNode)) {
            return false;
        }
        StyleNode test = (StyleNode)obj;
        return (this._name == test._name || this._name != null && this._name.equals(test._name)) && (this._selector == test._selector || this._selector != null && this._selector.equals(test._selector)) && (this._clientRule == test._clientRule || this._clientRule != null && this._clientRule.equals(test._clientRule)) && this._resetProperties == test._resetProperties && this._inhibitAll == test._inhibitAll && this._inhibitedProperties.equals(test._inhibitedProperties) && this._includedStyles.equals(test._includedStyles) && this._includedProperties.equals(test._includedProperties) && this._embeddedIncludeProperties.equals(test._embeddedIncludeProperties) && this._properties.equals(test._properties) && this._skinProperties.equals(test._skinProperties);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + (null == this._name ? 0 : this._name.hashCode());
        hash = 37 * hash + (null == this._selector ? 0 : this._selector.hashCode());
        hash = 37 * hash + (null == this._clientRule ? 0 : this._clientRule.hashCode());
        hash = 37 * hash + (this._resetProperties ? 0 : 1);
        hash = 37 * hash + (this._inhibitAll ? 0 : 1);
        hash = 37 * hash + this._inhibitedProperties.hashCode();
        hash = 37 * hash + this._includedStyles.hashCode();
        hash = 37 * hash + this._includedProperties.hashCode();
        hash = 37 * hash + this._embeddedIncludeProperties.hashCode();
        hash = 37 * hash + this._properties.hashCode();
        hash = 37 * hash + this._skinProperties.hashCode();
        return hash;
    }

    public String toString() {
        return this.getClass().getName() + "[" + "name=" + this._name + ", " + "selector=" + this._selector + ", " + "clientRule=" + this._clientRule + ", " + "properties=" + this._properties.toString() + ", " + "skinProperties=" + this._skinProperties.toString() + ", " + "includeStyles=" + this._includedStyles.toString() + ", " + "includeProperties=" + this._includedProperties.toString() + ", " + "embeddedIncludeProperties=" + this._embeddedIncludeProperties.toString() + ", " + "inhibitedProperties=" + this._inhibitedProperties.toString() + ", " + "resetProperties=" + this._resetProperties + ", " + "inhibitAll=" + this._inhibitAll + "]";
    }

    boolean __getResetProperties() {
        return this._resetProperties;
    }

    String getId() {
        StringBuilder id = new StringBuilder();
        if (this.hasClientRule()) {
            id.append(this._clientRule);
        }
        if (this._selector != null && !this._selector.isEmpty()) {
            id.append(this._selector);
        } else if (this._name != null && !this._name.isEmpty()) {
            id.append(this._name);
        }
        return id.toString();
    }
}

