/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.util.URLUtils;

public class URLInputStreamProvider
implements InputStreamProvider {
    private final URL _url;
    private Object _cached;
    private long _lastModifiedTime = -1L;

    public URLInputStreamProvider(URL url) {
        if (url == null) {
            throw new NullPointerException();
        }
        this._url = url;
    }

    public InputStream openInputStream() throws IOException {
        this._lastModifiedTime = URLUtils.getLastModified((URL)this._url);
        URLConnection connection = this._url.openConnection();
        connection.setUseCaches(false);
        InputStream base = connection.getInputStream();
        if (base instanceof BufferedInputStream) {
            return base;
        }
        return new BufferedInputStream(base);
    }

    public String getDisplayName() {
        return this._url.toExternalForm();
    }

    public Object getIdentifier() {
        return this._url;
    }

    public boolean hasSourceChanged() {
        try {
            long currentModifiedTime = URLUtils.getLastModified((URL)this._url);
            return currentModifiedTime != this._lastModifiedTime;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public Object getCachedResult() {
        return this._cached;
    }

    public void setCachedResult(Object value) {
        this._cached = value;
    }
}

