/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormInputRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.util.MessageUtils;

public abstract class InputLabelAndMessageRenderer
extends LabelAndMessageRenderer {
    private PropertyKey _simpleKey;
    private PropertyKey _disabledKey;
    private PropertyKey _readOnlyKey;

    protected InputLabelAndMessageRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._simpleKey = type.findKey("simple");
        this._disabledKey = type.findKey("disabled");
        this._readOnlyKey = type.findKey("readOnly");
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        this.getFormInputRenderer().decode(facesContext, component);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        return this.getFormInputRenderer().getConvertedValue(context, component, submittedValue);
    }

    @Override
    protected String getLabelFor(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        if (!this.getFormInputRenderer().renderAsElement(context, rc, component, bean)) {
            return null;
        }
        return InputLabelAndMessageRenderer.__getCachedClientId(rc);
    }

    @Override
    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (this.getSimple(component, bean)) {
            FacesMessage msg;
            String clientId = component.getClientId(context);
            if (this.isLeafRenderer() && this.canSkipRendering(rc, clientId)) {
                return;
            }
            String saved = rc.getCurrentClientId();
            rc.setCurrentClientId(clientId);
            String value = this.getLabel(component, bean);
            FormData fd = rc.getFormData();
            if (fd != null) {
                fd.addLabel(clientId, value);
            }
            if ((msg = MessageUtils.getFacesMessage(context, clientId)) != null) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("a", null);
                String anchor = MessageUtils.getAnchor(clientId);
                writer.writeAttribute("name", (Object)anchor, null);
                writer.endElement("a");
            }
            this.delegateRenderer(context, rc, component, bean, this.getFormInputRenderer());
            rc.setCurrentClientId(saved);
        } else {
            super.encodeAll(context, rc, component, bean);
        }
    }

    @Override
    protected boolean isContentEditable(UIComponent component, FacesBean bean) {
        return !this.getFormInputRenderer().getReadOnly(FacesContext.getCurrentInstance(), component, bean);
    }

    @Override
    protected void renderFieldCellContents(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        this.delegateRenderer(context, rc, component, bean, this.getFormInputRenderer());
    }

    protected boolean getSimple(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._simpleKey);
        if (o == null) {
            o = this._simpleKey.getDefault();
        }
        return !Boolean.FALSE.equals(o);
    }

    @Override
    protected void renderRootDomElementStyles(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        List<String> parsedStyleClasses;
        String styleClass = this.getStyleClass(component, bean);
        String contentStyleClass = this.getRootStyleClass(component, bean);
        String disabledStyleClass = null;
        String readOnlyStyleClass = null;
        String requiredStyleClass = null;
        if (this.isReadOnly(component, bean)) {
            readOnlyStyleClass = "p_AFReadOnly";
        } else if (this.isDisabled(component, bean)) {
            disabledStyleClass = "p_AFDisabled";
        }
        if (this.labelShowRequired(component, bean)) {
            requiredStyleClass = "p_AFRequired";
        }
        int userStyleClassCount = (parsedStyleClasses = OutputUtils.parseStyleClassList(styleClass)) == null ? (styleClass == null ? 0 : 1) : parsedStyleClasses.size();
        String[] styleClasses = new String[userStyleClassCount + 4];
        if (parsedStyleClasses != null) {
            for (int i = 0; i < userStyleClassCount; ++i) {
                styleClasses[i] = parsedStyleClasses.get(i);
            }
        } else if (styleClass != null) {
            styleClasses[i++] = styleClass;
        }
        styleClasses[i++] = contentStyleClass;
        styleClasses[i++] = disabledStyleClass;
        styleClasses[i++] = readOnlyStyleClass;
        styleClasses[i++] = requiredStyleClass;
        InputLabelAndMessageRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])styleClasses);
        this.renderInlineStyle(context, rc, component, bean);
    }

    protected boolean isDisabled(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._disabledKey);
        if (o == null) {
            o = this._disabledKey.getDefault();
        }
        return !Boolean.FALSE.equals(o);
    }

    protected boolean isReadOnly(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._readOnlyKey);
        if (o == null) {
            o = this._readOnlyKey.getDefault();
        }
        return !Boolean.FALSE.equals(o);
    }

    protected abstract FormInputRenderer getFormInputRenderer();
}

