/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlFrameBorderLayout;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class FrameBorderLayoutRenderer
extends XhtmlRenderer {
    private PropertyKey _onloadKey;
    private PropertyKey _onunloadKey;
    private PropertyKey _frameSpacingKey;
    private PropertyKey _borderWidthKey;
    private PropertyKey _frameBorderWidthKey;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FrameBorderLayoutRenderer.class);

    public FrameBorderLayoutRenderer() {
        this(HtmlFrameBorderLayout.TYPE);
    }

    protected FrameBorderLayoutRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._onloadKey = type.findKey("onload");
        this._onunloadKey = type.findKey("onunload");
        this._frameSpacingKey = type.findKey("frameSpacing");
        this._borderWidthKey = type.findKey("borderWidth");
        this._frameBorderWidthKey = type.findKey("frameBorderWidth");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.renderShortDescAttribute(context, rc, component, bean);
        this.renderStyleAttributes(context, rc, component, bean);
        writer.writeAttribute("rows", (Object)"100%,*", null);
        if (FrameBorderLayoutRenderer.supportsScripting(rc)) {
            writer.writeAttribute("onload", bean.getProperty(this._onloadKey), null);
            writer.writeAttribute("onunload", bean.getProperty(this._onunloadKey), null);
        }
    }

    protected final void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        UIComponent alternateContent;
        boolean renderLeftRightFrame;
        String sizes;
        boolean renderTopBottomFrame;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("frameset", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        String leftName = "left";
        String innerLeftName = "innerLeft";
        String rightName = "right";
        String innerRightName = "innerRight";
        UIComponent center = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)"center");
        UIComponent top = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)"top");
        UIComponent bottom = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)"bottom");
        UIComponent left = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)leftName);
        UIComponent right = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)rightName);
        UIComponent innerLeft = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)innerLeftName);
        UIComponent innerRight = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)innerRightName);
        boolean r2l = rc.getLocaleContext().isRightToLeft();
        if (left == null) {
            leftName = r2l ? "end" : "start";
            left = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)leftName);
        }
        if (right == null) {
            rightName = r2l ? "start" : "end";
            right = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)rightName);
        }
        if (innerLeft == null) {
            innerLeftName = r2l ? "innerEnd" : "innerStart";
            innerLeft = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)innerLeftName);
        }
        if (innerRight == null) {
            innerRightName = r2l ? "innerStart" : "innerEnd";
            innerRight = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)innerRightName);
        }
        boolean bl = renderTopBottomFrame = (sizes = this._getSizeString(top, null, null, bottom, "height")).length() > 1;
        if (renderTopBottomFrame) {
            writer.startElement("frameset", null);
            if (!FrameBorderLayoutRenderer.isInaccessibleMode((RenderingContext)rc)) {
                writer.writeAttribute("title", (Object)rc.getTranslatedString("af_frameBorderLayout.HORIZONTAL_FRAMESET_LAYOUT_CONTAINER_TITLE"), null);
            }
            writer.writeAttribute("rows", (Object)sizes, null);
            this._renderFrameBorderAndSpacing(writer, component, bean);
        }
        this._encodeFacet(context, top);
        sizes = this._getSizeString(left, innerLeft, innerRight, right, "width");
        boolean bl2 = renderLeftRightFrame = sizes.length() > 1;
        if (renderLeftRightFrame) {
            writer.startElement("frameset", null);
            if (!FrameBorderLayoutRenderer.isInaccessibleMode((RenderingContext)rc)) {
                writer.writeAttribute("title", (Object)rc.getTranslatedString("af_frameBorderLayout.VERTICAL_FRAMESET_LAYOUT_CONTAINER_TITLE"), null);
            }
            writer.writeAttribute("cols", (Object)sizes, null);
            this._renderFrameBorderAndSpacing(writer, component, bean);
        }
        this._encodeFacet(context, left);
        this._encodeFacet(context, innerLeft);
        this._encodeFacet(context, center);
        this._encodeFacet(context, innerRight);
        this._encodeFacet(context, right);
        if (renderLeftRightFrame) {
            writer.endElement("frameset");
        }
        this._encodeFacet(context, bottom);
        if (renderTopBottomFrame) {
            writer.endElement("frameset");
        }
        if ((alternateContent = FrameBorderLayoutRenderer.getFacet((UIComponent)component, (String)"alternateContent")) != null) {
            writer.startElement("noframes", null);
            this.encodeChild(context, alternateContent);
            writer.endElement("noframes");
        }
        writer.endElement("frameset");
    }

    private String _getSizeString(UIComponent outer1, UIComponent inner1, UIComponent inner2, UIComponent outer2, String attr) {
        StringBuffer buf = new StringBuffer(17);
        if (outer1 != null) {
            this._getPropertyValue(outer1, attr, buf).append(',');
        }
        if (inner1 != null) {
            this._getPropertyValue(inner1, attr, buf).append(',');
        }
        buf.append('*');
        if (inner2 != null) {
            this._getPropertyValue(inner2, attr, buf.append(','));
        }
        if (outer2 != null) {
            this._getPropertyValue(outer2, attr, buf.append(','));
        }
        return buf.toString();
    }

    private StringBuffer _getPropertyValue(UIComponent frame, String attr, StringBuffer result) {
        Object val = frame.getAttributes().get(attr);
        if (val == null) {
            if (_LOG.isWarning()) {
                _LOG.warning("FRAME_MISSING_ATTRIBUTE", new Object[]{frame.getId(), attr});
            }
            val = "0";
        }
        result.append(val);
        return result;
    }

    private void _encodeFacet(FacesContext context, UIComponent component) throws IOException {
        if (component != null) {
            this.encodeChild(context, component);
        }
    }

    private void _renderFrameBorderAndSpacing(ResponseWriter writer, UIComponent component, FacesBean bean) throws IOException {
        writer.writeAttribute("framespacing", this._getFrameSpacing(component, bean), "frameSpacing");
        writer.writeAttribute("border", this._getBorderWidth(component, bean), "borderWidth");
        writer.writeAttribute("frameborder", this._getFrameBorderWidth(component, bean), "frameBorderWidth");
    }

    private Object _getFrameSpacing(UIComponent component, FacesBean bean) {
        Object value = bean.getProperty(this._frameSpacingKey);
        if (value == null) {
            value = this._frameSpacingKey.getDefault();
        }
        return value;
    }

    private Object _getBorderWidth(UIComponent component, FacesBean bean) {
        Object value = bean.getProperty(this._borderWidthKey);
        if (value == null) {
            value = this._borderWidthKey.getDefault();
        }
        return value;
    }

    private Object _getFrameBorderWidth(UIComponent component, FacesBean bean) {
        Object value = bean.getProperty(this._frameBorderWidthKey);
        if (value == null) {
            value = this._frameBorderWidthKey.getDefault();
        }
        return value;
    }
}

