/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandLink;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.GoLinkRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class CommandLinkRenderer
extends GoLinkRenderer {
    private PropertyKey _immediateKey;
    private PropertyKey _partialSubmitKey;
    private static final Object _EXTRA_SUBMIT_PARAMS_KEY = new Object();

    public CommandLinkRenderer() {
        this(CoreCommandLink.TYPE);
    }

    protected CommandLinkRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._immediateKey = type.findKey("immediate");
        this._partialSubmitKey = type.findKey("partialSubmit");
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        RequestContext requestContext = RequestContext.getCurrentInstance();
        ReturnEvent returnEvent = requestContext.getDialogService().getReturnEvent(component);
        if (returnEvent != null) {
            returnEvent.queue();
        } else {
            Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
            Object source = parameterMap.get("javax.faces.source");
            if (source == null) {
                source = parameterMap.get("source");
            }
            if (clientId == null) {
                clientId = component.getClientId(facesContext);
            }
            if (source != null && source.equals(clientId)) {
                new ActionEvent(component).queue();
                if (this.getPartialSubmit(component, facesBean)) {
                    PartialPageUtils.forcePartialRendering(facesContext);
                }
            }
        }
    }

    @Override
    protected void encodeBegin(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        if (this.getPartialSubmit(comp, bean)) {
            AutoSubmitUtils.writeDependencies(context, rc);
        } else {
            XhtmlUtils.addLib(context, rc, "submitForm()");
        }
        String clientId = this.getClientId(context, comp);
        assert (rc.getCurrentClientId() == null);
        rc.setCurrentClientId(clientId);
        String extraParams = AutoSubmitUtils.getParameters(comp);
        String old = rc.getProperties().put(_EXTRA_SUBMIT_PARAMS_KEY, extraParams);
        super.encodeBegin(context, rc, comp, bean);
        rc.getProperties().put(_EXTRA_SUBMIT_PARAMS_KEY, old);
        rc.setCurrentClientId(null);
    }

    @Override
    public void encodeEnd(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        super.encodeEnd(context, rc, comp, bean);
        FormData fd = rc.getFormData();
        if (fd != null) {
            fd.addNeededValue("source");
        }
    }

    @Override
    protected String getDestination(UIComponent component, FacesBean bean) {
        return null;
    }

    @Override
    protected String getTargetFrame(UIComponent component, FacesBean bean) {
        return null;
    }

    @Override
    protected boolean hasOnclick(UIComponent component, FacesBean bean) {
        return true;
    }

    protected String getComponentOnclick(UIComponent component, FacesBean bean) {
        return super.getOnclick(component, bean);
    }

    @Override
    protected String getOnclick(UIComponent component, FacesBean bean) {
        String onclick = this.getComponentOnclick(component, bean);
        RenderingContext arc = RenderingContext.getCurrentInstance();
        String id = arc.getCurrentClientId();
        boolean immediate = this.getImmediate(component, bean);
        String extraParams = (String)arc.getProperties().get(_EXTRA_SUBMIT_PARAMS_KEY);
        String script = this.getPartialSubmit(component, bean) ? AutoSubmitUtils.getSubmitScript(arc, id, immediate, false, null, extraParams, false) : AutoSubmitUtils.getFullPageSubmitScript(arc, id, immediate, null, extraParams, false);
        return XhtmlUtils.getChainedJS(onclick, script, true);
    }

    protected boolean getImmediate(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._immediateKey);
        if (o == null) {
            o = this._immediateKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getPartialSubmit(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._partialSubmitKey);
        if (o == null) {
            o = this._partialSubmitKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }
}

