/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.core.nav.CoreBreadCrumbs;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandLink;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class BreadCrumbsRenderer
extends XhtmlRenderer {
    private PropertyKey _orientationKey;
    private static final int _INDENT_SPACES = 10;
    private static final int NARROW_SCREEN_INDENT_SPACES = 3;
    private static final Map<String, String> _RESOURCE_KEY_MAP = new HashMap<String, String>();

    public BreadCrumbsRenderer() {
        super(CoreBreadCrumbs.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._orientationKey = type.findKey("orientation");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", component);
        this.renderAllAttributes(context, rc, component, bean);
        this.renderId(context, component);
        int renderedItemCount = this._getItemCount((UIXHierarchy)component);
        int minItemCount = this._getMinItemCount(rc);
        if (renderedItemCount > minItemCount) {
            this.renderContent(context, rc, (UIXHierarchy)component, bean);
        }
        writer.endElement("span");
    }

    protected UIComponent getStamp(FacesContext context, RenderingContext rc, UIXHierarchy component, FacesBean bean) {
        UIComponent stamp = component.getFacet("nodeStamp");
        return stamp;
    }

    protected void renderContent(FacesContext context, RenderingContext rc, UIXHierarchy component, FacesBean bean) throws IOException {
        boolean isVertical = BreadCrumbsRenderer.supportsNarrowScreen(rc) ? true : this._isVertical(bean);
        boolean shouldRenderLastChild = this.shouldRenderLastChild(rc);
        boolean isLastChild = false;
        boolean isFirstChild = true;
        int renderedCount = 0;
        int nextVisChildIndex = 1;
        UIComponent stamp = this.getStamp(context, rc, component, bean);
        Icon separatorIcon = rc.getIcon("af|breadCrumbs::separator-icon");
        if (stamp != null) {
            Object oldPath = component.getRowKey();
            Object focusPath = this._getFocusRowKey(component);
            if (focusPath == null) {
                return;
            }
            ArrayList<Object> paths = new ArrayList<Object>(component.getAllAncestorContainerRowKeys(focusPath));
            paths.add(focusPath);
            int size = paths.size();
            for (int i = 0; i < size; ++i) {
                nextVisChildIndex = i + 1 == size ? -1 : i + 1;
                isLastChild = nextVisChildIndex == -1;
                component.setRowKey(paths.get(i));
                this.renderNode(context, rc, separatorIcon, stamp, renderedCount, shouldRenderLastChild, isFirstChild, isLastChild, isVertical);
                ++renderedCount;
                isFirstChild = false;
            }
            component.setRowKey(oldPath);
        }
        if (this.hasChildren((UIComponent)component)) {
            List children = component.getChildren();
            nextVisChildIndex = BreadCrumbsRenderer.getNextRenderedChildIndex((List)children, (int)-1);
            while (nextVisChildIndex != -1) {
                UIComponent child = (UIComponent)children.get(nextVisChildIndex);
                isLastChild = (nextVisChildIndex = BreadCrumbsRenderer.getNextRenderedChildIndex((List)children, (int)nextVisChildIndex)) == -1;
                this.renderNode(context, rc, separatorIcon, child, renderedCount, shouldRenderLastChild, isFirstChild, isLastChild, isVertical);
                ++renderedCount;
                isFirstChild = false;
            }
        }
    }

    protected boolean hasChildren(UIComponent component) {
        int childCount = component.getChildCount();
        return childCount > 0;
    }

    protected void renderNode(FacesContext context, RenderingContext rc, Icon separatorIcon, UIComponent child, int renderedCount, boolean shouldRenderLastChild, boolean isFirstChild, boolean isLastChild, boolean isVertical) throws IOException {
        boolean separatorOnNewRow = this.shouldRenderSeparatorOnNewLineWhenVertical(rc);
        if (!isLastChild || shouldRenderLastChild) {
            this.renderStartOfLink(context, isVertical);
            ResponseWriter writer = context.getResponseWriter();
            if (!isFirstChild && isVertical) {
                char[] chars = new char[]{'\u00a0'};
                int indents = separatorOnNewRow ? renderedCount - 1 : renderedCount;
                int indentSpaces = indents * this.getNumberOfIndentSpaces(rc);
                for (int i = 0; i < indentSpaces; ++i) {
                    writer.writeText(chars, 0, 1);
                }
            }
            if (rc.isRightToLeft()) {
                writer.startElement("span", null);
                writer.writeAttribute("dir", (Object)"rtl", null);
            }
            if (!isFirstChild && isVertical && separatorOnNewRow) {
                OutputUtils.renderIcon(context, rc, separatorIcon, "", null);
            }
            this.renderLink(context, rc, child, renderedCount, isLastChild);
            if (!(isLastChild || isVertical && separatorOnNewRow)) {
                OutputUtils.renderIcon(context, rc, separatorIcon, "", null);
            }
            if (rc.isRightToLeft()) {
                writer.endElement("span");
            }
            this.renderEndOfLink(context, isVertical);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderLink(FacesContext context, RenderingContext rc, UIComponent child, int renderedCount, boolean isLastChild) throws IOException {
        if (isLastChild) {
            ((CoreRenderingContext)rc).setLinkDisabled(true);
        }
        boolean isBidi = false;
        String text = BreadCrumbsRenderer.toString(child.getAttributes().get(CoreCommandLink.TEXT_KEY.getName()));
        if (text != null && text.length() > 0) {
            char[] firstChar = new char[]{text.charAt(0)};
            isBidi = Bidi.requiresBidi(firstChar, 0, 1);
        }
        Map originalResourceKeyMap = rc.getSkinResourceKeyMap();
        try {
            rc.setSkinResourceKeyMap(_RESOURCE_KEY_MAP);
            if (!isBidi) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("span", null);
                writer.writeAttribute("dir", (Object)"ltr", null);
                this.encodeChild(context, child);
                writer.endElement("span");
            } else {
                this.encodeChild(context, child);
            }
            if (isLastChild) {
                ((CoreRenderingContext)rc).setLinkDisabled(false);
            }
        }
        finally {
            rc.setSkinResourceKeyMap(originalResourceKeyMap);
        }
    }

    protected boolean shouldRenderLastChild(RenderingContext rc) {
        Object propValue = rc.getSkin().getProperty((Object)"af|breadCrumbs-tr-show-last-item");
        return Boolean.TRUE.equals(propValue);
    }

    @Override
    protected void renderStyleAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        this.renderStyleAttributes(context, rc, component, bean, "af|breadCrumbs");
    }

    protected String getOrientation(FacesBean bean) {
        return BreadCrumbsRenderer.toString((Object)bean.getProperty(this._orientationKey));
    }

    protected final void renderStartOfLink(FacesContext context, boolean isVertical) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (isVertical) {
            writer.startElement("div", null);
        }
        writer.startElement("nobr", null);
    }

    protected final void renderEndOfLink(FacesContext context, boolean isVertical) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("nobr");
        if (isVertical) {
            writer.endElement("div");
        }
    }

    private Object _getFocusRowKey(UIXHierarchy component) {
        return component.getFocusRowKey();
    }

    private int _getMinItemCount(RenderingContext rc) {
        int minChildCount = 0;
        boolean shouldRenderLastChild = this.shouldRenderLastChild(rc);
        if (!shouldRenderLastChild) {
            minChildCount = 1;
        }
        return minChildCount;
    }

    private int _getItemCount(UIXHierarchy component) {
        Object focusPath = this._getFocusRowKey(component);
        int kids = BreadCrumbsRenderer.getRenderedChildCount((UIComponent)component);
        if (focusPath == null) {
            return kids;
        }
        return kids + component.getDepth(focusPath) + 1;
    }

    private boolean _isVertical(FacesBean bean) {
        String orientation = this.getOrientation(bean);
        return "vertical".equals(orientation);
    }

    protected boolean shouldRenderSeparatorOnNewLineWhenVertical(RenderingContext rc) {
        Object propValue = rc.getSkin().getProperty((Object)"af|breadCrumbs-tr-separator-on-new-line");
        return Boolean.TRUE.equals(propValue);
    }

    protected int getNumberOfIndentSpaces(RenderingContext rc) {
        if (BreadCrumbsRenderer.supportsNarrowScreen(rc)) {
            return 3;
        }
        Object propValue = rc.getSkin().getProperty((Object)"af|breadCrumbs-tr-indent-spaces");
        int intValue = 10;
        if (propValue != null && propValue instanceof Integer && (intValue = ((Integer)propValue).intValue()) < 0) {
            intValue = 10;
        }
        return intValue;
    }

    static {
        _RESOURCE_KEY_MAP.put("OraLink", "af|breadCrumbs::step");
        _RESOURCE_KEY_MAP.put("OraLinkDisabled", "af|breadCrumbs::selected-step");
    }
}

