/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.desktop;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXColumn;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.core.data.CoreColumn;
import org.apache.myfaces.trinidad.component.core.data.CoreTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.io.RepeatIdResponseWriter;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ShowDetailRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.TableRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.CellUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.ColumnData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RenderStage;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RowData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableSelectManyRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public class DesktopTableRenderer
extends TableRenderer {
    private CoreRenderer _allDisclosed;
    private CoreRenderer _allUndisclosed;
    private static final String _SHOW_ALL_DETAILS_TEXT_KEY = "af_table.SHOW_ALL_DETAILS";
    private static final String _HIDE_ALL_DETAILS_TEXT_KEY = "af_table.HIDE_ALL_DETAILS";
    protected static final String _SELECT_ALL_TEXT_KEY = "af_tableSelectMany.SELECT_ALL";
    protected static final String _SELECT_NONE_TEXT_KEY = "af_tableSelectMany.SELECT_NONE";
    private static final Object _IE_SCROLL_KEY = new Object();
    public static final String LINKS_DIVIDER_TEXT = "\u00a0|\u00a0";
    private PropertyKey _autoSubmitKey;
    private PropertyKey _summaryKey;
    private PropertyKey _heightKey;
    private PropertyKey _allDetailsEnabledKey;

    protected DesktopTableRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._summaryKey = type.findKey("summary");
        this._heightKey = type.findKey("height");
        if (this._heightKey == null) {
            this._heightKey = PropertyKey.createPropertyKey((String)"height");
        }
        this._allDetailsEnabledKey = type.findKey("allDetailsEnabled");
        this._allDisclosed = new AllDetail(type, true);
        this._allUndisclosed = new AllDetail(type, false);
        this._autoSubmitKey = type.findKey("autoSubmit");
    }

    public DesktopTableRenderer() {
        this(CoreTable.TYPE);
    }

    @Override
    protected final void renderSingleRow(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        RenderStage renderStage = tContext.getRenderStage();
        int stage = renderStage.getStage();
        if (stage == 20) {
            this.renderColumnHeader(context, rc, tContext, component);
            return;
        }
        int physicalColumn = this.renderSpecialColumns(context, rc, tContext, component, 0);
        this._renderRegularColumns(context, tContext, component, physicalColumn);
    }

    protected void renderSelectionLinks(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        if (tContext.getRowData().isEmptyTable()) {
            return;
        }
        if (this.hasControlBarLinks(context, rc, tContext, component)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.startElement("table", null);
            OutputUtils.renderLayoutTableAttributes(context, rc, "0", "100%");
            DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|table::sub-control-bar");
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
            writer.writeAttribute("valign", (Object)"middle", null);
            this.renderControlBarLinks(context, rc, tContext, component, false);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    protected boolean hasControlBarLinks(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        return tContext.hasSelectAll() || tContext.getDetail() != null && this.getAllDetailsEnabled(component, this.getFacesBean(component));
    }

    protected void renderControlBarLinks(FacesContext context, RenderingContext arc, TableRenderingContext trc, UIComponent component, boolean useDivider) throws IOException {
        FacesBean bean = this.getFacesBean(component);
        boolean hasAllDetails = trc.getDetail() != null && this.getAllDetailsEnabled(component, bean);
        boolean needsDivider = false;
        if (trc.hasSelectAll()) {
            String jsVarName = trc.getJSVarName();
            this.renderControlBarLink(context, arc, TreeUtils.callJSSelectAll(jsVarName, true), _SELECT_ALL_TEXT_KEY, null, true);
            this.renderControlBarLink(context, arc, TreeUtils.callJSSelectAll(jsVarName, false), _SELECT_NONE_TEXT_KEY, null, hasAllDetails);
            needsDivider = true;
            TableSelectManyRenderer.renderScripts(context, arc, trc, this.isAutoSubmit(component, bean));
        }
        ResponseWriter writer = context.getResponseWriter();
        if (hasAllDetails) {
            this.delegateRenderer(context, arc, component, bean, this._allUndisclosed);
            writer.writeText((Object)LINKS_DIVIDER_TEXT, null);
            this.delegateRenderer(context, arc, component, bean, this._allDisclosed);
            needsDivider = true;
        }
        if (useDivider && needsDivider) {
            writer.writeText((Object)LINKS_DIVIDER_TEXT, null);
        }
    }

    protected final void renderControlBarLink(FacesContext context, RenderingContext rc, String onclick, String translationKey, String id, boolean hasDivider) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("id", (Object)id, null);
        DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"OraNavBarActiveLink");
        writer.writeAttribute("onclick", (Object)onclick, null);
        writer.writeURIAttribute("href", (Object)"#", null);
        Icon icon = rc.getIcon(this.getControlLinkIconName(translationKey));
        if (icon != null) {
            OutputUtils.renderIcon(context, rc, icon, rc.getTranslatedString(translationKey), null);
        } else {
            writer.writeText((Object)rc.getTranslatedString(translationKey), null);
        }
        writer.endElement("a");
        if (hasDivider) {
            writer.writeText((Object)LINKS_DIVIDER_TEXT, null);
        }
    }

    @Override
    protected void renderSubControlBar(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, boolean isUpper) throws IOException {
        if (!isUpper) {
            return;
        }
        RenderStage rs = tContext.getRenderStage();
        rs.setStage(12);
        this.renderSelectionLinks(context, rc, tContext, component);
    }

    @Override
    protected void renderTableContent(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        boolean wideMode;
        if (DesktopTableRenderer.getFacet((UIComponent)component, (String)"footer") != null) {
            tContext.setExplicitHeaderIDMode(true);
        }
        ResponseWriter writer = context.getResponseWriter();
        UIComponent table = tContext.getTable();
        RenderStage renderStage = tContext.getRenderStage();
        Object assertKey = null;
        if ($assertionsDisabled || (assertKey = ((UIXCollection)table).getRowKey()) == null) {
            // empty if block
        }
        if (wideMode = "100%".equals(tContext.getTableWidth())) {
            writer.endElement("table");
        } else {
            writer.startElement("tr", null);
            writer.startElement("td", null);
        }
        String height = this.getHeight(component, this.getFacesBean(component));
        boolean useScroll = height != null;
        String tableId = tContext.getTableId();
        writer.startElement("table", null);
        DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|table::content");
        if (useScroll) {
            writer.writeAttribute("id", (Object)(tableId + "_head"), null);
            writer.writeAttribute("style", (Object)"table-layout:fixed;", null);
        }
        FacesBean bean = this.getFacesBean(table);
        String summary = this.getSummary(component, bean);
        Object cellPadding = this.getTablePadding(table);
        OutputUtils.renderDataTableAttributes(context, rc, cellPadding, "0", "0", "100%", summary);
        this._renderTableHeader(context, rc, tContext, table);
        if (tContext.hasColumnHeaders()) {
            renderStage.setStage(20);
            writer.startElement("tr", null);
            this.renderColumnHeader(context, rc, tContext, component);
            writer.endElement("tr");
        }
        assert (this._assertCurrencyKeyPreserved(assertKey, table));
        ColumnData colData = tContext.getColumnData();
        if (useScroll) {
            writer.endElement("table");
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)("overflow:auto;overflow-x:hidden;width:100%;height:" + height), null);
            writer.startElement("table", null);
            DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|table::content");
            writer.writeAttribute("id", (Object)(tableId + "_data"), null);
            OutputUtils.renderLayoutTableAttributes(context, rc, "0", "0", "100%");
            String style = "padding-bottom:1px;";
            writer.writeAttribute("style", (Object)style, null);
            for (int i = 0; i < colData.getColumnCount(); ++i) {
                writer.startElement("col", null);
                writer.writeAttribute("width", colData.getWidth(i), null);
                writer.endElement("col");
            }
        }
        renderStage.setStage(30);
        this.renderTableRows(context, rc, tContext, component, bean);
        assert (this._assertCurrencyKeyPreserved(assertKey, table));
        writer.endElement("table");
        if (useScroll) {
            boolean hasColumnFooters;
            UIComponent footer = DesktopTableRenderer.getFacet((UIComponent)component, (String)"footer");
            boolean bl = hasColumnFooters = colData.getPhysicalIndexOfFirstFooter() >= 0;
            if (footer == null && !hasColumnFooters) {
                writer.endElement("div");
            }
            writer.startElement("script", null);
            DesktopTableRenderer.renderScriptDeferAttribute(context, rc);
            DesktopTableRenderer.renderScriptTypeAttribute(context, rc);
            this._writeScrollScript(context, rc, tableId);
            writer.endElement("script");
        }
        if (wideMode) {
            writer.startElement("table", null);
            OutputUtils.renderLayoutTableAttributes(context, rc, "0", "0", "100%");
        } else {
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    private void _writeScrollScript(FacesContext context, RenderingContext rc, String tableId) throws IOException {
        boolean previouslyNotRendered;
        ResponseWriter writer = context.getResponseWriter();
        boolean bl = previouslyNotRendered = rc.getProperties().put(_IE_SCROLL_KEY, Boolean.TRUE) == null;
        if (previouslyNotRendered) {
            writer.write("function _uixAdjustWidths(){};\n_uixAdjustWidths.addElement = function(tableId)\n{\nif (_uixAdjustWidths.elements == null)\n{\n_uixAdjustWidths.elements = new Array();\n}\n_uixAdjustWidths.elements.push(tableId);\n};\n_uixAdjustWidths.incrementIndex = function(headerList, index, increment)\n{\nvar inc=parseInt(increment,10);\nindex+=inc;\nwhile (index<headerList.length && headerList[index]!=null)\nindex++;\nreturn index;\n};\n_uixAdjustWidths.setColWidths = function()\n{\nvar elements = _uixAdjustWidths.elements;\nfor(var k=0; k<elements.length; k++)\n{\nvar headerId=elements[k]+'_head';\nvar dataId=elements[k]+'_data';\nvar footerId=elements[k]+'_foot';\nvar headerList=new Array();\nvar firstRowCells=null;\nif (document.getElementById(dataId) != null)\nif (document.getElementById(dataId).rows != null)\nif (document.getElementById(dataId).rows.length>0)\n{\nfirstRowCells=document.getElementById(dataId).rows[0].cells;\nvar footerCells=null;if (document.getElementById(footerId) != null) footerCells=document.getElementById(footerId).rows[0].cells;\nvar rows=document.getElementById(headerId).getElementsByTagName('tr');\nfor (var i=0;i<rows.length;i++)\n{\nvar headers=rows[i].getElementsByTagName('th');\nvar index=_uixAdjustWidths.incrementIndex(headerList, 0, 0);\nfor (var j=0;j<headers.length;j++)\n{\nif (headers[j].colSpan >'1')\n{\nheaderList.splice(index, parseInt(headers[j].colSpan,10));\nindex+=_uixAdjustWidths.incrementIndex(headerList, index, headers[j].colSpan);\n}\nelse\n{\nheaderList.splice(index,1,headers[j]);\nindex+=_uixAdjustWidths.incrementIndex(headerList, index, 1);\n}\n}\n}\nfor (var i=0;i<headerList.length;i++)\n{\nheaderList[i].width='';\n}\nvar outerTable=document.getElementById(elements[k]).getElementsByTagName('table')[0];\nvar noTableWidth=false;\nif (outerTable.width=='' && outerTable.style.width=='')\n{\nnoTableWidth=true;\nouterTable.width='100%';\n}\nif (headerList.length>0)\nfor (var i=0;i<firstRowCells.length-1;i++)\n{\nheaderList[i].style.width=parseInt(firstRowCells[i].offsetWidth,10) +'px';\nheaderList[i].style.width=(parseInt(firstRowCells[i].offsetWidth,10)*2-parseInt(headerList[i].offsetWidth,10) )+'px';\n}\nif (footerCells != null)\nfor (var i=0;i<footerCells.length-1;i++)\n{\n var footerIdx=footerCells.length-1-i;\n var dataIdx=firstRowCells.length-1-i;\n footerCells[footerIdx].style.width=parseInt(firstRowCells[dataIdx].offsetWidth,10) +'px';\n footerCells[footerIdx].style.width=(parseInt(firstRowCells[dataIdx].offsetWidth,10)*2-parseInt(footerCells[footerIdx].offsetWidth,10) )+'px';\n}\nif (noTableWidth)\nouterTable.width='';\n}\n}\n};\n");
        }
        writer.write("_uixAdjustWidths.addElement('" + tableId + "');\n");
        writer.write("if (document.readyState == 'complete')\n{\n_uixAdjustWidths.setColWidths();\n}\n");
        if (previouslyNotRendered) {
            writer.write("if (_uixAdjustWidths.attached == null)\n{\n_uixAdjustWidths.attached = true;\nif (window.addEventListener) \nwindow.addEventListener('load', _uixAdjustWidths.setColWidths, false); \nelse if (window.attachEvent)\nwindow.attachEvent('onload', _uixAdjustWidths.setColWidths); \nelse if (document.getElementById)\nwindow.onload=_uixAdjustWidths.setColWidths;\nif (window.addEventListener) \nwindow.addEventListener('resize', _uixAdjustWidths.setColWidths, false); \nelse if (window.attachEvent)\nwindow.attachEvent('onresize', _uixAdjustWidths.setColWidths); \nelse if (document.getElementById)\nwindow.onresize=_uixAdjustWidths.setColWidths;\n}\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void renderControlBar(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        boolean hasNav;
        UIComponent action = DesktopTableRenderer.getFacet((UIComponent)component, (String)"actions");
        boolean tableNotEmpty = !tContext.getRowData().isEmptyTable();
        boolean bl = hasNav = tContext.hasNavigation() && tableNotEmpty;
        if (hasNav || action != null) {
            boolean isUpper = tContext.getRenderStage().getStage() == 10;
            ResponseWriter oldRW = null;
            try {
                if (!isUpper) {
                    oldRW = RepeatIdResponseWriter.install(context);
                }
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("tr", null);
                writer.startElement("td", null);
                String style = "af|table::control-bar-top";
                if (!isUpper) {
                    style = "af|table::control-bar-bottom";
                }
                writer.startElement("table", null);
                OutputUtils.renderLayoutTableAttributes(context, rc, "0", "0", "0", "100%");
                DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)style);
                writer.startElement("tr", null);
                if (action != null) {
                    writer.startElement("td", null);
                    this.encodeChild(context, action);
                    writer.endElement("td");
                }
                writer.startElement("td", null);
                writer.writeAttribute("width", (Object)"100%", null);
                writer.endElement("td");
                if (hasNav) {
                    writer.startElement("td", null);
                    if (rc.isRightToLeft()) {
                        writer.writeAttribute("align", (Object)"left", null);
                    } else {
                        writer.writeAttribute("align", (Object)"right", null);
                    }
                    writer.writeAttribute("valign", (Object)"middle", null);
                    this.renderRangePagingControl(context, rc, tContext, component);
                    writer.endElement("td");
                }
                writer.endElement("tr");
                writer.endElement("table");
                writer.endElement("td");
                writer.endElement("tr");
            }
            finally {
                if (!isUpper) {
                    assert (oldRW != null);
                    RepeatIdResponseWriter.remove(context, oldRW);
                }
            }
        }
    }

    protected void renderRangePagingControl(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        this.delegateRenderer(context, rc, component, this.getFacesBean(component), this.getSharedNavBarRenderer());
    }

    private boolean _assertCurrencyKeyPreserved(Object oldKey, UIComponent table) {
        UIXCollection base = (UIXCollection)table;
        Object newKey = base.getRowKey();
        return oldKey != null ? oldKey.equals(newKey) : newKey == null;
    }

    protected Object getTablePadding(UIComponent component) {
        return "1";
    }

    protected void renderTableRows(FacesContext context, RenderingContext rc, TableRenderingContext trc, UIComponent component, FacesBean bean) throws IOException {
        if (trc.getRowData().isEmptyTable()) {
            this._renderEmptyTable(context, rc, trc);
        } else {
            this._renderTableRows(context, rc, trc, component);
        }
        this.renderFooter(context, rc, trc, component);
    }

    @Override
    protected void renderTableAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, Object cellPadding, Object border) throws IOException {
        super.renderTableAttributes(context, rc, component, bean, cellPadding, border);
    }

    protected void renderCellFormatAttributes(FacesContext context, RenderingContext rc, TableRenderingContext tContext) throws IOException {
        boolean noSelect;
        String cellClass = "af|column::cell-text";
        String borderStyleClass = CellUtils.getDataBorderStyle(rc, tContext);
        DesktopTableRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)rc, (String[])new String[]{cellClass, borderStyleClass});
        ResponseWriter writer = context.getResponseWriter();
        int row = tContext.getRowData().getRangeIndex();
        int physicalColumn = tContext.getColumnData().getPhysicalColumnIndex();
        boolean bl = noSelect = !tContext.hasSelection();
        if (row == 0 && noSelect && !tContext.hasColumnHeaders()) {
            Object width = tContext.getColumnWidth(physicalColumn);
            writer.writeAttribute("width", width, null);
        }
        if (tContext.getColumnData().getNoWrap(physicalColumn)) {
            writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
        }
    }

    private void _renderTableHeader(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = DesktopTableRenderer.getFacet((UIComponent)component, (String)"header");
        if (header != null) {
            writer.startElement("thead", null);
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)tContext.getActualColumnCount(), null);
            DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|column::sortable-header-icon-format");
            this.encodeChild(context, header);
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("thead");
        }
    }

    private void _renderEmptyTable(FacesContext context, RenderingContext rc, TableRenderingContext tContext) throws IOException {
        int specialCols;
        int n = specialCols = tContext.hasSelection() ? 1 : 0;
        if (tContext.getDetail() != null) {
            ++specialCols;
        }
        this.renderEmptyTableRow(context, rc, tContext, specialCols);
    }

    protected final void renderEmptyTableRow(FacesContext context, RenderingContext rc, TableRenderingContext tContext, int specialColumnCount) throws IOException {
        this.renderEmptyTableRow(context, rc, tContext, specialColumnCount, null);
    }

    protected final void renderEmptyTableRow(FacesContext context, RenderingContext rc, TableRenderingContext tContext, int specialColumnCount, CoreRenderer emptyTextRenderer) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        ColumnData colData = tContext.getColumnData();
        int physicalColumn = 0;
        int objectNameColumnIndex = colData.getObjectNameColumnIndex();
        int sz = Math.max(specialColumnCount, objectNameColumnIndex);
        for (int i = 0; i < sz; ++i) {
            this._renderEmptyCell(context, rc, tContext, physicalColumn++, null, 1);
        }
        int totalCols = tContext.getActualColumnCount();
        UIComponent table = tContext.getTable();
        FacesBean bean = this.getFacesBean(table);
        if (emptyTextRenderer == null) {
            this._renderEmptyCell(context, rc, tContext, physicalColumn, this.getEmptyText(table, bean), totalCols - physicalColumn);
            ++physicalColumn;
        } else {
            this.delegateRenderer(context, rc, table, bean, emptyTextRenderer);
            while (physicalColumn < totalCols) {
                this._renderEmptyCell(context, rc, tContext, physicalColumn++, null, 1);
            }
        }
        colData.setCurrentHeaderID(null);
        writer.endElement("tr");
    }

    private void _renderEmptyCell(FacesContext context, RenderingContext rc, TableRenderingContext tContext, int physicalColumn, String text, int colspan) throws IOException {
        ColumnData colData = tContext.getColumnData();
        ResponseWriter writer = context.getResponseWriter();
        String colID = colData.getHeaderID(physicalColumn);
        colData.setCurrentHeaderID(colID);
        colData.setColumnIndex(physicalColumn, -1);
        writer.startElement("td", null);
        this.renderCellFormatAttributes(context, rc, tContext);
        if (colspan > 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        if (text != null) {
            writer.writeText((Object)text, null);
        }
        writer.endElement("td");
    }

    private void _renderTableRows(FacesContext context, final RenderingContext rc, final TableRenderingContext tContext, UIComponent component) throws IOException {
        boolean useScroll;
        final RowData rowData = tContext.getRowData();
        final UIComponent detail = tContext.getDetail();
        final RenderStage renderStage = tContext.getRenderStage();
        TableUtils.RowLoop loop = new TableUtils.RowLoop(){

            @Override
            protected void processRowImpl(FacesContext fc, CollectionComponent tableBase) throws IOException {
                ResponseWriter writer = fc.getResponseWriter();
                rowData.setCurrentRowSpan(-1);
                renderStage.setStage(35);
                DesktopTableRenderer.this.renderSingleRow(fc, rc, tContext, (UIComponent)tableBase);
                renderStage.setStage(30);
                int sz = rowData.getCurrentRowSpan();
                for (int i = 0; i < sz; ++i) {
                    writer.startElement("tr", null);
                    DesktopTableRenderer.this.renderSingleRow(fc, rc, tContext, (UIComponent)tableBase);
                    rowData.incCurrentSubRow();
                    writer.endElement("tr");
                }
                if (detail != null && ((UIXTable)tableBase).getDisclosedRowKeys().isContained()) {
                    renderStage.setStage(45);
                    ColumnData colData = tContext.getColumnData();
                    writer.startElement("tr", null);
                    writer.startElement("td", null);
                    writer.writeAttribute("headers", (Object)colData.getHeaderID(tContext.getDetailColumnIndex()), null);
                    writer.writeAttribute("colspan", (Object)IntegerUtils.getString((int)tContext.getActualColumnCount()), null);
                    String styleClass = "af|table::detail";
                    String borderStyleClass = CellUtils.getBorderClass(true, true, true, true);
                    CoreRenderer.renderStyleClasses((FacesContext)fc, (RenderingContext)rc, (String[])new String[]{styleClass, borderStyleClass});
                    DesktopTableRenderer.this.encodeChild(fc, detail);
                    writer.endElement("td");
                    writer.endElement("tr");
                    renderStage.setStage(30);
                }
            }
        };
        ResponseWriter writer = context.getResponseWriter();
        String height = this.getHeight(component, this.getFacesBean(component));
        if (height != null && DesktopTableRenderer.isGecko((RenderingContext)rc)) {
            useScroll = true;
            writer.startElement("tbody", null);
            writer.writeAttribute("style", (Object)("overflow:auto;max-height:" + height), null);
        } else {
            useScroll = false;
        }
        loop.run(context, tContext.getCollectionComponent());
        if (useScroll) {
            writer.endElement("tbody");
        }
    }

    protected final void renderColumnHeader(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        ColumnData colData = tContext.getColumnData();
        colData.setRowIndex(0);
        int physicalCol = this.renderSpecialColumns(context, rc, tContext, component, 0);
        this.renderRegularHeaders(context, rc, tContext, component, physicalCol);
        colData.setRowIndex(-1);
    }

    protected final void renderRegularHeaders(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component, int physicalCol) throws IOException {
        ColumnData colData = tContext.getColumnData();
        this._renderRegularColumns(context, tContext, component, physicalCol);
        int rowSpan = colData.getHeaderRowSpan();
        if (rowSpan > 1) {
            ResponseWriter writer = context.getResponseWriter();
            for (int i = 1; i < rowSpan; ++i) {
                colData.setRowIndex(i);
                writer.endElement("tr");
                writer.startElement("tr", null);
                this._renderRegularColumns(context, tContext, component, physicalCol);
            }
        }
    }

    private void _renderRegularColumns(FacesContext context, TableRenderingContext tContext, UIComponent component, int physicalCol) throws IOException {
        List children = component.getChildren();
        int colCount = children.size();
        int[] hidden = tContext.getHiddenColumns();
        ColumnData colData = tContext.getColumnData();
        for (int i = 0; i < colCount; ++i) {
            UIXColumn column;
            boolean isRowHeader;
            UIComponent child;
            if (hidden[i] != 0 || !((child = (UIComponent)children.get(i)) instanceof UIXColumn) || (isRowHeader = Boolean.TRUE.equals((column = (UIXColumn)child).getAttributes().get(CoreColumn.ROW_HEADER_KEY.getName())))) continue;
            colData.setColumnIndex(physicalCol, i);
            this.encodeChild(context, (UIComponent)column);
            physicalCol = colData.getPhysicalColumnIndex();
        }
    }

    protected final void renderFooter(FacesContext context, RenderingContext rc, TableRenderingContext tContext, UIComponent component) throws IOException {
        boolean hasColumnFooters;
        tContext.getRenderStage().setStage(60);
        ColumnData colData = tContext.getColumnData();
        UIComponent footer = DesktopTableRenderer.getFacet((UIComponent)component, (String)"footer");
        boolean bl = hasColumnFooters = colData.getPhysicalIndexOfFirstFooter() >= 0;
        if (footer != null || hasColumnFooters) {
            boolean useScroll;
            ResponseWriter writer = context.getResponseWriter();
            String height = this.getHeight(component, this.getFacesBean(component));
            boolean bl2 = useScroll = height != null;
            if (useScroll) {
                String tableId = tContext.getTableId();
                writer.endElement("table");
                writer.endElement("div");
                writer.startElement("table", null);
                DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|table::content");
                writer.writeAttribute("id", (Object)(tableId + "_foot"), null);
                OutputUtils.renderLayoutTableAttributes(context, rc, "0", "0", "100%");
            }
            writer.startElement("tr", null);
            int firstFooterPhysicalIndex = colData.getPhysicalIndexOfFirstFooter();
            if (firstFooterPhysicalIndex != 0) {
                writer.startElement("th", null);
                int colSpan = firstFooterPhysicalIndex > 0 ? firstFooterPhysicalIndex : tContext.getActualColumnCount();
                writer.writeAttribute("colspan", (Object)IntegerUtils.getString((int)colSpan), null);
                DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|table::column-footer");
                if (footer != null) {
                    this.encodeChild(context, footer);
                }
                writer.endElement("th");
            }
            if (firstFooterPhysicalIndex >= 0) {
                colData.setColumnIndex(tContext.getSpecialColumnCount(), 0);
                for (UIComponent child : component.getChildren()) {
                    if (!child.isRendered()) continue;
                    this.encodeChild(context, child);
                }
            }
            writer.endElement("tr");
            if (firstFooterPhysicalIndex == 0 && footer != null) {
                writer.startElement("tr", null);
                writer.startElement("th", null);
                writer.writeAttribute("colspan", (Object)tContext.getActualColumnCount(), null);
                DesktopTableRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|table::column-footer");
                this.encodeChild(context, footer);
                writer.endElement("th");
                writer.endElement("tr");
            }
        }
    }

    protected String getControlLinkIconName(String translationKey) {
        if (translationKey == null) {
            return null;
        }
        return translationKey.equals(_SELECT_ALL_TEXT_KEY) ? "af|table::select-all-icon" : "af|table::select-none-icon";
    }

    protected String getSummary(UIComponent component, FacesBean bean) {
        return DesktopTableRenderer.toString((Object)bean.getProperty(this._summaryKey));
    }

    protected String getHeight(UIComponent component, FacesBean bean) {
        return DesktopTableRenderer.toString((Object)bean.getProperty(this._heightKey));
    }

    protected boolean isAutoSubmit(UIComponent component, FacesBean bean) {
        if (this._autoSubmitKey == null) {
            return false;
        }
        return Boolean.TRUE.equals(bean.getProperty(this._autoSubmitKey));
    }

    protected boolean getAllDetailsEnabled(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._allDetailsEnabledKey);
        if (o == null) {
            o = this._allDetailsEnabledKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    private static class AllDetail
    extends ShowDetailRenderer {
        private boolean _disclosed;

        public AllDetail(FacesBean.Type type, boolean disclosed) {
            super(type);
            this._disclosed = disclosed;
        }

        @Override
        protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        }

        @Override
        protected boolean isTableAllDisclosure() {
            return true;
        }

        @Override
        protected boolean renderAsInline() {
            return true;
        }

        @Override
        protected String getValueParameter(UIComponent component) {
            return "all";
        }

        @Override
        protected boolean getDisclosed(UIComponent component, FacesBean bean) {
            return this._disclosed;
        }

        @Override
        protected String getDisclosedText(UIComponent component, FacesBean bean) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            return arc.getTranslatedString(DesktopTableRenderer._HIDE_ALL_DETAILS_TEXT_KEY);
        }

        @Override
        protected String getUndisclosedText(UIComponent component, FacesBean bean) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            return arc.getTranslatedString(DesktopTableRenderer._SHOW_ALL_DETAILS_TEXT_KEY);
        }

        @Override
        protected String getLinkId(String rootId, boolean disclosed) {
            String suffix = disclosed ? "ha" : "sa";
            return XhtmlUtils.getCompositeId(rootId, suffix);
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            TableRenderingContext tContext = TableRenderingContext.getCurrentInstance();
            return tContext.getTableId();
        }
    }
}

