/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.desktop;

import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.data.CoreChart;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.event.ChartDrillDownEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.ChartModel;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.LibraryScriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;

public class ChartRenderer
extends XhtmlRenderer {
    private Scriptlet chartLib;
    private PropertyKey _typeKey;
    private PropertyKey _templateSourceKey;
    private PropertyKey _perspectiveKey;
    private PropertyKey _legendPositionKey;
    private PropertyKey _animationDurationKey;
    private PropertyKey _gradientsUsedKey;
    private PropertyKey _tooltipsVisibleKey;
    private PropertyKey _YMajorGridLineCountKey;
    private PropertyKey _XMajorGridLineCountKey;
    private PropertyKey _YMinorGridLineCountKey;
    private PropertyKey _maxPrecisionKey;
    private static final String _DELIMITER = "\\$adf\\$";
    private static final String _TEMPLATE_DOC = "/adf/svg/chart.svg";
    private static final String _TEMPLATE_DOC_NOGRADIENT = "/adf/svg/chartNoGradient.svg";
    private static final String _NUMBER_CONVERTER_SCRIPTLET = "TrNumberConverter()";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ChartRenderer.class);
    private static final Map<String, Integer> _typeToJSTypeMap = new HashMap<String, Integer>();

    public ChartRenderer() {
        super(CoreChart.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this.chartLib = new LibraryScriptlet("ApacheChart", null);
        this._typeKey = type.findKey("type");
        this._templateSourceKey = type.findKey("templateSource");
        this._perspectiveKey = type.findKey("perspective");
        this._legendPositionKey = type.findKey("legendPosition");
        this._animationDurationKey = type.findKey("animationDuration");
        this._gradientsUsedKey = type.findKey("gradientsUsed");
        this._tooltipsVisibleKey = type.findKey("tooltipsVisible");
        this._YMajorGridLineCountKey = type.findKey("YMajorGridLineCount");
        this._XMajorGridLineCountKey = type.findKey("XMajorGridLineCount");
        this._YMinorGridLineCountKey = type.findKey("YMinorGridLineCount");
        this._maxPrecisionKey = type.findKey("maxPrecision");
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        String id;
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        String source = (String)parameters.get("source");
        String string = id = clientId == null ? component.getClientId(facesContext) : clientId;
        if (!id.equals(source)) {
            return;
        }
        Object eventParam = parameters.get("event");
        if ("chartDrillDown".equals(eventParam)) {
            String[] tokens;
            int[] seriesIndices = null;
            int[] yValueIndices = null;
            double[] yValues = null;
            double[] xValues = null;
            String value = (String)parameters.get("value");
            for (String token : tokens = value.split(_DELIMITER)) {
                String[] subTokens = token.split("\t");
                if ("seriesIndices".equals(subTokens[0])) {
                    seriesIndices = this._unmarshallEventInts(subTokens);
                    continue;
                }
                if ("yValueIndices".equals(subTokens[0])) {
                    yValueIndices = this._unmarshallEventInts(subTokens);
                    continue;
                }
                if ("yValues".equals(subTokens[0])) {
                    yValues = this._unmarshallEventDoubles(subTokens);
                    continue;
                }
                if (!"xValues".equals(subTokens[0])) continue;
                xValues = this._unmarshallEventDoubles(subTokens);
            }
            ChartDrillDownEvent event = new ChartDrillDownEvent(component, seriesIndices, yValueIndices, yValues, xValues);
            event.queue();
        }
    }

    private int[] _unmarshallEventInts(String[] tokens) {
        int[] indices = new int[tokens.length - 1];
        for (int i = 1; i < tokens.length; ++i) {
            indices[i - 1] = Integer.parseInt(tokens[i]);
        }
        return indices;
    }

    private double[] _unmarshallEventDoubles(String[] tokens) {
        double[] values = new double[tokens.length - 1];
        for (int i = 1; i < tokens.length; ++i) {
            values[i - 1] = Double.parseDouble(tokens[i]);
        }
        return values;
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (this.canSkipRendering(context, rc, component)) {
            return;
        }
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("div", component);
        this.renderId(context, component);
        this.renderStyleAttributes(context, rc, component, bean, "af|chart");
        XhtmlUtils.addLib(context, rc, _NUMBER_CONVERTER_SCRIPTLET);
        this.chartLib.outputScriptlet(context, rc);
        StringWriter sw = new StringWriter(5000);
        this._outputSVGDocumentCreate(context, sw, component, bean);
        this._outputJSChartModel(sw, component);
        this._outputJSChartObject(context, rc, sw, component, bean);
        rw.startElement("script", null);
        ChartRenderer.renderScriptDeferAttribute(context, rc);
        ChartRenderer.renderScriptTypeAttribute(context, rc);
        rw.write(sw.toString());
        rw.endElement("script");
        rw.endElement("div");
    }

    protected void _outputSVGDocumentCreate(FacesContext context, StringWriter sw, UIComponent component, FacesBean bean) throws IOException {
        sw.append("ApacheChart.createSVG(\"");
        String clientId = component.getClientId(context);
        sw.append(clientId);
        sw.append("\",\"svgChart");
        sw.append(clientId);
        sw.append("\",\"");
        String templateURL = this.getTemplateSource(component, bean);
        templateURL = context.getExternalContext().encodeResourceURL(templateURL);
        sw.append(templateURL);
        sw.append("\",\"width:100%; height:100%;\"");
        sw.append(",null);\n");
    }

    protected void _outputJSChartModel(StringWriter sw, UIComponent component) throws IOException {
        CoreChart chart = (CoreChart)component;
        ChartModel model = (ChartModel)chart.getValue();
        if (model == null) {
            _LOG.severe("MODEL_NOT_SPECIFIED_FOR_CHART_COMPONENT");
            return;
        }
        sw.append("var seriesLabels = ");
        ChartRenderer._writeJSObject(sw, model.getSeriesLabels());
        sw.append(";\n");
        sw.append("var groupLabels = ");
        ChartRenderer._writeJSObject(sw, model.getGroupLabels());
        sw.append(";\n");
        sw.append("var seriesColors = ");
        ChartRenderer._writeJSObject(sw, model.getSeriesColors());
        sw.append(";\n");
        sw.append("var xValues = ");
        ChartRenderer._writeJSObject(sw, model.getXValues());
        sw.append(";\n");
        sw.append("var yValues = ");
        ChartRenderer._writeJSObject(sw, model.getYValues());
        sw.append(";\n");
        sw.append("var model = new ApacheChartModel(seriesLabels, groupLabels, yValues, xValues, seriesColors);\n");
        sw.append("model.setMinYValue(");
        ChartRenderer._writeJSObject(sw, model.getMinYValue());
        sw.append(");\n");
        sw.append("model.setMaxYValue(");
        ChartRenderer._writeJSObject(sw, model.getMaxYValue());
        sw.append(");\n");
        sw.append("model.setMinXValue(");
        ChartRenderer._writeJSObject(sw, model.getMinXValue());
        sw.append(");\n");
        sw.append("model.setMaxXValue(");
        ChartRenderer._writeJSObject(sw, model.getMaxXValue());
        sw.append(");\n");
        sw.append("model.setTitle(");
        ChartRenderer._writeJSObject(sw, model.getTitle());
        sw.append(");\n");
        sw.append("model.setSubTitle(");
        ChartRenderer._writeJSObject(sw, model.getSubTitle());
        sw.append(");\n");
        sw.append("model.setFootNote(");
        ChartRenderer._writeJSObject(sw, model.getFootNote());
        sw.append(");\n");
    }

    protected void _outputJSChartObject(FacesContext context, RenderingContext rc, StringWriter sw, UIComponent component, FacesBean bean) throws IOException {
        Integer type = _typeToJSTypeMap.get(this.getType(bean));
        if (type == null) {
            type = 1;
        }
        sw.append("var type = ");
        ChartRenderer._writeJSObject(sw, type);
        sw.append(";\n");
        String clientId = component.getClientId(context);
        sw.append("var chartId = ");
        ChartRenderer._writeJSObject(sw, "svgChart" + clientId);
        sw.append(";\n");
        sw.append("var isPerspective = ");
        ChartRenderer._writeJSObject(sw, this.isPerspective(component, bean));
        sw.append(";\n");
        sw.append("var legendPosition = ");
        ChartRenderer._writeJSObject(sw, this.getLegendPosition(component, bean));
        sw.append(";\n");
        sw.append("var apacheChart = ApacheChart.createChart(type, model, chartId, isPerspective, legendPosition);");
        sw.append("apacheChart.setYMajorGridLineCount(");
        ChartRenderer._writeJSObject(sw, this.getYMajorGridLineCount(component, bean));
        sw.append(");\n");
        sw.append("apacheChart.setYMinorGridLineCount(");
        ChartRenderer._writeJSObject(sw, this.getYMinorGridLineCount(component, bean));
        sw.append(");\n");
        sw.append("apacheChart.setXMajorGridLineCount(");
        ChartRenderer._writeJSObject(sw, this.getXMajorGridLineCount(component, bean));
        sw.append(");\n");
        sw.append("apacheChart.setGradientsUsed(");
        ChartRenderer._writeJSObject(sw, this.isGradientsUsed(component, bean));
        sw.append(");\n");
        sw.append("apacheChart.setAnimationDuration(");
        ChartRenderer._writeJSObject(sw, this.getAnimationDuration(component, bean));
        sw.append(");\n");
        sw.append("apacheChart.setTooltipsVisible(");
        ChartRenderer._writeJSObject(sw, this.isTooltipsVisible(component, bean));
        sw.append(");\n");
        sw.append("apacheChart.setMaxPrecision(");
        ChartRenderer._writeJSObject(sw, this.getMaxPrecision(component, bean));
        sw.append(");\n");
        FormData fData = rc.getFormData();
        String formName = fData == null ? null : fData.getName();
        if (formName != null) {
            sw.append("apacheChart.setFormName(");
            ChartRenderer._writeJSObject(sw, formName);
            sw.append(");\n");
        }
        if (!PartialPageUtils.isPPRActive(context)) {
            sw.append("apacheChart.setPartialSubmit(");
            ChartRenderer._writeJSObject(sw, false);
            sw.append(");\n");
        }
        if ("ie".equals(rc.getAgent().getAgentName())) {
            sw.append("apacheChart.setErrorHtml(");
            ChartRenderer._writeJSObject(sw, rc.getTranslatedString("af_chart.IE_SVG_PLUGIN_ERROR_HTML"));
            sw.append(");\n");
        } else {
            sw.append("apacheChart.setErrorHtml(");
            ChartRenderer._writeJSObject(sw, rc.getTranslatedString("af_chart.SVG_ENABLED_BROWSER_ERROR_HTML"));
            sw.append(");\n");
        }
        sw.append("apacheChart.setStatusHtml(");
        ChartRenderer._writeJSObject(sw, rc.getTranslatedString("af_chart.SVG_LOADING_STATUS_HTML"));
        sw.append(");\n");
        sw.append("apacheChart.draw();\n");
    }

    private static void _writeJSObject(StringWriter sw, Object attrValue) throws IOException {
        if (attrValue == null) {
            sw.append("null");
        } else {
            if (attrValue instanceof String) {
                ChartRenderer._writeJSString(sw, (String)attrValue);
                return;
            }
            Class<?> valueClass = attrValue.getClass();
            if (Boolean.class == valueClass) {
                ChartRenderer._writeJSBoolean(sw, (Boolean)attrValue);
            } else if (Integer.class == valueClass) {
                ChartRenderer._writeJSInt(sw, (Integer)attrValue);
            } else if (Double.class == valueClass) {
                ChartRenderer._writeJSDouble(sw, (Double)attrValue);
            } else if (Color.class == valueClass) {
                ChartRenderer._writeJSColor(sw, (Color)attrValue);
            } else if (Collection.class.isAssignableFrom(valueClass)) {
                ChartRenderer._writeJSCollection(sw, (Collection)attrValue);
            }
        }
    }

    private static void _writeJSString(StringWriter sw, String value) throws IOException {
        if (value == null) {
            sw.append("null");
        } else {
            sw.append('\'');
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                ChartRenderer._escapeChar(sw, ch);
            }
            sw.append('\'');
        }
    }

    private static void _escapeChar(StringWriter sw, char value) {
        switch (value) {
            case '&': {
                sw.append('&');
                break;
            }
            case '<': {
                sw.append('<');
                break;
            }
            case '>': {
                sw.append('>');
                break;
            }
            case '\"': {
                sw.append("\\\"");
                break;
            }
            case '\'': {
                sw.append("\\'");
                break;
            }
            case '\\': {
                sw.append("\\\\");
                break;
            }
            case '\b': {
                sw.append("\\b");
                break;
            }
            case '\f': {
                sw.append("\\f");
                break;
            }
            case '\n': {
                sw.append("\\n");
                break;
            }
            case '\r': {
                sw.append("\\r");
                break;
            }
            case '\t': {
                sw.append("\\t");
                break;
            }
            default: {
                if (value >= ' ' && value < '\u0080') {
                    sw.append(value);
                    break;
                }
                String hex = Integer.toHexString(value);
                if (value > '\u00ff') {
                    sw.append("\\u");
                    if (value < '\u1000') {
                        sw.append('0');
                    }
                    sw.append(hex);
                    break;
                }
                sw.append("\\x");
                if (value < '\u0010') {
                    sw.append('0');
                }
                sw.append(hex);
            }
        }
    }

    public static void _writeJSInt(StringWriter sw, Integer value) throws IOException {
        sw.append(String.valueOf(value));
    }

    private static void _writeJSBoolean(StringWriter sw, Boolean value) throws IOException {
        sw.append(String.valueOf(value));
    }

    private static void _writeJSDouble(StringWriter sw, Double value) throws IOException {
        sw.append(String.valueOf(value));
    }

    private static void _writeJSColor(StringWriter sw, Color color) throws IOException {
        sw.append("\"RGB(");
        sw.append(String.valueOf(color.getRed()));
        sw.append(",");
        sw.append(String.valueOf(color.getGreen()));
        sw.append(",");
        sw.append(String.valueOf(color.getBlue()));
        sw.append(")\"");
    }

    private static void _writeJSCollection(StringWriter sw, Collection<?> value) throws IOException {
        if (value == null) {
            sw.append("null");
        } else if (value.isEmpty()) {
            sw.append("[]");
        } else {
            sw.append("[");
            Iterator<?> iter = value.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                ChartRenderer._writeJSObject(sw, item);
                if (!iter.hasNext()) continue;
                sw.append(',');
            }
            sw.append(']');
        }
    }

    private static Object _getProperty(FacesBean bean, PropertyKey key) {
        Object ret = bean.getProperty(key);
        if (ret == null) {
            ret = key.getDefault();
        }
        return ret;
    }

    protected String getType(FacesBean bean) {
        return ChartRenderer.toString((Object)ChartRenderer._getProperty(bean, this._typeKey));
    }

    protected String getTemplateSource(UIComponent component, FacesBean bean) {
        Object ret = bean.getProperty(this._templateSourceKey);
        String uri = ret == null ? (this.isGradientsUsed(component, bean) ? _TEMPLATE_DOC : _TEMPLATE_DOC_NOGRADIENT) : ChartRenderer.toString((Object)ret);
        return ChartRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)uri);
    }

    protected boolean isPerspective(UIComponent component, FacesBean bean) {
        return Boolean.TRUE.equals(ChartRenderer._getProperty(bean, this._perspectiveKey));
    }

    protected String getLegendPosition(UIComponent component, FacesBean bean) {
        return ChartRenderer.toString((Object)ChartRenderer._getProperty(bean, this._legendPositionKey));
    }

    protected Integer getAnimationDuration(UIComponent component, FacesBean bean) {
        return (Integer)ChartRenderer._getProperty(bean, this._animationDurationKey);
    }

    protected boolean isGradientsUsed(UIComponent component, FacesBean bean) {
        return Boolean.TRUE.equals(ChartRenderer._getProperty(bean, this._gradientsUsedKey));
    }

    protected boolean isTooltipsVisible(UIComponent component, FacesBean bean) {
        return Boolean.TRUE.equals(ChartRenderer._getProperty(bean, this._tooltipsVisibleKey));
    }

    protected Integer getYMajorGridLineCount(UIComponent component, FacesBean bean) {
        return (Integer)ChartRenderer._getProperty(bean, this._YMajorGridLineCountKey);
    }

    protected Integer getXMajorGridLineCount(UIComponent component, FacesBean bean) {
        return (Integer)ChartRenderer._getProperty(bean, this._XMajorGridLineCountKey);
    }

    protected Integer getYMinorGridLineCount(UIComponent component, FacesBean bean) {
        return (Integer)ChartRenderer._getProperty(bean, this._YMinorGridLineCountKey);
    }

    protected Integer getMaxPrecision(UIComponent component, FacesBean bean) {
        return (Integer)ChartRenderer._getProperty(bean, this._maxPrecisionKey);
    }

    static {
        _typeToJSTypeMap.put("verticalBar", 1);
        _typeToJSTypeMap.put("horizontalBar", 2);
        _typeToJSTypeMap.put("stackedVerticalBar", 3);
        _typeToJSTypeMap.put("stackedHorizontalBar", 4);
        _typeToJSTypeMap.put("pie", 5);
        _typeToJSTypeMap.put("area", 6);
        _typeToJSTypeMap.put("stackedArea", 7);
        _typeToJSTypeMap.put("line", 8);
        _typeToJSTypeMap.put("barLine", 9);
        _typeToJSTypeMap.put("XYLine", 10);
        _typeToJSTypeMap.put("scatterPlot", 11);
        _typeToJSTypeMap.put("radar", 12);
        _typeToJSTypeMap.put("radarArea", 13);
        _typeToJSTypeMap.put("funnel", 14);
        _typeToJSTypeMap.put("circularGauge", 15);
        _typeToJSTypeMap.put("semiCircularGauge", 16);
    }
}

