/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.portlet.faces.annotation.ExcludeFromManagedRequestScope;
import org.apache.myfaces.trinidad.config.Configurator;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.ExtendedUploadedFile;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidad.util.RequestStateMap;
import org.apache.myfaces.trinidad.util.RequestType;
import org.apache.myfaces.trinidadinternal.config.upload.FileUploadUtils;
import org.apache.myfaces.trinidadinternal.config.upload.UploadActionInvocationHandler;
import org.apache.myfaces.trinidadinternal.config.upload.UploadRequestWrapper;
import org.apache.myfaces.trinidadinternal.config.upload.UploadResourceRequest;
import org.apache.myfaces.trinidadinternal.config.upload.UploadedFiles;
import org.apache.myfaces.trinidadinternal.share.util.MultipartFormHandler;
import org.apache.myfaces.trinidadinternal.share.util.MultipartFormItem;
import org.apache.myfaces.trinidadinternal.ui.marshal.MarshalingService;

public class FileUploadConfiguratorImpl
extends Configurator {
    private static final String _APPLIED = FileUploadConfiguratorImpl.class.getName() + ".APPLIED";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FileUploadConfiguratorImpl.class);
    private static final String _PARAMS = FileUploadConfiguratorImpl.class.getName() + ".PARAMS";
    private static final boolean _ENHANCED_PORTLET_SUPPORTED = ExternalContextUtils.isRequestTypeSupported((RequestType)RequestType.RESOURCE);
    private static final String _MULTIPLE_UPLOAD_PARAM = "org.apache.myfaces.trinidad.UploadedFiles";
    private static final String _MULTIPLE_UPLOAD_FILE_PROPERTY_PARAM = "org.apache.myfaces.trinidad.UploadedFiles.FileProperty";
    private static final String _MULTIPLE_UPLOAD_CHUNK_NUM_PARAM = "X-Trinidad-chunkNum";
    private static final String _MULTIPLE_UPLOAD_CHUNK_COUNT_PARAM = "X-Trinidad-chunkCount";
    private static final String _MULTIPLE_UPLOAD_CHUNK_FILENAME_PARAM = "X-Trinidad-chunkFilename";
    private static final String _UPLOADED_CHUNK_FILES_LIST_KEY = "org.apache.myfaces.trinidadinternal.webapp.UploadedFiles.ChunkList";
    private static volatile MarshalingService _marshalingService = null;
    private long _maxAllowedBytes = 0x8000000L;

    public static Map<String, String[]> getAddedParameters(ExternalContext externalContext) {
        Map map = (Map)externalContext.getRequestMap().get(_PARAMS);
        return map;
    }

    public static boolean isApplied(ExternalContext context) {
        return RequestStateMap.getInstance((ExternalContext)context).get((Object)_APPLIED) != null;
    }

    public static void apply(ExternalContext context) {
        RequestStateMap.getInstance((ExternalContext)context).put((Object)_APPLIED, (Object)AppliedClass.APPLIED);
    }

    public void beginRequest(ExternalContext externalContext) {
        block16: {
            RequestType reqType = ExternalContextUtils.getRequestType((ExternalContext)externalContext);
            if (MultipartFormHandler.isMultipartRequest(externalContext) && (ExternalContextUtils.isHttpServletRequest((ExternalContext)externalContext) || reqType.isPortlet())) {
                try {
                    String fileName;
                    String itemName;
                    String uploadType;
                    HashMap<String, String[]> parameters;
                    RequestContext requestContext = RequestContext.getCurrentInstance();
                    UploadedFiles files = UploadedFiles.getUploadedFiles(externalContext);
                    if (!FileUploadUtils.isProcessed(externalContext) || reqType.isPortlet()) {
                        MultipartFormItem item;
                        MultipartFormHandler mfh = new MultipartFormHandler(externalContext);
                        mfh.setMaximumAllowedBytes(this._maxAllowedBytes);
                        mfh.setCharacterEncoding(ExternalContextUtils.getCharacterEncoding((ExternalContext)externalContext));
                        parameters = new HashMap<String, String[]>();
                        files = new UploadedFiles(externalContext);
                        while ((item = mfh.getNextPart()) != null) {
                            String name = item.getName();
                            String value = null;
                            if (item.getFilename() == null) {
                                value = item.getValue();
                                Object oldValue = parameters.get(name);
                                if (oldValue == null) {
                                    parameters.put(name, new String[]{value});
                                    continue;
                                }
                                String[] oldArray = (String[])oldValue;
                                String[] newArray = new String[oldArray.length + 1];
                                System.arraycopy(oldArray, 0, newArray, 1, oldArray.length);
                                newArray[0] = value;
                                parameters.put(name, newArray);
                                continue;
                            }
                            if (item.getFilename().length() <= 0) continue;
                            this._doUploadFile(requestContext, externalContext, files, item, parameters);
                        }
                        externalContext.getRequestMap().put(_PARAMS, parameters);
                        FileUploadUtils.markProcessed(externalContext);
                    } else {
                        parameters = externalContext.getRequestParameterValuesMap();
                    }
                    if (null == files || !parameters.containsKey(_MULTIPLE_UPLOAD_PARAM) || (uploadType = ((String[])parameters.get(_MULTIPLE_UPLOAD_PARAM))[0]) == null) break block16;
                    UploadedFiles windowFiles = UploadedFiles.getUploadedFilesForWindow(externalContext);
                    if (uploadType.equals("multipleAdd")) {
                        Map<String, List<UploadedFile>> uploadedMapFile = files.getUploadedFileMap();
                        for (String name : uploadedMapFile.keySet()) {
                            List<UploadedFile> fileList = uploadedMapFile.get(name);
                            for (UploadedFile file : fileList) {
                                windowFiles.__put(name, file);
                            }
                        }
                        UploadedFiles.__saveUploadedFilesForWindow(windowFiles, externalContext, requestContext);
                        uploadedMapFile.clear();
                        break block16;
                    }
                    if (uploadType.equals("multipleDelete")) {
                        itemName = ((String[])parameters.get("itemName"))[0];
                        fileName = ((String[])parameters.get("fileName"))[0];
                        List<UploadedFile> uploadedFiles = windowFiles.getUploadedFileList(itemName);
                        if (uploadedFiles == null) break block16;
                        for (UploadedFile uploadedFile : uploadedFiles) {
                            if (!uploadedFile.getFilename().equals(fileName)) continue;
                            uploadedFiles.remove(uploadedFile);
                            uploadedFile.dispose();
                            UploadedFiles.__saveUploadedFilesForWindow(windowFiles, externalContext, requestContext);
                            break block16;
                        }
                        break block16;
                    }
                    if (uploadType.equals("multipleAddChunk")) {
                        itemName = ((String[])parameters.get("itemName"))[0];
                        fileName = (String)externalContext.getRequestHeaderMap().get(_MULTIPLE_UPLOAD_CHUNK_FILENAME_PARAM);
                        Long chunkNum = Long.parseLong((String)externalContext.getRequestHeaderMap().get(_MULTIPLE_UPLOAD_CHUNK_NUM_PARAM));
                        Long chunkCount = Long.parseLong((String)externalContext.getRequestHeaderMap().get(_MULTIPLE_UPLOAD_CHUNK_COUNT_PARAM));
                        UploadedFile file = files.getUploadedFile(itemName);
                        ArrayList<UploadedFile> chunkList = (ArrayList<UploadedFile>)externalContext.getSessionMap().get(_UPLOADED_CHUNK_FILES_LIST_KEY);
                        if (chunkList == null) {
                            chunkList = new ArrayList<UploadedFile>();
                            externalContext.getSessionMap().put(_UPLOADED_CHUNK_FILES_LIST_KEY, chunkList);
                        }
                        chunkList.add(file);
                        if (chunkNum == chunkCount - 1L) {
                            ChunkedUploadedFile combinedFile = new ChunkedUploadedFile(fileName, file.getContentType(), chunkList);
                            windowFiles.__put(itemName, (UploadedFile)combinedFile);
                            externalContext.getSessionMap().remove(_UPLOADED_CHUNK_FILES_LIST_KEY);
                            UploadedFiles.__saveUploadedFilesForWindow(windowFiles, externalContext, requestContext);
                        }
                        files.getUploadedFileMap().clear();
                    }
                }
                catch (Throwable t) {
                    _LOG.severe(t);
                }
            }
        }
    }

    public ExternalContext getExternalContext(ExternalContext externalContext) {
        Map<String, String[]> addedParams = FileUploadConfiguratorImpl.getAddedParameters(externalContext);
        if (addedParams != null) {
            return FileUploadConfiguratorImpl._getExternalContextWrapper(externalContext, addedParams);
        }
        return externalContext;
    }

    public void endRequest(ExternalContext externalContext) {
        UploadedFiles files;
        if (!ExternalContextUtils.isPortlet((ExternalContext)externalContext) && (files = UploadedFiles.getUploadedFiles(externalContext)) != null) {
            files.dispose();
        }
    }

    public void init(ExternalContext externalContext) {
        super.init(externalContext);
        _marshalingService = FileUploadConfiguratorImpl._getMarshalingService();
    }

    private void _doUploadFile(RequestContext requestContext, ExternalContext externalContext, UploadedFiles files, MultipartFormItem item, Map<String, String[]> parameters) throws IOException {
        String filename = item.getFilename();
        Map<String, Object> properties = FileUploadConfiguratorImpl._getPropertiesMapFromParameters(parameters, item.getName(), filename);
        String chunkFilename = (String)externalContext.getRequestHeaderMap().get(_MULTIPLE_UPLOAD_CHUNK_FILENAME_PARAM);
        if (chunkFilename != null) {
            String chunkNum = (String)externalContext.getRequestHeaderMap().get(_MULTIPLE_UPLOAD_CHUNK_NUM_PARAM);
            filename = chunkFilename = chunkFilename + ".part" + chunkNum;
        }
        TempUploadedFile temp = new TempUploadedFile(filename, item, properties);
        FileUploadUtils.setupRequest(externalContext);
        UploadedFile file = requestContext.getUploadedFileProcessor().processFile(externalContext.getRequest(), (UploadedFile)temp);
        FileUploadUtils.__addFile(files, item.getName(), file);
    }

    private static ExternalContext _getExternalContextWrapper(ExternalContext externalContext, Map<String, String[]> addedParams) {
        if (!FileUploadConfiguratorImpl.isApplied(externalContext)) {
            RequestType type = ExternalContextUtils.getRequestType((ExternalContext)externalContext);
            switch (type) {
                case SERVLET: {
                    externalContext.setRequest((Object)new UploadRequestWrapper(externalContext, addedParams));
                    break;
                }
                case RESOURCE: {
                    externalContext.setRequest((Object)new UploadResourceRequest(externalContext, addedParams));
                    break;
                }
                case ACTION: {
                    Object req = _ENHANCED_PORTLET_SUPPORTED ? FileUploadConfiguratorImpl._getActionRequestWrapper(externalContext, addedParams) : FileUploadConfiguratorImpl._getActionRequestProxy(externalContext, addedParams);
                    externalContext.setRequest(req);
                }
            }
            FileUploadConfiguratorImpl.apply(externalContext);
        }
        return externalContext;
    }

    private static Object _getActionRequestProxy(ExternalContext ec, Map<String, String[]> params) {
        try {
            Class actionRequestClass = ClassLoaderUtils.loadClass((String)"javax.portlet.ActionRequest");
            return Proxy.newProxyInstance(ClassLoaderUtils.getContextClassLoader(), new Class[]{actionRequestClass}, (InvocationHandler)new UploadActionInvocationHandler(ec, params));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object _getActionRequestWrapper(ExternalContext ec, Map<String, String[]> params) {
        try {
            Class wrapperClass = ClassLoaderUtils.loadClass((String)"org.apache.myfaces.trinidadinternal.config.upload.UploadActionRequestWrapper");
            return wrapperClass.getConstructor(ExternalContext.class, Map.class).newInstance(ec, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> _getPropertiesMapFromParameters(Map<String, String[]> parameters, String name, String filename) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        StringBuilder propertiesParamBuilder = new StringBuilder(_MULTIPLE_UPLOAD_FILE_PROPERTY_PARAM);
        propertiesParamBuilder.append(":");
        propertiesParamBuilder.append(name);
        propertiesParamBuilder.append(":");
        propertiesParamBuilder.append(filename);
        String propertiesParam = propertiesParamBuilder.toString();
        if (parameters.get(propertiesParam) == null || parameters.get(propertiesParam).length == 0) {
            return Collections.emptyMap();
        }
        String marshaledProperties = parameters.get(propertiesParam)[0];
        if (marshaledProperties != null && _marshalingService != null) {
            Object propertiesList = _marshalingService.unmarshal(marshaledProperties);
            if (propertiesList instanceof List) {
                for (int i = 0; i < ((List)propertiesList).size(); i += 2) {
                    String propertyName = (String)((List)propertiesList).get(i);
                    Object propertyValue = ((List)propertiesList).get(i + 1);
                    properties.put(propertyName, propertyValue);
                }
            }
            return properties;
        }
        return Collections.emptyMap();
    }

    private static MarshalingService _getMarshalingService() {
        MarshalingService service = null;
        List marshalingServices = ClassLoaderUtils.getServices((String)MarshalingService.class.getName());
        if (marshalingServices != null && !marshalingServices.isEmpty()) {
            service = (MarshalingService)marshalingServices.get(0);
        }
        return service;
    }

    private static class ChunkedUploadedFile
    extends ExtendedUploadedFile {
        private List<UploadedFile> _uploadedFileChunkList = null;
        private String _filename = null;
        private String _contentType = null;
        private static final long serialVersionUID = 4534545227734904589L;

        public ChunkedUploadedFile(String filename, String contentType, List<UploadedFile> uploadedFileChunkList) {
            this._filename = filename;
            this._contentType = contentType;
            this._uploadedFileChunkList = uploadedFileChunkList;
        }

        public String getFilename() {
            return this._filename;
        }

        public String getContentType() {
            return this._contentType;
        }

        public long getLength() {
            Long totalLength = 0L;
            for (UploadedFile file : this._uploadedFileChunkList) {
                if (file.getLength() == -1L) {
                    return -1L;
                }
                totalLength = totalLength + file.getLength();
            }
            return totalLength;
        }

        public Object getOpaqueData() {
            for (UploadedFile file : this._uploadedFileChunkList) {
                if (file.getLength() != -1L) continue;
                return file.getOpaqueData();
            }
            return null;
        }

        public Map<String, Object> getProperties() {
            UploadedFile file;
            if (this._uploadedFileChunkList.size() > 0 && (file = this._uploadedFileChunkList.get(0)) instanceof ExtendedUploadedFile) {
                return ((ExtendedUploadedFile)file).getProperties();
            }
            return Collections.emptyMap();
        }

        public InputStream getInputStream() throws IOException {
            ArrayList<InputStream> inputSteamList = new ArrayList<InputStream>(this._uploadedFileChunkList.size());
            for (UploadedFile uploadedFileChunk : this._uploadedFileChunkList) {
                inputSteamList.add(uploadedFileChunk.getInputStream());
            }
            return new SequenceInputStream(Collections.enumeration(inputSteamList));
        }

        public void dispose() {
            for (UploadedFile uploadedFileChunk : this._uploadedFileChunkList) {
                try {
                    uploadedFileChunk.dispose();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final class TempUploadedFile
    extends ExtendedUploadedFile {
        private MultipartFormItem _item;
        private String _filename = null;
        private Map<String, Object> _properties = new HashMap<String, Object>();

        public TempUploadedFile(String filename, MultipartFormItem item, Map<String, Object> properties) {
            this._filename = filename;
            this._item = item;
            if (properties != null) {
                this._properties = properties;
            }
            assert (properties != null);
            assert (item.getValue() == null);
        }

        public String getFilename() {
            return this._filename != null ? this._filename : this._item.getFilename();
        }

        public String getContentType() {
            return this._item.getContentType();
        }

        public long getLength() {
            return -1L;
        }

        public Object getOpaqueData() {
            return null;
        }

        public Map<String, Object> getProperties() {
            return this._properties;
        }

        public InputStream getInputStream() throws IOException {
            return this._item.getInputStream();
        }

        public void dispose() {
            throw new UnsupportedOperationException();
        }
    }

    @ExcludeFromManagedRequestScope
    private static class AppliedClass {
        public static final AppliedClass APPLIED = new AppliedClass();

        private AppliedClass() {
        }
    }
}

