/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.beans.IntrospectionException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ScalarDataModel;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.ChildPropertyTreeModel;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.MenuModel;
import org.apache.myfaces.trinidad.model.RowKeyIndex;
import org.apache.myfaces.trinidad.model.SortableModel;
import org.apache.myfaces.trinidad.model.TreeModel;
import org.apache.myfaces.trinidad.model.ViewIdPropertyMenuModel;

public final class ModelUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ModelUtils.class);

    public static Iterator<Object> getRowKeyIterator(final CollectionModel model) {
        Iterator<Object> iter = new Iterator<Object>(){
            private Object _next = Boolean.TRUE;
            private int _rowIndex = 0;

            @Override
            public boolean hasNext() {
                return this._next != null;
            }

            @Override
            public Object next() {
                if (this._next == null) {
                    throw new NoSuchElementException();
                }
                Object value = this._next;
                this._next = this._next();
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object _next() {
                int oldIndex = model.getRowIndex();
                try {
                    model.setRowIndex(this._rowIndex++);
                    if (model.isRowAvailable()) {
                        Object object = model.getRowKey();
                        return object;
                    }
                }
                finally {
                    model.setRowIndex(oldIndex);
                }
                return null;
            }
        };
        iter.next();
        return iter;
    }

    public static int getRowCount(RowKeyIndex model) {
        int rowCount = model.getRowCount();
        if (rowCount >= 0) {
            return rowCount;
        }
        int lowerBound = 0;
        int upperBound = 100;
        model.setRowIndex(upperBound);
        while (model.isRowAvailable()) {
            lowerBound = upperBound;
            model.setRowIndex(upperBound <<= 1);
        }
        return ModelUtils.findLastIndex(model, lowerBound, upperBound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findLastIndex(RowKeyIndex table, int startIndex, int endIndex) {
        int rowCount = table.getRowCount();
        if (rowCount >= 0 && rowCount < endIndex) {
            endIndex = rowCount;
        }
        if (table.isRowAvailable(endIndex - 1)) {
            return endIndex;
        }
        int old = table.getRowIndex();
        try {
            while (startIndex < endIndex) {
                int middle = (startIndex + endIndex) / 2;
                assert (middle != endIndex) : "something is grossly wrong with integer division";
                table.setRowIndex(middle);
                if (table.isRowAvailable()) {
                    startIndex = middle + 1;
                    continue;
                }
                endIndex = middle;
            }
            int n = endIndex;
            return n;
        }
        finally {
            table.setRowIndex(old);
        }
    }

    public static TreeModel toTreeModel(Object value) {
        if (value instanceof TreeModel) {
            return (TreeModel)value;
        }
        return new ChildPropertyTreeModel(value, null);
    }

    public static MenuModel toMenuModel(Object value) {
        if (value instanceof MenuModel) {
            return (MenuModel)value;
        }
        try {
            return new ViewIdPropertyMenuModel(value, null);
        }
        catch (IntrospectionException e) {
            IllegalArgumentException re = new IllegalArgumentException(_LOG.getMessage("CANNOT_CONVERT_INTO_MENUMODEL", value));
            re.initCause(e);
            throw re;
        }
    }

    public static CollectionModel toCollectionModel(Object value) {
        if (value instanceof CollectionModel) {
            return (CollectionModel)value;
        }
        return new SortableModel(value);
    }

    public static DataModel toDataModel(Object value) {
        if (value instanceof DataModel) {
            return (DataModel)value;
        }
        if (value instanceof Object[]) {
            return new ArrayDataModel((Object[])value);
        }
        if (value == null) {
            return new ListDataModel(Collections.emptyList());
        }
        if (value instanceof List) {
            return new ListDataModel((List)value);
        }
        return new ScalarDataModel(value);
    }

    private ModelUtils() {
    }
}

