/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.bean.PropertyMap;
import org.apache.myfaces.trinidad.bean.util.PropertyHashMap;
import org.apache.myfaces.trinidad.bean.util.StateUtils;

public class FlaggedPropertyMap
extends AbstractMap<PropertyKey, Object>
implements PropertyMap {
    private PropertyMap _map;
    private long _flags;
    private boolean _useStateHolder;
    private FacesBean.Type _type;

    @Override
    public boolean containsKey(Object key) {
        PropertyKey pKey = (PropertyKey)key;
        int index = pKey.getIndex();
        if (index >= 0 && index < 64) {
            return (this._flags & 1L << index) == 0L;
        }
        PropertyMap map = this.getPropertyMap(false);
        return map != null ? map.containsKey(pKey) : false;
    }

    @Override
    public Object get(Object key) {
        PropertyKey pKey = (PropertyKey)key;
        int index = pKey.getIndex();
        if (index >= 0 && index < 64 && (this._flags & 1L << index) == 0L) {
            return null;
        }
        PropertyMap map = this.getPropertyMap(false);
        return map != null ? map.get(key) : null;
    }

    @Override
    public Object put(PropertyKey key, Object value) {
        int index = key.getIndex();
        if (index >= 0 && index < 64) {
            this._flags |= 1L << index;
        }
        PropertyMap map = this.getPropertyMap(true);
        return map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        PropertyMap map;
        PropertyKey pKey = (PropertyKey)key;
        int index = pKey.getIndex();
        if (index >= 0 && index < 64) {
            long propertyMask = 1L << index;
            if ((this._flags & propertyMask) == 0L) {
                return null;
            }
            this._flags &= propertyMask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (map = this.getPropertyMap(false)) != null ? map.remove(key) : null;
    }

    @Override
    public void putAll(Map<? extends PropertyKey, ? extends Object> t) {
        for (PropertyKey propertyKey : t.keySet()) {
            int index = propertyKey.getIndex();
            if (index < 0 || index >= 64) continue;
            long propertyMask = 1L << index;
            this._flags |= propertyMask;
        }
        PropertyMap map = this.getPropertyMap(true);
        map.putAll(t);
    }

    @Override
    public Set<Map.Entry<PropertyKey, Object>> entrySet() {
        PropertyMap map = this.getPropertyMap(false);
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        return map.entrySet();
    }

    @Override
    public Set<PropertyKey> keySet() {
        PropertyMap map = this.getPropertyMap(false);
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    @Override
    public Collection<Object> values() {
        PropertyMap map = this.getPropertyMap(false);
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        return map.values();
    }

    @Override
    public void markInitialState() {
        PropertyMap map = this.getPropertyMap(false);
        if (map != null) {
            map.markInitialState();
        }
    }

    @Override
    public void clearInitialState() {
        PropertyMap map = this.getPropertyMap(false);
        if (map != null) {
            map.clearInitialState();
        }
    }

    @Override
    public boolean initialStateMarked() {
        PropertyMap map = this.getPropertyMap(false);
        if (map != null) {
            return map.initialStateMarked();
        }
        return false;
    }

    @Override
    public Object saveState(FacesContext context) {
        PropertyMap map = this.getPropertyMap(false);
        if (map != null) {
            return map.saveState(context);
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, FacesBean.Type type, Object state) {
        StateUtils.restoreState(this, context, type, state, this.getUseStateHolder());
    }

    public boolean getUseStateHolder() {
        return this._useStateHolder;
    }

    public void setUseStateHolder(boolean useStateHolder) {
        this._useStateHolder = useStateHolder;
    }

    public void setType(FacesBean.Type type) {
        this._type = type;
    }

    protected FacesBean.Type getType() {
        return this._type;
    }

    protected PropertyMap getPropertyMap(boolean createIfNull) {
        PropertyMap map = this._map;
        if (map == null && createIfNull) {
            map = this._map = this.createMap();
        }
        return map;
    }

    protected PropertyMap createMap() {
        PropertyHashMap map = new PropertyHashMap();
        map.setUseStateHolder(this.getUseStateHolder());
        map.setType(this._type);
        return map;
    }
}

