/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.ClassParserFactory;
import org.apache.myfaces.trinidadinternal.share.xml.ParserManager;
import org.apache.myfaces.trinidadinternal.style.xml.parse.ColorNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludePropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

public class StyleSheetDocumentUtils {
    private static ParserManager _sDefaultParserManager;
    private static final TrinidadLogger _LOG;

    public static StyleSheetDocument mergeStyleSheetDocuments(StyleSheetDocument document1, StyleSheetDocument document2) {
        if (document1 == null) {
            return document2;
        }
        if (document2 == null) {
            return document1;
        }
        String documentVersion = StyleSheetDocumentUtils._mergeDocumentVersions(document1, document2);
        long documentTimestamp = Math.max(document1.getDocumentTimestamp(), document2.getDocumentTimestamp());
        ArrayList<StyleSheetNode> styleSheetsList = new ArrayList<StyleSheetNode>();
        StyleSheetDocumentUtils._addStyleSheets(styleSheetsList, document1);
        StyleSheetDocumentUtils._addStyleSheets(styleSheetsList, document2);
        int styleSheetsCount = styleSheetsList.size();
        StyleSheetNode[] styleSheetsArray = new StyleSheetNode[styleSheetsCount];
        styleSheetsList.toArray(styleSheetsArray);
        return new StyleSheetDocument(styleSheetsArray, documentVersion, documentTimestamp);
    }

    private static void _addStyleSheets(List<StyleSheetNode> styleSheets, StyleSheetDocument document) {
        Iterator<StyleSheetNode> e = document.getStyleSheets();
        while (e.hasNext()) {
            styleSheets.add(e.next());
        }
    }

    private static String _mergeDocumentVersions(StyleSheetDocument document1, StyleSheetDocument document2) {
        assert (document1 != null && document2 != null);
        String version1 = document1.getDocumentVersion();
        String version2 = document2.getDocumentVersion();
        if (version1 == null) {
            return version2;
        }
        if (version2 == null) {
            return version1;
        }
        return version1 + version2;
    }

    private static ParserManager _getDefaultParserManager() {
        if (_sDefaultParserManager == null) {
            ParserManager manager = new ParserManager();
            StyleSheetDocumentUtils._registerFactory(manager, StyleSheetDocument.class, "StyleSheetDocument");
            StyleSheetDocumentUtils._registerFactory(manager, StyleSheetNode.class, "StyleSheetNode");
            StyleSheetDocumentUtils._registerFactory(manager, StyleNode.class, "StyleNode");
            StyleSheetDocumentUtils._registerFactory(manager, PropertyNode.class, "PropertyNode");
            StyleSheetDocumentUtils._registerFactory(manager, ColorNode.class, "ColorNode");
            StyleSheetDocumentUtils._registerFactory(manager, IncludePropertyNode.class, "IncludePropertyNode");
            StyleSheetDocumentUtils._registerFactory(manager, String.class, "ValueNode");
            _sDefaultParserManager = manager;
        }
        return _sDefaultParserManager;
    }

    private static void _registerFactory(ParserManager manager, Class<?> expectedType, String baseName) {
        String className = "org.apache.myfaces.trinidadinternal.style.xml.parse." + baseName + "Parser";
        ClassParserFactory factory = new ClassParserFactory(className);
        manager.registerFactory(expectedType, "http://myfaces.apache.org/uix/style", factory);
    }

    static {
        _LOG = TrinidadLogger.createTrinidadLogger(StyleSheetDocumentUtils.class);
    }
}

