/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.MessageFactory;
import org.apache.myfaces.trinidadinternal.convert.ConverterUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.CoreFormData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.EditableValueRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormInputRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.uix.SelectItemSupport;

public abstract class SimpleSelectManyRenderer
extends FormInputRenderer {
    private PropertyKey _valuePassThruKey;
    private static final int[] _EMPTY_INT_ARRAY = new int[0];
    private static final String[] _EMPTY_ARRAY = new String[0];
    private static final Object _ALREADY_FOUND = new Object();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(EditableValueRenderer.class);

    public SimpleSelectManyRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._valuePassThruKey = type.findKey("valuePassThru");
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        boolean valuePassThru;
        assert (submittedValue != null);
        String[] values = (String[])submittedValue;
        if (values.length == 0) {
            return null;
        }
        FacesBean bean = this.getFacesBean(component);
        Converter converter = this.getConverter(component, bean);
        if (converter == null) {
            converter = this.getDefaultConverter(context, component, bean);
        }
        Class modelClass = null;
        ValueExpression expression = this.getValueExpression(component, bean);
        if (expression != null) {
            modelClass = expression.getType(context.getELContext());
        }
        if (!(valuePassThru = this.getValuePassThru(component, bean))) {
            return this._convertIndexedSubmittedValue(context, component, converter, values, modelClass);
        }
        return SimpleSelectManyRenderer._convertSubmittedValue(context, component, converter, values, modelClass);
    }

    @Override
    protected Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        this.detectAutoSubmit(context, component, clientId);
        Object o = context.getExternalContext().getRequestParameterValuesMap().get(clientId);
        if (o == null) {
            o = _EMPTY_ARRAY;
        }
        return o;
    }

    @Override
    protected Converter getDefaultConverter(FacesContext context, UIComponent copmonent, FacesBean bean) {
        ValueExpression expression = this.getValueExpression(copmonent, bean);
        if (expression == null) {
            return null;
        }
        Class type = expression.getType(context.getELContext());
        if (type == null || type.isAssignableFrom(List.class)) {
            return null;
        }
        if (type.isArray()) {
            Class<?> itemClass = type.getComponentType();
            return ConverterUtils.createConverter(context, itemClass);
        }
        SimpleSelectManyRenderer._throwUnsupportedModelType(context, type, null);
        return null;
    }

    private static Object _convertSubmittedValue(FacesContext context, UIComponent component, Converter converter, String[] values, Class<?> modelClass) throws ConverterException {
        if (modelClass == null || modelClass.isAssignableFrom(List.class)) {
            if (converter == null) {
                return Arrays.asList(values);
            }
            ArrayList<Object> newList = new ArrayList<Object>(values.length);
            for (int i = 0; i < values.length; ++i) {
                newList.add(converter.getAsObject(context, component, values[i]));
            }
            return newList;
        }
        if (modelClass.isArray()) {
            if (converter == null) {
                return values;
            }
            Class<?> itemClass = modelClass.getComponentType();
            Object convertedArray = Array.newInstance(itemClass, values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(convertedArray, i, converter.getAsObject(context, component, values[i]));
            }
            return convertedArray;
        }
        SimpleSelectManyRenderer._throwUnsupportedModelType(context, modelClass, component);
        return null;
    }

    private Object _convertIndexedSubmittedValue(FacesContext context, UIComponent component, Converter converter, String[] values, Class<?> modelClass) throws ConverterException {
        Object objectArray;
        ArrayList<Object> objectList;
        boolean isArray;
        List<SelectItem> selectItems = this.getSelectItems(component, converter, true);
        if (selectItems == null || selectItems.isEmpty()) {
            SimpleSelectManyRenderer._throwConversionError(context, component);
        }
        boolean isList = modelClass == null || modelClass.isAssignableFrom(List.class);
        boolean bl = isArray = modelClass != null && modelClass.isArray();
        if (!isList && !isArray) {
            SimpleSelectManyRenderer._throwUnsupportedModelType(context, modelClass, component);
        }
        if (isList) {
            objectList = new ArrayList<Object>(values.length);
            objectArray = null;
        } else {
            objectList = null;
            Class<?> itemClass = modelClass.getComponentType();
            objectArray = Array.newInstance(itemClass, values.length);
        }
        for (int i = 0; i < values.length; ++i) {
            try {
                int index = Integer.parseInt(values[i]);
                if (-1 < index && selectItems.size() > index) {
                    SelectItem item = selectItems.get(index);
                    if (item == null) continue;
                    if (isList) {
                        objectList.add(item.getValue());
                        continue;
                    }
                    Array.set(objectArray, i, item.getValue());
                    continue;
                }
                SimpleSelectManyRenderer._throwConversionError(context, component);
                continue;
            }
            catch (NumberFormatException ne) {
                SimpleSelectManyRenderer._throwConversionError(context, component);
            }
        }
        if (isList) {
            return objectList;
        }
        return objectArray;
    }

    protected List<SelectItem> getSelectItems(UIComponent component, Converter converter) {
        return this.getSelectItems(component, converter, false);
    }

    protected List<SelectItem> getSelectItems(UIComponent component, Converter converter, boolean filteredItems) {
        return SelectItemSupport.getSelectItems(component, converter, filteredItems);
    }

    @Override
    protected void encodeAllAsElement(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        FormData fData;
        Converter converter = this.getConverter(component, bean);
        if (converter == null) {
            converter = this.getDefaultConverter(context, component, bean);
        }
        boolean valuePassThru = this.getValuePassThru(component, bean);
        if (this.isAutoSubmit(component, bean)) {
            AutoSubmitUtils.writeDependencies(context, rc);
        }
        if ((fData = rc.getFormData()) != null) {
            ((CoreFormData)fData).addOnSubmitConverterValidators(component, (Converter)(valuePassThru ? converter : null), valuePassThru ? this.getValidators(component, bean) : null, this.getClientId(context, component), this.isImmediate(component, bean), this.getRequired(component, bean), this.getRequiredMessageKey());
        }
        List<SelectItem> selectItems = this.getSelectItems(component, converter);
        int[] selectedIndices = this.getSelectedIndices(context, component, bean, selectItems, converter, valuePassThru);
        ResponseWriter writer = context.getResponseWriter();
        boolean simple = this.getSimple(component, bean);
        if (simple) {
            writer.startElement("span", component);
            this.renderRootDomElementStyles(context, rc, component, bean);
        }
        this.encodeElementContent(context, rc, component, bean, selectItems, selectedIndices, converter, valuePassThru);
        if (this.isHiddenLabelRequired(rc)) {
            this.renderShortDescAsHiddenLabel(context, rc, component, bean);
        }
        if (simple) {
            writer.endElement("span");
        }
    }

    protected abstract void encodeElementContent(FacesContext var1, RenderingContext var2, UIComponent var3, FacesBean var4, List<SelectItem> var5, int[] var6, Converter var7, boolean var8) throws IOException;

    @Override
    protected void renderNonElementContent(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (this.getValue(component, bean) == null) {
            return;
        }
        Converter converter = this.getConverter(component, bean);
        if (converter == null) {
            converter = this.getDefaultConverter(context, component, bean);
        }
        boolean valuePassThru = this.getValuePassThru(component, bean);
        List<SelectItem> selectItems = this.getSelectItems(component, converter);
        int[] selectedIndices = this.getSelectedIndices(context, component, bean, selectItems, converter, valuePassThru);
        ResponseWriter rw = context.getResponseWriter();
        for (int i = 0; i < selectedIndices.length; ++i) {
            if (i > 0) {
                this.renderBetweenNonElements(context, rc, component, bean);
            }
            SelectItem item = selectItems.get(selectedIndices[i]);
            rw.writeText((Object)item.getLabel(), null);
        }
    }

    protected void renderBetweenNonElements(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("br", component);
        rw.endElement("br");
    }

    @Override
    protected String getRequiredMessageKey() {
        return "org.apache.myfaces.trinidad.UIXSelectMany.REQUIRED";
    }

    protected boolean getValuePassThru(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._valuePassThruKey);
        if (o == null) {
            o = this._valuePassThruKey.getDefault();
        }
        assert (o != null);
        return Boolean.TRUE.equals(o);
    }

    protected boolean isReorderable() {
        return false;
    }

    protected int[] getSelectedIndices(FacesContext context, UIComponent component, FacesBean bean, List<SelectItem> selectItems, Converter converter, boolean valuePassThru) {
        ArrayList<Object> valueList;
        int i;
        ArrayList<Object> value;
        List<SelectItem> selectItemList = this.flatItemList(selectItems);
        ArrayList<Object> submittedValue = this.getSubmittedValue(component, bean);
        if (submittedValue != null && !valuePassThru) {
            String[] values = (String[])submittedValue;
            if (values.length == 0) {
                return _EMPTY_INT_ARRAY;
            }
            int[] indices = new int[values.length];
            for (int i2 = 0; i2 < values.length; ++i2) {
                indices[i2] = SimpleSelectOneRenderer.__getIndex(context, values[i2], selectItemList);
            }
            if (!this.isReorderable()) {
                Arrays.sort(indices);
            }
            return indices;
        }
        if (submittedValue == null) {
            value = this.getValue(component, bean);
        } else if (converter == null) {
            value = submittedValue;
        } else {
            String[] values = (String[])submittedValue;
            ArrayList<Object> valuesList = new ArrayList<Object>(values.length);
            for (i = 0; i < values.length; ++i) {
                valuesList.add(converter.getAsObject(context, component, values[i]));
            }
            value = valuesList;
        }
        if (value == null) {
            return _EMPTY_INT_ARRAY;
        }
        if (value instanceof List) {
            valueList = new ArrayList<Object>((List)value);
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            valueList = new ArrayList(length);
            for (i = 0; i < length; ++i) {
                valueList.add(Array.get(value, i));
            }
        } else {
            valueList = new ArrayList(1);
            valueList.add(value);
        }
        int valueListSize = valueList.size();
        int[] indices = new int[valueListSize];
        for (int i3 = 0; i3 < valueListSize; ++i3) {
            indices[i3] = -1;
        }
        int itemCount = selectItemList.size();
        int foundCount = 0;
        for (int i4 = 0; i4 < itemCount; ++i4) {
            int index;
            SelectItem item = selectItemList.get(i4);
            if (item == null || (index = this.calcIndex(item, valueList)) < 0) continue;
            valueList.set(index, _ALREADY_FOUND);
            indices[index] = i4;
            ++foundCount;
        }
        if (foundCount < valueListSize && _LOG.isWarning()) {
            _LOG.warning("SOME_ENTRIES_NOT_FOUND_IN_SELECTITEMS", new Object[]{component, valueList});
        }
        if (!this.isReorderable()) {
            Arrays.sort(indices);
        }
        Integer[] indicesObj = new Integer[indices.length];
        for (int foo = 0; foo < indices.length; ++foo) {
            indicesObj[foo] = indices[foo];
        }
        return indices;
    }

    private List<SelectItem> flatItemList(List<SelectItem> selectItems) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (SelectItem item : selectItems) {
            List<SelectItem> subresult = this.collectItems(item);
            for (SelectItem subItem : subresult) {
                result.add(subItem);
            }
        }
        return result;
    }

    private List<SelectItem> collectItems(SelectItem item) {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        if (item instanceof SelectItemGroup) {
            for (SelectItem subitem : ((SelectItemGroup)item).getSelectItems()) {
                List<SelectItem> subresult = this.collectItems(subitem);
                for (SelectItem subItem : subresult) {
                    result.add(subItem);
                }
            }
        } else {
            result.add(item);
        }
        return result;
    }

    private int calcIndex(SelectItem item, List<Object> valueList) {
        if (item instanceof SelectItemGroup) {
            SelectItem subItem;
            int index = -1;
            SelectItem[] arr$ = ((SelectItemGroup)item).getSelectItems();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (index = this.calcIndex(subItem = arr$[i$], valueList)) < 0; ++i$) {
            }
            return index;
        }
        return valueList.indexOf(item.getValue());
    }

    private static void _throwConversionError(FacesContext context, UIComponent component) throws ConverterException {
        throw new ConverterException(MessageFactory.getMessage((FacesContext)context, (String)"org.apache.myfaces.trinidad.UIXEditableValue.CONVERSION", (UIComponent)component));
    }

    private static void _throwUnsupportedModelType(FacesContext context, Class<?> type, UIComponent component) throws ConverterException {
        throw new ConverterException(MessageFactory.getMessage((FacesContext)context, (String)"org.apache.myfaces.trinidad.UIXSelectMany.UNSUPPORTED_MODEL_TYPE", (Object[])new Object[]{type}, (UIComponent)component));
    }
}

