/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.facelets;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

final class StringArrayPropertyTagRule
extends MetaRule {
    public static final MetaRule Instance = new StringArrayPropertyTagRule();
    private static final Class<? extends String[]> _STRING_ARRAY_TYPE = new String[0].getClass();

    StringArrayPropertyTagRule() {
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method m;
        if (meta.getPropertyType(name) == _STRING_ARRAY_TYPE && attribute.isLiteral() && (m = meta.getWriteMethod(name)) != null) {
            return new LiteralPropertyMetadata(m, attribute);
        }
        return null;
    }

    private static List<String> _coerceToStringArray(String str) {
        if (str == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(str);
        while (tokens.hasMoreTokens()) {
            list.add(tokens.nextToken());
        }
        return list;
    }

    private static class LiteralPropertyMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private List<String> _itemList;

        public LiteralPropertyMetadata(Method method, TagAttribute attribute) {
            this._method = method;
            this._attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            if (this._itemList == null) {
                this._itemList = StringArrayPropertyTagRule._coerceToStringArray(this._attribute.getValue());
            }
            try {
                Object[] params = new Object[]{this._itemList.isEmpty() ? null : this._itemList.toArray(new String[this._itemList.size()])};
                this._method.invoke(instance, params);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }
}

