/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.trinidad.config.RegionConfig;
import org.apache.myfaces.trinidad.config.RegionManager;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.ui.data.bind.ConvertBoundValue;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class RegionMetadata
extends RegionManager {
    private Map<String, RegionConfig> _map = Collections.emptyMap();
    private static final int _STATE_INIT = 0;
    private static final int _STATE_SKIP = 10;
    private static final int _STATE_COMP = 20;
    private static final int _STATE_COMP_TYPE = 30;
    private static final int _STATE_COMP_EXT = 40;
    private static final int _STATE_REGION_DEF = 50;
    private static final int _STATE_ATTR = 60;
    private static final int _STATE_ATTR_NAME = 70;
    private static final int _STATE_ATTR_CLASS = 80;
    private static final int _STATE_ATTR_EXT = 90;
    private static final int _STATE_FACES_CONFIG = 100;
    private static final int _STATE_DEFAULT_VALUE = 110;
    private static final int _STATE_REQUIRED = 120;
    private static final String _REGION_DEF_JSP_TAG = "region-jsp-ui-def";
    private static final String _COMP_TYPE_TAG = "component-type";
    private static final String _CONFIG_FILE = "META-INF/region-metadata.xml";
    private static final String _CONFIG_FILE_2 = "/WEB-INF/region-metadata.xml";
    static final String __CONFIG_FILE_OTHER = "/META-INF/region-metadata.xml";
    private static final SAXParserFactory _SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final TrinidadLogger _LOG;
    private static final String _KEY;

    private RegionMetadata() {
    }

    public RegionConfig getRegionConfig(String regionType) {
        return this._map.get(regionType);
    }

    public Map<String, RegionConfig> getRegionConfigs() {
        return Collections.unmodifiableMap(this._map);
    }

    public static synchronized RegionMetadata getRegionMetadata(FacesContext context) {
        Map appMap = context.getExternalContext().getApplicationMap();
        RegionMetadata bean = (RegionMetadata)((Object)appMap.get(_KEY));
        if (bean == null) {
            ServletContext servletContext;
            InputStream in;
            bean = new RegionMetadata();
            appMap.put(_KEY, bean);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            RegionMetadata._readAllRegionMDFiles(loader, bean, __CONFIG_FILE_OTHER);
            RegionMetadata._readAllRegionMDFiles(loader, bean, _CONFIG_FILE);
            Object sContext = context.getExternalContext().getContext();
            if (sContext instanceof ServletContext && (in = (servletContext = (ServletContext)sContext).getResourceAsStream(_CONFIG_FILE_2)) != null) {
                RegionMetadata._readRegionMetadata(bean, in, _CONFIG_FILE_2);
                try {
                    in.close();
                }
                catch (IOException e) {
                    _LOG.severe("ERR_CLOSING_FILE", (Object)_CONFIG_FILE_2);
                    _LOG.severe((Throwable)e);
                }
            }
        }
        return bean;
    }

    public static synchronized void invalidate(FacesContext context) {
        Map appMap = context.getExternalContext().getApplicationMap();
        appMap.remove(_KEY);
    }

    private static void _readAllRegionMDFiles(ClassLoader loader, RegionMetadata bean, String regionMDFile) {
        if (_LOG.isFinest()) {
            _LOG.finest("searching for region-metadata with resource:{0}", (Object)regionMDFile);
        }
        try {
            Enumeration<URL> files = loader.getResources(regionMDFile);
            while (files.hasMoreElements()) {
                URL url = files.nextElement();
                String publicId = url.toString();
                try {
                    InputStream in = url.openStream();
                    RegionMetadata._readRegionMetadata(bean, in, publicId);
                    in.close();
                }
                catch (IOException e) {
                    RegionMetadata._error(publicId, e);
                }
            }
        }
        catch (IOException e) {
            _LOG.warning("ERR_GET_REGION_METADATA_FILE", (Object)__CONFIG_FILE_OTHER);
            _LOG.warning((Throwable)e);
        }
    }

    private static void _error(String publicId, Throwable t) {
        _LOG.warning("ERR_READ_REGION_METADATA_FILE", (Object)publicId);
        _LOG.warning(t);
    }

    private static void _readRegionMetadata(RegionMetadata bean, InputStream in, String publicId) {
        if (_LOG.isFiner()) {
            _LOG.finer("Loading region-metadata from file:{0}", (Object)publicId);
        }
        try {
            InputSource input = new InputSource();
            input.setByteStream(in);
            input.setPublicId(publicId);
            Handler handler = new Handler(bean);
            _SAX_PARSER_FACTORY.newSAXParser().parse(input, (DefaultHandler)handler);
        }
        catch (IOException ioe) {
            RegionMetadata._error(publicId, ioe);
        }
        catch (ParserConfigurationException pce) {
            RegionMetadata._error(publicId, pce);
        }
        catch (SAXException saxe) {
            RegionMetadata._error(publicId, saxe);
        }
    }

    private void _put(String componentType, ComponentMetaData comp) {
        RegionConfig old;
        Map comparant;
        if (_LOG.isFine()) {
            _LOG.fine("Associating jspUri {0} with componentType:{1}", new Object[]{comp.getJspUIDef(), componentType});
        }
        if (this._map == (comparant = Collections.emptyMap())) {
            this._map = new HashMap<String, RegionConfig>(5);
        }
        if ((old = this._map.put(componentType, comp)) != null) {
            _LOG.warning("REPLACE_COMPONENTTYPE_JSPURI", new Object[]{old.getJspUIDef(), comp.getJspUIDef(), componentType});
        }
    }

    static {
        _SAX_PARSER_FACTORY.setNamespaceAware(true);
        _LOG = TrinidadLogger.createTrinidadLogger(RegionMetadata.class);
        _KEY = RegionMetadata.class.getName();
    }

    public static final class ComponentMetaData
    extends RegionConfig {
        private String _jsp;
        private String _regionType;
        private List<AttributeMetaData> _attrs = Collections.emptyList();

        public String getDescription() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getComponentType() {
            return this._regionType;
        }

        public String getJspUIDef() {
            return this._jsp;
        }

        public List<AttributeMetaData> getAttributes() {
            return this._attrs;
        }

        private void _addAttribute(AttributeMetaData attr) {
            List comparant = Collections.emptyList();
            if (this._attrs == comparant) {
                this._attrs = new ArrayList<AttributeMetaData>(5);
            }
            this._attrs.add(attr);
        }

        public void _trim() {
            if (this._attrs instanceof ArrayList) {
                ((ArrayList)this._attrs).trimToSize();
            }
        }
    }

    public static final class AttributeMetaData {
        private String _default;
        private String _name;
        private Class<?> _class;
        private boolean _required = false;

        public String getAttrName() {
            return this._name;
        }

        public Class<?> getAttrClass() {
            return this._class;
        }

        public String getDefaultValue() {
            return this._default;
        }

        public boolean isRequired() {
            return this._required;
        }
    }

    private static class Handler
    extends DefaultHandler {
        private StringBuffer _currentText = new StringBuffer(50);
        private String _skipElement = null;
        private int _returnState = 0;
        private int _state = 0;
        private AttributeMetaData _attr = null;
        private ComponentMetaData _comp = null;
        private final RegionMetadata _bean;
        private Locator _loc = null;

        public Handler(RegionMetadata bean) {
            this._bean = bean;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this._loc = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            switch (this._state) {
                case 0: {
                    if (this._changeState(localName, "faces-config", 100)) break;
                    this._unexpected(localName);
                    break;
                }
                case 100: {
                    if (this._changeState(localName, "component", 20)) {
                        assert (this._comp == null);
                        this._comp = new ComponentMetaData();
                        break;
                    }
                    this._skip(localName);
                    break;
                }
                case 20: {
                    if (this._changeState(localName, "attribute", 60)) {
                        assert (this._attr == null);
                        this._attr = new AttributeMetaData();
                        break;
                    }
                    if (this._changeState(localName, RegionMetadata._COMP_TYPE_TAG, 30) || this._changeState(localName, "component-extension", 40)) break;
                    this._skip(localName);
                    break;
                }
                case 30: 
                case 50: 
                case 70: 
                case 80: 
                case 110: 
                case 120: {
                    this._unexpected(localName);
                    break;
                }
                case 40: {
                    if (this._changeState(localName, RegionMetadata._REGION_DEF_JSP_TAG, 50)) break;
                    this._skip(localName);
                    break;
                }
                case 60: {
                    if (this._changeState(localName, "attribute-name", 70) || this._changeState(localName, "attribute-class", 80) || this._changeState(localName, "attribute-extension", 90) || this._changeState(localName, "default-value", 110)) break;
                    this._skip(localName);
                    break;
                }
                case 90: {
                    this._changeState(localName, "required", 120);
                    break;
                }
                case 10: {
                    if (!localName.equals(this._skipElement)) break;
                    throw new UnsupportedOperationException(_LOG.getMessage("REGION_METADATA_CANNOT_NEST", (Object)localName));
                }
            }
        }

        private boolean _changeState(String localName, String tag, int newState) {
            if (tag.equals(localName)) {
                this._state = newState;
                return true;
            }
            return false;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            switch (this._state) {
                case 30: 
                case 50: 
                case 70: 
                case 80: 
                case 110: 
                case 120: {
                    this._currentText.append(ch, start, length);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            switch (this._state) {
                case 10: {
                    if (!localName.equals(this._skipElement)) break;
                    this._skipElement = null;
                    this._state = this._returnState;
                    break;
                }
                case 30: {
                    this._comp._regionType = this._getCurrentText(20);
                    break;
                }
                case 50: {
                    this._comp._jsp = this._getCurrentText(40);
                    break;
                }
                case 40: {
                    this._state = 20;
                    break;
                }
                case 20: {
                    this._addComponentMetadata();
                    this._comp = null;
                    this._state = 100;
                    break;
                }
                case 60: {
                    this._comp._addAttribute(this._attr);
                    this._attr = null;
                    this._state = 20;
                    break;
                }
                case 120: {
                    this._attr._required = this._getCurrentText().equals("true");
                    this._state = 90;
                    break;
                }
                case 80: {
                    String javaType = this._getCurrentText(60);
                    this._attr._class = this._getClass(javaType);
                    break;
                }
                case 70: {
                    this._attr._name = this._getCurrentText(60);
                    break;
                }
                case 110: {
                    this._attr._default = this._getCurrentText(60);
                    break;
                }
                case 90: {
                    this._state = 60;
                }
            }
        }

        private void _addComponentMetadata() {
            if (this._comp._regionType == null) {
                this._missing(RegionMetadata._COMP_TYPE_TAG);
                return;
            }
            if (this._comp.getJspUIDef() == null) {
                this._missing(RegionMetadata._REGION_DEF_JSP_TAG);
                return;
            }
            this._bean._put(this._comp._regionType, this._comp);
            this._comp._trim();
        }

        private Class<?> _getClass(String javaType) {
            String className = ConvertBoundValue.getClassName(javaType);
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                this._log(e);
                return Object.class;
            }
        }

        private String _getCurrentText(int newState) {
            this._state = newState;
            return this._getCurrentText();
        }

        private String _getCurrentText() {
            String result = this._currentText.toString();
            result = result.trim();
            this._currentText.setLength(0);
            return result;
        }

        private void _unexpected(String localName) {
            if (_LOG.isWarning()) {
                _LOG.warning("UNKNOWN_ELEMENT", new Object[]{localName, this._getLocation()});
            }
            this._skip(localName);
        }

        private void _missing(String tag) {
            _LOG.severe("MISSING_AT", new Object[]{tag, this._getLocation()});
        }

        private void _log(Throwable t) {
            _LOG.severe("EXCEPTION_AT", (Object)this._getLocation());
            _LOG.severe(t);
        }

        private String _getLocation() {
            return "line:" + this._loc.getLineNumber() + " column:" + this._loc.getColumnNumber() + " file:" + this._loc.getPublicId();
        }

        private void _skip(String localName) {
            this._skipElement = localName;
            this._returnState = this._state;
            this._state = 10;
        }
    }
}

