/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.facelets;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TimeZone;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

class TimezonePropertyTagRule
extends MetaRule {
    static TimezonePropertyTagRule Instance = new TimezonePropertyTagRule();
    private static final Class<? extends TimeZone> _TIMEZONE_TYPE = TimeZone.class;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TimezonePropertyTagRule.class);

    TimezonePropertyTagRule() {
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method m;
        if (meta.getPropertyType(name) == _TIMEZONE_TYPE && attribute.isLiteral() && (m = meta.getWriteMethod(name)) != null) {
            return new LiteralPropertyMetadata(m, attribute);
        }
        return null;
    }

    private static class LiteralPropertyMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Object[] _params;

        public LiteralPropertyMetadata(Method method, TagAttribute attribute) {
            this._method = method;
            this._attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            if (this._params == null) {
                TimeZone tz = TimeZone.getTimeZone(this._attribute.getValue());
                this._params = new Object[]{tz};
            }
            try {
                this._method.invoke(instance, this._params);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }
}

