/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderKit;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.PPRResponseWriter;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.XmlResponseWriter;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;

public class PartialViewContextImpl
extends PartialViewContext {
    private ReqType _requestType;
    private Set<String> _executeIds;
    private Set<String> _renderIds;
    private FacesContext _context = null;
    private Boolean _partialRequest;
    private boolean _released;
    private Boolean _renderAll = null;
    private Boolean _executeAll = null;
    private static final String _RESPONSE_CONTENT_TYPE = "text/xml";
    private static final String _FACES_REQUEST = "Faces-Request";
    private static final String _PARTIAL_AJAX = "partial/ajax";
    private static final String _PARTIAL_PROCESS = "partial/process";
    private static final String _TRINIDAD_PPR = "Tr-PPR-Message";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PartialViewContextImpl.class);

    public PartialViewContextImpl(FacesContext context) {
        this._context = context;
        ExternalContext extContext = context.getExternalContext();
        this._requestType = ReqType.FULL;
        if (_PARTIAL_AJAX.equals(extContext.getRequestHeaderMap().get(_FACES_REQUEST))) {
            this._requestType = extContext.getRequestParameterMap().get(_TRINIDAD_PPR) != null ? ReqType.AJAX_LEGACY : ReqType.AJAX;
        } else if (CoreRenderKit.isLegacyPartialRequest(extContext)) {
            this._requestType = ReqType.LEGACY;
        }
    }

    public Collection<String> getExecuteIds() {
        this._assertNotReleased();
        if (this._executeIds == null) {
            UIComponent facet;
            UIViewRoot root;
            this._executeIds = this._getIds("javax.faces.partial.execute");
            if (!this._executeIds.isEmpty() && (root = this._context.getViewRoot()).getFacetCount() > 0 && (facet = root.getFacet("javax_faces_metadata")) != null) {
                this._executeIds.add(facet.getClientId(this._context));
            }
        }
        return this._executeIds;
    }

    public Collection<String> getRenderIds() {
        this._assertNotReleased();
        if (this._renderIds == null) {
            this._renderIds = this._getIds("javax.faces.partial.render");
        }
        return this._renderIds;
    }

    public boolean isAjaxRequest() {
        this._assertNotReleased();
        return this._requestType != ReqType.FULL;
    }

    public boolean isPartialRequest() {
        this._assertNotReleased();
        if (this._partialRequest == null) {
            this._partialRequest = this.isAjaxRequest() || _PARTIAL_PROCESS.equals(this._context.getExternalContext().getRequestHeaderMap().get(_FACES_REQUEST));
        }
        return this._partialRequest;
    }

    public boolean isExecuteAll() {
        this._assertNotReleased();
        if (this._executeAll == null) {
            if (this._requestType == ReqType.AJAX_LEGACY || this._requestType == ReqType.LEGACY) {
                this._executeAll = true;
            } else {
                String execute = (String)this._context.getExternalContext().getRequestParameterMap().get("javax.faces.partial.execute");
                this._executeAll = execute.equals("@all");
            }
        }
        return this._executeAll;
    }

    public boolean isRenderAll() {
        this._assertNotReleased();
        if (this._renderAll == null) {
            String render = (String)this._context.getExternalContext().getRequestParameterMap().get("javax.faces.partial.render");
            this._renderAll = "@all".equals(render);
        }
        return this._renderAll;
    }

    public void processPartial(PhaseId phaseId) {
        UIViewRoot viewRoot = this._context.getViewRoot();
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES || phaseId == PhaseId.PROCESS_VALIDATIONS || phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            this._processExecute(viewRoot, phaseId);
        } else if (phaseId == PhaseId.RENDER_RESPONSE) {
            this._processRender((UIComponent)viewRoot);
        }
    }

    public PartialResponseWriter getPartialResponseWriter() {
        ResponseWriter current = this._context.getResponseWriter();
        if (current != null && current instanceof PartialResponseWriter) {
            return (PartialResponseWriter)current;
        }
        if (current != null) {
            if (this._context.getCurrentPhaseId() == PhaseId.RENDER_RESPONSE) {
                _LOG.warning("getPartialResponseWriter() called during render_reponse. The returned writer is not integrated with PPRResponseWriter");
            }
            return new PartialResponseWriter(current);
        }
        ExternalContext extContext = this._context.getExternalContext();
        String encoding = "UTF-8";
        extContext.setResponseCharacterEncoding(encoding);
        Writer out = null;
        try {
            out = extContext.getResponseOutputWriter();
        }
        catch (IOException ioe) {
            _LOG.severe(ioe.toString(), (Throwable)ioe);
        }
        if (out != null) {
            Object responseWriter = null;
            RenderKit kit = this._context.getRenderKit();
            responseWriter = kit != null ? kit.createResponseWriter(out, _RESPONSE_CONTENT_TYPE, encoding) : new XmlResponseWriter(out, encoding);
            return new PartialResponseWriter(responseWriter);
        }
        return null;
    }

    public void setRenderAll(boolean renderAll) {
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this._partialRequest = isPartialRequest;
    }

    public void release() {
        this._executeIds = null;
        this._context = null;
        this._partialRequest = null;
        this._released = true;
        this._renderAll = null;
        this._renderIds = null;
    }

    private void _processExecute(UIViewRoot component, PhaseId phaseId) {
        Collection<String> executeIds = this.getExecuteIds();
        if (executeIds == null || executeIds.isEmpty()) {
            _LOG.warning("No execute Ids were supplied for the Ajax request");
            return;
        }
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)this._context, executeIds, EnumSet.of(VisitHint.SKIP_UNRENDERED, VisitHint.EXECUTE_LIFECYCLE));
        ProcessPhaseCallback visitCallback = new ProcessPhaseCallback(this._context, phaseId);
        component.visitTree(visitContext, (VisitCallback)visitCallback);
    }

    private void _processRender(UIComponent viewRoot) {
        ExternalContext extContext = this._context.getExternalContext();
        extContext.setResponseContentType(_RESPONSE_CONTENT_TYPE);
        extContext.addResponseHeader("Pragma", "no-cache");
        extContext.addResponseHeader("Cache-control", "no-cache");
        if (this.isRenderAll()) {
            this._renderAll(this._context, viewRoot);
            return;
        }
        ResponseWriter origResponseWriter = this._context.getResponseWriter();
        RenderingContext rc = RenderingContext.getCurrentInstance();
        assert (rc != null);
        boolean bufferScripts = this._requestType == ReqType.LEGACY || this._requestType == ReqType.AJAX_LEGACY;
        PPRResponseWriter pprWriter = new PPRResponseWriter(origResponseWriter, rc, bufferScripts);
        this._context.setResponseWriter((ResponseWriter)pprWriter);
        if (this._requestType == ReqType.AJAX) {
            this._addRenderIdsAsPartialTargets(rc);
            PartialPageUtils.forceOptimizedPPR(this._context);
        }
        try {
            pprWriter.startDocument();
            PartialViewContextImpl._renderChildren(this._context, viewRoot);
            if (!CoreRenderer.isPDA((RenderingContext)rc)) {
                String state = this._context.getApplication().getStateManager().getViewState(this._context);
                pprWriter.writeViewState(state);
            }
            pprWriter.endDocument();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            this._context.setResponseWriter(origResponseWriter);
        }
    }

    private void _renderAll(FacesContext context, UIComponent viewRoot) {
        ResponseWriter origResponseWriter = context.getResponseWriter();
        PartialResponseWriter rw = new PartialResponseWriter(origResponseWriter);
        context.setResponseWriter((ResponseWriter)rw);
        try {
            rw.startDocument();
            rw.startUpdate("javax.faces.ViewRoot");
            PartialViewContextImpl._renderChildren(context, viewRoot);
            rw.endUpdate();
            rw.startUpdate("javax.faces.ViewState");
            String state = context.getApplication().getStateManager().getViewState(context);
            rw.write(state);
            rw.endUpdate();
            rw.endDocument();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            context.setResponseWriter(origResponseWriter);
        }
    }

    private void _addRenderIdsAsPartialTargets(RenderingContext rc) {
        Collection<String> renderIds = this.getRenderIds();
        PartialPageContext pc = rc.getPartialPageContext();
        for (String id : renderIds) {
            pc.addPartialTarget(id);
        }
    }

    private static void _renderChildren(FacesContext context, UIComponent root) throws IOException {
        Iterator iterator = root.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent child = (UIComponent)iterator.next();
            if (!child.isRendered()) continue;
            child.encodeAll(context);
        }
    }

    private void _assertNotReleased() {
        if (this._released) {
            throw new IllegalStateException();
        }
    }

    private Set<String> _getIds(String parameter) {
        String[] ids;
        String param = (String)this._context.getExternalContext().getRequestParameterMap().get(parameter);
        if (param != null && (ids = param.split("[ \t]+")) != null && ids.length > 0) {
            HashSet<String> idSet = new HashSet<String>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                idSet.add(ids[i]);
            }
            return idSet;
        }
        return Collections.emptySet();
    }

    private static enum ReqType {
        FULL,
        AJAX,
        AJAX_LEGACY,
        LEGACY;

    }

    private static final class ProcessPhaseCallback
    implements VisitCallback {
        private FacesContext _context;
        private PhaseId _phaseId;

        ProcessPhaseCallback(FacesContext context, PhaseId phaseId) {
            this._context = context;
            this._phaseId = phaseId;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (this._phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                target.processDecodes(this._context);
            } else if (this._phaseId == PhaseId.PROCESS_VALIDATIONS) {
                target.processValidators(this._context);
            } else if (this._phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                target.processUpdates(this._context);
            }
            return VisitResult.REJECT;
        }
    }
}

