/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.trinidadinternal.skin.AgentAtRuleMatcher;
import org.apache.myfaces.trinidadinternal.skin.SkinSelectorPropertiesNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SkinStyleSheetNode {
    private final Map<String, String> _namespaceMap;
    private List<SkinSelectorPropertiesNode> _skinSelectorNodeList;
    private final int _direction;
    private final AgentAtRuleMatcher _agentMatcher;
    private final int[] _platforms;
    private final Set<Locale> _locales;
    private final Set<String> _accProperties;

    SkinStyleSheetNode(List<SkinSelectorPropertiesNode> skinSelectorNodeList, Map<String, String> namespaceMap, int direction, Set<Locale> locales, AgentAtRuleMatcher agentMatcher, Set<String> accProperties) {
        this._skinSelectorNodeList = skinSelectorNodeList;
        this._namespaceMap = namespaceMap;
        this._locales = locales;
        this._direction = direction;
        this._agentMatcher = agentMatcher;
        this._platforms = null;
        this._accProperties = accProperties;
    }

    SkinStyleSheetNode(Map<String, String> namespaceMap, int direction, Set<Locale> locales, AgentAtRuleMatcher agentMatcher, int[] platforms, Set<String> accProperties) {
        this._namespaceMap = namespaceMap;
        this._direction = direction;
        this._locales = locales;
        this._agentMatcher = agentMatcher;
        this._platforms = platforms;
        this._accProperties = accProperties;
    }

    public void add(SkinSelectorPropertiesNode node) {
        if (this._skinSelectorNodeList == null) {
            this._skinSelectorNodeList = new ArrayList<SkinSelectorPropertiesNode>();
        }
        this._skinSelectorNodeList.add(node);
    }

    public Map<String, String> getNamespaceMap() {
        return this._namespaceMap;
    }

    public List<SkinSelectorPropertiesNode> getSelectorNodeList() {
        return this._skinSelectorNodeList;
    }

    public int getDirection() {
        return this._direction;
    }

    public AgentAtRuleMatcher getAgentMatcher() {
        return this._agentMatcher;
    }

    public int[] getPlatforms() {
        return this._platforms;
    }

    public Set<Locale> getLocales() {
        return this._locales;
    }

    public Set<String> getAcessibilityProperties() {
        return this._accProperties;
    }

    public boolean matches(int direction, AgentAtRuleMatcher agentMatcher, int[] platforms, Set<Locale> locales, Set<String> accProperties) {
        boolean accMatch;
        boolean localeMatch;
        boolean platformsMatch;
        boolean agentsMatch;
        return direction == this._direction && (agentsMatch = this._objectsEqual(agentMatcher, this._agentMatcher)) && (platformsMatch = this._intArraysEqual(platforms, this._platforms)) && (localeMatch = this._setsEqual(locales, this._locales)) && (accMatch = this._setsEqual(accProperties, this._accProperties));
    }

    private boolean _intArraysEqual(int[] a1, int[] a2) {
        if (a1 != null) {
            Arrays.sort(a1);
        }
        if (a2 != null) {
            Arrays.sort(a2);
        }
        return Arrays.equals(a1, a2);
    }

    private boolean _setsEqual(Set<?> s1, Set<?> s2) {
        return this._objectsEqual(s1, s2);
    }

    private boolean _objectsEqual(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }
}

