/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectOneListbox;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSelectOneListboxRenderer
extends SimpleSelectOneRenderer {
    private PropertyKey _sizeKey;
    private PropertyKey _unselectedLabelKey;

    public SimpleSelectOneListboxRenderer() {
        this(CoreSelectOneListbox.TYPE);
    }

    public SimpleSelectOneListboxRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._sizeKey = type.findKey("size");
        this._unselectedLabelKey = type.findKey("unselectedLabel");
    }

    public static int getListSize(int sizeAttr, int itemCount, boolean addOne) {
        if (sizeAttr < 2) {
            sizeAttr = Math.min(8, Math.max(2, itemCount));
            if (addOne) {
                ++sizeAttr;
            }
        }
        return sizeAttr;
    }

    @Override
    protected void encodeElementContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean, false);
        int count = selectItems == null ? 0 : selectItems.size();
        String unselectedLabel = this.getUnselectedLabel(bean);
        boolean hasUnselectedLabel = unselectedLabel != null;
        int size = SimpleSelectOneListboxRenderer.getListSize(this.getSize(bean), count, hasUnselectedLabel);
        writer.writeAttribute("size", (Object)IntegerUtils.getString((int)size), "size");
        if (hasUnselectedLabel) {
            SelectItem item = new SelectItem((Object)"", unselectedLabel, "", false);
            SimpleSelectOneListboxRenderer.encodeOption(context, arc, component, item, null, true, -1, selectedIndex < 0);
        }
        int counter = 0;
        for (int i = 0; i < count; ++i) {
            SelectItem item = selectItems.get(i);
            if (item instanceof SelectItemGroup) {
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", (Object)item.getLabel(), null);
                SelectItem[] items = ((SelectItemGroup)item).getSelectItems();
                for (int j = 0; j < items.length; ++j) {
                    SimpleSelectOneListboxRenderer.encodeOption(context, arc, component, items[j], converter, valuePassThru, counter, selectedIndex == counter);
                    ++counter;
                }
                writer.endElement("optgroup");
                continue;
            }
            SimpleSelectOneListboxRenderer.encodeOption(context, arc, component, item, converter, valuePassThru, counter, selectedIndex == counter);
            ++counter;
        }
        writer.endElement("select");
    }

    @Override
    protected String getUnselectedLabel(FacesBean bean) {
        return SimpleSelectOneListboxRenderer.toString((Object)bean.getProperty(this._unselectedLabelKey));
    }

    @Override
    protected String getOnchange(FacesBean bean) {
        String onchange = super.getOnchange(bean);
        if (this.isAutoSubmit(bean)) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            String auto = this.getAutoSubmitScript(arc, bean);
            return XhtmlUtils.getChainedJS(onchange, auto, true);
        }
        return onchange;
    }

    protected int getSize(FacesBean bean) {
        Object o = bean.getProperty(this._sizeKey);
        if (o == null) {
            o = this._sizeKey.getDefault();
        }
        if (o == null) {
            return -1;
        }
        return SimpleSelectOneListboxRenderer.toInt((Object)o);
    }

    @Override
    protected String getContentStyleClass(FacesBean bean) {
        return "af|selectOneListbox::content";
    }

    @Override
    protected String getRootStyleClass(FacesBean bean) {
        return "af|selectOneListbox";
    }
}

