/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.render;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.visit.VisitCallback;
import org.apache.myfaces.trinidad.component.visit.VisitContext;
import org.apache.myfaces.trinidad.component.visit.VisitResult;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreRenderer
extends Renderer {
    public static final char CHAR_UNDEFINED = '\uffff';
    public static final int NO_CHILD_INDEX = -1;
    private static final int _COMPRESSED_LENGTH = 4;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CoreRenderer.class);

    protected CoreRenderer() {
    }

    public VisitResult partialEncodeVisit(VisitContext visitContext, PartialPageContext partialContext, UIComponent component, VisitCallback callback) {
        if (partialContext.isPossiblePartialTarget(component.getId()) && partialContext.isPartialTarget(component.getClientId(visitContext.getFacesContext()))) {
            return callback.visit(visitContext, component);
        }
        return VisitResult.ACCEPT;
    }

    public void setupEncodingContext(FacesContext context, RenderingContext rc, UIComponent component) {
        if (component instanceof UIXComponent) {
            this.setupEncodingContext(context, rc, (UIXComponent)component);
        }
    }

    @Deprecated
    public void setupEncodingContext(FacesContext context, RenderingContext rc, UIXComponent component) {
    }

    public void setupChildrenEncodingContext(FacesContext context, RenderingContext rc, UIComponent component) {
    }

    public void tearDownEncodingContext(FacesContext context, RenderingContext rc, UIComponent component) {
        if (component instanceof UIXComponent) {
            this.tearDownEncodingContext(context, rc, (UIXComponent)component);
        }
    }

    @Deprecated
    public void tearDownEncodingContext(FacesContext context, RenderingContext rc, UIXComponent component) {
    }

    public void tearDownChildrenEncodingContext(FacesContext context, RenderingContext rc, UIComponent component) {
    }

    public boolean visitChildrenForEncoding(UIXComponent component, VisitContext visitContext, VisitCallback callback) {
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIXComponent ? ((UIXComponent)kid).visitTree(visitContext, callback) : UIXComponent.visitTree(visitContext, kid, callback))) continue;
            return true;
        }
        return false;
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static String toResourceUri(FacesContext fc, Object o) {
        if (o == null) {
            return null;
        }
        String uri = o.toString();
        if (uri.length() == 0) {
            return null;
        }
        if (uri.startsWith("//")) {
            return uri.substring(1);
        }
        return fc.getApplication().getViewHandler().getResourceURL(fc, uri);
    }

    public static String toActionUri(FacesContext fc, Object o) {
        if (o == null) {
            return null;
        }
        String uri = o.toString();
        if (uri.startsWith("//")) {
            return uri.substring(1);
        }
        return fc.getApplication().getViewHandler().getActionURL(fc, uri);
    }

    @Deprecated
    public static String toUri(Object o) {
        return CoreRenderer.toResourceUri(FacesContext.getCurrentInstance(), o);
    }

    public static int toInt(Object o) {
        return ((Number)o).intValue();
    }

    public static long toLong(Object o) {
        return ((Number)o).longValue();
    }

    public static char toChar(Object o) {
        char c;
        if (o == null) {
            return '\uffff';
        }
        if (o instanceof Character) {
            c = ((Character)o).charValue();
        } else {
            CharSequence cs = o instanceof CharSequence ? (CharSequence)o : o.toString();
            c = cs.length() == 0 ? (char)'\uffff' : (char)cs.charAt(0);
        }
        if (c == '\u0000') {
            c = '\uffff';
        }
        return (char)c;
    }

    public final void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!this.getRendersChildren()) {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            if (rc == null) {
                throw new IllegalStateException(_LOG.getMessage("NO_RENDERINGCONTEXT"));
            }
            FacesBean bean = this.getFacesBean(component);
            this.beforeEncode(context, rc, component, bean);
            this.encodeBegin(context, rc, component, bean);
        }
    }

    public final void encodeChildren(FacesContext context, UIComponent component) {
    }

    public final void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RenderingContext rc = RenderingContext.getCurrentInstance();
        if (rc == null) {
            throw new IllegalStateException(_LOG.getMessage("NO_RENDERINGCONTEXT"));
        }
        FacesBean bean = this.getFacesBean(component);
        if (this.getRendersChildren()) {
            this.beforeEncode(context, rc, component, bean);
            this.encodeAll(context, rc, component, bean);
        } else {
            this.encodeEnd(context, rc, component, bean);
        }
        this.afterEncode(context, rc, component, bean);
    }

    protected void encodeBegin(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (this.getRendersChildren()) {
            throw new IllegalStateException();
        }
    }

    protected void encodeEnd(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (this.getRendersChildren()) {
            throw new IllegalStateException();
        }
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (!this.getRendersChildren()) {
            throw new IllegalStateException();
        }
    }

    protected void encodeChild(FacesContext context, UIComponent child) throws IOException {
        assert (child.isRendered());
        child.encodeAll(context);
    }

    protected void encodeAllChildren(FacesContext context, UIComponent component) throws IOException {
        int childCount = component.getChildCount();
        if (childCount == 0) {
            return;
        }
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            this.encodeChild(context, child);
        }
    }

    protected void delegateRenderer(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, CoreRenderer renderer) throws IOException {
        if (!renderer.getRendersChildren()) {
            throw new IllegalStateException();
        }
        renderer.encodeAll(context, rc, component, bean);
    }

    protected void delegateRendererBegin(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, CoreRenderer renderer) throws IOException {
        if (renderer.getRendersChildren()) {
            throw new IllegalStateException();
        }
        renderer.encodeBegin(context, rc, component, bean);
    }

    protected void delegateRendererEnd(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, CoreRenderer renderer) throws IOException {
        if (renderer.getRendersChildren()) {
            throw new IllegalStateException();
        }
        renderer.encodeEnd(context, rc, component, bean);
    }

    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeAttribute("id", (Object)clientId, "id");
        }
    }

    protected String getClientId(FacesContext context, UIComponent component) {
        return component.getClientId(context);
    }

    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        String id = component.getId();
        if (id == null) {
            return false;
        }
        return !id.startsWith("j_id");
    }

    protected boolean skipDecode(FacesContext context) {
        return false;
    }

    protected FacesBean getFacesBean(UIComponent component) {
        return ((UIXComponent)component).getFacesBean();
    }

    protected static final Object getRenderingProperty(RenderingContext rc, Object key) {
        return rc.getProperties().get(key);
    }

    protected static final Object setRenderingProperty(RenderingContext rc, Object key, Object value) {
        return rc.getProperties().put(key, value);
    }

    public static UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = component.getFacet(name);
        if (facet == null || !facet.isRendered()) {
            return null;
        }
        return facet;
    }

    public static boolean hasRenderedChildren(UIComponent component) {
        int count = component.getChildCount();
        if (count == 0) {
            return false;
        }
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            return true;
        }
        return false;
    }

    public static int getRenderedChildCount(UIComponent component) {
        int count = component.getChildCount();
        if (count == 0) {
            return 0;
        }
        int total = 0;
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            ++total;
        }
        return total;
    }

    public static int getNextRenderedChildIndex(List<UIComponent> components, int afterChildIndex) {
        int childIndex = afterChildIndex + 1;
        ListIterator<UIComponent> iter = components.listIterator(childIndex);
        while (iter.hasNext()) {
            if (((UIComponent)iter.next()).isRendered()) {
                return childIndex;
            }
            ++childIndex;
        }
        return -1;
    }

    public static boolean isDesktop(RenderingContext rc) {
        return Agent.TYPE_DESKTOP.equals(rc.getAgent().getType());
    }

    public static boolean isPDA(RenderingContext rc) {
        return Agent.TYPE_PDA.equals(rc.getAgent().getType());
    }

    public static boolean isIE(RenderingContext rc) {
        return "ie".equals(rc.getAgent().getAgentName());
    }

    public static boolean isKonqueror(RenderingContext rc) {
        return "konqueror".equals(rc.getAgent().getAgentName());
    }

    public static boolean isGecko(RenderingContext rc) {
        return "gecko".equals(rc.getAgent().getAgentName());
    }

    public static boolean isWebKit(RenderingContext rc) {
        return "webkit".equals(rc.getAgent().getAgentName());
    }

    public static boolean isOpera(RenderingContext rc) {
        return "opera".equals(rc.getAgent().getAgentName());
    }

    public static boolean isIPhone(RenderingContext rc) {
        return "iphone".equals(rc.getAgent().getPlatformName());
    }

    public static boolean isGenericPDA(RenderingContext rc) {
        return "genericpda".equals(rc.getAgent().getPlatformName());
    }

    public static boolean isNokiaS60(RenderingContext rc) {
        return "nokia_s60".equals(rc.getAgent().getPlatformName());
    }

    public static boolean isInaccessibleMode(RenderingContext rc) {
        return rc.getAccessibilityMode() == RequestContext.Accessibility.INACCESSIBLE;
    }

    public static boolean isScreenReaderMode(RenderingContext rc) {
        return rc.getAccessibilityMode() == RequestContext.Accessibility.SCREEN_READER;
    }

    protected void beforeEncode(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        this.setupEncodingContext(context, rc, component);
    }

    protected void afterEncode(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) {
        this.tearDownEncodingContext(context, rc, component);
    }

    protected void renderEncodedActionURI(FacesContext context, String name, Object value) throws IOException {
        if (value != null) {
            value = context.getExternalContext().encodeActionURL(value.toString());
            context.getResponseWriter().writeURIAttribute(name, value, null);
        }
    }

    protected void renderEncodedResourceURI(FacesContext context, String name, Object value) throws IOException {
        if (value != null) {
            value = context.getExternalContext().encodeResourceURL(value.toString());
            context.getResponseWriter().writeURIAttribute(name, value, null);
        }
    }

    public static void renderStyleClass(FacesContext context, RenderingContext rc, String styleClass) throws IOException {
        if (styleClass != null) {
            styleClass = rc.getStyleClass(styleClass);
            context.getResponseWriter().writeAttribute("class", (Object)styleClass, null);
        }
    }

    public static void renderStyleClasses(FacesContext context, RenderingContext rc, String[] styleClasses) throws IOException {
        String value;
        int length = styleClasses.length;
        if (length == 0) {
            return;
        }
        if (length == 1) {
            value = rc.getStyleClass(styleClasses[0]);
        } else {
            StringBuilder builder = new StringBuilder(5 * length);
            for (int i = 0; i < length; ++i) {
                String styleClass;
                if (styleClasses[i] == null || (styleClass = rc.getStyleClass(styleClasses[i])) == null) continue;
                if (builder.length() != 0) {
                    builder.append(' ');
                }
                builder.append(styleClass);
            }
            value = builder.length() == 0 ? null : builder.toString();
        }
        context.getResponseWriter().writeAttribute("class", (Object)value, null);
    }
}

