/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;

public final class AgentAtRuleMatcher {
    private static final Pattern _PROPERTY_SPLITTER = Pattern.compile("\\(\\s*([A-Za-z0-9_-]+)\\s*:\\s*(\\S+)\\s*\\)");
    private static final Pattern _AND_SPLITTER = Pattern.compile("\\s+and\\s+");
    private static final String[] _AFFIRMATIVE_TOUCH_CAPABILITIES = new String[]{TrinidadAgent.TOUCH_SCREEN_MULTIPLE.toString(), TrinidadAgent.TOUCH_SCREEN_SINGLE.toString()};
    private static final Set<String> _ALL_TOUCH_CAPABILITIES = new HashSet<String>(Arrays.asList(TrinidadAgent.TOUCH_SCREEN_MULTIPLE.toString(), TrinidadAgent.TOUCH_SCREEN_SINGLE.toString(), TrinidadAgent.TOUCH_SCREEN_NONE.toString()));
    private static final Map<String, Comparison> _COMPARISON_PARSER = new HashMap<String, Comparison>(4);
    private final Map<TrinidadAgent.Application, Set<AgentMatcher>> _selectorAgents;
    private final Set<AgentMatcher> _capTouchMatchers;
    private final int _hashCode;
    private static final TrinidadLogger _LOG;
    private static final String TOUCH_SCREEN_RULE_STR;

    public AgentAtRuleMatcher(String queryString) {
        this(queryString.split(","));
    }

    public AgentAtRuleMatcher(String[] selectors) {
        Map<Object, Object> selectorAgents = Collections.emptyMap();
        HashSet<AgentMatcher> capTouchMatchers = new HashSet<AgentMatcher>();
        for (int selectorIndex = 0; selectorIndex < selectors.length; ++selectorIndex) {
            Set<AgentMatcher> agentMatchers;
            String currSelector = selectors[selectorIndex].trim();
            if (currSelector.startsWith(TOUCH_SCREEN_RULE_STR)) {
                capTouchMatchers.add(this._getTouchScreenMatcher(currSelector));
                continue;
            }
            String[] sections = _AND_SPLITTER.split(currSelector);
            String agentName = sections[0].trim();
            TrinidadAgent.Application browser = NameUtils.getAgentApplication(agentName);
            if (browser == TrinidadAgent.Application.UNKNOWN) continue;
            int sectionCount = sections.length;
            if (sectionCount == 1) {
                agentMatchers = Collections.emptySet();
            } else {
                AgentMatcher newAgentMatcher;
                if (sectionCount > 2) {
                    ArrayList<AgentMatcher> andedMatchers = new ArrayList<AgentMatcher>(sectionCount - 1);
                    for (int sectionIndex = 1; sectionIndex < sectionCount; ++sectionIndex) {
                        andedMatchers.add(this._getAgentMatcher(sections[sectionIndex]));
                    }
                    newAgentMatcher = new AndMatcher(andedMatchers);
                } else {
                    newAgentMatcher = this._getAgentMatcher(sections[1]);
                }
                agentMatchers = (Set<AgentMatcher>)selectorAgents.get((Object)browser);
                if (agentMatchers == null || agentMatchers.isEmpty()) {
                    agentMatchers = Collections.singleton(newAgentMatcher);
                } else if (!agentMatchers.contains(newAgentMatcher)) {
                    if (agentMatchers.size() == 1) {
                        agentMatchers = new HashSet<AgentMatcher>(agentMatchers);
                    }
                    agentMatchers.add(newAgentMatcher);
                }
            }
            if (selectorAgents.isEmpty()) {
                selectorAgents = Collections.singletonMap(browser, agentMatchers);
                continue;
            }
            if (((Object)agentMatchers).equals(selectorAgents.get((Object)browser))) continue;
            if (selectorAgents.size() == 1) {
                HashMap<Object, Object> newSelectorAgents = new HashMap<Object, Object>(3);
                Map.Entry<Object, Object> singleEntry = selectorAgents.entrySet().iterator().next();
                newSelectorAgents.put(singleEntry.getKey(), singleEntry.getValue());
                selectorAgents = newSelectorAgents;
            }
            selectorAgents.put((Object)browser, agentMatchers);
        }
        this._selectorAgents = selectorAgents;
        this._capTouchMatchers = capTouchMatchers;
        this._hashCode = AgentAtRuleMatcher._calculateStableHashCode(this._selectorAgents, this._capTouchMatchers);
    }

    private TouchScreenCapabilityMatcher _getTouchScreenMatcher(String currSelector) {
        Matcher m = _PROPERTY_SPLITTER.matcher(currSelector);
        String[] capTouchArray = new String[]{};
        if (m.find()) {
            String propName = m.group(1);
            String propValue = m.group(2);
            if (propValue != null) {
                String capValue = propValue.trim();
                if (_ALL_TOUCH_CAPABILITIES.contains(capValue)) {
                    capTouchArray = new String[]{capValue};
                } else {
                    _LOG.warning("INVALID_AGENT_PROPERTY", new Object[]{propName, capValue});
                }
            }
        } else {
            capTouchArray = _AFFIRMATIVE_TOUCH_CAPABILITIES;
        }
        if (capTouchArray.length > 0) {
            Set<String> capTouchValues = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(capTouchArray)));
            TouchScreenCapabilityMatcher matcher = new TouchScreenCapabilityMatcher(capTouchValues);
            return matcher;
        }
        throw new IllegalArgumentException("Invalid @agent rule specified: " + currSelector);
    }

    private static int _calculateStableHashCode(Map<TrinidadAgent.Application, Set<AgentMatcher>> selectorAgents, Set<AgentMatcher> capTouchMatchers) {
        int hashCode = 0;
        for (Map.Entry<TrinidadAgent.Application, Set<AgentMatcher>> entry : selectorAgents.entrySet()) {
            int stableKeyHashCode = entry.getKey().name().hashCode();
            int entryHashCode = stableKeyHashCode ^ ((Object)entry.getValue()).hashCode();
            hashCode += entryHashCode;
        }
        return hashCode += ((Object)capTouchMatchers).hashCode();
    }

    private AgentMatcher _getAgentMatcher(String propertySelector) {
        if ((propertySelector = propertySelector.trim()).startsWith(TOUCH_SCREEN_RULE_STR)) {
            return this._getTouchScreenMatcher(propertySelector);
        }
        return this._getVersionMatcher(propertySelector);
    }

    private VersionMatcher _getVersionMatcher(String propertySelector) {
        Matcher m = _PROPERTY_SPLITTER.matcher(propertySelector);
        if (m.find()) {
            String propName = m.group(1);
            String version = m.group(2);
            Comparison comparison = _COMPARISON_PARSER.get(propName);
            if (comparison == null) {
                throw new IllegalArgumentException("Invalid @agent property name: " + propName);
            }
            Version newVersion = new Version(version, "*");
            return new VersionMatcher(newVersion, comparison);
        }
        throw new IllegalArgumentException("Invalid @agent property selector: " + propertySelector);
    }

    public Set<Match> match(TrinidadAgent agent) {
        HashSet<Match> matches = new HashSet<Match>();
        TrinidadAgent.Application browser = agent.getAgentApplication();
        if (this._selectorAgents.containsKey((Object)browser)) {
            matches.add(Match.APPLICATION);
            Set<AgentMatcher> agentMatchers = this._selectorAgents.get((Object)browser);
            if (!agentMatchers.isEmpty()) {
                for (AgentMatcher currMatcher : agentMatchers) {
                    if (!currMatcher.match(agent)) continue;
                    if (currMatcher instanceof VersionMatcher) {
                        matches.add(Match.VERSION);
                        continue;
                    }
                    if (currMatcher instanceof TouchScreenCapabilityMatcher) {
                        matches.add(Match.CAP_TOUCH_SCREEN);
                        continue;
                    }
                    if (!(currMatcher instanceof AndMatcher)) continue;
                    AndMatcher andMatcher = (AndMatcher)currMatcher;
                    if (andMatcher.hasVersionMatcher()) {
                        matches.add(Match.VERSION);
                    }
                    if (!andMatcher.hasTouchScreenCapabilityMatcher()) continue;
                    matches.add(Match.CAP_TOUCH_SCREEN);
                }
                if (!matches.contains((Object)Match.CAP_TOUCH_SCREEN) && !matches.contains((Object)Match.VERSION)) {
                    matches.clear();
                }
            }
        }
        if (!matches.contains((Object)Match.CAP_TOUCH_SCREEN) && !this._capTouchMatchers.isEmpty()) {
            for (AgentMatcher currMatcher : this._capTouchMatchers) {
                if (!currMatcher.match(agent)) continue;
                matches.add(Match.APPLICATION);
                matches.add(Match.CAP_TOUCH_SCREEN);
                break;
            }
        }
        return Collections.unmodifiableSet(matches);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AgentAtRuleMatcher) {
            AgentAtRuleMatcher otherAgentMatcher = (AgentAtRuleMatcher)other;
            return ((Object)this._selectorAgents).equals(otherAgentMatcher._selectorAgents) && ((Object)this._capTouchMatchers).equals(otherAgentMatcher._capTouchMatchers);
        }
        return false;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return super.toString() + "agents=" + this._selectorAgents.toString() + "touchScreenCap=" + this._capTouchMatchers.toString();
    }

    static {
        _COMPARISON_PARSER.put("version", Comparison.EQUALS);
        _COMPARISON_PARSER.put("max-version", Comparison.MAX);
        _COMPARISON_PARSER.put("min-version", Comparison.MIN);
        _LOG = TrinidadLogger.createTrinidadLogger(AgentAtRuleMatcher.class);
        TOUCH_SCREEN_RULE_STR = "(" + TrinidadAgent.CAP_TOUCH_SCREEN.getCapabilityName();
    }

    private static final class TouchScreenCapabilityMatcher
    extends AgentMatcher {
        private final Set<String> _touchCapabilities;
        private final int _hashCode;

        public TouchScreenCapabilityMatcher(Set<String> touchCapabilities) {
            if (touchCapabilities == null) {
                throw new NullPointerException("touchCapabilities must be non-null");
            }
            this._touchCapabilities = touchCapabilities;
            this._hashCode = ((Object)this._touchCapabilities).hashCode();
        }

        @Override
        public boolean match(TrinidadAgent agent) {
            String capTouchScreen = (String)agent.getCapabilities().get(TrinidadAgent.CAP_TOUCH_SCREEN);
            for (String touchCap : this._touchCapabilities) {
                if (!capTouchScreen.equals(touchCap)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this._hashCode;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TouchScreenCapabilityMatcher) {
                TouchScreenCapabilityMatcher otherMatcher = (TouchScreenCapabilityMatcher)other;
                return ((Object)this._touchCapabilities).equals(otherMatcher._touchCapabilities);
            }
            return false;
        }

        public String toString() {
            return super.toString() + ", touchCapabilities=" + this._touchCapabilities;
        }
    }

    private static class AndMatcher
    extends AgentMatcher {
        private final List<AgentMatcher> _matchers;
        private final int _hashCode;
        private boolean hasVersionMatcher;
        private boolean hasTouchScreenCapabilityMatcher;

        public AndMatcher(List<AgentMatcher> matchers) {
            this._matchers = matchers;
            this._hashCode = ((Object)matchers).hashCode();
            for (AgentMatcher matcher : matchers) {
                if (matcher instanceof VersionMatcher) {
                    this.hasVersionMatcher = true;
                }
                if (!(matcher instanceof TouchScreenCapabilityMatcher)) continue;
                this.hasTouchScreenCapabilityMatcher = true;
            }
        }

        protected boolean hasTouchScreenCapabilityMatcher() {
            return this.hasTouchScreenCapabilityMatcher;
        }

        protected boolean hasVersionMatcher() {
            return this.hasVersionMatcher;
        }

        @Override
        public boolean match(TrinidadAgent agent) {
            int matcherCount = this._matchers.size();
            for (int i = 0; i < matcherCount; ++i) {
                if (this._matchers.get(i).match(agent)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this._hashCode;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof AndMatcher) {
                return ((Object)this._matchers).equals(((AndMatcher)other)._matchers);
            }
            return false;
        }

        public String toString() {
            return super.toString() + ", matchers=" + this._matchers;
        }
    }

    private static final class VersionMatcher
    extends AgentMatcher {
        private final Version _version;
        private final Comparison _comparison;
        private final int _hashCode;

        public VersionMatcher(Version version, Comparison comparison) {
            this._version = version;
            this._comparison = comparison;
            this._hashCode = this._version.hashCode() * 37 + this._comparison.name().hashCode();
        }

        @Override
        public boolean match(TrinidadAgent agent) {
            int result = this._version.compareTo(agent.getVersion());
            if (result == 0) {
                return true;
            }
            switch (this._comparison) {
                case MIN: {
                    return result < 0;
                }
                case MAX: {
                    return result > 0;
                }
                case EQUALS: {
                    return false;
                }
            }
            assert (false) : "Unknown comparison type " + (Object)((Object)this._comparison);
            return false;
        }

        @Override
        public final int hashCode() {
            return this._hashCode;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof VersionMatcher) {
                VersionMatcher otherVersionMatcher = (VersionMatcher)other;
                return this._version.equals((Object)otherVersionMatcher._version) && this._comparison.equals((Object)otherVersionMatcher._comparison);
            }
            return false;
        }

        public String toString() {
            return super.toString() + ", version=" + this._version + ", comparison=" + (Object)((Object)this._comparison);
        }
    }

    private static abstract class AgentMatcher {
        private AgentMatcher() {
        }

        public abstract boolean match(TrinidadAgent var1);

        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }

    private static enum Comparison {
        EQUALS,
        MIN,
        MAX;

    }

    public static enum Match {
        APPLICATION,
        VERSION,
        CAP_TOUCH_SCREEN;

    }
}

