/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.io.XMLEscapes;
import org.apache.myfaces.trinidadinternal.share.util.CaboHttpUtils;

public class XhtmlResponseWriter
extends ResponseWriter {
    public static final String XHTML_CONTENT_TYPE = "application/xhtml+xml";
    private boolean _closeStart;
    private boolean _dontEscape;
    private Writer _out;
    private String _encoding;
    private String _pendingElement;
    private int _cdataCount;
    private final ArrayList<String> _skippedElements = new ArrayList(20);
    private static final Class<?> _CHAR_ARRAY_CLASS = new char[0].getClass();
    private static final Class<?> _BOOLEAN_CLASS = Boolean.class;
    private static final Class<?> _INTEGER_CLASS = Integer.class;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(XhtmlResponseWriter.class);

    public XhtmlResponseWriter(Writer out, String contentType, String encoding) throws UnsupportedEncodingException {
        this._out = out;
        this._encoding = encoding;
        this._cdataCount = 0;
        CaboHttpUtils.validateEncoding(encoding);
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public String getContentType() {
        return XHTML_CONTENT_TYPE;
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
        this._out.flush();
    }

    public void startCDATA() throws IOException {
        this._closeStartIfNecessary();
        ++this._cdataCount;
        if (this._cdataCount == 1) {
            this._out.write("<![CDATA[");
        }
    }

    public void endCDATA() throws IOException {
        if (this._cdataCount == 1) {
            this._out.write("]]>");
        }
        --this._cdataCount;
    }

    public void flush() throws IOException {
        this._closeStartIfNecessary();
        this._out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this._out.close();
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (name.charAt(0) == 's') {
            if ("span".equals(name)) {
                this._markPendingElements();
                this._pendingElement = name;
                return;
            }
            if ("script".equals(name) || "style".equals(name)) {
                this._dontEscape = true;
            }
        }
        this._startElementImpl(name);
    }

    public void endElement(String name) throws IOException {
        if (this._pendingElement != null) {
            this._pendingElement = null;
            return;
        }
        String element = this._popSkippedElement();
        if (element != null) {
            if (!element.equals(name)) {
                _LOG.severe("ELEMENT_END_NAME_NOT_MATCH_START_NAME", new Object[]{name, element});
            }
            Writer out = this._out;
            this._dontEscape = false;
            if (this._closeStart) {
                out.write(62);
                this._closeStart = false;
            }
            out.write("</");
            out.write(name);
            out.write(62);
        }
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (value == null) {
            return;
        }
        this._outputPendingElements();
        Writer out = this._out;
        Class<?> valueClass = value.getClass();
        if (valueClass == _BOOLEAN_CLASS) {
            if (Boolean.TRUE.equals(value)) {
                out.write(32);
                out.write(name);
                out.write("=\"");
                out.write(name);
                out.write("\"");
            }
        } else {
            out.write(32);
            out.write(name);
            out.write("=\"");
            this._writeValue(valueClass, value, true);
            out.write(34);
        }
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        this.writeAttribute(name, value, componentPropertyName);
    }

    public void writeComment(Object comment) throws IOException {
        if (comment != null) {
            this._closeStartIfNecessary();
            this._out.write("<!--");
            this._out.write(comment.toString());
            this._out.write("-->");
        }
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        if (text != null) {
            String valueString = text.toString();
            if (this._dontEscape) {
                this.write(text.toString());
            } else {
                this._closeStartIfNecessary();
                XMLEscapes.writeText(this._out, valueString);
            }
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (this._dontEscape) {
            this.write(text, off, len);
        } else {
            this._closeStartIfNecessary();
            XMLEscapes.writeText(this._out, text, off, len);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this._closeStartIfNecessary();
        this._out.write(cbuf, off, len);
    }

    public void write(String str) throws IOException {
        this._closeStartIfNecessary();
        this._out.write(str);
    }

    public void write(int c) throws IOException {
        this._closeStartIfNecessary();
        this._out.write((char)c);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        try {
            return new XhtmlResponseWriter(writer, this.getContentType(), this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            throw new IllegalStateException();
        }
    }

    private void _startElementImpl(String name) throws IOException {
        this._closeStartIfNecessary();
        this._pushOutputtedElement(name);
        Writer out = this._out;
        out.write(60);
        out.write(name);
        this._closeStart = true;
    }

    private void _writeValue(Class<?> valueClass, Object value, boolean isAttribute) throws IOException {
        assert (valueClass != _CHAR_ARRAY_CLASS) : "Character arrays not supported as HTML attributes";
        if (valueClass == _INTEGER_CLASS) {
            this._out.write(IntegerUtils.getString((Integer)((Integer)value)));
            return;
        }
        String stringValue = value.toString();
        if (isAttribute) {
            XMLEscapes.writeAttribute(this._out, stringValue);
        } else {
            XMLEscapes.writeText(this._out, stringValue);
        }
    }

    private void _closeStartIfNecessary() throws IOException {
        this._markPendingElements();
        if (this._closeStart) {
            this._out.write(62);
            this._closeStart = false;
        }
    }

    private void _outputPendingElements() throws IOException {
        String pendingElement = this._pendingElement;
        if (pendingElement != null) {
            this._pendingElement = null;
            this._startElementImpl(pendingElement);
        }
    }

    private void _markPendingElements() {
        String pendingElement = this._pendingElement;
        if (pendingElement != null) {
            this._pushSkippedElement();
            this._pendingElement = null;
        }
    }

    private String _popSkippedElement() {
        int size = this._skippedElements.size();
        if (size == 0) {
            return null;
        }
        return this._skippedElements.remove(size - 1);
    }

    private void _pushSkippedElement() {
        this._skippedElements.add(null);
    }

    private void _pushOutputtedElement(String name) {
        this._skippedElements.add(name);
    }
}

