/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.List;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.change.ChangeUtils;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RemoveChildComponentChange
extends ComponentChange
implements DocumentChange {
    private final String _childId;
    private final String _identifier;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RemoveChildComponentChange.class);
    private static final long serialVersionUID = 1L;

    public RemoveChildComponentChange(String childId) {
        this(childId, "id");
    }

    public RemoveChildComponentChange(String childId, String identifier) {
        if (childId == null || childId.length() == 0) {
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_CONSTRUCT_REMOVECHILDCHANGE_WITH_NULL_ID"));
        }
        if (identifier == null || "".equals(identifier)) {
            throw new IllegalArgumentException(_LOG.getMessage("IDENTIFIER_TYPE_CANNOT_BE_NULL"));
        }
        this._childId = childId;
        this._identifier = identifier;
    }

    public String getChildId() {
        return this._childId;
    }

    public final String getIdentifier() {
        return this._identifier;
    }

    public void changeComponent(UIComponent uiComponent) {
        if (uiComponent.getChildCount() == 0) {
            return;
        }
        List children = uiComponent.getChildren();
        children.remove(ChangeUtils.getChildForId(uiComponent, this._childId, this._identifier));
    }

    public void changeDocument(Node componentNode) {
        for (Node currChild = componentNode.getFirstChild(); currChild != null; currChild = currChild.getNextSibling()) {
            Node idAttr;
            NamedNodeMap attributes = currChild.getAttributes();
            if (attributes == null || (idAttr = attributes.getNamedItem(this._identifier)) == null || !this._childId.equals(idAttr.getNodeValue())) continue;
            currChild.getParentNode().removeChild(currChild);
            break;
        }
    }

    public boolean getForcesDocumentReload() {
        return false;
    }
}

