/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.convert.GenericConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(JsonUtils.class);

    public static void writeObject(StringBuilder out, Object attrValue, boolean escapeXML) throws IOException {
        if (attrValue == null) {
            out.append("null");
        } else {
            if (attrValue instanceof CharSequence) {
                JsonUtils.writeString(out, (CharSequence)attrValue, escapeXML);
                return;
            }
            Class<?> valueClass = attrValue.getClass();
            if (Boolean.class == valueClass) {
                JsonUtils.writeBoolean(out, (Boolean)attrValue);
                return;
            }
            if (Integer.class == valueClass) {
                JsonUtils.writeInt(out, (Integer)attrValue);
                return;
            }
            if (Character.class == valueClass) {
                JsonUtils.writeChar(out, ((Character)attrValue).charValue(), escapeXML);
                return;
            }
            if (valueClass.isArray()) {
                out.append('[');
                int length = Array.getLength(attrValue);
                for (int i = 0; i < length; ++i) {
                    JsonUtils.writeObject(out, Array.get(attrValue, i), escapeXML);
                    if (i == length - 1) continue;
                    out.append(',');
                }
                out.append(']');
                return;
            }
            GenericConverterFactory converter = GenericConverterFactory.getCurrentInstance();
            if (Byte.class == valueClass) {
                JsonUtils.writeByte(out, (Byte)attrValue);
            } else if (converter.isConvertible(attrValue, Date.class)) {
                Date date = (Date)converter.convert(attrValue, Date.class);
                JsonUtils.writeDate(out, date);
            } else if (Double.class == valueClass) {
                JsonUtils.writeDouble(out, (Double)attrValue);
            } else if (Float.class == valueClass) {
                JsonUtils.writeFloat(out, ((Float)attrValue).floatValue());
            } else if (Long.class == valueClass) {
                JsonUtils.writeLong(out, (Long)attrValue);
            } else if (Short.class == valueClass) {
                JsonUtils.writeShort(out, (Short)attrValue);
            } else if (converter.isConvertible(attrValue, Number.class)) {
                Number num = (Number)converter.convert(attrValue, Number.class);
                JsonUtils.writeDouble(out, num.doubleValue());
            } else if (Map.class.isAssignableFrom(valueClass)) {
                JsonUtils.writeMap(out, (Map)attrValue, escapeXML);
            } else if (Collection.class.isAssignableFrom(valueClass)) {
                JsonUtils.writeCollection(out, (Collection)attrValue, escapeXML);
            } else if (Color.class == valueClass) {
                JsonUtils.writeColor(out, (Color)attrValue);
            }
        }
    }

    public static void writeBoolean(StringBuilder out, boolean value) throws IOException {
        out.append(value);
    }

    public static void writeByte(StringBuilder out, byte value) throws IOException {
        out.append(value);
    }

    public static void writeChar(StringBuilder out, char value, boolean escapeXML) throws IOException {
        out.append('\'');
        JsonUtils._escapeChar(out, value, escapeXML);
        out.append('\'');
    }

    public static void writeCollection(StringBuilder out, Collection<?> value, boolean escapeXML) throws IOException {
        if (value == null) {
            out.append("null");
        } else if (value.isEmpty()) {
            out.append("[]");
        } else {
            out.append("[");
            Iterator<?> iter = value.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                JsonUtils.writeObject(out, item, escapeXML);
                if (!iter.hasNext()) continue;
                out.append(',');
            }
            out.append(']');
        }
    }

    public static void writeDate(StringBuilder out, Date value) throws IOException {
        out.append("new Date(" + value.getTime() + ")");
    }

    public static void writeColor(StringBuilder out, Color color) throws IOException {
        if (color.getAlpha() == 0) {
            out.append("null");
        } else {
            out.append("new TrColor(");
            out.append(color.getRed());
            out.append(",");
            out.append(color.getGreen());
            out.append(",");
            out.append(color.getBlue());
            out.append(")");
        }
    }

    public static void writeDouble(StringBuilder out, double value) throws IOException {
        out.append(value);
    }

    public static void writeFloat(StringBuilder out, float value) throws IOException {
        out.append(value);
    }

    public static void writeLong(StringBuilder out, long value) throws IOException {
        out.append(value);
    }

    public static void writeInt(StringBuilder out, int value) throws IOException {
        out.append(value);
    }

    public static void writeShort(StringBuilder out, short value) throws IOException {
        out.append(value);
    }

    public static void writeString(StringBuilder out, CharSequence value, boolean escapeXML) throws IOException {
        if (value == null) {
            out.append("null");
        } else {
            out.append('\'');
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                JsonUtils._escapeChar(out, ch, escapeXML);
            }
            out.append('\'');
        }
    }

    public static void writeMap(StringBuilder out, Map<?, ?> map, boolean escapeXML) throws IOException {
        if (map == null) {
            out.append("null");
        } else if (map.isEmpty()) {
            out.append("{}");
        } else {
            out.append('{');
            boolean needComma = false;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object rawKey = entry.getKey();
                if (rawKey == null) {
                    throw new IllegalArgumentException(_LOG.getMessage("JAVASCRIPT_NOT_SUPPORT_NULL_KEYS"));
                }
                String key = rawKey.toString();
                Object value = entry.getValue();
                if (value == null) continue;
                if (needComma) {
                    out.append(',');
                } else {
                    needComma = true;
                }
                JsonUtils.writeString(out, key, escapeXML);
                out.append(':');
                JsonUtils.writeObject(out, value, escapeXML);
            }
            out.append('}');
        }
    }

    private JsonUtils() {
    }

    private static void _escapeChar(StringBuilder out, char value, boolean escapeXML) {
        switch (value) {
            case '&': {
                if (escapeXML) {
                    out.append("&amp;");
                    break;
                }
                out.append('&');
                break;
            }
            case '<': {
                if (escapeXML) {
                    out.append("&lt;");
                    break;
                }
                out.append('<');
                break;
            }
            case '>': {
                if (escapeXML) {
                    out.append("&gt;");
                    break;
                }
                out.append('>');
                break;
            }
            case '\"': {
                if (escapeXML) {
                    out.append("\\&quot;");
                    break;
                }
                out.append("\\\"");
                break;
            }
            case '\'': {
                out.append("\\'");
                break;
            }
            case '\\': {
                out.append("\\\\");
                break;
            }
            case '\b': {
                out.append("\\b");
                break;
            }
            case '\f': {
                out.append("\\f");
                break;
            }
            case '\n': {
                out.append("\\n");
                break;
            }
            case '\r': {
                out.append("\\r");
                break;
            }
            case '\t': {
                out.append("\\t");
                break;
            }
            default: {
                if (value >= ' ' && value < '\u0080') {
                    out.append(value);
                    break;
                }
                String hex = Integer.toHexString(value);
                if (value > '\u00ff') {
                    out.append("\\u");
                    if (value < '\u1000') {
                        out.append('0');
                    }
                    out.append(hex);
                    break;
                }
                out.append("\\x");
                if (value < '\u0010') {
                    out.append('0');
                }
                out.append(hex);
            }
        }
    }
}

