/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputFormatted;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ValueRenderer;

public class OutputFormattedRenderer
extends ValueRenderer {
    private static final Map<String, String> _USAGES = new HashMap<String, String>();
    private PropertyKey _styleUsageKey;

    public OutputFormattedRenderer() {
        super(CoreOutputFormatted.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._styleUsageKey = type.findKey("styleUsage");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent comp, FacesBean bean) throws IOException {
        if (this.canSkipRendering(context, arc, comp)) {
            return;
        }
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("span", comp);
        this.renderId(context, comp);
        this.renderAllAttributes(context, arc, bean);
        String value = this.getConvertedString(context, comp, bean);
        this.renderFormattedText(context, value);
        rw.endElement("span");
    }

    protected String getStyleUsage(FacesBean bean) {
        return OutputFormattedRenderer.toString((Object)bean.getProperty(this._styleUsageKey));
    }

    protected String getStyleClass(FacesBean bean) {
        String usage;
        String styleClass = super.getStyleClass(bean);
        if (styleClass == null && (usage = this.getStyleUsage(bean)) != null) {
            styleClass = _USAGES.get(usage);
        }
        return styleClass;
    }

    static {
        _USAGES.put("inContextBranding", "p_InContextBrandingText");
        _USAGES.put("instruction", "AFInstructionText");
        _USAGES.put("pageStamp", "OraPageStampText");
    }
}

