/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public final class ComponentUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ComponentUtils.class);

    private ComponentUtils() {
    }

    public static Object resolveObject(Object value, Object defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean resolveBoolean(Object value, boolean defaultValue) {
        if (defaultValue) {
            return !Boolean.FALSE.equals(value);
        }
        return Boolean.TRUE.equals(value);
    }

    public static boolean resolveBoolean(Object value) {
        return Boolean.TRUE.equals(value);
    }

    public static int resolveInteger(Object value) {
        return ComponentUtils.resolveInteger(value, 0);
    }

    public static int resolveInteger(Object value, int defaultValue) {
        return value != null ? ((Number)value).intValue() : defaultValue;
    }

    public static long resolveLong(Object value) {
        return ComponentUtils.resolveLong(value, 0L);
    }

    public static long resolveLong(Object value, long defaultValue) {
        return value != null ? ((Number)value).longValue() : defaultValue;
    }

    public static double resolveDouble(Object value) {
        return ComponentUtils.resolveDouble(value, 0.0);
    }

    public static double resolveDouble(Object value, double defaultValue) {
        return value != null ? ((Number)value).doubleValue() : defaultValue;
    }

    public static char resolveCharacter(Character value) {
        return ComponentUtils.resolveCharacter(value, '\u0000');
    }

    public static char resolveCharacter(Character value, char defaultValue) {
        return value != null ? value.charValue() : defaultValue;
    }

    public static Number resolveNumber(Object value) {
        return ComponentUtils.resolveNumber(value, null);
    }

    public static Number resolveNumber(Object value, Number defaultValue) {
        return value != null ? (Number)((Number)value) : (Number)defaultValue;
    }

    public static String resolveString(Object value) {
        return value != null ? value.toString() : null;
    }

    public static String resolveString(Object value, String defaultValue) {
        return value != null ? value.toString() : defaultValue;
    }

    public static String[] resolveStringArray(Object value) {
        return ComponentUtils.resolveStringArray(value, null);
    }

    public static String[] resolveStringArray(Object value, String[] defaultValue) {
        return value != null ? (String[])value : defaultValue;
    }

    public static Date resolveDate(Object value) {
        return ComponentUtils.resolveDate(value, null);
    }

    public static Date resolveDate(Object value, Date defaultValue) {
        return value != null ? (Date)value : defaultValue;
    }

    public static TimeZone resolveTimeZone(Object value) {
        return ComponentUtils.resolveTimeZone(value, null);
    }

    public static TimeZone resolveTimeZone(Object value, TimeZone defaultValue) {
        return value != null ? (TimeZone)value : defaultValue;
    }

    public static Locale resolveLocale(Object value) {
        return ComponentUtils.resolveLocale(value, null);
    }

    public static Locale resolveLocale(Object value, Locale defaultValue) {
        return value != null ? (Locale)value : defaultValue;
    }

    public static Throwable unwrap(Throwable t) {
        Throwable unwrap;
        while ((unwrap = t.getCause()) != null) {
            t = unwrap;
        }
        return t;
    }

    public static UIComponent findRelativeComponent(UIComponent from, String scopedId) {
        UIComponent found;
        int colonCount;
        if (from == null) {
            return null;
        }
        UIComponent originalFrom = from;
        String originalRelativeId = scopedId;
        int idLength = scopedId.length();
        for (colonCount = 0; colonCount < idLength && scopedId.charAt(colonCount) == ':'; ++colonCount) {
        }
        if (colonCount > 1) {
            scopedId = scopedId.substring(colonCount);
            if (!(from instanceof NamingContainer)) {
                from = ComponentUtils._getParentNamingContainerOrViewRoot(from);
            }
            for (int j = 1; j < colonCount; ++j) {
                from = ComponentUtils._getParentNamingContainerOrViewRoot(from);
            }
        }
        if ((found = from.findComponent(scopedId)) != null) {
            return found;
        }
        if (!(originalFrom instanceof NamingContainer)) {
            return ComponentUtils._findRelativeComponentDeprecated(originalFrom, originalRelativeId);
        }
        return null;
    }

    public static String getScopedIdForComponent(UIComponent targetComponent, UIComponent baseComponent) {
        String targetComponentId = targetComponent.getId();
        if (targetComponent == null || targetComponentId == null || targetComponentId.length() == 0) {
            return null;
        }
        if (targetComponent.equals(baseComponent)) {
            return targetComponentId;
        }
        StringBuilder builder = new StringBuilder(100);
        if (baseComponent instanceof UIViewRoot) {
            builder.append(':');
        }
        ComponentUtils._buildScopedId(targetComponent, baseComponent, builder);
        return builder.toString();
    }

    private static void _buildScopedId(UIComponent targetComponent, UIComponent baseComponent, StringBuilder builder) {
        UIComponent namingContainer = ComponentUtils._getParentNamingContainer(targetComponent, baseComponent);
        if (namingContainer != null) {
            ComponentUtils._buildScopedId(namingContainer, baseComponent, builder);
            builder.append(':');
        }
        builder.append(targetComponent.getId());
    }

    private static UIComponent _getParentNamingContainer(UIComponent component, UIComponent baseComponent) {
        UIComponent checkedParent;
        for (checkedParent = component.getParent(); checkedParent != null && !(checkedParent instanceof NamingContainer); checkedParent = checkedParent.getParent()) {
            if (checkedParent != baseComponent) continue;
            return null;
        }
        return checkedParent;
    }

    private static UIComponent _getParentNamingContainerOrViewRoot(UIComponent from) {
        while (from.getParent() != null && !((from = from.getParent()) instanceof NamingContainer)) {
        }
        return from;
    }

    private static UIComponent _findRelativeComponentDeprecated(UIComponent from, String relativeId) {
        UIComponent found;
        int colonCount;
        UIComponent originalFrom = from;
        String originalRelativeId = relativeId;
        int idLength = relativeId.length();
        for (colonCount = 0; colonCount < idLength && relativeId.charAt(colonCount) == ':'; ++colonCount) {
        }
        if (colonCount > 1) {
            relativeId = relativeId.substring(colonCount);
            for (int j = 1; j < colonCount; ++j) {
                while (from.getParent() != null && !((from = from.getParent()) instanceof NamingContainer)) {
                }
            }
        }
        if ((found = from.findComponent(relativeId)) != null) {
            _LOG.warning("DEPRECATED_RELATIVE_ID_SYNTAX", new Object[]{originalRelativeId, originalFrom});
        }
        return found;
    }
}

