/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesBeanFactory {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FacesBeanFactory.class);
    private static Map<Object, Object> _TYPES_MAP;
    private static Map<String, Class<?>> _TYPES_CLASS;
    private static final ThreadLocal<StringBuilder> _STRING_BUILDER;

    public static FacesBean createFacesBean(Class<?> ownerClass, String rendererType) {
        if (ownerClass == null) {
            return null;
        }
        String className = ownerClass.getName();
        FacesBean bean = FacesBeanFactory.createFacesBean(className, rendererType);
        if (bean == null && rendererType != null) {
            bean = FacesBeanFactory.createFacesBean(className, null);
            FacesBeanFactory._cacheFacesBeanClass(bean, className, rendererType);
        }
        if (bean == null) {
            bean = FacesBeanFactory.createFacesBean(ownerClass.getSuperclass(), rendererType);
            FacesBeanFactory._cacheFacesBeanClass(bean, className, rendererType);
        }
        return bean;
    }

    public static FacesBean createFacesBean(String beanType, String rendererType) {
        String typeKey = FacesBeanFactory._buildTypeKey(beanType, rendererType);
        Class<?> type = _TYPES_CLASS.get(typeKey);
        if (type == null) {
            String className = (String)_TYPES_MAP.get(typeKey);
            if (className == null) {
                return null;
            }
            try {
                type = FacesBeanFactory._getClassLoader().loadClass(className);
                _TYPES_CLASS.put(typeKey, type);
            }
            catch (ClassNotFoundException cnfe) {
                _LOG.severe("CANNOT_FIND_FACESBEAN", className);
                _LOG.severe(cnfe);
            }
        }
        try {
            return (FacesBean)type.newInstance();
        }
        catch (IllegalAccessException iae) {
            _LOG.severe("CANNOT_CREATE_FACESBEAN_INSTANCE", type.getName());
            _LOG.severe(iae);
        }
        catch (InstantiationException ie) {
            _LOG.severe("CANNOT_CREATE_FACESBEAN_INSTANCE", type.getName());
            _LOG.severe(ie);
        }
        return null;
    }

    private static void _initializeBeanTypes() {
        _TYPES_MAP = new HashMap<Object, Object>();
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> en = FacesBeanFactory._getClassLoader().getResources("META-INF/faces-bean.properties");
            while (en.hasMoreElements()) {
                list.add(en.nextElement());
            }
            Collections.reverse(list);
        }
        catch (IOException ioe) {
            _LOG.severe(ioe);
            return;
        }
        if (list.isEmpty() && _LOG.isInfo()) {
            _LOG.info("NO_FACES_BEAN_PROPERTIES_FILES_LOCATED");
        }
        for (URL url : list) {
            FacesBeanFactory._initializeBeanTypes(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _initializeBeanTypes(URL url) {
        try {
            Properties properties = new Properties();
            InputStream is = url.openStream();
            try {
                properties.load(is);
                if (_LOG.isFine()) {
                    _LOG.fine("Loading bean factory info from " + url);
                }
                _TYPES_MAP.putAll(properties);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe) {
            _LOG.severe("CANNOT_LOAD_URL", url);
            _LOG.severe(ioe);
        }
    }

    private static ClassLoader _getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = FacesBeanFactory.class.getClassLoader();
        }
        return loader;
    }

    private static String _buildTypeKey(String beanType, String rendererType) {
        if (rendererType != null) {
            StringBuilder typeKeyBuilder = FacesBeanFactory._getSharedStringBuilder();
            typeKeyBuilder.append(beanType).append('|').append(rendererType);
            return typeKeyBuilder.toString();
        }
        return beanType;
    }

    private static void _cacheFacesBeanClass(FacesBean bean, String beanType, String rendererType) {
        if (bean != null) {
            String typeKey = FacesBeanFactory._buildTypeKey(beanType, rendererType);
            _TYPES_CLASS.put(typeKey, bean.getClass());
        }
    }

    private static StringBuilder _getSharedStringBuilder() {
        StringBuilder sb = _STRING_BUILDER.get();
        if (sb == null) {
            sb = new StringBuilder();
            _STRING_BUILDER.set(sb);
        }
        sb.setLength(0);
        return sb;
    }

    static {
        _TYPES_CLASS = new ConcurrentHashMap();
        _STRING_BUILDER = new ThreadLocal();
        FacesBeanFactory._initializeBeanTypes();
    }
}

