/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;
import org.apache.myfaces.trinidadinternal.share.config.Configuration;
import org.apache.myfaces.trinidadinternal.share.url.FormEncoder;
import org.apache.myfaces.trinidadinternal.style.ParsedPropertyKey;
import org.apache.myfaces.trinidadinternal.style.Style;
import org.apache.myfaces.trinidadinternal.style.StyleMap;
import org.apache.myfaces.trinidadinternal.style.util.StyleUtils;
import org.apache.myfaces.trinidadinternal.ui.AttributeKey;
import org.apache.myfaces.trinidadinternal.ui.MutableUINode;
import org.apache.myfaces.trinidadinternal.ui.NodeUtils;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.BaseLafUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.MutableProperty;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.FormValueRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class XhtmlLafUtils
extends BaseLafUtils {
    private static HashMap<String, String> _sSizeNameMap;
    private static final String[] _FONT_SIZE_NAME_MAPPING;
    private static final String[] _VALIGNS_SUPPORTED;
    private static final String[] _SIZE_MAPPING;
    private static final int _STRIP_STATE_START = 0;
    private static final int _STRIP_STATE_SLASH = 1;
    private static final int _STRIP_STATE_COMMENT = 2;
    private static final int _STRIP_STATE_STAR = 3;
    private static final Object _STYLE_INFO_PROPERTY;
    private static final int _STACK_FLAGS_INDEX = 0;
    private static final int _FONT_FACE_INDEX = 1;
    private static final int _FONT_SIZE_INDEX = 2;
    private static final int _FOREGROUND_INDEX = 3;
    private static final int _ITALIC_INDEX = 4;
    private static final int _BOLD_INDEX = 5;
    private static final int _STYLE_INFO_STACK_COUNT = 6;
    private static final String[] _STYLE_ELEMENTS;
    private static final Object[] _STYLE_DEFAULTS;
    private static Map<String, String> _sSupportedVAligns;
    private static final String _GIF_ENABLED = "gifEnabled";
    private static final Object _CURRENT_RENDERING_CONTEXT_PROPERTY;
    private static final Object _STYLE_CLASSES_PROPERTY;
    private static final Object _NULL_STYLE_CLASSES;
    private static final TrinidadLogger _LOG;

    protected XhtmlLafUtils() {
    }

    public static void copyAttr(UIXRenderingContext context, UINode sourceNode, AttributeKey attrKey, MutableUINode destNode) {
        Object value = sourceNode.getAttributeValue(context, attrKey);
        if (value != null) {
            destNode.setAttributeValue(attrKey, value);
        }
    }

    public static void registerScriptlet(Object key, Scriptlet scriptlet) {
        XhtmlUtils.registerScriptlet(key, scriptlet);
    }

    public static String encodeJSEventObject(UIXRenderingContext context, String formName, Iterator<Object> keyValues, int keyValueSize) {
        if (keyValues == null || !keyValues.hasNext()) {
            return null;
        }
        if (keyValueSize < 20) {
            keyValueSize = 20;
        }
        StringBuilder jsObject = new StringBuilder(keyValueSize + 2);
        jsObject.append('{');
        FormEncoder formEncoder = context.getFormEncoder();
        boolean isFirstKeyValue = true;
        try {
            do {
                if (isFirstKeyValue) {
                    isFirstKeyValue = false;
                } else {
                    jsObject.append(',');
                }
                Object key = keyValues.next();
                Object value = keyValues.next();
                if (key == null) continue;
                String keyString = key.toString();
                jsObject.append('\'');
                jsObject.append(keyString);
                jsObject.append('\'');
                FormValueRenderer.addNeededValue(context, formName, keyString);
                jsObject.append(':');
                jsObject.append('\'');
                if (value != null) {
                    String encodedValue = XhtmlLafUtils.getFormEncodedParameter(formEncoder, formName, keyString, value);
                    jsObject.append(encodedValue);
                }
                jsObject.append('\'');
            } while (keyValues.hasNext());
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(_LOG.getMessage("NUMBER_OF_KEYS_AND_VALUES_MUCH_MATCH"));
        }
        jsObject.append('}');
        return jsObject.toString();
    }

    public static String encodeJSEventObject(UIXRenderingContext context, String formName, Object[] keyValues) {
        int keyValueSize = XhtmlLafUtils.getKeyValueArraySize(keyValues, 5);
        if (keyValueSize > 0) {
            return XhtmlLafUtils.encodeJSEventObject(context, formName, Arrays.asList(keyValues).iterator(), keyValueSize);
        }
        return null;
    }

    public static Style getClassStyle(UIXRenderingContext context, Object className) {
        StyleMap map;
        if (className != null && (map = context.getStyleContext().getStyleMap()) != null) {
            return map.getStyleByClass(context.getStyleContext(), className.toString());
        }
        return null;
    }

    public static String getClassStyleProperty(UIXRenderingContext context, Object className, String propertyName) {
        Style classStyle = XhtmlLafUtils.getClassStyle(context, className);
        if (classStyle != null) {
            return classStyle.getProperty(propertyName);
        }
        return null;
    }

    public static Object getShortStyleClass(UIXRenderingContext context, Object styleClass) {
        String styleClassKey;
        if (styleClass == null) {
            return null;
        }
        styleClass = context.getStyleClass(styleClass.toString());
        Object styleClasses = context.getProperty("http://myfaces.apache.org/uix/ui", _STYLE_CLASSES_PROPERTY);
        if (styleClasses == null) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            styleClasses = context.getSkin().getStyleClassMap(arc);
            if (styleClasses == null) {
                styleClasses = _NULL_STYLE_CLASSES;
            }
            context.setProperty("http://myfaces.apache.org/uix/ui", _STYLE_CLASSES_PROPERTY, styleClasses);
        }
        Object shortStyleClass = null;
        if (styleClasses != _NULL_STYLE_CLASSES && (shortStyleClass = ((Map)styleClasses).get(styleClassKey = styleClass.toString())) != null) {
            styleClass = shortStyleClass;
        }
        if (shortStyleClass == null) {
            styleClass = StyleUtils.convertToValidSelector(styleClass.toString());
        }
        return styleClass;
    }

    public static String mapVerticalAlignToVAlign(UIXRenderingContext context, String verticalAlign) {
        if (verticalAlign != null) {
            return _sSupportedVAligns.get(verticalAlign);
        }
        return null;
    }

    public static void endRenderingStyleElements(UIXRenderingContext context) throws IOException {
        Stack[] styleInfo = XhtmlLafUtils._getStyleInfo(context);
        Stack styleFlagsStack = styleInfo[0];
        int styleFlags = (Integer)styleFlagsStack.pop();
        if (styleFlags != 0) {
            ResponseWriter writer = context.getResponseWriter();
            boolean fontEnded = false;
            for (int i = 5; i > 0; --i) {
                if ((styleFlags & 1 << i) == 0) continue;
                styleInfo[i].pop();
                if (fontEnded) continue;
                writer.endElement(_STYLE_ELEMENTS[i]);
                if (i > 3) continue;
                fontEnded = true;
            }
        }
    }

    public static void startRenderingStyleElements(UIXRenderingContext context, Style inlineStyle, Style classStyle) throws IOException {
        Stack[] styleInfo = XhtmlLafUtils._getStyleInfo(context);
        int flags = 0;
        if (inlineStyle != null || classStyle != null) {
            int currFlag;
            Object fontStyle = XhtmlLafUtils._getParsedStyleProperty(inlineStyle, classStyle, Style.FONT_STYLE_KEY);
            Boolean isItalic = Style.ITALIC_FONT_STYLE == fontStyle ? Boolean.TRUE : null;
            Object fontWeight = XhtmlLafUtils._getParsedStyleProperty(inlineStyle, classStyle, Style.FONT_WEIGHT_KEY);
            Boolean isBold = Style.BOLD_FONT_WEIGHT == fontWeight ? Boolean.TRUE : null;
            String fontFamilies = null;
            String foreground = null;
            String fontSize = XhtmlLafUtils.getStyleProperty(inlineStyle, classStyle, "font-size");
            foreground = XhtmlLafUtils.getStyleProperty(inlineStyle, classStyle, "color");
            fontFamilies = XhtmlLafUtils.getStyleProperty(inlineStyle, classStyle, "font-family");
            boolean hasFontElement = fontSize != null || foreground != null || fontFamilies != null;
            ResponseWriter writer = context.getResponseWriter();
            if (hasFontElement) {
                int fontFlags = 0;
                fontFlags |= XhtmlLafUtils._pushStackProperty(styleInfo, 3, foreground);
                fontFlags |= XhtmlLafUtils._pushStackProperty(styleInfo, 1, fontFamilies);
                String sizeAttr = fontSize;
                if (fontSize != null) {
                    Integer pixelSize;
                    sizeAttr = _sSizeNameMap.get(fontSize);
                    if (sizeAttr == null && (pixelSize = (Integer)XhtmlLafUtils._getParsedStyleProperty(inlineStyle, classStyle, Style.FONT_SIZE_KEY)) != null) {
                        int pixSize = pixelSize;
                        sizeAttr = pixSize > _SIZE_MAPPING.length ? _SIZE_MAPPING[_SIZE_MAPPING.length - 1] : _SIZE_MAPPING[pixSize];
                    }
                    fontFlags |= XhtmlLafUtils._pushStackProperty(styleInfo, 2, sizeAttr);
                }
                if (fontFlags != 0) {
                    writer.startElement("font", null);
                    if ((fontFlags & 8) != 0) {
                        writer.writeAttribute("color", (Object)foreground, null);
                    }
                    if ((fontFlags & 2) != 0) {
                        writer.writeAttribute("face", (Object)fontFamilies, null);
                    }
                    if ((fontFlags & 4) != 0) {
                        writer.writeAttribute("size", (Object)sizeAttr, null);
                    }
                    flags |= fontFlags;
                }
            }
            if ((currFlag = XhtmlLafUtils._pushStackProperty(styleInfo, 4, isItalic)) != 0) {
                flags |= currFlag;
                writer.startElement(_STYLE_ELEMENTS[4], null);
            }
            if ((currFlag = XhtmlLafUtils._pushStackProperty(styleInfo, 5, isBold)) != 0) {
                flags |= currFlag;
                writer.startElement(_STYLE_ELEMENTS[5], null);
            }
        }
        Stack<Object> stackInfo = XhtmlLafUtils._getStyleInfoStack(styleInfo, 0);
        stackInfo.push(flags);
    }

    private static Object _getParsedStyleProperty(Style style1, Style style2, ParsedPropertyKey stylePropertyKey) {
        Object value;
        Object object = value = style1 != null ? style1.getParsedProperty(stylePropertyKey) : null;
        if (value != null) {
            return value;
        }
        if (style2 != null) {
            return style2.getParsedProperty(stylePropertyKey);
        }
        return null;
    }

    public static String getStyleProperty(Style style1, Style style2, String stylePropertyName) {
        String value;
        String string = value = style1 != null ? style1.getProperty(stylePropertyName) : null;
        if (value != null) {
            return value;
        }
        if (style2 != null) {
            return style2.getProperty(stylePropertyName);
        }
        return null;
    }

    public static String createCompoundName(UIXRenderingContext context, String formName, Object keyValues) {
        return XhtmlLafUtils.createCompoundName(context, formName, keyValues, null);
    }

    public static String createCompoundName(UIXRenderingContext context, String formName, Object keyValues, Object keyExchanges) {
        String compoundName = XhtmlLafUtils.encodeCompoundKeyValues((Object[])keyValues, (Object[])keyExchanges);
        if (compoundName != null) {
            FormValueRenderer.addNeededValue(context, formName, "_compNm");
        }
        return compoundName;
    }

    public static Object getChainedJS(Object evh1, Object evh2, boolean shortCircuit) {
        String evh1String = evh1 == null ? null : evh1.toString();
        String evh2String = evh2 == null ? null : evh2.toString();
        return XhtmlUtils.getChainedJS(evh1String, evh2String, shortCircuit);
    }

    public static String escapeJS(String inString) {
        return XhtmlUtils.escapeJS(inString);
    }

    public static String escapeJS(String inString, boolean inQuotes) {
        return XhtmlUtils.escapeJS(inString, inQuotes);
    }

    public static void escapeJS(StringBuilder outBuffer, String inString) {
        XhtmlUtils.escapeJS(outBuffer, inString);
    }

    public static void escapeJS(StringBuilder outBuffer, String inString, boolean inQuotes) {
        XhtmlUtils.escapeJS(outBuffer, inString, inQuotes);
    }

    public static void escapeJS(StringBuilder outBuffer, String inString, boolean inQuotes, int escapeCount) {
        XhtmlUtils.escapeJS(outBuffer, inString, inQuotes, escapeCount);
    }

    public static void addOnSubmitRequiredValidator(UIXRenderingContext context, UINode node, String requiredMessageKey, Object nodeName) throws IOException {
        Object disabled;
        boolean requiredField = Boolean.TRUE.equals(node.getAttributeValue(context, REQUIRED_ATTR));
        if (requiredField && !Boolean.TRUE.equals(disabled = node.getAttributeValue(context, DISABLED_ATTR))) {
            if (nodeName != null) {
                UIComponent component = NodeUtils.getUIComponent(context, node);
                if (component == null) {
                    _LOG.warning("NULL_COMPONENT_FOR_NODE", (Object)node.getLocalName());
                }
                boolean unvalidated = Boolean.TRUE.equals(node.getAttributeValue(context, UIConstants.UNVALIDATED_ATTR));
                FormRenderer.addOnSubmitConverterValidators(component, null, null, nodeName.toString(), unvalidated, true, requiredMessageKey);
            } else {
                _LOG.warning("NULL_NODE_NAME_NO_VALIDATOR_ADDED", (Object)node.getLocalName());
            }
        }
    }

    public static void addLib(UIXRenderingContext context, Object libKey) throws IOException {
        XhtmlUtils.addLib(context.getFacesContext(), RenderingContext.getCurrentInstance(), libKey);
    }

    public static void writeLibImport(UIXRenderingContext context, Object libURL) throws IOException {
        XhtmlUtils.writeLibImport(context.getFacesContext(), RenderingContext.getCurrentInstance(), libURL);
    }

    public static String[] getPartialTargets(UIXRenderingContext context, UINode node) {
        return XhtmlLafUtils.getPartialTargets(context, node, null);
    }

    public static String[] getPartialTargets(UIXRenderingContext context, UINode node, Object id) {
        Object mode;
        if (!XhtmlLafRenderer.supportsPartialRendering(context)) {
            return null;
        }
        if (!PartialPageUtils.isPPRActive(context.getFacesContext())) {
            return null;
        }
        if (id == null) {
            id = node.getAttributeValue(context, ID_ATTR);
        }
        if ("self".equals(mode = node.getAttributeValue(context, PARTIAL_RENDER_MODE_ATTR))) {
            if (id == null) {
                return null;
            }
            return new String[]{id.toString()};
        }
        return null;
    }

    public static String getFirePartialChangeHandler(String destination) {
        return AutoSubmitUtils.getPartialGetScript(destination);
    }

    public static boolean supportsTransparentImages(UIXRenderingContext context) {
        TrinidadAgent agent = context.getAgent();
        if (5 == agent.getAgentApplication()) {
            return false;
        }
        if (agent.getCapability(TrinidadAgent.CAP_TRANSPARENT_PNG_TYPE_IMAGE) == Boolean.TRUE) {
            return true;
        }
        Configuration config = context.getConfiguration();
        return agent.getCapability(TrinidadAgent.CAP_GIF_TYPE_IMAGE) == Boolean.TRUE && !Boolean.FALSE.equals(config.getProperty(_GIF_ENABLED));
    }

    public static void renderIcon(UIXRenderingContext context, Icon icon, Object shortDesc, Object align) throws IOException {
        XhtmlLafUtils.renderIcon(context, icon, shortDesc, align, false);
    }

    public static void renderIcon(UIXRenderingContext context, Icon icon, Object shortDesc, Object align, boolean embedded) throws IOException {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        FacesContext fContext = context.getFacesContext();
        OutputUtils.renderIcon(fContext, arc, icon, shortDesc, align, embedded);
    }

    public static Object getMiddleIconAlignment(UIXRenderingContext context) {
        String align = null;
        int agentApplication = context.getAgent().getAgentApplication();
        align = agentApplication == 1 ? "top" : "middle";
        return align;
    }

    public static Object getFormEncodedValue(UIXRenderingContext context, Object transName, Object value) {
        FormEncoder formEncoder = context.getFormEncoder();
        return formEncoder.encodeFormValue(transName, value);
    }

    public static String getFormEncodedParameter(FormEncoder formEncoder, Object formName, Object transName, Object value) {
        Object encoded = formEncoder.encodeClientParameter(formName, transName, value);
        return encoded != null ? encoded.toString() : null;
    }

    public static boolean isReadOnly(UIXRenderingContext context, UINode node) {
        Object readOnly = node.getAttributeValue(context, READ_ONLY_ATTR);
        return Boolean.TRUE.equals(readOnly);
    }

    static StringBuilder __stripJSComments(StringBuilder buffer) {
        StringBuilder strippedBuffer = null;
        int state = 0;
        int startIndex = 0;
        int length = buffer.length();
        block6: for (int i = 0; i < length; ++i) {
            char c = buffer.charAt(i);
            switch (state) {
                case 0: {
                    if (c != '/') continue block6;
                    state = 1;
                    continue block6;
                }
                case 1: {
                    if (c == '*') {
                        state = 2;
                        if (strippedBuffer == null) {
                            strippedBuffer = new StringBuilder(length);
                        }
                        strippedBuffer.append(buffer.substring(startIndex, i - 1));
                        continue block6;
                    }
                    state = 0;
                    continue block6;
                }
                case 2: {
                    if (c != '*') continue block6;
                    state = 3;
                    continue block6;
                }
                case 3: {
                    if (c == '/') {
                        state = 0;
                        startIndex = i + 1;
                        continue block6;
                    }
                    state = 2;
                }
            }
        }
        assert (state == 0);
        if (strippedBuffer != null) {
            if (state == 0) {
                strippedBuffer.append(buffer.substring(startIndex, length));
            }
            return strippedBuffer;
        }
        return buffer;
    }

    static void __pushCurrentRenderingContext(UIXRenderingContext context) {
        assert (context != null);
        Stack<UIXRenderingContext> stack = (Stack<UIXRenderingContext>)context.getProperty("http://myfaces.apache.org/uix/ui", _CURRENT_RENDERING_CONTEXT_PROPERTY);
        if (stack == null) {
            stack = new Stack<UIXRenderingContext>();
            context.setProperty("http://myfaces.apache.org/uix/ui", _CURRENT_RENDERING_CONTEXT_PROPERTY, stack);
        }
        stack.push(context);
    }

    static void __popCurrentRenderingContext(UIXRenderingContext context) {
        Stack stack = (Stack)context.getProperty("http://myfaces.apache.org/uix/ui", _CURRENT_RENDERING_CONTEXT_PROPERTY);
        assert (stack != null);
        stack.pop();
    }

    static UIXRenderingContext __getCurrentRenderingContext(UIXRenderingContext context) {
        Stack stack = (Stack)context.getProperty("http://myfaces.apache.org/uix/ui", _CURRENT_RENDERING_CONTEXT_PROPERTY);
        if (stack == null || stack.empty()) {
            return null;
        }
        return (UIXRenderingContext)stack.peek();
    }

    private static int _pushStackProperty(Stack[] styleInfo, int stackIndex, Object value) {
        if (value != null) {
            Stack<Object> styleInfoStack = XhtmlLafUtils._getStyleInfoStack(styleInfo, stackIndex);
            styleInfoStack.push(value);
            return 1 << stackIndex;
        }
        return 0;
    }

    private static Stack<Object> _getStyleInfoStack(Stack[] styleInfo, int stackIndex) {
        Stack<Object> styleInfoStack = styleInfo[stackIndex];
        if (styleInfoStack == null) {
            styleInfoStack = new Stack<Object>();
            styleInfoStack.push(_STYLE_DEFAULTS[stackIndex]);
            styleInfo[stackIndex] = styleInfoStack;
        }
        return styleInfoStack;
    }

    private static Stack[] _getStyleInfo(UIXRenderingContext context) {
        StyleInfo styleInfo = (StyleInfo)XhtmlLafUtils.getRenderingProperty(context, _STYLE_INFO_PROPERTY);
        if (styleInfo == null) {
            styleInfo = new StyleInfo();
            XhtmlLafUtils.setRenderingProperty(context, _STYLE_INFO_PROPERTY, styleInfo);
        }
        return styleInfo.getValue();
    }

    static {
        int i;
        _sSizeNameMap = new HashMap(13);
        _FONT_SIZE_NAME_MAPPING = new String[]{"xx-small", "1", "x-small", "2", "small", "3", "medium", "4", "large", "5", "x-large", "6", "xx-large", "7", "smaller", "-1", "larger", "+1"};
        _VALIGNS_SUPPORTED = new String[]{"baseline", "top", "center", "middle", "bottom"};
        _SIZE_MAPPING = new String[]{"1", "1", "1", "1", "1", "1", "1", "1", "1", "2", "3", "4", "4", "4", "5", "5", "6", "6", "7"};
        _STYLE_INFO_PROPERTY = new Object();
        _STYLE_ELEMENTS = new String[]{null, "font", "font", "font", "i", "b"};
        _STYLE_DEFAULTS = new Object[]{null, "", "3", "#000000", Boolean.FALSE, Boolean.FALSE};
        _sSupportedVAligns = null;
        for (i = 0; i < _FONT_SIZE_NAME_MAPPING.length; i += 2) {
            _sSizeNameMap.put(_FONT_SIZE_NAME_MAPPING[i], _FONT_SIZE_NAME_MAPPING[i + 1]);
        }
        _sSupportedVAligns = new HashMap<String, String>(13);
        for (i = 0; i < _VALIGNS_SUPPORTED.length; ++i) {
            _sSupportedVAligns.put(_VALIGNS_SUPPORTED[i], _VALIGNS_SUPPORTED[i]);
        }
        _CURRENT_RENDERING_CONTEXT_PROPERTY = new Object();
        _STYLE_CLASSES_PROPERTY = new Object();
        _NULL_STYLE_CLASSES = new Object();
        _LOG = TrinidadLogger.createTrinidadLogger(XhtmlLafUtils.class);
    }

    @Deprecated
    private static final class StyleInfo
    implements MutableProperty {
        private final Stack[] _value;

        public StyleInfo() {
            this(new Stack[6]);
        }

        public StyleInfo(Stack[] value) {
            this._value = value;
        }

        public Stack[] getValue() {
            return this._value;
        }

        public Object clone() {
            int length = this._value.length;
            Stack[] newValue = new Stack[length];
            for (int i = 0; i < length; ++i) {
                if (this._value[i] == null) continue;
                newValue[i] = (Stack)this._value[i].clone();
            }
            return new StyleInfo(newValue);
        }
    }
}

