/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.taglib;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.webapp.ELContextTag;
import org.apache.myfaces.trinidadinternal.el.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForEachTag
extends TagSupport
implements ELContextTag {
    private int _currentBegin;
    private int _currentIndex;
    private int _currentEnd;
    private int _currentStep;
    private int _currentCount;
    private boolean _isFirst;
    private boolean _isLast;
    private ELContextTag _parentELContext;
    private String _items;
    private String _begin;
    private String _end;
    private String _step;
    private String _var;
    private String _varStatus;
    private Map<String, Object> _propertyReplacementMap;
    private String _varReplacement;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ForEachTag.class);

    public void setItems(String items) {
        if (!items.startsWith("#{") || !items.endsWith("}")) {
            throw new IllegalArgumentException(_LOG.getMessage("MUST_BE_SIMPLE_JSF_EL_EXPRESSION"));
        }
        this._items = items;
    }

    public void setBegin(String begin) {
        this._begin = begin;
    }

    public void setEnd(String end) {
        this._end = end;
    }

    public void setStep(String step) {
        this._step = step;
    }

    public void setVar(String var) {
        if (UIComponentTag.isValueReference((String)var)) {
            throw new IllegalArgumentException(_LOG.getMessage("VAR_CANNOT_BE_EXPRESSION"));
        }
        this._var = var;
    }

    public void setVarStatus(String varStatus) {
        if (UIComponentTag.isValueReference((String)varStatus)) {
            throw new IllegalArgumentException(_LOG.getMessage("VARSTATUS_CANNOT_BE_EXPRESSION"));
        }
        this._varStatus = varStatus;
    }

    public int doStartTag() throws JspException {
        this._validateAttributes();
        FacesContext context = FacesContext.getCurrentInstance();
        this._parentELContext = (ELContextTag)ForEachTag.findAncestorWithClass((Tag)this, ELContextTag.class);
        this._currentBegin = this._resolveInteger(context, this._begin, 0);
        if (null != this._items) {
            int length;
            Object items = this._resolveObject(context, this._items);
            if (items == null) {
                if (_LOG.isFine()) {
                    _LOG.fine("Items expression " + this._items + " resolved to null.");
                }
                return 0;
            }
            if (items instanceof List) {
                length = ((List)items).size();
            } else if (items.getClass().isArray()) {
                length = Array.getLength(items);
            } else {
                throw new JspException(_LOG.getMessage("MUST_POINT_TO_LIST_OR_ARRAY"));
            }
            if (length == 0) {
                if (_LOG.isFine()) {
                    _LOG.fine("Items found at " + this._items + " is empty.");
                }
                return 0;
            }
            if (length < this._currentBegin) {
                if (_LOG.isFine()) {
                    _LOG.fine("Size of 'items' is less than 'begin'");
                }
                return 0;
            }
            this._currentEnd = this._resolveInteger(context, this._end, length - 1);
            if (length < this._currentEnd) {
                this._currentEnd = length - 1;
            }
        } else {
            this._currentEnd = this._resolveInteger(context, this._end, 0);
        }
        this._currentIndex = this._currentBegin;
        this._currentStep = this._resolveInteger(context, this._step, 1);
        this._validateRangeAndStep();
        if (this._currentEnd < this._currentIndex) {
            return 0;
        }
        if (null != this._var || null != this._varStatus) {
            String string = this._varReplacement = null == this._items ? String.valueOf(this._currentIndex) : this._items.substring(2, this._items.length() - 1) + "[" + this._currentIndex + "]";
        }
        if (null != this._varStatus) {
            this._updateLoopStatus();
            this._propertyReplacementMap = new HashMap<String, Object>(9, 1.0f);
            this._propertyReplacementMap.put("begin", this._currentBegin);
            this._propertyReplacementMap.put("end", this._currentEnd);
            this._propertyReplacementMap.put("step", this._currentStep);
            this._propertyReplacementMap.put("count", this._currentCount);
            this._propertyReplacementMap.put("index", this._currentIndex);
            this._propertyReplacementMap.put("current", this._varReplacement);
            this._propertyReplacementMap.put("first", this._isFirst ? Boolean.TRUE : Boolean.FALSE);
            this._propertyReplacementMap.put("last", this._isLast ? Boolean.TRUE : Boolean.FALSE);
        }
        if (_LOG.isFiner()) {
            _LOG.finer("Iterating from " + this._currentIndex + " to " + this._currentEnd + " by " + this._currentStep);
        }
        return 1;
    }

    public int doAfterBody() {
        this._currentIndex += this._currentStep;
        if (null != this._var || null != this._varStatus) {
            String string = this._varReplacement = null == this._items ? String.valueOf(this._currentIndex) : this._items.substring(2, this._items.length() - 1) + "[" + this._currentIndex + "]";
        }
        if (null != this._varStatus) {
            boolean isSecondIteration = this._isFirst;
            this._updateLoopStatus();
            if (isSecondIteration) {
                this._propertyReplacementMap.put("first", this._isFirst ? Boolean.TRUE : Boolean.FALSE);
            }
            if (this._isLast) {
                this._propertyReplacementMap.put("last", this._isLast ? Boolean.TRUE : Boolean.FALSE);
            }
            this._propertyReplacementMap.put("count", this._currentCount);
            this._propertyReplacementMap.put("index", this._currentIndex);
            this._propertyReplacementMap.put("current", this._varReplacement);
        }
        if (this._currentEnd < this._currentIndex) {
            return 0;
        }
        return 2;
    }

    public String transformId(String id) {
        if (this._parentELContext != null) {
            id = this._parentELContext.transformId(id);
        }
        return id + '_' + this._currentIndex;
    }

    static String __transformExpression(String expression, String var, String subst) {
        String varDot = var + ".";
        Tokenizer tokens = new Tokenizer(expression);
        StringBuffer buf = new StringBuffer(expression.length());
        while (tokens.hasNext()) {
            Tokenizer.Token tok = tokens.next();
            String exp = tok.getText();
            if (tok.type == 600 && (var.equals(exp) || exp.startsWith(varDot))) {
                buf.append(subst);
                buf.append(exp.substring(var.length()));
                continue;
            }
            buf.append(exp);
        }
        return buf.toString();
    }

    public String transformExpression(String expression) {
        if (expression != null) {
            String transformedExp = expression;
            int expressionStart = expression.indexOf("#{");
            if (expressionStart >= 0) {
                transformedExp = this._transformExpression(expression);
                if (this._parentELContext != null) {
                    transformedExp = this._parentELContext.transformExpression(transformedExp);
                }
            }
            if (_LOG.isFiner()) {
                _LOG.finer("Transformed expression:{0} to:{1}", (Object[])new String[]{expression, transformedExp});
            }
            return transformedExp;
        }
        return null;
    }

    public void release() {
        super.release();
        this._begin = null;
        this._end = null;
        this._end = null;
        this._items = null;
        this._step = null;
        this._var = null;
        this._varStatus = null;
    }

    protected ValueBinding createValueBinding(FacesContext context, String expression) {
        if (this._parentELContext != null) {
            expression = this._parentELContext.transformExpression(expression);
        }
        return context.getApplication().createValueBinding(expression);
    }

    private void _validateAttributes() throws JspTagException {
        if (null == this._items && (null == this._begin || null == this._end)) {
            throw new JspTagException("'begin' and 'end' should be specified if 'items' is not specified");
        }
        if (this._var != null && this._var.equals(this._varStatus)) {
            throw new JspTagException("'var' and 'varStatus' should not have same value");
        }
    }

    private void _validateRangeAndStep() throws JspTagException {
        if (this._currentBegin < 0) {
            throw new JspTagException("'begin' < 0");
        }
        if (this._currentStep < 1) {
            throw new JspTagException("'step' < 1");
        }
    }

    private String _transformExpression(String expression) {
        boolean doVarStatus;
        boolean doVar = this._var != null;
        boolean bl = doVarStatus = this._varStatus != null;
        if (!doVar && !doVarStatus) {
            return expression;
        }
        StringBuffer buf = new StringBuffer(expression.length());
        Tokenizer tokens = new Tokenizer(expression);
        String varDot = this._var + ".";
        String varStatusDot = this._varStatus + ".";
        while (tokens.hasNext()) {
            Tokenizer.Token tok = tokens.next();
            String text = tok.getText();
            if (tok.type == 600) {
                if (doVar && (this._var.equals(text) || text.startsWith(varDot))) {
                    text = this._replaceVariableAndPropertiesInExpression(text, this._var, this._varReplacement, null);
                } else if (doVarStatus && (this._varStatus.equals(text) || text.startsWith(varStatusDot))) {
                    text = this._replaceVariableAndPropertiesInExpression(text, this._varStatus, null, this._propertyReplacementMap);
                }
            }
            buf.append(text);
        }
        return buf.toString();
    }

    private String _replaceVariableAndPropertiesInExpression(String subExpression, String variable, String variableReplacement, Map<String, Object> propertyReplacementMap) {
        int variableLength = variable.length();
        if (null != propertyReplacementMap) {
            for (Map.Entry<String, Object> entry : propertyReplacementMap.entrySet()) {
                String property = entry.getKey();
                String expressionAfterVar = subExpression.substring(variableLength);
                if (!expressionAfterVar.startsWith("." + property)) continue;
                int propertyLength = property.length();
                int endOfReplacement = propertyLength + 1;
                if (expressionAfterVar.length() > endOfReplacement && Character.isLetterOrDigit(expressionAfterVar.charAt(endOfReplacement))) continue;
                String propertyReplacement = entry.getValue().toString();
                subExpression = this._replaceSubString(subExpression, 0, variableLength + propertyLength + 1, propertyReplacement);
                break;
            }
        } else {
            subExpression = this._replaceSubString(subExpression, 0, variableLength, variableReplacement);
        }
        return subExpression;
    }

    private String _replaceSubString(String str, int beginIndex, int noOfChars, String replacement) {
        StringBuffer buffer = new StringBuffer(str.length() + replacement.length() - noOfChars);
        buffer.append(str.substring(0, beginIndex));
        buffer.append(replacement);
        buffer.append(str.substring(beginIndex + noOfChars));
        return buffer.toString();
    }

    private void _updateLoopStatus() {
        this._currentCount = (this._currentIndex - this._currentBegin) / this._currentStep + 1;
        this._isFirst = this._currentIndex == this._currentBegin;
        this._isLast = this._currentIndex + this._currentStep > this._currentEnd;
    }

    private Object _resolveObject(FacesContext context, String expression) {
        ValueBinding vb = this.createValueBinding(context, expression);
        return vb.getValue(context);
    }

    private int _resolveInteger(FacesContext context, String expression, int defaultValue) {
        if (expression == null) {
            return defaultValue;
        }
        if (UIComponentTag.isValueReference((String)expression)) {
            Object o = this._resolveObject(context, expression);
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            if (o == null) {
                return defaultValue;
            }
            expression = o.toString();
        }
        return Integer.parseInt(expression);
    }
}

