/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.convert;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.myfaces.trinidadinternal.convert.GenericConverter;
import org.apache.myfaces.trinidadinternal.convert.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlConverter
extends GenericConverter {
    @Override
    public Object convert(Object source, Class<?> targetType) {
        Date jDate = (Date)source;
        if (targetType.isAssignableFrom(java.sql.Date.class)) {
            return new java.sql.Date(jDate.getTime());
        }
        if (targetType.isAssignableFrom(Time.class)) {
            return new Time(jDate.getTime());
        }
        if (targetType.isAssignableFrom(Timestamp.class)) {
            return new Timestamp(jDate.getTime());
        }
        throw new TypeConversionException(source, targetType);
    }

    @Override
    public List<Class<?>> getTargetTypes(Class<?> sourceType) {
        if (Date.class.isAssignableFrom(sourceType)) {
            ArrayList list = new ArrayList(3);
            list.add(java.sql.Date.class);
            list.add(Time.class);
            list.add(Timestamp.class);
            return list;
        }
        return Collections.emptyList();
    }
}

