/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.toggle;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.toggle.ToggleGroup;
import org.apache.myfaces.custom.toggle.ToggleLink;
import org.apache.myfaces.custom.toggle.TogglePanel;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlGroupRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.ResourceUtils;

@ResourceDependency(library="oam.custom.toggle", name="MyFacesToggleLink.js")
public class TogglePanelRenderer
extends HtmlGroupRendererBase {
    private static Log log = LogFactory.getLog(TogglePanelRenderer.class);
    private static final String LAYOUT_BLOCK_VALUE = "block";

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(context, component, TogglePanel.class);
        TogglePanel togglePanel = (TogglePanel)component;
        ResponseWriter writer = context.getResponseWriter();
        Map behaviors = null;
        behaviors = togglePanel.getClientBehaviors();
        if (!behaviors.isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(context, writer);
        }
        boolean toggleMode = togglePanel.isToggled();
        this.toggleVisibility(togglePanel.getChildren(), toggleMode);
        String hiddenFieldId = this.getHiddenFieldId(context, togglePanel);
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenFieldId, null);
        writer.writeAttribute("name", (Object)hiddenFieldId, null);
        writer.writeAttribute("value", (Object)(toggleMode ? "1" : ""), null);
        writer.endElement("input");
        boolean span = false;
        String layoutElement = "span";
        String layout = togglePanel.getLayout();
        if (layout != null && layout.equals(LAYOUT_BLOCK_VALUE)) {
            layoutElement = "div";
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            span = true;
            writer.startElement(layoutElement, component);
            writer.writeAttribute("id", (Object)component.getClientId(context), null);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.UNIVERSAL_ATTRIBUTES);
            HtmlRendererUtils.renderBehaviorizedEventHandlers(context, writer, component, behaviors);
        } else if (component.getId() != null && !component.getId().startsWith("j_id")) {
            span = true;
            writer.startElement(layoutElement, component);
            HtmlRendererUtils.writeIdIfNecessary(writer, component, context);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
        } else {
            span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, layoutElement, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
        }
        RendererUtils.renderChildren(context, component);
        if (span) {
            writer.endElement(layoutElement);
        }
    }

    private void toggleVisibility(List children, boolean toggleMode) {
        for (UIComponent component : children) {
            TogglePanelRenderer.setComponentVisibility(component, toggleMode);
        }
    }

    public static boolean hasStyleAttribute(UIComponent component) {
        Method[] methods = component.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals("getStyle")) continue;
            return true;
        }
        return false;
    }

    public static void setComponentVisibility(UIComponent component, boolean toggleMode) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!TogglePanelRenderer.hasStyleAttribute(component)) {
            log.info((Object)("style attribute expected, not found for component " + component.getClientId(context)));
            return;
        }
        try {
            boolean display;
            Class<?> c = component.getClass();
            Method getStyle = c.getMethod("getStyle", new Class[0]);
            Method setStyle = c.getMethod("setStyle", String.class);
            String style = (String)getStyle.invoke((Object)component, new Object[0]);
            boolean bl = display = toggleMode != TogglePanelRenderer.isHiddenWhenToggled(component);
            if (display) {
                if (style == null || style.length() == 0) {
                    return;
                }
                int index = style.indexOf(";display:none;");
                if (index == -1) {
                    return;
                }
                style = index == 0 ? null : style.substring(0, index);
            } else if (style == null) {
                style = ";display:none;";
            } else if (style.indexOf("display:none;") == -1) {
                style = style.concat(";display:none;");
            }
            setStyle.invoke((Object)component, style);
        }
        catch (Throwable e) {
            log.error((Object)("unable to set style attribute on component " + component.getClientId(context)));
        }
    }

    public static boolean isHiddenWhenToggled(UIComponent component) {
        return component instanceof ToggleLink || component instanceof ToggleGroup;
    }

    private String getHiddenFieldId(FacesContext context, TogglePanel togglePanel) {
        return togglePanel.getClientId(context) + "_hidden";
    }

    public static String getToggleJavascriptFunctionName(FacesContext context, TogglePanel togglePanel) {
        return "MyFacesToggleLinkUtils.toggle";
    }
}

