/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.toggle;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.toggle.ToggleLink;
import org.apache.myfaces.custom.toggle.TogglePanel;
import org.apache.myfaces.custom.toggle.TogglePanelRenderer;
import org.apache.myfaces.renderkit.html.ext.HtmlLinkRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class ToggleLinkRenderer
extends HtmlLinkRenderer {
    public static final int DEFAULT_MAX_SUGGESTED_ITEMS = 200;

    protected void renderOutputLinkStart(FacesContext facesContext, UIOutput output) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = output.getClientId(facesContext);
        ToggleLink toggleLink = (ToggleLink)output;
        writer.startElement("a", (UIComponent)output);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeURIAttribute("href", (Object)"javascript:void(0);", null);
        Map behaviors = toggleLink.getClientBehaviors();
        if (behaviors != null && !behaviors.isEmpty()) {
            HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, (UIComponent)output, behaviors);
            HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, (UIComponent)output, behaviors);
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_STYLE_AND_EVENTS);
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onclick", (UIComponent)output, "click", null, behaviors, "onclick", null, this.buildOnclickToggleFunction(facesContext, output));
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_ONCLICK_WITHOUT_STYLE);
            HtmlRendererUtils.renderHTMLAttribute(writer, "onclick", "onclick", (Object)this.buildOnclickToggleFunction(facesContext, output));
        }
        HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", output.getAttributes().get("style"));
        HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", output.getAttributes().get("styleClass"));
        writer.flush();
    }

    protected void renderOutputLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.writeText((Object)"", null);
        writer.endElement("a");
    }

    private String buildOnclickToggleFunction(FacesContext facesContext, UIOutput output) throws IOException {
        ToggleLink toggleLink = (ToggleLink)output;
        TogglePanel togglePanel = this.getParentTogglePanel(facesContext, toggleLink);
        String[] componentsToToggle = toggleLink.getFor().split(",");
        String idsToHide = this.getIdsToHide(facesContext, togglePanel);
        StringBuffer idsToShow = new StringBuffer();
        for (int i = 0; i < componentsToToggle.length; ++i) {
            String componentId = componentsToToggle[i].trim();
            UIComponent componentToShow = toggleLink.findComponent(componentId);
            if (componentToShow == null) {
                Log log = LogFactory.getLog(ToggleLinkRenderer.class);
                log.error((Object)("Unable to find component with id " + componentId));
                continue;
            }
            if (idsToShow.length() > 0) {
                idsToShow.append(',');
            }
            idsToShow.append(componentToShow.getClientId(facesContext));
        }
        String outputOnclick = toggleLink.getOnclick();
        StringBuffer onClick = new StringBuffer();
        if (outputOnclick != null) {
            onClick.append("var cf = function(){");
            onClick.append(outputOnclick);
            onClick.append('}');
            onClick.append(';');
            onClick.append("var oamSF = function(){");
        }
        String onClickFocusClientId = toggleLink.getOnClickFocusId() != null ? toggleLink.findComponent(toggleLink.getOnClickFocusId()).getClientId(facesContext) : "";
        onClick.append(this.getToggleJavascriptFunctionName(facesContext, toggleLink) + "('" + idsToShow + "','" + idsToHide + "','" + this.getHiddenFieldId(facesContext, togglePanel) + "','" + onClickFocusClientId + "');");
        if (outputOnclick != null) {
            onClick.append('}');
            onClick.append(';');
            onClick.append("return (cf()==false)? false : oamSF();");
        }
        return onClick.toString();
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(context, component, ToggleLink.class);
        ToggleLink toggleLink = (ToggleLink)component;
        if (this.isDisabled(context, toggleLink)) {
            return;
        }
        super.encodeEnd(context, component);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(context, component, ToggleLink.class);
        ToggleLink toggleLink = (ToggleLink)component;
        if (this.isDisabled(context, toggleLink)) {
            return;
        }
        super.encodeBegin(context, component);
    }

    private String getToggleJavascriptFunctionName(FacesContext context, ToggleLink toggleLink) {
        for (UIComponent component = toggleLink.getParent(); component != null; component = component.getParent()) {
            if (!(component instanceof TogglePanel)) continue;
            return TogglePanelRenderer.getToggleJavascriptFunctionName(context, (TogglePanel)component);
        }
        Log log = LogFactory.getLog(ToggleLinkRenderer.class);
        log.error((Object)("The ToggleLink component with id " + toggleLink.getClientId(context) + " isn't enclosed in a togglePanel."));
        return null;
    }

    private String getIdsToHide(FacesContext facesContext, TogglePanel togglePanel) {
        StringBuffer idsToHide = new StringBuffer();
        int idsToHideCount = 0;
        for (UIComponent component : togglePanel.getChildren()) {
            if (!TogglePanelRenderer.isHiddenWhenToggled(component)) continue;
            if (idsToHideCount > 0) {
                idsToHide.append(',');
            }
            idsToHide.append(component.getClientId(facesContext));
            ++idsToHideCount;
        }
        return idsToHide.toString();
    }

    private TogglePanel getParentTogglePanel(FacesContext facesContext, ToggleLink toggleLink) {
        for (UIComponent component = toggleLink.getParent(); component != null; component = component.getParent()) {
            if (!(component instanceof TogglePanel)) continue;
            return (TogglePanel)component;
        }
        return null;
    }

    private String getHiddenFieldId(FacesContext context, TogglePanel togglePanel) {
        return togglePanel.getClientId(context) + "_hidden";
    }

    private boolean isDisabled(FacesContext facesContext, ToggleLink link) {
        TogglePanel panel = this.getParentTogglePanel(facesContext, link);
        return panel.isDisabled() || link.isDisabled() || !UserRoleUtils.isEnabledOnUserRole((UIComponent)link);
    }
}

