/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datascroller;

import java.io.Serializable;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource2;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIPanel;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import org.apache.myfaces.component.DisplayValueOnlyAware;
import org.apache.myfaces.component.ForceIdAware;
import org.apache.myfaces.component.StyleAware;
import org.apache.myfaces.component.UniversalProperties;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.util.HtmlComponentUtils;
import org.apache.myfaces.custom.datascroller.ScrollerActionEvent;
import org.apache.myfaces.shared_tomahawk.component.DisplayValueOnlyCapable;

public abstract class AbstractHtmlDataScroller
extends UIPanel
implements ActionSource2,
ClientBehaviorHolder,
UserRoleAware,
DisplayValueOnlyCapable,
DisplayValueOnlyAware,
ForceIdAware,
UniversalProperties,
StyleAware {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlDataScroller";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.DataScroller";
    private static final boolean DEFAULT_IMMEDIATE = false;
    private static final Log log = LogFactory.getLog(AbstractHtmlDataScroller.class);
    private static final String FIRST_FACET_NAME = "first";
    private static final String LAST_FACET_NAME = "last";
    private static final String NEXT_FACET_NAME = "next";
    private static final String PREVIOUS_FACET_NAME = "previous";
    private static final String FAST_FORWARD_FACET_NAME = "fastforward";
    private static final String FAST_REWIND_FACET_NAME = "fastrewind";
    public static final String FACET_FIRST = "first".intern();
    public static final String FACET_PREVIOUS = "previous".intern();
    public static final String FACET_NEXT = "next".intern();
    public static final String FACET_LAST = "last".intern();
    public static final String FACET_FAST_FORWARD = "fastf".intern();
    public static final String FACET_FAST_REWIND = "fastr".intern();
    private static final String TABLE_LAYOUT = "table";
    private static final String LIST_LAYOUT = "list";
    private static final String SINGLE_LIST_LAYOUT = "singleList";
    private static final String SINGLE_TABLE_LAYOUT = "singleTable";
    private transient UIData _UIData;
    private MethodBinding _actionListener;

    public String getClientId(FacesContext context) {
        String clientId = HtmlComponentUtils.getClientId((UIComponent)this, this.getRenderer(context), context);
        if (clientId == null) {
            clientId = super.getClientId(context);
        }
        return clientId;
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public boolean isSetDisplayValueOnly() {
        return this.getDisplayValueOnly() != null;
    }

    public boolean isDisplayValueOnly() {
        return this.getDisplayValueOnly() != null ? this.getDisplayValueOnly() : false;
    }

    public void setDisplayValueOnly(boolean displayValueOnly) {
        this.setDisplayValueOnly(displayValueOnly);
    }

    public abstract String getLayout();

    public abstract int getColspan();

    public abstract String getOnclick();

    public abstract String getOndblclick();

    public boolean isListLayout() {
        Boolean _listLayout;
        String layout = this.getLayout();
        if (layout == null || layout.equals(TABLE_LAYOUT) || layout.equals(SINGLE_TABLE_LAYOUT)) {
            _listLayout = Boolean.FALSE;
        } else if (layout.equals(LIST_LAYOUT) || layout.equals(SINGLE_LIST_LAYOUT)) {
            _listLayout = Boolean.TRUE;
        } else {
            log.error((Object)("Invalid layout-parameter : " + layout + " provided. Defaulting to table-layout."));
            _listLayout = Boolean.FALSE;
        }
        return _listLayout;
    }

    public boolean isSingleElementLayout() {
        String layout = this.getLayout();
        Boolean _singleElementLayout = layout == null || layout.equals(SINGLE_LIST_LAYOUT) || layout.equals(SINGLE_TABLE_LAYOUT) ? Boolean.TRUE : Boolean.FALSE;
        return _singleElementLayout;
    }

    public void queueEvent(FacesEvent event) {
        if (event != null && event instanceof ActionEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ScrollerActionEvent) {
            ScrollerActionEvent scrollerEvent = (ScrollerActionEvent)event;
            this.broadcastToActionListener(scrollerEvent);
            UIData uiData = this.getUIData();
            if (uiData == null) {
                return;
            }
            int pageindex = scrollerEvent.getPageIndex();
            if (pageindex == -1) {
                String facet = scrollerEvent.getScrollerfacet();
                if (FACET_FIRST.equals(facet)) {
                    this.setFirst(uiData, 0);
                } else if (FACET_PREVIOUS.equals(facet)) {
                    int previous = uiData.getFirst() - uiData.getRows();
                    if (previous >= 0) {
                        this.setFirst(uiData, previous);
                    }
                } else if (FACET_NEXT.equals(facet)) {
                    int next = uiData.getFirst() + uiData.getRows();
                    if (next < uiData.getRowCount()) {
                        this.setFirst(uiData, next);
                    }
                } else if (FACET_FAST_FORWARD.equals(facet)) {
                    int rowcount;
                    int next;
                    int fastStep = this.getFastStep();
                    if (fastStep <= 0) {
                        fastStep = 1;
                    }
                    if ((next = uiData.getFirst() + uiData.getRows() * fastStep) >= (rowcount = uiData.getRowCount())) {
                        next = rowcount - 1 - (rowcount - 1) % uiData.getRows();
                    }
                    this.setFirst(uiData, next);
                } else if (FACET_FAST_REWIND.equals(facet)) {
                    int previous;
                    int fastStep = this.getFastStep();
                    if (fastStep <= 0) {
                        fastStep = 1;
                    }
                    if ((previous = uiData.getFirst() - uiData.getRows() * fastStep) < 0) {
                        previous = 0;
                    }
                    this.setFirst(uiData, previous);
                } else if (FACET_LAST.equals(facet)) {
                    int first;
                    int rowcount = uiData.getRowCount();
                    int rows = uiData.getRows();
                    int delta = rows != 0 ? rowcount % rows : 0;
                    int n = first = delta > 0 && delta < rows ? rowcount - delta : rowcount - rows;
                    if (first >= 0) {
                        this.setFirst(uiData, first);
                    } else {
                        this.setFirst(uiData, 0);
                    }
                }
            } else {
                int pageCount = this.getPageCount();
                if (pageindex > pageCount) {
                    pageindex = pageCount;
                }
                if (pageindex <= 0) {
                    pageindex = 1;
                }
                this.setFirst(uiData, uiData.getRows() * (pageindex - 1));
            }
        }
    }

    protected void setFirst(UIData uiData, int value) {
        if (uiData.getValueBinding(FIRST_FACET_NAME) != null) {
            ValueBinding vb = uiData.getValueBinding(FIRST_FACET_NAME);
            vb.setValue(this.getFacesContext(), (Object)new Integer(value));
        } else {
            uiData.setFirst(value);
        }
    }

    protected void broadcastToActionListener(ScrollerActionEvent event) {
        ActionListener defaultActionListener;
        FacesContext context = this.getFacesContext();
        MethodBinding actionListenerBinding = this.getActionListener();
        if (actionListenerBinding != null) {
            try {
                actionListenerBinding.invoke(context, new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
        if ((defaultActionListener = context.getApplication().getActionListener()) != null) {
            defaultActionListener.processAction((ActionEvent)event);
        }
    }

    public UIData getUIData() {
        if (this._UIData == null) {
            this._UIData = this.findUIData();
        }
        return this._UIData;
    }

    public int getPageIndex() {
        int pageIndex;
        UIData uiData = this.getUIData();
        int rows = uiData.getRows();
        if (0 == rows) {
            throw new FacesException("You need to set a value to the 'rows' attribute of component '" + uiData.getClientId(this.getFacesContext()) + "'");
        }
        if (rows > 0) {
            pageIndex = uiData.getFirst() / rows + 1;
        } else {
            log.warn((Object)("DataTable " + uiData.getClientId(FacesContext.getCurrentInstance()) + " has invalid rows attribute."));
            pageIndex = 0;
        }
        if (uiData.getFirst() % rows > 0) {
            ++pageIndex;
        }
        return pageIndex;
    }

    public int getPageCount() {
        int pageCount;
        UIData uiData = this.getUIData();
        int rows = uiData.getRows();
        if (rows > 0) {
            int n = pageCount = rows <= 0 ? 1 : uiData.getRowCount() / rows;
            if (uiData.getRowCount() % rows > 0) {
                ++pageCount;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    public int getRowCount() {
        return this.getUIData().getRowCount();
    }

    public int getRows() {
        return this.getUIData().getRows();
    }

    public int getFirstRow() {
        return this.getUIData().getFirst();
    }

    protected UIData findUIData() {
        String forStr = this.getFor();
        UIComponent forComp = forStr == null ? this.getParent() : this.findComponent(forStr);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find UIData referenced by attribute dataScroller@for = '" + forStr + "'");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("uiComponent referenced by attribute dataScroller@for = '" + forStr + "' must be of type " + UIData.class.getName() + ", not type " + forComp.getClass().getName());
        }
        return (UIData)forComp;
    }

    public void setFirst(UIComponent first) {
        this.getFacets().put(FIRST_FACET_NAME, first);
    }

    public UIComponent getFirst() {
        return (UIComponent)this.getFacets().get(FIRST_FACET_NAME);
    }

    public void setLast(UIComponent last) {
        this.getFacets().put(LAST_FACET_NAME, last);
    }

    public UIComponent getLast() {
        return (UIComponent)this.getFacets().get(LAST_FACET_NAME);
    }

    public void setNext(UIComponent next) {
        this.getFacets().put(NEXT_FACET_NAME, next);
    }

    public UIComponent getNext() {
        return (UIComponent)this.getFacets().get(NEXT_FACET_NAME);
    }

    public void setFastForward(UIComponent previous) {
        this.getFacets().put(FAST_FORWARD_FACET_NAME, previous);
    }

    public UIComponent getFastForward() {
        return (UIComponent)this.getFacets().get(FAST_FORWARD_FACET_NAME);
    }

    public void setFastRewind(UIComponent previous) {
        this.getFacets().put(FAST_REWIND_FACET_NAME, previous);
    }

    public UIComponent getFastRewind() {
        return (UIComponent)this.getFacets().get(FAST_REWIND_FACET_NAME);
    }

    public void setPrevious(UIComponent previous) {
        this.getFacets().put(PREVIOUS_FACET_NAME, previous);
    }

    public UIComponent getPrevious() {
        return (UIComponent)this.getFacets().get(PREVIOUS_FACET_NAME);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public MethodBinding getAction() {
        return null;
    }

    public void setAction(MethodBinding action) {
        throw new UnsupportedOperationException("defining an action is not supported. use an actionlistener");
    }

    public MethodExpression getActionExpression() {
        return null;
    }

    public void setActionExpression(MethodExpression action) {
        throw new UnsupportedOperationException("defining an action is not supported. use an actionlistener");
    }

    public void setActionListener(MethodBinding actionListener) {
        this._actionListener = actionListener;
        if (this.initialStateMarked()) {
            this.getStateHelper().put((Serializable)((Object)PropertyKeys.actionListenerSet), (Object)Boolean.TRUE);
        }
    }

    private boolean _isSetActionListener() {
        Boolean value = (Boolean)this.getStateHelper().get((Serializable)((Object)PropertyKeys.actionListenerSet));
        return value == null ? false : value;
    }

    public MethodBinding getActionListener() {
        if (this._actionListener != null) {
            return this._actionListener;
        }
        ValueExpression expression = this.getValueExpression("actionListener");
        if (expression != null) {
            return (MethodBinding)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public Object saveState(FacesContext facesContext) {
        if (this.initialStateMarked()) {
            boolean nullDelta = true;
            Object parentSaved = super.saveState(facesContext);
            Object actionListenerSaved = null;
            if (!this._isSetActionListener() && this._actionListener != null && this._actionListener instanceof PartialStateHolder) {
                StateHolder holder = (StateHolder)this._actionListener;
                if (!holder.isTransient()) {
                    Object attachedState = holder.saveState(facesContext);
                    if (attachedState != null) {
                        nullDelta = false;
                    }
                    actionListenerSaved = new AttachedDeltaWrapper(this._actionListener.getClass(), attachedState);
                }
            } else if (this._isSetActionListener() || this._actionListener != null) {
                actionListenerSaved = AbstractHtmlDataScroller.saveAttachedState((FacesContext)facesContext, (Object)this._actionListener);
                nullDelta = false;
            }
            if (parentSaved == null && nullDelta) {
                return null;
            }
            Object[] values = new Object[]{parentSaved, actionListenerSaved};
            return values;
        }
        Object[] values = new Object[]{super.saveState(facesContext), AbstractHtmlDataScroller.saveAttachedState((FacesContext)facesContext, (Object)this._actionListener)};
        return values;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(facesContext, values[0]);
        if (values[1] instanceof AttachedDeltaWrapper) {
            ((StateHolder)this._actionListener).restoreState(facesContext, ((AttachedDeltaWrapper)values[1]).getWrappedStateObject());
        } else {
            this._actionListener = (MethodBinding)AbstractHtmlDataScroller.restoreAttachedState((FacesContext)facesContext, (Object)values[1]);
        }
    }

    public abstract String getFor();

    public abstract int getFastStep();

    public abstract String getPageIndexVar();

    public abstract String getPageCountVar();

    public abstract String getRowsCountVar();

    public abstract String getDisplayedRowsCountVar();

    public abstract String getFirstRowIndexVar();

    public abstract String getLastRowIndexVar();

    public abstract boolean isPaginator();

    public abstract int getPaginatorMaxPages();

    public abstract String getPaginatorTableClass();

    public abstract String getPaginatorTableStyle();

    public abstract String getPaginatorColumnClass();

    public abstract String getPaginatorColumnStyle();

    public abstract String getPaginatorActiveColumnClass();

    public abstract boolean isPaginatorRenderLinkForActive();

    public abstract String getFirstStyleClass();

    public abstract String getLastStyleClass();

    public abstract String getPreviousStyleClass();

    public abstract String getNextStyleClass();

    public abstract String getFastfStyleClass();

    public abstract String getFastrStyleClass();

    public abstract String getPaginatorActiveColumnStyle();

    public abstract boolean isRenderFacetsIfSinglePage();

    public abstract boolean isImmediate();

    public abstract boolean isDisableFacetLinksIfFirstPage();

    public abstract boolean isDisableFacetLinksIfLastPage();

    public abstract boolean isRenderFacetLinksIfFirstPage();

    public abstract boolean isRenderFacetLinksIfLastPage();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        actionListenerSet;

    }
}

