/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIFlexLayout;
import org.apache.myfaces.tobago.internal.component.AbstractUISplitLayout;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitLayoutRenderer<T extends AbstractUISplitLayout>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SUFFIX_SIZES = "::sizes";

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.source");
        String clientId = component.getClientId() + SUFFIX_SIZES;
        if (clientId.equals(sourceId)) {
            LOG.warn("todo update layout");
        }
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup();
        writer.startElement(HtmlElements.TOBAGO_SPLIT_LAYOUT);
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeClassAttribute(((AbstractUIFlexLayout)component).isHorizontal() ? BootstrapClass.FLEX_ROW : BootstrapClass.FLEX_COLUMN, markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        writer.writeAttribute(CustomAttributes.ORIENTATION, ((AbstractUIFlexLayout)component).isHorizontal() ? "horizontal" : "vertical", false);
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.INPUT);
        writer.writeNameAttribute(component.getClientId(facesContext) + SUFFIX_SIZES);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.endElement(HtmlElements.INPUT);
        writer.endElement(HtmlElements.TOBAGO_SPLIT_LAYOUT);
    }
}

