/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.el.ValueExpression;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.Behavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.render.ClientBehaviorRenderer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.component.SupportFieldId;
import org.apache.myfaces.tobago.internal.behavior.EventBehavior;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUIEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUIOperation;
import org.apache.myfaces.tobago.internal.renderkit.Collapse;
import org.apache.myfaces.tobago.internal.renderkit.Command;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoClientBehaviorRenderer
extends ClientBehaviorRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        FacesContext facesContext = behaviorContext.getFacesContext();
        UIComponent uiComponent = behaviorContext.getComponent();
        ClientBehaviors eventName = ClientBehaviors.getEnum(behaviorContext.getEventName());
        Collapse collapse = TobagoClientBehaviorRenderer.createCollapsible(facesContext, uiComponent);
        String executeIds = null;
        String renderIds = null;
        Boolean transition = null;
        String target = null;
        String clientId = null;
        String fieldId = null;
        boolean omit = false;
        boolean resetValues = false;
        String confirmation = ComponentUtils.getConfirmation(uiComponent);
        if (behavior instanceof AjaxBehavior) {
            AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
            if (ajaxBehavior.isDisabled()) {
                return null;
            }
            resetValues = ajaxBehavior.isResetValues();
            Collection execute = ajaxBehavior.getExecute();
            Collection render = ajaxBehavior.getRender();
            clientId = uiComponent.getClientId(facesContext);
            if (uiComponent instanceof SupportFieldId) {
                fieldId = ((SupportFieldId)uiComponent).getFieldId(facesContext);
            }
            executeIds = (executeIds = ComponentUtils.evaluateClientIds(facesContext, uiComponent, execute.toArray(new String[0]))) != null ? executeIds + " " + clientId : clientId;
            if (uiComponent instanceof AbstractUICommand) {
                AbstractUICommand command = (AbstractUICommand)uiComponent;
                transition = command.isTransition();
                target = command.getTarget();
                omit = command.isOmit() || StringUtils.isNotBlank(RenderUtils.generateUrl(facesContext, command));
            }
            renderIds = ComponentUtils.evaluateClientIds(facesContext, uiComponent, render.toArray(new String[0]));
        } else if (behavior instanceof EventBehavior) {
            EventBehavior eventBehavior = (EventBehavior)behavior;
            AbstractUIEvent event = RenderUtils.getAbstractUIEvent(uiComponent, eventBehavior);
            if (event != null) {
                if (!event.isRendered() || event.isDisabled()) {
                    return null;
                }
                transition = event.isTransition();
                target = event.getTarget();
                clientId = event.getClientId(facesContext);
                if (collapse == null) {
                    collapse = TobagoClientBehaviorRenderer.createCollapsible(facesContext, (UIComponent)event);
                }
                omit = event.isOmit() || StringUtils.isNotBlank(RenderUtils.generateUrl(facesContext, event));
            }
        } else {
            LOG.warn("Unknown behavior '{}'!", (Object)behavior.getClass().getName());
        }
        Command command = new Command(clientId, fieldId, transition, target, executeIds, renderIds, confirmation, null, collapse, omit);
        if (resetValues) {
            command.setResetValues(true);
        }
        CommandMap map = new CommandMap();
        map.addCommand(eventName, command);
        CommandMap.storeCommandMap(facesContext, map);
        return "dummy";
    }

    public void decode(FacesContext facesContext, UIComponent component, ClientBehavior clientBehavior) {
        if (clientBehavior instanceof AjaxBehavior) {
            AjaxBehavior ajaxBehavior = (AjaxBehavior)clientBehavior;
            if (!component.isRendered() || ajaxBehavior.isDisabled()) {
                return;
            }
            this.dispatchBehaviorEvent(component, (ClientBehavior)ajaxBehavior);
        } else if (clientBehavior instanceof EventBehavior) {
            EventBehavior eventBehavior = (EventBehavior)clientBehavior;
            AbstractUIEvent abstractUIEvent = RenderUtils.getAbstractUIEvent(component, eventBehavior);
            if (!component.isRendered() || abstractUIEvent == null || !abstractUIEvent.isRendered() || abstractUIEvent.isDisabled()) {
                return;
            }
            for (List children : abstractUIEvent.getClientBehaviors().values()) {
                for (ClientBehavior child : children) {
                    this.decode(facesContext, component, child);
                }
            }
            this.dispatchBehaviorEvent(component, (ClientBehavior)eventBehavior);
        }
    }

    private void dispatchBehaviorEvent(UIComponent component, ClientBehavior clientBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, (Behavior)clientBehavior);
        boolean isImmediate = this.isImmediate(clientBehavior, component);
        event.setPhaseId(isImmediate ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION);
        component.queueEvent((FacesEvent)event);
    }

    private boolean isImmediate(ClientBehavior clientBehavior, UIComponent component) {
        EventBehavior eventBehavior;
        if (clientBehavior instanceof AjaxBehavior) {
            AjaxBehavior ajaxBehavior = (AjaxBehavior)clientBehavior;
            if (ajaxBehavior.isImmediateSet()) {
                return ajaxBehavior.isImmediate();
            }
        } else if (clientBehavior instanceof EventBehavior && (eventBehavior = (EventBehavior)clientBehavior).isImmediateSet()) {
            return eventBehavior.isImmediate();
        }
        if (component instanceof EditableValueHolder) {
            return ((EditableValueHolder)component).isImmediate();
        }
        if (component instanceof ActionSource) {
            return ((ActionSource)component).isImmediate();
        }
        return false;
    }

    @Deprecated
    public static Collapse createCollapsible(FacesContext facesContext, UIComponent component) {
        ArrayList<AbstractUIOperation> operations = new ArrayList<AbstractUIOperation>();
        for (UIComponent child : component.getChildren()) {
            if (!AbstractUIOperation.class.isAssignableFrom(child.getClass())) continue;
            operations.add((AbstractUIOperation)child);
        }
        Collapse collapse = null;
        if (operations.size() > 0) {
            AbstractUIOperation operation = (AbstractUIOperation)((Object)operations.get(0));
            ValueExpression valueExpression = operation.getValueExpression("for");
            String value = valueExpression != null ? (String)valueExpression.getValue(facesContext.getELContext()) : operation.getFor();
            String forId = ComponentUtils.evaluateClientId(facesContext, component, value);
            collapse = new Collapse(Collapse.Operation.valueOf(operation.getName()), forId);
        }
        return collapse;
    }
}

